# htmlchars.st - string table data for HTML5 named characters
#
# Copyright (c) 1994-2012 Carnegie Mellon University.  All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
#
# 1. Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
#
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in
#    the documentation and/or other materials provided with the
#    distribution.
#
# 3. The name "Carnegie Mellon University" must not be used to
#    endorse or promote products derived from this software without
#    prior written permission. For permission or any legal
#    details, please contact
#      Carnegie Mellon University
#      Center for Technology Transfer and Enterprise Creation
#      4615 Forbes Avenue
#      Suite 302
#      Pittsburgh, PA  15213
#      (412) 268-7393, fax: (412) 268-7395
#      innovation@andrew.cmu.edu
#
# 4. Redistributions of any form whatsoever must retain the following
#    acknowledgment:
#    "This product includes software developed by Computing Services
#     at Carnegie Mellon University (http://www.cmu.edu/computing/)."
#
# CARNEGIE MELLON UNIVERSITY DISCLAIMS ALL WARRANTIES WITH REGARD TO
# THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
# AND FITNESS, IN NO EVENT SHALL CARNEGIE MELLON UNIVERSITY BE LIABLE
# FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
# WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
# AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING
# OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
#

#  Derived from
#  http://dev.w3.org/html5/spec/named-character-references.html#named-character-references

table htmlchar
ent 0x00C1 "Aacute"
ent 0x00E1 "aacute"
ent 0x0102 "Abreve"
ent 0x0103 "abreve"
ent 0x223F "acd"
ent 0x223E0333 "acE"
ent 0x00C2 "Acirc"
ent 0x00E2 "acirc"
ent 0x223E "ac"
ent 0x00B4 "acute"
ent 0x0410 "Acy"
ent 0x0430 "acy"
ent 0x00C6 "AElig"
ent 0x00E6 "aelig"
ent 0xD504 "Afr"
ent 0xD51E "afr"
ent 0x2061 "af"
ent 0x00C0 "Agrave"
ent 0x00E0 "agrave"
ent 0x2135 "alefsym"
ent 0x2135 "aleph"
ent 0x0391 "Alpha"
ent 0x03B1 "alpha"
ent 0x0100 "Amacr"
ent 0x0101 "amacr"
ent 0x2A3F "amalg"
ent 0x0026 "amp"
ent 0x0026 "AMP"
ent 0x2A55 "andand"
ent 0x2A5C "andd"
ent 0x2A58 "andslope"
ent 0x2227 "and"
ent 0x2A53 "And"
ent 0x2A5A "andv"
ent 0x29A4 "ange"
ent 0x2220 "angle"
ent 0x29A8 "angmsdaa"
ent 0x29A9 "angmsdab"
ent 0x29AA "angmsdac"
ent 0x29AB "angmsdad"
ent 0x29AC "angmsdae"
ent 0x29AD "angmsdaf"
ent 0x29AE "angmsdag"
ent 0x29AF "angmsdah"
ent 0x2221 "angmsd"
ent 0x221F "angrt"
ent 0x299D "angrtvbd"
ent 0x22BE "angrtvb"
ent 0x2222 "angsph"
ent 0x00C5 "angst"
ent 0x2220 "ang"
ent 0x237C "angzarr"
ent 0x0104 "Aogon"
ent 0x0105 "aogon"
ent 0xD538 "Aopf"
ent 0xD552 "aopf"
ent 0x2A6F "apacir"
ent 0x224A "ape"
ent 0x2A70 "apE"
ent 0x224B "apid"
ent 0x0027 "apos"
ent 0x2061 "ApplyFunction"
ent 0x224A "approxeq"
ent 0x2248 "approx"
ent 0x2248 "ap"
ent 0x00C5 "Aring"
ent 0x00E5 "aring"
ent 0xD49C "Ascr"
ent 0xD4B6 "ascr"
ent 0x2254 "Assign"
ent 0x002A "ast"
ent 0x224D "asympeq"
ent 0x2248 "asymp"
ent 0x00C3 "Atilde"
ent 0x00E3 "atilde"
ent 0x00C4 "Auml"
ent 0x00E4 "auml"
ent 0x2233 "awconint"
ent 0x2A11 "awint"
ent 0x224C "backcong"
ent 0x03F6 "backepsilon"
ent 0x2035 "backprime"
ent 0x22CD "backsimeq"
ent 0x223D "backsim"
ent 0x2216 "Backslash"
ent 0x22BD "barvee"
ent 0x2AE7 "Barv"
ent 0x2305 "barwedge"
ent 0x2305 "barwed"
ent 0x2306 "Barwed"
ent 0x23B6 "bbrktbrk"
ent 0x23B5 "bbrk"
ent 0x224C "bcong"
ent 0x0411 "Bcy"
ent 0x0431 "bcy"
ent 0x201E "bdquo"
ent 0x2235 "because"
ent 0x2235 "Because"
ent 0x2235 "becaus"
ent 0x29B0 "bemptyv"
ent 0x03F6 "bepsi"
ent 0x212C "Bernoullis"
ent 0x212C "bernou"
ent 0x0392 "Beta"
ent 0x03B2 "beta"
ent 0x2136 "beth"
ent 0x226C "between"
ent 0xD505 "Bfr"
ent 0xD51F "bfr"
ent 0x22C2 "bigcap"
ent 0x25EF "bigcirc"
ent 0x22C3 "bigcup"
ent 0x2A00 "bigodot"
ent 0x2A01 "bigoplus"
ent 0x2A02 "bigotimes"
ent 0x2A06 "bigsqcup"
ent 0x2605 "bigstar"
ent 0x25BD "bigtriangledown"
ent 0x25B3 "bigtriangleup"
ent 0x2A04 "biguplus"
ent 0x22C1 "bigvee"
ent 0x22C0 "bigwedge"
ent 0x290D "bkarow"
ent 0x29EB "blacklozenge"
ent 0x25AA "blacksquare"
ent 0x25BE "blacktriangledown"
ent 0x25C2 "blacktriangleleft"
ent 0x25B8 "blacktriangleright"
ent 0x25B4 "blacktriangle"
ent 0x2423 "blank"
ent 0x2592 "blk12"
ent 0x2591 "blk14"
ent 0x2593 "blk34"
ent 0x2588 "block"
ent 0x226120E5 "bnequiv"
ent 0x003D20E5 "bne"
ent 0x2310 "bnot"
ent 0x2AED "bNot"
ent 0xD539 "Bopf"
ent 0xD553 "bopf"
ent 0x22A5 "bottom"
ent 0x22A5 "bot"
ent 0x22C8 "bowtie"
ent 0x29C9 "boxbox"
ent 0x2510 "boxdl"
ent 0x2555 "boxdL"
ent 0x2556 "boxDl"
ent 0x2557 "boxDL"
ent 0x250C "boxdr"
ent 0x2552 "boxdR"
ent 0x2553 "boxDr"
ent 0x2554 "boxDR"
ent 0x252C "boxhd"
ent 0x2564 "boxHd"
ent 0x2565 "boxhD"
ent 0x2566 "boxHD"
ent 0x2500 "boxh"
ent 0x2550 "boxH"
ent 0x2534 "boxhu"
ent 0x2567 "boxHu"
ent 0x2568 "boxhU"
ent 0x2569 "boxHU"
ent 0x229F "boxminus"
ent 0x229E "boxplus"
ent 0x22A0 "boxtimes"
ent 0x2518 "boxul"
ent 0x255B "boxuL"
ent 0x255C "boxUl"
ent 0x255D "boxUL"
ent 0x2514 "boxur"
ent 0x2558 "boxuR"
ent 0x2559 "boxUr"
ent 0x255A "boxUR"
ent 0x253C "boxvh"
ent 0x256A "boxvH"
ent 0x256B "boxVh"
ent 0x256C "boxVH"
ent 0x2524 "boxvl"
ent 0x2561 "boxvL"
ent 0x2562 "boxVl"
ent 0x2563 "boxVL"
ent 0x251C "boxvr"
ent 0x255E "boxvR"
ent 0x255F "boxVr"
ent 0x2560 "boxVR"
ent 0x2502 "boxv"
ent 0x2551 "boxV"
ent 0x2035 "bprime"
ent 0x02D8 "breve"
ent 0x02D8 "Breve"
ent 0x00A6 "brvbar"
ent 0x212C "Bscr"
ent 0xD4B7 "bscr"
ent 0x204F "bsemi"
ent 0x22CD "bsime"
ent 0x223D "bsim"
ent 0x29C5 "bsolb"
ent 0x27C8 "bsolhsub"
ent 0x005C "bsol"
ent 0x2022 "bullet"
ent 0x2022 "bull"
ent 0x224E "Bumpeq"
ent 0x224F "bumpeq"
ent 0x224F "bumpe"
ent 0x2AAE "bumpE"
ent 0x224E "bump"
ent 0x0106 "Cacute"
ent 0x0107 "cacute"
ent 0x2A44 "capand"
ent 0x2A49 "capbrcup"
ent 0x2A4B "capcap"
ent 0x2A47 "capcup"
ent 0x2A40 "capdot"
ent 0x2145 "CapitalDifferentialD"
ent 0x2229FE00 "caps"
ent 0x2229 "cap"
ent 0x22D2 "Cap"
ent 0x2041 "caret"
ent 0x02C7 "caron"
ent 0x212D "Cayleys"
ent 0x2A4D "ccaps"
ent 0x010C "Ccaron"
ent 0x010D "ccaron"
ent 0x00C7 "Ccedil"
ent 0x00E7 "ccedil"
ent 0x0108 "Ccirc"
ent 0x0109 "ccirc"
ent 0x2230 "Cconint"
ent 0x2A50 "ccupssm"
ent 0x2A4C "ccups"
ent 0x010A "Cdot"
ent 0x010B "cdot"
ent 0x00B8 "Cedilla"
ent 0x00B8 "cedil"
ent 0x29B2 "cemptyv"
ent 0x00B7 "centerdot"
ent 0x00B7 "CenterDot"
ent 0x00A2 "cent"
ent 0x212D "Cfr"
ent 0xD520 "cfr"
ent 0x0427 "CHcy"
ent 0x0447 "chcy"
ent 0x2713 "checkmark"
ent 0x2713 "check"
ent 0x03A7 "Chi"
ent 0x03C7 "chi"
ent 0x2257 "circeq"
ent 0x21BA "circlearrowleft"
ent 0x21BB "circlearrowright"
ent 0x229B "circledast"
ent 0x229A "circledcirc"
ent 0x229D "circleddash"
ent 0x2299 "CircleDot"
ent 0x00AE "circledR"
ent 0x24C8 "circledS"
ent 0x2296 "CircleMinus"
ent 0x2295 "CirclePlus"
ent 0x2297 "CircleTimes"
ent 0x02C6 "circ"
ent 0x2257 "cire"
ent 0x29C3 "cirE"
ent 0x2A10 "cirfnint"
ent 0x2AEF "cirmid"
ent 0x29C2 "cirscir"
ent 0x25CB "cir"
ent 0x2232 "ClockwiseContourIntegral"
ent 0x201D "CloseCurlyDoubleQuote"
ent 0x2019 "CloseCurlyQuote"
ent 0x2663 "clubs"
ent 0x2663 "clubsuit"
ent 0x2254 "coloneq"
ent 0x2254 "colone"
ent 0x2A74 "Colone"
ent 0x003A "colon"
ent 0x2237 "Colon"
ent 0x0040 "commat"
ent 0x002C "comma"
ent 0x2218 "compfn"
ent 0x2201 "complement"
ent 0x2102 "complexes"
ent 0x2201 "comp"
ent 0x2A6D "congdot"
ent 0x2261 "Congruent"
ent 0x2245 "cong"
ent 0x222E "conint"
ent 0x222F "Conint"
ent 0x222E "ContourIntegral"
ent 0x2102 "Copf"
ent 0xD554 "copf"
ent 0x2210 "coprod"
ent 0x2210 "Coproduct"
ent 0x2117 "copysr"
ent 0x00A9 "copy"
ent 0x00A9 "COPY"
ent 0x2233 "CounterClockwiseContourIntegral"
ent 0x21B5 "crarr"
ent 0x2717 "cross"
ent 0x2A2F "Cross"
ent 0xD49E "Cscr"
ent 0xD4B8 "cscr"
ent 0x2AD1 "csube"
ent 0x2ACF "csub"
ent 0x2AD2 "csupe"
ent 0x2AD0 "csup"
ent 0x22EF "ctdot"
ent 0x2938 "cudarrl"
ent 0x2935 "cudarrr"
ent 0x22DE "cuepr"
ent 0x22DF "cuesc"
ent 0x293D "cularrp"
ent 0x21B6 "cularr"
ent 0x2A48 "cupbrcap"
ent 0x224D "CupCap"
ent 0x2A46 "cupcap"
ent 0x2A4A "cupcup"
ent 0x228D "cupdot"
ent 0x2A45 "cupor"
ent 0x222AFE00 "cups"
ent 0x222A "cup"
ent 0x22D3 "Cup"
ent 0x293C "curarrm"
ent 0x21B7 "curarr"
ent 0x22DE "curlyeqprec"
ent 0x22DF "curlyeqsucc"
ent 0x22CE "curlyvee"
ent 0x22CF "curlywedge"
ent 0x00A4 "curren"
ent 0x21B6 "curvearrowleft"
ent 0x21B7 "curvearrowright"
ent 0x22CE "cuvee"
ent 0x22CF "cuwed"
ent 0x2232 "cwconint"
ent 0x2231 "cwint"
ent 0x232D "cylcty"
ent 0x2020 "dagger"
ent 0x2021 "Dagger"
ent 0x2138 "daleth"
ent 0x2193 "darr"
ent 0x21A1 "Darr"
ent 0x21D3 "dArr"
ent 0x2010 "dash"
ent 0x22A3 "dashv"
ent 0x2AE4 "Dashv"
ent 0x290F "dbkarow"
ent 0x02DD "dblac"
ent 0x010E "Dcaron"
ent 0x010F "dcaron"
ent 0x0414 "Dcy"
ent 0x0434 "dcy"
ent 0x2021 "ddagger"
ent 0x21CA "ddarr"
ent 0x2911 "DDotrahd"
ent 0x2A77 "ddotseq"
ent 0x2145 "DD"
ent 0x2146 "dd"
ent 0x00B0 "deg"
ent 0x0394 "Delta"
ent 0x03B4 "delta"
ent 0x2207 "Del"
ent 0x29B1 "demptyv"
ent 0x297F "dfisht"
ent 0xD507 "Dfr"
ent 0xD521 "dfr"
ent 0x21C3 "dharl"
ent 0x21C2 "dharr"
ent 0x2965 "dHar"
ent 0x00B4 "DiacriticalAcute"
ent 0x02D9 "DiacriticalDot"
ent 0x02DD "DiacriticalDoubleAcute"
ent 0x0060 "DiacriticalGrave"
ent 0x02DC "DiacriticalTilde"
ent 0x2666 "diamondsuit"
ent 0x22C4 "diamond"
ent 0x22C4 "Diamond"
ent 0x2666 "diams"
ent 0x22C4 "diam"
ent 0x00A8 "die"
ent 0x2146 "DifferentialD"
ent 0x03DD "digamma"
ent 0x22F2 "disin"
ent 0x22C7 "divideontimes"
ent 0x00F7 "divide"
ent 0x22C7 "divonx"
ent 0x00F7 "div"
ent 0x0402 "DJcy"
ent 0x0452 "djcy"
ent 0x231E "dlcorn"
ent 0x230D "dlcrop"
ent 0x0024 "dollar"
ent 0xD53B "Dopf"
ent 0xD555 "dopf"
ent 0x20DC "DotDot"
ent 0x2251 "doteqdot"
ent 0x2250 "doteq"
ent 0x2250 "DotEqual"
ent 0x2238 "dotminus"
ent 0x2214 "dotplus"
ent 0x22A1 "dotsquare"
ent 0x00A8 "Dot"
ent 0x02D9 "dot"
ent 0x2306 "doublebarwedge"
ent 0x222F "DoubleContourIntegral"
ent 0x00A8 "DoubleDot"
ent 0x21D3 "DoubleDownArrow"
ent 0x21D0 "DoubleLeftArrow"
ent 0x21D4 "DoubleLeftRightArrow"
ent 0x2AE4 "DoubleLeftTee"
ent 0x27F8 "DoubleLongLeftArrow"
ent 0x27FA "DoubleLongLeftRightArrow"
ent 0x27F9 "DoubleLongRightArrow"
ent 0x21D2 "DoubleRightArrow"
ent 0x22A8 "DoubleRightTee"
ent 0x21D1 "DoubleUpArrow"
ent 0x21D5 "DoubleUpDownArrow"
ent 0x2225 "DoubleVerticalBar"
ent 0x2913 "DownArrowBar"
ent 0x2193 "downarrow"
ent 0x2193 "DownArrow"
ent 0x21D3 "Downarrow"
ent 0x21F5 "DownArrowUpArrow"
ent 0x0311 "DownBreve"
ent 0x21CA "downdownarrows"
ent 0x21C3 "downharpoonleft"
ent 0x21C2 "downharpoonright"
ent 0x2950 "DownLeftRightVector"
ent 0x295E "DownLeftTeeVector"
ent 0x2956 "DownLeftVectorBar"
ent 0x21BD "DownLeftVector"
ent 0x295F "DownRightTeeVector"
ent 0x2957 "DownRightVectorBar"
ent 0x21C1 "DownRightVector"
ent 0x21A7 "DownTeeArrow"
ent 0x22A4 "DownTee"
ent 0x2910 "drbkarow"
ent 0x231F "drcorn"
ent 0x230C "drcrop"
ent 0xD49F "Dscr"
ent 0xD4B9 "dscr"
ent 0x0405 "DScy"
ent 0x0455 "dscy"
ent 0x29F6 "dsol"
ent 0x0110 "Dstrok"
ent 0x0111 "dstrok"
ent 0x22F1 "dtdot"
ent 0x25BE "dtrif"
ent 0x25BF "dtri"
ent 0x21F5 "duarr"
ent 0x296F "duhar"
ent 0x29A6 "dwangle"
ent 0x040F "DZcy"
ent 0x045F "dzcy"
ent 0x27FF "dzigrarr"
ent 0x00C9 "Eacute"
ent 0x00E9 "eacute"
ent 0x2A6E "easter"
ent 0x011A "Ecaron"
ent 0x011B "ecaron"
ent 0x00CA "Ecirc"
ent 0x00EA "ecirc"
ent 0x2256 "ecir"
ent 0x2255 "ecolon"
ent 0x042D "Ecy"
ent 0x044D "ecy"
ent 0x2A77 "eDDot"
ent 0x0116 "Edot"
ent 0x0117 "edot"
ent 0x2251 "eDot"
ent 0x2147 "ee"
ent 0x2252 "efDot"
ent 0xD508 "Efr"
ent 0xD522 "efr"
ent 0x00C8 "Egrave"
ent 0x00E8 "egrave"
ent 0x2A98 "egsdot"
ent 0x2A96 "egs"
ent 0x2A9A "eg"
ent 0x2208 "Element"
ent 0x23E7 "elinters"
ent 0x2113 "ell"
ent 0x2A97 "elsdot"
ent 0x2A95 "els"
ent 0x2A99 "el"
ent 0x0112 "Emacr"
ent 0x0113 "emacr"
ent 0x2205 "emptyset"
ent 0x25FB "EmptySmallSquare"
ent 0x2205 "empty"
ent 0x25AB "EmptyVerySmallSquare"
ent 0x2205 "emptyv"
ent 0x2004 "emsp13"
ent 0x2005 "emsp14"
ent 0x2003 "emsp"
ent 0x014A "ENG"
ent 0x014B "eng"
ent 0x2002 "ensp"
ent 0x0118 "Eogon"
ent 0x0119 "eogon"
ent 0xD53C "Eopf"
ent 0xD556 "eopf"
ent 0x29E3 "eparsl"
ent 0x22D5 "epar"
ent 0x2A71 "eplus"
ent 0x0395 "Epsilon"
ent 0x03B5 "epsilon"
ent 0x03B5 "epsi"
ent 0x03F5 "epsiv"
ent 0x2256 "eqcirc"
ent 0x2255 "eqcolon"
ent 0x2242 "eqsim"
ent 0x2A96 "eqslantgtr"
ent 0x2A95 "eqslantless"
ent 0x003D "equals"
ent 0x2242 "EqualTilde"
ent 0x2A75 "Equal"
ent 0x225F "equest"
ent 0x21CC "Equilibrium"
ent 0x2A78 "equivDD"
ent 0x2261 "equiv"
ent 0x29E5 "eqvparsl"
ent 0x2971 "erarr"
ent 0x2253 "erDot"
ent 0x212F "escr"
ent 0x2130 "Escr"
ent 0x2250 "esdot"
ent 0x2242 "esim"
ent 0x2A73 "Esim"
ent 0x0397 "Eta"
ent 0x03B7 "eta"
ent 0x00D0 "ETH"
ent 0x00F0 "eth"
ent 0x00CB "Euml"
ent 0x00EB "euml"
ent 0x20AC "euro"
ent 0x0021 "excl"
ent 0x2203 "Exists"
ent 0x2203 "exist"
ent 0x2130 "expectation"
ent 0x2147 "exponentiale"
ent 0x2147 "ExponentialE"
ent 0x2252 "fallingdotseq"
ent 0x0424 "Fcy"
ent 0x0444 "fcy"
ent 0x2640 "female"
ent 0xFB03 "ffilig"
ent 0xFB00 "fflig"
ent 0xFB04 "ffllig"
ent 0xD509 "Ffr"
ent 0xD523 "ffr"
ent 0xFB01 "filig"
ent 0x25FC "FilledSmallSquare"
ent 0x25AA "FilledVerySmallSquare"
ent 0x0066006A "fjlig"
ent 0x266D "flat"
ent 0xFB02 "fllig"
ent 0x25B1 "fltns"
ent 0x0192 "fnof"
ent 0xD53D "Fopf"
ent 0xD557 "fopf"
ent 0x2200 "forall"
ent 0x2200 "ForAll"
ent 0x22D4 "fork"
ent 0x2AD9 "forkv"
ent 0x2131 "Fouriertrf"
ent 0x2A0D "fpartint"
ent 0x00BD "frac12"
ent 0x2153 "frac13"
ent 0x00BC "frac14"
ent 0x2155 "frac15"
ent 0x2159 "frac16"
ent 0x215B "frac18"
ent 0x2154 "frac23"
ent 0x2156 "frac25"
ent 0x00BE "frac34"
ent 0x2157 "frac35"
ent 0x215C "frac38"
ent 0x2158 "frac45"
ent 0x215A "frac56"
ent 0x215D "frac58"
ent 0x215E "frac78"
ent 0x2044 "frasl"
ent 0x2322 "frown"
ent 0x2131 "Fscr"
ent 0xD4BB "fscr"
ent 0x01F5 "gacute"
ent 0x03DC "Gammad"
ent 0x03DD "gammad"
ent 0x0393 "Gamma"
ent 0x03B3 "gamma"
ent 0x2A86 "gap"
ent 0x011E "Gbreve"
ent 0x011F "gbreve"
ent 0x0122 "Gcedil"
ent 0x011C "Gcirc"
ent 0x011D "gcirc"
ent 0x0413 "Gcy"
ent 0x0433 "gcy"
ent 0x0120 "Gdot"
ent 0x0121 "gdot"
ent 0x22DB "gel"
ent 0x2A8C "gEl"
ent 0x2267 "geqq"
ent 0x2A7E "geqslant"
ent 0x2265 "geq"
ent 0x2AA9 "gescc"
ent 0x2A84 "gesdotol"
ent 0x2A82 "gesdoto"
ent 0x2A80 "gesdot"
ent 0x2A94 "gesles"
ent 0x22DBFE00 "gesl"
ent 0x2A7E "ges"
ent 0x2265 "ge"
ent 0x2267 "gE"
ent 0xD50A "Gfr"
ent 0xD524 "gfr"
ent 0x22D9 "ggg"
ent 0x226B "gg"
ent 0x22D9 "Gg"
ent 0x2137 "gimel"
ent 0x0403 "GJcy"
ent 0x0453 "gjcy"
ent 0x2AA5 "gla"
ent 0x2A92 "glE"
ent 0x2AA4 "glj"
ent 0x2277 "gl"
ent 0x2A8A "gnapprox"
ent 0x2A8A "gnap"
ent 0x2269 "gneqq"
ent 0x2A88 "gneq"
ent 0x2269 "gnE"
ent 0x2A88 "gne"
ent 0x22E7 "gnsim"
ent 0xD53E "Gopf"
ent 0xD558 "gopf"
ent 0x0060 "grave"
ent 0x22DB "GreaterEqualLess"
ent 0x2265 "GreaterEqual"
ent 0x2267 "GreaterFullEqual"
ent 0x2AA2 "GreaterGreater"
ent 0x2277 "GreaterLess"
ent 0x2A7E "GreaterSlantEqual"
ent 0x2273 "GreaterTilde"
ent 0x210A "gscr"
ent 0xD4A2 "Gscr"
ent 0x2A8E "gsime"
ent 0x2A90 "gsiml"
ent 0x2273 "gsim"
ent 0x2AA7 "gtcc"
ent 0x2A7A "gtcir"
ent 0x22D7 "gtdot"
ent 0x2995 "gtlPar"
ent 0x2A7C "gtquest"
ent 0x2A86 "gtrapprox"
ent 0x2978 "gtrarr"
ent 0x22D7 "gtrdot"
ent 0x22DB "gtreqless"
ent 0x2A8C "gtreqqless"
ent 0x2277 "gtrless"
ent 0x2273 "gtrsim"
ent 0x003E "gt"
ent 0x003E "GT"
ent 0x226B "Gt"
ent 0x2269FE00 "gvertneqq"
ent 0x2269FE00 "gvnE"
ent 0x02C7 "Hacek"
ent 0x200A "hairsp"
ent 0x00BD "half"
ent 0x210B "hamilt"
ent 0x042A "HARDcy"
ent 0x044A "hardcy"
ent 0x2948 "harrcir"
ent 0x2194 "harr"
ent 0x21D4 "hArr"
ent 0x21AD "harrw"
ent 0x005E "Hat"
ent 0x210F "hbar"
ent 0x0124 "Hcirc"
ent 0x0125 "hcirc"
ent 0x2665 "hearts"
ent 0x2665 "heartsuit"
ent 0x2026 "hellip"
ent 0x22B9 "hercon"
ent 0x210C "Hfr"
ent 0xD525 "hfr"
ent 0x210B "HilbertSpace"
ent 0x2925 "hksearow"
ent 0x2926 "hkswarow"
ent 0x21FF "hoarr"
ent 0x223B "homtht"
ent 0x21A9 "hookleftarrow"
ent 0x21AA "hookrightarrow"
ent 0x210D "Hopf"
ent 0xD559 "hopf"
ent 0x2015 "horbar"
ent 0x2500 "HorizontalLine"
ent 0x210B "Hscr"
ent 0xD4BD "hscr"
ent 0x210F "hslash"
ent 0x0126 "Hstrok"
ent 0x0127 "hstrok"
ent 0x224E "HumpDownHump"
ent 0x224F "HumpEqual"
ent 0x2043 "hybull"
ent 0x2010 "hyphen"
ent 0x00CD "Iacute"
ent 0x00ED "iacute"
ent 0x00CE "Icirc"
ent 0x00EE "icirc"
ent 0x2063 "ic"
ent 0x0418 "Icy"
ent 0x0438 "icy"
ent 0x0130 "Idot"
ent 0x0415 "IEcy"
ent 0x0435 "iecy"
ent 0x00A1 "iexcl"
ent 0x21D4 "iff"
ent 0x2111 "Ifr"
ent 0xD526 "ifr"
ent 0x00CC "Igrave"
ent 0x00EC "igrave"
ent 0x2A0C "iiiint"
ent 0x222D "iiint"
ent 0x29DC "iinfin"
ent 0x2129 "iiota"
ent 0x2148 "ii"
ent 0x0132 "IJlig"
ent 0x0133 "ijlig"
ent 0x012A "Imacr"
ent 0x012B "imacr"
ent 0x2111 "image"
ent 0x2148 "ImaginaryI"
ent 0x2110 "imagline"
ent 0x2111 "imagpart"
ent 0x0131 "imath"
ent 0x22B7 "imof"
ent 0x01B5 "imped"
ent 0x21D2 "Implies"
ent 0x2111 "Im"
ent 0x2105 "incare"
ent 0x29DD "infintie"
ent 0x221E "infin"
ent 0x0131 "inodot"
ent 0x22BA "intcal"
ent 0x2124 "integers"
ent 0x222B "Integral"
ent 0x22BA "intercal"
ent 0x22C2 "Intersection"
ent 0x2A17 "intlarhk"
ent 0x2A3C "intprod"
ent 0x222B "int"
ent 0x222C "Int"
ent 0x2208 "in"
ent 0x2063 "InvisibleComma"
ent 0x2062 "InvisibleTimes"
ent 0x0401 "IOcy"
ent 0x0451 "iocy"
ent 0x012E "Iogon"
ent 0x012F "iogon"
ent 0xD540 "Iopf"
ent 0xD55A "iopf"
ent 0x0399 "Iota"
ent 0x03B9 "iota"
ent 0x2A3C "iprod"
ent 0x00BF "iquest"
ent 0x2110 "Iscr"
ent 0xD4BE "iscr"
ent 0x22F5 "isindot"
ent 0x22F9 "isinE"
ent 0x22F4 "isins"
ent 0x22F3 "isinsv"
ent 0x2208 "isin"
ent 0x2208 "isinv"
ent 0x0128 "Itilde"
ent 0x0129 "itilde"
ent 0x2062 "it"
ent 0x0406 "Iukcy"
ent 0x0456 "iukcy"
ent 0x00CF "Iuml"
ent 0x00EF "iuml"
ent 0x0134 "Jcirc"
ent 0x0135 "jcirc"
ent 0x0419 "Jcy"
ent 0x0439 "jcy"
ent 0xD50D "Jfr"
ent 0xD527 "jfr"
ent 0x0237 "jmath"
ent 0xD541 "Jopf"
ent 0xD55B "jopf"
ent 0xD4A5 "Jscr"
ent 0xD4BF "jscr"
ent 0x0408 "Jsercy"
ent 0x0458 "jsercy"
ent 0x0404 "Jukcy"
ent 0x0454 "jukcy"
ent 0x039A "Kappa"
ent 0x03BA "kappa"
ent 0x03F0 "kappav"
ent 0x0136 "Kcedil"
ent 0x0137 "kcedil"
ent 0x041A "Kcy"
ent 0x043A "kcy"
ent 0xD50E "Kfr"
ent 0xD528 "kfr"
ent 0x0138 "kgreen"
ent 0x0425 "KHcy"
ent 0x0445 "khcy"
ent 0x040C "KJcy"
ent 0x045C "kjcy"
ent 0xD542 "Kopf"
ent 0xD55C "kopf"
ent 0xD4A6 "Kscr"
ent 0xD4C0 "kscr"
ent 0x21DA "lAarr"
ent 0x0139 "Lacute"
ent 0x013A "lacute"
ent 0x29B4 "laemptyv"
ent 0x2112 "lagran"
ent 0x039B "Lambda"
ent 0x03BB "lambda"
ent 0x2991 "langd"
ent 0x27E8 "langle"
ent 0x27E8 "lang"
ent 0x27EA "Lang"
ent 0x2112 "Laplacetrf"
ent 0x2A85 "lap"
ent 0x00AB "laquo"
ent 0x291F "larrbfs"
ent 0x21E4 "larrb"
ent 0x291D "larrfs"
ent 0x21A9 "larrhk"
ent 0x21AB "larrlp"
ent 0x2939 "larrpl"
ent 0x2973 "larrsim"
ent 0x21A2 "larrtl"
ent 0x2190 "larr"
ent 0x219E "Larr"
ent 0x21D0 "lArr"
ent 0x2919 "latail"
ent 0x291B "lAtail"
ent 0x2AADFE00 "lates"
ent 0x2AAD "late"
ent 0x2AAB "lat"
ent 0x290C "lbarr"
ent 0x290E "lBarr"
ent 0x2772 "lbbrk"
ent 0x007B "lbrace"
ent 0x005B "lbrack"
ent 0x298B "lbrke"
ent 0x298F "lbrksld"
ent 0x298D "lbrkslu"
ent 0x013D "Lcaron"
ent 0x013E "lcaron"
ent 0x013B "Lcedil"
ent 0x013C "lcedil"
ent 0x2308 "lceil"
ent 0x007B "lcub"
ent 0x041B "Lcy"
ent 0x043B "lcy"
ent 0x2936 "ldca"
ent 0x201E "ldquor"
ent 0x201C "ldquo"
ent 0x2967 "ldrdhar"
ent 0x294B "ldrushar"
ent 0x21B2 "ldsh"
ent 0x27E8 "LeftAngleBracket"
ent 0x21E4 "LeftArrowBar"
ent 0x21C6 "LeftArrowRightArrow"
ent 0x21A2 "leftarrowtail"
ent 0x2190 "leftarrow"
ent 0x2190 "LeftArrow"
ent 0x21D0 "Leftarrow"
ent 0x2308 "LeftCeiling"
ent 0x27E6 "LeftDoubleBracket"
ent 0x2961 "LeftDownTeeVector"
ent 0x2959 "LeftDownVectorBar"
ent 0x21C3 "LeftDownVector"
ent 0x230A "LeftFloor"
ent 0x21BD "leftharpoondown"
ent 0x21BC "leftharpoonup"
ent 0x21C7 "leftleftarrows"
ent 0x21C6 "leftrightarrows"
ent 0x2194 "leftrightarrow"
ent 0x2194 "LeftRightArrow"
ent 0x21D4 "Leftrightarrow"
ent 0x21CB "leftrightharpoons"
ent 0x21AD "leftrightsquigarrow"
ent 0x294E "LeftRightVector"
ent 0x21A4 "LeftTeeArrow"
ent 0x22A3 "LeftTee"
ent 0x295A "LeftTeeVector"
ent 0x22CB "leftthreetimes"
ent 0x29CF "LeftTriangleBar"
ent 0x22B4 "LeftTriangleEqual"
ent 0x22B2 "LeftTriangle"
ent 0x2951 "LeftUpDownVector"
ent 0x2960 "LeftUpTeeVector"
ent 0x2958 "LeftUpVectorBar"
ent 0x21BF "LeftUpVector"
ent 0x2952 "LeftVectorBar"
ent 0x21BC "LeftVector"
ent 0x22DA "leg"
ent 0x2A8B "lEg"
ent 0x2266 "leqq"
ent 0x2A7D "leqslant"
ent 0x2264 "leq"
ent 0x2AA8 "lescc"
ent 0x2A83 "lesdotor"
ent 0x2A81 "lesdoto"
ent 0x2A7F "lesdot"
ent 0x2A93 "lesges"
ent 0x22DAFE00 "lesg"
ent 0x2A85 "lessapprox"
ent 0x22D6 "lessdot"
ent 0x22DA "lesseqgtr"
ent 0x2A8B "lesseqqgtr"
ent 0x22DA "LessEqualGreater"
ent 0x2266 "LessFullEqual"
ent 0x2276 "LessGreater"
ent 0x2276 "lessgtr"
ent 0x2AA1 "LessLess"
ent 0x2272 "lesssim"
ent 0x2A7D "LessSlantEqual"
ent 0x2272 "LessTilde"
ent 0x2A7D "les"
ent 0x2264 "le"
ent 0x2266 "lE"
ent 0x297C "lfisht"
ent 0x230A "lfloor"
ent 0xD50F "Lfr"
ent 0xD529 "lfr"
ent 0x2A91 "lgE"
ent 0x2276 "lg"
ent 0x21BD "lhard"
ent 0x2962 "lHar"
ent 0x296A "lharul"
ent 0x21BC "lharu"
ent 0x2584 "lhblk"
ent 0x0409 "LJcy"
ent 0x0459 "ljcy"
ent 0x21C7 "llarr"
ent 0x231E "llcorner"
ent 0x21DA "Lleftarrow"
ent 0x296B "llhard"
ent 0x25FA "lltri"
ent 0x226A "ll"
ent 0x22D8 "Ll"
ent 0x013F "Lmidot"
ent 0x0140 "lmidot"
ent 0x23B0 "lmoustache"
ent 0x23B0 "lmoust"
ent 0x2A89 "lnapprox"
ent 0x2A89 "lnap"
ent 0x2268 "lneqq"
ent 0x2A87 "lneq"
ent 0x2268 "lnE"
ent 0x2A87 "lne"
ent 0x22E6 "lnsim"
ent 0x27EC "loang"
ent 0x21FD "loarr"
ent 0x27E6 "lobrk"
ent 0x27F5 "longleftarrow"
ent 0x27F5 "LongLeftArrow"
ent 0x27F8 "Longleftarrow"
ent 0x27F7 "longleftrightarrow"
ent 0x27F7 "LongLeftRightArrow"
ent 0x27FA "Longleftrightarrow"
ent 0x27FC "longmapsto"
ent 0x27F6 "longrightarrow"
ent 0x27F6 "LongRightArrow"
ent 0x27F9 "Longrightarrow"
ent 0x21AB "looparrowleft"
ent 0x21AC "looparrowright"
ent 0x2985 "lopar"
ent 0xD543 "Lopf"
ent 0xD55D "lopf"
ent 0x2A2D "loplus"
ent 0x2A34 "lotimes"
ent 0x2217 "lowast"
ent 0x005F "lowbar"
ent 0x2199 "LowerLeftArrow"
ent 0x2198 "LowerRightArrow"
ent 0x25CA "lozenge"
ent 0x29EB "lozf"
ent 0x25CA "loz"
ent 0x2993 "lparlt"
ent 0x0028 "lpar"
ent 0x21C6 "lrarr"
ent 0x231F "lrcorner"
ent 0x296D "lrhard"
ent 0x21CB "lrhar"
ent 0x200E "lrm"
ent 0x22BF "lrtri"
ent 0x2039 "lsaquo"
ent 0x2112 "Lscr"
ent 0xD4C1 "lscr"
ent 0x21B0 "lsh"
ent 0x21B0 "Lsh"
ent 0x2A8D "lsime"
ent 0x2A8F "lsimg"
ent 0x2272 "lsim"
ent 0x005B "lsqb"
ent 0x201A "lsquor"
ent 0x2018 "lsquo"
ent 0x0141 "Lstrok"
ent 0x0142 "lstrok"
ent 0x2AA6 "ltcc"
ent 0x2A79 "ltcir"
ent 0x22D6 "ltdot"
ent 0x22CB "lthree"
ent 0x22C9 "ltimes"
ent 0x2976 "ltlarr"
ent 0x2A7B "ltquest"
ent 0x22B4 "ltrie"
ent 0x25C2 "ltrif"
ent 0x25C3 "ltri"
ent 0x2996 "ltrPar"
ent 0x003C "lt"
ent 0x003C "LT"
ent 0x226A "Lt"
ent 0x294A "lurdshar"
ent 0x2966 "luruhar"
ent 0x2268FE00 "lvertneqq"
ent 0x2268FE00 "lvnE"
ent 0x00AF "macr"
ent 0x2642 "male"
ent 0x2720 "maltese"
ent 0x2720 "malt"
ent 0x21A7 "mapstodown"
ent 0x21A4 "mapstoleft"
ent 0x21A6 "mapsto"
ent 0x21A5 "mapstoup"
ent 0x21A6 "map"
ent 0x2905 "Map"
ent 0x25AE "marker"
ent 0x2A29 "mcomma"
ent 0x041C "Mcy"
ent 0x043C "mcy"
ent 0x2014 "mdash"
ent 0x223A "mDDot"
ent 0x2221 "measuredangle"
ent 0x205F "MediumSpace"
ent 0x2133 "Mellintrf"
ent 0xD510 "Mfr"
ent 0xD52A "mfr"
ent 0x2127 "mho"
ent 0x00B5 "micro"
ent 0x002A "midast"
ent 0x2AF0 "midcir"
ent 0x00B7 "middot"
ent 0x2223 "mid"
ent 0x229F "minusb"
ent 0x2238 "minusd"
ent 0x2A2A "minusdu"
ent 0x2213 "MinusPlus"
ent 0x2212 "minus"
ent 0x2ADB "mlcp"
ent 0x2026 "mldr"
ent 0x2213 "mnplus"
ent 0x22A7 "models"
ent 0xD544 "Mopf"
ent 0xD55E "mopf"
ent 0x2213 "mp"
ent 0x2133 "Mscr"
ent 0xD4C2 "mscr"
ent 0x223E "mstpos"
ent 0x22B8 "multimap"
ent 0x22B8 "mumap"
ent 0x039C "Mu"
ent 0x03BC "mu"
ent 0x2207 "nabla"
ent 0x0143 "Nacute"
ent 0x0144 "nacute"
ent 0x222020D2 "nang"
ent 0x2A700338 "napE"
ent 0x224B0338 "napid"
ent 0x0149 "napos"
ent 0x2249 "napprox"
ent 0x2249 "nap"
ent 0x2115 "naturals"
ent 0x266E "natural"
ent 0x266E "natur"
ent 0x00A0 "nbsp"
ent 0x224F0338 "nbumpe"
ent 0x224E0338 "nbump"
ent 0x2A43 "ncap"
ent 0x0147 "Ncaron"
ent 0x0148 "ncaron"
ent 0x0145 "Ncedil"
ent 0x0146 "ncedil"
ent 0x2A6D0338 "ncongdot"
ent 0x2247 "ncong"
ent 0x2A42 "ncup"
ent 0x041D "Ncy"
ent 0x043D "ncy"
ent 0x2013 "ndash"
ent 0x2924 "nearhk"
ent 0x2197 "nearrow"
ent 0x2197 "nearr"
ent 0x21D7 "neArr"
ent 0x22500338 "nedot"
ent 0x200B "NegativeMediumSpace"
ent 0x200B "NegativeThickSpace"
ent 0x200B "NegativeThinSpace"
ent 0x200B "NegativeVeryThinSpace"
ent 0x2262 "nequiv"
ent 0x2928 "nesear"
ent 0x22420338 "nesim"
ent 0x226B "NestedGreaterGreater"
ent 0x226A "NestedLessLess"
ent 0x2260 "ne"
ent 0x000A "NewLine"
ent 0x2204 "nexists"
ent 0x2204 "nexist"
ent 0xD511 "Nfr"
ent 0xD52B "nfr"
ent 0x22670338 "ngeqq"
ent 0x2A7E0338 "ngeqslant"
ent 0x2271 "ngeq"
ent 0x2A7E0338 "nges"
ent 0x22670338 "ngE"
ent 0x2271 "nge"
ent 0x22D90338 "nGg"
ent 0x2275 "ngsim"
ent 0x226F "ngtr"
ent 0x226B20D2 "nGt"
ent 0x226F "ngt"
ent 0x226B0338 "nGtv"
ent 0x21AE "nharr"
ent 0x21CE "nhArr"
ent 0x2AF2 "nhpar"
ent 0x22FA "nisd"
ent 0x22FC "nis"
ent 0x220B "ni"
ent 0x220B "niv"
ent 0x040A "NJcy"
ent 0x045A "njcy"
ent 0x219A "nlarr"
ent 0x21CD "nlArr"
ent 0x2025 "nldr"
ent 0x219A "nleftarrow"
ent 0x21CD "nLeftarrow"
ent 0x21AE "nleftrightarrow"
ent 0x21CE "nLeftrightarrow"
ent 0x22660338 "nleqq"
ent 0x2A7D0338 "nleqslant"
ent 0x2270 "nleq"
ent 0x226E "nless"
ent 0x2A7D0338 "nles"
ent 0x22660338 "nlE"
ent 0x2270 "nle"
ent 0x22D80338 "nLl"
ent 0x2274 "nlsim"
ent 0x22EC "nltrie"
ent 0x22EA "nltri"
ent 0x226A20D2 "nLt"
ent 0x226E "nlt"
ent 0x226A0338 "nLtv"
ent 0x2224 "nmid"
ent 0x2060 "NoBreak"
ent 0x00A0 "NonBreakingSpace"
ent 0x2115 "Nopf"
ent 0xD55F "nopf"
ent 0x2262 "NotCongruent"
ent 0x226D "NotCupCap"
ent 0x2226 "NotDoubleVerticalBar"
ent 0x2209 "NotElement"
ent 0x22420338 "NotEqualTilde"
ent 0x2260 "NotEqual"
ent 0x2204 "NotExists"
ent 0x2271 "NotGreaterEqual"
ent 0x22670338 "NotGreaterFullEqual"
ent 0x226B0338 "NotGreaterGreater"
ent 0x2279 "NotGreaterLess"
ent 0x2A7E0338 "NotGreaterSlantEqual"
ent 0x2275 "NotGreaterTilde"
ent 0x226F "NotGreater"
ent 0x224E0338 "NotHumpDownHump"
ent 0x224F0338 "NotHumpEqual"
ent 0x22F50338 "notindot"
ent 0x22F90338 "notinE"
ent 0x2209 "notin"
ent 0x2209 "notinva"
ent 0x22F7 "notinvb"
ent 0x22F6 "notinvc"
ent 0x29CF0338 "NotLeftTriangleBar"
ent 0x22EC "NotLeftTriangleEqual"
ent 0x22EA "NotLeftTriangle"
ent 0x2270 "NotLessEqual"
ent 0x2278 "NotLessGreater"
ent 0x226A0338 "NotLessLess"
ent 0x2A7D0338 "NotLessSlantEqual"
ent 0x2274 "NotLessTilde"
ent 0x226E "NotLess"
ent 0x2AA20338 "NotNestedGreaterGreater"
ent 0x2AA10338 "NotNestedLessLess"
ent 0x220C "notni"
ent 0x220C "notniva"
ent 0x22FE "notnivb"
ent 0x22FD "notnivc"
ent 0x2AAF0338 "NotPrecedesEqual"
ent 0x22E0 "NotPrecedesSlantEqual"
ent 0x2280 "NotPrecedes"
ent 0x220C "NotReverseElement"
ent 0x29D00338 "NotRightTriangleBar"
ent 0x22ED "NotRightTriangleEqual"
ent 0x22EB "NotRightTriangle"
ent 0x22E2 "NotSquareSubsetEqual"
ent 0x228F0338 "NotSquareSubset"
ent 0x22E3 "NotSquareSupersetEqual"
ent 0x22900338 "NotSquareSuperset"
ent 0x2288 "NotSubsetEqual"
ent 0x228220D2 "NotSubset"
ent 0x2AB00338 "NotSucceedsEqual"
ent 0x22E1 "NotSucceedsSlantEqual"
ent 0x227F0338 "NotSucceedsTilde"
ent 0x2281 "NotSucceeds"
ent 0x2289 "NotSupersetEqual"
ent 0x228320D2 "NotSuperset"
ent 0x2244 "NotTildeEqual"
ent 0x2247 "NotTildeFullEqual"
ent 0x2249 "NotTildeTilde"
ent 0x2241 "NotTilde"
ent 0x00AC "not"
ent 0x2AEC "Not"
ent 0x2224 "NotVerticalBar"
ent 0x2226 "nparallel"
ent 0x2AFD20E5 "nparsl"
ent 0x22020338 "npart"
ent 0x2226 "npar"
ent 0x2A14 "npolint"
ent 0x22E0 "nprcue"
ent 0x2AAF0338 "npreceq"
ent 0x2280 "nprec"
ent 0x2AAF0338 "npre"
ent 0x2280 "npr"
ent 0x29330338 "nrarrc"
ent 0x219B "nrarr"
ent 0x21CF "nrArr"
ent 0x219D0338 "nrarrw"
ent 0x219B "nrightarrow"
ent 0x21CF "nRightarrow"
ent 0x22ED "nrtrie"
ent 0x22EB "nrtri"
ent 0x22E1 "nsccue"
ent 0x2AB00338 "nsce"
ent 0xD4A9 "Nscr"
ent 0xD4C3 "nscr"
ent 0x2281 "nsc"
ent 0x2224 "nshortmid"
ent 0x2226 "nshortparallel"
ent 0x2244 "nsimeq"
ent 0x2244 "nsime"
ent 0x2241 "nsim"
ent 0x2224 "nsmid"
ent 0x2226 "nspar"
ent 0x22E2 "nsqsube"
ent 0x22E3 "nsqsupe"
ent 0x2288 "nsube"
ent 0x2AC50338 "nsubE"
ent 0x2AC50338 "nsubseteqq"
ent 0x2288 "nsubseteq"
ent 0x228220D2 "nsubset"
ent 0x2284 "nsub"
ent 0x2AB00338 "nsucceq"
ent 0x2281 "nsucc"
ent 0x2289 "nsupe"
ent 0x2AC60338 "nsupE"
ent 0x2AC60338 "nsupseteqq"
ent 0x2289 "nsupseteq"
ent 0x228320D2 "nsupset"
ent 0x2285 "nsup"
ent 0x2279 "ntgl"
ent 0x00D1 "Ntilde"
ent 0x00F1 "ntilde"
ent 0x2278 "ntlg"
ent 0x22EC "ntrianglelefteq"
ent 0x22EA "ntriangleleft"
ent 0x22ED "ntrianglerighteq"
ent 0x22EB "ntriangleright"
ent 0x2116 "numero"
ent 0x2007 "numsp"
ent 0x0023 "num"
ent 0x039D "Nu"
ent 0x03BD "nu"
ent 0x224D20D2 "nvap"
ent 0x22AC "nvdash"
ent 0x22AD "nvDash"
ent 0x22AE "nVdash"
ent 0x22AF "nVDash"
ent 0x226520D2 "nvge"
ent 0x003E20D2 "nvgt"
ent 0x2904 "nvHarr"
ent 0x29DE "nvinfin"
ent 0x2902 "nvlArr"
ent 0x226420D2 "nvle"
ent 0x22B420D2 "nvltrie"
ent 0x003C20D2 "nvlt"
ent 0x2903 "nvrArr"
ent 0x22B520D2 "nvrtrie"
ent 0x223C20D2 "nvsim"
ent 0x2923 "nwarhk"
ent 0x2196 "nwarrow"
ent 0x2196 "nwarr"
ent 0x21D6 "nwArr"
ent 0x2927 "nwnear"
ent 0x00D3 "Oacute"
ent 0x00F3 "oacute"
ent 0x229B "oast"
ent 0x00D4 "Ocirc"
ent 0x00F4 "ocirc"
ent 0x229A "ocir"
ent 0x041E "Ocy"
ent 0x043E "ocy"
ent 0x229D "odash"
ent 0x0150 "Odblac"
ent 0x0151 "odblac"
ent 0x2A38 "odiv"
ent 0x2299 "odot"
ent 0x29BC "odsold"
ent 0x0152 "OElig"
ent 0x0153 "oelig"
ent 0x29BF "ofcir"
ent 0xD512 "Ofr"
ent 0xD52C "ofr"
ent 0x02DB "ogon"
ent 0x00D2 "Ograve"
ent 0x00F2 "ograve"
ent 0x29C1 "ogt"
ent 0x29B5 "ohbar"
ent 0x03A9 "ohm"
ent 0x222E "oint"
ent 0x21BA "olarr"
ent 0x29BE "olcir"
ent 0x29BB "olcross"
ent 0x203E "oline"
ent 0x29C0 "olt"
ent 0x014C "Omacr"
ent 0x014D "omacr"
ent 0x03A9 "Omega"
ent 0x03C9 "omega"
ent 0x039F "Omicron"
ent 0x03BF "omicron"
ent 0x29B6 "omid"
ent 0x2296 "ominus"
ent 0xD546 "Oopf"
ent 0xD560 "oopf"
ent 0x29B7 "opar"
ent 0x201C "OpenCurlyDoubleQuote"
ent 0x2018 "OpenCurlyQuote"
ent 0x29B9 "operp"
ent 0x2295 "oplus"
ent 0x21BB "orarr"
ent 0x2134 "orderof"
ent 0x2134 "order"
ent 0x00AA "ordf"
ent 0x00BA "ordm"
ent 0x2A5D "ord"
ent 0x22B6 "origof"
ent 0x2A56 "oror"
ent 0x2A57 "orslope"
ent 0x2228 "or"
ent 0x2A54 "Or"
ent 0x2A5B "orv"
ent 0x2134 "oscr"
ent 0xD4AA "Oscr"
ent 0x00D8 "Oslash"
ent 0x00F8 "oslash"
ent 0x2298 "osol"
ent 0x24C8 "oS"
ent 0x00D5 "Otilde"
ent 0x00F5 "otilde"
ent 0x2A36 "otimesas"
ent 0x2297 "otimes"
ent 0x2A37 "Otimes"
ent 0x00D6 "Ouml"
ent 0x00F6 "ouml"
ent 0x233D "ovbar"
ent 0x203E "OverBar"
ent 0x23DE "OverBrace"
ent 0x23B4 "OverBracket"
ent 0x23DC "OverParenthesis"
ent 0x2225 "parallel"
ent 0x00B6 "para"
ent 0x2AF3 "parsim"
ent 0x2AFD "parsl"
ent 0x2202 "PartialD"
ent 0x2202 "part"
ent 0x2225 "par"
ent 0x041F "Pcy"
ent 0x043F "pcy"
ent 0x0025 "percnt"
ent 0x002E "period"
ent 0x2030 "permil"
ent 0x22A5 "perp"
ent 0x2031 "pertenk"
ent 0xD513 "Pfr"
ent 0xD52D "pfr"
ent 0x03A6 "Phi"
ent 0x03C6 "phi"
ent 0x03D5 "phiv"
ent 0x2133 "phmmat"
ent 0x260E "phone"
ent 0x22D4 "pitchfork"
ent 0x03A0 "Pi"
ent 0x03C0 "pi"
ent 0x03D6 "piv"
ent 0x210E "planckh"
ent 0x210F "planck"
ent 0x210F "plankv"
ent 0x2A23 "plusacir"
ent 0x229E "plusb"
ent 0x2A22 "pluscir"
ent 0x2214 "plusdo"
ent 0x2A25 "plusdu"
ent 0x2A72 "pluse"
ent 0x00B1 "PlusMinus"
ent 0x00B1 "plusmn"
ent 0x2A26 "plussim"
ent 0x2A27 "plustwo"
ent 0x002B "plus"
ent 0x00B1 "pm"
ent 0x210C "Poincareplane"
ent 0x2A15 "pointint"
ent 0x2119 "Popf"
ent 0xD561 "popf"
ent 0x00A3 "pound"
ent 0x2AB7 "prap"
ent 0x227C "prcue"
ent 0x2AB7 "precapprox"
ent 0x227C "preccurlyeq"
ent 0x2AAF "PrecedesEqual"
ent 0x227C "PrecedesSlantEqual"
ent 0x227E "PrecedesTilde"
ent 0x227A "Precedes"
ent 0x2AAF "preceq"
ent 0x2AB9 "precnapprox"
ent 0x2AB5 "precneqq"
ent 0x22E8 "precnsim"
ent 0x227E "precsim"
ent 0x227A "prec"
ent 0x2AAF "pre"
ent 0x2AB3 "prE"
ent 0x2119 "primes"
ent 0x2032 "prime"
ent 0x2033 "Prime"
ent 0x2AB9 "prnap"
ent 0x2AB5 "prnE"
ent 0x22E8 "prnsim"
ent 0x220F "prod"
ent 0x220F "Product"
ent 0x232E "profalar"
ent 0x2312 "profline"
ent 0x2313 "profsurf"
ent 0x221D "Proportional"
ent 0x2237 "Proportion"
ent 0x221D "propto"
ent 0x221D "prop"
ent 0x227E "prsim"
ent 0x227A "pr"
ent 0x2ABB "Pr"
ent 0x22B0 "prurel"
ent 0xD4AB "Pscr"
ent 0xD4C5 "pscr"
ent 0x03A8 "Psi"
ent 0x03C8 "psi"
ent 0x2008 "puncsp"
ent 0xD514 "Qfr"
ent 0xD52E "qfr"
ent 0x2A0C "qint"
ent 0x211A "Qopf"
ent 0xD562 "qopf"
ent 0x2057 "qprime"
ent 0xD4AC "Qscr"
ent 0xD4C6 "qscr"
ent 0x210D "quaternions"
ent 0x2A16 "quatint"
ent 0x225F "questeq"
ent 0x003F "quest"
ent 0x0022 "quot"
ent 0x0022 "QUOT"
ent 0x21DB "rAarr"
ent 0x223D0331 "race"
ent 0x0154 "Racute"
ent 0x0155 "racute"
ent 0x221A "radic"
ent 0x29B3 "raemptyv"
ent 0x2992 "rangd"
ent 0x29A5 "range"
ent 0x27E9 "rangle"
ent 0x27E9 "rang"
ent 0x27EB "Rang"
ent 0x00BB "raquo"
ent 0x2975 "rarrap"
ent 0x2920 "rarrbfs"
ent 0x21E5 "rarrb"
ent 0x2933 "rarrc"
ent 0x291E "rarrfs"
ent 0x21AA "rarrhk"
ent 0x21AC "rarrlp"
ent 0x2945 "rarrpl"
ent 0x2974 "rarrsim"
ent 0x21A3 "rarrtl"
ent 0x2916 "Rarrtl"
ent 0x2192 "rarr"
ent 0x21A0 "Rarr"
ent 0x21D2 "rArr"
ent 0x219D "rarrw"
ent 0x291A "ratail"
ent 0x291C "rAtail"
ent 0x211A "rationals"
ent 0x2236 "ratio"
ent 0x290D "rbarr"
ent 0x290F "rBarr"
ent 0x2910 "RBarr"
ent 0x2773 "rbbrk"
ent 0x007D "rbrace"
ent 0x005D "rbrack"
ent 0x298C "rbrke"
ent 0x298E "rbrksld"
ent 0x2990 "rbrkslu"
ent 0x0158 "Rcaron"
ent 0x0159 "rcaron"
ent 0x0156 "Rcedil"
ent 0x0157 "rcedil"
ent 0x2309 "rceil"
ent 0x007D "rcub"
ent 0x0420 "Rcy"
ent 0x0440 "rcy"
ent 0x2937 "rdca"
ent 0x2969 "rdldhar"
ent 0x201D "rdquor"
ent 0x201D "rdquo"
ent 0x21B3 "rdsh"
ent 0x211B "realine"
ent 0x211C "realpart"
ent 0x211D "reals"
ent 0x211C "real"
ent 0x25AD "rect"
ent 0x00AE "reg"
ent 0x00AE "REG"
ent 0x211C "Re"
ent 0x220B "ReverseElement"
ent 0x21CB "ReverseEquilibrium"
ent 0x296F "ReverseUpEquilibrium"
ent 0x297D "rfisht"
ent 0x230B "rfloor"
ent 0x211C "Rfr"
ent 0xD52F "rfr"
ent 0x21C1 "rhard"
ent 0x2964 "rHar"
ent 0x296C "rharul"
ent 0x21C0 "rharu"
ent 0x03A1 "Rho"
ent 0x03C1 "rho"
ent 0x03F1 "rhov"
ent 0x27E9 "RightAngleBracket"
ent 0x21E5 "RightArrowBar"
ent 0x21C4 "RightArrowLeftArrow"
ent 0x21A3 "rightarrowtail"
ent 0x2192 "rightarrow"
ent 0x2192 "RightArrow"
ent 0x21D2 "Rightarrow"
ent 0x2309 "RightCeiling"
ent 0x27E7 "RightDoubleBracket"
ent 0x295D "RightDownTeeVector"
ent 0x2955 "RightDownVectorBar"
ent 0x21C2 "RightDownVector"
ent 0x230B "RightFloor"
ent 0x21C1 "rightharpoondown"
ent 0x21C0 "rightharpoonup"
ent 0x21C4 "rightleftarrows"
ent 0x21CC "rightleftharpoons"
ent 0x21C9 "rightrightarrows"
ent 0x219D "rightsquigarrow"
ent 0x21A6 "RightTeeArrow"
ent 0x22A2 "RightTee"
ent 0x295B "RightTeeVector"
ent 0x22CC "rightthreetimes"
ent 0x29D0 "RightTriangleBar"
ent 0x22B5 "RightTriangleEqual"
ent 0x22B3 "RightTriangle"
ent 0x294F "RightUpDownVector"
ent 0x295C "RightUpTeeVector"
ent 0x2954 "RightUpVectorBar"
ent 0x21BE "RightUpVector"
ent 0x2953 "RightVectorBar"
ent 0x21C0 "RightVector"
ent 0x02DA "ring"
ent 0x2253 "risingdotseq"
ent 0x21C4 "rlarr"
ent 0x21CC "rlhar"
ent 0x200F "rlm"
ent 0x23B1 "rmoustache"
ent 0x23B1 "rmoust"
ent 0x2AEE "rnmid"
ent 0x27ED "roang"
ent 0x21FE "roarr"
ent 0x27E7 "robrk"
ent 0x2986 "ropar"
ent 0x211D "Ropf"
ent 0xD563 "ropf"
ent 0x2A2E "roplus"
ent 0x2A35 "rotimes"
ent 0x2970 "RoundImplies"
ent 0x2994 "rpargt"
ent 0x0029 "rpar"
ent 0x2A12 "rppolint"
ent 0x21C9 "rrarr"
ent 0x21DB "Rrightarrow"
ent 0x203A "rsaquo"
ent 0x211B "Rscr"
ent 0xD4C7 "rscr"
ent 0x21B1 "rsh"
ent 0x21B1 "Rsh"
ent 0x005D "rsqb"
ent 0x2019 "rsquor"
ent 0x2019 "rsquo"
ent 0x22CC "rthree"
ent 0x22CA "rtimes"
ent 0x22B5 "rtrie"
ent 0x25B8 "rtrif"
ent 0x29CE "rtriltri"
ent 0x25B9 "rtri"
ent 0x29F4 "RuleDelayed"
ent 0x2968 "ruluhar"
ent 0x211E "rx"
ent 0x015A "Sacute"
ent 0x015B "sacute"
ent 0x201A "sbquo"
ent 0x2AB8 "scap"
ent 0x0160 "Scaron"
ent 0x0161 "scaron"
ent 0x227D "sccue"
ent 0x015E "Scedil"
ent 0x015F "scedil"
ent 0x2AB0 "sce"
ent 0x2AB4 "scE"
ent 0x015C "Scirc"
ent 0x015D "scirc"
ent 0x2ABA "scnap"
ent 0x2AB6 "scnE"
ent 0x22E9 "scnsim"
ent 0x2A13 "scpolint"
ent 0x227F "scsim"
ent 0x227B "sc"
ent 0x2ABC "Sc"
ent 0x0421 "Scy"
ent 0x0441 "scy"
ent 0x22A1 "sdotb"
ent 0x2A66 "sdote"
ent 0x22C5 "sdot"
ent 0x2925 "searhk"
ent 0x2198 "searrow"
ent 0x2198 "searr"
ent 0x21D8 "seArr"
ent 0x00A7 "sect"
ent 0x003B "semi"
ent 0x2929 "seswar"
ent 0x2216 "setminus"
ent 0x2216 "setmn"
ent 0x2736 "sext"
ent 0x2322 "sfrown"
ent 0xD516 "Sfr"
ent 0xD530 "sfr"
ent 0x266F "sharp"
ent 0x0429 "SHCHcy"
ent 0x0449 "shchcy"
ent 0x0428 "SHcy"
ent 0x0448 "shcy"
ent 0x2193 "ShortDownArrow"
ent 0x2190 "ShortLeftArrow"
ent 0x2223 "shortmid"
ent 0x2225 "shortparallel"
ent 0x2192 "ShortRightArrow"
ent 0x2191 "ShortUpArrow"
ent 0x00AD "shy"
ent 0x03C2 "sigmaf"
ent 0x03A3 "Sigma"
ent 0x03C3 "sigma"
ent 0x03C2 "sigmav"
ent 0x2A6A "simdot"
ent 0x2243 "simeq"
ent 0x2243 "sime"
ent 0x2AA0 "simgE"
ent 0x2A9E "simg"
ent 0x2A9F "simlE"
ent 0x2A9D "siml"
ent 0x2246 "simne"
ent 0x2A24 "simplus"
ent 0x2972 "simrarr"
ent 0x223C "sim"
ent 0x2190 "slarr"
ent 0x2218 "SmallCircle"
ent 0x2216 "smallsetminus"
ent 0x2A33 "smashp"
ent 0x29E4 "smeparsl"
ent 0x2223 "smid"
ent 0x2323 "smile"
ent 0x2AACFE00 "smtes"
ent 0x2AAC "smte"
ent 0x2AAA "smt"
ent 0x042C "SOFTcy"
ent 0x044C "softcy"
ent 0x233F "solbar"
ent 0x29C4 "solb"
ent 0x002F "sol"
ent 0xD54A "Sopf"
ent 0xD564 "sopf"
ent 0x2660 "spades"
ent 0x2660 "spadesuit"
ent 0x2225 "spar"
ent 0x2293FE00 "sqcaps"
ent 0x2293 "sqcap"
ent 0x2294FE00 "sqcups"
ent 0x2294 "sqcup"
ent 0x221A "Sqrt"
ent 0x2291 "sqsube"
ent 0x2291 "sqsubseteq"
ent 0x228F "sqsubset"
ent 0x228F "sqsub"
ent 0x2292 "sqsupe"
ent 0x2292 "sqsupseteq"
ent 0x2290 "sqsupset"
ent 0x2290 "sqsup"
ent 0x2293 "SquareIntersection"
ent 0x2291 "SquareSubsetEqual"
ent 0x228F "SquareSubset"
ent 0x2292 "SquareSupersetEqual"
ent 0x2290 "SquareSuperset"
ent 0x25A1 "square"
ent 0x25A1 "Square"
ent 0x2294 "SquareUnion"
ent 0x25AA "squarf"
ent 0x25AA "squf"
ent 0x25A1 "squ"
ent 0x2192 "srarr"
ent 0xD4AE "Sscr"
ent 0xD4C8 "sscr"
ent 0x2216 "ssetmn"
ent 0x2323 "ssmile"
ent 0x22C6 "sstarf"
ent 0x2605 "starf"
ent 0x22C6 "Star"
ent 0x2606 "star"
ent 0x03F5 "straightepsilon"
ent 0x03D5 "straightphi"
ent 0x00AF "strns"
ent 0x2ABD "subdot"
ent 0x2AC3 "subedot"
ent 0x2286 "sube"
ent 0x2AC5 "subE"
ent 0x2AC1 "submult"
ent 0x228A "subne"
ent 0x2ACB "subnE"
ent 0x2ABF "subplus"
ent 0x2979 "subrarr"
ent 0x2AC5 "subseteqq"
ent 0x2286 "subseteq"
ent 0x2286 "SubsetEqual"
ent 0x2ACB "subsetneqq"
ent 0x228A "subsetneq"
ent 0x2282 "subset"
ent 0x22D0 "Subset"
ent 0x2AC7 "subsim"
ent 0x2AD5 "subsub"
ent 0x2AD3 "subsup"
ent 0x2282 "sub"
ent 0x22D0 "Sub"
ent 0x2AB8 "succapprox"
ent 0x227D "succcurlyeq"
ent 0x2AB0 "SucceedsEqual"
ent 0x227D "SucceedsSlantEqual"
ent 0x227F "SucceedsTilde"
ent 0x227B "Succeeds"
ent 0x2AB0 "succeq"
ent 0x2ABA "succnapprox"
ent 0x2AB6 "succneqq"
ent 0x22E9 "succnsim"
ent 0x227F "succsim"
ent 0x227B "succ"
ent 0x220B "SuchThat"
ent 0x2211 "sum"
ent 0x2211 "Sum"
ent 0x266A "sung"
ent 0x00B9 "sup1"
ent 0x00B2 "sup2"
ent 0x00B3 "sup3"
ent 0x2ABE "supdot"
ent 0x2AD8 "supdsub"
ent 0x2AC4 "supedot"
ent 0x2287 "SupersetEqual"
ent 0x2283 "Superset"
ent 0x2287 "supe"
ent 0x2AC6 "supE"
ent 0x27C9 "suphsol"
ent 0x2AD7 "suphsub"
ent 0x297B "suplarr"
ent 0x2AC2 "supmult"
ent 0x228B "supne"
ent 0x2ACC "supnE"
ent 0x2AC0 "supplus"
ent 0x2AC6 "supseteqq"
ent 0x2287 "supseteq"
ent 0x2ACC "supsetneqq"
ent 0x228B "supsetneq"
ent 0x2283 "supset"
ent 0x22D1 "Supset"
ent 0x2AC8 "supsim"
ent 0x2AD4 "supsub"
ent 0x2AD6 "supsup"
ent 0x2283 "sup"
ent 0x22D1 "Sup"
ent 0x2926 "swarhk"
ent 0x2199 "swarrow"
ent 0x2199 "swarr"
ent 0x21D9 "swArr"
ent 0x292A "swnwar"
ent 0x00DF "szlig"
ent 0x0009 "Tab"
ent 0x2316 "target"
ent 0x03A4 "Tau"
ent 0x03C4 "tau"
ent 0x23B4 "tbrk"
ent 0x0164 "Tcaron"
ent 0x0165 "tcaron"
ent 0x0162 "Tcedil"
ent 0x0163 "tcedil"
ent 0x0422 "Tcy"
ent 0x0442 "tcy"
ent 0x20DB "tdot"
ent 0x2315 "telrec"
ent 0xD517 "Tfr"
ent 0xD531 "tfr"
ent 0x2234 "there4"
ent 0x2234 "therefore"
ent 0x2234 "Therefore"
ent 0x03D1 "thetasym"
ent 0x0398 "Theta"
ent 0x03B8 "theta"
ent 0x03D1 "thetav"
ent 0x2248 "thickapprox"
ent 0x223C "thicksim"
ent 0x205F200A "ThickSpace"
ent 0x2009 "ThinSpace"
ent 0x2009 "thinsp"
ent 0x2248 "thkap"
ent 0x223C "thksim"
ent 0x00DE "THORN"
ent 0x00FE "thorn"
ent 0x2243 "TildeEqual"
ent 0x2245 "TildeFullEqual"
ent 0x2248 "TildeTilde"
ent 0x02DC "tilde"
ent 0x223C "Tilde"
ent 0x2A31 "timesbar"
ent 0x22A0 "timesb"
ent 0x2A30 "timesd"
ent 0x00D7 "times"
ent 0x222D "tint"
ent 0x2928 "toea"
ent 0x2336 "topbot"
ent 0x2AF1 "topcir"
ent 0x2ADA "topfork"
ent 0xD54B "Topf"
ent 0xD565 "topf"
ent 0x22A4 "top"
ent 0x2929 "tosa"
ent 0x2034 "tprime"
ent 0x2122 "trade"
ent 0x2122 "TRADE"
ent 0x25BF "triangledown"
ent 0x22B4 "trianglelefteq"
ent 0x25C3 "triangleleft"
ent 0x225C "triangleq"
ent 0x22B5 "trianglerighteq"
ent 0x25B9 "triangleright"
ent 0x25B5 "triangle"
ent 0x25EC "tridot"
ent 0x225C "trie"
ent 0x2A3A "triminus"
ent 0x20DB "TripleDot"
ent 0x2A39 "triplus"
ent 0x29CD "trisb"
ent 0x2A3B "tritime"
ent 0x23E2 "trpezium"
ent 0xD4AF "Tscr"
ent 0xD4C9 "tscr"
ent 0x0426 "TScy"
ent 0x0446 "tscy"
ent 0x040B "TSHcy"
ent 0x045B "tshcy"
ent 0x0166 "Tstrok"
ent 0x0167 "tstrok"
ent 0x226C "twixt"
ent 0x219E "twoheadleftarrow"
ent 0x21A0 "twoheadrightarrow"
ent 0x00DA "Uacute"
ent 0x00FA "uacute"
ent 0x2949 "Uarrocir"
ent 0x2191 "uarr"
ent 0x219F "Uarr"
ent 0x21D1 "uArr"
ent 0x040E "Ubrcy"
ent 0x045E "ubrcy"
ent 0x016C "Ubreve"
ent 0x016D "ubreve"
ent 0x00DB "Ucirc"
ent 0x00FB "ucirc"
ent 0x0423 "Ucy"
ent 0x0443 "ucy"
ent 0x21C5 "udarr"
ent 0x0170 "Udblac"
ent 0x0171 "udblac"
ent 0x296E "udhar"
ent 0x297E "ufisht"
ent 0xD518 "Ufr"
ent 0xD532 "ufr"
ent 0x00D9 "Ugrave"
ent 0x00F9 "ugrave"
ent 0x21BF "uharl"
ent 0x21BE "uharr"
ent 0x2963 "uHar"
ent 0x2580 "uhblk"
ent 0x231C "ulcorner"
ent 0x231C "ulcorn"
ent 0x230F "ulcrop"
ent 0x25F8 "ultri"
ent 0x016A "Umacr"
ent 0x016B "umacr"
ent 0x00A8 "uml"
ent 0x005F "UnderBar"
ent 0x23DF "UnderBrace"
ent 0x23B5 "UnderBracket"
ent 0x23DD "UnderParenthesis"
ent 0x228E "UnionPlus"
ent 0x22C3 "Union"
ent 0x0172 "Uogon"
ent 0x0173 "uogon"
ent 0xD54C "Uopf"
ent 0xD566 "uopf"
ent 0x2912 "UpArrowBar"
ent 0x21C5 "UpArrowDownArrow"
ent 0x2191 "uparrow"
ent 0x2191 "UpArrow"
ent 0x21D1 "Uparrow"
ent 0x2195 "updownarrow"
ent 0x2195 "UpDownArrow"
ent 0x21D5 "Updownarrow"
ent 0x296E "UpEquilibrium"
ent 0x21BF "upharpoonleft"
ent 0x21BE "upharpoonright"
ent 0x228E "uplus"
ent 0x2196 "UpperLeftArrow"
ent 0x2197 "UpperRightArrow"
ent 0x03D2 "upsih"
ent 0x03A5 "Upsilon"
ent 0x03C5 "upsilon"
ent 0x03C5 "upsi"
ent 0x03D2 "Upsi"
ent 0x21A5 "UpTeeArrow"
ent 0x22A5 "UpTee"
ent 0x21C8 "upuparrows"
ent 0x231D "urcorner"
ent 0x231D "urcorn"
ent 0x230E "urcrop"
ent 0x016E "Uring"
ent 0x016F "uring"
ent 0x25F9 "urtri"
ent 0xD4B0 "Uscr"
ent 0xD4CA "uscr"
ent 0x22F0 "utdot"
ent 0x0168 "Utilde"
ent 0x0169 "utilde"
ent 0x25B4 "utrif"
ent 0x25B5 "utri"
ent 0x21C8 "uuarr"
ent 0x00DC "Uuml"
ent 0x00FC "uuml"
ent 0x29A7 "uwangle"
ent 0x299C "vangrt"
ent 0x03F5 "varepsilon"
ent 0x03F0 "varkappa"
ent 0x2205 "varnothing"
ent 0x03D5 "varphi"
ent 0x03D6 "varpi"
ent 0x221D "varpropto"
ent 0x03F1 "varrho"
ent 0x2195 "varr"
ent 0x21D5 "vArr"
ent 0x03C2 "varsigma"
ent 0x2ACBFE00 "varsubsetneqq"
ent 0x228AFE00 "varsubsetneq"
ent 0x2ACCFE00 "varsupsetneqq"
ent 0x228BFE00 "varsupsetneq"
ent 0x03D1 "vartheta"
ent 0x22B2 "vartriangleleft"
ent 0x22B3 "vartriangleright"
ent 0x2AE8 "vBar"
ent 0x2AEB "Vbar"
ent 0x2AE9 "vBarv"
ent 0x0412 "Vcy"
ent 0x0432 "vcy"
ent 0x2AE6 "Vdashl"
ent 0x22A2 "vdash"
ent 0x22A8 "vDash"
ent 0x22A9 "Vdash"
ent 0x22AB "VDash"
ent 0x22BB "veebar"
ent 0x225A "veeeq"
ent 0x2228 "vee"
ent 0x22C1 "Vee"
ent 0x22EE "vellip"
ent 0x007C "verbar"
ent 0x2016 "Verbar"
ent 0x2223 "VerticalBar"
ent 0x007C "VerticalLine"
ent 0x2758 "VerticalSeparator"
ent 0x2240 "VerticalTilde"
ent 0x007C "vert"
ent 0x2016 "Vert"
ent 0x200A "VeryThinSpace"
ent 0xD519 "Vfr"
ent 0xD533 "vfr"
ent 0x22B2 "vltri"
ent 0x228220D2 "vnsub"
ent 0x228320D2 "vnsup"
ent 0xD54D "Vopf"
ent 0xD567 "vopf"
ent 0x221D "vprop"
ent 0x22B3 "vrtri"
ent 0xD4B1 "Vscr"
ent 0xD4CB "vscr"
ent 0x228AFE00 "vsubne"
ent 0x2ACBFE00 "vsubnE"
ent 0x228BFE00 "vsupne"
ent 0x2ACCFE00 "vsupnE"
ent 0x22AA "Vvdash"
ent 0x299A "vzigzag"
ent 0x0174 "Wcirc"
ent 0x0175 "wcirc"
ent 0x2A5F "wedbar"
ent 0x2259 "wedgeq"
ent 0x2227 "wedge"
ent 0x22C0 "Wedge"
ent 0x2118 "weierp"
ent 0xD51A "Wfr"
ent 0xD534 "wfr"
ent 0xD54E "Wopf"
ent 0xD568 "wopf"
ent 0x2118 "wp"
ent 0x2240 "wreath"
ent 0x2240 "wr"
ent 0xD4B2 "Wscr"
ent 0xD4CC "wscr"
ent 0x22C2 "xcap"
ent 0x25EF "xcirc"
ent 0x22C3 "xcup"
ent 0x25BD "xdtri"
ent 0xD51B "Xfr"
ent 0xD535 "xfr"
ent 0x27F7 "xharr"
ent 0x27FA "xhArr"
ent 0x039E "Xi"
ent 0x03BE "xi"
ent 0x27F5 "xlarr"
ent 0x27F8 "xlArr"
ent 0x27FC "xmap"
ent 0x22FB "xnis"
ent 0x2A00 "xodot"
ent 0xD54F "Xopf"
ent 0xD569 "xopf"
ent 0x2A01 "xoplus"
ent 0x2A02 "xotime"
ent 0x27F6 "xrarr"
ent 0x27F9 "xrArr"
ent 0xD4B3 "Xscr"
ent 0xD4CD "xscr"
ent 0x2A06 "xsqcup"
ent 0x2A04 "xuplus"
ent 0x25B3 "xutri"
ent 0x22C1 "xvee"
ent 0x22C0 "xwedge"
ent 0x00DD "Yacute"
ent 0x00FD "yacute"
ent 0x042F "YAcy"
ent 0x044F "yacy"
ent 0x0176 "Ycirc"
ent 0x0177 "ycirc"
ent 0x042B "Ycy"
ent 0x044B "ycy"
ent 0x00A5 "yen"
ent 0xD51C "Yfr"
ent 0xD536 "yfr"
ent 0x0407 "YIcy"
ent 0x0457 "yicy"
ent 0xD550 "Yopf"
ent 0xD56A "yopf"
ent 0xD4B4 "Yscr"
ent 0xD4CE "yscr"
ent 0x042E "YUcy"
ent 0x044E "yucy"
ent 0x00FF "yuml"
ent 0x0178 "Yuml"
ent 0x0179 "Zacute"
ent 0x017A "zacute"
ent 0x017D "Zcaron"
ent 0x017E "zcaron"
ent 0x0417 "Zcy"
ent 0x0437 "zcy"
ent 0x017B "Zdot"
ent 0x017C "zdot"
ent 0x2128 "zeetrf"
ent 0x200B "ZeroWidthSpace"
ent 0x0396 "Zeta"
ent 0x03B6 "zeta"
ent 0x2128 "Zfr"
ent 0xD537 "zfr"
ent 0x0416 "ZHcy"
ent 0x0436 "zhcy"
ent 0x21DD "zigrarr"
ent 0x2124 "Zopf"
ent 0xD56B "zopf"
ent 0xD4B5 "Zscr"
ent 0xD4CF "zscr"
ent 0x200D "zwj"
ent 0x200C "zwnj"
