#define RUNTIME_ICU
#include "CharClassesICU.cpp"
#include <stdio.h>

/// Usage:
/// g++ -O2 ./CharClasses_mk.cpp -o /tmp/CharClasses_mk -licuuc && /tmp/CharClasses_mk > CharClasses.cpp

template <class FN>
	static void WriteFunc(const char *name, FN fn)
{
	UChar32 c, last = 0x10ffff;
	UChar32 start = 0;
	printf("bool CharClasses::%s()\n", name);
	printf("{\n");
	printf("\tswitch (_c) {\n");
	for (c = 1; c <= last + 1; ++c) {
		const bool matched = (c <= last) && fn(c);
		if (matched) {
			if (!start) {
				start = c;
			}

		} else if (start) {
			if (start + 2 == c) {
				printf("\t\tcase 0x%x: case 0x%x:\n", (unsigned int)start, (unsigned int)c - 1);
			} else if (start + 1 < c) {
				printf("\t\tcase 0x%x ... 0x%x:\n", (unsigned int)start, (unsigned int)c - 1);
			} else {
				//printf("(c == 0x%x)\n", (unsigned int)start);
				printf("\t\tcase 0x%x:\n", (unsigned int)start);
			}
			start = 0;
		}
	}
	printf("\t\t\treturn true;\n");
	printf("\t\tdefault: return false;\n");
	printf("\t}\n");
	printf("}\n\n");
}

int main()
{
//	printf("%u\n", u_getIntPropertyValue(0xcbe, UCHAR_GENERAL_CATEGORY));
//	return -1;
	UChar32 c, last = 0x10ffff;
	UChar32 unstable_start = 0;
	bool first = true;
	printf("// this file autogenerated by CharClasses_mk.cpp\n\n");
	printf("#include <wchar.h>\n");
	printf("#include \"../include/CharClasses.h\"\n\n");

	WriteFunc("FullWidth", [](wchar_t c)->bool {
		return CharClasses(c).FullWidth();
	});

	WriteFunc("Prefix", [](wchar_t c)->bool {
		return CharClasses(c).Prefix();
	});

	WriteFunc("Suffix", [](wchar_t c)->bool {
		return CharClasses(c).Suffix();
	});
}
