//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armappcontainers

import "time"

// AllowedAudiencesValidation - The configuration settings of the Allowed Audiences validation flow.
type AllowedAudiencesValidation struct {
	// The configuration settings of the allowed list of audiences from which to validate the JWT token.
	AllowedAudiences []*string `json:"allowedAudiences,omitempty"`
}

// AllowedPrincipals - The configuration settings of the Azure Active Directory allowed principals.
type AllowedPrincipals struct {
	// The list of the allowed groups.
	Groups []*string `json:"groups,omitempty"`

	// The list of the allowed identities.
	Identities []*string `json:"identities,omitempty"`
}

// AppLogsConfiguration - Configuration of application logs
type AppLogsConfiguration struct {
	// Logs destination
	Destination *string `json:"destination,omitempty"`

	// Log Analytics configuration
	LogAnalyticsConfiguration *LogAnalyticsConfiguration `json:"logAnalyticsConfiguration,omitempty"`
}

// AppRegistration - The configuration settings of the app registration for providers that have app ids and app secrets
type AppRegistration struct {
	// The App ID of the app used for login.
	AppID *string `json:"appId,omitempty"`

	// The app setting name that contains the app secret.
	AppSecretSettingName *string `json:"appSecretSettingName,omitempty"`
}

// Apple - The configuration settings of the Apple provider.
type Apple struct {
	// false if the Apple provider should not be enabled despite the set registration; otherwise, true.
	Enabled *bool `json:"enabled,omitempty"`

	// The configuration settings of the login flow.
	Login *LoginScopes `json:"login,omitempty"`

	// The configuration settings of the Apple registration.
	Registration *AppleRegistration `json:"registration,omitempty"`
}

// AppleRegistration - The configuration settings of the registration for the Apple provider
type AppleRegistration struct {
	// The Client ID of the app used for login.
	ClientID *string `json:"clientId,omitempty"`

	// The app setting name that contains the client secret.
	ClientSecretSettingName *string `json:"clientSecretSettingName,omitempty"`
}

// AuthConfig - Configuration settings for the Azure ContainerApp Service Authentication / Authorization feature.
type AuthConfig struct {
	// AuthConfig resource specific properties
	Properties *AuthConfigProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// AuthConfigCollection - AuthConfig collection ARM resource.
type AuthConfigCollection struct {
	// REQUIRED; Collection of resources.
	Value []*AuthConfig `json:"value,omitempty"`

	// READ-ONLY; Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// AuthConfigProperties - AuthConfig resource specific properties
type AuthConfigProperties struct {
	// The configuration settings that determines the validation flow of users using Service Authentication/Authorization.
	GlobalValidation *GlobalValidation `json:"globalValidation,omitempty"`

	// The configuration settings of the HTTP requests for authentication and authorization requests made against ContainerApp
	// Service Authentication/Authorization.
	HTTPSettings *HTTPSettings `json:"httpSettings,omitempty"`

	// The configuration settings of each of the identity providers used to configure ContainerApp Service Authentication/Authorization.
	IdentityProviders *IdentityProviders `json:"identityProviders,omitempty"`

	// The configuration settings of the login flow of users using ContainerApp Service Authentication/Authorization.
	Login *Login `json:"login,omitempty"`

	// The configuration settings of the platform of ContainerApp Service Authentication/Authorization.
	Platform *AuthPlatform `json:"platform,omitempty"`
}

// AuthPlatform - The configuration settings of the platform of ContainerApp Service Authentication/Authorization.
type AuthPlatform struct {
	// true if the Authentication / Authorization feature is enabled for the current app; otherwise, false.
	Enabled *bool `json:"enabled,omitempty"`

	// The RuntimeVersion of the Authentication / Authorization feature in use for the current app. The setting in this value
	// can control the behavior of certain features in the Authentication /
	// Authorization module.
	RuntimeVersion *string `json:"runtimeVersion,omitempty"`
}

// AvailableOperations - Available operations of the service
type AvailableOperations struct {
	// URL client should use to fetch the next page (per server side paging). It's null for now, added for future use.
	NextLink *string `json:"nextLink,omitempty"`

	// Collection of available operation details
	Value []*OperationDetail `json:"value,omitempty"`
}

// AvailableWorkloadProfile - A premium workload profile.
type AvailableWorkloadProfile struct {
	// Region of the workload profile.
	Location *string `json:"location,omitempty"`

	// Revision resource specific properties
	Properties *AvailableWorkloadProfileProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// AvailableWorkloadProfileProperties - Revision resource specific properties
type AvailableWorkloadProfileProperties struct {
	// indicates whether the profile is default for the location.
	Applicability *Applicability `json:"applicability,omitempty"`

	// Used to map workload profile types to billing meter.
	BillingMeterCategory *Category `json:"billingMeterCategory,omitempty"`

	// Number of cores in CPU.
	Cores *int32 `json:"cores,omitempty"`

	// The everyday name of the workload profile.
	DisplayName *string `json:"displayName,omitempty"`

	// Memory in GiB.
	MemoryGiB *int32 `json:"memoryGiB,omitempty"`
}

// AvailableWorkloadProfilesClientGetOptions contains the optional parameters for the AvailableWorkloadProfilesClient.Get
// method.
type AvailableWorkloadProfilesClientGetOptions struct {
	// placeholder for future optional parameters
}

// AvailableWorkloadProfilesCollection - Collection of available workload profiles in the location.
type AvailableWorkloadProfilesCollection struct {
	// REQUIRED; Collection of workload profiles.
	Value []*AvailableWorkloadProfile `json:"value,omitempty"`

	// READ-ONLY; Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// AzureActiveDirectory - The configuration settings of the Azure Active directory provider.
type AzureActiveDirectory struct {
	// false if the Azure Active Directory provider should not be enabled despite the set registration; otherwise, true.
	Enabled *bool `json:"enabled,omitempty"`

	// Gets a value indicating whether the Azure AD configuration was auto-provisioned using 1st party tooling. This is an internal
	// flag primarily intended to support the Azure Management Portal. Users
	// should not read or write to this property.
	IsAutoProvisioned *bool `json:"isAutoProvisioned,omitempty"`

	// The configuration settings of the Azure Active Directory login flow.
	Login *AzureActiveDirectoryLogin `json:"login,omitempty"`

	// The configuration settings of the Azure Active Directory app registration.
	Registration *AzureActiveDirectoryRegistration `json:"registration,omitempty"`

	// The configuration settings of the Azure Active Directory token validation flow.
	Validation *AzureActiveDirectoryValidation `json:"validation,omitempty"`
}

// AzureActiveDirectoryLogin - The configuration settings of the Azure Active Directory login flow.
type AzureActiveDirectoryLogin struct {
	// true if the www-authenticate provider should be omitted from the request; otherwise, false.
	DisableWWWAuthenticate *bool `json:"disableWWWAuthenticate,omitempty"`

	// Login parameters to send to the OpenID Connect authorization endpoint when a user logs in. Each parameter must be in the
	// form "key=value".
	LoginParameters []*string `json:"loginParameters,omitempty"`
}

// AzureActiveDirectoryRegistration - The configuration settings of the Azure Active Directory app registration.
type AzureActiveDirectoryRegistration struct {
	// The Client ID of this relying party application, known as the clientid. This setting is required for enabling OpenID Connection
	// authentication with Azure Active Directory or other 3rd party OpenID
	// Connect providers. More information on OpenID Connect: http://openid.net/specs/openid-connect-core-10.html
	ClientID *string `json:"clientId,omitempty"`

	// An alternative to the client secret thumbprint, that is the issuer of a certificate used for signing purposes. This property
	// acts as a replacement for the Client Secret Certificate Thumbprint. It is
	// also optional.
	ClientSecretCertificateIssuer *string `json:"clientSecretCertificateIssuer,omitempty"`

	// An alternative to the client secret thumbprint, that is the subject alternative name of a certificate used for signing
	// purposes. This property acts as a replacement for the Client Secret Certificate
	// Thumbprint. It is also optional.
	ClientSecretCertificateSubjectAlternativeName *string `json:"clientSecretCertificateSubjectAlternativeName,omitempty"`

	// An alternative to the client secret, that is the thumbprint of a certificate used for signing purposes. This property acts
	// as a replacement for the Client Secret. It is also optional.
	ClientSecretCertificateThumbprint *string `json:"clientSecretCertificateThumbprint,omitempty"`

	// The app setting name that contains the client secret of the relying party application.
	ClientSecretSettingName *string `json:"clientSecretSettingName,omitempty"`

	// The OpenID Connect Issuer URI that represents the entity which issues access tokens for this application. When using Azure
	// Active Directory, this value is the URI of the directory tenant, e.g.
	// https://login.microsoftonline.com/v2.0/{tenant-guid}/. This URI is a case-sensitive identifier for the token issuer. More
	// information on OpenID Connect Discovery:
	// http://openid.net/specs/openid-connect-discovery-1_0.html
	OpenIDIssuer *string `json:"openIdIssuer,omitempty"`
}

// AzureActiveDirectoryValidation - The configuration settings of the Azure Active Directory token validation flow.
type AzureActiveDirectoryValidation struct {
	// The list of audiences that can make successful authentication/authorization requests.
	AllowedAudiences []*string `json:"allowedAudiences,omitempty"`

	// The configuration settings of the default authorization policy.
	DefaultAuthorizationPolicy *DefaultAuthorizationPolicy `json:"defaultAuthorizationPolicy,omitempty"`

	// The configuration settings of the checks that should be made while validating the JWT Claims.
	JwtClaimChecks *JwtClaimChecks `json:"jwtClaimChecks,omitempty"`
}

// AzureCredentials - Container App credentials.
type AzureCredentials struct {
	// Client Id.
	ClientID *string `json:"clientId,omitempty"`

	// Client Secret.
	ClientSecret *string `json:"clientSecret,omitempty"`

	// Subscription Id.
	SubscriptionID *string `json:"subscriptionId,omitempty"`

	// Tenant Id.
	TenantID *string `json:"tenantId,omitempty"`
}

// AzureFileProperties - Azure File Properties.
type AzureFileProperties struct {
	// Access mode for storage
	AccessMode *AccessMode `json:"accessMode,omitempty"`

	// Storage account key for azure file.
	AccountKey *string `json:"accountKey,omitempty"`

	// Storage account name for azure file.
	AccountName *string `json:"accountName,omitempty"`

	// Azure file share name.
	ShareName *string `json:"shareName,omitempty"`
}

// AzureStaticWebApps - The configuration settings of the Azure Static Web Apps provider.
type AzureStaticWebApps struct {
	// false if the Azure Static Web Apps provider should not be enabled despite the set registration; otherwise, true.
	Enabled *bool `json:"enabled,omitempty"`

	// The configuration settings of the Azure Static Web Apps registration.
	Registration *AzureStaticWebAppsRegistration `json:"registration,omitempty"`
}

// AzureStaticWebAppsRegistration - The configuration settings of the registration for the Azure Static Web Apps provider
type AzureStaticWebAppsRegistration struct {
	// The Client ID of the app used for login.
	ClientID *string `json:"clientId,omitempty"`
}

// BaseContainer - Container App base container definition.
type BaseContainer struct {
	// Container start command arguments.
	Args []*string `json:"args,omitempty"`

	// Container start command.
	Command []*string `json:"command,omitempty"`

	// Container environment variables.
	Env []*EnvironmentVar `json:"env,omitempty"`

	// Container image tag.
	Image *string `json:"image,omitempty"`

	// Custom container name.
	Name *string `json:"name,omitempty"`

	// Container resource requirements.
	Resources *ContainerResources `json:"resources,omitempty"`

	// Container volume mounts.
	VolumeMounts []*VolumeMount `json:"volumeMounts,omitempty"`
}

// BillingMeter - A premium billing meter.
type BillingMeter struct {
	// Region for the billing meter.
	Location *string `json:"location,omitempty"`

	// Revision resource specific properties
	Properties *BillingMeterProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// BillingMeterCollection - Collection of premium workload billing meters.
type BillingMeterCollection struct {
	// REQUIRED; Collection of billing meters.
	Value []*BillingMeter `json:"value,omitempty"`
}

// BillingMeterProperties - Revision resource specific properties
type BillingMeterProperties struct {
	// Used to map workload profile types to billing meter.
	Category *Category `json:"category,omitempty"`

	// The everyday name of the billing meter.
	DisplayName *string `json:"displayName,omitempty"`

	// Billing meter type.
	MeterType *string `json:"meterType,omitempty"`
}

// BillingMetersClientGetOptions contains the optional parameters for the BillingMetersClient.Get method.
type BillingMetersClientGetOptions struct {
	// placeholder for future optional parameters
}

// Certificate used for Custom Domain bindings of Container Apps in a Managed Environment
type Certificate struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string `json:"location,omitempty"`

	// Certificate resource specific properties
	Properties *CertificateProperties `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// CertificateCollection - Collection of Certificates.
type CertificateCollection struct {
	// REQUIRED; Collection of resources.
	Value []*Certificate `json:"value,omitempty"`

	// READ-ONLY; Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// CertificatePatch - A certificate to update
type CertificatePatch struct {
	// Application-specific metadata in the form of key-value pairs.
	Tags map[string]*string `json:"tags,omitempty"`
}

// CertificateProperties - Certificate resource specific properties
type CertificateProperties struct {
	// Certificate password.
	Password *string `json:"password,omitempty"`

	// PFX or PEM blob
	Value []byte `json:"value,omitempty"`

	// READ-ONLY; Certificate expiration date.
	ExpirationDate *time.Time `json:"expirationDate,omitempty" azure:"ro"`

	// READ-ONLY; Certificate issue Date.
	IssueDate *time.Time `json:"issueDate,omitempty" azure:"ro"`

	// READ-ONLY; Certificate issuer.
	Issuer *string `json:"issuer,omitempty" azure:"ro"`

	// READ-ONLY; Provisioning state of the certificate.
	ProvisioningState *CertificateProvisioningState `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; Public key hash.
	PublicKeyHash *string `json:"publicKeyHash,omitempty" azure:"ro"`

	// READ-ONLY; Subject alternative names the certificate applies to.
	SubjectAlternativeNames []*string `json:"subjectAlternativeNames,omitempty" azure:"ro"`

	// READ-ONLY; Subject name of the certificate.
	SubjectName *string `json:"subjectName,omitempty" azure:"ro"`

	// READ-ONLY; Certificate thumbprint.
	Thumbprint *string `json:"thumbprint,omitempty" azure:"ro"`

	// READ-ONLY; Is the certificate valid?.
	Valid *bool `json:"valid,omitempty" azure:"ro"`
}

// CertificatesClientCreateOrUpdateOptions contains the optional parameters for the CertificatesClient.CreateOrUpdate method.
type CertificatesClientCreateOrUpdateOptions struct {
	// Certificate to be created or updated
	CertificateEnvelope *Certificate
}

// CertificatesClientDeleteOptions contains the optional parameters for the CertificatesClient.Delete method.
type CertificatesClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// CertificatesClientGetOptions contains the optional parameters for the CertificatesClient.Get method.
type CertificatesClientGetOptions struct {
	// placeholder for future optional parameters
}

// CertificatesClientListOptions contains the optional parameters for the CertificatesClient.List method.
type CertificatesClientListOptions struct {
	// placeholder for future optional parameters
}

// CertificatesClientUpdateOptions contains the optional parameters for the CertificatesClient.Update method.
type CertificatesClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// CheckNameAvailabilityRequest - The check availability request body.
type CheckNameAvailabilityRequest struct {
	// The name of the resource for which availability needs to be checked.
	Name *string `json:"name,omitempty"`

	// The resource type.
	Type *string `json:"type,omitempty"`
}

// CheckNameAvailabilityResponse - The check availability result.
type CheckNameAvailabilityResponse struct {
	// Detailed reason why the given name is available.
	Message *string `json:"message,omitempty"`

	// Indicates if the resource name is available.
	NameAvailable *bool `json:"nameAvailable,omitempty"`

	// The reason why the given name is not available.
	Reason *CheckNameAvailabilityReason `json:"reason,omitempty"`
}

// ClientRegistration - The configuration settings of the app registration for providers that have client ids and client secrets
type ClientRegistration struct {
	// The Client ID of the app used for login.
	ClientID *string `json:"clientId,omitempty"`

	// The app setting name that contains the client secret.
	ClientSecretSettingName *string `json:"clientSecretSettingName,omitempty"`
}

// Configuration - Non versioned Container App configuration properties that define the mutable settings of a Container app
type Configuration struct {
	// ActiveRevisionsMode controls how active revisions are handled for the Container app:Multiple: multiple revisions can be
	// active.Single: Only one revision can be active at a time. Revision weights can
	// not be used in this mode. If no value if provided, this is the default.
	ActiveRevisionsMode *ActiveRevisionsMode `json:"activeRevisionsMode,omitempty"`

	// Dapr configuration for the Container App.
	Dapr *Dapr `json:"dapr,omitempty"`

	// Ingress configurations.
	Ingress *Ingress `json:"ingress,omitempty"`

	// Optional. Max inactive revisions a Container App can have.
	MaxInactiveRevisions *int32 `json:"maxInactiveRevisions,omitempty"`

	// Collection of private container registry credentials for containers used by the Container app
	Registries []*RegistryCredentials `json:"registries,omitempty"`

	// Collection of secrets used by a Container app
	Secrets []*Secret `json:"secrets,omitempty"`
}

// ConnectedEnvironment - An environment for Kubernetes cluster specialized for web workloads by Azure App Service
type ConnectedEnvironment struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string `json:"location,omitempty"`

	// The complex type of the extended location.
	ExtendedLocation *ExtendedLocation `json:"extendedLocation,omitempty"`

	// ConnectedEnvironment resource specific properties
	Properties *ConnectedEnvironmentProperties `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ConnectedEnvironmentCollection - Collection of connectedEnvironments
type ConnectedEnvironmentCollection struct {
	// Collection of resources.
	Value []*ConnectedEnvironment `json:"value,omitempty"`

	// READ-ONLY; Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// ConnectedEnvironmentProperties - ConnectedEnvironment resource specific properties
type ConnectedEnvironmentProperties struct {
	// Custom domain configuration for the environment
	CustomDomainConfiguration *CustomDomainConfiguration `json:"customDomainConfiguration,omitempty"`

	// Application Insights connection string used by Dapr to export Service to Service communication telemetry
	DaprAIConnectionString *string `json:"daprAIConnectionString,omitempty"`

	// Static IP of the connectedEnvironment
	StaticIP *string `json:"staticIp,omitempty"`

	// READ-ONLY; Default Domain Name for the cluster
	DefaultDomain *string `json:"defaultDomain,omitempty" azure:"ro"`

	// READ-ONLY; Any errors that occurred during deployment or deployment validation
	DeploymentErrors *string `json:"deploymentErrors,omitempty" azure:"ro"`

	// READ-ONLY; Provisioning state of the Kubernetes Environment.
	ProvisioningState *ConnectedEnvironmentProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// ConnectedEnvironmentStorage - Storage resource for connectedEnvironment.
type ConnectedEnvironmentStorage struct {
	// Storage properties
	Properties *ConnectedEnvironmentStorageProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ConnectedEnvironmentStorageProperties - Storage properties
type ConnectedEnvironmentStorageProperties struct {
	// Azure file properties
	AzureFile *AzureFileProperties `json:"azureFile,omitempty"`
}

// ConnectedEnvironmentStoragesCollection - Collection of Storage for Environments
type ConnectedEnvironmentStoragesCollection struct {
	// REQUIRED; Collection of storage resources.
	Value []*ConnectedEnvironmentStorage `json:"value,omitempty"`
}

// ConnectedEnvironmentsCertificatesClientCreateOrUpdateOptions contains the optional parameters for the ConnectedEnvironmentsCertificatesClient.CreateOrUpdate
// method.
type ConnectedEnvironmentsCertificatesClientCreateOrUpdateOptions struct {
	// Certificate to be created or updated
	CertificateEnvelope *Certificate
}

// ConnectedEnvironmentsCertificatesClientDeleteOptions contains the optional parameters for the ConnectedEnvironmentsCertificatesClient.Delete
// method.
type ConnectedEnvironmentsCertificatesClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// ConnectedEnvironmentsCertificatesClientGetOptions contains the optional parameters for the ConnectedEnvironmentsCertificatesClient.Get
// method.
type ConnectedEnvironmentsCertificatesClientGetOptions struct {
	// placeholder for future optional parameters
}

// ConnectedEnvironmentsCertificatesClientListOptions contains the optional parameters for the ConnectedEnvironmentsCertificatesClient.List
// method.
type ConnectedEnvironmentsCertificatesClientListOptions struct {
	// placeholder for future optional parameters
}

// ConnectedEnvironmentsCertificatesClientUpdateOptions contains the optional parameters for the ConnectedEnvironmentsCertificatesClient.Update
// method.
type ConnectedEnvironmentsCertificatesClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// ConnectedEnvironmentsClientBeginCreateOrUpdateOptions contains the optional parameters for the ConnectedEnvironmentsClient.BeginCreateOrUpdate
// method.
type ConnectedEnvironmentsClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ConnectedEnvironmentsClientBeginDeleteOptions contains the optional parameters for the ConnectedEnvironmentsClient.BeginDelete
// method.
type ConnectedEnvironmentsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ConnectedEnvironmentsClientCheckNameAvailabilityOptions contains the optional parameters for the ConnectedEnvironmentsClient.CheckNameAvailability
// method.
type ConnectedEnvironmentsClientCheckNameAvailabilityOptions struct {
	// placeholder for future optional parameters
}

// ConnectedEnvironmentsClientGetOptions contains the optional parameters for the ConnectedEnvironmentsClient.Get method.
type ConnectedEnvironmentsClientGetOptions struct {
	// placeholder for future optional parameters
}

// ConnectedEnvironmentsClientListByResourceGroupOptions contains the optional parameters for the ConnectedEnvironmentsClient.ListByResourceGroup
// method.
type ConnectedEnvironmentsClientListByResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// ConnectedEnvironmentsClientListBySubscriptionOptions contains the optional parameters for the ConnectedEnvironmentsClient.ListBySubscription
// method.
type ConnectedEnvironmentsClientListBySubscriptionOptions struct {
	// placeholder for future optional parameters
}

// ConnectedEnvironmentsClientUpdateOptions contains the optional parameters for the ConnectedEnvironmentsClient.Update method.
type ConnectedEnvironmentsClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// ConnectedEnvironmentsDaprComponentsClientCreateOrUpdateOptions contains the optional parameters for the ConnectedEnvironmentsDaprComponentsClient.CreateOrUpdate
// method.
type ConnectedEnvironmentsDaprComponentsClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// ConnectedEnvironmentsDaprComponentsClientDeleteOptions contains the optional parameters for the ConnectedEnvironmentsDaprComponentsClient.Delete
// method.
type ConnectedEnvironmentsDaprComponentsClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// ConnectedEnvironmentsDaprComponentsClientGetOptions contains the optional parameters for the ConnectedEnvironmentsDaprComponentsClient.Get
// method.
type ConnectedEnvironmentsDaprComponentsClientGetOptions struct {
	// placeholder for future optional parameters
}

// ConnectedEnvironmentsDaprComponentsClientListOptions contains the optional parameters for the ConnectedEnvironmentsDaprComponentsClient.List
// method.
type ConnectedEnvironmentsDaprComponentsClientListOptions struct {
	// placeholder for future optional parameters
}

// ConnectedEnvironmentsDaprComponentsClientListSecretsOptions contains the optional parameters for the ConnectedEnvironmentsDaprComponentsClient.ListSecrets
// method.
type ConnectedEnvironmentsDaprComponentsClientListSecretsOptions struct {
	// placeholder for future optional parameters
}

// ConnectedEnvironmentsStoragesClientCreateOrUpdateOptions contains the optional parameters for the ConnectedEnvironmentsStoragesClient.CreateOrUpdate
// method.
type ConnectedEnvironmentsStoragesClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// ConnectedEnvironmentsStoragesClientDeleteOptions contains the optional parameters for the ConnectedEnvironmentsStoragesClient.Delete
// method.
type ConnectedEnvironmentsStoragesClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// ConnectedEnvironmentsStoragesClientGetOptions contains the optional parameters for the ConnectedEnvironmentsStoragesClient.Get
// method.
type ConnectedEnvironmentsStoragesClientGetOptions struct {
	// placeholder for future optional parameters
}

// ConnectedEnvironmentsStoragesClientListOptions contains the optional parameters for the ConnectedEnvironmentsStoragesClient.List
// method.
type ConnectedEnvironmentsStoragesClientListOptions struct {
	// placeholder for future optional parameters
}

// Container App container definition
type Container struct {
	// Container start command arguments.
	Args []*string `json:"args,omitempty"`

	// Container start command.
	Command []*string `json:"command,omitempty"`

	// Container environment variables.
	Env []*EnvironmentVar `json:"env,omitempty"`

	// Container image tag.
	Image *string `json:"image,omitempty"`

	// Custom container name.
	Name *string `json:"name,omitempty"`

	// List of probes for the container.
	Probes []*ContainerAppProbe `json:"probes,omitempty"`

	// Container resource requirements.
	Resources *ContainerResources `json:"resources,omitempty"`

	// Container volume mounts.
	VolumeMounts []*VolumeMount `json:"volumeMounts,omitempty"`
}

// ContainerApp - Container App.
type ContainerApp struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string `json:"location,omitempty"`

	// The complex type of the extended location.
	ExtendedLocation *ExtendedLocation `json:"extendedLocation,omitempty"`

	// managed identities for the Container App to interact with other Azure services without maintaining any secrets or credentials
	// in code.
	Identity *ManagedServiceIdentity `json:"identity,omitempty"`

	// ContainerApp resource specific properties
	Properties *ContainerAppProperties `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ContainerAppAuthToken - Container App Auth Token.
type ContainerAppAuthToken struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string `json:"location,omitempty"`

	// Container App auth token resource specific properties
	Properties *ContainerAppAuthTokenProperties `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ContainerAppAuthTokenProperties - Container App auth token resource specific properties
type ContainerAppAuthTokenProperties struct {
	// READ-ONLY; Token expiration date.
	Expires *time.Time `json:"expires,omitempty" azure:"ro"`

	// READ-ONLY; Auth token value.
	Token *string `json:"token,omitempty" azure:"ro"`
}

// ContainerAppCollection - Container App collection ARM resource.
type ContainerAppCollection struct {
	// REQUIRED; Collection of resources.
	Value []*ContainerApp `json:"value,omitempty"`

	// READ-ONLY; Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// ContainerAppProbe - Probe describes a health check to be performed against a container to determine whether it is alive
// or ready to receive traffic.
type ContainerAppProbe struct {
	// Minimum consecutive failures for the probe to be considered failed after having succeeded. Defaults to 3. Minimum value
	// is 1. Maximum value is 10.
	FailureThreshold *int32 `json:"failureThreshold,omitempty"`

	// HTTPGet specifies the http request to perform.
	HTTPGet *ContainerAppProbeHTTPGet `json:"httpGet,omitempty"`

	// Number of seconds after the container has started before liveness probes are initiated. Minimum value is 1. Maximum value
	// is 60.
	InitialDelaySeconds *int32 `json:"initialDelaySeconds,omitempty"`

	// How often (in seconds) to perform the probe. Default to 10 seconds. Minimum value is 1. Maximum value is 240.
	PeriodSeconds *int32 `json:"periodSeconds,omitempty"`

	// Minimum consecutive successes for the probe to be considered successful after having failed. Defaults to 1. Must be 1 for
	// liveness and startup. Minimum value is 1. Maximum value is 10.
	SuccessThreshold *int32 `json:"successThreshold,omitempty"`

	// TCPSocket specifies an action involving a TCP port. TCP hooks not yet supported.
	TCPSocket *ContainerAppProbeTCPSocket `json:"tcpSocket,omitempty"`

	// Optional duration in seconds the pod needs to terminate gracefully upon probe failure. The grace period is the duration
	// in seconds after the processes running in the pod are sent a termination signal
	// and the time when the processes are forcibly halted with a kill signal. Set this value longer than the expected cleanup
	// time for your process. If this value is nil, the pod's
	// terminationGracePeriodSeconds will be used. Otherwise, this value overrides the value provided by the pod spec. Value must
	// be non-negative integer. The value zero indicates stop immediately via the
	// kill signal (no opportunity to shut down). This is an alpha field and requires enabling ProbeTerminationGracePeriod feature
	// gate. Maximum value is 3600 seconds (1 hour)
	TerminationGracePeriodSeconds *int64 `json:"terminationGracePeriodSeconds,omitempty"`

	// Number of seconds after which the probe times out. Defaults to 1 second. Minimum value is 1. Maximum value is 240.
	TimeoutSeconds *int32 `json:"timeoutSeconds,omitempty"`

	// The type of probe.
	Type *Type `json:"type,omitempty"`
}

// ContainerAppProbeHTTPGet - HTTPGet specifies the http request to perform.
type ContainerAppProbeHTTPGet struct {
	// REQUIRED; Name or number of the port to access on the container. Number must be in the range 1 to 65535. Name must be an
	// IANASVCNAME.
	Port *int32 `json:"port,omitempty"`

	// Custom headers to set in the request. HTTP allows repeated headers.
	HTTPHeaders []*ContainerAppProbeHTTPGetHTTPHeadersItem `json:"httpHeaders,omitempty"`

	// Host name to connect to, defaults to the pod IP. You probably want to set "Host" in httpHeaders instead.
	Host *string `json:"host,omitempty"`

	// Path to access on the HTTP server.
	Path *string `json:"path,omitempty"`

	// Scheme to use for connecting to the host. Defaults to HTTP.
	Scheme *Scheme `json:"scheme,omitempty"`
}

// ContainerAppProbeHTTPGetHTTPHeadersItem - HTTPHeader describes a custom header to be used in HTTP probes
type ContainerAppProbeHTTPGetHTTPHeadersItem struct {
	// REQUIRED; The header field name
	Name *string `json:"name,omitempty"`

	// REQUIRED; The header field value
	Value *string `json:"value,omitempty"`
}

// ContainerAppProbeTCPSocket - TCPSocket specifies an action involving a TCP port. TCP hooks not yet supported.
type ContainerAppProbeTCPSocket struct {
	// REQUIRED; Number or name of the port to access on the container. Number must be in the range 1 to 65535. Name must be an
	// IANASVCNAME.
	Port *int32 `json:"port,omitempty"`

	// Optional: Host name to connect to, defaults to the pod IP.
	Host *string `json:"host,omitempty"`
}

// ContainerAppProperties - ContainerApp resource specific properties
type ContainerAppProperties struct {
	// Non versioned Container App configuration properties.
	Configuration *Configuration `json:"configuration,omitempty"`

	// Resource ID of environment.
	EnvironmentID *string `json:"environmentId,omitempty"`

	// Deprecated. Resource ID of the Container App's environment.
	ManagedEnvironmentID *string `json:"managedEnvironmentId,omitempty"`

	// Container App versioned application definition.
	Template *Template `json:"template,omitempty"`

	// Workload profile type to pin for container app execution.
	WorkloadProfileType *string `json:"workloadProfileType,omitempty"`

	// READ-ONLY; Id used to verify domain name ownership
	CustomDomainVerificationID *string `json:"customDomainVerificationId,omitempty" azure:"ro"`

	// READ-ONLY; The endpoint of the eventstream of the container app.
	EventStreamEndpoint *string `json:"eventStreamEndpoint,omitempty" azure:"ro"`

	// READ-ONLY; Fully Qualified Domain Name of the latest revision of the Container App.
	LatestRevisionFqdn *string `json:"latestRevisionFqdn,omitempty" azure:"ro"`

	// READ-ONLY; Name of the latest revision of the Container App.
	LatestRevisionName *string `json:"latestRevisionName,omitempty" azure:"ro"`

	// READ-ONLY; Outbound IP Addresses for container app.
	OutboundIPAddresses []*string `json:"outboundIPAddresses,omitempty" azure:"ro"`

	// READ-ONLY; Provisioning state of the Container App.
	ProvisioningState *ContainerAppProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// ContainerAppSecret - Container App Secret.
type ContainerAppSecret struct {
	// READ-ONLY; Secret Name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Secret Value.
	Value *string `json:"value,omitempty" azure:"ro"`
}

// ContainerAppsAuthConfigsClientCreateOrUpdateOptions contains the optional parameters for the ContainerAppsAuthConfigsClient.CreateOrUpdate
// method.
type ContainerAppsAuthConfigsClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// ContainerAppsAuthConfigsClientDeleteOptions contains the optional parameters for the ContainerAppsAuthConfigsClient.Delete
// method.
type ContainerAppsAuthConfigsClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// ContainerAppsAuthConfigsClientGetOptions contains the optional parameters for the ContainerAppsAuthConfigsClient.Get method.
type ContainerAppsAuthConfigsClientGetOptions struct {
	// placeholder for future optional parameters
}

// ContainerAppsAuthConfigsClientListByContainerAppOptions contains the optional parameters for the ContainerAppsAuthConfigsClient.ListByContainerApp
// method.
type ContainerAppsAuthConfigsClientListByContainerAppOptions struct {
	// placeholder for future optional parameters
}

// ContainerAppsClientBeginCreateOrUpdateOptions contains the optional parameters for the ContainerAppsClient.BeginCreateOrUpdate
// method.
type ContainerAppsClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ContainerAppsClientBeginDeleteOptions contains the optional parameters for the ContainerAppsClient.BeginDelete method.
type ContainerAppsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ContainerAppsClientBeginUpdateOptions contains the optional parameters for the ContainerAppsClient.BeginUpdate method.
type ContainerAppsClientBeginUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ContainerAppsClientGetAuthTokenOptions contains the optional parameters for the ContainerAppsClient.GetAuthToken method.
type ContainerAppsClientGetAuthTokenOptions struct {
	// placeholder for future optional parameters
}

// ContainerAppsClientGetOptions contains the optional parameters for the ContainerAppsClient.Get method.
type ContainerAppsClientGetOptions struct {
	// placeholder for future optional parameters
}

// ContainerAppsClientListByResourceGroupOptions contains the optional parameters for the ContainerAppsClient.ListByResourceGroup
// method.
type ContainerAppsClientListByResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// ContainerAppsClientListBySubscriptionOptions contains the optional parameters for the ContainerAppsClient.ListBySubscription
// method.
type ContainerAppsClientListBySubscriptionOptions struct {
	// placeholder for future optional parameters
}

// ContainerAppsClientListCustomHostNameAnalysisOptions contains the optional parameters for the ContainerAppsClient.ListCustomHostNameAnalysis
// method.
type ContainerAppsClientListCustomHostNameAnalysisOptions struct {
	// Custom hostname.
	CustomHostname *string
}

// ContainerAppsClientListSecretsOptions contains the optional parameters for the ContainerAppsClient.ListSecrets method.
type ContainerAppsClientListSecretsOptions struct {
	// placeholder for future optional parameters
}

// ContainerAppsDiagnosticsClientGetDetectorOptions contains the optional parameters for the ContainerAppsDiagnosticsClient.GetDetector
// method.
type ContainerAppsDiagnosticsClientGetDetectorOptions struct {
	// placeholder for future optional parameters
}

// ContainerAppsDiagnosticsClientGetRevisionOptions contains the optional parameters for the ContainerAppsDiagnosticsClient.GetRevision
// method.
type ContainerAppsDiagnosticsClientGetRevisionOptions struct {
	// placeholder for future optional parameters
}

// ContainerAppsDiagnosticsClientGetRootOptions contains the optional parameters for the ContainerAppsDiagnosticsClient.GetRoot
// method.
type ContainerAppsDiagnosticsClientGetRootOptions struct {
	// placeholder for future optional parameters
}

// ContainerAppsDiagnosticsClientListDetectorsOptions contains the optional parameters for the ContainerAppsDiagnosticsClient.ListDetectors
// method.
type ContainerAppsDiagnosticsClientListDetectorsOptions struct {
	// placeholder for future optional parameters
}

// ContainerAppsDiagnosticsClientListRevisionsOptions contains the optional parameters for the ContainerAppsDiagnosticsClient.ListRevisions
// method.
type ContainerAppsDiagnosticsClientListRevisionsOptions struct {
	// The filter to apply on the operation.
	Filter *string
}

// ContainerAppsRevisionReplicasClientGetReplicaOptions contains the optional parameters for the ContainerAppsRevisionReplicasClient.GetReplica
// method.
type ContainerAppsRevisionReplicasClientGetReplicaOptions struct {
	// placeholder for future optional parameters
}

// ContainerAppsRevisionReplicasClientListReplicasOptions contains the optional parameters for the ContainerAppsRevisionReplicasClient.ListReplicas
// method.
type ContainerAppsRevisionReplicasClientListReplicasOptions struct {
	// placeholder for future optional parameters
}

// ContainerAppsRevisionsClientActivateRevisionOptions contains the optional parameters for the ContainerAppsRevisionsClient.ActivateRevision
// method.
type ContainerAppsRevisionsClientActivateRevisionOptions struct {
	// placeholder for future optional parameters
}

// ContainerAppsRevisionsClientDeactivateRevisionOptions contains the optional parameters for the ContainerAppsRevisionsClient.DeactivateRevision
// method.
type ContainerAppsRevisionsClientDeactivateRevisionOptions struct {
	// placeholder for future optional parameters
}

// ContainerAppsRevisionsClientGetRevisionOptions contains the optional parameters for the ContainerAppsRevisionsClient.GetRevision
// method.
type ContainerAppsRevisionsClientGetRevisionOptions struct {
	// placeholder for future optional parameters
}

// ContainerAppsRevisionsClientListRevisionsOptions contains the optional parameters for the ContainerAppsRevisionsClient.ListRevisions
// method.
type ContainerAppsRevisionsClientListRevisionsOptions struct {
	// The filter to apply on the operation.
	Filter *string
}

// ContainerAppsRevisionsClientRestartRevisionOptions contains the optional parameters for the ContainerAppsRevisionsClient.RestartRevision
// method.
type ContainerAppsRevisionsClientRestartRevisionOptions struct {
	// placeholder for future optional parameters
}

// ContainerAppsSourceControlsClientBeginCreateOrUpdateOptions contains the optional parameters for the ContainerAppsSourceControlsClient.BeginCreateOrUpdate
// method.
type ContainerAppsSourceControlsClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ContainerAppsSourceControlsClientBeginDeleteOptions contains the optional parameters for the ContainerAppsSourceControlsClient.BeginDelete
// method.
type ContainerAppsSourceControlsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ContainerAppsSourceControlsClientGetOptions contains the optional parameters for the ContainerAppsSourceControlsClient.Get
// method.
type ContainerAppsSourceControlsClientGetOptions struct {
	// placeholder for future optional parameters
}

// ContainerAppsSourceControlsClientListByContainerAppOptions contains the optional parameters for the ContainerAppsSourceControlsClient.ListByContainerApp
// method.
type ContainerAppsSourceControlsClientListByContainerAppOptions struct {
	// placeholder for future optional parameters
}

// ContainerResources - Container App container resource requirements.
type ContainerResources struct {
	// Required CPU in cores, e.g. 0.5
	CPU *float64 `json:"cpu,omitempty"`

	// Required memory, e.g. "250Mb"
	Memory *string `json:"memory,omitempty"`

	// READ-ONLY; Ephemeral Storage, e.g. "1Gi"
	EphemeralStorage *string `json:"ephemeralStorage,omitempty" azure:"ro"`
}

// CookieExpiration - The configuration settings of the session cookie's expiration.
type CookieExpiration struct {
	// The convention used when determining the session cookie's expiration.
	Convention *CookieExpirationConvention `json:"convention,omitempty"`

	// The time after the request is made when the session cookie should expire.
	TimeToExpiration *string `json:"timeToExpiration,omitempty"`
}

// CustomDomain - Custom Domain of a Container App
type CustomDomain struct {
	// REQUIRED; Resource Id of the Certificate to be bound to this hostname. Must exist in the Managed Environment.
	CertificateID *string `json:"certificateId,omitempty"`

	// REQUIRED; Hostname.
	Name *string `json:"name,omitempty"`

	// Custom Domain binding type.
	BindingType *BindingType `json:"bindingType,omitempty"`
}

// CustomDomainConfiguration - Configuration properties for apps environment custom domain
type CustomDomainConfiguration struct {
	// Certificate password
	CertificatePassword []byte `json:"certificatePassword,omitempty"`

	// PFX or PEM blob
	CertificateValue []byte `json:"certificateValue,omitempty"`

	// Dns suffix for the environment domain
	DNSSuffix *string `json:"dnsSuffix,omitempty"`

	// READ-ONLY; Id used to verify domain name ownership
	CustomDomainVerificationID *string `json:"customDomainVerificationId,omitempty" azure:"ro"`

	// READ-ONLY; Certificate expiration date.
	ExpirationDate *time.Time `json:"expirationDate,omitempty" azure:"ro"`

	// READ-ONLY; Subject name of the certificate.
	SubjectName *string `json:"subjectName,omitempty" azure:"ro"`

	// READ-ONLY; Certificate thumbprint.
	Thumbprint *string `json:"thumbprint,omitempty" azure:"ro"`
}

// CustomHostnameAnalysisResult - Custom domain analysis.
type CustomHostnameAnalysisResult struct {
	// A records visible for this hostname.
	ARecords []*string `json:"aRecords,omitempty"`

	// Alternate CName records visible for this hostname.
	AlternateCNameRecords []*string `json:"alternateCNameRecords,omitempty"`

	// Alternate TXT records visible for this hostname.
	AlternateTxtRecords []*string `json:"alternateTxtRecords,omitempty"`

	// CName records visible for this hostname.
	CNameRecords []*string `json:"cNameRecords,omitempty"`

	// TXT records visible for this hostname.
	TxtRecords []*string `json:"txtRecords,omitempty"`

	// READ-ONLY; true if there is a conflict on the Container App's managed environment level custom domain; otherwise, false.
	ConflictWithEnvironmentCustomDomain *bool `json:"conflictWithEnvironmentCustomDomain,omitempty" azure:"ro"`

	// READ-ONLY; Name of the conflicting Container App on the Managed Environment if it's within the same subscription.
	ConflictingContainerAppResourceID *string `json:"conflictingContainerAppResourceId,omitempty" azure:"ro"`

	// READ-ONLY; Raw failure information if DNS verification fails.
	CustomDomainVerificationFailureInfo *CustomHostnameAnalysisResultCustomDomainVerificationFailureInfo `json:"customDomainVerificationFailureInfo,omitempty" azure:"ro"`

	// READ-ONLY; DNS verification test result.
	CustomDomainVerificationTest *DNSVerificationTestResult `json:"customDomainVerificationTest,omitempty" azure:"ro"`

	// READ-ONLY; true if there is a conflict on the Container App's managed environment; otherwise, false.
	HasConflictOnManagedEnvironment *bool `json:"hasConflictOnManagedEnvironment,omitempty" azure:"ro"`

	// READ-ONLY; Host name that was analyzed
	HostName *string `json:"hostName,omitempty" azure:"ro"`

	// READ-ONLY; true if hostname is already verified; otherwise, false.
	IsHostnameAlreadyVerified *bool `json:"isHostnameAlreadyVerified,omitempty" azure:"ro"`
}

// CustomHostnameAnalysisResultCustomDomainVerificationFailureInfo - Raw failure information if DNS verification fails.
type CustomHostnameAnalysisResultCustomDomainVerificationFailureInfo struct {
	// Details or the error
	Details []*CustomHostnameAnalysisResultCustomDomainVerificationFailureInfoDetailsItem `json:"details,omitempty"`

	// READ-ONLY; Standardized string to programmatically identify the error.
	Code *string `json:"code,omitempty" azure:"ro"`

	// READ-ONLY; Detailed error description and debugging information.
	Message *string `json:"message,omitempty" azure:"ro"`

	// READ-ONLY; Detailed error description and debugging information.
	Target *string `json:"target,omitempty" azure:"ro"`
}

// CustomHostnameAnalysisResultCustomDomainVerificationFailureInfoDetailsItem - Detailed errors.
type CustomHostnameAnalysisResultCustomDomainVerificationFailureInfoDetailsItem struct {
	// READ-ONLY; Standardized string to programmatically identify the error.
	Code *string `json:"code,omitempty" azure:"ro"`

	// READ-ONLY; Detailed error description and debugging information.
	Message *string `json:"message,omitempty" azure:"ro"`

	// READ-ONLY; Detailed error description and debugging information.
	Target *string `json:"target,omitempty" azure:"ro"`
}

// CustomOpenIDConnectProvider - The configuration settings of the custom Open ID Connect provider.
type CustomOpenIDConnectProvider struct {
	// false if the custom Open ID provider provider should not be enabled; otherwise, true.
	Enabled *bool `json:"enabled,omitempty"`

	// The configuration settings of the login flow of the custom Open ID Connect provider.
	Login *OpenIDConnectLogin `json:"login,omitempty"`

	// The configuration settings of the app registration for the custom Open ID Connect provider.
	Registration *OpenIDConnectRegistration `json:"registration,omitempty"`
}

// CustomScaleRule - Container App container Custom scaling rule.
type CustomScaleRule struct {
	// Authentication secrets for the custom scale rule.
	Auth []*ScaleRuleAuth `json:"auth,omitempty"`

	// Metadata properties to describe custom scale rule.
	Metadata map[string]*string `json:"metadata,omitempty"`

	// Type of the custom scale rule eg: azure-servicebus, redis etc.
	Type *string `json:"type,omitempty"`
}

// Dapr - Container App Dapr configuration.
type Dapr struct {
	// Dapr application identifier
	AppID *string `json:"appId,omitempty"`

	// Tells Dapr which port your application is listening on
	AppPort *int32 `json:"appPort,omitempty"`

	// Tells Dapr which protocol your application is using. Valid options are http and grpc. Default is http
	AppProtocol *AppProtocol `json:"appProtocol,omitempty"`

	// Enables API logging for the Dapr sidecar
	EnableAPILogging *bool `json:"enableApiLogging,omitempty"`

	// Boolean indicating if the Dapr side car is enabled
	Enabled *bool `json:"enabled,omitempty"`

	// Increasing max size of request body http and grpc servers parameter in MB to handle uploading of big files. Default is
	// 4 MB.
	HTTPMaxRequestSize *int32 `json:"httpMaxRequestSize,omitempty"`

	// Dapr max size of http header read buffer in KB to handle when sending multi-KB headers. Default is 65KB.
	HTTPReadBufferSize *int32 `json:"httpReadBufferSize,omitempty"`

	// Sets the log level for the Dapr sidecar. Allowed values are debug, info, warn, error. Default is info.
	LogLevel *LogLevel `json:"logLevel,omitempty"`
}

// DaprComponent - Dapr Component.
type DaprComponent struct {
	// Dapr Component resource specific properties
	Properties *DaprComponentProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// DaprComponentProperties - Dapr Component resource specific properties
type DaprComponentProperties struct {
	// Component type
	ComponentType *string `json:"componentType,omitempty"`

	// Boolean describing if the component errors are ignores
	IgnoreErrors *bool `json:"ignoreErrors,omitempty"`

	// Initialization timeout
	InitTimeout *string `json:"initTimeout,omitempty"`

	// Component metadata
	Metadata []*DaprMetadata `json:"metadata,omitempty"`

	// Names of container apps that can use this Dapr component
	Scopes []*string `json:"scopes,omitempty"`

	// Name of a Dapr component to retrieve component secrets from
	SecretStoreComponent *string `json:"secretStoreComponent,omitempty"`

	// Collection of secrets used by a Dapr component
	Secrets []*Secret `json:"secrets,omitempty"`

	// Component version
	Version *string `json:"version,omitempty"`
}

// DaprComponentsClientCreateOrUpdateOptions contains the optional parameters for the DaprComponentsClient.CreateOrUpdate
// method.
type DaprComponentsClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// DaprComponentsClientDeleteOptions contains the optional parameters for the DaprComponentsClient.Delete method.
type DaprComponentsClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// DaprComponentsClientGetOptions contains the optional parameters for the DaprComponentsClient.Get method.
type DaprComponentsClientGetOptions struct {
	// placeholder for future optional parameters
}

// DaprComponentsClientListOptions contains the optional parameters for the DaprComponentsClient.List method.
type DaprComponentsClientListOptions struct {
	// placeholder for future optional parameters
}

// DaprComponentsClientListSecretsOptions contains the optional parameters for the DaprComponentsClient.ListSecrets method.
type DaprComponentsClientListSecretsOptions struct {
	// placeholder for future optional parameters
}

// DaprComponentsCollection - Dapr Components ARM resource.
type DaprComponentsCollection struct {
	// REQUIRED; Collection of resources.
	Value []*DaprComponent `json:"value,omitempty"`

	// READ-ONLY; Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// DaprMetadata - Dapr component metadata.
type DaprMetadata struct {
	// Metadata property name.
	Name *string `json:"name,omitempty"`

	// Name of the Dapr Component secret from which to pull the metadata property value.
	SecretRef *string `json:"secretRef,omitempty"`

	// Metadata property value.
	Value *string `json:"value,omitempty"`
}

// DaprSecret - Dapr component Secret for ListSecrets Action
type DaprSecret struct {
	// READ-ONLY; Secret Name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Secret Value.
	Value *string `json:"value,omitempty" azure:"ro"`
}

// DaprSecretsCollection - Dapr component Secrets Collection for ListSecrets Action.
type DaprSecretsCollection struct {
	// REQUIRED; Collection of secrets used by a Dapr component
	Value []*Secret `json:"value,omitempty"`
}

// DefaultAuthorizationPolicy - The configuration settings of the Azure Active Directory default authorization policy.
type DefaultAuthorizationPolicy struct {
	// The configuration settings of the Azure Active Directory allowed applications.
	AllowedApplications []*string `json:"allowedApplications,omitempty"`

	// The configuration settings of the Azure Active Directory allowed principals.
	AllowedPrincipals *AllowedPrincipals `json:"allowedPrincipals,omitempty"`
}

// DefaultErrorResponse - App Service error response.
type DefaultErrorResponse struct {
	// READ-ONLY; Error model.
	Error *DefaultErrorResponseError `json:"error,omitempty" azure:"ro"`
}

// DefaultErrorResponseError - Error model.
type DefaultErrorResponseError struct {
	// Details or the error
	Details []*DefaultErrorResponseErrorDetailsItem `json:"details,omitempty"`

	// READ-ONLY; Standardized string to programmatically identify the error.
	Code *string `json:"code,omitempty" azure:"ro"`

	// READ-ONLY; More information to debug error.
	Innererror *string `json:"innererror,omitempty" azure:"ro"`

	// READ-ONLY; Detailed error description and debugging information.
	Message *string `json:"message,omitempty" azure:"ro"`

	// READ-ONLY; Detailed error description and debugging information.
	Target *string `json:"target,omitempty" azure:"ro"`
}

// DefaultErrorResponseErrorDetailsItem - Detailed errors.
type DefaultErrorResponseErrorDetailsItem struct {
	// READ-ONLY; Standardized string to programmatically identify the error.
	Code *string `json:"code,omitempty" azure:"ro"`

	// READ-ONLY; Detailed error description and debugging information.
	Message *string `json:"message,omitempty" azure:"ro"`

	// READ-ONLY; Detailed error description and debugging information.
	Target *string `json:"target,omitempty" azure:"ro"`
}

// DiagnosticDataProviderMetadata - Details of a diagnostics data provider
type DiagnosticDataProviderMetadata struct {
	// Collection of properties
	PropertyBag []*DiagnosticDataProviderMetadataPropertyBagItem `json:"propertyBag,omitempty"`

	// Name of data provider
	ProviderName *string `json:"providerName,omitempty"`
}

// DiagnosticDataProviderMetadataPropertyBagItem - Property details
type DiagnosticDataProviderMetadataPropertyBagItem struct {
	// Property name
	Name *string `json:"name,omitempty"`

	// Property value
	Value *string `json:"value,omitempty"`
}

// DiagnosticDataTableResponseColumn - Diagnostics data column
type DiagnosticDataTableResponseColumn struct {
	// Column name
	ColumnName *string `json:"columnName,omitempty"`

	// Column type
	ColumnType *string `json:"columnType,omitempty"`

	// Data type of the column
	DataType *string `json:"dataType,omitempty"`
}

// DiagnosticDataTableResponseObject - Diagnostics data table
type DiagnosticDataTableResponseObject struct {
	// Columns in the table
	Columns []*DiagnosticDataTableResponseColumn `json:"columns,omitempty"`

	// Rows in the table
	Rows []interface{} `json:"rows,omitempty"`

	// Table name
	TableName *string `json:"tableName,omitempty"`
}

// DiagnosticRendering - Rendering details of a diagnostics table
type DiagnosticRendering struct {
	// Description of the table
	Description *string `json:"description,omitempty"`

	// Flag if the table should be rendered
	IsVisible *bool `json:"isVisible,omitempty"`

	// Title of the table
	Title *string `json:"title,omitempty"`

	// Rendering type
	Type *int32 `json:"type,omitempty"`
}

// DiagnosticSupportTopic - Support topic information
type DiagnosticSupportTopic struct {
	// READ-ONLY; Unique topic identifier
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; PES identifier
	PesID *string `json:"pesId,omitempty" azure:"ro"`
}

// Diagnostics data for a resource.
type Diagnostics struct {
	// Diagnostics resource specific properties
	Properties *DiagnosticsProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// DiagnosticsCollection - Diagnostics data collection for a resource.
type DiagnosticsCollection struct {
	// REQUIRED; Collection of diagnostic data.
	Value []*Diagnostics `json:"value,omitempty"`

	// READ-ONLY; Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// DiagnosticsDataAPIResponse - Diagnostics data returned from a detector
type DiagnosticsDataAPIResponse struct {
	// Details of the table response
	RenderingProperties *DiagnosticRendering `json:"renderingProperties,omitempty"`

	// Table response
	Table *DiagnosticDataTableResponseObject `json:"table,omitempty"`
}

// DiagnosticsDefinition - Metadata of the diagnostics response
type DiagnosticsDefinition struct {
	// List of analysis types
	AnalysisTypes []*string `json:"analysisTypes,omitempty"`

	// List of support topics
	SupportTopicList []*DiagnosticSupportTopic `json:"supportTopicList,omitempty"`

	// READ-ONLY; Authors' names of the detector
	Author *string `json:"author,omitempty" azure:"ro"`

	// READ-ONLY; Category of the detector
	Category *string `json:"category,omitempty" azure:"ro"`

	// READ-ONLY; Details of the diagnostics info
	Description *string `json:"description,omitempty" azure:"ro"`

	// READ-ONLY; Unique detector name
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Display Name of the detector
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Authors' names of the detector
	Score *float32 `json:"score,omitempty" azure:"ro"`

	// READ-ONLY; Authors' names of the detector
	Type *string `json:"type,omitempty" azure:"ro"`
}

// DiagnosticsProperties - Diagnostics resource specific properties
type DiagnosticsProperties struct {
	// List of data providers' metadata.
	DataProviderMetadata *DiagnosticDataProviderMetadata `json:"dataProviderMetadata,omitempty"`

	// Set of data collections associated with the response.
	Dataset []*DiagnosticsDataAPIResponse `json:"dataset,omitempty"`

	// Metadata of the diagnostics response.
	Metadata *DiagnosticsDefinition `json:"metadata,omitempty"`

	// Status of the diagnostics response.
	Status *DiagnosticsStatus `json:"status,omitempty"`
}

// DiagnosticsStatus - Rendering details of a diagnostics table
type DiagnosticsStatus struct {
	// Diagnostic message
	Message *string `json:"message,omitempty"`

	// Status
	StatusID *int32 `json:"statusId,omitempty"`
}

// EnvironmentAuthToken - Environment Auth Token.
type EnvironmentAuthToken struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string `json:"location,omitempty"`

	// Environment auth token resource specific properties
	Properties *EnvironmentAuthTokenProperties `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// EnvironmentAuthTokenProperties - Environment auth token resource specific properties
type EnvironmentAuthTokenProperties struct {
	// READ-ONLY; Token expiration date.
	Expires *time.Time `json:"expires,omitempty" azure:"ro"`

	// READ-ONLY; Auth token value.
	Token *string `json:"token,omitempty" azure:"ro"`
}

// EnvironmentSKUProperties - Managed Environment resource SKU properties.
type EnvironmentSKUProperties struct {
	// REQUIRED; Name of the Sku.
	Name *SKUName `json:"name,omitempty"`
}

// EnvironmentVar - Container App container environment variable.
type EnvironmentVar struct {
	// Environment variable name.
	Name *string `json:"name,omitempty"`

	// Name of the Container App secret from which to pull the environment variable value.
	SecretRef *string `json:"secretRef,omitempty"`

	// Non-secret environment variable value.
	Value *string `json:"value,omitempty"`
}

// ErrorAdditionalInfo - The resource management error additional info.
type ErrorAdditionalInfo struct {
	// READ-ONLY; The additional info.
	Info interface{} `json:"info,omitempty" azure:"ro"`

	// READ-ONLY; The additional info type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ErrorDetail - The error detail.
type ErrorDetail struct {
	// READ-ONLY; The error additional info.
	AdditionalInfo []*ErrorAdditionalInfo `json:"additionalInfo,omitempty" azure:"ro"`

	// READ-ONLY; The error code.
	Code *string `json:"code,omitempty" azure:"ro"`

	// READ-ONLY; The error details.
	Details []*ErrorDetail `json:"details,omitempty" azure:"ro"`

	// READ-ONLY; The error message.
	Message *string `json:"message,omitempty" azure:"ro"`

	// READ-ONLY; The error target.
	Target *string `json:"target,omitempty" azure:"ro"`
}

// ErrorResponse - Common error response for all Azure Resource Manager APIs to return error details for failed operations.
// (This also follows the OData error response format.).
type ErrorResponse struct {
	// The error object.
	Error *ErrorDetail `json:"error,omitempty"`
}

// ExtendedLocation - The complex type of the extended location.
type ExtendedLocation struct {
	// The name of the extended location.
	Name *string `json:"name,omitempty"`

	// The type of the extended location.
	Type *ExtendedLocationTypes `json:"type,omitempty"`
}

// Facebook - The configuration settings of the Facebook provider.
type Facebook struct {
	// false if the Facebook provider should not be enabled despite the set registration; otherwise, true.
	Enabled *bool `json:"enabled,omitempty"`

	// The version of the Facebook api to be used while logging in.
	GraphAPIVersion *string `json:"graphApiVersion,omitempty"`

	// The configuration settings of the login flow.
	Login *LoginScopes `json:"login,omitempty"`

	// The configuration settings of the app registration for the Facebook provider.
	Registration *AppRegistration `json:"registration,omitempty"`
}

// ForwardProxy - The configuration settings of a forward proxy used to make the requests.
type ForwardProxy struct {
	// The convention used to determine the url of the request made.
	Convention *ForwardProxyConvention `json:"convention,omitempty"`

	// The name of the header containing the host of the request.
	CustomHostHeaderName *string `json:"customHostHeaderName,omitempty"`

	// The name of the header containing the scheme of the request.
	CustomProtoHeaderName *string `json:"customProtoHeaderName,omitempty"`
}

// GitHub - The configuration settings of the GitHub provider.
type GitHub struct {
	// false if the GitHub provider should not be enabled despite the set registration; otherwise, true.
	Enabled *bool `json:"enabled,omitempty"`

	// The configuration settings of the login flow.
	Login *LoginScopes `json:"login,omitempty"`

	// The configuration settings of the app registration for the GitHub provider.
	Registration *ClientRegistration `json:"registration,omitempty"`
}

// GithubActionConfiguration - Configuration properties that define the mutable settings of a Container App SourceControl
type GithubActionConfiguration struct {
	// AzureCredentials configurations.
	AzureCredentials *AzureCredentials `json:"azureCredentials,omitempty"`

	// Context path
	ContextPath *string `json:"contextPath,omitempty"`

	// Image name
	Image *string `json:"image,omitempty"`

	// Operation system
	OS *string `json:"os,omitempty"`

	// Code or Image
	PublishType *string `json:"publishType,omitempty"`

	// Registry configurations.
	RegistryInfo *RegistryInfo `json:"registryInfo,omitempty"`

	// Runtime stack
	RuntimeStack *string `json:"runtimeStack,omitempty"`

	// Runtime version
	RuntimeVersion *string `json:"runtimeVersion,omitempty"`
}

// GlobalValidation - The configuration settings that determines the validation flow of users using ContainerApp Service Authentication/Authorization.
type GlobalValidation struct {
	// The paths for which unauthenticated flow would not be redirected to the login page.
	ExcludedPaths []*string `json:"excludedPaths,omitempty"`

	// The default authentication provider to use when multiple providers are configured. This setting is only needed if multiple
	// providers are configured and the unauthenticated client action is set to
	// "RedirectToLoginPage".
	RedirectToProvider *string `json:"redirectToProvider,omitempty"`

	// The action to take when an unauthenticated client attempts to access the app.
	UnauthenticatedClientAction *UnauthenticatedClientActionV2 `json:"unauthenticatedClientAction,omitempty"`
}

// Google - The configuration settings of the Google provider.
type Google struct {
	// false if the Google provider should not be enabled despite the set registration; otherwise, true.
	Enabled *bool `json:"enabled,omitempty"`

	// The configuration settings of the login flow.
	Login *LoginScopes `json:"login,omitempty"`

	// The configuration settings of the app registration for the Google provider.
	Registration *ClientRegistration `json:"registration,omitempty"`

	// The configuration settings of the Azure Active Directory token validation flow.
	Validation *AllowedAudiencesValidation `json:"validation,omitempty"`
}

// HTTPScaleRule - Container App container Http scaling rule.
type HTTPScaleRule struct {
	// Authentication secrets for the custom scale rule.
	Auth []*ScaleRuleAuth `json:"auth,omitempty"`

	// Metadata properties to describe http scale rule.
	Metadata map[string]*string `json:"metadata,omitempty"`
}

// HTTPSettings - The configuration settings of the HTTP requests for authentication and authorization requests made against
// ContainerApp Service Authentication/Authorization.
type HTTPSettings struct {
	// The configuration settings of a forward proxy used to make the requests.
	ForwardProxy *ForwardProxy `json:"forwardProxy,omitempty"`

	// false if the authentication/authorization responses not having the HTTPS scheme are permissible; otherwise, true.
	RequireHTTPS *bool `json:"requireHttps,omitempty"`

	// The configuration settings of the paths HTTP requests.
	Routes *HTTPSettingsRoutes `json:"routes,omitempty"`
}

// HTTPSettingsRoutes - The configuration settings of the paths HTTP requests.
type HTTPSettingsRoutes struct {
	// The prefix that should precede all the authentication/authorization paths.
	APIPrefix *string `json:"apiPrefix,omitempty"`
}

// IPSecurityRestrictionRule - Rule to restrict incoming IP address.
type IPSecurityRestrictionRule struct {
	// REQUIRED; Allow or Deny rules to determine for incoming IP. Note: Rules can only consist of ALL Allow or ALL Deny
	Action *Action `json:"action,omitempty"`

	// REQUIRED; CIDR notation to match incoming IP address
	IPAddressRange *string `json:"ipAddressRange,omitempty"`

	// REQUIRED; Name for the IP restriction rule.
	Name *string `json:"name,omitempty"`

	// Describe the IP restriction rule that is being sent to the container-app. This is an optional field.
	Description *string `json:"description,omitempty"`
}

// IdentityProviders - The configuration settings of each of the identity providers used to configure ContainerApp Service
// Authentication/Authorization.
type IdentityProviders struct {
	// The configuration settings of the Apple provider.
	Apple *Apple `json:"apple,omitempty"`

	// The configuration settings of the Azure Active directory provider.
	AzureActiveDirectory *AzureActiveDirectory `json:"azureActiveDirectory,omitempty"`

	// The configuration settings of the Azure Static Web Apps provider.
	AzureStaticWebApps *AzureStaticWebApps `json:"azureStaticWebApps,omitempty"`

	// The map of the name of the alias of each custom Open ID Connect provider to the configuration settings of the custom Open
	// ID Connect provider.
	CustomOpenIDConnectProviders map[string]*CustomOpenIDConnectProvider `json:"customOpenIdConnectProviders,omitempty"`

	// The configuration settings of the Facebook provider.
	Facebook *Facebook `json:"facebook,omitempty"`

	// The configuration settings of the GitHub provider.
	GitHub *GitHub `json:"gitHub,omitempty"`

	// The configuration settings of the Google provider.
	Google *Google `json:"google,omitempty"`

	// The configuration settings of the Twitter provider.
	Twitter *Twitter `json:"twitter,omitempty"`
}

// Ingress - Container App Ingress configuration.
type Ingress struct {
	// Bool indicating if HTTP connections to is allowed. If set to false HTTP connections are automatically redirected to HTTPS
	// connections
	AllowInsecure *bool `json:"allowInsecure,omitempty"`

	// custom domain bindings for Container Apps' hostnames.
	CustomDomains []*CustomDomain `json:"customDomains,omitempty"`

	// Exposed Port in containers for TCP traffic from ingress
	ExposedPort *int32 `json:"exposedPort,omitempty"`

	// Bool indicating if app exposes an external http endpoint
	External *bool `json:"external,omitempty"`

	// Rules to restrict incoming IP address.
	IPSecurityRestrictions []*IPSecurityRestrictionRule `json:"ipSecurityRestrictions,omitempty"`

	// Target Port in containers for traffic from ingress
	TargetPort *int32 `json:"targetPort,omitempty"`

	// Traffic weights for app's revisions
	Traffic []*TrafficWeight `json:"traffic,omitempty"`

	// Ingress transport protocol
	Transport *IngressTransportMethod `json:"transport,omitempty"`

	// READ-ONLY; Hostname.
	Fqdn *string `json:"fqdn,omitempty" azure:"ro"`
}

// InitContainer - Container App init container definition
type InitContainer struct {
	// Container start command arguments.
	Args []*string `json:"args,omitempty"`

	// Container start command.
	Command []*string `json:"command,omitempty"`

	// Container environment variables.
	Env []*EnvironmentVar `json:"env,omitempty"`

	// Container image tag.
	Image *string `json:"image,omitempty"`

	// Custom container name.
	Name *string `json:"name,omitempty"`

	// Container resource requirements.
	Resources *ContainerResources `json:"resources,omitempty"`

	// Container volume mounts.
	VolumeMounts []*VolumeMount `json:"volumeMounts,omitempty"`
}

// JwtClaimChecks - The configuration settings of the checks that should be made while validating the JWT Claims.
type JwtClaimChecks struct {
	// The list of the allowed client applications.
	AllowedClientApplications []*string `json:"allowedClientApplications,omitempty"`

	// The list of the allowed groups.
	AllowedGroups []*string `json:"allowedGroups,omitempty"`
}

// LogAnalyticsConfiguration - Log analytics configuration
type LogAnalyticsConfiguration struct {
	// Log analytics customer id
	CustomerID *string `json:"customerId,omitempty"`

	// Log analytics customer key
	SharedKey *string `json:"sharedKey,omitempty"`
}

// Login - The configuration settings of the login flow of users using ContainerApp Service Authentication/Authorization.
type Login struct {
	// External URLs that can be redirected to as part of logging in or logging out of the app. Note that the query string part
	// of the URL is ignored. This is an advanced setting typically only needed by
	// Windows Store application backends. Note that URLs within the current domain are always implicitly allowed.
	AllowedExternalRedirectUrls []*string `json:"allowedExternalRedirectUrls,omitempty"`

	// The configuration settings of the session cookie's expiration.
	CookieExpiration *CookieExpiration `json:"cookieExpiration,omitempty"`

	// The configuration settings of the nonce used in the login flow.
	Nonce *Nonce `json:"nonce,omitempty"`

	// true if the fragments from the request are preserved after the login request is made; otherwise, false.
	PreserveURLFragmentsForLogins *bool `json:"preserveUrlFragmentsForLogins,omitempty"`

	// The routes that specify the endpoints used for login and logout requests.
	Routes *LoginRoutes `json:"routes,omitempty"`
}

// LoginRoutes - The routes that specify the endpoints used for login and logout requests.
type LoginRoutes struct {
	// The endpoint at which a logout request should be made.
	LogoutEndpoint *string `json:"logoutEndpoint,omitempty"`
}

// LoginScopes - The configuration settings of the login flow, including the scopes that should be requested.
type LoginScopes struct {
	// A list of the scopes that should be requested while authenticating.
	Scopes []*string `json:"scopes,omitempty"`
}

// ManagedEnvironment - An environment for hosting container apps
type ManagedEnvironment struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string `json:"location,omitempty"`

	// Managed environment resource specific properties
	Properties *ManagedEnvironmentProperties `json:"properties,omitempty"`

	// SKU properties of the Environment.
	SKU *EnvironmentSKUProperties `json:"sku,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ManagedEnvironmentDiagnosticsClientGetDetectorOptions contains the optional parameters for the ManagedEnvironmentDiagnosticsClient.GetDetector
// method.
type ManagedEnvironmentDiagnosticsClientGetDetectorOptions struct {
	// placeholder for future optional parameters
}

// ManagedEnvironmentDiagnosticsClientListDetectorsOptions contains the optional parameters for the ManagedEnvironmentDiagnosticsClient.ListDetectors
// method.
type ManagedEnvironmentDiagnosticsClientListDetectorsOptions struct {
	// placeholder for future optional parameters
}

// ManagedEnvironmentOutboundSettings - Configuration used to control the Environment Egress outbound traffic
type ManagedEnvironmentOutboundSettings struct {
	// Outbound type for the cluster
	OutBoundType *ManagedEnvironmentOutBoundType `json:"outBoundType,omitempty"`

	// Virtual Appliance IP used as the Egress controller for the Environment
	VirtualNetworkApplianceIP *string `json:"virtualNetworkApplianceIp,omitempty"`
}

// ManagedEnvironmentProperties - Managed environment resource specific properties
type ManagedEnvironmentProperties struct {
	// Cluster configuration which enables the log daemon to export app logs to a destination. Currently only "log-analytics"
	// is supported
	AppLogsConfiguration *AppLogsConfiguration `json:"appLogsConfiguration,omitempty"`

	// Custom domain configuration for the environment
	CustomDomainConfiguration *CustomDomainConfiguration `json:"customDomainConfiguration,omitempty"`

	// Application Insights connection string used by Dapr to export Service to Service communication telemetry
	DaprAIConnectionString *string `json:"daprAIConnectionString,omitempty"`

	// Azure Monitor instrumentation key used by Dapr to export Service to Service communication telemetry
	DaprAIInstrumentationKey *string `json:"daprAIInstrumentationKey,omitempty"`

	// Vnet configuration for the environment
	VnetConfiguration *VnetConfiguration `json:"vnetConfiguration,omitempty"`

	// Workload profiles configured for the Managed Environment.
	WorkloadProfiles []*WorkloadProfile `json:"workloadProfiles,omitempty"`

	// Whether or not this Managed Environment is zone-redundant.
	ZoneRedundant *bool `json:"zoneRedundant,omitempty"`

	// READ-ONLY; Default Domain Name for the cluster
	DefaultDomain *string `json:"defaultDomain,omitempty" azure:"ro"`

	// READ-ONLY; Any errors that occurred during deployment or deployment validation
	DeploymentErrors *string `json:"deploymentErrors,omitempty" azure:"ro"`

	// READ-ONLY; The endpoint of the eventstream of the Environment.
	EventStreamEndpoint *string `json:"eventStreamEndpoint,omitempty" azure:"ro"`

	// READ-ONLY; Provisioning state of the Environment.
	ProvisioningState *EnvironmentProvisioningState `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; Static IP of the Environment
	StaticIP *string `json:"staticIp,omitempty" azure:"ro"`
}

// ManagedEnvironmentStorage - Storage resource for managedEnvironment.
type ManagedEnvironmentStorage struct {
	// Storage properties
	Properties *ManagedEnvironmentStorageProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ManagedEnvironmentStorageProperties - Storage properties
type ManagedEnvironmentStorageProperties struct {
	// Azure file properties
	AzureFile *AzureFileProperties `json:"azureFile,omitempty"`
}

// ManagedEnvironmentStoragesCollection - Collection of Storage for Environments
type ManagedEnvironmentStoragesCollection struct {
	// REQUIRED; Collection of storage resources.
	Value []*ManagedEnvironmentStorage `json:"value,omitempty"`
}

// ManagedEnvironmentsClientBeginCreateOrUpdateOptions contains the optional parameters for the ManagedEnvironmentsClient.BeginCreateOrUpdate
// method.
type ManagedEnvironmentsClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ManagedEnvironmentsClientBeginDeleteOptions contains the optional parameters for the ManagedEnvironmentsClient.BeginDelete
// method.
type ManagedEnvironmentsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ManagedEnvironmentsClientBeginUpdateOptions contains the optional parameters for the ManagedEnvironmentsClient.BeginUpdate
// method.
type ManagedEnvironmentsClientBeginUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ManagedEnvironmentsClientGetAuthTokenOptions contains the optional parameters for the ManagedEnvironmentsClient.GetAuthToken
// method.
type ManagedEnvironmentsClientGetAuthTokenOptions struct {
	// placeholder for future optional parameters
}

// ManagedEnvironmentsClientGetOptions contains the optional parameters for the ManagedEnvironmentsClient.Get method.
type ManagedEnvironmentsClientGetOptions struct {
	// placeholder for future optional parameters
}

// ManagedEnvironmentsClientListByResourceGroupOptions contains the optional parameters for the ManagedEnvironmentsClient.ListByResourceGroup
// method.
type ManagedEnvironmentsClientListByResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// ManagedEnvironmentsClientListBySubscriptionOptions contains the optional parameters for the ManagedEnvironmentsClient.ListBySubscription
// method.
type ManagedEnvironmentsClientListBySubscriptionOptions struct {
	// placeholder for future optional parameters
}

// ManagedEnvironmentsClientListWorkloadProfileStatesOptions contains the optional parameters for the ManagedEnvironmentsClient.ListWorkloadProfileStates
// method.
type ManagedEnvironmentsClientListWorkloadProfileStatesOptions struct {
	// placeholder for future optional parameters
}

// ManagedEnvironmentsCollection - Collection of Environments
type ManagedEnvironmentsCollection struct {
	// REQUIRED; Collection of resources.
	Value []*ManagedEnvironment `json:"value,omitempty"`

	// READ-ONLY; Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// ManagedEnvironmentsDiagnosticsClientGetRootOptions contains the optional parameters for the ManagedEnvironmentsDiagnosticsClient.GetRoot
// method.
type ManagedEnvironmentsDiagnosticsClientGetRootOptions struct {
	// placeholder for future optional parameters
}

// ManagedEnvironmentsStoragesClientCreateOrUpdateOptions contains the optional parameters for the ManagedEnvironmentsStoragesClient.CreateOrUpdate
// method.
type ManagedEnvironmentsStoragesClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// ManagedEnvironmentsStoragesClientDeleteOptions contains the optional parameters for the ManagedEnvironmentsStoragesClient.Delete
// method.
type ManagedEnvironmentsStoragesClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// ManagedEnvironmentsStoragesClientGetOptions contains the optional parameters for the ManagedEnvironmentsStoragesClient.Get
// method.
type ManagedEnvironmentsStoragesClientGetOptions struct {
	// placeholder for future optional parameters
}

// ManagedEnvironmentsStoragesClientListOptions contains the optional parameters for the ManagedEnvironmentsStoragesClient.List
// method.
type ManagedEnvironmentsStoragesClientListOptions struct {
	// placeholder for future optional parameters
}

// ManagedServiceIdentity - Managed service identity (system assigned and/or user assigned identities)
type ManagedServiceIdentity struct {
	// REQUIRED; Type of managed service identity (where both SystemAssigned and UserAssigned types are allowed).
	Type *ManagedServiceIdentityType `json:"type,omitempty"`

	// The set of user assigned identities associated with the resource. The userAssignedIdentities dictionary keys will be ARM
	// resource ids in the form:
	// '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}.
	// The dictionary values can be empty objects ({}) in
	// requests.
	UserAssignedIdentities map[string]*UserAssignedIdentity `json:"userAssignedIdentities,omitempty"`

	// READ-ONLY; The service principal ID of the system assigned identity. This property will only be provided for a system assigned
	// identity.
	PrincipalID *string `json:"principalId,omitempty" azure:"ro"`

	// READ-ONLY; The tenant ID of the system assigned identity. This property will only be provided for a system assigned identity.
	TenantID *string `json:"tenantId,omitempty" azure:"ro"`
}

// NamespacesClientCheckNameAvailabilityOptions contains the optional parameters for the NamespacesClient.CheckNameAvailability
// method.
type NamespacesClientCheckNameAvailabilityOptions struct {
	// placeholder for future optional parameters
}

// Nonce - The configuration settings of the nonce used in the login flow.
type Nonce struct {
	// The time after the request is made when the nonce should expire.
	NonceExpirationInterval *string `json:"nonceExpirationInterval,omitempty"`

	// false if the nonce should not be validated while completing the login flow; otherwise, true.
	ValidateNonce *bool `json:"validateNonce,omitempty"`
}

// OpenIDConnectClientCredential - The authentication client credentials of the custom Open ID Connect provider.
type OpenIDConnectClientCredential struct {
	// The app setting that contains the client secret for the custom Open ID Connect provider.
	ClientSecretSettingName *string `json:"clientSecretSettingName,omitempty"`

	// The method that should be used to authenticate the user.
	Method *string `json:"method,omitempty"`
}

// OpenIDConnectConfig - The configuration settings of the endpoints used for the custom Open ID Connect provider.
type OpenIDConnectConfig struct {
	// The endpoint to be used to make an authorization request.
	AuthorizationEndpoint *string `json:"authorizationEndpoint,omitempty"`

	// The endpoint that provides the keys necessary to validate the token.
	CertificationURI *string `json:"certificationUri,omitempty"`

	// The endpoint that issues the token.
	Issuer *string `json:"issuer,omitempty"`

	// The endpoint to be used to request a token.
	TokenEndpoint *string `json:"tokenEndpoint,omitempty"`

	// The endpoint that contains all the configuration endpoints for the provider.
	WellKnownOpenIDConfiguration *string `json:"wellKnownOpenIdConfiguration,omitempty"`
}

// OpenIDConnectLogin - The configuration settings of the login flow of the custom Open ID Connect provider.
type OpenIDConnectLogin struct {
	// The name of the claim that contains the users name.
	NameClaimType *string `json:"nameClaimType,omitempty"`

	// A list of the scopes that should be requested while authenticating.
	Scopes []*string `json:"scopes,omitempty"`
}

// OpenIDConnectRegistration - The configuration settings of the app registration for the custom Open ID Connect provider.
type OpenIDConnectRegistration struct {
	// The authentication credentials of the custom Open ID Connect provider.
	ClientCredential *OpenIDConnectClientCredential `json:"clientCredential,omitempty"`

	// The client id of the custom Open ID Connect provider.
	ClientID *string `json:"clientId,omitempty"`

	// The configuration settings of the endpoints used for the custom Open ID Connect provider.
	OpenIDConnectConfiguration *OpenIDConnectConfig `json:"openIdConnectConfiguration,omitempty"`
}

// OperationDetail - Operation detail payload
type OperationDetail struct {
	// Display of the operation
	Display *OperationDisplay `json:"display,omitempty"`

	// Indicates whether the operation is a data action
	IsDataAction *bool `json:"isDataAction,omitempty"`

	// Name of the operation
	Name *string `json:"name,omitempty"`

	// Origin of the operation
	Origin *string `json:"origin,omitempty"`
}

// OperationDisplay - Operation display payload
type OperationDisplay struct {
	// Localized friendly description for the operation
	Description *string `json:"description,omitempty"`

	// Localized friendly name for the operation
	Operation *string `json:"operation,omitempty"`

	// Resource provider of the operation
	Provider *string `json:"provider,omitempty"`

	// Resource of the operation
	Resource *string `json:"resource,omitempty"`
}

// OperationsClientListOptions contains the optional parameters for the OperationsClient.List method.
type OperationsClientListOptions struct {
	// placeholder for future optional parameters
}

// ProxyResource - The resource model definition for a Azure Resource Manager proxy resource. It will not have tags and a
// location
type ProxyResource struct {
	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// QueueScaleRule - Container App container Azure Queue based scaling rule.
type QueueScaleRule struct {
	// Authentication secrets for the queue scale rule.
	Auth []*ScaleRuleAuth `json:"auth,omitempty"`

	// Queue length.
	QueueLength *int32 `json:"queueLength,omitempty"`

	// Queue name.
	QueueName *string `json:"queueName,omitempty"`
}

// RegistryCredentials - Container App Private Registry
type RegistryCredentials struct {
	// A Managed Identity to use to authenticate with Azure Container Registry. For user-assigned identities, use the full user-assigned
	// identity Resource ID. For system-assigned identities, use 'system'
	Identity *string `json:"identity,omitempty"`

	// The name of the Secret that contains the registry login password
	PasswordSecretRef *string `json:"passwordSecretRef,omitempty"`

	// Container Registry Server
	Server *string `json:"server,omitempty"`

	// Container Registry Username
	Username *string `json:"username,omitempty"`
}

// RegistryInfo - Container App registry information.
type RegistryInfo struct {
	// registry secret.
	RegistryPassword *string `json:"registryPassword,omitempty"`

	// registry server Url.
	RegistryURL *string `json:"registryUrl,omitempty"`

	// registry username.
	RegistryUserName *string `json:"registryUserName,omitempty"`
}

// Replica - Container App Revision Replica.
type Replica struct {
	// Replica resource specific properties
	Properties *ReplicaProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ReplicaCollection - Container App Revision Replicas collection ARM resource.
type ReplicaCollection struct {
	// REQUIRED; Collection of resources.
	Value []*Replica `json:"value,omitempty"`
}

// ReplicaContainer - Container object under Container App Revision Replica.
type ReplicaContainer struct {
	// The Id of the Container
	ContainerID *string `json:"containerId,omitempty"`

	// The Name of the Container
	Name *string `json:"name,omitempty"`

	// The container ready status
	Ready *bool `json:"ready,omitempty"`

	// The container restart count
	RestartCount *int32 `json:"restartCount,omitempty"`

	// The container start status
	Started *bool `json:"started,omitempty"`

	// READ-ONLY; Container exec endpoint
	ExecEndpoint *string `json:"execEndpoint,omitempty" azure:"ro"`

	// READ-ONLY; Log Stream endpoint
	LogStreamEndpoint *string `json:"logStreamEndpoint,omitempty" azure:"ro"`
}

// ReplicaProperties - Replica resource specific properties
type ReplicaProperties struct {
	// The containers collection under a replica.
	Containers []*ReplicaContainer `json:"containers,omitempty"`

	// READ-ONLY; Timestamp describing when the pod was created by controller
	CreatedTime *time.Time `json:"createdTime,omitempty" azure:"ro"`
}

// Resource - Common fields that are returned in the response for all Azure Resource Manager resources
type Resource struct {
	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// Revision - Container App Revision.
type Revision struct {
	// Revision resource specific properties
	Properties *RevisionProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// RevisionCollection - Container App Revisions collection ARM resource.
type RevisionCollection struct {
	// REQUIRED; Collection of resources.
	Value []*Revision `json:"value,omitempty"`

	// READ-ONLY; Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// RevisionProperties - Revision resource specific properties
type RevisionProperties struct {
	// READ-ONLY; Boolean describing if the Revision is Active
	Active *bool `json:"active,omitempty" azure:"ro"`

	// READ-ONLY; Timestamp describing when the revision was created by controller
	CreatedTime *time.Time `json:"createdTime,omitempty" azure:"ro"`

	// READ-ONLY; Fully qualified domain name of the revision
	Fqdn *string `json:"fqdn,omitempty" azure:"ro"`

	// READ-ONLY; Current health State of the revision
	HealthState *RevisionHealthState `json:"healthState,omitempty" azure:"ro"`

	// READ-ONLY; Timestamp describing when the revision was last active. Only meaningful when revision is inactive
	LastActiveTime *time.Time `json:"lastActiveTime,omitempty" azure:"ro"`

	// READ-ONLY; Optional Field - Platform Error Message
	ProvisioningError *string `json:"provisioningError,omitempty" azure:"ro"`

	// READ-ONLY; Current provisioning State of the revision
	ProvisioningState *RevisionProvisioningState `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; Number of pods currently running for this revision
	Replicas *int32 `json:"replicas,omitempty" azure:"ro"`

	// READ-ONLY; Container App Revision Template with all possible settings and the defaults if user did not provide them. The
	// defaults are populated as they were at the creation time
	Template *Template `json:"template,omitempty" azure:"ro"`

	// READ-ONLY; Traffic weight assigned to this revision
	TrafficWeight *int32 `json:"trafficWeight,omitempty" azure:"ro"`
}

// Scale - Container App scaling configurations.
type Scale struct {
	// Optional. Maximum number of container replicas. Defaults to 10 if not set.
	MaxReplicas *int32 `json:"maxReplicas,omitempty"`

	// Optional. Minimum number of container replicas.
	MinReplicas *int32 `json:"minReplicas,omitempty"`

	// Scaling rules.
	Rules []*ScaleRule `json:"rules,omitempty"`
}

// ScaleRule - Container App container scaling rule.
type ScaleRule struct {
	// Azure Queue based scaling.
	AzureQueue *QueueScaleRule `json:"azureQueue,omitempty"`

	// Custom scale rule.
	Custom *CustomScaleRule `json:"custom,omitempty"`

	// HTTP requests based scaling.
	HTTP *HTTPScaleRule `json:"http,omitempty"`

	// Scale Rule Name
	Name *string `json:"name,omitempty"`

	// Tcp requests based scaling.
	TCP *TCPScaleRule `json:"tcp,omitempty"`
}

// ScaleRuleAuth - Auth Secrets for Container App Scale Rule
type ScaleRuleAuth struct {
	// Name of the Container App secret from which to pull the auth params.
	SecretRef *string `json:"secretRef,omitempty"`

	// Trigger Parameter that uses the secret
	TriggerParameter *string `json:"triggerParameter,omitempty"`
}

// Secret definition.
type Secret struct {
	// Secret Name.
	Name *string `json:"name,omitempty"`

	// Secret Value.
	Value *string `json:"value,omitempty"`
}

// SecretsCollection - Container App Secrets Collection ARM resource.
type SecretsCollection struct {
	// REQUIRED; Collection of resources.
	Value []*ContainerAppSecret `json:"value,omitempty"`
}

// SourceControl - Container App SourceControl.
type SourceControl struct {
	// SourceControl resource specific properties
	Properties *SourceControlProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// SourceControlCollection - SourceControl collection ARM resource.
type SourceControlCollection struct {
	// REQUIRED; Collection of resources.
	Value []*SourceControl `json:"value,omitempty"`

	// READ-ONLY; Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// SourceControlProperties - SourceControl resource specific properties
type SourceControlProperties struct {
	// The branch which will trigger the auto deployment
	Branch *string `json:"branch,omitempty"`

	// Container App Revision Template with all possible settings and the defaults if user did not provide them. The defaults
	// are populated as they were at the creation time
	GithubActionConfiguration *GithubActionConfiguration `json:"githubActionConfiguration,omitempty"`

	// The repo url which will be integrated to ContainerApp.
	RepoURL *string `json:"repoUrl,omitempty"`

	// READ-ONLY; Current provisioning State of the operation
	OperationState *SourceControlOperationState `json:"operationState,omitempty" azure:"ro"`
}

// SystemData - Metadata pertaining to creation and last modification of the resource.
type SystemData struct {
	// The timestamp of resource creation (UTC).
	CreatedAt *time.Time `json:"createdAt,omitempty"`

	// The identity that created the resource.
	CreatedBy *string `json:"createdBy,omitempty"`

	// The type of identity that created the resource.
	CreatedByType *CreatedByType `json:"createdByType,omitempty"`

	// The timestamp of resource last modification (UTC)
	LastModifiedAt *time.Time `json:"lastModifiedAt,omitempty"`

	// The identity that last modified the resource.
	LastModifiedBy *string `json:"lastModifiedBy,omitempty"`

	// The type of identity that last modified the resource.
	LastModifiedByType *CreatedByType `json:"lastModifiedByType,omitempty"`
}

// TCPScaleRule - Container App container Tcp scaling rule.
type TCPScaleRule struct {
	// Authentication secrets for the tcp scale rule.
	Auth []*ScaleRuleAuth `json:"auth,omitempty"`

	// Metadata properties to describe tcp scale rule.
	Metadata map[string]*string `json:"metadata,omitempty"`
}

// Template - Container App versioned application definition. Defines the desired state of an immutable revision. Any changes
// to this section Will result in a new revision being created
type Template struct {
	// List of container definitions for the Container App.
	Containers []*Container `json:"containers,omitempty"`

	// List of specialized containers that run before app containers.
	InitContainers []*InitContainer `json:"initContainers,omitempty"`

	// User friendly suffix that is appended to the revision name
	RevisionSuffix *string `json:"revisionSuffix,omitempty"`

	// Scaling properties for the Container App.
	Scale *Scale `json:"scale,omitempty"`

	// List of volume definitions for the Container App.
	Volumes []*Volume `json:"volumes,omitempty"`
}

// TrackedResource - The resource model definition for an Azure Resource Manager tracked top level resource which has 'tags'
// and a 'location'
type TrackedResource struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string `json:"location,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// TrafficWeight - Traffic weight assigned to a revision
type TrafficWeight struct {
	// Associates a traffic label with a revision
	Label *string `json:"label,omitempty"`

	// Indicates that the traffic weight belongs to a latest stable revision
	LatestRevision *bool `json:"latestRevision,omitempty"`

	// Name of a revision
	RevisionName *string `json:"revisionName,omitempty"`

	// Traffic weight assigned to a revision
	Weight *int32 `json:"weight,omitempty"`
}

// Twitter - The configuration settings of the Twitter provider.
type Twitter struct {
	// false if the Twitter provider should not be enabled despite the set registration; otherwise, true.
	Enabled *bool `json:"enabled,omitempty"`

	// The configuration settings of the app registration for the Twitter provider.
	Registration *TwitterRegistration `json:"registration,omitempty"`
}

// TwitterRegistration - The configuration settings of the app registration for the Twitter provider.
type TwitterRegistration struct {
	// The OAuth 1.0a consumer key of the Twitter application used for sign-in. This setting is required for enabling Twitter
	// Sign-In. Twitter Sign-In documentation: https://dev.twitter.com/web/sign-in
	ConsumerKey *string `json:"consumerKey,omitempty"`

	// The app setting name that contains the OAuth 1.0a consumer secret of the Twitter application used for sign-in.
	ConsumerSecretSettingName *string `json:"consumerSecretSettingName,omitempty"`
}

// UserAssignedIdentity - User assigned identity properties
type UserAssignedIdentity struct {
	// READ-ONLY; The client ID of the assigned identity.
	ClientID *string `json:"clientId,omitempty" azure:"ro"`

	// READ-ONLY; The principal ID of the assigned identity.
	PrincipalID *string `json:"principalId,omitempty" azure:"ro"`
}

// VnetConfiguration - Configuration properties for apps environment to join a Virtual Network
type VnetConfiguration struct {
	// CIDR notation IP range assigned to the Docker bridge, network. Must not overlap with any other provided IP ranges.
	DockerBridgeCidr *string `json:"dockerBridgeCidr,omitempty"`

	// Resource ID of a subnet for infrastructure components. This subnet must be in the same VNET as the subnet defined in runtimeSubnetId.
	// Must not overlap with any other provided IP ranges.
	InfrastructureSubnetID *string `json:"infrastructureSubnetId,omitempty"`

	// Boolean indicating the environment only has an internal load balancer. These environments do not have a public static IP
	// resource. They must provide runtimeSubnetId and infrastructureSubnetId if
	// enabling this property
	Internal *bool `json:"internal,omitempty"`

	// Configuration used to control the Environment Egress outbound traffic
	OutboundSettings *ManagedEnvironmentOutboundSettings `json:"outboundSettings,omitempty"`

	// IP range in CIDR notation that can be reserved for environment infrastructure IP addresses. Must not overlap with any other
	// provided IP ranges.
	PlatformReservedCidr *string `json:"platformReservedCidr,omitempty"`

	// An IP address from the IP range defined by platformReservedCidr that will be reserved for the internal DNS server.
	PlatformReservedDNSIP *string `json:"platformReservedDnsIP,omitempty"`

	// Resource ID of a subnet that Container App containers are injected into. This subnet must be in the same VNET as the subnet
	// defined in infrastructureSubnetId. Must not overlap with any other provided
	// IP ranges.
	RuntimeSubnetID *string `json:"runtimeSubnetId,omitempty"`
}

// Volume definitions for the Container App.
type Volume struct {
	// Volume name.
	Name *string `json:"name,omitempty"`

	// Name of storage resource. No need to provide for EmptyDir.
	StorageName *string `json:"storageName,omitempty"`

	// Storage type for the volume. If not provided, use EmptyDir.
	StorageType *StorageType `json:"storageType,omitempty"`
}

// VolumeMount - Volume mount for the Container App.
type VolumeMount struct {
	// Path within the container at which the volume should be mounted.Must not contain ':'.
	MountPath *string `json:"mountPath,omitempty"`

	// This must match the Name of a Volume.
	VolumeName *string `json:"volumeName,omitempty"`
}

// WorkloadProfile - Workload profile to scope container app execution.
type WorkloadProfile struct {
	// REQUIRED; The maximum capacity.
	MaximumCount *int32 `json:"maximumCount,omitempty"`

	// REQUIRED; The minimum capacity.
	MinimumCount *int32 `json:"minimumCount,omitempty"`

	// REQUIRED; Workload profile type for the workloads to run on.
	WorkloadProfileType *string `json:"workloadProfileType,omitempty"`
}

// WorkloadProfileStates - Collection of all the workload Profile States for a Premium Managed Environment..
type WorkloadProfileStates struct {
	// Workload Profile resource specific properties.
	Properties *WorkloadProfileStatesProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// WorkloadProfileStatesCollection - Collection of workloadProfileStates
type WorkloadProfileStatesCollection struct {
	// REQUIRED; Collection of resources.
	Value []*WorkloadProfileStates `json:"value,omitempty"`

	// READ-ONLY; Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// WorkloadProfileStatesProperties - Workload Profile resource specific properties.
type WorkloadProfileStatesProperties struct {
	// Current count of nodes.
	CurrentCount *int32 `json:"currentCount,omitempty"`

	// Maximum count of nodes.
	MaximumCount *int32 `json:"maximumCount,omitempty"`

	// Minimum count of instances.
	MinimumCount *int32 `json:"minimumCount,omitempty"`
}
