//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armhybridcompute

import "time"

// AgentConfiguration - Configurable properties that the user can set locally via the azcmagent config command, or remotely
// via ARM.
type AgentConfiguration struct {
	// READ-ONLY; Array of extensions that are allowed to be installed or updated.
	ExtensionsAllowList []*ConfigurationExtension `json:"extensionsAllowList,omitempty" azure:"ro"`

	// READ-ONLY; Array of extensions that are blocked (cannot be installed or updated)
	ExtensionsBlockList []*ConfigurationExtension `json:"extensionsBlockList,omitempty" azure:"ro"`

	// READ-ONLY; Specifies whether the extension service is enabled or disabled.
	ExtensionsEnabled *string `json:"extensionsEnabled,omitempty" azure:"ro"`

	// READ-ONLY; Specified whether the guest configuration service is enabled or disabled.
	GuestConfigurationEnabled *string `json:"guestConfigurationEnabled,omitempty" azure:"ro"`

	// READ-ONLY; Specifies the list of ports that the agent will be able to listen on.
	IncomingConnectionsPorts []*string `json:"incomingConnectionsPorts,omitempty" azure:"ro"`

	// READ-ONLY; List of service names which should not use the specified proxy server.
	ProxyBypass []*string `json:"proxyBypass,omitempty" azure:"ro"`

	// READ-ONLY; Specifies the URL of the proxy to be used.
	ProxyURL *string `json:"proxyUrl,omitempty" azure:"ro"`
}

// CloudMetadata - The metadata of the cloud environment (Azure/GCP/AWS/OCI…).
type CloudMetadata struct {
	// READ-ONLY; Specifies the cloud provider (Azure/AWS/GCP…).
	Provider *string `json:"provider,omitempty" azure:"ro"`
}

// ConfigurationExtension - Describes properties that can identify extensions.
type ConfigurationExtension struct {
	// READ-ONLY; Publisher of the extension.
	Publisher *string `json:"publisher,omitempty" azure:"ro"`

	// READ-ONLY; Type of the extension.
	Type *string `json:"type,omitempty" azure:"ro"`
}

type ConnectionDetail struct {
	// READ-ONLY; The private endpoint connection group id
	GroupID *string `json:"groupId,omitempty" azure:"ro"`

	// READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The private endpoint connection link identifier
	LinkIdentifier *string `json:"linkIdentifier,omitempty" azure:"ro"`

	// READ-ONLY; The private endpoint connection member name
	MemberName *string `json:"memberName,omitempty" azure:"ro"`

	// READ-ONLY; The private endpoint connection private ip address
	PrivateIPAddress *string `json:"privateIpAddress,omitempty" azure:"ro"`
}

// ErrorAdditionalInfo - The resource management error additional info.
type ErrorAdditionalInfo struct {
	// READ-ONLY; The additional info.
	Info interface{} `json:"info,omitempty" azure:"ro"`

	// READ-ONLY; The additional info type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ErrorDetail - The error detail.
type ErrorDetail struct {
	// READ-ONLY; The error additional info.
	AdditionalInfo []*ErrorAdditionalInfo `json:"additionalInfo,omitempty" azure:"ro"`

	// READ-ONLY; The error code.
	Code *string `json:"code,omitempty" azure:"ro"`

	// READ-ONLY; The error details.
	Details []*ErrorDetail `json:"details,omitempty" azure:"ro"`

	// READ-ONLY; The error message.
	Message *string `json:"message,omitempty" azure:"ro"`

	// READ-ONLY; The error target.
	Target *string `json:"target,omitempty" azure:"ro"`
}

// ErrorResponse - Common error response for all Azure Resource Manager APIs to return error details for failed operations.
// (This also follows the OData error response format.).
type ErrorResponse struct {
	// The error object.
	Error *ErrorDetail `json:"error,omitempty"`
}

// ExtensionTargetProperties - Describes the Machine Extension Target Version Properties
type ExtensionTargetProperties struct {
	// Properties for the specified Extension to Upgrade.
	TargetVersion *string `json:"targetVersion,omitempty"`
}

// Identity for the resource.
type Identity struct {
	// The identity type.
	Type *string `json:"type,omitempty"`

	// READ-ONLY; The principal ID of resource identity.
	PrincipalID *string `json:"principalId,omitempty" azure:"ro"`

	// READ-ONLY; The tenant ID of resource.
	TenantID *string `json:"tenantId,omitempty" azure:"ro"`
}

// LocationData - Metadata pertaining to the geographic location of the resource.
type LocationData struct {
	// REQUIRED; A canonical name for the geographic or physical location.
	Name *string `json:"name,omitempty"`

	// The city or locality where the resource is located.
	City *string `json:"city,omitempty"`

	// The country or region where the resource is located
	CountryOrRegion *string `json:"countryOrRegion,omitempty"`

	// The district, state, or province where the resource is located.
	District *string `json:"district,omitempty"`
}

// Machine - Describes a hybrid machine.
type Machine struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string `json:"location,omitempty"`

	// Identity for the resource.
	Identity *Identity `json:"identity,omitempty"`

	// Hybrid Compute Machine properties
	Properties *MachineProperties `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The system meta data relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// MachineExtension - Describes a Machine Extension.
type MachineExtension struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string `json:"location,omitempty"`

	// Describes Machine Extension Properties.
	Properties *MachineExtensionProperties `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The system meta data relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// MachineExtensionInstanceView - Describes the Machine Extension Instance View.
type MachineExtensionInstanceView struct {
	// The machine extension name.
	Name *string `json:"name,omitempty"`

	// Instance view status.
	Status *MachineExtensionInstanceViewStatus `json:"status,omitempty"`

	// Specifies the type of the extension; an example is "CustomScriptExtension".
	Type *string `json:"type,omitempty"`

	// Specifies the version of the script handler.
	TypeHandlerVersion *string `json:"typeHandlerVersion,omitempty"`
}

// MachineExtensionInstanceViewStatus - Instance view status.
type MachineExtensionInstanceViewStatus struct {
	// The status code.
	Code *string `json:"code,omitempty"`

	// The short localizable label for the status.
	DisplayStatus *string `json:"displayStatus,omitempty"`

	// The level code.
	Level *StatusLevelTypes `json:"level,omitempty"`

	// The detailed status message, including for alerts and error messages.
	Message *string `json:"message,omitempty"`

	// The time of the status.
	Time *time.Time `json:"time,omitempty"`
}

// MachineExtensionProperties - Describes the properties of a Machine Extension.
type MachineExtensionProperties struct {
	// Indicates whether the extension should use a newer minor version if one is available at deployment time. Once deployed,
	// however, the extension will not upgrade minor versions unless redeployed, even
	// with this property set to true.
	AutoUpgradeMinorVersion *bool `json:"autoUpgradeMinorVersion,omitempty"`

	// Indicates whether the extension should be automatically upgraded by the platform if there is a newer version available.
	EnableAutomaticUpgrade *bool `json:"enableAutomaticUpgrade,omitempty"`

	// How the extension handler should be forced to update even if the extension configuration has not changed.
	ForceUpdateTag *string `json:"forceUpdateTag,omitempty"`

	// The machine extension instance view.
	InstanceView *MachineExtensionInstanceView `json:"instanceView,omitempty"`

	// The extension can contain either protectedSettings or protectedSettingsFromKeyVault or no protected settings at all.
	ProtectedSettings interface{} `json:"protectedSettings,omitempty"`

	// The name of the extension handler publisher.
	Publisher *string `json:"publisher,omitempty"`

	// Json formatted public settings for the extension.
	Settings interface{} `json:"settings,omitempty"`

	// Specifies the type of the extension; an example is "CustomScriptExtension".
	Type *string `json:"type,omitempty"`

	// Specifies the version of the script handler.
	TypeHandlerVersion *string `json:"typeHandlerVersion,omitempty"`

	// READ-ONLY; The provisioning state, which only appears in the response.
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`
}

// MachineExtensionUpdate - Describes a Machine Extension Update.
type MachineExtensionUpdate struct {
	// Describes Machine Extension Update Properties.
	Properties *MachineExtensionUpdateProperties `json:"properties,omitempty"`

	// Resource tags
	Tags map[string]*string `json:"tags,omitempty"`
}

// MachineExtensionUpdateProperties - Describes the properties of a Machine Extension.
type MachineExtensionUpdateProperties struct {
	// Indicates whether the extension should use a newer minor version if one is available at deployment time. Once deployed,
	// however, the extension will not upgrade minor versions unless redeployed, even
	// with this property set to true.
	AutoUpgradeMinorVersion *bool `json:"autoUpgradeMinorVersion,omitempty"`

	// How the extension handler should be forced to update even if the extension configuration has not changed.
	ForceUpdateTag *string `json:"forceUpdateTag,omitempty"`

	// The extension can contain either protectedSettings or protectedSettingsFromKeyVault or no protected settings at all.
	ProtectedSettings interface{} `json:"protectedSettings,omitempty"`

	// The name of the extension handler publisher.
	Publisher *string `json:"publisher,omitempty"`

	// Json formatted public settings for the extension.
	Settings interface{} `json:"settings,omitempty"`

	// Specifies the type of the extension; an example is "CustomScriptExtension".
	Type *string `json:"type,omitempty"`

	// Specifies the version of the script handler.
	TypeHandlerVersion *string `json:"typeHandlerVersion,omitempty"`
}

// MachineExtensionUpgrade - Describes the Machine Extension Upgrade Properties
type MachineExtensionUpgrade struct {
	// Describes the Extension Target Properties.
	ExtensionTargets map[string]*ExtensionTargetProperties `json:"extensionTargets,omitempty"`
}

// MachineExtensionsClientBeginCreateOrUpdateOptions contains the optional parameters for the MachineExtensionsClient.BeginCreateOrUpdate
// method.
type MachineExtensionsClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// MachineExtensionsClientBeginDeleteOptions contains the optional parameters for the MachineExtensionsClient.BeginDelete
// method.
type MachineExtensionsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// MachineExtensionsClientBeginUpdateOptions contains the optional parameters for the MachineExtensionsClient.BeginUpdate
// method.
type MachineExtensionsClientBeginUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// MachineExtensionsClientGetOptions contains the optional parameters for the MachineExtensionsClient.Get method.
type MachineExtensionsClientGetOptions struct {
	// placeholder for future optional parameters
}

// MachineExtensionsClientListOptions contains the optional parameters for the MachineExtensionsClient.List method.
type MachineExtensionsClientListOptions struct {
	// The expand expression to apply on the operation.
	Expand *string
}

// MachineExtensionsListResult - Describes the Machine Extensions List Result.
type MachineExtensionsListResult struct {
	// The uri to fetch the next page of machine extensions. Call ListNext() with this to fetch the next page of extensions.
	NextLink *string `json:"nextLink,omitempty"`

	// The list of extensions
	Value []*MachineExtension `json:"value,omitempty"`
}

// MachineListResult - The List hybrid machine operation response.
type MachineListResult struct {
	// REQUIRED; The list of hybrid machines.
	Value []*Machine `json:"value,omitempty"`

	// The URI to fetch the next page of Machines. Call ListNext() with this URI to fetch the next page of hybrid machines.
	NextLink *string `json:"nextLink,omitempty"`
}

// MachineProperties - Describes the properties of a hybrid machine.
type MachineProperties struct {
	// Public Key that the client provides to be used during initial resource onboarding
	ClientPublicKey *string `json:"clientPublicKey,omitempty"`

	// The metadata of the cloud environment (Azure/GCP/AWS/OCI…).
	CloudMetadata *CloudMetadata `json:"cloudMetadata,omitempty"`

	// Machine Extensions information
	Extensions []*MachineExtensionInstanceView `json:"extensions,omitempty"`

	// Metadata pertaining to the geographic location of the resource.
	LocationData *LocationData `json:"locationData,omitempty"`

	// Specifies whether any MS SQL instance is discovered on the machine.
	MssqlDiscovered *string `json:"mssqlDiscovered,omitempty"`

	// Specifies the operating system settings for the hybrid machine.
	OSProfile *OSProfile `json:"osProfile,omitempty"`

	// The type of Operating System (windows/linux).
	OSType *string `json:"osType,omitempty"`

	// The resource id of the parent cluster (Azure HCI) this machine is assigned to, if any.
	ParentClusterResourceID *string `json:"parentClusterResourceId,omitempty"`

	// The resource id of the private link scope this machine is assigned to, if any.
	PrivateLinkScopeResourceID *string `json:"privateLinkScopeResourceId,omitempty"`

	// Statuses of dependent services that are reported back to ARM.
	ServiceStatuses *ServiceStatuses `json:"serviceStatuses,omitempty"`

	// Specifies the hybrid machine unique ID.
	VMID *string `json:"vmId,omitempty"`

	// READ-ONLY; Specifies the AD fully qualified display name.
	AdFqdn *string `json:"adFqdn,omitempty" azure:"ro"`

	// READ-ONLY; Configurable properties that the user can set locally via the azcmagent config command, or remotely via ARM.
	AgentConfiguration *AgentConfiguration `json:"agentConfiguration,omitempty" azure:"ro"`

	// READ-ONLY; The hybrid machine agent full version.
	AgentVersion *string `json:"agentVersion,omitempty" azure:"ro"`

	// READ-ONLY; Specifies the DNS fully qualified display name.
	DNSFqdn *string `json:"dnsFqdn,omitempty" azure:"ro"`

	// READ-ONLY; Detected properties from the machine.
	DetectedProperties map[string]*string `json:"detectedProperties,omitempty" azure:"ro"`

	// READ-ONLY; Specifies the hybrid machine display name.
	DisplayName *string `json:"displayName,omitempty" azure:"ro"`

	// READ-ONLY; Specifies the Windows domain name.
	DomainName *string `json:"domainName,omitempty" azure:"ro"`

	// READ-ONLY; Details about the error state.
	ErrorDetails []*ErrorDetail `json:"errorDetails,omitempty" azure:"ro"`

	// READ-ONLY; The time of the last status change.
	LastStatusChange *time.Time `json:"lastStatusChange,omitempty" azure:"ro"`

	// READ-ONLY; Specifies the hybrid machine FQDN.
	MachineFqdn *string `json:"machineFqdn,omitempty" azure:"ro"`

	// READ-ONLY; The Operating System running on the hybrid machine.
	OSName *string `json:"osName,omitempty" azure:"ro"`

	// READ-ONLY; Specifies the Operating System product SKU.
	OSSKU *string `json:"osSku,omitempty" azure:"ro"`

	// READ-ONLY; The version of Operating System running on the hybrid machine.
	OSVersion *string `json:"osVersion,omitempty" azure:"ro"`

	// READ-ONLY; The provisioning state, which only appears in the response.
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; The status of the hybrid machine agent.
	Status *StatusTypes `json:"status,omitempty" azure:"ro"`

	// READ-ONLY; Specifies the Arc Machine's unique SMBIOS ID
	VMUUID *string `json:"vmUuid,omitempty" azure:"ro"`
}

// MachineUpdate - Describes a hybrid machine Update.
type MachineUpdate struct {
	// Identity for the resource.
	Identity *Identity `json:"identity,omitempty"`

	// Hybrid Compute Machine properties
	Properties *MachineUpdateProperties `json:"properties,omitempty"`

	// Resource tags
	Tags map[string]*string `json:"tags,omitempty"`
}

// MachineUpdateProperties - Describes the ARM updatable properties of a hybrid machine.
type MachineUpdateProperties struct {
	// The metadata of the cloud environment (Azure/GCP/AWS/OCI…).
	CloudMetadata *CloudMetadata `json:"cloudMetadata,omitempty"`

	// Metadata pertaining to the geographic location of the resource.
	LocationData *LocationData `json:"locationData,omitempty"`

	// Specifies the operating system settings for the hybrid machine.
	OSProfile *OSProfile `json:"osProfile,omitempty"`

	// The resource id of the parent cluster (Azure HCI) this machine is assigned to, if any.
	ParentClusterResourceID *string `json:"parentClusterResourceId,omitempty"`

	// The resource id of the private link scope this machine is assigned to, if any.
	PrivateLinkScopeResourceID *string `json:"privateLinkScopeResourceId,omitempty"`
}

// MachinesClientCreateOrUpdateOptions contains the optional parameters for the MachinesClient.CreateOrUpdate method.
type MachinesClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// MachinesClientDeleteOptions contains the optional parameters for the MachinesClient.Delete method.
type MachinesClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// MachinesClientGetOptions contains the optional parameters for the MachinesClient.Get method.
type MachinesClientGetOptions struct {
	// The expand expression to apply on the operation.
	Expand *InstanceViewTypes
}

// MachinesClientListByResourceGroupOptions contains the optional parameters for the MachinesClient.ListByResourceGroup method.
type MachinesClientListByResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// MachinesClientListBySubscriptionOptions contains the optional parameters for the MachinesClient.ListBySubscription method.
type MachinesClientListBySubscriptionOptions struct {
	// placeholder for future optional parameters
}

// MachinesClientUpdateOptions contains the optional parameters for the MachinesClient.Update method.
type MachinesClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// ManagementClientBeginUpgradeExtensionsOptions contains the optional parameters for the ManagementClient.BeginUpgradeExtensions
// method.
type ManagementClientBeginUpgradeExtensionsOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// OSProfile - Specifies the operating system settings for the hybrid machine.
type OSProfile struct {
	// Specifies the linux configuration for update management.
	LinuxConfiguration *OSProfileLinuxConfiguration `json:"linuxConfiguration,omitempty"`

	// Specifies the windows configuration for update management.
	WindowsConfiguration *OSProfileWindowsConfiguration `json:"windowsConfiguration,omitempty"`

	// READ-ONLY; Specifies the host OS name of the hybrid machine.
	ComputerName *string `json:"computerName,omitempty" azure:"ro"`
}

// OSProfileLinuxConfiguration - Specifies the linux configuration for update management.
type OSProfileLinuxConfiguration struct {
	// Specifies the patch settings.
	PatchSettings *PatchSettings `json:"patchSettings,omitempty"`
}

// OSProfileWindowsConfiguration - Specifies the windows configuration for update management.
type OSProfileWindowsConfiguration struct {
	// Specifies the patch settings.
	PatchSettings *PatchSettings `json:"patchSettings,omitempty"`
}

// OperationListResult - The List Compute Operation operation response.
type OperationListResult struct {
	// READ-ONLY; The list of compute operations
	Value []*OperationValue `json:"value,omitempty" azure:"ro"`
}

// OperationValue - Describes the properties of a Compute Operation value.
type OperationValue struct {
	// Display properties
	Display *OperationValueDisplay `json:"display,omitempty"`

	// READ-ONLY; This property indicates if the operation is an action or a data action
	IsDataAction *bool `json:"isDataAction,omitempty" azure:"ro"`

	// READ-ONLY; The name of the compute operation.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The origin of the compute operation.
	Origin *string `json:"origin,omitempty" azure:"ro"`
}

// OperationValueDisplay - Describes the properties of a Hybrid Compute Operation Value Display.
type OperationValueDisplay struct {
	// READ-ONLY; The description of the operation.
	Description *string `json:"description,omitempty" azure:"ro"`

	// READ-ONLY; The display name of the compute operation.
	Operation *string `json:"operation,omitempty" azure:"ro"`

	// READ-ONLY; The resource provider for the operation.
	Provider *string `json:"provider,omitempty" azure:"ro"`

	// READ-ONLY; The display name of the resource the operation applies to.
	Resource *string `json:"resource,omitempty" azure:"ro"`
}

// OperationsClientListOptions contains the optional parameters for the OperationsClient.List method.
type OperationsClientListOptions struct {
	// placeholder for future optional parameters
}

// PatchSettings - Specifies the patch settings.
type PatchSettings struct {
	// Specifies the assessment mode.
	AssessmentMode *AssessmentModeTypes `json:"assessmentMode,omitempty"`

	// Specifies the patch mode.
	PatchMode *PatchModeTypes `json:"patchMode,omitempty"`
}

// PrivateEndpointConnection - A private endpoint connection
type PrivateEndpointConnection struct {
	// Resource properties.
	Properties *PrivateEndpointConnectionProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The system meta data relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// PrivateEndpointConnectionDataModel - The Data Model for a Private Endpoint Connection associated with a Private Link Scope
type PrivateEndpointConnectionDataModel struct {
	// The Private Endpoint Connection properties.
	Properties *PrivateEndpointConnectionProperties `json:"properties,omitempty"`

	// READ-ONLY; The ARM Resource Id of the Private Endpoint.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The Name of the Private Endpoint.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// PrivateEndpointConnectionListResult - A list of private endpoint connections.
type PrivateEndpointConnectionListResult struct {
	// READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; Array of results.
	Value []*PrivateEndpointConnection `json:"value,omitempty" azure:"ro"`
}

// PrivateEndpointConnectionProperties - Properties of a private endpoint connection.
type PrivateEndpointConnectionProperties struct {
	// Private endpoint which the connection belongs to.
	PrivateEndpoint *PrivateEndpointProperty `json:"privateEndpoint,omitempty"`

	// Connection state of the private endpoint connection.
	PrivateLinkServiceConnectionState *PrivateLinkServiceConnectionStateProperty `json:"privateLinkServiceConnectionState,omitempty"`

	// READ-ONLY; List of group IDs.
	GroupIDs []*string `json:"groupIds,omitempty" azure:"ro"`

	// READ-ONLY; State of the private endpoint connection.
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`
}

// PrivateEndpointConnectionsClientBeginCreateOrUpdateOptions contains the optional parameters for the PrivateEndpointConnectionsClient.BeginCreateOrUpdate
// method.
type PrivateEndpointConnectionsClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// PrivateEndpointConnectionsClientBeginDeleteOptions contains the optional parameters for the PrivateEndpointConnectionsClient.BeginDelete
// method.
type PrivateEndpointConnectionsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// PrivateEndpointConnectionsClientGetOptions contains the optional parameters for the PrivateEndpointConnectionsClient.Get
// method.
type PrivateEndpointConnectionsClientGetOptions struct {
	// placeholder for future optional parameters
}

// PrivateEndpointConnectionsClientListByPrivateLinkScopeOptions contains the optional parameters for the PrivateEndpointConnectionsClient.ListByPrivateLinkScope
// method.
type PrivateEndpointConnectionsClientListByPrivateLinkScopeOptions struct {
	// placeholder for future optional parameters
}

// PrivateEndpointProperty - Private endpoint which the connection belongs to.
type PrivateEndpointProperty struct {
	// Resource id of the private endpoint.
	ID *string `json:"id,omitempty"`
}

// PrivateLinkResource - A private link resource
type PrivateLinkResource struct {
	// Resource properties.
	Properties *PrivateLinkResourceProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The system meta data relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// PrivateLinkResourceListResult - A list of private link resources
type PrivateLinkResourceListResult struct {
	// READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; Array of results.
	Value []*PrivateLinkResource `json:"value,omitempty" azure:"ro"`
}

// PrivateLinkResourceProperties - Properties of a private link resource.
type PrivateLinkResourceProperties struct {
	// READ-ONLY; The private link resource group id.
	GroupID *string `json:"groupId,omitempty" azure:"ro"`

	// READ-ONLY; The private link resource required member names.
	RequiredMembers []*string `json:"requiredMembers,omitempty" azure:"ro"`

	// READ-ONLY; Required DNS zone names of the the private link resource.
	RequiredZoneNames []*string `json:"requiredZoneNames,omitempty" azure:"ro"`
}

// PrivateLinkResourcesClientGetOptions contains the optional parameters for the PrivateLinkResourcesClient.Get method.
type PrivateLinkResourcesClientGetOptions struct {
	// placeholder for future optional parameters
}

// PrivateLinkResourcesClientListByPrivateLinkScopeOptions contains the optional parameters for the PrivateLinkResourcesClient.ListByPrivateLinkScope
// method.
type PrivateLinkResourcesClientListByPrivateLinkScopeOptions struct {
	// placeholder for future optional parameters
}

// PrivateLinkScope - An Azure Arc PrivateLinkScope definition.
type PrivateLinkScope struct {
	// REQUIRED; Resource location
	Location *string `json:"location,omitempty"`

	// Properties that define a Azure Arc PrivateLinkScope resource.
	Properties *PrivateLinkScopeProperties `json:"properties,omitempty"`

	// Resource tags
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The system meta data relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// PrivateLinkScopeListResult - Describes the list of Azure Arc PrivateLinkScope resources.
type PrivateLinkScopeListResult struct {
	// REQUIRED; List of Azure Arc PrivateLinkScope definitions.
	Value []*PrivateLinkScope `json:"value,omitempty"`

	// The URI to get the next set of Azure Arc PrivateLinkScope definitions if too many PrivateLinkScopes where returned in the
	// result set.
	NextLink *string `json:"nextLink,omitempty"`
}

// PrivateLinkScopeProperties - Properties that define a Azure Arc PrivateLinkScope resource.
type PrivateLinkScopeProperties struct {
	// Indicates whether machines associated with the private link scope can also use public Azure Arc service endpoints.
	PublicNetworkAccess *PublicNetworkAccessType `json:"publicNetworkAccess,omitempty"`

	// READ-ONLY; The collection of associated Private Endpoint Connections.
	PrivateEndpointConnections []*PrivateEndpointConnectionDataModel `json:"privateEndpointConnections,omitempty" azure:"ro"`

	// READ-ONLY; The Guid id of the private link scope.
	PrivateLinkScopeID *string `json:"privateLinkScopeId,omitempty" azure:"ro"`

	// READ-ONLY; Current state of this PrivateLinkScope: whether or not is has been provisioned within the resource group it
	// is defined. Users cannot change this value but are able to read from it. Values will include
	// Provisioning ,Succeeded, Canceled and Failed.
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`
}

type PrivateLinkScopeValidationDetails struct {
	// List of Private Endpoint Connection details.
	ConnectionDetails []*ConnectionDetail `json:"connectionDetails,omitempty"`

	// Indicates whether machines associated with the private link scope can also use public Azure Arc service endpoints.
	PublicNetworkAccess *PublicNetworkAccessType `json:"publicNetworkAccess,omitempty"`

	// READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty" azure:"ro"`
}

// PrivateLinkScopesClientBeginDeleteOptions contains the optional parameters for the PrivateLinkScopesClient.BeginDelete
// method.
type PrivateLinkScopesClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// PrivateLinkScopesClientCreateOrUpdateOptions contains the optional parameters for the PrivateLinkScopesClient.CreateOrUpdate
// method.
type PrivateLinkScopesClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// PrivateLinkScopesClientGetOptions contains the optional parameters for the PrivateLinkScopesClient.Get method.
type PrivateLinkScopesClientGetOptions struct {
	// placeholder for future optional parameters
}

// PrivateLinkScopesClientGetValidationDetailsForMachineOptions contains the optional parameters for the PrivateLinkScopesClient.GetValidationDetailsForMachine
// method.
type PrivateLinkScopesClientGetValidationDetailsForMachineOptions struct {
	// placeholder for future optional parameters
}

// PrivateLinkScopesClientGetValidationDetailsOptions contains the optional parameters for the PrivateLinkScopesClient.GetValidationDetails
// method.
type PrivateLinkScopesClientGetValidationDetailsOptions struct {
	// placeholder for future optional parameters
}

// PrivateLinkScopesClientListByResourceGroupOptions contains the optional parameters for the PrivateLinkScopesClient.ListByResourceGroup
// method.
type PrivateLinkScopesClientListByResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// PrivateLinkScopesClientListOptions contains the optional parameters for the PrivateLinkScopesClient.List method.
type PrivateLinkScopesClientListOptions struct {
	// placeholder for future optional parameters
}

// PrivateLinkScopesClientUpdateTagsOptions contains the optional parameters for the PrivateLinkScopesClient.UpdateTags method.
type PrivateLinkScopesClientUpdateTagsOptions struct {
	// placeholder for future optional parameters
}

// PrivateLinkScopesResource - An azure resource object
type PrivateLinkScopesResource struct {
	// REQUIRED; Resource location
	Location *string `json:"location,omitempty"`

	// Resource tags
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Azure resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Azure resource name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Azure resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// PrivateLinkServiceConnectionStateProperty - State of the private endpoint connection.
type PrivateLinkServiceConnectionStateProperty struct {
	// REQUIRED; The private link service connection description.
	Description *string `json:"description,omitempty"`

	// REQUIRED; The private link service connection status.
	Status *string `json:"status,omitempty"`

	// READ-ONLY; The actions required for private link service connection.
	ActionsRequired *string `json:"actionsRequired,omitempty" azure:"ro"`
}

// ProxyResource - The resource model definition for a Azure Resource Manager proxy resource. It will not have tags and a
// location
type ProxyResource struct {
	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// Resource - Common fields that are returned in the response for all Azure Resource Manager resources
type Resource struct {
	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ResourceUpdate - The Update Resource model definition.
type ResourceUpdate struct {
	// Resource tags
	Tags map[string]*string `json:"tags,omitempty"`
}

// ServiceStatus - Describes the status and behavior of a service.
type ServiceStatus struct {
	// The behavior of the service when the Arc-enabled machine starts up.
	StartupType *string `json:"startupType,omitempty"`

	// The current status of the service.
	Status *string `json:"status,omitempty"`
}

// ServiceStatuses - Reports the state and behavior of dependent services.
type ServiceStatuses struct {
	// The state of the extension service on the Arc-enabled machine.
	ExtensionService *ServiceStatus `json:"extensionService,omitempty"`

	// The state of the guest configuration service on the Arc-enabled machine.
	GuestConfigurationService *ServiceStatus `json:"guestConfigurationService,omitempty"`
}

// SystemData - Metadata pertaining to creation and last modification of the resource.
type SystemData struct {
	// The timestamp of resource creation (UTC).
	CreatedAt *time.Time `json:"createdAt,omitempty"`

	// The identity that created the resource.
	CreatedBy *string `json:"createdBy,omitempty"`

	// The type of identity that created the resource.
	CreatedByType *CreatedByType `json:"createdByType,omitempty"`

	// The timestamp of resource last modification (UTC)
	LastModifiedAt *time.Time `json:"lastModifiedAt,omitempty"`

	// The identity that last modified the resource.
	LastModifiedBy *string `json:"lastModifiedBy,omitempty"`

	// The type of identity that last modified the resource.
	LastModifiedByType *CreatedByType `json:"lastModifiedByType,omitempty"`
}

// TagsResource - A container holding only the Tags for a resource, allowing the user to update the tags on a PrivateLinkScope
// instance.
type TagsResource struct {
	// Resource tags
	Tags map[string]*string `json:"tags,omitempty"`
}

// TrackedResource - The resource model definition for an Azure Resource Manager tracked top level resource which has 'tags'
// and a 'location'
type TrackedResource struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string `json:"location,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}
