//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armmanagedservices_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/managedservices/armmanagedservices"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/tree/main/specification/managedservices/resource-manager/Microsoft.ManagedServices/preview/2022-01-01-preview/examples/GetRegistrationDefinition.json
func ExampleRegistrationDefinitionsClient_Get() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	client, err := armmanagedservices.NewRegistrationDefinitionsClient(cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := client.Get(ctx,
		"subscription/0afefe50-734e-4610-8a82-a144ahf49dea",
		"26c128c2-fefa-4340-9bb1-6e081c90ada2",
		nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// TODO: use response item
	_ = res
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/tree/main/specification/managedservices/resource-manager/Microsoft.ManagedServices/preview/2022-01-01-preview/examples/DeleteRegistrationDefinition.json
func ExampleRegistrationDefinitionsClient_Delete() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	client, err := armmanagedservices.NewRegistrationDefinitionsClient(cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	_, err = client.Delete(ctx,
		"26c128c2-fefa-4340-9bb1-6e081c90ada2",
		"subscription/0afefe50-734e-4610-8a82-a144ahf49dea",
		nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/tree/main/specification/managedservices/resource-manager/Microsoft.ManagedServices/preview/2022-01-01-preview/examples/PutRegistrationDefinition.json
func ExampleRegistrationDefinitionsClient_BeginCreateOrUpdate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	client, err := armmanagedservices.NewRegistrationDefinitionsClient(cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := client.BeginCreateOrUpdate(ctx,
		"26c128c2-fefa-4340-9bb1-6e081c90ada2",
		"subscription/0afefe50-734e-4610-8a82-a144ahf49dea",
		armmanagedservices.RegistrationDefinition{
			Plan: &armmanagedservices.Plan{
				Name:      to.Ptr("addesai-plan"),
				Product:   to.Ptr("test"),
				Publisher: to.Ptr("marketplace-test"),
				Version:   to.Ptr("1.0.0"),
			},
			Properties: &armmanagedservices.RegistrationDefinitionProperties{
				Description: to.Ptr("Tes1t"),
				Authorizations: []*armmanagedservices.Authorization{
					{
						PrincipalID:            to.Ptr("f98d86a2-4cc4-4e9d-ad47-b3e80a1bcdfc"),
						PrincipalIDDisplayName: to.Ptr("Support User"),
						RoleDefinitionID:       to.Ptr("acdd72a7-3385-48ef-bd42-f606fba81ae7"),
					},
					{
						DelegatedRoleDefinitionIDs: []*string{
							to.Ptr("b24988ac-6180-42a0-ab88-20f7382dd24c")},
						PrincipalID:            to.Ptr("f98d86a2-4cc4-4e9d-ad47-b3e80a1bcdfc"),
						PrincipalIDDisplayName: to.Ptr("User Access Administrator"),
						RoleDefinitionID:       to.Ptr("18d7d88d-d35e-4fb5-a5c3-7773c20a72d9"),
					}},
				EligibleAuthorizations: []*armmanagedservices.EligibleAuthorization{
					{
						JustInTimeAccessPolicy: &armmanagedservices.JustInTimeAccessPolicy{
							ManagedByTenantApprovers: []*armmanagedservices.EligibleApprover{
								{
									PrincipalID:            to.Ptr("d9b22cd6-6407-43cc-8c60-07c56df0b51a"),
									PrincipalIDDisplayName: to.Ptr("Approver Group"),
								}},
							MaximumActivationDuration: to.Ptr("PT8H"),
							MultiFactorAuthProvider:   to.Ptr(armmanagedservices.MultiFactorAuthProviderAzure),
						},
						PrincipalID:            to.Ptr("3e0ed8c6-e902-4fc5-863c-e3ddbb2ae2a2"),
						PrincipalIDDisplayName: to.Ptr("Support User"),
						RoleDefinitionID:       to.Ptr("ae349356-3a1b-4a5e-921d-050484c6347e"),
					}},
				ManagedByTenantID:          to.Ptr("83abe5cd-bcc3-441a-bd86-e6a75360cecc"),
				RegistrationDefinitionName: to.Ptr("DefinitionName"),
			},
		},
		nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// TODO: use response item
	_ = res
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/tree/main/specification/managedservices/resource-manager/Microsoft.ManagedServices/preview/2022-01-01-preview/examples/GetRegistrationDefinitions.json
func ExampleRegistrationDefinitionsClient_NewListPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	client, err := armmanagedservices.NewRegistrationDefinitionsClient(cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := client.NewListPager("subscription/0afefe50-734e-4610-8a82-a144ahf49dea",
		&armmanagedservices.RegistrationDefinitionsClientListOptions{Filter: nil})
	for pager.More() {
		nextResult, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range nextResult.Value {
			// TODO: use page item
			_ = v
		}
	}
}
