//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armsql

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	armruntime "github.com/Azure/azure-sdk-for-go/sdk/azcore/arm/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/cloud"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// ManagedDatabaseVulnerabilityAssessmentScansClient contains the methods for the ManagedDatabaseVulnerabilityAssessmentScans group.
// Don't use this type directly, use NewManagedDatabaseVulnerabilityAssessmentScansClient() instead.
type ManagedDatabaseVulnerabilityAssessmentScansClient struct {
	host           string
	subscriptionID string
	pl             runtime.Pipeline
}

// NewManagedDatabaseVulnerabilityAssessmentScansClient creates a new instance of ManagedDatabaseVulnerabilityAssessmentScansClient with the specified values.
// subscriptionID - The subscription ID that identifies an Azure subscription.
// credential - used to authorize requests. Usually a credential from azidentity.
// options - pass nil to accept the default values.
func NewManagedDatabaseVulnerabilityAssessmentScansClient(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*ManagedDatabaseVulnerabilityAssessmentScansClient, error) {
	if options == nil {
		options = &arm.ClientOptions{}
	}
	ep := cloud.AzurePublic.Services[cloud.ResourceManager].Endpoint
	if c, ok := options.Cloud.Services[cloud.ResourceManager]; ok {
		ep = c.Endpoint
	}
	pl, err := armruntime.NewPipeline(moduleName, moduleVersion, credential, runtime.PipelineOptions{}, options)
	if err != nil {
		return nil, err
	}
	client := &ManagedDatabaseVulnerabilityAssessmentScansClient{
		subscriptionID: subscriptionID,
		host:           ep,
		pl:             pl,
	}
	return client, nil
}

// Export - Convert an existing scan result to a human readable format. If already exists nothing happens
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2020-11-01-preview
// resourceGroupName - The name of the resource group that contains the resource. You can obtain this value from the Azure
// Resource Manager API or the portal.
// managedInstanceName - The name of the managed instance.
// databaseName - The name of the scanned database.
// vulnerabilityAssessmentName - The name of the vulnerability assessment.
// scanID - The vulnerability assessment scan Id.
// options - ManagedDatabaseVulnerabilityAssessmentScansClientExportOptions contains the optional parameters for the ManagedDatabaseVulnerabilityAssessmentScansClient.Export
// method.
func (client *ManagedDatabaseVulnerabilityAssessmentScansClient) Export(ctx context.Context, resourceGroupName string, managedInstanceName string, databaseName string, vulnerabilityAssessmentName VulnerabilityAssessmentName, scanID string, options *ManagedDatabaseVulnerabilityAssessmentScansClientExportOptions) (ManagedDatabaseVulnerabilityAssessmentScansClientExportResponse, error) {
	req, err := client.exportCreateRequest(ctx, resourceGroupName, managedInstanceName, databaseName, vulnerabilityAssessmentName, scanID, options)
	if err != nil {
		return ManagedDatabaseVulnerabilityAssessmentScansClientExportResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return ManagedDatabaseVulnerabilityAssessmentScansClientExportResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK, http.StatusCreated) {
		return ManagedDatabaseVulnerabilityAssessmentScansClientExportResponse{}, runtime.NewResponseError(resp)
	}
	return client.exportHandleResponse(resp)
}

// exportCreateRequest creates the Export request.
func (client *ManagedDatabaseVulnerabilityAssessmentScansClient) exportCreateRequest(ctx context.Context, resourceGroupName string, managedInstanceName string, databaseName string, vulnerabilityAssessmentName VulnerabilityAssessmentName, scanID string, options *ManagedDatabaseVulnerabilityAssessmentScansClientExportOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/managedInstances/{managedInstanceName}/databases/{databaseName}/vulnerabilityAssessments/{vulnerabilityAssessmentName}/scans/{scanId}/export"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if managedInstanceName == "" {
		return nil, errors.New("parameter managedInstanceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{managedInstanceName}", url.PathEscape(managedInstanceName))
	if databaseName == "" {
		return nil, errors.New("parameter databaseName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{databaseName}", url.PathEscape(databaseName))
	if vulnerabilityAssessmentName == "" {
		return nil, errors.New("parameter vulnerabilityAssessmentName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{vulnerabilityAssessmentName}", url.PathEscape(string(vulnerabilityAssessmentName)))
	if scanID == "" {
		return nil, errors.New("parameter scanID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{scanId}", url.PathEscape(scanID))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2020-11-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// exportHandleResponse handles the Export response.
func (client *ManagedDatabaseVulnerabilityAssessmentScansClient) exportHandleResponse(resp *http.Response) (ManagedDatabaseVulnerabilityAssessmentScansClientExportResponse, error) {
	result := ManagedDatabaseVulnerabilityAssessmentScansClientExportResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.DatabaseVulnerabilityAssessmentScansExport); err != nil {
		return ManagedDatabaseVulnerabilityAssessmentScansClientExportResponse{}, err
	}
	return result, nil
}

// Get - Gets a vulnerability assessment scan record of a database.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2020-11-01-preview
// resourceGroupName - The name of the resource group that contains the resource. You can obtain this value from the Azure
// Resource Manager API or the portal.
// managedInstanceName - The name of the managed instance.
// databaseName - The name of the database.
// vulnerabilityAssessmentName - The name of the vulnerability assessment.
// scanID - The vulnerability assessment scan Id of the scan to retrieve.
// options - ManagedDatabaseVulnerabilityAssessmentScansClientGetOptions contains the optional parameters for the ManagedDatabaseVulnerabilityAssessmentScansClient.Get
// method.
func (client *ManagedDatabaseVulnerabilityAssessmentScansClient) Get(ctx context.Context, resourceGroupName string, managedInstanceName string, databaseName string, vulnerabilityAssessmentName VulnerabilityAssessmentName, scanID string, options *ManagedDatabaseVulnerabilityAssessmentScansClientGetOptions) (ManagedDatabaseVulnerabilityAssessmentScansClientGetResponse, error) {
	req, err := client.getCreateRequest(ctx, resourceGroupName, managedInstanceName, databaseName, vulnerabilityAssessmentName, scanID, options)
	if err != nil {
		return ManagedDatabaseVulnerabilityAssessmentScansClientGetResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return ManagedDatabaseVulnerabilityAssessmentScansClientGetResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return ManagedDatabaseVulnerabilityAssessmentScansClientGetResponse{}, runtime.NewResponseError(resp)
	}
	return client.getHandleResponse(resp)
}

// getCreateRequest creates the Get request.
func (client *ManagedDatabaseVulnerabilityAssessmentScansClient) getCreateRequest(ctx context.Context, resourceGroupName string, managedInstanceName string, databaseName string, vulnerabilityAssessmentName VulnerabilityAssessmentName, scanID string, options *ManagedDatabaseVulnerabilityAssessmentScansClientGetOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/managedInstances/{managedInstanceName}/databases/{databaseName}/vulnerabilityAssessments/{vulnerabilityAssessmentName}/scans/{scanId}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if managedInstanceName == "" {
		return nil, errors.New("parameter managedInstanceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{managedInstanceName}", url.PathEscape(managedInstanceName))
	if databaseName == "" {
		return nil, errors.New("parameter databaseName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{databaseName}", url.PathEscape(databaseName))
	if vulnerabilityAssessmentName == "" {
		return nil, errors.New("parameter vulnerabilityAssessmentName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{vulnerabilityAssessmentName}", url.PathEscape(string(vulnerabilityAssessmentName)))
	if scanID == "" {
		return nil, errors.New("parameter scanID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{scanId}", url.PathEscape(scanID))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2020-11-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getHandleResponse handles the Get response.
func (client *ManagedDatabaseVulnerabilityAssessmentScansClient) getHandleResponse(resp *http.Response) (ManagedDatabaseVulnerabilityAssessmentScansClientGetResponse, error) {
	result := ManagedDatabaseVulnerabilityAssessmentScansClientGetResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.VulnerabilityAssessmentScanRecord); err != nil {
		return ManagedDatabaseVulnerabilityAssessmentScansClientGetResponse{}, err
	}
	return result, nil
}

// BeginInitiateScan - Executes a Vulnerability Assessment database scan.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2020-11-01-preview
// resourceGroupName - The name of the resource group that contains the resource. You can obtain this value from the Azure
// Resource Manager API or the portal.
// managedInstanceName - The name of the managed instance.
// databaseName - The name of the database.
// vulnerabilityAssessmentName - The name of the vulnerability assessment.
// scanID - The vulnerability assessment scan Id of the scan to retrieve.
// options - ManagedDatabaseVulnerabilityAssessmentScansClientBeginInitiateScanOptions contains the optional parameters for
// the ManagedDatabaseVulnerabilityAssessmentScansClient.BeginInitiateScan method.
func (client *ManagedDatabaseVulnerabilityAssessmentScansClient) BeginInitiateScan(ctx context.Context, resourceGroupName string, managedInstanceName string, databaseName string, vulnerabilityAssessmentName VulnerabilityAssessmentName, scanID string, options *ManagedDatabaseVulnerabilityAssessmentScansClientBeginInitiateScanOptions) (*runtime.Poller[ManagedDatabaseVulnerabilityAssessmentScansClientInitiateScanResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.initiateScan(ctx, resourceGroupName, managedInstanceName, databaseName, vulnerabilityAssessmentName, scanID, options)
		if err != nil {
			return nil, err
		}
		return runtime.NewPoller[ManagedDatabaseVulnerabilityAssessmentScansClientInitiateScanResponse](resp, client.pl, nil)
	} else {
		return runtime.NewPollerFromResumeToken[ManagedDatabaseVulnerabilityAssessmentScansClientInitiateScanResponse](options.ResumeToken, client.pl, nil)
	}
}

// InitiateScan - Executes a Vulnerability Assessment database scan.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2020-11-01-preview
func (client *ManagedDatabaseVulnerabilityAssessmentScansClient) initiateScan(ctx context.Context, resourceGroupName string, managedInstanceName string, databaseName string, vulnerabilityAssessmentName VulnerabilityAssessmentName, scanID string, options *ManagedDatabaseVulnerabilityAssessmentScansClientBeginInitiateScanOptions) (*http.Response, error) {
	req, err := client.initiateScanCreateRequest(ctx, resourceGroupName, managedInstanceName, databaseName, vulnerabilityAssessmentName, scanID, options)
	if err != nil {
		return nil, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK, http.StatusAccepted) {
		return nil, runtime.NewResponseError(resp)
	}
	return resp, nil
}

// initiateScanCreateRequest creates the InitiateScan request.
func (client *ManagedDatabaseVulnerabilityAssessmentScansClient) initiateScanCreateRequest(ctx context.Context, resourceGroupName string, managedInstanceName string, databaseName string, vulnerabilityAssessmentName VulnerabilityAssessmentName, scanID string, options *ManagedDatabaseVulnerabilityAssessmentScansClientBeginInitiateScanOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/managedInstances/{managedInstanceName}/databases/{databaseName}/vulnerabilityAssessments/{vulnerabilityAssessmentName}/scans/{scanId}/initiateScan"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if managedInstanceName == "" {
		return nil, errors.New("parameter managedInstanceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{managedInstanceName}", url.PathEscape(managedInstanceName))
	if databaseName == "" {
		return nil, errors.New("parameter databaseName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{databaseName}", url.PathEscape(databaseName))
	if vulnerabilityAssessmentName == "" {
		return nil, errors.New("parameter vulnerabilityAssessmentName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{vulnerabilityAssessmentName}", url.PathEscape(string(vulnerabilityAssessmentName)))
	if scanID == "" {
		return nil, errors.New("parameter scanID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{scanId}", url.PathEscape(scanID))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2020-11-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	return req, nil
}

// NewListByDatabasePager - Lists the vulnerability assessment scans of a database.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2020-11-01-preview
// resourceGroupName - The name of the resource group that contains the resource. You can obtain this value from the Azure
// Resource Manager API or the portal.
// managedInstanceName - The name of the managed instance.
// databaseName - The name of the database.
// vulnerabilityAssessmentName - The name of the vulnerability assessment.
// options - ManagedDatabaseVulnerabilityAssessmentScansClientListByDatabaseOptions contains the optional parameters for the
// ManagedDatabaseVulnerabilityAssessmentScansClient.ListByDatabase method.
func (client *ManagedDatabaseVulnerabilityAssessmentScansClient) NewListByDatabasePager(resourceGroupName string, managedInstanceName string, databaseName string, vulnerabilityAssessmentName VulnerabilityAssessmentName, options *ManagedDatabaseVulnerabilityAssessmentScansClientListByDatabaseOptions) *runtime.Pager[ManagedDatabaseVulnerabilityAssessmentScansClientListByDatabaseResponse] {
	return runtime.NewPager(runtime.PagingHandler[ManagedDatabaseVulnerabilityAssessmentScansClientListByDatabaseResponse]{
		More: func(page ManagedDatabaseVulnerabilityAssessmentScansClientListByDatabaseResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *ManagedDatabaseVulnerabilityAssessmentScansClientListByDatabaseResponse) (ManagedDatabaseVulnerabilityAssessmentScansClientListByDatabaseResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.listByDatabaseCreateRequest(ctx, resourceGroupName, managedInstanceName, databaseName, vulnerabilityAssessmentName, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.NextLink)
			}
			if err != nil {
				return ManagedDatabaseVulnerabilityAssessmentScansClientListByDatabaseResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return ManagedDatabaseVulnerabilityAssessmentScansClientListByDatabaseResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return ManagedDatabaseVulnerabilityAssessmentScansClientListByDatabaseResponse{}, runtime.NewResponseError(resp)
			}
			return client.listByDatabaseHandleResponse(resp)
		},
	})
}

// listByDatabaseCreateRequest creates the ListByDatabase request.
func (client *ManagedDatabaseVulnerabilityAssessmentScansClient) listByDatabaseCreateRequest(ctx context.Context, resourceGroupName string, managedInstanceName string, databaseName string, vulnerabilityAssessmentName VulnerabilityAssessmentName, options *ManagedDatabaseVulnerabilityAssessmentScansClientListByDatabaseOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/managedInstances/{managedInstanceName}/databases/{databaseName}/vulnerabilityAssessments/{vulnerabilityAssessmentName}/scans"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if managedInstanceName == "" {
		return nil, errors.New("parameter managedInstanceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{managedInstanceName}", url.PathEscape(managedInstanceName))
	if databaseName == "" {
		return nil, errors.New("parameter databaseName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{databaseName}", url.PathEscape(databaseName))
	if vulnerabilityAssessmentName == "" {
		return nil, errors.New("parameter vulnerabilityAssessmentName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{vulnerabilityAssessmentName}", url.PathEscape(string(vulnerabilityAssessmentName)))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2020-11-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listByDatabaseHandleResponse handles the ListByDatabase response.
func (client *ManagedDatabaseVulnerabilityAssessmentScansClient) listByDatabaseHandleResponse(resp *http.Response) (ManagedDatabaseVulnerabilityAssessmentScansClientListByDatabaseResponse, error) {
	result := ManagedDatabaseVulnerabilityAssessmentScansClientListByDatabaseResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.VulnerabilityAssessmentScanRecordListResult); err != nil {
		return ManagedDatabaseVulnerabilityAssessmentScansClientListByDatabaseResponse{}, err
	}
	return result, nil
}
