// Code generated by smithy-go-codegen DO NOT EDIT.

package emr

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/emr/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Cancels a pending step or steps in a running cluster. Available only in Amazon
// EMR versions 4.8.0 and later, excluding version 5.0.0. A maximum of 256 steps
// are allowed in each CancelSteps request. CancelSteps is idempotent but
// asynchronous; it does not guarantee that a step will be canceled, even if the
// request is successfully submitted. When you use Amazon EMR releases 5.28.0 and
// later, you can cancel steps that are in a PENDING or RUNNING state. In earlier
// versions of Amazon EMR, you can only cancel steps that are in a PENDING state.
func (c *Client) CancelSteps(ctx context.Context, params *CancelStepsInput, optFns ...func(*Options)) (*CancelStepsOutput, error) {
	if params == nil {
		params = &CancelStepsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CancelSteps", params, optFns, c.addOperationCancelStepsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CancelStepsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

// The input argument to the CancelSteps operation.
type CancelStepsInput struct {

	// The ClusterID for the specified steps that will be canceled. Use RunJobFlow and ListClusters to get
	// ClusterIDs.
	//
	// This member is required.
	ClusterId *string

	// The list of StepIDs to cancel. Use ListSteps to get steps and their states for the
	// specified cluster.
	//
	// This member is required.
	StepIds []string

	// The option to choose to cancel RUNNING steps. By default, the value is
	// SEND_INTERRUPT .
	StepCancellationOption types.StepCancellationOption

	noSmithyDocumentSerde
}

// The output for the CancelSteps operation.
type CancelStepsOutput struct {

	// A list of CancelStepsInfo, which shows the status of specified cancel requests for each StepID
	// specified.
	CancelStepsInfoList []types.CancelStepsInfo

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCancelStepsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpCancelSteps{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpCancelSteps{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CancelSteps"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addOpCancelStepsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCancelSteps(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opCancelSteps(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CancelSteps",
	}
}
