.\"
.\" Manual page for HTMLDOC, a HTML document processing program.
.\"
.\" Copyright 2011-2025 by Michael R Sweet.
.\" Copyright 1997-2010 by msweet.org.
.\"
.\" This program is free software.  Distribution and use rights are outlined
.\" in the file "COPYING".
.\"
.TH htmldoc 1 "HTMLDOC 1.9.21" "2025-01-24" "Michael R Sweet"
.SH NAME
htmldoc \- convert html source files into html, postscript, or pdf.
.SH SYNOPSIS
htmldoc [options] filename1.{html,md} [ ... filenameN.{html,md} ]
.LP
htmldoc [options] \-
.LP
htmldoc [filename.book]
.SH DESCRIPTION
.BR Htmldoc (1)
converts HTML and Markdown source files into indexed HTML, PostScript, or
Portable Document Format (PDF) files that can be viewed online or printed.
With no options a HTML document is produced on stdout.
.LP
The second form of
.B htmldoc
reads HTML source from stdin, which allows you to use
.B htmldoc
as a filter.
.LP
The third form of
.B htmldoc
launches a graphical interface that allows you to change options and generate documents interactively.
.SH COMMON MISTAKES
There are two types of HTML files - structured documents using headings (H1, H2, etc.) which
.B htmldoc
calls "books", and unstructured documents that do not use headings which
.B htmldoc
calls "web pages".
.LP
A very common mistake is to try converting a web page using:
.nf
    htmldoc \-f filename.pdf filename.html
.fi
which will likely produce a PDF file with no pages.
To convert web page files you
.B must
use the
.I \-\-webpage
or
.I \-\-continuous
options at the command-line or choose
.I Web Page
or
.I Continuous
in the input tab of the GUI.
.SH OPTIONS
The following command-line options are supported by
.BR htmldoc :
.TP 5
.BI \-\-batch " filename.book"
Generates the specified book file without opening the GUI.
.TP 5
.BI \-\-bodycolor " color"
Specifies the background color for all pages.
.TP 5
.BI \-\-bodyfont " {courier,helvetica,monospace,sans,serif,times}"
.TP 5
.BI \-\-textfont " {courier,helvetica,monospace,sans,serif,times}"
Specifies the default typeface for all normal text.
.TP 5
.BI \-\-bodyimage " filename"
Specifies the background image that is tiled on all pages.
.TP 5
.B \-\-book
Specifies that the HTML sources are structured (headings, chapters, etc.)
.TP 5
.BI \-\-bottom " margin"
Specifies the bottom margin in points (no suffix or ##pt), inches (##in), centimeters (##cm), or millimeters (##mm).
.TP 5
.BI \-\-charset " {cp-nnnn,iso-8859-1,...,iso-8859-15,utf-8}"
Specifies the character set to use for the output.
Note: UTF-8 support is limited to the first 128 Unicode characters that are found in the input.
.TP 5
.B \-\-color
Specifies that PostScript or PDF output should be in color.
.TP 5
.B \-\-continuous
Specifies that the HTML sources are unstructured (plain web pages.) No page breaks are inserted between each file or URL in the output.
.TP 5
.BI \-\-datadir " directory"
Specifies the location of the
.B htmldoc
data files, usually
.I /usr/share/htmldoc
or
.I C:/Program Files/HTMLDOC.
.TP 5
.B \-\-duplex
Specifies that the output should be formatted for double-sided printing.
.TP 5
.BI \-\-effectduration " {0.1...10.0}"
Specifies the duration in seconds of PDF page transition effects.
.TP 5
.B \-\-embedfonts
Specifies that fonts should be embedded in PDF and PostScript output.
.TP 5
.B \-\-encryption
Enables encryption of PDF files.
.TP 5
.BI \-\-fontsize " size"
Specifies the default font size for body text.
.TP 5
.BI \-\-fontspacing " spacing"
Specifies the default line spacing for body text. The line spacing is a multiplier for the font size, so a value of 1.2 will provide an additional 20% of space between the lines.
.TP 5
.BI \-\-footer " fff"
Sets the page footer to use on body pages. See the
.B HEADERS/FOOTERS FORMATS
section below.
.TP 5
.BI \-\-format " format"
.TP 5
.BI \-t " format"
Specifies the output format: epub, html, htmlsep (separate HTML files for each heading in the table-of-contents), ps or ps2 (PostScript Level 2), ps1 (PostScript Level 1), ps3 (PostScript Level 3), pdf11 (PDF 1.1/Acrobat 2.0), pdf12 (PDF 1.2/Acrobat 3.0), pdf or pdf13 (PDF 1.3/Acrobat 4.0), or pdf14 (PDF 1.4/Acrobat 5.0).
.TP 5
.B \-\-gray
Specifies that PostScript or PDF output should be grayscale.
.TP 5
.BI \-\-header " fff"
Sets the page header to use on body pages. See the
.B HEADERS/FOOTERS FORMATS
section below.
.TP 5
.BI \-\-header1 " fff"
Sets the page header to use on the first body/chapter page. See the
.B HEADERS/FOOTERS FORMATS
section below.
.TP 5
.BI \-\-headfootfont " font"
Sets the font to use on headers and footers.
.TP 5
.BI \-\-headfootsize " size"
Sets the size of the font to use on headers and footers.
.TP 5
.BI \-\-headingfont " typeface"
Sets the typeface to use for headings.
.TP 5
.B \-\-help
Displays a summary of command-line options.
.TP 5
.BI \-\-helpdir " directory"
Specifies the location of the
.B htmldoc
online help files, usually
.I /usr/share/doc/htmldoc
or
.I C:/Program Files/HTMLDOC/DOC.
.TP 5
.BI \-\-hfimageN " filename"
Specifies an image (numbered from 1 to 10) to be used in the header or footer in a PostScript or PDF document.
.TP 5
.BI \-\-jpeg [=quality]
Sets the JPEG compression level to use for large images. A value of 0 disables JPEG compression.
.TP 5
.BI \-\-left " margin"
Specifies the left margin in points (no suffix or ##pt), inches (##in), centimeters (##cm), or millimeters (##mm).
.TP 5
.BI \-\-letterhead " filename"
Specifies an image to be used as a letterhead in the header or footer in a PostScript or PDF document.
Note that you need to use the
.I \-\-header, \-\-header1,
and/or
.I \-\-footer
options with the
.I L
parameter or use the corresponding HTML page comments to display the letterhead image in the header or footer.
.TP 5
.BI \-\-linkcolor " color"
Sets the color of links.
.TP 5
.B \-\-links
Enables generation of links in PDF files (default).
.TP 5
.BI \-\-linkstyle " {plain,underline}"
Sets the style of links.
.TP 5
.BI \-\-logoimage " filename"
Specifies an image to be used as a logo in the header or footer in a PostScript or PDF document, and in the navigation bar of a HTML document.
Note that you need to use the
.I \-\-header, \-\-header1,
and/or
.I \-\-footer
options with the
.I l
parameter or use the corresponding HTML page comments to display the logo image in the header or footer.
.TP 5
.B \-\-no-compression
Disables compression of PostScript or PDF files.
.TP 5
.B \-\-no-duplex
Disables double-sided printing.
.TP 5
.B \-\-no-embedfonts
.br
Specifies that fonts should not be embedded in PDF and PostScript output.
.TP 5
.B \-\-no-encryption
Disables document encryption.
.TP 5
.B \-\-no-jpeg
Disables JPEG compression of large images.
.TP 5
.B \-\-no-links
Disables generation of links in a PDF document.
.TP 5
.B \-\-no-numbered
Disables automatic heading numbering.
.TP 5
.B \-\-no-pscommands
Disables generation of PostScript setpagedevice commands.
.TP 5
.B \-\-no-strict
Disables strict HTML input checking.
.TP 5
.B \-\-no-title
Disables generation of a title page.
.TP 5
.B \-\-no-toc
Disables generation of a table of contents.
.TP 5
.B \-\-numbered
Numbers all headings in a document.
.TP 5
.BI \-\-nup " pages"
Sets the number of pages that are placed on each output page. Valid values are 1, 2, 4, 6, 9, and 16.
.TP 5
.BI \-\-outdir " directory"
.TP 5
.BI \-d " directory"
Specifies that output should be sent to a directory in multiple files. (Not compatible with PDF output)
.TP 5
.BI \-\-outfile " filename"
.TP 5
.BI \-f " filename"
Specifies that output should be sent to a single file.
.TP 5
.BI \-\-owner-password " password"
Sets the owner password for encrypted PDF files.
.TP 5
.BI \-\-pageduration " I{1.0...60.0}"
Sets the view duration of a page in a PDF document.
.TP 5
.BI \-\-pageeffect " effect"
Specifies the page transition effect for all pages; this attribute is ignored by all Adobe PDF viewers.
.TP 5
.BI \-\-pagelayout " {single,one,twoleft,tworight}"
Specifies the initial layout of pages for a PDF file.
.TP 5
.BI \-\-pagemode " {document,outlines,fullscreen}"
Specifies the initial viewing mode for a PDF file.
.TP 5
.BI \-\-path " \"dir1;dir2;dir3;...;dirN\""
Specifies a search path for files in a document.
.TP 5
.BI \-\-permissions " permission[,permission,...]"
Specifies document permissions for encrypted PDF files. The following permissions are understood: all, none, annotate, no-annotate, copy, no-copy, modify, no-modify, print, and no-print. Separate multiple permissions with commas.
.TP 5
.BI \-\-pre\-indent " distance"
Specifies the indentation of pre-formatted text in points (no suffix or ##pt), inches (##in), centimeters (##cm), or millimeters (##mm).
.TP 5
.B \-\-pscommands
Specifies that PostScript setpagedevice commands should be included in the output.
.TP 5
.B \-\-quiet
Suppresses all messages, even error messages.
.TP 5
.BI \-\-referer " url"
Specifies the URL that is passed in the Referer: field of HTTP requests.
.TP 5
.BI \-\-right " margin"
Specifies the right margin in points (no suffix or ##pt), inches (##in), centimeters (##cm), or millimeters (##mm).
.TP 5
.BI \-\-size " pagesize"
Specifies the page size using a standard name or in points (no suffix or ##x##pt), inches (##x##in), centimeters (##x##cm), or millimeters (##x##mm). The standard sizes that are currently recognized are "letter" (8.5x11in), "legal" (8.5x14in), "a4" (210x297mm), and "universal" (8.27x11in).
.TP 5
.B \-\-strict
Enables strict HTML input checking.
.TP 5
.BI \-\-textcolor " color"
Specifies the default color of all text.
.TP 5
.B \-\-title
Enables the generation of a title page.
.TP 5
.BI \-\-titlefile " filename"
.TP 5
.BI \-\-titleimage " filename"
Specifies the file to use for the title page.
If the file is an image then the title page is automatically generated using the document meta data and title image.
.TP 5
.BI \-\-tocfooter " fff"
Sets the page footer to use on table-of-contents pages. See the
.B HEADERS/FOOTERS FORMATS
section below.
.TP 5
.BI \-\-tocheader " fff"
Sets the page header to use on table-of-contents pages. See the
.B HEADERS/FOOTERS FORMATS
section below.
.TP 5
.BI \-\-toclevels " levels"
Sets the number of levels in the table-of-contents.
.TP 5
.BI \-\-toctitle " string"
Sets the title for the table-of-contents.
.TP 5
.BI \-\-top " margin"
Specifies the top margin in points (no suffix or ##pt), inches (##in), centimeters (##cm), or millimeters (##mm).
.TP 5
.BI \-\-user-password " password"
Specifies the user password for encryption of PDF files.
.TP 5
.B \-\-verbose
.TP 5
.B \-v
Provides verbose messages.
.TP 5
.B \-\-version
Displays the current version number.
.TP 5
.B \-\-webpage
Specifies that the HTML sources are unstructured (plain web pages.) A page break is inserted between each file or URL in the output.
.SH EXIT STATUS
.B Htmldoc
returns a non-zero exit status if any errors are seen, zero otherwise.
.SH HEADER/FOOTER FORMATS
The header and footer of each page can contain up to three preformatted values.
These values are specified using a single character for the left, middle, and right of the page, resulting in the
.I fff
notation shown previously.
.LP
Each character can be one of the following:
.TP 5
.B .
blank
.TP 5
.B /
n/N arabic page numbers (1/3, 2/3, 3/3)
.TP 5
.B :
c/C arabic chapter page numbers (1/2, 2/2, 1/4, 2/4, ...)
.TP 5
.B 1
arabic numbers (1, 2, 3, ...)
.TP 5
.B a
lowercase letters
.TP 5
.B A
uppercase letters
.TP 5
.B c
current chapter heading
.TP 5
.B C
current chapter page number (arabic)
.TP 5
.B d
current date
.TP 5
.B D
current date and time
.TP 5
.B h
current heading
.TP 5
.B i
lowercase roman numerals
.TP 5
.B I
uppercase roman numerals
.TP 5
.B l
logo image
.TP 5
.B L
logo image as letterhead - the image is inserted at its maximum size
.TP 5
.B t
title text
.TP 5
.B T
current time
.TP 5
.B u
current filename or URL

.SH ENVIRONMENT
HTMLDOC looks for several environment variables which can override the default directories, display additional debugging information, and disable CGI mode:
.TP 5
.B HTMLDOC_DATA
This environment variable specifies the location of
.BR htmldoc 's
data and fonts directories, normally /usr/share/htmldoc or C:/Program Files/HTMLDOC.
.TP 5
.B HTMLDOC_DEBUG
This environment variable enables debugging information that is sent to stderr. The value is a list of any of the following keywords separated by spaces: "all", "links", "memory", "remotebytes", "table", "tempfiles", and/or "timing".
.TP 5
.B HTMLDOC_HELP
This environment variable specifies the location of
.BR htmldoc 's
documentation directory, normally /usr/share/doc/htmldoc or C:/Program Files/HTMLDOC/doc.
.TP 5
.B HTMLDOC_NOCGI
This environment variable, when set (the value doesn't matter), disables CGI mode. It is most useful for using
.B htmldoc
on a web server from a scripting language or invocation from a program.
.SH EXAMPLES
Create a PDF file from a web site:
.nf
    htmldoc \-\-webpage -f example.pdf http://www.example.com/
.fi
Create a PostScript book from a directory of HTML files
.nf
    htmldoc \-\-book -f example.pdf *.html
.fi
.SH SEE ALSO
HTMLDOC Users Manual
.LP
https://www.msweet.org/htmldoc
.SH AUTHOR
Michael R Sweet
.SH LEGAL STUFF
HTMLDOC is copyright \[co] 1997-2025 by Michael R Sweet.
.PP
This program is free software; you can redistribute it and/or modify it under
the terms of the GNU General Public License version 2 as published by the Free
Software Foundation.
.PP
This program is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
PARTICULAR PURPOSE.  See the GNU General Public License for more details.
.PP
You should have received a copy of the GNU General Public License along with
this program; if not, write to the Free Software Foundation, Inc., 59 Temple
Place, Suite 330, Boston, MA 02111-1307 USA.
