ITK Release 5.0 Alpha 1
=======================

ITK 5.0 brings dramatic improvements to ITK's API and performance. At the same time, there are minimal changes that break backwards compatibility.

This the first in a series of alpha releases to enable the community to test and improve these major changes.

In this first alpha release, we highlight ITK's adoption of and requirement for the **C++11 standard**. Prior to this release, a subset of C++11 functionality was utilized, when available, through backports and macros. ITKv5 deprecates or removes these macros (e.g. `ITK_NULLPTR`, `ITK_DELETED_FUNCTION`, ` ITK_NOEXCEPT`, `ITK_CONSTEXPR`) and directly uses C++11 keywords such as [`delete`](https://github.com/InsightSoftwareConsortium/ITK/commit/02128abbd0bf790deadc86a28c62c4a25e23518b), [`constexpr`](https://github.com/InsightSoftwareConsortium/ITK/commit/b8e41d0d1652a8f6ddb84328faef67b207e77430), [`nullptr`](https://github.com/InsightSoftwareConsortium/ITK/commit/3c6372b80ac2900e2e197899989c4cd151f1695f), [`override`](https://github.com/InsightSoftwareConsortium/ITK/commit/3ceacc0ad4ec699b094d96e23d33f9467c2a63c6), [`noexcept`](https://github.com/InsightSoftwareConsortium/ITK/commit/af4f65519abb32b59cebb2d72f0186a96efe3b4e). The keywords [`auto`](https://github.com/InsightSoftwareConsortium/ITK/commit/de713e7ac52f7815a35754de885795ff0a1c4981) and  [`using`](https://github.com/InsightSoftwareConsortium/ITK/commit/66e5d6b3bcc28f1a85b702086b6cedc8cab6723b) as well as [range-based loops](https://github.com/InsightSoftwareConsortium/ITK/commit/48daed0751df99bcb5fd1077e78ceb1b47546ccc) are also now used heavily throughout ITK.

ITKv5 includes some API changes. Even though we tried to minimize backward compatibility issues, there will be a few (see below for important changes). These changes were discussed by the community on the ITK Discourse forum [[1]](https://discourse.itk.org/t/gearing-up-for-itk5/515)[[2]](https://discourse.itk.org/t/gearing-up-for-itk5/515/4)[[3]](https://discourse.itk.org/t/new-build-errors-on-cdash-1-24-18-drop-support-for-vs2013-in-itkv5/619/3)[[4]](https://discourse.itk.org/t/opinions-on-dropping-support-for-c-03/481/4). This ITK alpha release is purposefully created with the goal of helping developers to test their current software with this new ITK version, update their code if necessary, and report problems they encountered during this process.

ITK now [requires](https://github.com/InsightSoftwareConsortium/ITK/commit/3525bf45200bd9845259ea9a88f586684cc522db) CMake 3.9.5 for configuration and a compiler that supports C++11. This means that Visual Studio 2015 or later is required for Windows development with the Microsoft toolchain.

Important [changes in style](https://itk.org/ITKSoftwareGuide/html/Book1/ITKSoftwareGuide-Book1ch13.html#x57-259000C) have also been integrated in ITK to match the C++11 best practices. This includes replacing `typedef` calls with the `using` keyword, the usage of the keyword `auto` when appropriate, and moving the macro `ITK_DISALLOW_COPY_AND_ASSIGN` from the private class section to the public class section. The [ITK Software Guide](https://itk.org/ITKSoftwareGuide/html/) has been updated to match these changes.

As shown below, toolkit has adopted the application of the `using` keyword for [type aliases](https://en.cppreference.com/w/cpp/language/type_alias), which many developers find easier to read and understand.

```
  template< typename TInputImage, typename TOutputImage >
  class ITK_TEMPLATE_EXPORT BoxImageFilter:
    public ImageToImageFilter< TInputImage, TOutputImage >
  {
  public:
    ITK_DISALLOW_COPY_AND_ASSIGN(BoxImageFilter);

    /⋆⋆ Standard class type alias. ⋆/
    using Self = BoxImageFilter;
    using Superclass = ImageToImageFilter< TInputImage, TOutputImage >;

    [...]

  protected:
    BoxImageFilter();
    ~BoxImageFilter() {}

    void GenerateInputRequestedRegion() override;
    void PrintSelf(std::ostream & os, Indent indent) const override;

  private:
    RadiusType m_Radius;
  };

  } // end namespace itk
```

For more information on style changes, see the [Coding Style Guide](https://itk.org/ITKSoftwareGuide/html/Book1/ITKSoftwareGuide-Book1ch13.html#x57-259000C) found in the ITK Software Guide.

To test the 5.0 Alpha 1 Python packages, run

```bash
python -m pip install --upgrade pip
python -m pip install --upgrade --pre itk
```

For a full list of the new features and changes in API, please review the log below. The community has been busy -- there have been **319 commits, 97,794 insertions, 152,791 deletions** since 4.13.0 was released in December!

Please discuss your experiences on [Discourse](https://discourse.itk.org/). The API is expected to change across alpha releases as we improve the library based on our experiences.

```
Changes from v4.13.0 to v5.0 Alpha1
------------------------------------------------

Bradley Lowekamp (49):
    ENH: Adding more swap methods
    BUG: Respect Visibility Preset for initial template visibility
    COMP: Use explicit equality for boolean evaluation of real number
    BUG: Keep the SetSeed# methods in IsolatedConnectedImageFilter
    ENH: Use direct for loops for implementing image transformations
    COMP: Use anonymous namespace for internal linkage
    ENH: Mark 2 template parameter ModulusTransform to be removed
    COMP: Remove legacy marking on definition of SetSeed methods
    STYLE: Use itk::v3 nested namespace for Rigid3DTransform
    BUG: Preserve option to use a "label value" mask and boolean mask
    ENH: update C+11 headers and try compile for headers
    ENH: Remove duplicated CMake module from upstream CMake
    COMP: Explicitly include the fixed width integer header before usage
    COMP: Update SimpleITKFilters for dependency issues
    BUG: The CXX language must be enable to check compiler variables
    PERF: Support move semantics for ITK smart pointers
    ENH: Remove usage of SmartPointerForward reference
    ENH: Remove unneeded internal smart pointer type
    COMP: Require MSVC VS14 2015 for C++11 compatibility
    ENH: Use C++11 template alias for Image::Rebind
    STYLE: Use copy-swap idiom for SmartPointer
    ENH: Use std::unique_ptr over itk::AutoPointer
    DOC: Document additional MaskValue variable
    BUG: remove unused cmake CXX try compile file
    BUG: Remove un-configured and unused CMake configure define
    BUG: Improve Doxygen extraction with blank line
    ENH: Remove TEMPLATED_FRIEND macro and try compile
    ENH: Replace optional tr1 type_traits with c++11 standard
    ENH: Assume c++11, remove configure defines for optional TR1 features
    BUG: Add missing extensions to ImageIO
    ENH: Only use std::atomic implementation for AtomicInt class
    ENH: Add direct SmartPointer conversions to match raw Pointers
    PERF: Use emplace when inserting into map for ProcessObject
    ENH: Create virtual interface for the MultiTheader
    ENH: Trying out the ThreadPool as a separate MultiThreader
    BUG: Fix uninitialized cross structuring element buffer
    BUG: Disable ThreadPools by default
    COMP: Add forward declaration of ExceptionObject in Macro.h
    COMP: Add forward declaration of ExceptionObject in Macro.h
    ENH: Use gtest_discover_tests if available
    DOC: Watershed filters is not stream-able
    COMP: Use nullptr over 0 for null pointer
    STYLE: Use SmartPointer direct conversion constructors
    Revert "BUG: Disable ThreadPools by default"
    BUG: Actually disable ThreadPools by default
    COMP: Suppress warning on CircleCI about itkIndex out of bounds
    ENH: Update CircleCI external data cache
    ENH: Address incorrect types with neighborhood iterator base class
    COMP: Make MirrorPadImageFilter::DelayBase a conventional parameter

Bryce A Besler (1):
    ENH: Move DiscreteGaussianDerivativeImageFilter from Review to ITKImageFeature

Dženan Zukić (27):
    ENH: updating SphinxExamples and pointing to GitHub
    COMP: Get rid of warning about registry key
    STYLE: minor fixes
    BUG: duplicator crashes if buffered region is smaller than largest region
    STYLE: reducing code duplication and cleaning up method documentation
    ENH: adding itkReviewPrintTest to tests. It existed but was not invoked.
    COMP: turn FEM off by default, as it takes a long time to build
    COMP: fixing compiler warnings
    ENH: making ITKBioCell and ITKNeuralNetworks remote modules
    COMP: fixing configure error
    COMP: long paths are not yet supported by all the tools in the build chain
    COMP: using ITK_DELETED_FUNCTION, and more consistent override specifier
    ENH: simplify code and properly support long long type
    COMP: fix compile warning
    STYLE: avoid redirect for repository address in DVMeshNoise
    ENH: update remote modules to require CMake 3.9.5
    BUG: fixing crash in test
    ENH: Remove ITKFEMRegistration from default configuration
    ENH: Fixing error and improving examples' test
    ENH: Use MultiThreaderBase
    STYLE: reducing duplication and removing commented code in DistanceMap tests
    STYLE: fixing typo
    BUG: more reliably detect Windows+DLLs case
    ENH: enable thread pool by default
    ENH: adding exponential decay option to MirrorPadImageFilter
    BUG: Set/GetGlobalDefaultNumberOfThreads was forgotten in legacy #ifdef
    BUG: fixing Windows+DLL ThreadPool sporadic destructor hanging

Francois Budin (17):
    BUG: Update ITK test files SHA and debug ContentLinkSynchronization.sh
    ENH: Bump ITK version to 5.0.0.
    ENH: lifting path length limitation on Windows 10 version 1607+
    BUG: Remove bad guards stopping inclusion of necessary hxx file
    BUG: Remove extern "C" call to include <cstring>
    BUG: Initializes CMAKE_DEBUG_POSTFIX to be empty
    BUG: Initializes CMAKE_DEBUG_POSTFIX to be empty
    DOC: Remove CMake comments mentioning CMake 3.4
    DOC: ITK_CONSTEXPR* and ITK_HAS_CXX11_RVREF are deprecated
    BUG: DCMTK builds fails with ICU ON on Linux and Mac
    BUG: LabelErodeDilate remote module repositories are out of sync
    BUG: Projects could not link to DCMTK on Windows and MacOS
    DOC: Add missing documentation for `github_compare` option
    ENH: Update CMake code to use IN_LIST (CMake >= 3.3)
    BUG: Update LabelErodeDilate
    ENH: Compile ITK with MKL (FFTW) installed on system
    BUG: Update ParabolicMorphology remote module

Gregory C. Sharp (1):
    DOC: Fix misspelling of vertices

Hans Johnson (86):
    ENH: Update Wiki examples for latest code changes
    COMP: Remove override warnings
    ENH: Cuberille future compilation deprecations
    ENH: Strain future compilation deprecations
    COMP: TwoProjectionRegistration Future proof code
    COMP: LevelSetsv4 used deprecated api
    COMP: N4 remove testing of deprecated SetMaskLabel
    BUG: Provide consistent GetOutput behavior
    BUG: GetModifiableTransformList needs to always be available
    BUG: Restore backwards compatibility
    DOC: Remove ITKv3 to ITKv4 migration documentation.
    COMP: Provide migration documentation old macros
    STYLE: Remove deprecated code directory contents
    STYLE: Remove all vestiges of ITKv3 code
    STYLE: Remove legacy code for ITKv5 starting
    ENH: Revert to include itkv3::Rigid3DTransform
    STYLE: Move Future deprecated to deprecated
    BUG: Restored testing for long HistorgramMatching
    COMP: Remove unnecessary conditional tests
    COMP: Force using lower deployment targert for fftw
    COMP: Use C++ headers over C headers
    COMP: Set ITK_VERSION_MAJOR to 5
    STYLE: Fix header guard format
    COMP: Remove ITK_USE_STRICT_CONCEPT_CHECKING flag
    ENH: Set cmake Minimums to 3.9.5
    COMP: Change min cmake version to 3.9.5 for circleci
    COMP: Directly use cmake compiler_detection.h
    STYLE: Fix typo requireing -> requiring
    COMP: Consistently set use of CMake 3.9.5 and options
    COMP: Enforce building ITK with C++11
    COMP: Modularize cmake config like VTK.
    COMP: Use C++ headers over C headers (part 2)
    ENH: Scripts used during ITKv5 migration
    STYLE: Remove conditional version 201103L code
    COMP: Need to match type for different threaders
    COMP: Preparing for ITKv5 by adding override
    COMP:  Use C++11 override directly
    STYLE: Use override statements for C++11
    COMP:  Use C++11 ITK_NULLPTR directly
    COMP: Use nullptr instead of 0 or NULL
    STYLE: Prefer nullptr for C++11
    COMP:  Use C++11 nullptr directly
    BUG: VXL visibility must match ITK visibility
    COMP:  Use C++11 = delete directly
    COMP:  Use C++11 constexpr directly
    STYLE: ITK_COMPILER_CXX_CONSTEXPR is always true
    BUG: Missing external linkage options for float and double.
    COMP: Remove deprecated C++ 11 features
    ENH: ReplaceitkGetObjectMacro.sh used during ITKv5 migration
    ENH: Update SeveralRemotes to latest version.
    COMP: Suppress invalid warning
    STYLE: Remove outdated conditional code
    STYLE: Remove unnecessary old CMakeCode
    ENH: Remote for SmoothingRecursiveYvvGaussianFilter
    STYLE: Prefer C++11 type alias over typedef
    BUG: Type alias errent typo in name
    BUG: ConceptChecking type matching failed.
    STYLE: Remove ITK_HAS variables that should not be defined
    COMP: Allow using cmake 3.9.5 default for RPATH setting
    STYLE: Replace itkStaticConstMacro with static constexpr
    BUG: Propagate C++11 requirements to external project
    STYLE: Prefer constexpr for const numeric literals
    STYLE: Use range-based loops from C++11
    PERF: Allow compiler to choose best way to construct a copy
    PERF: Replace explicit return calls of constructor
    STYLE: Use auto for variable creation
    BUG: Restore ITK.kws.xml preferences
    ENH: Provide advanced development mode for writing GTests
    COMP:  Use C++11 noexcept directly
    ENH: Use simplified/natural conversion to const pointer
    ENH: Use natural ConstPointer conversion
    STYLE: Use override statements for C++11
    COMP:  Use C++11 noexcept directly
    ENH: Add google test for itkIndex.h
    ENH: Make const operator[] conform to standards
    STYLE: Change aggregate classes to mirror std::array
    ENH: Update all remote modules with C++11 conformance
    BUG: New SmartPointer conversion ambiguity
    BUG: Error in ITK_VERSION construction
    ENH:  Add introspection into the build process
    COMP: Silence warning of mismatched signs.
    ENH: Bring in C++11 updates for ITKBridgeNumPy
    STYLE: Do not use itkGetStaticConstMacro in ITK
    COMP: Make member name match kwstyle requirements.
    BUG: Add ability to construct SmartPointer with NULL
    BUG: Update NULL pointer patch with final fixes

Hastings Greer (1):
    ENH: Add wrapping for Labeled PointSet to PointSet registration classes

Jean-Christophe Fillion-Robin (3):
    BUG: Prevent gdcm "missing implementation" error on macOS
    BUG: Prevent gdcm "missing implementation" error on macOS
    STYLE: MeshIO: Introduce ITKIOMeshBase module. See #3393

Jon Haitz Legarreta (8):
    STYLE: Fix typo in itk::VariableLengthVector struct name.
    ENH: Set the InsightSoftwareConsortium repo as the remote.
    STYLE: Improve itkHoughTransform2DLinesImageFilter style.
    DOC: Add different GitHub badges to the `README.md` file.
    DOC: Change the ITK Git tips wiki page reference for Git scm website.
    DOC: Add commands in a `Review` section to the ITK Git cheat sheet.
    DOC: Change the `ITKGitCheatSheet.tex` file tittle.
    DOC: Make references to ITK issue tracking system consistent.

Jon Haitz Legarreta Gorroño (19):
    BUG: Fix bug in class LaTeX documentation Doxygen link.
    BUG: Fix unnecessary explicit itk namespace mention in Doxygen link.
    DOC: Remove redundant ellipsis after "etc." in LaTeX doc.
    DOC: Remove unnecessary EOF comments.
    DOC: Make namespace closing bracket comments consistent.
    DOC: Fix typo: substract to subtract.
    DOC: Remove unnecessary ifdef and class ending comments in FEM.
    DOC: Remove non-existing namespace comment.
    ENH: Add a code of conduct to the ITK project.
    ENH: Bump latest version of the ITKSplitComponents remote module.
    DOC: Remove unnecessary Doxygen \ref keyword in module crossrefs.
    DOC: Remove crossrefs to non-existing classes.
    DOC: Improve the ISSUE_TEMPLATE.md markdown file contents.
    DOC: Change the term `mailing list` in README.md.
    DOC: Fix syntax mistake in `Sharing Data` section of CoC.
    DOC: Fix typos in class doc.
    ENH: Add Python wrap file to itk::MultiResolutionPDEDeforableRegistration.
    STYLE: Update the wrap files to match current CMake syntax.
    DOC: Fix typo.

KWSys Upstream (1):
    KWSys 2018-01-08 (f7990fc2)

Marcus D. Hanwell (1):
    DOC: Add GitCheatSheet sources

Martino Pilia (2):
    BUG: fix itkFormatWarning in Python wrapping
    BUG: fix itkFormatWarning in Python wrapping

Matthew McCormick (46):
    BUG: Remove ITKTubeTK remote
    ENH: Add wrapping for BSplineTransformInitializer
    ENH: Add PolarTransform remote module
    COMP: Do not use absolute path to TestBigEndian.cmake in GDCM
    COMP: Enable pthreads shim with Emscripten
    COMP: Do not use absolute path to TestBigEndian.cmake in GDCM
    COMP: Enable pthreads shim with Emscripten
    BUG: Allow module examples to be enabled when built externally
    ENH: Ensure external module examples get added to current build tree
    COMP: Specify OutputImageType for boundary conditions in FFTPadImageFilter
    COMP: Update DCMTK to 2018.01.16 and support Emscripten
    COMP: Fix cross compiling DCMTK
    BUG: Do not set DCMTK_WITH_XML to ON in DCMTK configuration
    COMP: itk::Math perfect forward return type
    BUG: Do not segfault when trying to use PDEDeformableRegistrationFilter
    COMP: Ensure CastXML uses C++11 with GCC or Clang
    COMP: Remove legacy BackTransform methods from Rigid3DTransform
    COMP: Explicitly add NumericTraits::max to the API
    COMP: Address SG line length warnings in DataRepresentation, Filtering
    DOC: Update README Software Guide link
    DOC: Update Discussion link in the README
    ENH: Add banner to the README
    COMP: Bump KWStyle to 2018-02-22 master
    COMP: Add missing wrapping for MultiThreaderBase
    COMP: Do not wrap methods with ?unknown? type
    COMP: Add missing itkSimpleFastMutexLock headers
    ENH: Import the ITKBridgeNumPy module
    BUG: GetArrayFromImage calls UpdateLargestPossibleRegion
    BUG: Add missing wrapping for PoolMultiThreader
    BUG: Exclude MultiThreaderBase from GetNameOfClass test
    COMP: Add SimpleFastMutexLock include to ESMDemonsRegistrationFunction
    BUG: Cast to correct iterator type in PeriodicBoundaryCondition
    BUG: Fix casting in PeriodicBoundaryCondition
    COMP: Work around RegionGrow2DTest compiler error on ppc64le
    BUG: Bump KWStyle for C++11 brace list initialization support
    BUG: Fix MeshFileWriter export specification
    BUG: Wrap long long instead of long
    ENH: Create ITKIOMeshVTK module
    COMP: ExceptionObject declaration must come before usage
    ENH: Migrate BYU IO into ITKIOMeshBYU
    COMP: Bump ParabolicMorphology for MultiThreaderChanges
    COMP: Remove SmartPointer NULL initialization compatibility code
    DOC: Use http for issues.itk.org
    ENH: Migrate MultiScaleHessianBasedMeasureImageFilter out of ITKReview
    ENH: Move ContourExtractor2DImageFilter out of ITKReview
    DOC: Avoid Voronoi term when referring to the pixel center

Niels Dekker (18):
    PERF: Improved speed of copying and resizing NeighborhoodAllocator
    STYLE: Removed 'char(255)' casts from NumericTraits min() and max()
    STYLE: Removed assignments from Neighborhood copy constructor
    BUG: Fixed semantics NeighborhoodAllocator operator== and operator!=
    BUG: GaussianDerivativeImageFunction should use image spacing consistently
    PERF: NeighborhoodOperatorImageFunction avoids copy ConstNeighborhoodIterator
    COMP: Worked around endless VS2015 Release compilation on Math::Floor
    PERF: Removed blurring from GaussianDerivativeImageFunction
    ENH: Added GetCenterPoint and SetCenterPoint to EllipseSpatialObject
    DOC: Explained calling GetCenterPoint() when using Hough filter->GetCircles()
    ENH: IsInside(point) made easier, especially for HoughTransform circles
    STYLE: Using C++11 auto in HoughTransform2DCirclesImageFilter
    PERF: GaussianDerivativeImageFunction now reuses NeighborhoodIterator objects
    PERF: GaussianDerivativeImageFunction constructor, RecomputeGaussianKernel()
    COMP: ITK_DISALLOW_COPY_AND_ASSIGN now unconditionally does '= delete'
    COMP: Moved ITK_DISALLOW_COPY_AND_ASSIGN calls to public section
    COMP: Manually moved ITK_DISALLOW_COPY_AND_ASSIGN calls to public section
    COMP: Moved ITK_DISALLOW_COPY_AND_ASSIGN calls in *.cxx to public section

Sean McBride (19):
    STYLE: Fixed up confusion between base 2 and base 10 prefixes
    STYLE: arranged/alphabetized things to make subsequent changes reviewable
    COMP: Fixed some missing name mangling of libTIFF symbols
    BUG: fixed crash on macOS under guardmalloc from RunOSCheck()
    BUG: don't use double underscore, which is reserved in C++
    STYLE: fixed some spelling, spacing, and comments
    DOC: Fixed comment about LegacyAnalyze75Mode default value
    BUG: Some minor cleanup and improvement after itkNiftiImageIO code review
    STYLE: arranged/alphabetized things to make subsequent changes reviewable
    COMP: Fixed some missing name mangling of libTIFF symbols
    BUG: Analyze 7.5 fixes/improvements
    COMP: Mangle HDF5 symbol names
    COMP: Fixed clang Wrange-loop-analysis warnings
    DOC: fixed minor typo in comment
    BUG: fixed crash on macOS under guardmalloc from RunOSCheck()
    COMP: Mangle HDF5 symbol names
    BUG: Revert part of f38b1dd4, which caused a regression
    ENH: Added new DetermineFileType() API to NiftiImageIO
    COMP: fixed clang warning about unnecessary copy in for loop

Simon Rit (1):
    BUG: fix deadlock in FFTW for windows shared libs

Taylor Braun-Jones (1):
    BUG: Handle single-component PLANARCONFIG_SEPARATE TIFF images (#ITK-3518)

VXL Maintainers (3):
    VNL 2018-01-25 (ed159d55)
    VNL 2018-01-31 (39559d06)
    VNL 2018-03-04 (09a097e6)

Ziv Yaniv (1):
    ENH: Adding user set min and max values for noise.
```
