C> \ingroup nwxc 
C> @{ 
C> 
C> \file nwxcm_x_tpss03.F 
C> The nwxcm_x_tpss03 functional 
C> 
C> @} 
C> 
C> \ingroup nwxc_priv 
C> @{ 
C> 
C> \brief Evaluate the nwxcm_x_tpss03 functional [1] 
C> 
C> \f{eqnarray*}{ 
C>   {\it t_1} &=& \rho_\alpha^{{{4}\over{3}}}\\\\ 
C>   {\it t_2} &=& \rho_\beta^{{{4}\over{3}}}\\\\ 
C>   {\it t_3} &=& {{1}\over{\rho_\alpha^{{{8}\over{3}}}}}\\\\ 
C>   {\it t_4} &=& {{1}\over{\rho_\alpha^{{{16}\over{3}}}}}\\\\ 
C>   {\it t_5} &=& \sigma_{\alpha\alpha}^2\\\\ 
C>   {\it t_6} &=& {{1}\over{\rho_\alpha}}\\\\ 
C>   {\it t_7} &=& \left({{{\it t_6}\,\sigma_{\alpha\alpha}}
C>    \over{\tau_\alpha}}\right)^{2.0}\\\\ 
C>   {\it t_8} &=& {{1}\over{\rho_\alpha^{{{5}\over{3}}}}}\\\\ 
C>   {\it t_9} &=& 2.0\,\tau_\alpha-0.25\,{\it t_6}\,
C>    \sigma_{\alpha\alpha}\\\\ 
C>   {\it t_{10}} &=& 0.1097020523068037\,{\it t_8}\,{\it t_9}-1.0\\\\ 
C>   {\it t_{11}} &=& {{0.45\,{\it t_{10}}}\over{
C>    \left(0.0438808209227215\,{\it t_8}\,{\it t_9}\,{\it t_{10}}
C>    +1.0\right)^{0.5}}}+0.01097020523068038\,{\it t_3}\,
C>    \sigma_{\alpha\alpha}\\\\ 
C>   {\it t_{12}} &=& {{1}\over{\rho_\beta^{{{8}\over{3}}}}}\\\\ 
C>   {\it t_{13}} &=& {{1}\over{\rho_\beta^{{{16}\over{3}}}}}\\\\ 
C>   {\it t_{14}} &=& \sigma_{\beta\beta}^2\\\\ 
C>   {\it t_{15}} &=& {{1}\over{\rho_\beta}}\\\\ 
C>   {\it t_{16}} &=& \left({{{\it t_{15}}\,
C>    \sigma_{\beta\beta}}\over{\tau_\beta}}\right)^{2.0}\\\\ 
C>   {\it t_{17}} &=& {{1}\over{\rho_\beta^{{{5}\over{3}}}}}\\\\ 
C>   {\it t_{18}} &=& 2.0\,\tau_\beta-0.25\,{\it t_{15}}\,
C>    \sigma_{\beta\beta}\\\\ 
C>   {\it t_{19}} &=& 0.1097020523068037\,{\it t_{17}}\,{\it t_{18}}
C>    -1.0\\\\ 
C>   {\it t_{20}} &=& {{0.45\,{\it t_{19}}}\over{
C>    \left(0.0438808209227215\,{\it t_{17}}\,{\it t_{18}}\,{
C>    \it t_{19}}+1.0\right)^{0.5}}}+0.01097020523068038\,{
C>    \it t_{12}}\,\sigma_{\beta\beta}\\\\ 
C>   {\it t_{21}} &=& \rho_s^{{{4}\over{3}}}\\\\ 
C>   {\it t_{22}} &=& {{1}\over{\rho_s^{{{8}\over{3}}}}}\\\\ 
C>   {\it t_{23}} &=& {{1}\over{\rho_s^{{{16}\over{3}}}}}\\\\ 
C>   {\it t_{24}} &=& \sigma_{ss}^2\\\\ 
C>   {\it t_{25}} &=& {{1}\over{\rho_s}}\\\\ 
C>   {\it t_{26}} &=& \left({{{\it t_{25}}\,\sigma_{ss}}
C>    \over{\tau_s}}\right)^{2.0}\\\\ 
C>   {\it t_{27}} &=& {{1}\over{\rho_s^{{{5}\over{3}}}}}\\\\ 
C>   {\it t_{28}} &=& 2.0\,\tau_s-0.25\,{\it t_{25}}\,\sigma_{ss}\\\\ 
C>   {\it t_{29}} &=& 0.1097020523068037\,{\it t_{27}}\,{\it t_{28}}
C>    -1.0\\\\ 
C>   {\it t_{30}} &=& {{0.45\,{\it t_{29}}}\over{
C>    \left(0.0438808209227215\,{\it t_{27}}\,{\it t_{28}}\,{
C>    \it t_{29}}+1.0\right)^{0.5}}}+0.01097020523068038\,{
C>    \it t_{22}}\,\sigma_{ss}\\\\ 
C>   f &=& -0.9305257363490997\,{\it t_2}\,\left(0.804
C>    -{{0.804}\over{{{1.243781094527363\,\left(0.07209876543209877
C>    \,{\it t_{20}}^2-0.1802469135802469\,\left(0.0028125\,{
C>    \it t_{16}}+1.35388578153653 \times 10^{-4}\,{\it t_{13}}\,{
C>    \it t_{14}}\right)^{0.5}\,{\it t_{20}}+0.01645530784602056
C>    \,{\it t_{12}}\,\sigma_{\beta\beta}\,\left({{0.02485875\,{
C>    \it t_{16}}}\over{\left(0.015625\,{\it t_{16}}
C>    +1.0\right)^{2.0}}}+0.1234567901234568\right)
C>    +0.001721886167929995\,{\it t_{16}}
C>    +{{1.503301918569225 \times 10^{-6}\,
C>    \sigma_{\beta\beta}^3}\over{\rho_\beta^8}}
C>    +5.133173416322327 \times 10^{-6}\,{\it t_{13}}\,{
C>    \it t_{14}}\right)}\over{\left(0.02040060021774676\,{
C>    \it t_{12}}\,\sigma_{\beta\beta}+1.0\right)^{2.0}}}+1.0}}\right)
C>    -0.9305257363490997\,{\it t_1}\,\left(0.804-{{0.804}
C>    \over{{{1.243781094527363\,\left(0.07209876543209877\,{
C>    \it t_{11}}^2-0.1802469135802469\,\left(0.0028125\,{\it t_7}
C>    +1.35388578153653 \times 10^{-4}\,{\it t_4}\,{
C>    \it t_5}\right)^{0.5}\,{\it t_{11}}+0.01645530784602056\,{
C>    \it t_3}\,\sigma_{\alpha\alpha}\,\left({{0.02485875\,{
C>    \it t_7}}\over{\left(0.015625\,{\it t_7}+1.0\right)^{2.0}}}
C>    +0.1234567901234568\right)+0.001721886167929995\,{\it t_7}
C>    +{{1.503301918569225 \times 10^{-6}\,
C>    \sigma_{\alpha\alpha}^3}\over{\rho_\alpha^8}}
C>    +5.133173416322327 \times 10^{-6}\,{\it t_4}\,{
C>    \it t_5}\right)}\over{\left(0.02040060021774676\,{\it t_3}
C>    \,\sigma_{\alpha\alpha}+1.0\right)^{2.0}}}+1.0}}\right)
C>    -0.9305257363490997\,{\it t_2}-0.9305257363490997\,{\it t_1}\\\\ 
C>   g &=& 0\\\\ 
C>   G &=& -0.9305257363490997\,{\it t_{21}}\,\left(0.804
C>    -{{0.804}\over{{{1.243781094527363\,\left(0.07209876543209877
C>    \,{\it t_{30}}^2-0.1802469135802469\,\left(0.0028125\,{
C>    \it t_{26}}+1.35388578153653 \times 10^{-4}\,{\it t_{23}}\,{
C>    \it t_{24}}\right)^{0.5}\,{\it t_{30}}+0.01645530784602056
C>    \,{\it t_{22}}\,\sigma_{ss}\,\left({{0.02485875\,{
C>    \it t_{26}}}\over{\left(0.015625\,{\it t_{26}}
C>    +1.0\right)^{2.0}}}+0.1234567901234568\right)
C>    +0.001721886167929995\,{\it t_{26}}
C>    +{{1.503301918569225 \times 10^{-6}\,\sigma_{ss}^3}
C>    \over{\rho_s^8}}+5.133173416322327 \times 10^{-6}\,{
C>    \it t_{23}}\,{\it t_{24}}\right)}\over{
C>    \left(0.02040060021774676\,{\it t_{22}}\,\sigma_{ss}
C>    +1.0\right)^{2.0}}}+1.0}}\right)-0.9305257363490997\,{
C>    \it t_{21}}\\\\ 
C> \f} 
C> 
C> Code generated with Maxima 5.34.0 [2] 
C> driven by autoxc-Ds [3]. 
C> 
C> ### References ### 
C> 
C> [1] J Tao, JP Perdew, VN Staveroverov, GE Scuseria
C>    , Phys.Rev.Lett. 91, 146401 (2003)  , DOI: 
C> <a href="https://doi.org/10.1103/PhysRevLett.91.146401 "> 
C> 10.1103/PhysRevLett.91.146401 </a> 
C> 
C> [2] Maxima, a computer algebra system, 
C> <a href="http://maxima.sourceforge.net/"> 
C> http://maxima.sourceforge.net/</a> 
C> 
C> [3] autoxc-Ds, revision 27207 2015-06-23 
C> 
      subroutine nwxcm_x_tpss03(param,tol_rho,ipol,nq,wght, 
     +rho,rgamma,tau,fnc,Amat,Cmat,Mmat) 
c $Id: $ 
#ifdef NWXC_QUAD_PREC 
      implicit real(kind=selected_real_kind(30))(a-h,o-z),integer(i-n) 
      integer, parameter :: rk=selected_real_kind(30) 
#else 
      implicit real(kind=selected_real_kind(15))(a-h,o-z),integer(i-n) 
      integer, parameter :: rk=selected_real_kind(15) 
#endif 
#include "nwxc_param.fh" 
      double precision param(*)     !< [Input] Parameters of functional 
      double precision tol_rho      !< [Input] The lower limit on the density 
      integer ipol                  !< [Input] The number of spin channels 
      integer nq                    !< [Input] The number of points 
      double precision wght         !< [Input] The weight of the functional 
      double precision rho(nq,NCOL_RHO)      !< [Input] The density 
      double precision rgamma(nq,NCOL_GAMMA) !< [Input] The norm of the density 
                                             !< gradients 
      double precision tau(nq,NCOL_TAU)      !< [Input] The kinetic energy density 
      double precision fnc(nq)      !< [Output] The value of the functional 
c 
c     Sampling Matrices for the XC Kernel 
c 
      double precision Amat(nq,NCOL_AMAT)   !< [Output] The derivative wrt rho 
      double precision Cmat(nq,NCOL_CMAT)   !< [Output] The derivative wrt rgamma 
      double precision Mmat(nq,NCOL_MMAT)   !< [Output] The derivative wrt tau 
      integer iq 
      double precision tmp 
      double precision rhoa,rhob 
      double precision gammaaa,gammaab,gammabb 
      double precision taua,taub 
      double precision nwxcm_heaviside 
      external         nwxcm_heaviside 
CDIR$ NOVECTOR
      do iq = 1, nq 
        if (ipol.eq.1) then 
          rhoa    = 0.5d0*rho(iq,R_T) 
          gammaaa = 0.25d0*rgamma(iq,G_TT) 
          taua    = 0.5d0*tau(iq,T_T) 
          if (rhoa.gt.tol_rho) then 
            if (taua.gt.tol_rho) then 
              t1 = rhoa**1.3333333333333333d+0
              t2 = 1/rhoa**2.6666666666666666d+0
              t3 = 2.040060021774676d-2*gammaaa*t2+1.0d+0
              t4 = 1/t3**2.0d+0
              t5 = gammaaa**3
              t6 = 1/rhoa**8
              t7 = gammaaa**2
              t8 = 1/rhoa**5.333333333333333d+0
              t9 = 1/rhoa
              t10 = 1/taua
              t11 = gammaaa*t10*t9
              t12 = t11**2.0d+0
              t13 = 1.5625d-2*t12+1.0d+0
              t14 = 1/t13**2.0d+0
              t15 = 2.485875d-2*t12*t14+1.234567901234568d-1
              t16 = (1.35388578153653d-4*t7*t8+2.8125d-3*t12)**5.0d-1
              t17 = 1/rhoa**1.6666666666666669d+0
              t18 = 2.0d+0*taua-2.5d-1*gammaaa*t9
              t19 = 1.0970205230680374d-1*t17*t18-1.0d+0
              t20 = 4.38808209227215d-2*t17*t18*t19+1.0d+0
              t21 = 1/t20**5.0d-1
              t22 = 4.5d-1*t19*t21+1.0970205230680376d-2*gammaaa*t2
              t23 = 5.133173416322327d-6*t7*t8+1.5033019185692253d-6*t5*
     1           t6+7.209876543209877d-2*t22**2-1.802469135802469d-1*t16
     2           *t22+1.6455307846020564d-2*gammaaa*t15*t2+1.72188616792
     3           99946d-3*t12
              t24 = 1.2437810945273631d+0*t23*t4+1.0d+0
              t25 = 8.04d-1-8.04d-1/t24
              t26 = rhoa**3.333333333333333d-1
              t27 = 1/t24**2
              t28 = 1/rhoa**6.333333333333333d+0
              t29 = 1/rhoa**3.6666666666666664d+0
              t30 = 1/rhoa**3
              t31 = 1/taua**2
              t32 = 1/rhoa**2
              t33 = 1/t13**3.0d+0
              t34 = t11**3.0d+0
              t35 = 2.7425513076700936d-2*gammaaa*t29-1.828367538446729d
     1           -1*t18*t2
              t36 = 1/t20**1.5d+0
              t37 = -2.25d-1*t19*(4.38808209227215d-2*t17*t18*t35+1.0970
     1           205230680374d-2*gammaaa*t19*t29-7.313470153786916d-2*t1
     2           8*t19*t2)*t36+4.5d-1*t21*t35-2.925388061514767d-2*gamma
     3           aa*t29
              t38 = 1/t16
              t39 = 1/t3**3.0d+0
              t40 = -2.25d-1*t19*(-1.0970205230680374d-2*t19*t2-1.203454
     1           0280324706d-3*t18/rhoa**4.333333333333333d+0)*t36-1.234
     2           1480884515421d-2*t2*t21+1.0970205230680376d-2*t2
              t41 = 1/taua**3
              t42 = 9.873184707612337d-2*t17*t21-2.25d-1*t19*(8.77616418
     1           45443d-2*t17*t19+9.627632224259765d-3*t18/rhoa**3.33333
     2           33333333337d+0)*t36
              fnc(iq) = (-1.8610514726981994d+0*t1*t25-1.861051472698199
     1           4d+0*t1)*wght+fnc(iq)
              Amat(iq,D1_RA) = (-7.481426920246762d-1*t1*t27*(1.24378109
     1           45273631d+0*t4*(1.6455307846020564d-2*gammaaa*t2*(1.553
     2           671875d-3*gammaaa*t10*t32*t33*t34-4.97175d-2*t14*t30*t3
     3           1*t7)-9.012345679012345d-2*t22*t38*(-5.625d-3*t30*t31*t
     4           7-7.220724168194825d-4*t28*t7)-3.443772335859989d-3*t30
     5           *t31*t7-2.737692488705241d-5*t28*t7-1.2026415348553804d
     6           -5*t5/rhoa**9+1.4419753086419754d-1*t22*t37-1.802469135
     7           802469d-1*t16*t37-4.3880820922721503d-2*gammaaa*t15*t29
     8           )+1.3532736462850253d-1*gammaaa*t23*t29*t39)-1.24070098
     9           17987995d+0*t25*t26-1.2407009817987995d+0*t26)*wght+Ama
     :           t(iq,D1_RA)
              Cmat(iq,D1_GAA) = Cmat(iq,D1_GAA)-7.481426920246762d-1*t1*
     1           t27*(1.2437810945273631d+0*t4*(1.6455307846020564d-2*ga
     2           mmaaa*t2*(4.97175d-2*gammaaa*t14*t31*t32-1.553671875d-3
     3           *t10*t33*t34*t9)-9.012345679012345d-2*t22*t38*(2.707771
     4           56307306d-4*gammaaa*t8+5.625d-3*gammaaa*t31*t32)+1.0266
     5           346832644656d-5*gammaaa*t8+4.509905755707676d-6*t6*t7+1
     6           .4419753086419754d-1*t22*t40-1.802469135802469d-1*t16*t
     7           40+3.443772335859989d-3*gammaaa*t31*t32+1.6455307846020
     8           564d-2*t15*t2)-5.074776173568845d-2*t2*t23*t39)*wght
              Cmat(iq,D1_GAB) = Cmat(iq,D1_GAB)
              Mmat(iq,D1_TA) = Mmat(iq,D1_TA)-9.305257363490997d-1*t1*t2
     1           7*t4*(1.6455307846020564d-2*gammaaa*t2*(1.553671875d-3*
     2           gammaaa*t31*t33*t34*t9-4.97175d-2*t14*t32*t41*t7)+5.069
     3           444444444443d-4*t22*t32*t38*t41*t7-3.443772335859989d-3
     4           *t32*t41*t7+1.4419753086419754d-1*t22*t42-1.80246913580
     5           2469d-1*t16*t42)*wght
            else 
              t1 = rhoa**1.3333333333333333d+0
              t2 = 1/rhoa**1.6666666666666669d+0
              t3 = 1.0970205230680374d-51*t2-1.0d+0
              t4 = 4.3880820922721503d-52*t2*t3+1.0d+0
              t5 = 1/t4**5.0d-1
              t6 = 4.5d-1*t3*t5+4.3880820922721503d-52*t2
              t7 = 1/rhoa**3.3333333333333337d+0
              t8 = (2.166217250458448d-103*t7+4.4999999999999996d-2)**5.
     1           0d-1
              t9 = -1.802469135802469d-1*t6*t8+8.213077466115726d-105*t7
     1           +7.209876543209877d-2*t6**2+2.4881109353903252d-52*t2+9
     2           .621132278843042d-155/rhoa**5+2.755017868687991d-2
              t10 = 8.160240087098705d-52*t2+1.0d+0
              t11 = 1/t10**2.0d+0
              t12 = 1.2437810945273631d+0*t11*t9+1.0d+0
              t13 = 8.04d-1-8.04d-1/t12
              t14 = rhoa**3.333333333333333d-1
              t15 = 1/rhoa**4.333333333333333d+0
              t16 = 1/rhoa**2.6666666666666666d+0
              t17 = -8.227653923010281d-52*t16*t5-2.25d-1*t3*(-7.3134701
     1           53786917d-52*t16*t3-8.023026853549804d-103*t15)/t4**1.5
     2           d+0-7.313470153786917d-52*t16
              fnc(iq) = (-1.8610514726981994d+0*t1*t13-1.861051472698199
     1           4d+0*t1)*wght+fnc(iq)
              Amat(iq,D1_RA) = (-7.481426920246762d-1*t1*(3.383184115712
     1           5636d-51*t16*t9/t10**3.0d+0+1.2437810945273631d+0*t11*(
     2           -1.802469135802469d-1*t17*t8+6.507566225657065d-104*t15
     3           *t6/t8+1.4419753086419754d-1*t17*t6-4.146851558983876d-
     4           52*t16-2.737692488705242d-104*t15-4.810566139421521d-15
     5           4/rhoa**6))/t12**2-1.2407009817987995d+0*t13*t14-1.2407
     6           009817987995d+0*t14)*wght+Amat(iq,D1_RA)
              Cmat(iq,D1_GAA) = Cmat(iq,D1_GAA)
              Cmat(iq,D1_GAB) = Cmat(iq,D1_GAB)
              Mmat(iq,D1_TA) = Mmat(iq,D1_TA)
            endif 
          endif ! rhoa.gt.tol_rho 
        else  ! ipol.eq.1 
          rhoa    = rho(iq,R_A) 
          rhob    = rho(iq,R_B) 
          gammaaa = rgamma(iq,G_AA) 
          gammaab = rgamma(iq,G_AB) 
          gammabb = rgamma(iq,G_BB) 
          taua    = tau(iq,T_A) 
          taub    = tau(iq,T_B) 
          if (rhoa.gt.tol_rho.and.rhob.gt.tol_rho) then 
            if (taua.gt.tol_rho.and.taub.gt.tol_rho) then 
              t1 = rhoa**1.3333333333333333d+0
              t2 = rhob**1.3333333333333333d+0
              t3 = 1/rhoa**2.6666666666666666d+0
              t4 = 2.040060021774676d-2*gammaaa*t3+1.0d+0
              t5 = 1/t4**2.0d+0
              t6 = gammaaa**3
              t7 = 1/rhoa**8
              t8 = gammaaa**2
              t9 = 1/rhoa**5.333333333333333d+0
              t10 = 1/rhoa
              t11 = 1/taua
              t12 = gammaaa*t10*t11
              t13 = t12**2.0d+0
              t14 = 1.5625d-2*t13+1.0d+0
              t15 = 1/t14**2.0d+0
              t16 = 2.485875d-2*t13*t15+1.234567901234568d-1
              t17 = (1.35388578153653d-4*t8*t9+2.8125d-3*t13)**5.0d-1
              t18 = 1/rhoa**1.6666666666666669d+0
              t19 = 2.0d+0*taua-2.5d-1*gammaaa*t10
              t20 = 1.0970205230680374d-1*t18*t19-1.0d+0
              t21 = 4.38808209227215d-2*t18*t19*t20+1.0d+0
              t22 = 1/t21**5.0d-1
              t23 = 1.0970205230680376d-2*gammaaa*t3+4.5d-1*t20*t22
              t24 = 5.133173416322327d-6*t8*t9+1.5033019185692253d-6*t6*
     1           t7+1.6455307846020564d-2*gammaaa*t16*t3+7.2098765432098
     2           77d-2*t23**2-1.802469135802469d-1*t17*t23+1.72188616792
     3           99946d-3*t13
              t25 = 1.2437810945273631d+0*t24*t5+1.0d+0
              t26 = 8.04d-1-8.04d-1/t25
              t27 = 1/rhob**2.6666666666666666d+0
              t28 = 2.040060021774676d-2*gammabb*t27+1.0d+0
              t29 = 1/t28**2.0d+0
              t30 = gammabb**3
              t31 = 1/rhob**8
              t32 = gammabb**2
              t33 = 1/rhob**5.333333333333333d+0
              t34 = 1/rhob
              t35 = 1/taub
              t36 = gammabb*t34*t35
              t37 = t36**2.0d+0
              t38 = 1.5625d-2*t37+1.0d+0
              t39 = 1/t38**2.0d+0
              t40 = 2.485875d-2*t37*t39+1.234567901234568d-1
              t41 = (2.8125d-3*t37+1.35388578153653d-4*t32*t33)**5.0d-1
              t42 = 1/rhob**1.6666666666666669d+0
              t43 = 2.0d+0*taub-2.5d-1*gammabb*t34
              t44 = 1.0970205230680374d-1*t42*t43-1.0d+0
              t45 = 4.38808209227215d-2*t42*t43*t44+1.0d+0
              t46 = 1/t45**5.0d-1
              t47 = 4.5d-1*t44*t46+1.0970205230680376d-2*gammabb*t27
              t48 = 7.209876543209877d-2*t47**2-1.802469135802469d-1*t41
     1           *t47+1.6455307846020564d-2*gammabb*t27*t40+1.7218861679
     2           299946d-3*t37+5.133173416322327d-6*t32*t33+1.5033019185
     3           692253d-6*t30*t31
              t49 = 1.2437810945273631d+0*t29*t48+1.0d+0
              t50 = 8.04d-1-8.04d-1/t49
              t51 = rhoa**3.333333333333333d-1
              t52 = 1/t25**2
              t53 = 1/rhoa**6.333333333333333d+0
              t54 = 1/rhoa**3.6666666666666664d+0
              t55 = 1/rhoa**3
              t56 = 1/taua**2
              t57 = 1/rhoa**2
              t58 = 1/t14**3.0d+0
              t59 = t12**3.0d+0
              t60 = 2.7425513076700936d-2*gammaaa*t54-1.828367538446729d
     1           -1*t19*t3
              t61 = 1/t21**1.5d+0
              t62 = -2.25d-1*t20*(4.38808209227215d-2*t18*t19*t60+1.0970
     1           205230680374d-2*gammaaa*t20*t54-7.313470153786916d-2*t1
     2           9*t20*t3)*t61+4.5d-1*t22*t60-2.925388061514767d-2*gamma
     3           aa*t54
              t63 = 1/t17
              t64 = 1/t4**3.0d+0
              t65 = rhob**3.333333333333333d-1
              t66 = 1/t49**2
              t67 = 1/rhob**6.333333333333333d+0
              t68 = 1/rhob**3.6666666666666664d+0
              t69 = 1/rhob**3
              t70 = 1/taub**2
              t71 = 1/rhob**2
              t72 = 1/t38**3.0d+0
              t73 = t36**3.0d+0
              t74 = 2.7425513076700936d-2*gammabb*t68-1.828367538446729d
     1           -1*t27*t43
              t75 = 1/t45**1.5d+0
              t76 = -2.25d-1*t44*(4.38808209227215d-2*t42*t43*t74+1.0970
     1           205230680374d-2*gammabb*t44*t68-7.313470153786916d-2*t2
     2           7*t43*t44)*t75+4.5d-1*t46*t74-2.925388061514767d-2*gamm
     3           abb*t68
              t77 = 1/t41
              t78 = 1/t28**3.0d+0
              t79 = -2.25d-1*t20*(-1.0970205230680374d-2*t20*t3-1.203454
     1           0280324706d-3*t19/rhoa**4.333333333333333d+0)*t61-1.234
     2           1480884515421d-2*t22*t3+1.0970205230680376d-2*t3
              t80 = -2.25d-1*t44*(-1.0970205230680374d-2*t27*t44-1.20345
     1           40280324706d-3*t43/rhob**4.333333333333333d+0)*t75-1.23
     2           41480884515421d-2*t27*t46+1.0970205230680376d-2*t27
              t81 = 1/taua**3
              t82 = 9.873184707612337d-2*t18*t22-2.25d-1*t20*(8.77616418
     1           45443d-2*t18*t20+9.627632224259765d-3*t19/rhoa**3.33333
     2           33333333337d+0)*t61
              t83 = 1/taub**3
              t84 = 9.873184707612337d-2*t42*t46-2.25d-1*t44*(8.77616418
     1           45443d-2*t42*t44+9.627632224259765d-3*t43/rhob**3.33333
     2           33333333337d+0)*t75
              fnc(iq) = (-9.305257363490997d-1*t2*t50-9.305257363490997d
     1           -1*t1*t26-9.305257363490997d-1*t2-9.305257363490997d-1*
     2           t1)*wght+fnc(iq)
              Amat(iq,D1_RA) = (-7.481426920246762d-1*t1*t52*(1.24378109
     1           45273631d+0*t5*(1.6455307846020564d-2*gammaaa*t3*(1.553
     2           671875d-3*gammaaa*t11*t57*t58*t59-4.97175d-2*t15*t55*t5
     3           6*t8)-9.012345679012345d-2*t23*t63*(-5.625d-3*t55*t56*t
     4           8-7.220724168194825d-4*t53*t8)-3.443772335859989d-3*t55
     5           *t56*t8-2.737692488705241d-5*t53*t8+1.4419753086419754d
     6           -1*t23*t62-1.802469135802469d-1*t17*t62-1.2026415348553
     7           804d-5*t6/rhoa**9-4.3880820922721503d-2*gammaaa*t16*t54
     8           )+1.3532736462850253d-1*gammaaa*t24*t54*t64)-1.24070098
     9           17987995d+0*t26*t51-1.2407009817987995d+0*t51)*wght+Ama
     :           t(iq,D1_RA)
              Amat(iq,D1_RB) = (-7.481426920246762d-1*t2*t66*(1.35327364
     1           62850253d-1*gammabb*t48*t68*t78+1.2437810945273631d+0*t
     2           29*(-9.012345679012345d-2*t47*(-5.625d-3*t32*t69*t70-7.
     3           220724168194825d-4*t32*t67)*t77+1.4419753086419754d-1*t
     4           47*t76-1.802469135802469d-1*t41*t76+1.6455307846020564d
     5           -2*gammabb*t27*(1.553671875d-3*gammabb*t35*t71*t72*t73-
     6           4.97175d-2*t32*t39*t69*t70)-3.443772335859989d-3*t32*t6
     7           9*t70-4.3880820922721503d-2*gammabb*t40*t68-2.737692488
     8           705241d-5*t32*t67-1.2026415348553804d-5*t30/rhob**9))-1
     9           .2407009817987995d+0*t50*t65-1.2407009817987995d+0*t65)
     :           *wght+Amat(iq,D1_RB)
              Cmat(iq,D1_GAA) = Cmat(iq,D1_GAA)-7.481426920246762d-1*t1*
     1           t52*(1.2437810945273631d+0*t5*(-9.012345679012345d-2*t2
     2           3*t63*(2.70777156307306d-4*gammaaa*t9+5.625d-3*gammaaa*
     3           t56*t57)+1.0266346832644656d-5*gammaaa*t9+4.50990575570
     4           7676d-6*t7*t8+1.4419753086419754d-1*t23*t79-1.802469135
     5           802469d-1*t17*t79+1.6455307846020564d-2*gammaaa*t3*(4.9
     6           7175d-2*gammaaa*t15*t56*t57-1.553671875d-3*t10*t11*t58*
     7           t59)+3.443772335859989d-3*gammaaa*t56*t57+1.64553078460
     8           20564d-2*t16*t3)-5.074776173568845d-2*t24*t3*t64)*wght
              Cmat(iq,D1_GAB) = Cmat(iq,D1_GAB)
              Cmat(iq,D1_GBB) = Cmat(iq,D1_GBB)-7.481426920246762d-1*t2*
     1           t66*(1.2437810945273631d+0*t29*(1.4419753086419754d-1*t
     2           47*t80-1.802469135802469d-1*t41*t80-9.012345679012345d-
     3           2*t47*(5.625d-3*gammabb*t70*t71+2.70777156307306d-4*gam
     4           mabb*t33)*t77+1.6455307846020564d-2*gammabb*t27*(4.9717
     5           5d-2*gammabb*t39*t70*t71-1.553671875d-3*t34*t35*t72*t73
     6           )+3.443772335859989d-3*gammabb*t70*t71+1.64553078460205
     7           64d-2*t27*t40+1.0266346832644656d-5*gammabb*t33+4.50990
     8           5755707676d-6*t31*t32)-5.074776173568845d-2*t27*t48*t78
     9           )*wght
              Mmat(iq,D1_TA) = Mmat(iq,D1_TA)-9.305257363490997d-1*t1*t5
     1           *t52*(1.4419753086419754d-1*t23*t82-1.802469135802469d-
     2           1*t17*t82+1.6455307846020564d-2*gammaaa*t3*(1.553671875
     3           d-3*gammaaa*t10*t56*t58*t59-4.97175d-2*t15*t57*t8*t81)+
     4           5.069444444444443d-4*t23*t57*t63*t8*t81-3.4437723358599
     5           89d-3*t57*t8*t81)*wght
              Mmat(iq,D1_TB) = Mmat(iq,D1_TB)-9.305257363490997d-1*t2*t2
     1           9*t66*(1.4419753086419754d-1*t47*t84-1.802469135802469d
     2           -1*t41*t84+1.6455307846020564d-2*gammabb*t27*(1.5536718
     3           75d-3*gammabb*t34*t70*t72*t73-4.97175d-2*t32*t39*t71*t8
     4           3)+5.069444444444443d-4*t32*t47*t71*t77*t83-3.443772335
     5           859989d-3*t32*t71*t83)*wght
            elseif (taua.gt.tol_rho.and.taub.le.tol_rho) then 
              t1 = rhoa**1.3333333333333333d+0
              t2 = rhob**1.3333333333333333d+0
              t3 = 1/rhob**1.6666666666666669d+0
              t4 = 1.0970205230680374d-51*t3-1.0d+0
              t5 = 4.3880820922721503d-52*t3*t4+1.0d+0
              t6 = 1/t5**5.0d-1
              t7 = 4.5d-1*t4*t6+4.3880820922721503d-52*t3
              t8 = 1/rhob**3.3333333333333337d+0
              t9 = (2.166217250458448d-103*t8+4.4999999999999996d-2)**5.
     1           0d-1
              t10 = -1.802469135802469d-1*t7*t9+8.213077466115726d-105*t
     1           8+7.209876543209877d-2*t7**2+2.4881109353903252d-52*t3+
     2           9.621132278843042d-155/rhob**5+2.755017868687991d-2
              t11 = 8.160240087098705d-52*t3+1.0d+0
              t12 = 1/t11**2.0d+0
              t13 = 1.2437810945273631d+0*t10*t12+1.0d+0
              t14 = 8.04d-1-8.04d-1/t13
              t15 = 1/rhoa**2.6666666666666666d+0
              t16 = 2.040060021774676d-2*gammaaa*t15+1.0d+0
              t17 = 1/t16**2.0d+0
              t18 = gammaaa**3
              t19 = 1/rhoa**8
              t20 = gammaaa**2
              t21 = 1/rhoa**5.333333333333333d+0
              t22 = 1/rhoa
              t23 = 1/taua
              t24 = gammaaa*t22*t23
              t25 = t24**2.0d+0
              t26 = 1.5625d-2*t25+1.0d+0
              t27 = 1/t26**2.0d+0
              t28 = 2.485875d-2*t25*t27+1.234567901234568d-1
              t29 = (2.8125d-3*t25+1.35388578153653d-4*t20*t21)**5.0d-1
              t30 = 1/rhoa**1.6666666666666669d+0
              t31 = 2.0d+0*taua-2.5d-1*gammaaa*t22
              t32 = 1.0970205230680374d-1*t30*t31-1.0d+0
              t33 = 4.38808209227215d-2*t30*t31*t32+1.0d+0
              t34 = 1/t33**5.0d-1
              t35 = 4.5d-1*t32*t34+1.0970205230680376d-2*gammaaa*t15
              t36 = 7.209876543209877d-2*t35**2-1.802469135802469d-1*t29
     1           *t35+1.6455307846020564d-2*gammaaa*t15*t28+1.7218861679
     2           299946d-3*t25+5.133173416322327d-6*t20*t21+1.5033019185
     3           692253d-6*t18*t19
              t37 = 1.2437810945273631d+0*t17*t36+1.0d+0
              t38 = 8.04d-1-8.04d-1/t37
              t39 = rhoa**3.333333333333333d-1
              t40 = 1/t37**2
              t41 = 1/rhoa**6.333333333333333d+0
              t42 = 1/rhoa**3.6666666666666664d+0
              t43 = 1/rhoa**3
              t44 = 1/taua**2
              t45 = 1/rhoa**2
              t46 = 1/t26**3.0d+0
              t47 = t24**3.0d+0
              t48 = 2.7425513076700936d-2*gammaaa*t42-1.828367538446729d
     1           -1*t15*t31
              t49 = 1/t33**1.5d+0
              t50 = -2.25d-1*t32*(4.38808209227215d-2*t30*t31*t48+1.0970
     1           205230680374d-2*gammaaa*t32*t42-7.313470153786916d-2*t1
     2           5*t31*t32)*t49+4.5d-1*t34*t48-2.925388061514767d-2*gamm
     3           aaa*t42
              t51 = 1/t29
              t52 = 1/t16**3.0d+0
              t53 = rhob**3.333333333333333d-1
              t54 = 1/rhob**4.333333333333333d+0
              t55 = 1/rhob**2.6666666666666666d+0
              t56 = -8.227653923010281d-52*t55*t6-2.25d-1*t4*(-7.3134701
     1           53786917d-52*t4*t55-8.023026853549804d-103*t54)/t5**1.5
     2           d+0-7.313470153786917d-52*t55
              t57 = -2.25d-1*t32*(-1.0970205230680374d-2*t15*t32-1.20345
     1           40280324706d-3*t31/rhoa**4.333333333333333d+0)*t49-1.23
     2           41480884515421d-2*t15*t34+1.0970205230680376d-2*t15
              t58 = 1/taua**3
              t59 = 9.873184707612337d-2*t30*t34-2.25d-1*t32*(8.77616418
     1           45443d-2*t30*t32+9.627632224259765d-3*t31/rhoa**3.33333
     2           33333333337d+0)*t49
              fnc(iq) = (-9.305257363490997d-1*t1*t38-9.305257363490997d
     1           -1*t14*t2-9.305257363490997d-1*t2-9.305257363490997d-1*
     2           t1)*wght+fnc(iq)
              Amat(iq,D1_RA) = (-7.481426920246762d-1*t1*t40*(1.35327364
     1           62850253d-1*gammaaa*t36*t42*t52+1.2437810945273631d+0*t
     2           17*(-9.012345679012345d-2*t35*(-5.625d-3*t20*t43*t44-7.
     3           220724168194825d-4*t20*t41)*t51+1.4419753086419754d-1*t
     4           35*t50-1.802469135802469d-1*t29*t50+1.6455307846020564d
     5           -2*gammaaa*t15*(1.553671875d-3*gammaaa*t23*t45*t46*t47-
     6           4.97175d-2*t20*t27*t43*t44)-3.443772335859989d-3*t20*t4
     7           3*t44-4.3880820922721503d-2*gammaaa*t28*t42-2.737692488
     8           705241d-5*t20*t41-1.2026415348553804d-5*t18/rhoa**9))-1
     9           .2407009817987995d+0*t38*t39-1.2407009817987995d+0*t39)
     :           *wght+Amat(iq,D1_RA)
              Amat(iq,D1_RB) = (-7.481426920246762d-1*t2*(1.243781094527
     1           3631d+0*t12*(-1.802469135802469d-1*t56*t9+6.50756622565
     2           7065d-104*t54*t7/t9+1.4419753086419754d-1*t56*t7-4.1468
     3           51558983876d-52*t55-2.737692488705242d-104*t54-4.810566
     4           139421521d-154/rhob**6)+3.3831841157125636d-51*t10*t55/
     5           t11**3.0d+0)/t13**2-1.2407009817987995d+0*t14*t53-1.240
     6           7009817987995d+0*t53)*wght+Amat(iq,D1_RB)
              Cmat(iq,D1_GAA) = Cmat(iq,D1_GAA)-7.481426920246762d-1*t1*
     1           t40*(1.2437810945273631d+0*t17*(1.4419753086419754d-1*t
     2           35*t57-1.802469135802469d-1*t29*t57-9.012345679012345d-
     3           2*t35*(5.625d-3*gammaaa*t44*t45+2.70777156307306d-4*gam
     4           maaa*t21)*t51+1.6455307846020564d-2*gammaaa*t15*(4.9717
     5           5d-2*gammaaa*t27*t44*t45-1.553671875d-3*t22*t23*t46*t47
     6           )+3.443772335859989d-3*gammaaa*t44*t45+1.64553078460205
     7           64d-2*t15*t28+1.0266346832644656d-5*gammaaa*t21+4.50990
     8           5755707676d-6*t19*t20)-5.074776173568845d-2*t15*t36*t52
     9           )*wght
              Cmat(iq,D1_GAB) = Cmat(iq,D1_GAB)
              Cmat(iq,D1_GBB) = Cmat(iq,D1_GBB)
              Mmat(iq,D1_TA) = Mmat(iq,D1_TA)-9.305257363490997d-1*t1*t1
     1           7*t40*(1.4419753086419754d-1*t35*t59-1.802469135802469d
     2           -1*t29*t59+1.6455307846020564d-2*gammaaa*t15*(1.5536718
     3           75d-3*gammaaa*t22*t44*t46*t47-4.97175d-2*t20*t27*t45*t5
     4           8)+5.069444444444443d-4*t20*t35*t45*t51*t58-3.443772335
     5           859989d-3*t20*t45*t58)*wght
              Mmat(iq,D1_TB) = Mmat(iq,D1_TB)
            elseif (taua.le.tol_rho.and.taub.gt.tol_rho) then 
              t1 = rhoa**1.3333333333333333d+0
              t2 = 1/rhoa**1.6666666666666669d+0
              t3 = 1.0970205230680374d-51*t2-1.0d+0
              t4 = 4.3880820922721503d-52*t2*t3+1.0d+0
              t5 = 1/t4**5.0d-1
              t6 = 4.5d-1*t3*t5+4.3880820922721503d-52*t2
              t7 = 1/rhoa**3.3333333333333337d+0
              t8 = (2.166217250458448d-103*t7+4.4999999999999996d-2)**5.
     1           0d-1
              t9 = -1.802469135802469d-1*t6*t8+8.213077466115726d-105*t7
     1           +7.209876543209877d-2*t6**2+2.4881109353903252d-52*t2+9
     2           .621132278843042d-155/rhoa**5+2.755017868687991d-2
              t10 = 8.160240087098705d-52*t2+1.0d+0
              t11 = 1/t10**2.0d+0
              t12 = 1.2437810945273631d+0*t11*t9+1.0d+0
              t13 = 8.04d-1-8.04d-1/t12
              t14 = rhob**1.3333333333333333d+0
              t15 = 1/rhob**2.6666666666666666d+0
              t16 = 2.040060021774676d-2*gammabb*t15+1.0d+0
              t17 = 1/t16**2.0d+0
              t18 = gammabb**3
              t19 = 1/rhob**8
              t20 = gammabb**2
              t21 = 1/rhob**5.333333333333333d+0
              t22 = 1/rhob
              t23 = 1/taub
              t24 = gammabb*t22*t23
              t25 = t24**2.0d+0
              t26 = 1.5625d-2*t25+1.0d+0
              t27 = 1/t26**2.0d+0
              t28 = 2.485875d-2*t25*t27+1.234567901234568d-1
              t29 = (2.8125d-3*t25+1.35388578153653d-4*t20*t21)**5.0d-1
              t30 = 1/rhob**1.6666666666666669d+0
              t31 = 2.0d+0*taub-2.5d-1*gammabb*t22
              t32 = 1.0970205230680374d-1*t30*t31-1.0d+0
              t33 = 4.38808209227215d-2*t30*t31*t32+1.0d+0
              t34 = 1/t33**5.0d-1
              t35 = 4.5d-1*t32*t34+1.0970205230680376d-2*gammabb*t15
              t36 = 7.209876543209877d-2*t35**2-1.802469135802469d-1*t29
     1           *t35+1.6455307846020564d-2*gammabb*t15*t28+1.7218861679
     2           299946d-3*t25+5.133173416322327d-6*t20*t21+1.5033019185
     3           692253d-6*t18*t19
              t37 = 1.2437810945273631d+0*t17*t36+1.0d+0
              t38 = 8.04d-1-8.04d-1/t37
              t39 = rhoa**3.333333333333333d-1
              t40 = 1/rhoa**4.333333333333333d+0
              t41 = 1/rhoa**2.6666666666666666d+0
              t42 = -8.227653923010281d-52*t41*t5-2.25d-1*t3*(-7.3134701
     1           53786917d-52*t3*t41-8.023026853549804d-103*t40)/t4**1.5
     2           d+0-7.313470153786917d-52*t41
              t43 = rhob**3.333333333333333d-1
              t44 = 1/t37**2
              t45 = 1/rhob**6.333333333333333d+0
              t46 = 1/rhob**3.6666666666666664d+0
              t47 = 1/rhob**3
              t48 = 1/taub**2
              t49 = 1/rhob**2
              t50 = 1/t26**3.0d+0
              t51 = t24**3.0d+0
              t52 = 2.7425513076700936d-2*gammabb*t46-1.828367538446729d
     1           -1*t15*t31
              t53 = 1/t33**1.5d+0
              t54 = -2.25d-1*t32*(4.38808209227215d-2*t30*t31*t52+1.0970
     1           205230680374d-2*gammabb*t32*t46-7.313470153786916d-2*t1
     2           5*t31*t32)*t53+4.5d-1*t34*t52-2.925388061514767d-2*gamm
     3           abb*t46
              t55 = 1/t29
              t56 = 1/t16**3.0d+0
              t57 = -2.25d-1*t32*(-1.0970205230680374d-2*t15*t32-1.20345
     1           40280324706d-3*t31/rhob**4.333333333333333d+0)*t53-1.23
     2           41480884515421d-2*t15*t34+1.0970205230680376d-2*t15
              t58 = 1/taub**3
              t59 = 9.873184707612337d-2*t30*t34-2.25d-1*t32*(8.77616418
     1           45443d-2*t30*t32+9.627632224259765d-3*t31/rhob**3.33333
     2           33333333337d+0)*t53
              fnc(iq) = (-9.305257363490997d-1*t14*t38-9.305257363490997
     1           d-1*t14-9.305257363490997d-1*t1*t13-9.305257363490997d-
     2           1*t1)*wght+fnc(iq)
              Amat(iq,D1_RA) = (-7.481426920246762d-1*t1*(3.383184115712
     1           5636d-51*t41*t9/t10**3.0d+0+1.2437810945273631d+0*t11*(
     2           -1.802469135802469d-1*t42*t8+6.507566225657065d-104*t40
     3           *t6/t8+1.4419753086419754d-1*t42*t6-4.146851558983876d-
     4           52*t41-2.737692488705242d-104*t40-4.810566139421521d-15
     5           4/rhoa**6))/t12**2-1.2407009817987995d+0*t13*t39-1.2407
     6           009817987995d+0*t39)*wght+Amat(iq,D1_RA)
              Amat(iq,D1_RB) = (-7.481426920246762d-1*t14*t44*(1.3532736
     1           462850253d-1*gammabb*t36*t46*t56+1.2437810945273631d+0*
     2           t17*(-9.012345679012345d-2*t35*(-5.625d-3*t20*t47*t48-7
     3           .220724168194825d-4*t20*t45)*t55+1.4419753086419754d-1*
     4           t35*t54-1.802469135802469d-1*t29*t54+1.6455307846020564
     5           d-2*gammabb*t15*(1.553671875d-3*gammabb*t23*t49*t50*t51
     6           -4.97175d-2*t20*t27*t47*t48)-3.443772335859989d-3*t20*t
     7           47*t48-4.3880820922721503d-2*gammabb*t28*t46-2.73769248
     8           8705241d-5*t20*t45-1.2026415348553804d-5*t18/rhob**9))-
     9           1.2407009817987995d+0*t38*t43-1.2407009817987995d+0*t43
     :           )*wght+Amat(iq,D1_RB)
              Cmat(iq,D1_GAA) = Cmat(iq,D1_GAA)
              Cmat(iq,D1_GAB) = Cmat(iq,D1_GAB)
              Cmat(iq,D1_GBB) = Cmat(iq,D1_GBB)-7.481426920246762d-1*t14
     1           *t44*(1.2437810945273631d+0*t17*(1.4419753086419754d-1*
     2           t35*t57-1.802469135802469d-1*t29*t57-9.012345679012345d
     3           -2*t35*(5.625d-3*gammabb*t48*t49+2.70777156307306d-4*ga
     4           mmabb*t21)*t55+1.6455307846020564d-2*gammabb*t15*(4.971
     5           75d-2*gammabb*t27*t48*t49-1.553671875d-3*t22*t23*t50*t5
     6           1)+3.443772335859989d-3*gammabb*t48*t49+1.6455307846020
     7           564d-2*t15*t28+1.0266346832644656d-5*gammabb*t21+4.5099
     8           05755707676d-6*t19*t20)-5.074776173568845d-2*t15*t36*t5
     9           6)*wght
              Mmat(iq,D1_TA) = Mmat(iq,D1_TA)
              Mmat(iq,D1_TB) = Mmat(iq,D1_TB)-9.305257363490997d-1*t14*t
     1           17*t44*(1.4419753086419754d-1*t35*t59-1.802469135802469
     2           d-1*t29*t59+1.6455307846020564d-2*gammabb*t15*(1.553671
     3           875d-3*gammabb*t22*t48*t50*t51-4.97175d-2*t20*t27*t49*t
     4           58)+5.069444444444443d-4*t20*t35*t49*t55*t58-3.44377233
     5           5859989d-3*t20*t49*t58)*wght
            else 
              t1 = rhoa**1.3333333333333333d+0
              t2 = 1/rhoa**1.6666666666666669d+0
              t3 = 1.0970205230680374d-51*t2-1.0d+0
              t4 = 4.3880820922721503d-52*t2*t3+1.0d+0
              t5 = 1/t4**5.0d-1
              t6 = 4.5d-1*t3*t5+4.3880820922721503d-52*t2
              t7 = 1/rhoa**3.3333333333333337d+0
              t8 = (2.166217250458448d-103*t7+4.4999999999999996d-2)**5.
     1           0d-1
              t9 = -1.802469135802469d-1*t6*t8+8.213077466115726d-105*t7
     1           +7.209876543209877d-2*t6**2+2.4881109353903252d-52*t2+9
     2           .621132278843042d-155/rhoa**5+2.755017868687991d-2
              t10 = 8.160240087098705d-52*t2+1.0d+0
              t11 = 1/t10**2.0d+0
              t12 = 1.2437810945273631d+0*t11*t9+1.0d+0
              t13 = 8.04d-1-8.04d-1/t12
              t14 = rhob**1.3333333333333333d+0
              t15 = 1/rhob**1.6666666666666669d+0
              t16 = 1.0970205230680374d-51*t15-1.0d+0
              t17 = 4.3880820922721503d-52*t15*t16+1.0d+0
              t18 = 1/t17**5.0d-1
              t19 = 4.5d-1*t16*t18+4.3880820922721503d-52*t15
              t20 = 1/rhob**3.3333333333333337d+0
              t21 = (2.166217250458448d-103*t20+4.4999999999999996d-2)**
     1           5.0d-1
              t22 = -1.802469135802469d-1*t19*t21+8.213077466115726d-105
     1           *t20+7.209876543209877d-2*t19**2+2.4881109353903252d-52
     2           *t15+9.621132278843042d-155/rhob**5+2.755017868687991d-
     3           2
              t23 = 8.160240087098705d-52*t15+1.0d+0
              t24 = 1/t23**2.0d+0
              t25 = 1.2437810945273631d+0*t22*t24+1.0d+0
              t26 = 8.04d-1-8.04d-1/t25
              t27 = rhoa**3.333333333333333d-1
              t28 = 1/rhoa**4.333333333333333d+0
              t29 = 1/rhoa**2.6666666666666666d+0
              t30 = -8.227653923010281d-52*t29*t5-2.25d-1*t3*(-7.3134701
     1           53786917d-52*t29*t3-8.023026853549804d-103*t28)/t4**1.5
     2           d+0-7.313470153786917d-52*t29
              t31 = rhob**3.333333333333333d-1
              t32 = 1/rhob**4.333333333333333d+0
              t33 = 1/rhob**2.6666666666666666d+0
              t34 = -2.25d-1*t16*(-7.313470153786917d-52*t16*t33-8.02302
     1           6853549804d-103*t32)/t17**1.5d+0-8.227653923010281d-52*
     2           t18*t33-7.313470153786917d-52*t33
              fnc(iq) = (-9.305257363490997d-1*t14*t26-9.305257363490997
     1           d-1*t14-9.305257363490997d-1*t1*t13-9.305257363490997d-
     2           1*t1)*wght+fnc(iq)
              Amat(iq,D1_RA) = (-7.481426920246762d-1*t1*(3.383184115712
     1           5636d-51*t29*t9/t10**3.0d+0+1.2437810945273631d+0*t11*(
     2           -1.802469135802469d-1*t30*t8+6.507566225657065d-104*t28
     3           *t6/t8+1.4419753086419754d-1*t30*t6-4.146851558983876d-
     4           52*t29-2.737692488705242d-104*t28-4.810566139421521d-15
     5           4/rhoa**6))/t12**2-1.2407009817987995d+0*t13*t27-1.2407
     6           009817987995d+0*t27)*wght+Amat(iq,D1_RA)
              Amat(iq,D1_RB) = (-7.481426920246762d-1*t14*(1.24378109452
     1           73631d+0*t24*(-1.802469135802469d-1*t21*t34+1.441975308
     2           6419754d-1*t19*t34-4.146851558983876d-52*t33+6.50756622
     3           5657065d-104*t19*t32/t21-2.737692488705242d-104*t32-4.8
     4           10566139421521d-154/rhob**6)+3.3831841157125636d-51*t22
     5           *t33/t23**3.0d+0)/t25**2-1.2407009817987995d+0*t26*t31-
     6           1.2407009817987995d+0*t31)*wght+Amat(iq,D1_RB)
              Cmat(iq,D1_GAA) = Cmat(iq,D1_GAA)
              Cmat(iq,D1_GAB) = Cmat(iq,D1_GAB)
              Cmat(iq,D1_GBB) = Cmat(iq,D1_GBB)
              Mmat(iq,D1_TA) = Mmat(iq,D1_TA)
              Mmat(iq,D1_TB) = Mmat(iq,D1_TB)
            endif 
          elseif (rhoa.gt.tol_rho.and.rhob.le.tol_rho) then 
            if (taua.gt.tol_rho.and.taub.gt.tol_rho) then 
              t1 = rhoa**1.3333333333333333d+0
              t2 = 1/rhoa**2.6666666666666666d+0
              t3 = 2.040060021774676d-2*gammaaa*t2+1.0d+0
              t4 = 1/t3**2.0d+0
              t5 = gammaaa**3
              t6 = 1/rhoa**8
              t7 = gammaaa**2
              t8 = 1/rhoa**5.333333333333333d+0
              t9 = 1/rhoa
              t10 = 1/taua
              t11 = gammaaa*t10*t9
              t12 = t11**2.0d+0
              t13 = 1.5625d-2*t12+1.0d+0
              t14 = 1/t13**2.0d+0
              t15 = 2.485875d-2*t12*t14+1.234567901234568d-1
              t16 = (1.35388578153653d-4*t7*t8+2.8125d-3*t12)**5.0d-1
              t17 = 1/rhoa**1.6666666666666669d+0
              t18 = 2.0d+0*taua-2.5d-1*gammaaa*t9
              t19 = 1.0970205230680374d-1*t17*t18-1.0d+0
              t20 = 4.38808209227215d-2*t17*t18*t19+1.0d+0
              t21 = 1/t20**5.0d-1
              t22 = 4.5d-1*t19*t21+1.0970205230680376d-2*gammaaa*t2
              t23 = 5.133173416322327d-6*t7*t8+1.5033019185692253d-6*t5*
     1           t6+7.209876543209877d-2*t22**2-1.802469135802469d-1*t16
     2           *t22+1.6455307846020564d-2*gammaaa*t15*t2+1.72188616792
     3           99946d-3*t12
              t24 = 1.2437810945273631d+0*t23*t4+1.0d+0
              t25 = 8.04d-1-8.04d-1/t24
              t26 = rhoa**3.333333333333333d-1
              t27 = 1/t24**2
              t28 = 1/rhoa**6.333333333333333d+0
              t29 = 1/rhoa**3.6666666666666664d+0
              t30 = 1/rhoa**3
              t31 = 1/taua**2
              t32 = 1/rhoa**2
              t33 = 1/t13**3.0d+0
              t34 = t11**3.0d+0
              t35 = 2.7425513076700936d-2*gammaaa*t29-1.828367538446729d
     1           -1*t18*t2
              t36 = 1/t20**1.5d+0
              t37 = -2.25d-1*t19*(4.38808209227215d-2*t17*t18*t35+1.0970
     1           205230680374d-2*gammaaa*t19*t29-7.313470153786916d-2*t1
     2           8*t19*t2)*t36+4.5d-1*t21*t35-2.925388061514767d-2*gamma
     3           aa*t29
              t38 = 1/t16
              t39 = 1/t3**3.0d+0
              t40 = -2.25d-1*t19*(-1.0970205230680374d-2*t19*t2-1.203454
     1           0280324706d-3*t18/rhoa**4.333333333333333d+0)*t36-1.234
     2           1480884515421d-2*t2*t21+1.0970205230680376d-2*t2
              t41 = 1/taua**3
              t42 = 9.873184707612337d-2*t17*t21-2.25d-1*t19*(8.77616418
     1           45443d-2*t17*t19+9.627632224259765d-3*t18/rhoa**3.33333
     2           33333333337d+0)*t36
              fnc(iq) = (-9.305257363490997d-1*t1*t25-9.305257363490997d
     1           -1*t1)*wght+fnc(iq)
              Amat(iq,D1_RA) = (-7.481426920246762d-1*t1*t27*(1.24378109
     1           45273631d+0*t4*(1.6455307846020564d-2*gammaaa*t2*(1.553
     2           671875d-3*gammaaa*t10*t32*t33*t34-4.97175d-2*t14*t30*t3
     3           1*t7)-9.012345679012345d-2*t22*t38*(-5.625d-3*t30*t31*t
     4           7-7.220724168194825d-4*t28*t7)-3.443772335859989d-3*t30
     5           *t31*t7-2.737692488705241d-5*t28*t7-1.2026415348553804d
     6           -5*t5/rhoa**9+1.4419753086419754d-1*t22*t37-1.802469135
     7           802469d-1*t16*t37-4.3880820922721503d-2*gammaaa*t15*t29
     8           )+1.3532736462850253d-1*gammaaa*t23*t29*t39)-1.24070098
     9           17987995d+0*t25*t26-1.2407009817987995d+0*t26)*wght+Ama
     :           t(iq,D1_RA)
              Cmat(iq,D1_GAA) = Cmat(iq,D1_GAA)-7.481426920246762d-1*t1*
     1           t27*(1.2437810945273631d+0*t4*(1.6455307846020564d-2*ga
     2           mmaaa*t2*(4.97175d-2*gammaaa*t14*t31*t32-1.553671875d-3
     3           *t10*t33*t34*t9)-9.012345679012345d-2*t22*t38*(2.707771
     4           56307306d-4*gammaaa*t8+5.625d-3*gammaaa*t31*t32)+1.0266
     5           346832644656d-5*gammaaa*t8+4.509905755707676d-6*t6*t7+1
     6           .4419753086419754d-1*t22*t40-1.802469135802469d-1*t16*t
     7           40+3.443772335859989d-3*gammaaa*t31*t32+1.6455307846020
     8           564d-2*t15*t2)-5.074776173568845d-2*t2*t23*t39)*wght
              Mmat(iq,D1_TA) = Mmat(iq,D1_TA)-9.305257363490997d-1*t1*t2
     1           7*t4*(1.6455307846020564d-2*gammaaa*t2*(1.553671875d-3*
     2           gammaaa*t31*t33*t34*t9-4.97175d-2*t14*t32*t41*t7)+5.069
     3           444444444443d-4*t22*t32*t38*t41*t7-3.443772335859989d-3
     4           *t32*t41*t7+1.4419753086419754d-1*t22*t42-1.80246913580
     5           2469d-1*t16*t42)*wght
              Mmat(iq,D1_TB) = Mmat(iq,D1_TB)
            elseif (taua.gt.tol_rho.and.taub.le.tol_rho) then 
              t1 = rhoa**1.3333333333333333d+0
              t2 = 1/rhoa**2.6666666666666666d+0
              t3 = 2.040060021774676d-2*gammaaa*t2+1.0d+0
              t4 = 1/t3**2.0d+0
              t5 = gammaaa**3
              t6 = 1/rhoa**8
              t7 = gammaaa**2
              t8 = 1/rhoa**5.333333333333333d+0
              t9 = 1/rhoa
              t10 = 1/taua
              t11 = gammaaa*t10*t9
              t12 = t11**2.0d+0
              t13 = 1.5625d-2*t12+1.0d+0
              t14 = 1/t13**2.0d+0
              t15 = 2.485875d-2*t12*t14+1.234567901234568d-1
              t16 = (1.35388578153653d-4*t7*t8+2.8125d-3*t12)**5.0d-1
              t17 = 1/rhoa**1.6666666666666669d+0
              t18 = 2.0d+0*taua-2.5d-1*gammaaa*t9
              t19 = 1.0970205230680374d-1*t17*t18-1.0d+0
              t20 = 4.38808209227215d-2*t17*t18*t19+1.0d+0
              t21 = 1/t20**5.0d-1
              t22 = 4.5d-1*t19*t21+1.0970205230680376d-2*gammaaa*t2
              t23 = 5.133173416322327d-6*t7*t8+1.5033019185692253d-6*t5*
     1           t6+7.209876543209877d-2*t22**2-1.802469135802469d-1*t16
     2           *t22+1.6455307846020564d-2*gammaaa*t15*t2+1.72188616792
     3           99946d-3*t12
              t24 = 1.2437810945273631d+0*t23*t4+1.0d+0
              t25 = 8.04d-1-8.04d-1/t24
              t26 = rhoa**3.333333333333333d-1
              t27 = 1/t24**2
              t28 = 1/rhoa**6.333333333333333d+0
              t29 = 1/rhoa**3.6666666666666664d+0
              t30 = 1/rhoa**3
              t31 = 1/taua**2
              t32 = 1/rhoa**2
              t33 = 1/t13**3.0d+0
              t34 = t11**3.0d+0
              t35 = 2.7425513076700936d-2*gammaaa*t29-1.828367538446729d
     1           -1*t18*t2
              t36 = 1/t20**1.5d+0
              t37 = -2.25d-1*t19*(4.38808209227215d-2*t17*t18*t35+1.0970
     1           205230680374d-2*gammaaa*t19*t29-7.313470153786916d-2*t1
     2           8*t19*t2)*t36+4.5d-1*t21*t35-2.925388061514767d-2*gamma
     3           aa*t29
              t38 = 1/t16
              t39 = 1/t3**3.0d+0
              t40 = -2.25d-1*t19*(-1.0970205230680374d-2*t19*t2-1.203454
     1           0280324706d-3*t18/rhoa**4.333333333333333d+0)*t36-1.234
     2           1480884515421d-2*t2*t21+1.0970205230680376d-2*t2
              t41 = 1/taua**3
              t42 = 9.873184707612337d-2*t17*t21-2.25d-1*t19*(8.77616418
     1           45443d-2*t17*t19+9.627632224259765d-3*t18/rhoa**3.33333
     2           33333333337d+0)*t36
              fnc(iq) = (-9.305257363490997d-1*t1*t25-9.305257363490997d
     1           -1*t1)*wght+fnc(iq)
              Amat(iq,D1_RA) = (-7.481426920246762d-1*t1*t27*(1.24378109
     1           45273631d+0*t4*(1.6455307846020564d-2*gammaaa*t2*(1.553
     2           671875d-3*gammaaa*t10*t32*t33*t34-4.97175d-2*t14*t30*t3
     3           1*t7)-9.012345679012345d-2*t22*t38*(-5.625d-3*t30*t31*t
     4           7-7.220724168194825d-4*t28*t7)-3.443772335859989d-3*t30
     5           *t31*t7-2.737692488705241d-5*t28*t7-1.2026415348553804d
     6           -5*t5/rhoa**9+1.4419753086419754d-1*t22*t37-1.802469135
     7           802469d-1*t16*t37-4.3880820922721503d-2*gammaaa*t15*t29
     8           )+1.3532736462850253d-1*gammaaa*t23*t29*t39)-1.24070098
     9           17987995d+0*t25*t26-1.2407009817987995d+0*t26)*wght+Ama
     :           t(iq,D1_RA)
              Cmat(iq,D1_GAA) = Cmat(iq,D1_GAA)-7.481426920246762d-1*t1*
     1           t27*(1.2437810945273631d+0*t4*(1.6455307846020564d-2*ga
     2           mmaaa*t2*(4.97175d-2*gammaaa*t14*t31*t32-1.553671875d-3
     3           *t10*t33*t34*t9)-9.012345679012345d-2*t22*t38*(2.707771
     4           56307306d-4*gammaaa*t8+5.625d-3*gammaaa*t31*t32)+1.0266
     5           346832644656d-5*gammaaa*t8+4.509905755707676d-6*t6*t7+1
     6           .4419753086419754d-1*t22*t40-1.802469135802469d-1*t16*t
     7           40+3.443772335859989d-3*gammaaa*t31*t32+1.6455307846020
     8           564d-2*t15*t2)-5.074776173568845d-2*t2*t23*t39)*wght
              Mmat(iq,D1_TA) = Mmat(iq,D1_TA)-9.305257363490997d-1*t1*t2
     1           7*t4*(1.6455307846020564d-2*gammaaa*t2*(1.553671875d-3*
     2           gammaaa*t31*t33*t34*t9-4.97175d-2*t14*t32*t41*t7)+5.069
     3           444444444443d-4*t22*t32*t38*t41*t7-3.443772335859989d-3
     4           *t32*t41*t7+1.4419753086419754d-1*t22*t42-1.80246913580
     5           2469d-1*t16*t42)*wght
              Mmat(iq,D1_TB) = Mmat(iq,D1_TB)
            elseif (taua.le.tol_rho.and.taub.gt.tol_rho) then 
              t1 = rhoa**1.3333333333333333d+0
              t2 = 1/rhoa**1.6666666666666669d+0
              t3 = 1.0970205230680374d-51*t2-1.0d+0
              t4 = 4.3880820922721503d-52*t2*t3+1.0d+0
              t5 = 1/t4**5.0d-1
              t6 = 4.5d-1*t3*t5+4.3880820922721503d-52*t2
              t7 = 1/rhoa**3.3333333333333337d+0
              t8 = (2.166217250458448d-103*t7+4.4999999999999996d-2)**5.
     1           0d-1
              t9 = -1.802469135802469d-1*t6*t8+8.213077466115726d-105*t7
     1           +7.209876543209877d-2*t6**2+2.4881109353903252d-52*t2+9
     2           .621132278843042d-155/rhoa**5+2.755017868687991d-2
              t10 = 8.160240087098705d-52*t2+1.0d+0
              t11 = 1/t10**2.0d+0
              t12 = 1.2437810945273631d+0*t11*t9+1.0d+0
              t13 = 8.04d-1-8.04d-1/t12
              t14 = rhoa**3.333333333333333d-1
              t15 = 1/rhoa**4.333333333333333d+0
              t16 = 1/rhoa**2.6666666666666666d+0
              t17 = -8.227653923010281d-52*t16*t5-2.25d-1*t3*(-7.3134701
     1           53786917d-52*t16*t3-8.023026853549804d-103*t15)/t4**1.5
     2           d+0-7.313470153786917d-52*t16
              fnc(iq) = (-9.305257363490997d-1*t1*t13-9.305257363490997d
     1           -1*t1)*wght+fnc(iq)
              Amat(iq,D1_RA) = (-7.481426920246762d-1*t1*(3.383184115712
     1           5636d-51*t16*t9/t10**3.0d+0+1.2437810945273631d+0*t11*(
     2           -1.802469135802469d-1*t17*t8+6.507566225657065d-104*t15
     3           *t6/t8+1.4419753086419754d-1*t17*t6-4.146851558983876d-
     4           52*t16-2.737692488705242d-104*t15-4.810566139421521d-15
     5           4/rhoa**6))/t12**2-1.2407009817987995d+0*t13*t14-1.2407
     6           009817987995d+0*t14)*wght+Amat(iq,D1_RA)
              Cmat(iq,D1_GAA) = Cmat(iq,D1_GAA)
              Mmat(iq,D1_TA) = Mmat(iq,D1_TA)
              Mmat(iq,D1_TB) = Mmat(iq,D1_TB)
            else 
              t1 = rhoa**1.3333333333333333d+0
              t2 = 1/rhoa**1.6666666666666669d+0
              t3 = 1.0970205230680374d-51*t2-1.0d+0
              t4 = 4.3880820922721503d-52*t2*t3+1.0d+0
              t5 = 1/t4**5.0d-1
              t6 = 4.5d-1*t3*t5+4.3880820922721503d-52*t2
              t7 = 1/rhoa**3.3333333333333337d+0
              t8 = (2.166217250458448d-103*t7+4.4999999999999996d-2)**5.
     1           0d-1
              t9 = -1.802469135802469d-1*t6*t8+8.213077466115726d-105*t7
     1           +7.209876543209877d-2*t6**2+2.4881109353903252d-52*t2+9
     2           .621132278843042d-155/rhoa**5+2.755017868687991d-2
              t10 = 8.160240087098705d-52*t2+1.0d+0
              t11 = 1/t10**2.0d+0
              t12 = 1.2437810945273631d+0*t11*t9+1.0d+0
              t13 = 8.04d-1-8.04d-1/t12
              t14 = rhoa**3.333333333333333d-1
              t15 = 1/rhoa**4.333333333333333d+0
              t16 = 1/rhoa**2.6666666666666666d+0
              t17 = -8.227653923010281d-52*t16*t5-2.25d-1*t3*(-7.3134701
     1           53786917d-52*t16*t3-8.023026853549804d-103*t15)/t4**1.5
     2           d+0-7.313470153786917d-52*t16
              fnc(iq) = (-9.305257363490997d-1*t1*t13-9.305257363490997d
     1           -1*t1)*wght+fnc(iq)
              Amat(iq,D1_RA) = (-7.481426920246762d-1*t1*(3.383184115712
     1           5636d-51*t16*t9/t10**3.0d+0+1.2437810945273631d+0*t11*(
     2           -1.802469135802469d-1*t17*t8+6.507566225657065d-104*t15
     3           *t6/t8+1.4419753086419754d-1*t17*t6-4.146851558983876d-
     4           52*t16-2.737692488705242d-104*t15-4.810566139421521d-15
     5           4/rhoa**6))/t12**2-1.2407009817987995d+0*t13*t14-1.2407
     6           009817987995d+0*t14)*wght+Amat(iq,D1_RA)
              Cmat(iq,D1_GAA) = Cmat(iq,D1_GAA)
              Mmat(iq,D1_TA) = Mmat(iq,D1_TA)
              Mmat(iq,D1_TB) = Mmat(iq,D1_TB)
            endif 
          elseif (rhoa.le.tol_rho.and.rhob.gt.tol_rho) then 
            if (taua.gt.tol_rho.and.taub.gt.tol_rho) then 
              t1 = rhob**1.3333333333333333d+0
              t2 = 1/rhob**2.6666666666666666d+0
              t3 = 2.040060021774676d-2*gammabb*t2+1.0d+0
              t4 = 1/t3**2.0d+0
              t5 = gammabb**3
              t6 = 1/rhob**8
              t7 = gammabb**2
              t8 = 1/rhob**5.333333333333333d+0
              t9 = 1/rhob
              t10 = 1/taub
              t11 = gammabb*t10*t9
              t12 = t11**2.0d+0
              t13 = 1.5625d-2*t12+1.0d+0
              t14 = 1/t13**2.0d+0
              t15 = 2.485875d-2*t12*t14+1.234567901234568d-1
              t16 = (1.35388578153653d-4*t7*t8+2.8125d-3*t12)**5.0d-1
              t17 = 1/rhob**1.6666666666666669d+0
              t18 = 2.0d+0*taub-2.5d-1*gammabb*t9
              t19 = 1.0970205230680374d-1*t17*t18-1.0d+0
              t20 = 4.38808209227215d-2*t17*t18*t19+1.0d+0
              t21 = 1/t20**5.0d-1
              t22 = 4.5d-1*t19*t21+1.0970205230680376d-2*gammabb*t2
              t23 = 5.133173416322327d-6*t7*t8+1.5033019185692253d-6*t5*
     1           t6+7.209876543209877d-2*t22**2-1.802469135802469d-1*t16
     2           *t22+1.6455307846020564d-2*gammabb*t15*t2+1.72188616792
     3           99946d-3*t12
              t24 = 1.2437810945273631d+0*t23*t4+1.0d+0
              t25 = 8.04d-1-8.04d-1/t24
              t26 = rhob**3.333333333333333d-1
              t27 = 1/t24**2
              t28 = 1/rhob**6.333333333333333d+0
              t29 = 1/rhob**3.6666666666666664d+0
              t30 = 1/rhob**3
              t31 = 1/taub**2
              t32 = 1/rhob**2
              t33 = 1/t13**3.0d+0
              t34 = t11**3.0d+0
              t35 = 2.7425513076700936d-2*gammabb*t29-1.828367538446729d
     1           -1*t18*t2
              t36 = 1/t20**1.5d+0
              t37 = -2.25d-1*t19*(4.38808209227215d-2*t17*t18*t35+1.0970
     1           205230680374d-2*gammabb*t19*t29-7.313470153786916d-2*t1
     2           8*t19*t2)*t36+4.5d-1*t21*t35-2.925388061514767d-2*gamma
     3           bb*t29
              t38 = 1/t16
              t39 = 1/t3**3.0d+0
              t40 = -2.25d-1*t19*(-1.0970205230680374d-2*t19*t2-1.203454
     1           0280324706d-3*t18/rhob**4.333333333333333d+0)*t36-1.234
     2           1480884515421d-2*t2*t21+1.0970205230680376d-2*t2
              t41 = 1/taub**3
              t42 = 9.873184707612337d-2*t17*t21-2.25d-1*t19*(8.77616418
     1           45443d-2*t17*t19+9.627632224259765d-3*t18/rhob**3.33333
     2           33333333337d+0)*t36
              fnc(iq) = (-9.305257363490997d-1*t1*t25-9.305257363490997d
     1           -1*t1)*wght+fnc(iq)
              Amat(iq,D1_RB) = (-7.481426920246762d-1*t1*t27*(1.24378109
     1           45273631d+0*t4*(1.6455307846020564d-2*gammabb*t2*(1.553
     2           671875d-3*gammabb*t10*t32*t33*t34-4.97175d-2*t14*t30*t3
     3           1*t7)-9.012345679012345d-2*t22*t38*(-5.625d-3*t30*t31*t
     4           7-7.220724168194825d-4*t28*t7)-3.443772335859989d-3*t30
     5           *t31*t7-2.737692488705241d-5*t28*t7-1.2026415348553804d
     6           -5*t5/rhob**9+1.4419753086419754d-1*t22*t37-1.802469135
     7           802469d-1*t16*t37-4.3880820922721503d-2*gammabb*t15*t29
     8           )+1.3532736462850253d-1*gammabb*t23*t29*t39)-1.24070098
     9           17987995d+0*t25*t26-1.2407009817987995d+0*t26)*wght+Ama
     :           t(iq,D1_RB)
              Cmat(iq,D1_GBB) = Cmat(iq,D1_GBB)-7.481426920246762d-1*t1*
     1           t27*(1.2437810945273631d+0*t4*(1.6455307846020564d-2*ga
     2           mmabb*t2*(4.97175d-2*gammabb*t14*t31*t32-1.553671875d-3
     3           *t10*t33*t34*t9)-9.012345679012345d-2*t22*t38*(2.707771
     4           56307306d-4*gammabb*t8+5.625d-3*gammabb*t31*t32)+1.0266
     5           346832644656d-5*gammabb*t8+4.509905755707676d-6*t6*t7+1
     6           .4419753086419754d-1*t22*t40-1.802469135802469d-1*t16*t
     7           40+3.443772335859989d-3*gammabb*t31*t32+1.6455307846020
     8           564d-2*t15*t2)-5.074776173568845d-2*t2*t23*t39)*wght
              Mmat(iq,D1_TB) = Mmat(iq,D1_TB)-9.305257363490997d-1*t1*t2
     1           7*t4*(1.6455307846020564d-2*gammabb*t2*(1.553671875d-3*
     2           gammabb*t31*t33*t34*t9-4.97175d-2*t14*t32*t41*t7)+5.069
     3           444444444443d-4*t22*t32*t38*t41*t7-3.443772335859989d-3
     4           *t32*t41*t7+1.4419753086419754d-1*t22*t42-1.80246913580
     5           2469d-1*t16*t42)*wght
              Mmat(iq,D1_TA) = Mmat(iq,D1_TA)
            elseif (taua.gt.tol_rho.and.taub.le.tol_rho) then 
              t1 = rhob**1.3333333333333333d+0
              t2 = 1/rhob**1.6666666666666669d+0
              t3 = 1.0970205230680374d-51*t2-1.0d+0
              t4 = 4.3880820922721503d-52*t2*t3+1.0d+0
              t5 = 1/t4**5.0d-1
              t6 = 4.5d-1*t3*t5+4.3880820922721503d-52*t2
              t7 = 1/rhob**3.3333333333333337d+0
              t8 = (2.166217250458448d-103*t7+4.4999999999999996d-2)**5.
     1           0d-1
              t9 = -1.802469135802469d-1*t6*t8+8.213077466115726d-105*t7
     1           +7.209876543209877d-2*t6**2+2.4881109353903252d-52*t2+9
     2           .621132278843042d-155/rhob**5+2.755017868687991d-2
              t10 = 8.160240087098705d-52*t2+1.0d+0
              t11 = 1/t10**2.0d+0
              t12 = 1.2437810945273631d+0*t11*t9+1.0d+0
              t13 = 8.04d-1-8.04d-1/t12
              t14 = rhob**3.333333333333333d-1
              t15 = 1/rhob**4.333333333333333d+0
              t16 = 1/rhob**2.6666666666666666d+0
              t17 = -8.227653923010281d-52*t16*t5-2.25d-1*t3*(-7.3134701
     1           53786917d-52*t16*t3-8.023026853549804d-103*t15)/t4**1.5
     2           d+0-7.313470153786917d-52*t16
              fnc(iq) = (-9.305257363490997d-1*t1*t13-9.305257363490997d
     1           -1*t1)*wght+fnc(iq)
              Amat(iq,D1_RB) = (-7.481426920246762d-1*t1*(3.383184115712
     1           5636d-51*t16*t9/t10**3.0d+0+1.2437810945273631d+0*t11*(
     2           -1.802469135802469d-1*t17*t8+6.507566225657065d-104*t15
     3           *t6/t8+1.4419753086419754d-1*t17*t6-4.146851558983876d-
     4           52*t16-2.737692488705242d-104*t15-4.810566139421521d-15
     5           4/rhob**6))/t12**2-1.2407009817987995d+0*t13*t14-1.2407
     6           009817987995d+0*t14)*wght+Amat(iq,D1_RB)
              Cmat(iq,D1_GBB) = Cmat(iq,D1_GBB)
              Mmat(iq,D1_TB) = Mmat(iq,D1_TB)
              Mmat(iq,D1_TA) = Mmat(iq,D1_TA)
            elseif (taua.le.tol_rho.and.taub.gt.tol_rho) then 
              t1 = rhob**1.3333333333333333d+0
              t2 = 1/rhob**2.6666666666666666d+0
              t3 = 2.040060021774676d-2*gammabb*t2+1.0d+0
              t4 = 1/t3**2.0d+0
              t5 = gammabb**3
              t6 = 1/rhob**8
              t7 = gammabb**2
              t8 = 1/rhob**5.333333333333333d+0
              t9 = 1/rhob
              t10 = 1/taub
              t11 = gammabb*t10*t9
              t12 = t11**2.0d+0
              t13 = 1.5625d-2*t12+1.0d+0
              t14 = 1/t13**2.0d+0
              t15 = 2.485875d-2*t12*t14+1.234567901234568d-1
              t16 = (1.35388578153653d-4*t7*t8+2.8125d-3*t12)**5.0d-1
              t17 = 1/rhob**1.6666666666666669d+0
              t18 = 2.0d+0*taub-2.5d-1*gammabb*t9
              t19 = 1.0970205230680374d-1*t17*t18-1.0d+0
              t20 = 4.38808209227215d-2*t17*t18*t19+1.0d+0
              t21 = 1/t20**5.0d-1
              t22 = 4.5d-1*t19*t21+1.0970205230680376d-2*gammabb*t2
              t23 = 5.133173416322327d-6*t7*t8+1.5033019185692253d-6*t5*
     1           t6+7.209876543209877d-2*t22**2-1.802469135802469d-1*t16
     2           *t22+1.6455307846020564d-2*gammabb*t15*t2+1.72188616792
     3           99946d-3*t12
              t24 = 1.2437810945273631d+0*t23*t4+1.0d+0
              t25 = 8.04d-1-8.04d-1/t24
              t26 = rhob**3.333333333333333d-1
              t27 = 1/t24**2
              t28 = 1/rhob**6.333333333333333d+0
              t29 = 1/rhob**3.6666666666666664d+0
              t30 = 1/rhob**3
              t31 = 1/taub**2
              t32 = 1/rhob**2
              t33 = 1/t13**3.0d+0
              t34 = t11**3.0d+0
              t35 = 2.7425513076700936d-2*gammabb*t29-1.828367538446729d
     1           -1*t18*t2
              t36 = 1/t20**1.5d+0
              t37 = -2.25d-1*t19*(4.38808209227215d-2*t17*t18*t35+1.0970
     1           205230680374d-2*gammabb*t19*t29-7.313470153786916d-2*t1
     2           8*t19*t2)*t36+4.5d-1*t21*t35-2.925388061514767d-2*gamma
     3           bb*t29
              t38 = 1/t16
              t39 = 1/t3**3.0d+0
              t40 = -2.25d-1*t19*(-1.0970205230680374d-2*t19*t2-1.203454
     1           0280324706d-3*t18/rhob**4.333333333333333d+0)*t36-1.234
     2           1480884515421d-2*t2*t21+1.0970205230680376d-2*t2
              t41 = 1/taub**3
              t42 = 9.873184707612337d-2*t17*t21-2.25d-1*t19*(8.77616418
     1           45443d-2*t17*t19+9.627632224259765d-3*t18/rhob**3.33333
     2           33333333337d+0)*t36
              fnc(iq) = (-9.305257363490997d-1*t1*t25-9.305257363490997d
     1           -1*t1)*wght+fnc(iq)
              Amat(iq,D1_RB) = (-7.481426920246762d-1*t1*t27*(1.24378109
     1           45273631d+0*t4*(1.6455307846020564d-2*gammabb*t2*(1.553
     2           671875d-3*gammabb*t10*t32*t33*t34-4.97175d-2*t14*t30*t3
     3           1*t7)-9.012345679012345d-2*t22*t38*(-5.625d-3*t30*t31*t
     4           7-7.220724168194825d-4*t28*t7)-3.443772335859989d-3*t30
     5           *t31*t7-2.737692488705241d-5*t28*t7-1.2026415348553804d
     6           -5*t5/rhob**9+1.4419753086419754d-1*t22*t37-1.802469135
     7           802469d-1*t16*t37-4.3880820922721503d-2*gammabb*t15*t29
     8           )+1.3532736462850253d-1*gammabb*t23*t29*t39)-1.24070098
     9           17987995d+0*t25*t26-1.2407009817987995d+0*t26)*wght+Ama
     :           t(iq,D1_RB)
              Cmat(iq,D1_GBB) = Cmat(iq,D1_GBB)-7.481426920246762d-1*t1*
     1           t27*(1.2437810945273631d+0*t4*(1.6455307846020564d-2*ga
     2           mmabb*t2*(4.97175d-2*gammabb*t14*t31*t32-1.553671875d-3
     3           *t10*t33*t34*t9)-9.012345679012345d-2*t22*t38*(2.707771
     4           56307306d-4*gammabb*t8+5.625d-3*gammabb*t31*t32)+1.0266
     5           346832644656d-5*gammabb*t8+4.509905755707676d-6*t6*t7+1
     6           .4419753086419754d-1*t22*t40-1.802469135802469d-1*t16*t
     7           40+3.443772335859989d-3*gammabb*t31*t32+1.6455307846020
     8           564d-2*t15*t2)-5.074776173568845d-2*t2*t23*t39)*wght
              Mmat(iq,D1_TB) = Mmat(iq,D1_TB)-9.305257363490997d-1*t1*t2
     1           7*t4*(1.6455307846020564d-2*gammabb*t2*(1.553671875d-3*
     2           gammabb*t31*t33*t34*t9-4.97175d-2*t14*t32*t41*t7)+5.069
     3           444444444443d-4*t22*t32*t38*t41*t7-3.443772335859989d-3
     4           *t32*t41*t7+1.4419753086419754d-1*t22*t42-1.80246913580
     5           2469d-1*t16*t42)*wght
              Mmat(iq,D1_TA) = Mmat(iq,D1_TA)
            else 
              t1 = rhob**1.3333333333333333d+0
              t2 = 1/rhob**1.6666666666666669d+0
              t3 = 1.0970205230680374d-51*t2-1.0d+0
              t4 = 4.3880820922721503d-52*t2*t3+1.0d+0
              t5 = 1/t4**5.0d-1
              t6 = 4.5d-1*t3*t5+4.3880820922721503d-52*t2
              t7 = 1/rhob**3.3333333333333337d+0
              t8 = (2.166217250458448d-103*t7+4.4999999999999996d-2)**5.
     1           0d-1
              t9 = -1.802469135802469d-1*t6*t8+8.213077466115726d-105*t7
     1           +7.209876543209877d-2*t6**2+2.4881109353903252d-52*t2+9
     2           .621132278843042d-155/rhob**5+2.755017868687991d-2
              t10 = 8.160240087098705d-52*t2+1.0d+0
              t11 = 1/t10**2.0d+0
              t12 = 1.2437810945273631d+0*t11*t9+1.0d+0
              t13 = 8.04d-1-8.04d-1/t12
              t14 = rhob**3.333333333333333d-1
              t15 = 1/rhob**4.333333333333333d+0
              t16 = 1/rhob**2.6666666666666666d+0
              t17 = -8.227653923010281d-52*t16*t5-2.25d-1*t3*(-7.3134701
     1           53786917d-52*t16*t3-8.023026853549804d-103*t15)/t4**1.5
     2           d+0-7.313470153786917d-52*t16
              fnc(iq) = (-9.305257363490997d-1*t1*t13-9.305257363490997d
     1           -1*t1)*wght+fnc(iq)
              Amat(iq,D1_RB) = (-7.481426920246762d-1*t1*(3.383184115712
     1           5636d-51*t16*t9/t10**3.0d+0+1.2437810945273631d+0*t11*(
     2           -1.802469135802469d-1*t17*t8+6.507566225657065d-104*t15
     3           *t6/t8+1.4419753086419754d-1*t17*t6-4.146851558983876d-
     4           52*t16-2.737692488705242d-104*t15-4.810566139421521d-15
     5           4/rhob**6))/t12**2-1.2407009817987995d+0*t13*t14-1.2407
     6           009817987995d+0*t14)*wght+Amat(iq,D1_RB)
              Cmat(iq,D1_GBB) = Cmat(iq,D1_GBB)
              Mmat(iq,D1_TB) = Mmat(iq,D1_TB)
              Mmat(iq,D1_TA) = Mmat(iq,D1_TA)
            endif 
          endif ! rhoa.gt.tol_rho.and.rhob.gt.tol_rho 
        endif ! ipol.eq.1 
      enddo ! iq 
      end 
C> 
C> \brief Evaluate the nwxcm_x_tpss03 functional [1] 
C> 
C> \f{eqnarray*}{ 
C>   {\it t_1} &=& \rho_\alpha^{{{4}\over{3}}}\\\\ 
C>   {\it t_2} &=& \rho_\beta^{{{4}\over{3}}}\\\\ 
C>   {\it t_3} &=& {{1}\over{\rho_\alpha^{{{8}\over{3}}}}}\\\\ 
C>   {\it t_4} &=& {{1}\over{\rho_\alpha^{{{16}\over{3}}}}}\\\\ 
C>   {\it t_5} &=& \sigma_{\alpha\alpha}^2\\\\ 
C>   {\it t_6} &=& {{1}\over{\rho_\alpha}}\\\\ 
C>   {\it t_7} &=& \left({{{\it t_6}\,\sigma_{\alpha\alpha}}
C>    \over{\tau_\alpha}}\right)^{2.0}\\\\ 
C>   {\it t_8} &=& {{1}\over{\rho_\alpha^{{{5}\over{3}}}}}\\\\ 
C>   {\it t_9} &=& 2.0\,\tau_\alpha-0.25\,{\it t_6}\,
C>    \sigma_{\alpha\alpha}\\\\ 
C>   {\it t_{10}} &=& 0.1097020523068037\,{\it t_8}\,{\it t_9}-1.0\\\\ 
C>   {\it t_{11}} &=& {{0.45\,{\it t_{10}}}\over{
C>    \left(0.0438808209227215\,{\it t_8}\,{\it t_9}\,{\it t_{10}}
C>    +1.0\right)^{0.5}}}+0.01097020523068038\,{\it t_3}\,
C>    \sigma_{\alpha\alpha}\\\\ 
C>   {\it t_{12}} &=& {{1}\over{\rho_\beta^{{{8}\over{3}}}}}\\\\ 
C>   {\it t_{13}} &=& {{1}\over{\rho_\beta^{{{16}\over{3}}}}}\\\\ 
C>   {\it t_{14}} &=& \sigma_{\beta\beta}^2\\\\ 
C>   {\it t_{15}} &=& {{1}\over{\rho_\beta}}\\\\ 
C>   {\it t_{16}} &=& \left({{{\it t_{15}}\,
C>    \sigma_{\beta\beta}}\over{\tau_\beta}}\right)^{2.0}\\\\ 
C>   {\it t_{17}} &=& {{1}\over{\rho_\beta^{{{5}\over{3}}}}}\\\\ 
C>   {\it t_{18}} &=& 2.0\,\tau_\beta-0.25\,{\it t_{15}}\,
C>    \sigma_{\beta\beta}\\\\ 
C>   {\it t_{19}} &=& 0.1097020523068037\,{\it t_{17}}\,{\it t_{18}}
C>    -1.0\\\\ 
C>   {\it t_{20}} &=& {{0.45\,{\it t_{19}}}\over{
C>    \left(0.0438808209227215\,{\it t_{17}}\,{\it t_{18}}\,{
C>    \it t_{19}}+1.0\right)^{0.5}}}+0.01097020523068038\,{
C>    \it t_{12}}\,\sigma_{\beta\beta}\\\\ 
C>   {\it t_{21}} &=& \rho_s^{{{4}\over{3}}}\\\\ 
C>   {\it t_{22}} &=& {{1}\over{\rho_s^{{{8}\over{3}}}}}\\\\ 
C>   {\it t_{23}} &=& {{1}\over{\rho_s^{{{16}\over{3}}}}}\\\\ 
C>   {\it t_{24}} &=& \sigma_{ss}^2\\\\ 
C>   {\it t_{25}} &=& {{1}\over{\rho_s}}\\\\ 
C>   {\it t_{26}} &=& \left({{{\it t_{25}}\,\sigma_{ss}}
C>    \over{\tau_s}}\right)^{2.0}\\\\ 
C>   {\it t_{27}} &=& {{1}\over{\rho_s^{{{5}\over{3}}}}}\\\\ 
C>   {\it t_{28}} &=& 2.0\,\tau_s-0.25\,{\it t_{25}}\,\sigma_{ss}\\\\ 
C>   {\it t_{29}} &=& 0.1097020523068037\,{\it t_{27}}\,{\it t_{28}}
C>    -1.0\\\\ 
C>   {\it t_{30}} &=& {{0.45\,{\it t_{29}}}\over{
C>    \left(0.0438808209227215\,{\it t_{27}}\,{\it t_{28}}\,{
C>    \it t_{29}}+1.0\right)^{0.5}}}+0.01097020523068038\,{
C>    \it t_{22}}\,\sigma_{ss}\\\\ 
C>   f &=& -0.9305257363490997\,{\it t_2}\,\left(0.804
C>    -{{0.804}\over{{{1.243781094527363\,\left(0.07209876543209877
C>    \,{\it t_{20}}^2-0.1802469135802469\,\left(0.0028125\,{
C>    \it t_{16}}+1.35388578153653 \times 10^{-4}\,{\it t_{13}}\,{
C>    \it t_{14}}\right)^{0.5}\,{\it t_{20}}+0.01645530784602056
C>    \,{\it t_{12}}\,\sigma_{\beta\beta}\,\left({{0.02485875\,{
C>    \it t_{16}}}\over{\left(0.015625\,{\it t_{16}}
C>    +1.0\right)^{2.0}}}+0.1234567901234568\right)
C>    +0.001721886167929995\,{\it t_{16}}
C>    +{{1.503301918569225 \times 10^{-6}\,
C>    \sigma_{\beta\beta}^3}\over{\rho_\beta^8}}
C>    +5.133173416322327 \times 10^{-6}\,{\it t_{13}}\,{
C>    \it t_{14}}\right)}\over{\left(0.02040060021774676\,{
C>    \it t_{12}}\,\sigma_{\beta\beta}+1.0\right)^{2.0}}}+1.0}}\right)
C>    -0.9305257363490997\,{\it t_1}\,\left(0.804-{{0.804}
C>    \over{{{1.243781094527363\,\left(0.07209876543209877\,{
C>    \it t_{11}}^2-0.1802469135802469\,\left(0.0028125\,{\it t_7}
C>    +1.35388578153653 \times 10^{-4}\,{\it t_4}\,{
C>    \it t_5}\right)^{0.5}\,{\it t_{11}}+0.01645530784602056\,{
C>    \it t_3}\,\sigma_{\alpha\alpha}\,\left({{0.02485875\,{
C>    \it t_7}}\over{\left(0.015625\,{\it t_7}+1.0\right)^{2.0}}}
C>    +0.1234567901234568\right)+0.001721886167929995\,{\it t_7}
C>    +{{1.503301918569225 \times 10^{-6}\,
C>    \sigma_{\alpha\alpha}^3}\over{\rho_\alpha^8}}
C>    +5.133173416322327 \times 10^{-6}\,{\it t_4}\,{
C>    \it t_5}\right)}\over{\left(0.02040060021774676\,{\it t_3}
C>    \,\sigma_{\alpha\alpha}+1.0\right)^{2.0}}}+1.0}}\right)
C>    -0.9305257363490997\,{\it t_2}-0.9305257363490997\,{\it t_1}\\\\ 
C>   g &=& 0\\\\ 
C>   G &=& -0.9305257363490997\,{\it t_{21}}\,\left(0.804
C>    -{{0.804}\over{{{1.243781094527363\,\left(0.07209876543209877
C>    \,{\it t_{30}}^2-0.1802469135802469\,\left(0.0028125\,{
C>    \it t_{26}}+1.35388578153653 \times 10^{-4}\,{\it t_{23}}\,{
C>    \it t_{24}}\right)^{0.5}\,{\it t_{30}}+0.01645530784602056
C>    \,{\it t_{22}}\,\sigma_{ss}\,\left({{0.02485875\,{
C>    \it t_{26}}}\over{\left(0.015625\,{\it t_{26}}
C>    +1.0\right)^{2.0}}}+0.1234567901234568\right)
C>    +0.001721886167929995\,{\it t_{26}}
C>    +{{1.503301918569225 \times 10^{-6}\,\sigma_{ss}^3}
C>    \over{\rho_s^8}}+5.133173416322327 \times 10^{-6}\,{
C>    \it t_{23}}\,{\it t_{24}}\right)}\over{
C>    \left(0.02040060021774676\,{\it t_{22}}\,\sigma_{ss}
C>    +1.0\right)^{2.0}}}+1.0}}\right)-0.9305257363490997\,{
C>    \it t_{21}}\\\\ 
C> \f} 
C> 
C> Code generated with Maxima 5.34.0 [2] 
C> driven by autoxc-Ds [3]. 
C> 
C> ### References ### 
C> 
C> [1] J Tao, JP Perdew, VN Staveroverov, GE Scuseria
C>    , Phys.Rev.Lett. 91, 146401 (2003)  , DOI: 
C> <a href="https://doi.org/10.1103/PhysRevLett.91.146401 "> 
C> 10.1103/PhysRevLett.91.146401 </a> 
C> 
C> [2] Maxima, a computer algebra system, 
C> <a href="http://maxima.sourceforge.net/"> 
C> http://maxima.sourceforge.net/</a> 
C> 
C> [3] autoxc-Ds, revision 27207 2015-06-23 
C> 
      subroutine nwxcm_x_tpss03_d2(param,tol_rho,ipol,nq,wght, 
     +rho,rgamma,tau,fnc,Amat,Amat2,Cmat,Cmat2,Mmat,Mmat2) 
c $Id: $ 
#ifdef NWXC_QUAD_PREC 
      implicit real(kind=selected_real_kind(30))(a-h,o-z),integer(i-n) 
      integer, parameter :: rk=selected_real_kind(30) 
#else 
      implicit real(kind=selected_real_kind(15))(a-h,o-z),integer(i-n) 
      integer, parameter :: rk=selected_real_kind(15) 
#endif 
#include "nwxc_param.fh" 
      double precision param(*)     !< [Input] Parameters of functional 
      double precision tol_rho      !< [Input] The lower limit on the density 
      integer ipol                  !< [Input] The number of spin channels 
      integer nq                    !< [Input] The number of points 
      double precision wght         !< [Input] The weight of the functional 
      double precision rho(nq,NCOL_RHO)      !< [Input] The density 
      double precision rgamma(nq,NCOL_GAMMA) !< [Input] The norm of the density 
                                             !< gradients 
      double precision tau(nq,NCOL_TAU)      !< [Input] The kinetic energy density 
      double precision fnc(nq)      !< [Output] The value of the functional 
c 
c     Sampling Matrices for the XC Kernel 
c 
      double precision Amat(nq,NCOL_AMAT)   !< [Output] The derivative wrt rho 
      double precision Cmat(nq,NCOL_CMAT)   !< [Output] The derivative wrt rgamma 
      double precision Mmat(nq,NCOL_MMAT)   !< [Output] The derivative wrt tau 
c 
c     Sampling Matrices for the XC Kernel 
c 
      double precision Amat2(nq,NCOL_AMAT2)  !< [Output] The 2nd derivative wrt rho 
      double precision Cmat2(nq,NCOL_CMAT2)  !< [Output] The 2nd derivative wrt rgamma 
                                             !< and possibly rho 
      double precision Mmat2(nq,NCOL_MMAT2)  !< [Output] The 2nd derivative wrt tau 
                                             !< and possibly rho 
      integer iq 
      double precision tmp 
      double precision rhoa,rhob 
      double precision gammaaa,gammaab,gammabb 
      double precision taua,taub 
      double precision nwxcm_heaviside 
      external         nwxcm_heaviside 
CDIR$ NOVECTOR
      do iq = 1, nq 
        if (ipol.eq.1) then 
          rhoa    = 0.5d0*rho(iq,R_T) 
          gammaaa = 0.25d0*rgamma(iq,G_TT) 
          taua    = 0.5d0*tau(iq,T_T) 
          if (rhoa.gt.tol_rho) then 
            if (taua.gt.tol_rho) then 
              t1 = rhoa**1.3333333333333333d+0
              t2 = 1/rhoa**2.6666666666666666d+0
              t3 = 2.040060021774676d-2*gammaaa*t2+1.0d+0
              t4 = 1/t3**2.0d+0
              t5 = gammaaa**3
              t6 = 1/rhoa**8
              t7 = gammaaa**2
              t8 = 1/rhoa**5.333333333333333d+0
              t9 = 1/rhoa
              t10 = 1/taua
              t11 = gammaaa*t10*t9
              t12 = t11**2.0d+0
              t13 = 1.5625d-2*t12+1.0d+0
              t14 = 1/t13**2.0d+0
              t15 = 2.485875d-2*t12*t14+1.234567901234568d-1
              t16 = 1.35388578153653d-4*t7*t8+2.8125d-3*t12
              t17 = t16**5.0d-1
              t18 = 1/rhoa**1.6666666666666669d+0
              t19 = 2.0d+0*taua-2.5d-1*gammaaa*t9
              t20 = 1.0970205230680374d-1*t18*t19-1.0d+0
              t21 = 4.38808209227215d-2*t18*t19*t20+1.0d+0
              t22 = 1/t21**5.0d-1
              t23 = 4.5d-1*t20*t22+1.0970205230680376d-2*gammaaa*t2
              t24 = 5.133173416322327d-6*t7*t8+1.5033019185692253d-6*t5*
     1           t6+7.209876543209877d-2*t23**2-1.802469135802469d-1*t17
     2           *t23+1.6455307846020564d-2*gammaaa*t15*t2+1.72188616792
     3           99946d-3*t12
              t25 = 1.2437810945273631d+0*t24*t4+1.0d+0
              t26 = 8.04d-1-8.04d-1/t25
              t27 = rhoa**3.333333333333333d-1
              t28 = 1/t25**2
              t29 = 1/rhoa**9
              t30 = 1/rhoa**6.333333333333333d+0
              t31 = 1/rhoa**3.6666666666666664d+0
              t32 = 1/rhoa**3
              t33 = 1/taua**2
              t34 = 1/rhoa**2
              t35 = 1/t13**3.0d+0
              t36 = t11**3.0d+0
              t37 = 1.553671875d-3*gammaaa*t10*t34*t35*t36-4.97175d-2*t1
     1           4*t32*t33*t7
              t38 = 2.7425513076700936d-2*gammaaa*t31-1.828367538446729d
     1           -1*t19*t2
              t39 = 4.38808209227215d-2*t18*t19*t38+1.0970205230680374d-
     1           2*gammaaa*t20*t31-7.313470153786916d-2*t19*t2*t20
              t40 = 1/t21**1.5d+0
              t41 = -2.25d-1*t20*t39*t40+4.5d-1*t22*t38-2.92538806151476
     1           7d-2*gammaaa*t31
              t42 = 1/t17
              t43 = -5.625d-3*t32*t33*t7-7.220724168194825d-4*t30*t7
              t44 = -3.443772335859989d-3*t32*t33*t7-2.737692488705241d-
     1           5*t30*t7-1.2026415348553804d-5*t29*t5-9.012345679012345
     2           d-2*t23*t42*t43+1.4419753086419754d-1*t23*t41-1.8024691
     3           35802469d-1*t17*t41+1.6455307846020564d-2*gammaaa*t2*t3
     4           7-4.3880820922721503d-2*gammaaa*t15*t31
              t45 = 1/t3**3.0d+0
              t46 = 1.3532736462850253d-1*gammaaa*t24*t31*t45+1.24378109
     1           45273631d+0*t4*t44
              t47 = 4.97175d-2*gammaaa*t14*t33*t34-1.553671875d-3*t10*t3
     1           5*t36*t9
              t48 = 1/rhoa**4.333333333333333d+0
              t49 = -1.2034540280324706d-3*t19*t48-1.0970205230680374d-2
     1           *t2*t20
              t50 = -2.25d-1*t20*t40*t49-1.2341480884515421d-2*t2*t22+1.
     1           0970205230680376d-2*t2
              t51 = 2.70777156307306d-4*gammaaa*t8+5.625d-3*gammaaa*t33*
     1           t34
              t52 = 1.0266346832644656d-5*gammaaa*t8+4.509905755707676d-
     1           6*t6*t7-9.012345679012345d-2*t23*t42*t51+1.441975308641
     2           9754d-1*t23*t50-1.802469135802469d-1*t17*t50+1.64553078
     3           46020564d-2*gammaaa*t2*t47+3.443772335859989d-3*gammaaa
     4           *t33*t34+1.6455307846020564d-2*t15*t2
              t53 = 1.2437810945273631d+0*t4*t52-5.074776173568845d-2*t2
     1           *t24*t45
              t54 = 1/taua**3
              t55 = 1.553671875d-3*gammaaa*t33*t35*t36*t9-4.97175d-2*t14
     1           *t34*t54*t7
              t56 = 1/rhoa**3.3333333333333337d+0
              t57 = 9.627632224259765d-3*t19*t56+8.7761641845443d-2*t18*
     1           t20
              t58 = 9.873184707612337d-2*t18*t22-2.25d-1*t20*t40*t57
              t59 = 5.069444444444443d-4*t23*t34*t42*t54*t7-3.4437723358
     1           59989d-3*t34*t54*t7+1.4419753086419754d-1*t23*t58-1.802
     2           469135802469d-1*t17*t58+1.6455307846020564d-2*gammaaa*t
     3           2*t55
              t60 = 1/rhoa**7.333333333333333d+0
              t61 = 1/rhoa**4.666666666666667d+0
              t62 = 1/rhoa**4
              t63 = gammaaa**4
              t64 = 1/taua**4
              t65 = 1/t13**4.0d+0
              t66 = t11**4.0d+0
              t67 = 1/t21**2.5d+0
              t68 = 4.8756467691912775d-1*t19*t31-1.4626940307573832d-1*
     1           gammaaa*t61
              t69 = -2.25d-1*t20*t40*(4.38808209227215d-2*t18*t19*t68-5.
     1           850776123029533d-2*gammaaa*t20*t61+2.194041046136075d-2
     2           *gammaaa*t31*t38-1.4626940307573832d-1*t19*t2*t38+1.950
     3           258707676511d-1*t19*t20*t31)+4.5d-1*t22*t68+3.375d-1*t2
     4           0*t39**2*t67+1.0726422892220812d-1*gammaaa*t61-4.5d-1*t
     5           38*t39*t40
              t70 = 1/t16**1.5d+0
              t71 = 1/t3**4.0d+0
              t72 = 1/t25**3
              t73 = 1/rhoa**5
              t74 = -2.25d-1*t20*t40*(5.214967454807371d-3*t19*t8-1.0970
     1           205230680374d-2*t2*t38+2.9253880615147665d-2*t20*t31-3.
     2           0086350700811765d-4*gammaaa*t30)+3.375d-1*t20*t39*t49*t
     3           67-2.25d-1*t38*t40*t49+6.170740442257711d-3*t2*t39*t40+
     4           3.2910615692041123d-2*t22*t31-2.925388061514767d-2*t31
              t75 = -1.3538857815365296d-4*t20*t40*t8+3.375d-1*t20*t49**
     1           2*t67+1.2341480884515421d-2*t2*t40*t49
              t76 = 1/taua**5
              t77 = -2.25d-1*t20*t40*(2.406908056064941d-3*gammaaa*t8-3.
     1           209210741419921d-2*t19*t48+8.7761641845443d-2*t18*t38-1
     2           .4626940307573832d-1*t2*t20)+3.375d-1*t20*t39*t57*t67-2
     3           .25d-1*t38*t40*t57-4.9365923538061685d-2*t18*t39*t40-1.
     4           6455307846020562d-1*t2*t22
              t78 = 3.375d-1*t20*t49*t57*t67+6.170740442257711d-3*t2*t40
     1           *t57-4.9365923538061685d-2*t18*t40*t49+1.08310862522922
     2           35d-3*t20*t40*t48
              t79 = 1/taua**6
              t80 = 3.375d-1*t20*t57**2*t67-9.873184707612337d-2*t18*t40
     1           *t57-8.664869001833788d-3*t20*t40*t56
              fnc(iq) = (-1.8610514726981994d+0*t1*t26-1.861051472698199
     1           4d+0*t1)*wght+fnc(iq)
              Amat(iq,D1_RA) = (-7.481426920246762d-1*t1*t28*t46-1.24070
     1           09817987995d+0*t26*t27-1.2407009817987995d+0*t27)*wght+
     2           Amat(iq,D1_RA)
              Cmat(iq,D1_GAA) = Cmat(iq,D1_GAA)-7.481426920246762d-1*t1*
     1           t28*t53*wght
              Cmat(iq,D1_GAB) = Cmat(iq,D1_GAB)
              Mmat(iq,D1_TA) = Mmat(iq,D1_TA)-9.305257363490997d-1*t1*t2
     1           8*t4*t59*wght
              Amat2(iq,D2_RA_RA) = (1.4962853840493523d+0*t1*t46**2*t72+
     1           t28*(-7.481426920246762d-1*t1*(2.208607571445859d-2*t24
     2           *t60*t7*t71+1.2437810945273631d+0*t4*(4.506172839506172
     3           3d-2*t23*t43**2*t70+1.6455307846020564d-2*gammaaa*t2*(1
     4           .4565673828125d-4*t33*t62*t65*t66*t7-4.6610156249999996
     5           d-3*t12*t33*t35*t62*t7+1.491525d-1*t14*t33*t62*t7-3.107
     6           34375d-3*t35*t63*t64/rhoa**6-3.10734375d-3*gammaaa*t10*
     7           t32*t35*t36)-9.012345679012345d-2*t23*t42*(1.6875d-2*t3
     8           3*t62*t7+4.573125306523389d-3*t60*t7)+1.033131700757996
     9           8d-2*t33*t62*t7+1.7338719095133195d-4*t60*t7+1.44197530
     :           86419754d-1*t23*t69-1.802469135802469d-1*t17*t69+1.6089
     ;           634338331218d-1*gammaaa*t15*t61+1.0823773813698423d-4*t
     <           5/rhoa**10-1.802469135802469d-1*t41*t42*t43+1.441975308
     =           6419754d-1*t41**2-8.776164184544301d-2*gammaaa*t31*t37)
     >           -4.9620033697117594d-1*gammaaa*t24*t45*t61+2.7065472925
     ?           700507d-1*gammaaa*t31*t44*t45)-1.9950471787324697d+0*t2
     @           7*t46)+(-4.1356699393293317d-1*t26-4.1356699393293317d-
     1           1)/rhoa**6.666666666666666d-1)*wght+Amat2(iq,D2_RA_RA)
              Amat2(iq,D2_RA_RB) = Amat2(iq,D2_RA_RB)
              Cmat2(iq,D2_RA_GAA) = (t28*(-7.481426920246762d-1*t1*(1.24
     1           37810945273631d+0*t4*(1.4419753086419754d-1*t23*t74-1.8
     2           02469135802469d-1*t17*t74+1.6455307846020564d-2*gammaaa
     3           *t2*(3.10734375d-3*t35*t5*t64*t73-1.4565673828125d-4*ga
     4           mmaaa*t32*t33*t65*t66+1.553671875d-3*t10*t34*t35*t36+4.
     5           6610156249999996d-3*gammaaa*t12*t32*t33*t35-9.9435d-2*g
     6           ammaaa*t14*t32*t33)+4.5061728395061723d-2*t23*t43*t51*t
     7           70-3.607924604566141d-5*t29*t7-9.012345679012345d-2*t41
     8           *t42*t51-9.012345679012345d-2*t42*t43*t50+1.44197530864
     9           19754d-1*t41*t50-4.3880820922721503d-2*gammaaa*t31*t47-
     :           9.012345679012345d-2*t23*(-1.1249999999999999d-2*gammaa
     ;           a*t32*t33-1.444144833638965d-3*gammaaa*t30)*t42+1.64553
     <           07846020564d-2*t2*t37-6.887544671719978d-3*gammaaa*t32*
     =           t33-4.3880820922721503d-2*t15*t31-5.475384977410482d-5*
     >           gammaaa*t30)-8.282278392921971d-3*gammaaa*t24*t30*t71+1
     ?           .3532736462850253d-1*gammaaa*t31*t45*t52-5.074776173568
     @           845d-2*t2*t44*t45+1.3532736462850253d-1*t24*t31*t45)-9.
     1           975235893662349d-1*t27*t53)+1.4962853840493523d+0*t1*t4
     2           6*t53*t72)*wght+Cmat2(iq,D2_RA_GAA)
              Cmat2(iq,D2_RA_GAB) = Cmat2(iq,D2_RA_GAB)
              Cmat2(iq,D2_RA_GBB) = Cmat2(iq,D2_RA_GBB)
              Cmat2(iq,D2_GAA_GAA) = -7.481426920246762d-1*t1*t28*(3.105
     1           85439734574d-3*t24*t71*t8+1.2437810945273631d+0*t4*(1.0
     2           266346832644656d-5*t8-9.012345679012345d-2*t23*t42*(2.7
     3           0777156307306d-4*t8+5.625d-3*t33*t34)+1.441975308641975
     4           4d-1*t23*t75-1.802469135802469d-1*t17*t75+4.50617283950
     5           61723d-2*t23*t51**2*t70+1.6455307846020564d-2*gammaaa*t
     6           2*(-3.10734375d-3*t35*t62*t64*t7+1.4565673828125d-4*t33
     7           *t34*t65*t66-4.6610156249999996d-3*t12*t33*t34*t35+4.97
     8           175d-2*t14*t33*t34)+9.019811511415352d-6*gammaaa*t6-1.8
     9           02469135802469d-1*t42*t50*t51+1.4419753086419754d-1*t50
     :           **2+3.291061569204113d-2*t2*t47+3.443772335859989d-3*t3
     ;           3*t34)-1.014955234713769d-1*t2*t45*t52)*wght+1.49628538
     <           40493523d+0*t1*t53**2*t72*wght+Cmat2(iq,D2_GAA_GAA)
              Cmat2(iq,D2_GAA_GAB) = Cmat2(iq,D2_GAA_GAB)
              Cmat2(iq,D2_GAA_GBB) = Cmat2(iq,D2_GAA_GBB)
              Cmat2(iq,D2_GAB_GAB) = Cmat2(iq,D2_GAB_GAB)
              Mmat2(iq,D2_RA_TA) = (-7.481426920246762d-1*t1*t28*(1.2437
     1           810945273631d+0*t4*(1.4419753086419754d-1*t23*t77-1.802
     2           469135802469d-1*t17*t77+1.6455307846020564d-2*gammaaa*t
     3           2*(-3.10734375d-3*t35*t63*t73*t76+1.4565673828125d-4*t3
     4           2*t54*t65*t66*t7-4.6610156249999996d-3*t12*t32*t35*t54*
     5           t7+9.9435d-2*t14*t32*t54*t7-1.553671875d-3*gammaaa*t33*
     6           t34*t35*t36)-2.5347222222222215d-4*t23*t34*t43*t54*t7*t
     7           70+5.069444444444443d-4*t34*t41*t42*t54*t7-1.0138888888
     8           888886d-3*t23*t32*t42*t54*t7+6.887544671719978d-3*t32*t
     9           54*t7-9.012345679012345d-2*t42*t43*t58+1.44197530864197
     :           54d-1*t41*t58-4.3880820922721503d-2*gammaaa*t31*t55)+1.
     ;           3532736462850253d-1*gammaaa*t31*t45*t59)+1.861051472698
     <           1991d+0*t1*t4*t46*t59*t72-1.2407009817987995d+0*t27*t28
     =           *t4*t59)*wght+Mmat2(iq,D2_RA_TA)
              Mmat2(iq,D2_RA_TB) = Mmat2(iq,D2_RA_TB)
              Mmat2(iq,D2_GAA_TA) = -7.481426920246762d-1*t1*t28*(1.2437
     1           810945273631d+0*t4*(1.6455307846020564d-2*gammaaa*t2*(1
     2           .553671875d-3*t33*t35*t36*t9+3.10734375d-3*t35*t5*t62*t
     3           76-1.4565673828125d-4*gammaaa*t34*t54*t65*t66+4.6610156
     4           249999996d-3*gammaaa*t12*t34*t35*t54-9.9435d-2*gammaaa*
     5           t14*t34*t54)+1.4419753086419754d-1*t23*t78-1.8024691358
     6           02469d-1*t17*t78-2.5347222222222215d-4*t23*t34*t51*t54*
     7           t7*t70+5.069444444444443d-4*t34*t42*t50*t54*t7-9.012345
     8           679012345d-2*t42*t51*t58+1.4419753086419754d-1*t50*t58+
     9           1.6455307846020564d-2*t2*t55+1.0138888888888886d-3*gamm
     :           aaa*t23*t34*t42*t54-6.887544671719978d-3*gammaaa*t34*t5
     ;           4)-5.074776173568845d-2*t2*t45*t59)*wght+1.861051472698
     <           1991d+0*t1*t4*t53*t59*t72*wght+Mmat2(iq,D2_GAA_TA)
              Mmat2(iq,D2_GAA_TB) = Mmat2(iq,D2_GAA_TB)
              Mmat2(iq,D2_GAB_TA) = Mmat2(iq,D2_GAB_TA)
              Mmat2(iq,D2_TA_TA) = -9.305257363490997d-1*t1*t28*t4*(1.64
     1           55307846020564d-2*gammaaa*t2*(-3.10734375d-3*gammaaa*t3
     2           5*t36*t54*t9-3.10734375d-3*t35*t62*t63*t79+1.4565673828
     3           125d-4*t34*t64*t65*t66*t7-4.6610156249999996d-3*t12*t34
     4           *t35*t64*t7+1.491525d-1*t14*t34*t64*t7)+1.4419753086419
     5           754d-1*t23*t80-1.802469135802469d-1*t17*t80+1.425781249
     6           9999994d-6*t23*t62*t63*t70*t79-1.520833333333333d-3*t23
     7           *t34*t42*t64*t7+1.0331317007579968d-2*t34*t64*t7+1.0138
     8           888888888886d-3*t34*t42*t54*t58*t7+1.4419753086419754d-
     9           1*t58**2)*wght+2.3147406376843277d+0*t1*t59**2*t71*t72*
     :           wght+Mmat2(iq,D2_TA_TA)
              Mmat2(iq,D2_TA_TB) = Mmat2(iq,D2_TA_TB)
            else 
              t1 = rhoa**1.3333333333333333d+0
              t2 = 1/rhoa**1.6666666666666669d+0
              t3 = 1.0970205230680374d-51*t2-1.0d+0
              t4 = 4.3880820922721503d-52*t2*t3+1.0d+0
              t5 = 1/t4**5.0d-1
              t6 = 4.5d-1*t3*t5+4.3880820922721503d-52*t2
              t7 = 1/rhoa**3.3333333333333337d+0
              t8 = 2.166217250458448d-103*t7+4.4999999999999996d-2
              t9 = t8**5.0d-1
              t10 = -1.802469135802469d-1*t6*t9+8.213077466115726d-105*t
     1           7+7.209876543209877d-2*t6**2+2.4881109353903252d-52*t2+
     2           9.621132278843042d-155/rhoa**5+2.755017868687991d-2
              t11 = 8.160240087098705d-52*t2+1.0d+0
              t12 = 1/t11**2.0d+0
              t13 = 1.2437810945273631d+0*t10*t12+1.0d+0
              t14 = 8.04d-1-8.04d-1/t13
              t15 = rhoa**3.333333333333333d-1
              t16 = 1/t13**2
              t17 = 1/rhoa**4.333333333333333d+0
              t18 = 1/t9
              t19 = 1/rhoa**2.6666666666666666d+0
              t20 = -7.313470153786917d-52*t19*t3-8.023026853549804d-103
     1           *t17
              t21 = 1/t4**1.5d+0
              t22 = -8.227653923010281d-52*t19*t5-2.25d-1*t20*t21*t3-7.3
     1           13470153786917d-52*t19
              t23 = -1.802469135802469d-1*t22*t9+1.4419753086419754d-1*t
     1           22*t6+6.507566225657065d-104*t17*t18*t6-4.1468515589838
     2           76d-52*t19-2.737692488705242d-104*t17-4.810566139421521
     3           d-154/rhoa**6
              t24 = 1/t11**3.0d+0
              t25 = 3.3831841157125636d-51*t10*t19*t24+1.243781094527363
     1           1d+0*t12*t23
              t26 = 1/rhoa**5.333333333333333d+0
              t27 = 1/rhoa**3.6666666666666664d+0
              t28 = 2.194041046136075d-51*t27*t5+3.375d-1*t20**2*t3/t4**
     1           2.5d+0-2.25d-1*t21*t3*(1.9502587076765113d-51*t27*t3+4.
     2           8138161121298817d-102*t26)+1.9502587076765113d-51*t27+8
     3           .227653923010281d-52*t19*t20*t21
              fnc(iq) = (-1.8610514726981994d+0*t1*t14-1.861051472698199
     1           4d+0*t1)*wght+fnc(iq)
              Amat(iq,D1_RA) = (-7.481426920246762d-1*t1*t16*t25-1.24070
     1           09817987995d+0*t14*t15-1.2407009817987995d+0*t15)*wght+
     2           Amat(iq,D1_RA)
              Cmat(iq,D1_GAA) = Cmat(iq,D1_GAA)
              Cmat(iq,D1_GAB) = Cmat(iq,D1_GAB)
              Mmat(iq,D1_TA) = Mmat(iq,D1_TA)
              Amat2(iq,D2_RA_RA) = (t16*(-7.481426920246762d-1*t1*(1.243
     1           7810945273631d+0*t12*(-1.802469135802469d-1*t28*t9+2.34
     2           9467036086518d-206*t6/(rhoa**8.666666666666666d+0*t8**1
     3           .5d+0)+1.4419753086419754d-1*t28*t6-2.8199453644513944d
     4           -103*t18*t26*t6+1.1058270823957002d-51*t27+1.1863334117
     5           722714d-103*t26+1.4419753086419754d-1*t22**2+1.30151324
     6           5131413d-103*t17*t18*t22+2.886339683652913d-153/rhoa**7
     7           )-9.021824308566837d-51*t10*t24*t27+1.3803797321536623d
     8           -101*t10*t26/t11**4.0d+0+6.766368231425127d-51*t19*t23*
     9           t24)-1.9950471787324697d+0*t15*t25)+1.4962853840493523d
     :           +0*t1*t25**2/t13**3+(-4.1356699393293317d-1*t14-4.13566
     ;           99393293317d-1)/rhoa**6.666666666666666d-1)*wght+Amat2(
     <           iq,D2_RA_RA)
              Amat2(iq,D2_RA_RB) = Amat2(iq,D2_RA_RB)
              Cmat2(iq,D2_RA_GAA) = Cmat2(iq,D2_RA_GAA)
              Cmat2(iq,D2_RA_GAB) = Cmat2(iq,D2_RA_GAB)
              Cmat2(iq,D2_RA_GBB) = Cmat2(iq,D2_RA_GBB)
              Cmat2(iq,D2_GAA_GAA) = Cmat2(iq,D2_GAA_GAA)
              Cmat2(iq,D2_GAA_GAB) = Cmat2(iq,D2_GAA_GAB)
              Cmat2(iq,D2_GAA_GBB) = Cmat2(iq,D2_GAA_GBB)
              Cmat2(iq,D2_GAB_GAB) = Cmat2(iq,D2_GAB_GAB)
              Mmat2(iq,D2_RA_TA) = Mmat2(iq,D2_RA_TA)
              Mmat2(iq,D2_RA_TB) = Mmat2(iq,D2_RA_TB)
              Mmat2(iq,D2_GAA_TA) = Mmat2(iq,D2_GAA_TA)
              Mmat2(iq,D2_GAA_TB) = Mmat2(iq,D2_GAA_TB)
              Mmat2(iq,D2_GAB_TA) = Mmat2(iq,D2_GAB_TA)
              Mmat2(iq,D2_TA_TA) = Mmat2(iq,D2_TA_TA)
              Mmat2(iq,D2_TA_TB) = Mmat2(iq,D2_TA_TB)
            endif 
          endif ! rhoa.gt.tol_rho 
        else  ! ipol.eq.1 
          rhoa    = rho(iq,R_A) 
          rhob    = rho(iq,R_B) 
          gammaaa = rgamma(iq,G_AA) 
          gammaab = rgamma(iq,G_AB) 
          gammabb = rgamma(iq,G_BB) 
          taua    = tau(iq,T_A) 
          taub    = tau(iq,T_B) 
          if (rhoa.gt.tol_rho.and.rhob.gt.tol_rho) then 
            if (taua.gt.tol_rho.and.taub.gt.tol_rho) then 
              t1 = rhoa**1.3333333333333333d+0
              t2 = rhob**1.3333333333333333d+0
              t3 = 1/rhoa**2.6666666666666666d+0
              t4 = 2.040060021774676d-2*gammaaa*t3+1.0d+0
              t5 = 1/t4**2.0d+0
              t6 = gammaaa**3
              t7 = 1/rhoa**8
              t8 = gammaaa**2
              t9 = 1/rhoa**5.333333333333333d+0
              t10 = 1/rhoa
              t11 = 1/taua
              t12 = gammaaa*t10*t11
              t13 = t12**2.0d+0
              t14 = 1.5625d-2*t13+1.0d+0
              t15 = 1/t14**2.0d+0
              t16 = 2.485875d-2*t13*t15+1.234567901234568d-1
              t17 = 1.35388578153653d-4*t8*t9+2.8125d-3*t13
              t18 = t17**5.0d-1
              t19 = 1/rhoa**1.6666666666666669d+0
              t20 = 2.0d+0*taua-2.5d-1*gammaaa*t10
              t21 = 1.0970205230680374d-1*t19*t20-1.0d+0
              t22 = 4.38808209227215d-2*t19*t20*t21+1.0d+0
              t23 = 1/t22**5.0d-1
              t24 = 1.0970205230680376d-2*gammaaa*t3+4.5d-1*t21*t23
              t25 = 5.133173416322327d-6*t8*t9+1.5033019185692253d-6*t6*
     1           t7+1.6455307846020564d-2*gammaaa*t16*t3+7.2098765432098
     2           77d-2*t24**2-1.802469135802469d-1*t18*t24+1.72188616792
     3           99946d-3*t13
              t26 = 1.2437810945273631d+0*t25*t5+1.0d+0
              t27 = 8.04d-1-8.04d-1/t26
              t28 = 1/rhob**2.6666666666666666d+0
              t29 = 2.040060021774676d-2*gammabb*t28+1.0d+0
              t30 = 1/t29**2.0d+0
              t31 = gammabb**3
              t32 = 1/rhob**8
              t33 = gammabb**2
              t34 = 1/rhob**5.333333333333333d+0
              t35 = 1/rhob
              t36 = 1/taub
              t37 = gammabb*t35*t36
              t38 = t37**2.0d+0
              t39 = 1.5625d-2*t38+1.0d+0
              t40 = 1/t39**2.0d+0
              t41 = 2.485875d-2*t38*t40+1.234567901234568d-1
              t42 = 2.8125d-3*t38+1.35388578153653d-4*t33*t34
              t43 = t42**5.0d-1
              t44 = 1/rhob**1.6666666666666669d+0
              t45 = 2.0d+0*taub-2.5d-1*gammabb*t35
              t46 = 1.0970205230680374d-1*t44*t45-1.0d+0
              t47 = 4.38808209227215d-2*t44*t45*t46+1.0d+0
              t48 = 1/t47**5.0d-1
              t49 = 4.5d-1*t46*t48+1.0970205230680376d-2*gammabb*t28
              t50 = 7.209876543209877d-2*t49**2-1.802469135802469d-1*t43
     1           *t49+1.6455307846020564d-2*gammabb*t28*t41+1.7218861679
     2           299946d-3*t38+5.133173416322327d-6*t33*t34+1.5033019185
     3           692253d-6*t31*t32
              t51 = 1.2437810945273631d+0*t30*t50+1.0d+0
              t52 = 8.04d-1-8.04d-1/t51
              t53 = rhoa**3.333333333333333d-1
              t54 = 1/t26**2
              t55 = 1/rhoa**9
              t56 = 1/rhoa**6.333333333333333d+0
              t57 = 1/rhoa**3.6666666666666664d+0
              t58 = 1/rhoa**3
              t59 = 1/taua**2
              t60 = 1/rhoa**2
              t61 = 1/t14**3.0d+0
              t62 = t12**3.0d+0
              t63 = 1.553671875d-3*gammaaa*t11*t60*t61*t62-4.97175d-2*t1
     1           5*t58*t59*t8
              t64 = 2.7425513076700936d-2*gammaaa*t57-1.828367538446729d
     1           -1*t20*t3
              t65 = 4.38808209227215d-2*t19*t20*t64+1.0970205230680374d-
     1           2*gammaaa*t21*t57-7.313470153786916d-2*t20*t21*t3
              t66 = 1/t22**1.5d+0
              t67 = -2.25d-1*t21*t65*t66+4.5d-1*t23*t64-2.92538806151476
     1           7d-2*gammaaa*t57
              t68 = 1/t18
              t69 = -5.625d-3*t58*t59*t8-7.220724168194825d-4*t56*t8
              t70 = -3.443772335859989d-3*t58*t59*t8-2.737692488705241d-
     1           5*t56*t8-9.012345679012345d-2*t24*t68*t69+1.44197530864
     2           19754d-1*t24*t67-1.802469135802469d-1*t18*t67+1.6455307
     3           846020564d-2*gammaaa*t3*t63-1.2026415348553804d-5*t55*t
     4           6-4.3880820922721503d-2*gammaaa*t16*t57
              t71 = 1/t4**3.0d+0
              t72 = 1.3532736462850253d-1*gammaaa*t25*t57*t71+1.24378109
     1           45273631d+0*t5*t70
              t73 = rhob**3.333333333333333d-1
              t74 = 1/t51**2
              t75 = 1/rhob**9
              t76 = 1/rhob**6.333333333333333d+0
              t77 = 1/rhob**3.6666666666666664d+0
              t78 = 1/rhob**3
              t79 = 1/taub**2
              t80 = 1/rhob**2
              t81 = 1/t39**3.0d+0
              t82 = t37**3.0d+0
              t83 = 1.553671875d-3*gammabb*t36*t80*t81*t82-4.97175d-2*t3
     1           3*t40*t78*t79
              t84 = 2.7425513076700936d-2*gammabb*t77-1.828367538446729d
     1           -1*t28*t45
              t85 = 4.38808209227215d-2*t44*t45*t84+1.0970205230680374d-
     1           2*gammabb*t46*t77-7.313470153786916d-2*t28*t45*t46
              t86 = 1/t47**1.5d+0
              t87 = -2.25d-1*t46*t85*t86+4.5d-1*t48*t84-2.92538806151476
     1           7d-2*gammabb*t77
              t88 = 1/t43
              t89 = -5.625d-3*t33*t78*t79-7.220724168194825d-4*t33*t76
              t90 = -9.012345679012345d-2*t49*t88*t89+1.4419753086419754
     1           d-1*t49*t87-1.802469135802469d-1*t43*t87+1.645530784602
     2           0564d-2*gammabb*t28*t83-3.443772335859989d-3*t33*t78*t7
     3           9-4.3880820922721503d-2*gammabb*t41*t77-2.7376924887052
     4           41d-5*t33*t76-1.2026415348553804d-5*t31*t75
              t91 = 1/t29**3.0d+0
              t92 = 1.3532736462850253d-1*gammabb*t50*t77*t91+1.24378109
     1           45273631d+0*t30*t90
              t93 = 4.97175d-2*gammaaa*t15*t59*t60-1.553671875d-3*t10*t1
     1           1*t61*t62
              t94 = 1/rhoa**4.333333333333333d+0
              t95 = -1.2034540280324706d-3*t20*t94-1.0970205230680374d-2
     1           *t21*t3
              t96 = -2.25d-1*t21*t66*t95-1.2341480884515421d-2*t23*t3+1.
     1           0970205230680376d-2*t3
              t97 = 2.70777156307306d-4*gammaaa*t9+5.625d-3*gammaaa*t59*
     1           t60
              t98 = -9.012345679012345d-2*t24*t68*t97+1.4419753086419754
     1           d-1*t24*t96-1.802469135802469d-1*t18*t96+1.645530784602
     2           0564d-2*gammaaa*t3*t93+1.0266346832644656d-5*gammaaa*t9
     3           +4.509905755707676d-6*t7*t8+3.443772335859989d-3*gammaa
     4           a*t59*t60+1.6455307846020564d-2*t16*t3
              t99 = 1.2437810945273631d+0*t5*t98-5.074776173568845d-2*t2
     1           5*t3*t71
              t100 = 4.97175d-2*gammabb*t40*t79*t80-1.553671875d-3*t35*t
     1           36*t81*t82
              t101 = 1/rhob**4.333333333333333d+0
              t102 = -1.0970205230680374d-2*t28*t46-1.2034540280324706d-
     1           3*t101*t45
              t103 = -2.25d-1*t102*t46*t86-1.2341480884515421d-2*t28*t48
     1           +1.0970205230680376d-2*t28
              t104 = 5.625d-3*gammabb*t79*t80+2.70777156307306d-4*gammab
     1           b*t34
              t105 = -9.012345679012345d-2*t104*t49*t88+3.44377233585998
     1           9d-3*gammabb*t79*t80+1.4419753086419754d-1*t103*t49-1.8
     2           02469135802469d-1*t103*t43+1.6455307846020564d-2*t28*t4
     3           1+1.0266346832644656d-5*gammabb*t34+4.509905755707676d-
     4           6*t32*t33+1.6455307846020564d-2*gammabb*t100*t28
              t106 = 1.2437810945273631d+0*t105*t30-5.074776173568845d-2
     1           *t28*t50*t91
              t107 = 1/taua**3
              t108 = 1.553671875d-3*gammaaa*t10*t59*t61*t62-4.97175d-2*t
     1           107*t15*t60*t8
              t109 = 1/rhoa**3.3333333333333337d+0
              t110 = 8.7761641845443d-2*t19*t21+9.627632224259765d-3*t10
     1           9*t20
              t111 = 9.873184707612337d-2*t19*t23-2.25d-1*t110*t21*t66
              t112 = 5.069444444444443d-4*t107*t24*t60*t68*t8-3.44377233
     1           5859989d-3*t107*t60*t8+1.6455307846020564d-2*gammaaa*t1
     2           08*t3+1.4419753086419754d-1*t111*t24-1.802469135802469d
     3           -1*t111*t18
              t113 = 1/taub**3
              t114 = 1.553671875d-3*gammabb*t35*t79*t81*t82-4.97175d-2*t
     1           113*t33*t40*t80
              t115 = 1/rhob**3.3333333333333337d+0
              t116 = 8.7761641845443d-2*t44*t46+9.627632224259765d-3*t11
     1           5*t45
              t117 = 9.873184707612337d-2*t44*t48-2.25d-1*t116*t46*t86
              t118 = 5.069444444444443d-4*t113*t33*t49*t80*t88-3.4437723
     1           35859989d-3*t113*t33*t80+1.4419753086419754d-1*t117*t49
     2           -1.802469135802469d-1*t117*t43+1.6455307846020564d-2*ga
     3           mmabb*t114*t28
              t119 = 1/rhoa**7.333333333333333d+0
              t120 = 1/rhoa**4.666666666666667d+0
              t121 = 1/rhoa**4
              t122 = gammaaa**4
              t123 = 1/taua**4
              t124 = 1/t14**4.0d+0
              t125 = t12**4.0d+0
              t126 = 1/t22**2.5d+0
              t127 = 4.8756467691912775d-1*t20*t57-1.4626940307573832d-1
     1           *gammaaa*t120
              t128 = -4.5d-1*t64*t65*t66-2.25d-1*t21*(2.194041046136075d
     1           -2*gammaaa*t57*t64-1.4626940307573832d-1*t20*t3*t64+1.9
     2           50258707676511d-1*t20*t21*t57-5.850776123029533d-2*gamm
     3           aaa*t120*t21+4.38808209227215d-2*t127*t19*t20)*t66+3.37
     4           5d-1*t126*t21*t65**2+4.5d-1*t127*t23+1.0726422892220812
     5           d-1*gammaaa*t120
              t129 = 1/t17**1.5d+0
              t130 = 1/t4**4.0d+0
              t131 = 1/t26**3
              t132 = 1/rhob**7.333333333333333d+0
              t133 = 1/rhob**4.666666666666667d+0
              t134 = 1/rhob**4
              t135 = gammabb**4
              t136 = 1/taub**4
              t137 = 1/t39**4.0d+0
              t138 = t37**4.0d+0
              t139 = 1/t47**2.5d+0
              t140 = 4.8756467691912775d-1*t45*t77-1.4626940307573832d-1
     1           *gammabb*t133
              t141 = -4.5d-1*t84*t85*t86-2.25d-1*t46*(2.194041046136075d
     1           -2*gammabb*t77*t84-1.4626940307573832d-1*t28*t45*t84+1.
     2           950258707676511d-1*t45*t46*t77-5.850776123029533d-2*gam
     3           mabb*t133*t46+4.38808209227215d-2*t140*t44*t45)*t86+3.3
     4           75d-1*t139*t46*t85**2+4.5d-1*t140*t48+1.072642289222081
     5           2d-1*gammabb*t133
              t142 = 1/t42**1.5d+0
              t143 = 1/t29**4.0d+0
              t144 = 1/t51**3
              t145 = 1/rhoa**5
              t146 = -2.25d-1*t64*t66*t95+3.375d-1*t126*t21*t65*t95-2.25
     1           d-1*t21*t66*(5.214967454807371d-3*t20*t9-1.097020523068
     2           0374d-2*t3*t64+2.9253880615147665d-2*t21*t57-3.00863507
     3           00811765d-4*gammaaa*t56)+6.170740442257711d-3*t3*t65*t6
     4           6+3.2910615692041123d-2*t23*t57-2.925388061514767d-2*t5
     5           7
              t147 = 1/rhob**5
              t148 = 6.170740442257711d-3*t28*t85*t86-2.25d-1*t46*(-1.09
     1           70205230680374d-2*t28*t84+2.9253880615147665d-2*t46*t77
     2           -3.0086350700811765d-4*gammabb*t76+5.214967454807371d-3
     3           *t34*t45)*t86-2.25d-1*t102*t84*t86+3.375d-1*t102*t139*t
     4           46*t85+3.2910615692041123d-2*t48*t77-2.925388061514767d
     5           -2*t77
              t149 = 3.375d-1*t126*t21*t95**2+1.2341480884515421d-2*t3*t
     1           66*t95-1.3538857815365296d-4*t21*t66*t9
              t150 = -1.3538857815365296d-4*t34*t46*t86+1.23414808845154
     1           21d-2*t102*t28*t86+3.375d-1*t102**2*t139*t46
              t151 = 1/taua**5
              t152 = -2.25d-1*t21*t66*(-3.209210741419921d-2*t20*t94+2.4
     1           06908056064941d-3*gammaaa*t9+8.7761641845443d-2*t19*t64
     2           -1.4626940307573832d-1*t21*t3)-4.9365923538061685d-2*t1
     3           9*t65*t66-2.25d-1*t110*t64*t66+3.375d-1*t110*t126*t21*t
     4           65-1.6455307846020562d-1*t23*t3
              t153 = 1/taub**5
              t154 = -4.9365923538061685d-2*t44*t85*t86-2.25d-1*t46*(8.7
     1           761641845443d-2*t44*t84-1.4626940307573832d-1*t28*t46-3
     2           .209210741419921d-2*t101*t45+2.406908056064941d-3*gamma
     3           bb*t34)*t86-2.25d-1*t116*t84*t86+3.375d-1*t116*t139*t46
     4           *t85-1.6455307846020562d-1*t28*t48
              t155 = -4.9365923538061685d-2*t19*t66*t95+3.375d-1*t110*t1
     1           26*t21*t95+1.0831086252292235d-3*t21*t66*t94+6.17074044
     2           2257711d-3*t110*t3*t66
              t156 = 1.0831086252292235d-3*t101*t46*t86-4.93659235380616
     1           85d-2*t102*t44*t86+6.170740442257711d-3*t116*t28*t86+3.
     2           375d-1*t102*t116*t139*t46
              t157 = 1/taua**6
              t158 = -8.664869001833788d-3*t109*t21*t66-9.87318470761233
     1           7d-2*t110*t19*t66+3.375d-1*t110**2*t126*t21
              t159 = 1/taub**6
              t160 = -8.664869001833788d-3*t115*t46*t86-9.87318470761233
     1           7d-2*t116*t44*t86+3.375d-1*t116**2*t139*t46
              fnc(iq) = (-9.305257363490997d-1*t2*t52-9.305257363490997d
     1           -1*t1*t27-9.305257363490997d-1*t2-9.305257363490997d-1*
     2           t1)*wght+fnc(iq)
              Amat(iq,D1_RA) = (-7.481426920246762d-1*t1*t54*t72-1.24070
     1           09817987995d+0*t27*t53-1.2407009817987995d+0*t53)*wght+
     2           Amat(iq,D1_RA)
              Amat(iq,D1_RB) = (-7.481426920246762d-1*t2*t74*t92-1.24070
     1           09817987995d+0*t52*t73-1.2407009817987995d+0*t73)*wght+
     2           Amat(iq,D1_RB)
              Cmat(iq,D1_GAA) = Cmat(iq,D1_GAA)-7.481426920246762d-1*t1*
     1           t54*t99*wght
              Cmat(iq,D1_GAB) = Cmat(iq,D1_GAB)
              Cmat(iq,D1_GBB) = Cmat(iq,D1_GBB)-7.481426920246762d-1*t10
     1           6*t2*t74*wght
              Mmat(iq,D1_TA) = Mmat(iq,D1_TA)-9.305257363490997d-1*t1*t1
     1           12*t5*t54*wght
              Mmat(iq,D1_TB) = Mmat(iq,D1_TB)-9.305257363490997d-1*t118*
     1           t2*t30*t74*wght
              Amat2(iq,D2_RA_RA) = (t54*(-7.481426920246762d-1*t1*(1.243
     1           7810945273631d+0*t5*(1.6455307846020564d-2*gammaaa*t3*(
     2           -4.6610156249999996d-3*t121*t13*t59*t61*t8+1.491525d-1*
     3           t121*t15*t59*t8+1.4565673828125d-4*t121*t124*t125*t59*t
     4           8-3.10734375d-3*gammaaa*t11*t58*t61*t62-3.10734375d-3*t
     5           122*t123*t61/rhoa**6)-9.012345679012345d-2*t24*t68*(1.6
     6           875d-2*t121*t59*t8+4.573125306523389d-3*t119*t8)+1.0331
     7           317007579968d-2*t121*t59*t8+1.7338719095133195d-4*t119*
     8           t8+4.5061728395061723d-2*t129*t24*t69**2-1.802469135802
     9           469d-1*t67*t68*t69+1.4419753086419754d-1*t67**2-8.77616
     :           4184544301d-2*gammaaa*t57*t63+1.0823773813698423d-4*t6/
     ;           rhoa**10+1.4419753086419754d-1*t128*t24-1.8024691358024
     <           69d-1*t128*t18+1.6089634338331218d-1*gammaaa*t120*t16)+
     =           2.208607571445859d-2*t119*t130*t25*t8+2.706547292570050
     >           7d-1*gammaaa*t57*t70*t71-4.9620033697117594d-1*gammaaa*
     ?           t120*t25*t71)-1.9950471787324697d+0*t53*t72)+1.49628538
     @           40493523d+0*t1*t131*t72**2+(-4.1356699393293317d-1*t27-
     1           4.1356699393293317d-1)/rhoa**6.666666666666666d-1)*wght
     2           +Amat2(iq,D2_RA_RA)
              Amat2(iq,D2_RA_RB) = Amat2(iq,D2_RA_RB)
              Amat2(iq,D2_RB_RB) = (1.4962853840493523d+0*t144*t2*t92**2
     1           +t74*(-1.9950471787324697d+0*t73*t92-7.481426920246762d
     2           -1*t2*(2.7065472925700507d-1*gammabb*t77*t90*t91-4.9620
     3           033697117594d-1*gammabb*t133*t50*t91+1.2437810945273631
     4           d+0*t30*(4.5061728395061723d-2*t142*t49*t89**2-1.802469
     5           135802469d-1*t87*t88*t89-9.012345679012345d-2*t49*(1.68
     6           75d-2*t134*t33*t79+4.573125306523389d-3*t132*t33)*t88+1
     7           .4419753086419754d-1*t87**2-8.776164184544301d-2*gammab
     8           b*t77*t83+1.6455307846020564d-2*gammabb*t28*(-3.1073437
     9           5d-3*gammabb*t36*t78*t81*t82-4.6610156249999996d-3*t134
     :           *t33*t38*t79*t81-3.10734375d-3*t135*t136*t81/rhob**6+1.
     ;           491525d-1*t134*t33*t40*t79+1.4565673828125d-4*t134*t137
     <           *t138*t33*t79)+1.0331317007579968d-2*t134*t33*t79+1.441
     =           9753086419754d-1*t141*t49-1.802469135802469d-1*t141*t43
     >           +1.6089634338331218d-1*gammabb*t133*t41+1.7338719095133
     ?           195d-4*t132*t33+1.0823773813698423d-4*t31/rhob**10)+2.2
     @           08607571445859d-2*t132*t143*t33*t50))+(-4.1356699393293
     1           317d-1*t52-4.1356699393293317d-1)/rhob**6.6666666666666
     2           66d-1)*wght+Amat2(iq,D2_RB_RB)
              Cmat2(iq,D2_RA_GAA) = (t54*(-9.975235893662349d-1*t53*t99-
     1           7.481426920246762d-1*t1*(1.3532736462850253d-1*gammaaa*
     2           t57*t71*t98+1.2437810945273631d+0*t5*(4.506172839506172
     3           3d-2*t129*t24*t69*t97-9.012345679012345d-2*t67*t68*t97-
     4           9.012345679012345d-2*t68*t69*t96+1.4419753086419754d-1*
     5           t67*t96-4.3880820922721503d-2*gammaaa*t57*t93-3.6079246
     6           04566141d-5*t55*t8-9.012345679012345d-2*t24*(-1.1249999
     7           999999999d-2*gammaaa*t58*t59-1.444144833638965d-3*gamma
     8           aa*t56)*t68+1.6455307846020564d-2*t3*t63+1.645530784602
     9           0564d-2*gammaaa*t3*(1.553671875d-3*t11*t60*t61*t62+3.10
     :           734375d-3*t123*t145*t6*t61+4.6610156249999996d-3*gammaa
     ;           a*t13*t58*t59*t61-9.9435d-2*gammaaa*t15*t58*t59-1.45656
     <           73828125d-4*gammaaa*t124*t125*t58*t59)-6.88754467171997
     =           8d-3*gammaaa*t58*t59-4.3880820922721503d-2*t16*t57-5.47
     >           5384977410482d-5*gammaaa*t56+1.4419753086419754d-1*t146
     ?           *t24-1.802469135802469d-1*t146*t18)-5.074776173568845d-
     @           2*t3*t70*t71+1.3532736462850253d-1*t25*t57*t71-8.282278
     1           392921971d-3*gammaaa*t130*t25*t56))+1.4962853840493523d
     2           +0*t1*t131*t72*t99)*wght+Cmat2(iq,D2_RA_GAA)
              Cmat2(iq,D2_RA_GAB) = Cmat2(iq,D2_RA_GAB)
              Cmat2(iq,D2_RA_GBB) = Cmat2(iq,D2_RA_GBB)
              Cmat2(iq,D2_RB_GAA) = Cmat2(iq,D2_RB_GAA)
              Cmat2(iq,D2_RB_GAB) = Cmat2(iq,D2_RB_GAB)
              Cmat2(iq,D2_RB_GBB) = (1.4962853840493523d+0*t106*t144*t2*
     1           t92+t74*(-7.481426920246762d-1*t2*(-5.074776173568845d-
     2           2*t28*t90*t91+1.3532736462850253d-1*t50*t77*t91+1.35327
     3           36462850253d-1*gammabb*t105*t77*t91+1.2437810945273631d
     4           +0*t30*(-9.012345679012345d-2*t103*t88*t89+4.5061728395
     5           061723d-2*t104*t142*t49*t89-9.012345679012345d-2*t104*t
     6           87*t88-9.012345679012345d-2*t49*(-1.1249999999999999d-2
     7           *gammabb*t78*t79-1.444144833638965d-3*gammabb*t76)*t88+
     8           1.4419753086419754d-1*t103*t87+1.6455307846020564d-2*t2
     9           8*t83+1.6455307846020564d-2*gammabb*t28*(1.553671875d-3
     :           *t36*t80*t81*t82+4.6610156249999996d-3*gammabb*t38*t78*
     ;           t79*t81+3.10734375d-3*t136*t147*t31*t81-9.9435d-2*gamma
     <           bb*t40*t78*t79-1.4565673828125d-4*gammabb*t137*t138*t78
     =           *t79)-6.887544671719978d-3*gammabb*t78*t79-4.3880820922
     >           721503d-2*t41*t77-4.3880820922721503d-2*gammabb*t100*t7
     ?           7-5.475384977410482d-5*gammabb*t76-3.607924604566141d-5
     @           *t33*t75+1.4419753086419754d-1*t148*t49-1.8024691358024
     1           69d-1*t148*t43)-8.282278392921971d-3*gammabb*t143*t50*t
     2           76)-9.975235893662349d-1*t106*t73))*wght+Cmat2(iq,D2_RB
     3           _GBB)
              Cmat2(iq,D2_GAA_GAA) = 1.4962853840493523d+0*t1*t131*t99**
     1           2*wght-7.481426920246762d-1*t1*t54*(-1.014955234713769d
     2           -1*t3*t71*t98+1.2437810945273631d+0*t5*(4.5061728395061
     3           723d-2*t129*t24*t97**2-1.802469135802469d-1*t68*t96*t97
     4           +1.4419753086419754d-1*t96**2+3.291061569204113d-2*t3*t
     5           93+1.0266346832644656d-5*t9-9.012345679012345d-2*t24*t6
     6           8*(2.70777156307306d-4*t9+5.625d-3*t59*t60)+1.645530784
     7           6020564d-2*gammaaa*t3*(-3.10734375d-3*t121*t123*t61*t8-
     8           4.6610156249999996d-3*t13*t59*t60*t61+4.97175d-2*t15*t5
     9           9*t60+1.4565673828125d-4*t124*t125*t59*t60)+9.019811511
     :           415352d-6*gammaaa*t7+3.443772335859989d-3*t59*t60+1.441
     ;           9753086419754d-1*t149*t24-1.802469135802469d-1*t149*t18
     <           )+3.10585439734574d-3*t130*t25*t9)*wght+Cmat2(iq,D2_GAA
     =           _GAA)
              Cmat2(iq,D2_GAA_GAB) = Cmat2(iq,D2_GAA_GAB)
              Cmat2(iq,D2_GAA_GBB) = Cmat2(iq,D2_GAA_GBB)
              Cmat2(iq,D2_GAB_GAB) = Cmat2(iq,D2_GAB_GAB)
              Cmat2(iq,D2_GAB_GBB) = Cmat2(iq,D2_GAB_GBB)
              Cmat2(iq,D2_GBB_GBB) = -7.481426920246762d-1*t2*t74*(-1.01
     1           4955234713769d-1*t105*t28*t91+1.2437810945273631d+0*t30
     2           *(-9.012345679012345d-2*t49*(5.625d-3*t79*t80+2.7077715
     3           6307306d-4*t34)*t88-1.802469135802469d-1*t103*t104*t88+
     4           1.6455307846020564d-2*gammabb*t28*(-4.6610156249999996d
     5           -3*t38*t79*t80*t81-3.10734375d-3*t134*t136*t33*t81+4.97
     6           175d-2*t40*t79*t80+1.4565673828125d-4*t137*t138*t79*t80
     7           )+3.443772335859989d-3*t79*t80+1.4419753086419754d-1*t1
     8           50*t49+4.5061728395061723d-2*t104**2*t142*t49-1.8024691
     9           35802469d-1*t150*t43+1.0266346832644656d-5*t34+9.019811
     :           511415352d-6*gammabb*t32+3.291061569204113d-2*t100*t28+
     ;           1.4419753086419754d-1*t103**2)+3.10585439734574d-3*t143
     <           *t34*t50)*wght+1.4962853840493523d+0*t106**2*t144*t2*wg
     =           ht+Cmat2(iq,D2_GBB_GBB)
              Mmat2(iq,D2_RA_TA) = (-7.481426920246762d-1*t1*t54*(1.2437
     1           810945273631d+0*t5*(1.6455307846020564d-2*gammaaa*t3*(-
     2           4.6610156249999996d-3*t107*t13*t58*t61*t8+9.9435d-2*t10
     3           7*t15*t58*t8+1.4565673828125d-4*t107*t124*t125*t58*t8-1
     4           .553671875d-3*gammaaa*t59*t60*t61*t62-3.10734375d-3*t12
     5           2*t145*t151*t61)-2.5347222222222215d-4*t107*t129*t24*t6
     6           0*t69*t8+5.069444444444443d-4*t107*t60*t67*t68*t8-1.013
     7           8888888888886d-3*t107*t24*t58*t68*t8+6.887544671719978d
     8           -3*t107*t58*t8-9.012345679012345d-2*t111*t68*t69+1.4419
     9           753086419754d-1*t111*t67-4.3880820922721503d-2*gammaaa*
     :           t108*t57+1.4419753086419754d-1*t152*t24-1.8024691358024
     ;           69d-1*t152*t18)+1.3532736462850253d-1*gammaaa*t112*t57*
     <           t71)+1.8610514726981991d+0*t1*t112*t131*t5*t72-1.240700
     =           9817987995d+0*t112*t5*t53*t54)*wght+Mmat2(iq,D2_RA_TA)
              Mmat2(iq,D2_RA_TB) = Mmat2(iq,D2_RA_TB)
              Mmat2(iq,D2_RB_TA) = Mmat2(iq,D2_RB_TA)
              Mmat2(iq,D2_RB_TB) = (1.8610514726981991d+0*t118*t144*t2*t
     1           30*t92-7.481426920246762d-1*t2*t74*(1.3532736462850253d
     2           -1*gammabb*t118*t77*t91+1.2437810945273631d+0*t30*(-9.0
     3           12345679012345d-2*t117*t88*t89-2.5347222222222215d-4*t1
     4           13*t142*t33*t49*t80*t89+5.069444444444443d-4*t113*t33*t
     5           80*t87*t88-1.0138888888888886d-3*t113*t33*t49*t78*t88+1
     6           .4419753086419754d-1*t117*t87+1.6455307846020564d-2*gam
     7           mabb*t28*(-1.553671875d-3*gammabb*t79*t80*t81*t82-4.661
     8           0156249999996d-3*t113*t33*t38*t78*t81-3.10734375d-3*t13
     9           5*t147*t153*t81+9.9435d-2*t113*t33*t40*t78+1.4565673828
     :           125d-4*t113*t137*t138*t33*t78)+6.887544671719978d-3*t11
     ;           3*t33*t78-4.3880820922721503d-2*gammabb*t114*t77+1.4419
     <           753086419754d-1*t154*t49-1.802469135802469d-1*t154*t43)
     =           )-1.2407009817987995d+0*t118*t30*t73*t74)*wght+Mmat2(iq
     >           ,D2_RB_TB)
              Mmat2(iq,D2_GAA_TA) = 1.8610514726981991d+0*t1*t112*t131*t
     1           5*t99*wght-7.481426920246762d-1*t1*t54*(1.2437810945273
     2           631d+0*t5*(-2.5347222222222215d-4*t107*t129*t24*t60*t8*
     3           t97-9.012345679012345d-2*t111*t68*t97+5.069444444444443
     4           d-4*t107*t60*t68*t8*t96+1.4419753086419754d-1*t111*t96+
     5           1.0138888888888886d-3*gammaaa*t107*t24*t60*t68+1.645530
     6           7846020564d-2*gammaaa*t3*(1.553671875d-3*t10*t59*t61*t6
     7           2+4.6610156249999996d-3*gammaaa*t107*t13*t60*t61+3.1073
     8           4375d-3*t121*t151*t6*t61-9.9435d-2*gammaaa*t107*t15*t60
     9           -1.4565673828125d-4*gammaaa*t107*t124*t125*t60)-6.88754
     :           4671719978d-3*gammaaa*t107*t60+1.6455307846020564d-2*t1
     ;           08*t3+1.4419753086419754d-1*t155*t24-1.802469135802469d
     <           -1*t155*t18)-5.074776173568845d-2*t112*t3*t71)*wght+Mma
     =           t2(iq,D2_GAA_TA)
              Mmat2(iq,D2_GAA_TB) = Mmat2(iq,D2_GAA_TB)
              Mmat2(iq,D2_GAB_TA) = Mmat2(iq,D2_GAB_TA)
              Mmat2(iq,D2_GAB_TB) = Mmat2(iq,D2_GAB_TB)
              Mmat2(iq,D2_GBB_TA) = Mmat2(iq,D2_GBB_TA)
              Mmat2(iq,D2_GBB_TB) = -7.481426920246762d-1*t2*t74*(1.2437
     1           810945273631d+0*t30*(1.0138888888888886d-3*gammabb*t113
     2           *t49*t80*t88+5.069444444444443d-4*t103*t113*t33*t80*t88
     3           -9.012345679012345d-2*t104*t117*t88+1.6455307846020564d
     4           -2*gammabb*t28*(1.553671875d-3*t35*t79*t81*t82+4.661015
     5           6249999996d-3*gammabb*t113*t38*t80*t81+3.10734375d-3*t1
     6           34*t153*t31*t81-9.9435d-2*gammabb*t113*t40*t80-1.456567
     7           3828125d-4*gammabb*t113*t137*t138*t80)-2.53472222222222
     8           15d-4*t104*t113*t142*t33*t49*t80-6.887544671719978d-3*g
     9           ammabb*t113*t80+1.4419753086419754d-1*t156*t49-1.802469
     :           135802469d-1*t156*t43+1.6455307846020564d-2*t114*t28+1.
     ;           4419753086419754d-1*t103*t117)-5.074776173568845d-2*t11
     <           8*t28*t91)*wght+1.8610514726981991d+0*t106*t118*t144*t2
     =           *t30*wght+Mmat2(iq,D2_GBB_TB)
              Mmat2(iq,D2_TA_TA) = -9.305257363490997d-1*t1*t5*t54*(1.64
     1           55307846020564d-2*gammaaa*t3*(-4.6610156249999996d-3*t1
     2           23*t13*t60*t61*t8+1.491525d-1*t123*t15*t60*t8+1.4565673
     3           828125d-4*t123*t124*t125*t60*t8-3.10734375d-3*gammaaa*t
     4           10*t107*t61*t62-3.10734375d-3*t121*t122*t157*t61)-1.520
     5           833333333333d-3*t123*t24*t60*t68*t8+1.0138888888888886d
     6           -3*t107*t111*t60*t68*t8+1.0331317007579968d-2*t123*t60*
     7           t8+1.4419753086419754d-1*t158*t24+1.4257812499999994d-6
     8           *t121*t122*t129*t157*t24-1.802469135802469d-1*t158*t18+
     9           1.4419753086419754d-1*t111**2)*wght+2.3147406376843277d
     :           +0*t1*t112**2*t130*t131*wght+Mmat2(iq,D2_TA_TA)
              Mmat2(iq,D2_TA_TB) = Mmat2(iq,D2_TA_TB)
              Mmat2(iq,D2_TB_TB) = -9.305257363490997d-1*t2*t30*t74*(-1.
     1           520833333333333d-3*t136*t33*t49*t80*t88+1.0138888888888
     2           886d-3*t113*t117*t33*t80*t88+1.6455307846020564d-2*gamm
     3           abb*t28*(-3.10734375d-3*gammabb*t113*t35*t81*t82-4.6610
     4           156249999996d-3*t136*t33*t38*t80*t81-3.10734375d-3*t134
     5           *t135*t159*t81+1.491525d-1*t136*t33*t40*t80+1.456567382
     6           8125d-4*t136*t137*t138*t33*t80)+1.0331317007579968d-2*t
     7           136*t33*t80+1.4419753086419754d-1*t160*t49+1.4257812499
     8           999994d-6*t134*t135*t142*t159*t49-1.802469135802469d-1*
     9           t160*t43+1.4419753086419754d-1*t117**2)*wght+2.31474063
     :           76843277d+0*t118**2*t143*t144*t2*wght+Mmat2(iq,D2_TB_TB
     ;           )
            elseif (taua.gt.tol_rho.and.taub.le.tol_rho) then 
              t1 = rhoa**1.3333333333333333d+0
              t2 = rhob**1.3333333333333333d+0
              t3 = 1/rhob**1.6666666666666669d+0
              t4 = 1.0970205230680374d-51*t3-1.0d+0
              t5 = 4.3880820922721503d-52*t3*t4+1.0d+0
              t6 = 1/t5**5.0d-1
              t7 = 4.5d-1*t4*t6+4.3880820922721503d-52*t3
              t8 = 1/rhob**3.3333333333333337d+0
              t9 = 2.166217250458448d-103*t8+4.4999999999999996d-2
              t10 = t9**5.0d-1
              t11 = 8.213077466115726d-105*t8+7.209876543209877d-2*t7**2
     1           -1.802469135802469d-1*t10*t7+2.4881109353903252d-52*t3+
     2           9.621132278843042d-155/rhob**5+2.755017868687991d-2
              t12 = 8.160240087098705d-52*t3+1.0d+0
              t13 = 1/t12**2.0d+0
              t14 = 1.2437810945273631d+0*t11*t13+1.0d+0
              t15 = 8.04d-1-8.04d-1/t14
              t16 = 1/rhoa**2.6666666666666666d+0
              t17 = 2.040060021774676d-2*gammaaa*t16+1.0d+0
              t18 = 1/t17**2.0d+0
              t19 = gammaaa**3
              t20 = 1/rhoa**8
              t21 = gammaaa**2
              t22 = 1/rhoa**5.333333333333333d+0
              t23 = 1/rhoa
              t24 = 1/taua
              t25 = gammaaa*t23*t24
              t26 = t25**2.0d+0
              t27 = 1.5625d-2*t26+1.0d+0
              t28 = 1/t27**2.0d+0
              t29 = 2.485875d-2*t26*t28+1.234567901234568d-1
              t30 = 2.8125d-3*t26+1.35388578153653d-4*t21*t22
              t31 = t30**5.0d-1
              t32 = 1/rhoa**1.6666666666666669d+0
              t33 = 2.0d+0*taua-2.5d-1*gammaaa*t23
              t34 = 1.0970205230680374d-1*t32*t33-1.0d+0
              t35 = 4.38808209227215d-2*t32*t33*t34+1.0d+0
              t36 = 1/t35**5.0d-1
              t37 = 4.5d-1*t34*t36+1.0970205230680376d-2*gammaaa*t16
              t38 = 7.209876543209877d-2*t37**2-1.802469135802469d-1*t31
     1           *t37+1.6455307846020564d-2*gammaaa*t16*t29+1.7218861679
     2           299946d-3*t26+5.133173416322327d-6*t21*t22+1.5033019185
     3           692253d-6*t19*t20
              t39 = 1.2437810945273631d+0*t18*t38+1.0d+0
              t40 = 8.04d-1-8.04d-1/t39
              t41 = rhoa**3.333333333333333d-1
              t42 = 1/t39**2
              t43 = 1/rhoa**9
              t44 = 1/rhoa**6.333333333333333d+0
              t45 = 1/rhoa**3.6666666666666664d+0
              t46 = 1/rhoa**3
              t47 = 1/taua**2
              t48 = 1/rhoa**2
              t49 = 1/t27**3.0d+0
              t50 = t25**3.0d+0
              t51 = 1.553671875d-3*gammaaa*t24*t48*t49*t50-4.97175d-2*t2
     1           1*t28*t46*t47
              t52 = 2.7425513076700936d-2*gammaaa*t45-1.828367538446729d
     1           -1*t16*t33
              t53 = 4.38808209227215d-2*t32*t33*t52+1.0970205230680374d-
     1           2*gammaaa*t34*t45-7.313470153786916d-2*t16*t33*t34
              t54 = 1/t35**1.5d+0
              t55 = -2.25d-1*t34*t53*t54+4.5d-1*t36*t52-2.92538806151476
     1           7d-2*gammaaa*t45
              t56 = 1/t31
              t57 = -5.625d-3*t21*t46*t47-7.220724168194825d-4*t21*t44
              t58 = -9.012345679012345d-2*t37*t56*t57+1.4419753086419754
     1           d-1*t37*t55-1.802469135802469d-1*t31*t55+1.645530784602
     2           0564d-2*gammaaa*t16*t51-3.443772335859989d-3*t21*t46*t4
     3           7-4.3880820922721503d-2*gammaaa*t29*t45-2.7376924887052
     4           41d-5*t21*t44-1.2026415348553804d-5*t19*t43
              t59 = 1/t17**3.0d+0
              t60 = 1.3532736462850253d-1*gammaaa*t38*t45*t59+1.24378109
     1           45273631d+0*t18*t58
              t61 = rhob**3.333333333333333d-1
              t62 = 1/t14**2
              t63 = 1/rhob**4.333333333333333d+0
              t64 = 1/t10
              t65 = 1/rhob**2.6666666666666666d+0
              t66 = -7.313470153786917d-52*t4*t65-8.023026853549804d-103
     1           *t63
              t67 = 1/t5**1.5d+0
              t68 = -2.25d-1*t4*t66*t67-8.227653923010281d-52*t6*t65-7.3
     1           13470153786917d-52*t65
              t69 = 1.4419753086419754d-1*t68*t7+6.507566225657065d-104*
     1           t63*t64*t7-1.802469135802469d-1*t10*t68-4.1468515589838
     2           76d-52*t65-2.737692488705242d-104*t63-4.810566139421521
     3           d-154/rhob**6
              t70 = 1/t12**3.0d+0
              t71 = 3.3831841157125636d-51*t11*t65*t70+1.243781094527363
     1           1d+0*t13*t69
              t72 = 4.97175d-2*gammaaa*t28*t47*t48-1.553671875d-3*t23*t2
     1           4*t49*t50
              t73 = 1/rhoa**4.333333333333333d+0
              t74 = -1.2034540280324706d-3*t33*t73-1.0970205230680374d-2
     1           *t16*t34
              t75 = -2.25d-1*t34*t54*t74-1.2341480884515421d-2*t16*t36+1
     1           .0970205230680376d-2*t16
              t76 = 5.625d-3*gammaaa*t47*t48+2.70777156307306d-4*gammaaa
     1           *t22
              t77 = -9.012345679012345d-2*t37*t56*t76+1.4419753086419754
     1           d-1*t37*t75-1.802469135802469d-1*t31*t75+1.645530784602
     2           0564d-2*gammaaa*t16*t72+3.443772335859989d-3*gammaaa*t4
     3           7*t48+1.6455307846020564d-2*t16*t29+1.0266346832644656d
     4           -5*gammaaa*t22+4.509905755707676d-6*t20*t21
              t78 = 1.2437810945273631d+0*t18*t77-5.074776173568845d-2*t
     1           16*t38*t59
              t79 = 1/taua**3
              t80 = 1.553671875d-3*gammaaa*t23*t47*t49*t50-4.97175d-2*t2
     1           1*t28*t48*t79
              t81 = 1/rhoa**3.3333333333333337d+0
              t82 = 9.627632224259765d-3*t33*t81+8.7761641845443d-2*t32*
     1           t34
              t83 = 9.873184707612337d-2*t32*t36-2.25d-1*t34*t54*t82
              t84 = 1.4419753086419754d-1*t37*t83-1.802469135802469d-1*t
     1           31*t83+1.6455307846020564d-2*gammaaa*t16*t80+5.06944444
     2           4444443d-4*t21*t37*t48*t56*t79-3.443772335859989d-3*t21
     3           *t48*t79
              t85 = 1/rhoa**7.333333333333333d+0
              t86 = 1/rhoa**4.666666666666667d+0
              t87 = 1/rhoa**4
              t88 = gammaaa**4
              t89 = 1/taua**4
              t90 = 1/t27**4.0d+0
              t91 = t25**4.0d+0
              t92 = 1/t35**2.5d+0
              t93 = 4.8756467691912775d-1*t33*t45-1.4626940307573832d-1*
     1           gammaaa*t86
              t94 = -2.25d-1*t34*t54*(4.38808209227215d-2*t32*t33*t93-5.
     1           850776123029533d-2*gammaaa*t34*t86+2.194041046136075d-2
     2           *gammaaa*t45*t52-1.4626940307573832d-1*t16*t33*t52+1.95
     3           0258707676511d-1*t33*t34*t45)+4.5d-1*t36*t93+3.375d-1*t
     4           34*t53**2*t92+1.0726422892220812d-1*gammaaa*t86-4.5d-1*
     5           t52*t53*t54
              t95 = 1/t30**1.5d+0
              t96 = 1/t17**4.0d+0
              t97 = 1/t39**3
              t98 = 1/rhob**5.333333333333333d+0
              t99 = 1/rhob**3.6666666666666664d+0
              t100 = -2.25d-1*t4*t67*(1.9502587076765113d-51*t4*t99+4.81
     1           38161121298817d-102*t98)+2.194041046136075d-51*t6*t99+1
     2           .9502587076765113d-51*t99+8.227653923010281d-52*t65*t66
     3           *t67+3.375d-1*t4*t66**2/t5**2.5d+0
              t101 = 1/rhoa**5
              t102 = 3.375d-1*t34*t53*t74*t92-2.25d-1*t52*t54*t74+6.1707
     1           40442257711d-3*t16*t53*t54-2.25d-1*t34*(-1.097020523068
     2           0374d-2*t16*t52+2.9253880615147665d-2*t34*t45-3.0086350
     3           700811765d-4*gammaaa*t44+5.214967454807371d-3*t22*t33)*
     4           t54+3.2910615692041123d-2*t36*t45-2.925388061514767d-2*
     5           t45
              t103 = 3.375d-1*t34*t74**2*t92+1.2341480884515421d-2*t16*t
     1           54*t74-1.3538857815365296d-4*t22*t34*t54
              t104 = 1/taua**5
              t105 = 3.375d-1*t34*t53*t82*t92-2.25d-1*t52*t54*t82-2.25d-
     1           1*t34*t54*(-3.209210741419921d-2*t33*t73+8.776164184544
     2           3d-2*t32*t52-1.4626940307573832d-1*t16*t34+2.4069080560
     3           64941d-3*gammaaa*t22)-4.9365923538061685d-2*t32*t53*t54
     4           -1.6455307846020562d-1*t16*t36
              t106 = 3.375d-1*t34*t74*t82*t92+6.170740442257711d-3*t16*t
     1           54*t82-4.9365923538061685d-2*t32*t54*t74+1.083108625229
     2           2235d-3*t34*t54*t73
              t107 = 1/taua**6
              t108 = 3.375d-1*t34*t82**2*t92-9.873184707612337d-2*t32*t5
     1           4*t82-8.664869001833788d-3*t34*t54*t81
              fnc(iq) = (-9.305257363490997d-1*t1*t40-9.305257363490997d
     1           -1*t15*t2-9.305257363490997d-1*t2-9.305257363490997d-1*
     2           t1)*wght+fnc(iq)
              Amat(iq,D1_RA) = (-7.481426920246762d-1*t1*t42*t60-1.24070
     1           09817987995d+0*t40*t41-1.2407009817987995d+0*t41)*wght+
     2           Amat(iq,D1_RA)
              Amat(iq,D1_RB) = (-7.481426920246762d-1*t2*t62*t71-1.24070
     1           09817987995d+0*t15*t61-1.2407009817987995d+0*t61)*wght+
     2           Amat(iq,D1_RB)
              Cmat(iq,D1_GAA) = Cmat(iq,D1_GAA)-7.481426920246762d-1*t1*
     1           t42*t78*wght
              Cmat(iq,D1_GAB) = Cmat(iq,D1_GAB)
              Cmat(iq,D1_GBB) = Cmat(iq,D1_GBB)
              Mmat(iq,D1_TA) = Mmat(iq,D1_TA)-9.305257363490997d-1*t1*t1
     1           8*t42*t84*wght
              Mmat(iq,D1_TB) = Mmat(iq,D1_TB)
              Amat2(iq,D2_RA_RA) = (1.4962853840493523d+0*t1*t60**2*t97+
     1           t42*(-7.481426920246762d-1*t1*(2.208607571445859d-2*t21
     2           *t38*t85*t96+1.2437810945273631d+0*t18*(4.5061728395061
     3           723d-2*t37*t57**2*t95+1.4419753086419754d-1*t37*t94-1.8
     4           02469135802469d-1*t31*t94+1.6455307846020564d-2*gammaaa
     5           *t16*(1.4565673828125d-4*t21*t47*t87*t90*t91-3.10734375
     6           d-3*t49*t88*t89/rhoa**6-4.6610156249999996d-3*t21*t26*t
     7           47*t49*t87+1.491525d-1*t21*t28*t47*t87-3.10734375d-3*ga
     8           mmaaa*t24*t46*t49*t50)-9.012345679012345d-2*t37*t56*(1.
     9           6875d-2*t21*t47*t87+4.573125306523389d-3*t21*t85)+1.033
     :           1317007579968d-2*t21*t47*t87+1.6089634338331218d-1*gamm
     ;           aaa*t29*t86+1.7338719095133195d-4*t21*t85-1.80246913580
     <           2469d-1*t55*t56*t57+1.4419753086419754d-1*t55**2-8.7761
     =           64184544301d-2*gammaaa*t45*t51+1.0823773813698423d-4*t1
     >           9/rhoa**10)-4.9620033697117594d-1*gammaaa*t38*t59*t86+2
     ?           .7065472925700507d-1*gammaaa*t45*t58*t59)-1.99504717873
     @           24697d+0*t41*t60)+(-4.1356699393293317d-1*t40-4.1356699
     1           393293317d-1)/rhoa**6.666666666666666d-1)*wght+Amat2(iq
     2           ,D2_RA_RA)
              Amat2(iq,D2_RA_RB) = Amat2(iq,D2_RA_RB)
              Amat2(iq,D2_RB_RB) = (t62*(-7.481426920246762d-1*t2*(-9.02
     1           1824308566837d-51*t11*t70*t99+1.2437810945273631d+0*t13
     2           *(1.1058270823957002d-51*t99-2.8199453644513944d-103*t6
     3           4*t7*t98+1.1863334117722714d-103*t98+2.349467036086518d
     4           -206*t7/(rhob**8.666666666666666d+0*t9**1.5d+0)+1.44197
     5           53086419754d-1*t100*t7+1.4419753086419754d-1*t68**2+1.3
     6           01513245131413d-103*t63*t64*t68-1.802469135802469d-1*t1
     7           0*t100+2.886339683652913d-153/rhob**7)+1.38037973215366
     8           23d-101*t11*t98/t12**4.0d+0+6.766368231425127d-51*t65*t
     9           69*t70)-1.9950471787324697d+0*t61*t71)+1.49628538404935
     :           23d+0*t2*t71**2/t14**3+(-4.1356699393293317d-1*t15-4.13
     ;           56699393293317d-1)/rhob**6.666666666666666d-1)*wght+Ama
     <           t2(iq,D2_RB_RB)
              Cmat2(iq,D2_RA_GAA) = (1.4962853840493523d+0*t1*t60*t78*t9
     1           7+t42*(-7.481426920246762d-1*t1*(-8.282278392921971d-3*
     2           gammaaa*t38*t44*t96+1.2437810945273631d+0*t18*(4.506172
     3           8395061723d-2*t37*t57*t76*t95+1.6455307846020564d-2*gam
     4           maaa*t16*(-1.4565673828125d-4*gammaaa*t46*t47*t90*t91+3
     5           .10734375d-3*t101*t19*t49*t89+1.553671875d-3*t24*t48*t4
     6           9*t50+4.6610156249999996d-3*gammaaa*t26*t46*t47*t49-9.9
     7           435d-2*gammaaa*t28*t46*t47)-9.012345679012345d-2*t55*t5
     8           6*t76-9.012345679012345d-2*t56*t57*t75+1.44197530864197
     9           54d-1*t55*t75-4.3880820922721503d-2*gammaaa*t45*t72-9.0
     :           12345679012345d-2*t37*(-1.1249999999999999d-2*gammaaa*t
     ;           46*t47-1.444144833638965d-3*gammaaa*t44)*t56+1.64553078
     <           46020564d-2*t16*t51-6.887544671719978d-3*gammaaa*t46*t4
     =           7-4.3880820922721503d-2*t29*t45-5.475384977410482d-5*ga
     >           mmaaa*t44-3.607924604566141d-5*t21*t43+1.44197530864197
     ?           54d-1*t102*t37-1.802469135802469d-1*t102*t31)+1.3532736
     @           462850253d-1*gammaaa*t45*t59*t77-5.074776173568845d-2*t
     1           16*t58*t59+1.3532736462850253d-1*t38*t45*t59)-9.9752358
     2           93662349d-1*t41*t78))*wght+Cmat2(iq,D2_RA_GAA)
              Cmat2(iq,D2_RA_GAB) = Cmat2(iq,D2_RA_GAB)
              Cmat2(iq,D2_RA_GBB) = Cmat2(iq,D2_RA_GBB)
              Cmat2(iq,D2_RB_GAA) = Cmat2(iq,D2_RB_GAA)
              Cmat2(iq,D2_RB_GAB) = Cmat2(iq,D2_RB_GAB)
              Cmat2(iq,D2_RB_GBB) = Cmat2(iq,D2_RB_GBB)
              Cmat2(iq,D2_GAA_GAA) = 1.4962853840493523d+0*t1*t78**2*t97
     1           *wght-7.481426920246762d-1*t1*t42*(3.10585439734574d-3*
     2           t22*t38*t96+1.2437810945273631d+0*t18*(4.50617283950617
     3           23d-2*t37*t76**2*t95+1.6455307846020564d-2*gammaaa*t16*
     4           (1.4565673828125d-4*t47*t48*t90*t91-3.10734375d-3*t21*t
     5           49*t87*t89-4.6610156249999996d-3*t26*t47*t48*t49+4.9717
     6           5d-2*t28*t47*t48)-1.802469135802469d-1*t56*t75*t76+1.44
     7           19753086419754d-1*t75**2+3.291061569204113d-2*t16*t72-9
     8           .012345679012345d-2*t37*(5.625d-3*t47*t48+2.70777156307
     9           306d-4*t22)*t56+3.443772335859989d-3*t47*t48+1.44197530
     :           86419754d-1*t103*t37-1.802469135802469d-1*t103*t31+1.02
     ;           66346832644656d-5*t22+9.019811511415352d-6*gammaaa*t20)
     <           -1.014955234713769d-1*t16*t59*t77)*wght+Cmat2(iq,D2_GAA
     =           _GAA)
              Cmat2(iq,D2_GAA_GAB) = Cmat2(iq,D2_GAA_GAB)
              Cmat2(iq,D2_GAA_GBB) = Cmat2(iq,D2_GAA_GBB)
              Cmat2(iq,D2_GAB_GAB) = Cmat2(iq,D2_GAB_GAB)
              Cmat2(iq,D2_GAB_GBB) = Cmat2(iq,D2_GAB_GBB)
              Cmat2(iq,D2_GBB_GBB) = Cmat2(iq,D2_GBB_GBB)
              Mmat2(iq,D2_RA_TA) = (1.8610514726981991d+0*t1*t18*t60*t84
     1           *t97-7.481426920246762d-1*t1*t42*(1.2437810945273631d+0
     2           *t18*(-2.5347222222222215d-4*t21*t37*t48*t57*t79*t95+1.
     3           6455307846020564d-2*gammaaa*t16*(1.4565673828125d-4*t21
     4           *t46*t79*t90*t91-3.10734375d-3*t101*t104*t49*t88-4.6610
     5           156249999996d-3*t21*t26*t46*t49*t79+9.9435d-2*t21*t28*t
     6           46*t79-1.553671875d-3*gammaaa*t47*t48*t49*t50)-9.012345
     7           679012345d-2*t56*t57*t83+1.4419753086419754d-1*t55*t83-
     8           4.3880820922721503d-2*gammaaa*t45*t80+5.069444444444443
     9           d-4*t21*t48*t55*t56*t79-1.0138888888888886d-3*t21*t37*t
     :           46*t56*t79+6.887544671719978d-3*t21*t46*t79+1.441975308
     ;           6419754d-1*t105*t37-1.802469135802469d-1*t105*t31)+1.35
     <           32736462850253d-1*gammaaa*t45*t59*t84)-1.24070098179879
     =           95d+0*t18*t41*t42*t84)*wght+Mmat2(iq,D2_RA_TA)
              Mmat2(iq,D2_RA_TB) = Mmat2(iq,D2_RA_TB)
              Mmat2(iq,D2_RB_TA) = Mmat2(iq,D2_RB_TA)
              Mmat2(iq,D2_RB_TB) = Mmat2(iq,D2_RB_TB)
              Mmat2(iq,D2_GAA_TA) = 1.8610514726981991d+0*t1*t18*t78*t84
     1           *t97*wght-7.481426920246762d-1*t1*t42*(1.24378109452736
     2           31d+0*t18*(-2.5347222222222215d-4*t21*t37*t48*t76*t79*t
     3           95+1.6455307846020564d-2*gammaaa*t16*(-1.4565673828125d
     4           -4*gammaaa*t48*t79*t90*t91+3.10734375d-3*t104*t19*t49*t
     5           87+4.6610156249999996d-3*gammaaa*t26*t48*t49*t79-9.9435
     6           d-2*gammaaa*t28*t48*t79+1.553671875d-3*t23*t47*t49*t50)
     7           -9.012345679012345d-2*t56*t76*t83+1.4419753086419754d-1
     8           *t75*t83+1.6455307846020564d-2*t16*t80+5.06944444444444
     9           3d-4*t21*t48*t56*t75*t79+1.0138888888888886d-3*gammaaa*
     :           t37*t48*t56*t79-6.887544671719978d-3*gammaaa*t48*t79+1.
     ;           4419753086419754d-1*t106*t37-1.802469135802469d-1*t106*
     <           t31)-5.074776173568845d-2*t16*t59*t84)*wght+Mmat2(iq,D2
     =           _GAA_TA)
              Mmat2(iq,D2_GAA_TB) = Mmat2(iq,D2_GAA_TB)
              Mmat2(iq,D2_GAB_TA) = Mmat2(iq,D2_GAB_TA)
              Mmat2(iq,D2_GAB_TB) = Mmat2(iq,D2_GAB_TB)
              Mmat2(iq,D2_GBB_TA) = Mmat2(iq,D2_GBB_TA)
              Mmat2(iq,D2_GBB_TB) = Mmat2(iq,D2_GBB_TB)
              Mmat2(iq,D2_TA_TA) = 2.3147406376843277d+0*t1*t84**2*t96*t
     1           97*wght-9.305257363490997d-1*t1*t18*t42*(1.425781249999
     2           9994d-6*t107*t37*t87*t88*t95+1.6455307846020564d-2*gamm
     3           aaa*t16*(1.4565673828125d-4*t21*t48*t89*t90*t91-4.66101
     4           56249999996d-3*t21*t26*t48*t49*t89+1.491525d-1*t21*t28*
     5           t48*t89-3.10734375d-3*t107*t49*t87*t88-3.10734375d-3*ga
     6           mmaaa*t23*t49*t50*t79)-1.520833333333333d-3*t21*t37*t48
     7           *t56*t89+1.0331317007579968d-2*t21*t48*t89+1.4419753086
     8           419754d-1*t83**2+1.0138888888888886d-3*t21*t48*t56*t79*
     9           t83+1.4419753086419754d-1*t108*t37-1.802469135802469d-1
     :           *t108*t31)*wght+Mmat2(iq,D2_TA_TA)
              Mmat2(iq,D2_TA_TB) = Mmat2(iq,D2_TA_TB)
              Mmat2(iq,D2_TB_TB) = Mmat2(iq,D2_TB_TB)
            elseif (taua.le.tol_rho.and.taub.gt.tol_rho) then 
              t1 = rhoa**1.3333333333333333d+0
              t2 = 1/rhoa**1.6666666666666669d+0
              t3 = 1.0970205230680374d-51*t2-1.0d+0
              t4 = 4.3880820922721503d-52*t2*t3+1.0d+0
              t5 = 1/t4**5.0d-1
              t6 = 4.5d-1*t3*t5+4.3880820922721503d-52*t2
              t7 = 1/rhoa**3.3333333333333337d+0
              t8 = 2.166217250458448d-103*t7+4.4999999999999996d-2
              t9 = t8**5.0d-1
              t10 = -1.802469135802469d-1*t6*t9+8.213077466115726d-105*t
     1           7+7.209876543209877d-2*t6**2+2.4881109353903252d-52*t2+
     2           9.621132278843042d-155/rhoa**5+2.755017868687991d-2
              t11 = 8.160240087098705d-52*t2+1.0d+0
              t12 = 1/t11**2.0d+0
              t13 = 1.2437810945273631d+0*t10*t12+1.0d+0
              t14 = 8.04d-1-8.04d-1/t13
              t15 = rhob**1.3333333333333333d+0
              t16 = 1/rhob**2.6666666666666666d+0
              t17 = 2.040060021774676d-2*gammabb*t16+1.0d+0
              t18 = 1/t17**2.0d+0
              t19 = gammabb**3
              t20 = 1/rhob**8
              t21 = gammabb**2
              t22 = 1/rhob**5.333333333333333d+0
              t23 = 1/rhob
              t24 = 1/taub
              t25 = gammabb*t23*t24
              t26 = t25**2.0d+0
              t27 = 1.5625d-2*t26+1.0d+0
              t28 = 1/t27**2.0d+0
              t29 = 2.485875d-2*t26*t28+1.234567901234568d-1
              t30 = 2.8125d-3*t26+1.35388578153653d-4*t21*t22
              t31 = t30**5.0d-1
              t32 = 1/rhob**1.6666666666666669d+0
              t33 = 2.0d+0*taub-2.5d-1*gammabb*t23
              t34 = 1.0970205230680374d-1*t32*t33-1.0d+0
              t35 = 4.38808209227215d-2*t32*t33*t34+1.0d+0
              t36 = 1/t35**5.0d-1
              t37 = 4.5d-1*t34*t36+1.0970205230680376d-2*gammabb*t16
              t38 = 7.209876543209877d-2*t37**2-1.802469135802469d-1*t31
     1           *t37+1.6455307846020564d-2*gammabb*t16*t29+1.7218861679
     2           299946d-3*t26+5.133173416322327d-6*t21*t22+1.5033019185
     3           692253d-6*t19*t20
              t39 = 1.2437810945273631d+0*t18*t38+1.0d+0
              t40 = 8.04d-1-8.04d-1/t39
              t41 = rhoa**3.333333333333333d-1
              t42 = 1/t13**2
              t43 = 1/rhoa**4.333333333333333d+0
              t44 = 1/t9
              t45 = 1/rhoa**2.6666666666666666d+0
              t46 = -7.313470153786917d-52*t3*t45-8.023026853549804d-103
     1           *t43
              t47 = 1/t4**1.5d+0
              t48 = -8.227653923010281d-52*t45*t5-2.25d-1*t3*t46*t47-7.3
     1           13470153786917d-52*t45
              t49 = -1.802469135802469d-1*t48*t9+1.4419753086419754d-1*t
     1           48*t6+6.507566225657065d-104*t43*t44*t6-4.1468515589838
     2           76d-52*t45-2.737692488705242d-104*t43-4.810566139421521
     3           d-154/rhoa**6
              t50 = 1/t11**3.0d+0
              t51 = 3.3831841157125636d-51*t10*t45*t50+1.243781094527363
     1           1d+0*t12*t49
              t52 = rhob**3.333333333333333d-1
              t53 = 1/t39**2
              t54 = 1/rhob**9
              t55 = 1/rhob**6.333333333333333d+0
              t56 = 1/rhob**3.6666666666666664d+0
              t57 = 1/rhob**3
              t58 = 1/taub**2
              t59 = 1/rhob**2
              t60 = 1/t27**3.0d+0
              t61 = t25**3.0d+0
              t62 = 1.553671875d-3*gammabb*t24*t59*t60*t61-4.97175d-2*t2
     1           1*t28*t57*t58
              t63 = 2.7425513076700936d-2*gammabb*t56-1.828367538446729d
     1           -1*t16*t33
              t64 = 4.38808209227215d-2*t32*t33*t63+1.0970205230680374d-
     1           2*gammabb*t34*t56-7.313470153786916d-2*t16*t33*t34
              t65 = 1/t35**1.5d+0
              t66 = -2.25d-1*t34*t64*t65+4.5d-1*t36*t63-2.92538806151476
     1           7d-2*gammabb*t56
              t67 = 1/t31
              t68 = -5.625d-3*t21*t57*t58-7.220724168194825d-4*t21*t55
              t69 = -9.012345679012345d-2*t37*t67*t68+1.4419753086419754
     1           d-1*t37*t66-1.802469135802469d-1*t31*t66+1.645530784602
     2           0564d-2*gammabb*t16*t62-3.443772335859989d-3*t21*t57*t5
     3           8-4.3880820922721503d-2*gammabb*t29*t56-2.7376924887052
     4           41d-5*t21*t55-1.2026415348553804d-5*t19*t54
              t70 = 1/t17**3.0d+0
              t71 = 1.3532736462850253d-1*gammabb*t38*t56*t70+1.24378109
     1           45273631d+0*t18*t69
              t72 = 4.97175d-2*gammabb*t28*t58*t59-1.553671875d-3*t23*t2
     1           4*t60*t61
              t73 = 1/rhob**4.333333333333333d+0
              t74 = -1.2034540280324706d-3*t33*t73-1.0970205230680374d-2
     1           *t16*t34
              t75 = -2.25d-1*t34*t65*t74-1.2341480884515421d-2*t16*t36+1
     1           .0970205230680376d-2*t16
              t76 = 5.625d-3*gammabb*t58*t59+2.70777156307306d-4*gammabb
     1           *t22
              t77 = -9.012345679012345d-2*t37*t67*t76+1.4419753086419754
     1           d-1*t37*t75-1.802469135802469d-1*t31*t75+1.645530784602
     2           0564d-2*gammabb*t16*t72+3.443772335859989d-3*gammabb*t5
     3           8*t59+1.6455307846020564d-2*t16*t29+1.0266346832644656d
     4           -5*gammabb*t22+4.509905755707676d-6*t20*t21
              t78 = 1.2437810945273631d+0*t18*t77-5.074776173568845d-2*t
     1           16*t38*t70
              t79 = 1/taub**3
              t80 = 1.553671875d-3*gammabb*t23*t58*t60*t61-4.97175d-2*t2
     1           1*t28*t59*t79
              t81 = 1/rhob**3.3333333333333337d+0
              t82 = 9.627632224259765d-3*t33*t81+8.7761641845443d-2*t32*
     1           t34
              t83 = 9.873184707612337d-2*t32*t36-2.25d-1*t34*t65*t82
              t84 = 1.4419753086419754d-1*t37*t83-1.802469135802469d-1*t
     1           31*t83+1.6455307846020564d-2*gammabb*t16*t80+5.06944444
     2           4444443d-4*t21*t37*t59*t67*t79-3.443772335859989d-3*t21
     3           *t59*t79
              t85 = 1/rhoa**5.333333333333333d+0
              t86 = 1/rhoa**3.6666666666666664d+0
              t87 = -2.25d-1*t3*t47*(1.9502587076765113d-51*t3*t86+4.813
     1           8161121298817d-102*t85)+2.194041046136075d-51*t5*t86+1.
     2           9502587076765113d-51*t86+8.227653923010281d-52*t45*t46*
     3           t47+3.375d-1*t3*t46**2/t4**2.5d+0
              t88 = 1/rhob**7.333333333333333d+0
              t89 = 1/rhob**4.666666666666667d+0
              t90 = 1/rhob**4
              t91 = gammabb**4
              t92 = 1/taub**4
              t93 = 1/t27**4.0d+0
              t94 = t25**4.0d+0
              t95 = 1/t35**2.5d+0
              t96 = 4.8756467691912775d-1*t33*t56-1.4626940307573832d-1*
     1           gammabb*t89
              t97 = -2.25d-1*t34*t65*(4.38808209227215d-2*t32*t33*t96-5.
     1           850776123029533d-2*gammabb*t34*t89+2.194041046136075d-2
     2           *gammabb*t56*t63-1.4626940307573832d-1*t16*t33*t63+1.95
     3           0258707676511d-1*t33*t34*t56)+4.5d-1*t36*t96+3.375d-1*t
     4           34*t64**2*t95+1.0726422892220812d-1*gammabb*t89-4.5d-1*
     5           t63*t64*t65
              t98 = 1/t30**1.5d+0
              t99 = 1/t17**4.0d+0
              t100 = 1/t39**3
              t101 = 1/rhob**5
              t102 = 3.375d-1*t34*t64*t74*t95-2.25d-1*t63*t65*t74+6.1707
     1           40442257711d-3*t16*t64*t65-2.25d-1*t34*(-1.097020523068
     2           0374d-2*t16*t63+2.9253880615147665d-2*t34*t56-3.0086350
     3           700811765d-4*gammabb*t55+5.214967454807371d-3*t22*t33)*
     4           t65+3.2910615692041123d-2*t36*t56-2.925388061514767d-2*
     5           t56
              t103 = 3.375d-1*t34*t74**2*t95+1.2341480884515421d-2*t16*t
     1           65*t74-1.3538857815365296d-4*t22*t34*t65
              t104 = 1/taub**5
              t105 = 3.375d-1*t34*t64*t82*t95-2.25d-1*t63*t65*t82-2.25d-
     1           1*t34*t65*(-3.209210741419921d-2*t33*t73+8.776164184544
     2           3d-2*t32*t63-1.4626940307573832d-1*t16*t34+2.4069080560
     3           64941d-3*gammabb*t22)-4.9365923538061685d-2*t32*t64*t65
     4           -1.6455307846020562d-1*t16*t36
              t106 = 3.375d-1*t34*t74*t82*t95+6.170740442257711d-3*t16*t
     1           65*t82-4.9365923538061685d-2*t32*t65*t74+1.083108625229
     2           2235d-3*t34*t65*t73
              t107 = 1/taub**6
              t108 = 3.375d-1*t34*t82**2*t95-9.873184707612337d-2*t32*t6
     1           5*t82-8.664869001833788d-3*t34*t65*t81
              fnc(iq) = (-9.305257363490997d-1*t15*t40-9.305257363490997
     1           d-1*t15-9.305257363490997d-1*t1*t14-9.305257363490997d-
     2           1*t1)*wght+fnc(iq)
              Amat(iq,D1_RA) = (-7.481426920246762d-1*t1*t42*t51-1.24070
     1           09817987995d+0*t14*t41-1.2407009817987995d+0*t41)*wght+
     2           Amat(iq,D1_RA)
              Amat(iq,D1_RB) = (-7.481426920246762d-1*t15*t53*t71-1.2407
     1           009817987995d+0*t40*t52-1.2407009817987995d+0*t52)*wght
     2           +Amat(iq,D1_RB)
              Cmat(iq,D1_GAA) = Cmat(iq,D1_GAA)
              Cmat(iq,D1_GAB) = Cmat(iq,D1_GAB)
              Cmat(iq,D1_GBB) = Cmat(iq,D1_GBB)-7.481426920246762d-1*t15
     1           *t53*t78*wght
              Mmat(iq,D1_TA) = Mmat(iq,D1_TA)
              Mmat(iq,D1_TB) = Mmat(iq,D1_TB)-9.305257363490997d-1*t15*t
     1           18*t53*t84*wght
              Amat2(iq,D2_RA_RA) = (t42*(-7.481426920246762d-1*t1*(1.243
     1           7810945273631d+0*t12*(-1.802469135802469d-1*t87*t9+1.44
     2           19753086419754d-1*t6*t87+1.1058270823957002d-51*t86-2.8
     3           199453644513944d-103*t44*t6*t85+1.1863334117722714d-103
     4           *t85+2.349467036086518d-206*t6/(rhoa**8.666666666666666
     5           d+0*t8**1.5d+0)+1.4419753086419754d-1*t48**2+1.30151324
     6           5131413d-103*t43*t44*t48+2.886339683652913d-153/rhoa**7
     7           )-9.021824308566837d-51*t10*t50*t86+1.3803797321536623d
     8           -101*t10*t85/t11**4.0d+0+6.766368231425127d-51*t45*t49*
     9           t50)-1.9950471787324697d+0*t41*t51)+1.4962853840493523d
     :           +0*t1*t51**2/t13**3+(-4.1356699393293317d-1*t14-4.13566
     ;           99393293317d-1)/rhoa**6.666666666666666d-1)*wght+Amat2(
     <           iq,D2_RA_RA)
              Amat2(iq,D2_RA_RB) = Amat2(iq,D2_RA_RB)
              Amat2(iq,D2_RB_RB) = (t53*(-7.481426920246762d-1*t15*(2.20
     1           8607571445859d-2*t21*t38*t88*t99+1.2437810945273631d+0*
     2           t18*(4.5061728395061723d-2*t37*t68**2*t98+1.44197530864
     3           19754d-1*t37*t97-1.802469135802469d-1*t31*t97+1.6455307
     4           846020564d-2*gammabb*t16*(1.4565673828125d-4*t21*t58*t9
     5           0*t93*t94-3.10734375d-3*t60*t91*t92/rhob**6-4.661015624
     6           9999996d-3*t21*t26*t58*t60*t90+1.491525d-1*t21*t28*t58*
     7           t90-3.10734375d-3*gammabb*t24*t57*t60*t61)-9.0123456790
     8           12345d-2*t37*t67*(1.6875d-2*t21*t58*t90+4.5731253065233
     9           89d-3*t21*t88)+1.0331317007579968d-2*t21*t58*t90+1.6089
     :           634338331218d-1*gammabb*t29*t89+1.7338719095133195d-4*t
     ;           21*t88-1.802469135802469d-1*t66*t67*t68+1.4419753086419
     <           754d-1*t66**2-8.776164184544301d-2*gammabb*t56*t62+1.08
     =           23773813698423d-4*t19/rhob**10)-4.9620033697117594d-1*g
     >           ammabb*t38*t70*t89+2.7065472925700507d-1*gammabb*t56*t6
     ?           9*t70)-1.9950471787324697d+0*t52*t71)+1.496285384049352
     @           3d+0*t100*t15*t71**2+(-4.1356699393293317d-1*t40-4.1356
     1           699393293317d-1)/rhob**6.666666666666666d-1)*wght+Amat2
     2           (iq,D2_RB_RB)
              Cmat2(iq,D2_RA_GAA) = Cmat2(iq,D2_RA_GAA)
              Cmat2(iq,D2_RA_GAB) = Cmat2(iq,D2_RA_GAB)
              Cmat2(iq,D2_RA_GBB) = Cmat2(iq,D2_RA_GBB)
              Cmat2(iq,D2_RB_GAA) = Cmat2(iq,D2_RB_GAA)
              Cmat2(iq,D2_RB_GAB) = Cmat2(iq,D2_RB_GAB)
              Cmat2(iq,D2_RB_GBB) = (t53*(-7.481426920246762d-1*t15*(-8.
     1           282278392921971d-3*gammabb*t38*t55*t99+1.24378109452736
     2           31d+0*t18*(4.5061728395061723d-2*t37*t68*t76*t98+1.6455
     3           307846020564d-2*gammabb*t16*(-1.4565673828125d-4*gammab
     4           b*t57*t58*t93*t94+3.10734375d-3*t101*t19*t60*t92+1.5536
     5           71875d-3*t24*t59*t60*t61+4.6610156249999996d-3*gammabb*
     6           t26*t57*t58*t60-9.9435d-2*gammabb*t28*t57*t58)-9.012345
     7           679012345d-2*t66*t67*t76-9.012345679012345d-2*t67*t68*t
     8           75+1.4419753086419754d-1*t66*t75-4.3880820922721503d-2*
     9           gammabb*t56*t72-9.012345679012345d-2*t37*(-1.1249999999
     :           999999d-2*gammabb*t57*t58-1.444144833638965d-3*gammabb*
     ;           t55)*t67+1.6455307846020564d-2*t16*t62-6.88754467171997
     <           8d-3*gammabb*t57*t58-4.3880820922721503d-2*t29*t56-5.47
     =           5384977410482d-5*gammabb*t55-3.607924604566141d-5*t21*t
     >           54+1.4419753086419754d-1*t102*t37-1.802469135802469d-1*
     ?           t102*t31)+1.3532736462850253d-1*gammabb*t56*t70*t77-5.0
     @           74776173568845d-2*t16*t69*t70+1.3532736462850253d-1*t38
     1           *t56*t70)-9.975235893662349d-1*t52*t78)+1.4962853840493
     2           523d+0*t100*t15*t71*t78)*wght+Cmat2(iq,D2_RB_GBB)
              Cmat2(iq,D2_GAA_GAA) = Cmat2(iq,D2_GAA_GAA)
              Cmat2(iq,D2_GAA_GAB) = Cmat2(iq,D2_GAA_GAB)
              Cmat2(iq,D2_GAA_GBB) = Cmat2(iq,D2_GAA_GBB)
              Cmat2(iq,D2_GAB_GAB) = Cmat2(iq,D2_GAB_GAB)
              Cmat2(iq,D2_GAB_GBB) = Cmat2(iq,D2_GAB_GBB)
              Cmat2(iq,D2_GBB_GBB) = -7.481426920246762d-1*t15*t53*(3.10
     1           585439734574d-3*t22*t38*t99+1.2437810945273631d+0*t18*(
     2           4.5061728395061723d-2*t37*t76**2*t98+1.6455307846020564
     3           d-2*gammabb*t16*(1.4565673828125d-4*t58*t59*t93*t94-3.1
     4           0734375d-3*t21*t60*t90*t92-4.6610156249999996d-3*t26*t5
     5           8*t59*t60+4.97175d-2*t28*t58*t59)-1.802469135802469d-1*
     6           t67*t75*t76+1.4419753086419754d-1*t75**2+3.291061569204
     7           113d-2*t16*t72-9.012345679012345d-2*t37*(5.625d-3*t58*t
     8           59+2.70777156307306d-4*t22)*t67+3.443772335859989d-3*t5
     9           8*t59+1.4419753086419754d-1*t103*t37-1.802469135802469d
     :           -1*t103*t31+1.0266346832644656d-5*t22+9.019811511415352
     ;           d-6*gammabb*t20)-1.014955234713769d-1*t16*t70*t77)*wght
     <           +1.4962853840493523d+0*t100*t15*t78**2*wght+Cmat2(iq,D2
     =           _GBB_GBB)
              Mmat2(iq,D2_RA_TA) = Mmat2(iq,D2_RA_TA)
              Mmat2(iq,D2_RA_TB) = Mmat2(iq,D2_RA_TB)
              Mmat2(iq,D2_RB_TA) = Mmat2(iq,D2_RB_TA)
              Mmat2(iq,D2_RB_TB) = (-7.481426920246762d-1*t15*t53*(1.243
     1           7810945273631d+0*t18*(-2.5347222222222215d-4*t21*t37*t5
     2           9*t68*t79*t98+1.6455307846020564d-2*gammabb*t16*(1.4565
     3           673828125d-4*t21*t57*t79*t93*t94-3.10734375d-3*t101*t10
     4           4*t60*t91-4.6610156249999996d-3*t21*t26*t57*t60*t79+9.9
     5           435d-2*t21*t28*t57*t79-1.553671875d-3*gammabb*t58*t59*t
     6           60*t61)-9.012345679012345d-2*t67*t68*t83+1.441975308641
     7           9754d-1*t66*t83-4.3880820922721503d-2*gammabb*t56*t80+5
     8           .069444444444443d-4*t21*t59*t66*t67*t79-1.0138888888888
     9           886d-3*t21*t37*t57*t67*t79+6.887544671719978d-3*t21*t57
     :           *t79+1.4419753086419754d-1*t105*t37-1.802469135802469d-
     ;           1*t105*t31)+1.3532736462850253d-1*gammabb*t56*t70*t84)+
     <           1.8610514726981991d+0*t100*t15*t18*t71*t84-1.2407009817
     =           987995d+0*t18*t52*t53*t84)*wght+Mmat2(iq,D2_RB_TB)
              Mmat2(iq,D2_GAA_TA) = Mmat2(iq,D2_GAA_TA)
              Mmat2(iq,D2_GAA_TB) = Mmat2(iq,D2_GAA_TB)
              Mmat2(iq,D2_GAB_TA) = Mmat2(iq,D2_GAB_TA)
              Mmat2(iq,D2_GAB_TB) = Mmat2(iq,D2_GAB_TB)
              Mmat2(iq,D2_GBB_TA) = Mmat2(iq,D2_GBB_TA)
              Mmat2(iq,D2_GBB_TB) = -7.481426920246762d-1*t15*t53*(1.243
     1           7810945273631d+0*t18*(-2.5347222222222215d-4*t21*t37*t5
     2           9*t76*t79*t98+1.6455307846020564d-2*gammabb*t16*(-1.456
     3           5673828125d-4*gammabb*t59*t79*t93*t94+3.10734375d-3*t10
     4           4*t19*t60*t90+4.6610156249999996d-3*gammabb*t26*t59*t60
     5           *t79-9.9435d-2*gammabb*t28*t59*t79+1.553671875d-3*t23*t
     6           58*t60*t61)-9.012345679012345d-2*t67*t76*t83+1.44197530
     7           86419754d-1*t75*t83+1.6455307846020564d-2*t16*t80+5.069
     8           444444444443d-4*t21*t59*t67*t75*t79+1.0138888888888886d
     9           -3*gammabb*t37*t59*t67*t79-6.887544671719978d-3*gammabb
     :           *t59*t79+1.4419753086419754d-1*t106*t37-1.8024691358024
     ;           69d-1*t106*t31)-5.074776173568845d-2*t16*t70*t84)*wght+
     <           1.8610514726981991d+0*t100*t15*t18*t78*t84*wght+Mmat2(i
     =           q,D2_GBB_TB)
              Mmat2(iq,D2_TA_TA) = Mmat2(iq,D2_TA_TA)
              Mmat2(iq,D2_TA_TB) = Mmat2(iq,D2_TA_TB)
              Mmat2(iq,D2_TB_TB) = 2.3147406376843277d+0*t100*t15*t84**2
     1           *t99*wght-9.305257363490997d-1*t15*t18*t53*(1.425781249
     2           9999994d-6*t107*t37*t90*t91*t98+1.6455307846020564d-2*g
     3           ammabb*t16*(1.4565673828125d-4*t21*t59*t92*t93*t94-4.66
     4           10156249999996d-3*t21*t26*t59*t60*t92+1.491525d-1*t21*t
     5           28*t59*t92-3.10734375d-3*t107*t60*t90*t91-3.10734375d-3
     6           *gammabb*t23*t60*t61*t79)-1.520833333333333d-3*t21*t37*
     7           t59*t67*t92+1.0331317007579968d-2*t21*t59*t92+1.4419753
     8           086419754d-1*t83**2+1.0138888888888886d-3*t21*t59*t67*t
     9           79*t83+1.4419753086419754d-1*t108*t37-1.802469135802469
     :           d-1*t108*t31)*wght+Mmat2(iq,D2_TB_TB)
            else 
              t1 = rhoa**1.3333333333333333d+0
              t2 = 1/rhoa**1.6666666666666669d+0
              t3 = 1.0970205230680374d-51*t2-1.0d+0
              t4 = 4.3880820922721503d-52*t2*t3+1.0d+0
              t5 = 1/t4**5.0d-1
              t6 = 4.5d-1*t3*t5+4.3880820922721503d-52*t2
              t7 = 1/rhoa**3.3333333333333337d+0
              t8 = 2.166217250458448d-103*t7+4.4999999999999996d-2
              t9 = t8**5.0d-1
              t10 = -1.802469135802469d-1*t6*t9+8.213077466115726d-105*t
     1           7+7.209876543209877d-2*t6**2+2.4881109353903252d-52*t2+
     2           9.621132278843042d-155/rhoa**5+2.755017868687991d-2
              t11 = 8.160240087098705d-52*t2+1.0d+0
              t12 = 1/t11**2.0d+0
              t13 = 1.2437810945273631d+0*t10*t12+1.0d+0
              t14 = 8.04d-1-8.04d-1/t13
              t15 = rhob**1.3333333333333333d+0
              t16 = 1/rhob**1.6666666666666669d+0
              t17 = 1.0970205230680374d-51*t16-1.0d+0
              t18 = 4.3880820922721503d-52*t16*t17+1.0d+0
              t19 = 1/t18**5.0d-1
              t20 = 4.5d-1*t17*t19+4.3880820922721503d-52*t16
              t21 = 1/rhob**3.3333333333333337d+0
              t22 = 2.166217250458448d-103*t21+4.4999999999999996d-2
              t23 = t22**5.0d-1
              t24 = -1.802469135802469d-1*t20*t23+8.213077466115726d-105
     1           *t21+7.209876543209877d-2*t20**2+2.4881109353903252d-52
     2           *t16+9.621132278843042d-155/rhob**5+2.755017868687991d-
     3           2
              t25 = 8.160240087098705d-52*t16+1.0d+0
              t26 = 1/t25**2.0d+0
              t27 = 1.2437810945273631d+0*t24*t26+1.0d+0
              t28 = 8.04d-1-8.04d-1/t27
              t29 = rhoa**3.333333333333333d-1
              t30 = 1/t13**2
              t31 = 1/rhoa**4.333333333333333d+0
              t32 = 1/t9
              t33 = 1/rhoa**2.6666666666666666d+0
              t34 = -7.313470153786917d-52*t3*t33-8.023026853549804d-103
     1           *t31
              t35 = 1/t4**1.5d+0
              t36 = -8.227653923010281d-52*t33*t5-2.25d-1*t3*t34*t35-7.3
     1           13470153786917d-52*t33
              t37 = -1.802469135802469d-1*t36*t9+1.4419753086419754d-1*t
     1           36*t6+6.507566225657065d-104*t31*t32*t6-4.1468515589838
     2           76d-52*t33-2.737692488705242d-104*t31-4.810566139421521
     3           d-154/rhoa**6
              t38 = 1/t11**3.0d+0
              t39 = 3.3831841157125636d-51*t10*t33*t38+1.243781094527363
     1           1d+0*t12*t37
              t40 = rhob**3.333333333333333d-1
              t41 = 1/t27**2
              t42 = 1/rhob**4.333333333333333d+0
              t43 = 1/t23
              t44 = 1/rhob**2.6666666666666666d+0
              t45 = -7.313470153786917d-52*t17*t44-8.023026853549804d-10
     1           3*t42
              t46 = 1/t18**1.5d+0
              t47 = -2.25d-1*t17*t45*t46-8.227653923010281d-52*t19*t44-7
     1           .313470153786917d-52*t44
              t48 = -1.802469135802469d-1*t23*t47+1.4419753086419754d-1*
     1           t20*t47-4.146851558983876d-52*t44+6.507566225657065d-10
     2           4*t20*t42*t43-2.737692488705242d-104*t42-4.810566139421
     3           521d-154/rhob**6
              t49 = 1/t25**3.0d+0
              t50 = 3.3831841157125636d-51*t24*t44*t49+1.243781094527363
     1           1d+0*t26*t48
              t51 = 1/rhoa**5.333333333333333d+0
              t52 = 1/rhoa**3.6666666666666664d+0
              t53 = -2.25d-1*t3*t35*(1.9502587076765113d-51*t3*t52+4.813
     1           8161121298817d-102*t51)+2.194041046136075d-51*t5*t52+1.
     2           9502587076765113d-51*t52+3.375d-1*t3*t34**2/t4**2.5d+0+
     3           8.227653923010281d-52*t33*t34*t35
              t54 = 1/rhob**5.333333333333333d+0
              t55 = 1/rhob**3.6666666666666664d+0
              t56 = -2.25d-1*t17*t46*(1.9502587076765113d-51*t17*t55+4.8
     1           138161121298817d-102*t54)+2.194041046136075d-51*t19*t55
     2           +1.9502587076765113d-51*t55+8.227653923010281d-52*t44*t
     3           45*t46+3.375d-1*t17*t45**2/t18**2.5d+0
              fnc(iq) = (-9.305257363490997d-1*t15*t28-9.305257363490997
     1           d-1*t15-9.305257363490997d-1*t1*t14-9.305257363490997d-
     2           1*t1)*wght+fnc(iq)
              Amat(iq,D1_RA) = (-7.481426920246762d-1*t1*t30*t39-1.24070
     1           09817987995d+0*t14*t29-1.2407009817987995d+0*t29)*wght+
     2           Amat(iq,D1_RA)
              Amat(iq,D1_RB) = (-7.481426920246762d-1*t15*t41*t50-1.2407
     1           009817987995d+0*t28*t40-1.2407009817987995d+0*t40)*wght
     2           +Amat(iq,D1_RB)
              Cmat(iq,D1_GAA) = Cmat(iq,D1_GAA)
              Cmat(iq,D1_GAB) = Cmat(iq,D1_GAB)
              Cmat(iq,D1_GBB) = Cmat(iq,D1_GBB)
              Mmat(iq,D1_TA) = Mmat(iq,D1_TA)
              Mmat(iq,D1_TB) = Mmat(iq,D1_TB)
              Amat2(iq,D2_RA_RA) = (t30*(-7.481426920246762d-1*t1*(1.243
     1           7810945273631d+0*t12*(-1.802469135802469d-1*t53*t9+2.34
     2           9467036086518d-206*t6/(rhoa**8.666666666666666d+0*t8**1
     3           .5d+0)+1.4419753086419754d-1*t53*t6-2.8199453644513944d
     4           -103*t32*t51*t6+1.1058270823957002d-51*t52+1.1863334117
     5           722714d-103*t51+1.4419753086419754d-1*t36**2+1.30151324
     6           5131413d-103*t31*t32*t36+2.886339683652913d-153/rhoa**7
     7           )-9.021824308566837d-51*t10*t38*t52+1.3803797321536623d
     8           -101*t10*t51/t11**4.0d+0+6.766368231425127d-51*t33*t37*
     9           t38)-1.9950471787324697d+0*t29*t39)+1.4962853840493523d
     :           +0*t1*t39**2/t13**3+(-4.1356699393293317d-1*t14-4.13566
     ;           99393293317d-1)/rhoa**6.666666666666666d-1)*wght+Amat2(
     <           iq,D2_RA_RA)
              Amat2(iq,D2_RA_RB) = Amat2(iq,D2_RA_RB)
              Amat2(iq,D2_RB_RB) = (t41*(-7.481426920246762d-1*t15*(1.24
     1           37810945273631d+0*t26*(-1.802469135802469d-1*t23*t56+1.
     2           4419753086419754d-1*t20*t56+1.1058270823957002d-51*t55-
     3           2.8199453644513944d-103*t20*t43*t54+1.1863334117722714d
     4           -103*t54+1.4419753086419754d-1*t47**2+1.301513245131413
     5           d-103*t42*t43*t47+2.349467036086518d-206*t20/(rhob**8.6
     6           66666666666666d+0*t22**1.5d+0)+2.886339683652913d-153/r
     7           hob**7)-9.021824308566837d-51*t24*t49*t55+1.38037973215
     8           36623d-101*t24*t54/t25**4.0d+0+6.766368231425127d-51*t4
     9           4*t48*t49)-1.9950471787324697d+0*t40*t50)+1.49628538404
     :           93523d+0*t15*t50**2/t27**3+(-4.1356699393293317d-1*t28-
     ;           4.1356699393293317d-1)/rhob**6.666666666666666d-1)*wght
     <           +Amat2(iq,D2_RB_RB)
              Cmat2(iq,D2_RA_GAA) = Cmat2(iq,D2_RA_GAA)
              Cmat2(iq,D2_RA_GAB) = Cmat2(iq,D2_RA_GAB)
              Cmat2(iq,D2_RA_GBB) = Cmat2(iq,D2_RA_GBB)
              Cmat2(iq,D2_RB_GAA) = Cmat2(iq,D2_RB_GAA)
              Cmat2(iq,D2_RB_GAB) = Cmat2(iq,D2_RB_GAB)
              Cmat2(iq,D2_RB_GBB) = Cmat2(iq,D2_RB_GBB)
              Cmat2(iq,D2_GAA_GAA) = Cmat2(iq,D2_GAA_GAA)
              Cmat2(iq,D2_GAA_GAB) = Cmat2(iq,D2_GAA_GAB)
              Cmat2(iq,D2_GAA_GBB) = Cmat2(iq,D2_GAA_GBB)
              Cmat2(iq,D2_GAB_GAB) = Cmat2(iq,D2_GAB_GAB)
              Cmat2(iq,D2_GAB_GBB) = Cmat2(iq,D2_GAB_GBB)
              Cmat2(iq,D2_GBB_GBB) = Cmat2(iq,D2_GBB_GBB)
              Mmat2(iq,D2_RA_TA) = Mmat2(iq,D2_RA_TA)
              Mmat2(iq,D2_RA_TB) = Mmat2(iq,D2_RA_TB)
              Mmat2(iq,D2_RB_TA) = Mmat2(iq,D2_RB_TA)
              Mmat2(iq,D2_RB_TB) = Mmat2(iq,D2_RB_TB)
              Mmat2(iq,D2_GAA_TA) = Mmat2(iq,D2_GAA_TA)
              Mmat2(iq,D2_GAA_TB) = Mmat2(iq,D2_GAA_TB)
              Mmat2(iq,D2_GAB_TA) = Mmat2(iq,D2_GAB_TA)
              Mmat2(iq,D2_GAB_TB) = Mmat2(iq,D2_GAB_TB)
              Mmat2(iq,D2_GBB_TA) = Mmat2(iq,D2_GBB_TA)
              Mmat2(iq,D2_GBB_TB) = Mmat2(iq,D2_GBB_TB)
              Mmat2(iq,D2_TA_TA) = Mmat2(iq,D2_TA_TA)
              Mmat2(iq,D2_TA_TB) = Mmat2(iq,D2_TA_TB)
              Mmat2(iq,D2_TB_TB) = Mmat2(iq,D2_TB_TB)
            endif 
          elseif (rhoa.gt.tol_rho.and.rhob.le.tol_rho) then 
            if (taua.gt.tol_rho.and.taub.gt.tol_rho) then 
              t1 = rhoa**1.3333333333333333d+0
              t2 = 1/rhoa**2.6666666666666666d+0
              t3 = 2.040060021774676d-2*gammaaa*t2+1.0d+0
              t4 = 1/t3**2.0d+0
              t5 = gammaaa**3
              t6 = 1/rhoa**8
              t7 = gammaaa**2
              t8 = 1/rhoa**5.333333333333333d+0
              t9 = 1/rhoa
              t10 = 1/taua
              t11 = gammaaa*t10*t9
              t12 = t11**2.0d+0
              t13 = 1.5625d-2*t12+1.0d+0
              t14 = 1/t13**2.0d+0
              t15 = 2.485875d-2*t12*t14+1.234567901234568d-1
              t16 = 1.35388578153653d-4*t7*t8+2.8125d-3*t12
              t17 = t16**5.0d-1
              t18 = 1/rhoa**1.6666666666666669d+0
              t19 = 2.0d+0*taua-2.5d-1*gammaaa*t9
              t20 = 1.0970205230680374d-1*t18*t19-1.0d+0
              t21 = 4.38808209227215d-2*t18*t19*t20+1.0d+0
              t22 = 1/t21**5.0d-1
              t23 = 4.5d-1*t20*t22+1.0970205230680376d-2*gammaaa*t2
              t24 = 5.133173416322327d-6*t7*t8+1.5033019185692253d-6*t5*
     1           t6+7.209876543209877d-2*t23**2-1.802469135802469d-1*t17
     2           *t23+1.6455307846020564d-2*gammaaa*t15*t2+1.72188616792
     3           99946d-3*t12
              t25 = 1.2437810945273631d+0*t24*t4+1.0d+0
              t26 = 8.04d-1-8.04d-1/t25
              t27 = rhoa**3.333333333333333d-1
              t28 = 1/t25**2
              t29 = 1/rhoa**9
              t30 = 1/rhoa**6.333333333333333d+0
              t31 = 1/rhoa**3.6666666666666664d+0
              t32 = 1/rhoa**3
              t33 = 1/taua**2
              t34 = 1/rhoa**2
              t35 = 1/t13**3.0d+0
              t36 = t11**3.0d+0
              t37 = 1.553671875d-3*gammaaa*t10*t34*t35*t36-4.97175d-2*t1
     1           4*t32*t33*t7
              t38 = 2.7425513076700936d-2*gammaaa*t31-1.828367538446729d
     1           -1*t19*t2
              t39 = 4.38808209227215d-2*t18*t19*t38+1.0970205230680374d-
     1           2*gammaaa*t20*t31-7.313470153786916d-2*t19*t2*t20
              t40 = 1/t21**1.5d+0
              t41 = -2.25d-1*t20*t39*t40+4.5d-1*t22*t38-2.92538806151476
     1           7d-2*gammaaa*t31
              t42 = 1/t17
              t43 = -5.625d-3*t32*t33*t7-7.220724168194825d-4*t30*t7
              t44 = -3.443772335859989d-3*t32*t33*t7-2.737692488705241d-
     1           5*t30*t7-1.2026415348553804d-5*t29*t5-9.012345679012345
     2           d-2*t23*t42*t43+1.4419753086419754d-1*t23*t41-1.8024691
     3           35802469d-1*t17*t41+1.6455307846020564d-2*gammaaa*t2*t3
     4           7-4.3880820922721503d-2*gammaaa*t15*t31
              t45 = 1/t3**3.0d+0
              t46 = 1.3532736462850253d-1*gammaaa*t24*t31*t45+1.24378109
     1           45273631d+0*t4*t44
              t47 = 4.97175d-2*gammaaa*t14*t33*t34-1.553671875d-3*t10*t3
     1           5*t36*t9
              t48 = 1/rhoa**4.333333333333333d+0
              t49 = -1.2034540280324706d-3*t19*t48-1.0970205230680374d-2
     1           *t2*t20
              t50 = -2.25d-1*t20*t40*t49-1.2341480884515421d-2*t2*t22+1.
     1           0970205230680376d-2*t2
              t51 = 2.70777156307306d-4*gammaaa*t8+5.625d-3*gammaaa*t33*
     1           t34
              t52 = 1.0266346832644656d-5*gammaaa*t8+4.509905755707676d-
     1           6*t6*t7-9.012345679012345d-2*t23*t42*t51+1.441975308641
     2           9754d-1*t23*t50-1.802469135802469d-1*t17*t50+1.64553078
     3           46020564d-2*gammaaa*t2*t47+3.443772335859989d-3*gammaaa
     4           *t33*t34+1.6455307846020564d-2*t15*t2
              t53 = 1.2437810945273631d+0*t4*t52-5.074776173568845d-2*t2
     1           *t24*t45
              t54 = 1/taua**3
              t55 = 1.553671875d-3*gammaaa*t33*t35*t36*t9-4.97175d-2*t14
     1           *t34*t54*t7
              t56 = 1/rhoa**3.3333333333333337d+0
              t57 = 9.627632224259765d-3*t19*t56+8.7761641845443d-2*t18*
     1           t20
              t58 = 9.873184707612337d-2*t18*t22-2.25d-1*t20*t40*t57
              t59 = 5.069444444444443d-4*t23*t34*t42*t54*t7-3.4437723358
     1           59989d-3*t34*t54*t7+1.4419753086419754d-1*t23*t58-1.802
     2           469135802469d-1*t17*t58+1.6455307846020564d-2*gammaaa*t
     3           2*t55
              t60 = 1/rhoa**7.333333333333333d+0
              t61 = 1/rhoa**4.666666666666667d+0
              t62 = 1/rhoa**4
              t63 = gammaaa**4
              t64 = 1/taua**4
              t65 = 1/t13**4.0d+0
              t66 = t11**4.0d+0
              t67 = 1/t21**2.5d+0
              t68 = 4.8756467691912775d-1*t19*t31-1.4626940307573832d-1*
     1           gammaaa*t61
              t69 = -2.25d-1*t20*t40*(4.38808209227215d-2*t18*t19*t68-5.
     1           850776123029533d-2*gammaaa*t20*t61+2.194041046136075d-2
     2           *gammaaa*t31*t38-1.4626940307573832d-1*t19*t2*t38+1.950
     3           258707676511d-1*t19*t20*t31)+4.5d-1*t22*t68+3.375d-1*t2
     4           0*t39**2*t67+1.0726422892220812d-1*gammaaa*t61-4.5d-1*t
     5           38*t39*t40
              t70 = 1/t16**1.5d+0
              t71 = 1/t3**4.0d+0
              t72 = 1/t25**3
              t73 = 1/rhoa**5
              t74 = -2.25d-1*t20*t40*(5.214967454807371d-3*t19*t8-1.0970
     1           205230680374d-2*t2*t38+2.9253880615147665d-2*t20*t31-3.
     2           0086350700811765d-4*gammaaa*t30)+3.375d-1*t20*t39*t49*t
     3           67-2.25d-1*t38*t40*t49+6.170740442257711d-3*t2*t39*t40+
     4           3.2910615692041123d-2*t22*t31-2.925388061514767d-2*t31
              t75 = -1.3538857815365296d-4*t20*t40*t8+3.375d-1*t20*t49**
     1           2*t67+1.2341480884515421d-2*t2*t40*t49
              t76 = 1/taua**5
              t77 = -2.25d-1*t20*t40*(2.406908056064941d-3*gammaaa*t8-3.
     1           209210741419921d-2*t19*t48+8.7761641845443d-2*t18*t38-1
     2           .4626940307573832d-1*t2*t20)+3.375d-1*t20*t39*t57*t67-2
     3           .25d-1*t38*t40*t57-4.9365923538061685d-2*t18*t39*t40-1.
     4           6455307846020562d-1*t2*t22
              t78 = 3.375d-1*t20*t49*t57*t67+6.170740442257711d-3*t2*t40
     1           *t57-4.9365923538061685d-2*t18*t40*t49+1.08310862522922
     2           35d-3*t20*t40*t48
              t79 = 1/taua**6
              t80 = 3.375d-1*t20*t57**2*t67-9.873184707612337d-2*t18*t40
     1           *t57-8.664869001833788d-3*t20*t40*t56
              fnc(iq) = (-9.305257363490997d-1*t1*t26-9.305257363490997d
     1           -1*t1)*wght+fnc(iq)
              Amat(iq,D1_RA) = (-7.481426920246762d-1*t1*t28*t46-1.24070
     1           09817987995d+0*t26*t27-1.2407009817987995d+0*t27)*wght+
     2           Amat(iq,D1_RA)
              Cmat(iq,D1_GAA) = Cmat(iq,D1_GAA)-7.481426920246762d-1*t1*
     1           t28*t53*wght
              Mmat(iq,D1_TA) = Mmat(iq,D1_TA)-9.305257363490997d-1*t1*t2
     1           8*t4*t59*wght
              Mmat(iq,D1_TB) = Mmat(iq,D1_TB)
              Amat2(iq,D2_RA_RA) = (1.4962853840493523d+0*t1*t46**2*t72+
     1           t28*(-7.481426920246762d-1*t1*(2.208607571445859d-2*t24
     2           *t60*t7*t71+1.2437810945273631d+0*t4*(4.506172839506172
     3           3d-2*t23*t43**2*t70+1.6455307846020564d-2*gammaaa*t2*(1
     4           .4565673828125d-4*t33*t62*t65*t66*t7-4.6610156249999996
     5           d-3*t12*t33*t35*t62*t7+1.491525d-1*t14*t33*t62*t7-3.107
     6           34375d-3*t35*t63*t64/rhoa**6-3.10734375d-3*gammaaa*t10*
     7           t32*t35*t36)-9.012345679012345d-2*t23*t42*(1.6875d-2*t3
     8           3*t62*t7+4.573125306523389d-3*t60*t7)+1.033131700757996
     9           8d-2*t33*t62*t7+1.7338719095133195d-4*t60*t7+1.44197530
     :           86419754d-1*t23*t69-1.802469135802469d-1*t17*t69+1.6089
     ;           634338331218d-1*gammaaa*t15*t61+1.0823773813698423d-4*t
     <           5/rhoa**10-1.802469135802469d-1*t41*t42*t43+1.441975308
     =           6419754d-1*t41**2-8.776164184544301d-2*gammaaa*t31*t37)
     >           -4.9620033697117594d-1*gammaaa*t24*t45*t61+2.7065472925
     ?           700507d-1*gammaaa*t31*t44*t45)-1.9950471787324697d+0*t2
     @           7*t46)+(-4.1356699393293317d-1*t26-4.1356699393293317d-
     1           1)/rhoa**6.666666666666666d-1)*wght+Amat2(iq,D2_RA_RA)
              Cmat2(iq,D2_RA_GAA) = (t28*(-7.481426920246762d-1*t1*(1.24
     1           37810945273631d+0*t4*(1.4419753086419754d-1*t23*t74-1.8
     2           02469135802469d-1*t17*t74+1.6455307846020564d-2*gammaaa
     3           *t2*(3.10734375d-3*t35*t5*t64*t73-1.4565673828125d-4*ga
     4           mmaaa*t32*t33*t65*t66+1.553671875d-3*t10*t34*t35*t36+4.
     5           6610156249999996d-3*gammaaa*t12*t32*t33*t35-9.9435d-2*g
     6           ammaaa*t14*t32*t33)+4.5061728395061723d-2*t23*t43*t51*t
     7           70-3.607924604566141d-5*t29*t7-9.012345679012345d-2*t41
     8           *t42*t51-9.012345679012345d-2*t42*t43*t50+1.44197530864
     9           19754d-1*t41*t50-4.3880820922721503d-2*gammaaa*t31*t47-
     :           9.012345679012345d-2*t23*(-1.1249999999999999d-2*gammaa
     ;           a*t32*t33-1.444144833638965d-3*gammaaa*t30)*t42+1.64553
     <           07846020564d-2*t2*t37-6.887544671719978d-3*gammaaa*t32*
     =           t33-4.3880820922721503d-2*t15*t31-5.475384977410482d-5*
     >           gammaaa*t30)-8.282278392921971d-3*gammaaa*t24*t30*t71+1
     ?           .3532736462850253d-1*gammaaa*t31*t45*t52-5.074776173568
     @           845d-2*t2*t44*t45+1.3532736462850253d-1*t24*t31*t45)-9.
     1           975235893662349d-1*t27*t53)+1.4962853840493523d+0*t1*t4
     2           6*t53*t72)*wght+Cmat2(iq,D2_RA_GAA)
              Cmat2(iq,D2_GAA_GAA) = -7.481426920246762d-1*t1*t28*(3.105
     1           85439734574d-3*t24*t71*t8+1.2437810945273631d+0*t4*(1.0
     2           266346832644656d-5*t8-9.012345679012345d-2*t23*t42*(2.7
     3           0777156307306d-4*t8+5.625d-3*t33*t34)+1.441975308641975
     4           4d-1*t23*t75-1.802469135802469d-1*t17*t75+4.50617283950
     5           61723d-2*t23*t51**2*t70+1.6455307846020564d-2*gammaaa*t
     6           2*(-3.10734375d-3*t35*t62*t64*t7+1.4565673828125d-4*t33
     7           *t34*t65*t66-4.6610156249999996d-3*t12*t33*t34*t35+4.97
     8           175d-2*t14*t33*t34)+9.019811511415352d-6*gammaaa*t6-1.8
     9           02469135802469d-1*t42*t50*t51+1.4419753086419754d-1*t50
     :           **2+3.291061569204113d-2*t2*t47+3.443772335859989d-3*t3
     ;           3*t34)-1.014955234713769d-1*t2*t45*t52)*wght+1.49628538
     <           40493523d+0*t1*t53**2*t72*wght+Cmat2(iq,D2_GAA_GAA)
              Mmat2(iq,D2_RA_TA) = (-7.481426920246762d-1*t1*t28*(1.2437
     1           810945273631d+0*t4*(1.4419753086419754d-1*t23*t77-1.802
     2           469135802469d-1*t17*t77+1.6455307846020564d-2*gammaaa*t
     3           2*(-3.10734375d-3*t35*t63*t73*t76+1.4565673828125d-4*t3
     4           2*t54*t65*t66*t7-4.6610156249999996d-3*t12*t32*t35*t54*
     5           t7+9.9435d-2*t14*t32*t54*t7-1.553671875d-3*gammaaa*t33*
     6           t34*t35*t36)-2.5347222222222215d-4*t23*t34*t43*t54*t7*t
     7           70+5.069444444444443d-4*t34*t41*t42*t54*t7-1.0138888888
     8           888886d-3*t23*t32*t42*t54*t7+6.887544671719978d-3*t32*t
     9           54*t7-9.012345679012345d-2*t42*t43*t58+1.44197530864197
     :           54d-1*t41*t58-4.3880820922721503d-2*gammaaa*t31*t55)+1.
     ;           3532736462850253d-1*gammaaa*t31*t45*t59)+1.861051472698
     <           1991d+0*t1*t4*t46*t59*t72-1.2407009817987995d+0*t27*t28
     =           *t4*t59)*wght+Mmat2(iq,D2_RA_TA)
              Mmat2(iq,D2_RA_TB) = Mmat2(iq,D2_RA_TB)
              Mmat2(iq,D2_GAA_TA) = -7.481426920246762d-1*t1*t28*(1.2437
     1           810945273631d+0*t4*(1.6455307846020564d-2*gammaaa*t2*(1
     2           .553671875d-3*t33*t35*t36*t9+3.10734375d-3*t35*t5*t62*t
     3           76-1.4565673828125d-4*gammaaa*t34*t54*t65*t66+4.6610156
     4           249999996d-3*gammaaa*t12*t34*t35*t54-9.9435d-2*gammaaa*
     5           t14*t34*t54)+1.4419753086419754d-1*t23*t78-1.8024691358
     6           02469d-1*t17*t78-2.5347222222222215d-4*t23*t34*t51*t54*
     7           t7*t70+5.069444444444443d-4*t34*t42*t50*t54*t7-9.012345
     8           679012345d-2*t42*t51*t58+1.4419753086419754d-1*t50*t58+
     9           1.6455307846020564d-2*t2*t55+1.0138888888888886d-3*gamm
     :           aaa*t23*t34*t42*t54-6.887544671719978d-3*gammaaa*t34*t5
     ;           4)-5.074776173568845d-2*t2*t45*t59)*wght+1.861051472698
     <           1991d+0*t1*t4*t53*t59*t72*wght+Mmat2(iq,D2_GAA_TA)
              Mmat2(iq,D2_GAA_TB) = Mmat2(iq,D2_GAA_TB)
              Mmat2(iq,D2_TA_TA) = -9.305257363490997d-1*t1*t28*t4*(1.64
     1           55307846020564d-2*gammaaa*t2*(-3.10734375d-3*gammaaa*t3
     2           5*t36*t54*t9-3.10734375d-3*t35*t62*t63*t79+1.4565673828
     3           125d-4*t34*t64*t65*t66*t7-4.6610156249999996d-3*t12*t34
     4           *t35*t64*t7+1.491525d-1*t14*t34*t64*t7)+1.4419753086419
     5           754d-1*t23*t80-1.802469135802469d-1*t17*t80+1.425781249
     6           9999994d-6*t23*t62*t63*t70*t79-1.520833333333333d-3*t23
     7           *t34*t42*t64*t7+1.0331317007579968d-2*t34*t64*t7+1.0138
     8           888888888886d-3*t34*t42*t54*t58*t7+1.4419753086419754d-
     9           1*t58**2)*wght+2.3147406376843277d+0*t1*t59**2*t71*t72*
     :           wght+Mmat2(iq,D2_TA_TA)
              Mmat2(iq,D2_TA_TB) = Mmat2(iq,D2_TA_TB)
              Mmat2(iq,D2_TB_TB) = Mmat2(iq,D2_TB_TB)
            elseif (taua.gt.tol_rho.and.taub.le.tol_rho) then 
              t1 = rhoa**1.3333333333333333d+0
              t2 = 1/rhoa**2.6666666666666666d+0
              t3 = 2.040060021774676d-2*gammaaa*t2+1.0d+0
              t4 = 1/t3**2.0d+0
              t5 = gammaaa**3
              t6 = 1/rhoa**8
              t7 = gammaaa**2
              t8 = 1/rhoa**5.333333333333333d+0
              t9 = 1/rhoa
              t10 = 1/taua
              t11 = gammaaa*t10*t9
              t12 = t11**2.0d+0
              t13 = 1.5625d-2*t12+1.0d+0
              t14 = 1/t13**2.0d+0
              t15 = 2.485875d-2*t12*t14+1.234567901234568d-1
              t16 = 1.35388578153653d-4*t7*t8+2.8125d-3*t12
              t17 = t16**5.0d-1
              t18 = 1/rhoa**1.6666666666666669d+0
              t19 = 2.0d+0*taua-2.5d-1*gammaaa*t9
              t20 = 1.0970205230680374d-1*t18*t19-1.0d+0
              t21 = 4.38808209227215d-2*t18*t19*t20+1.0d+0
              t22 = 1/t21**5.0d-1
              t23 = 4.5d-1*t20*t22+1.0970205230680376d-2*gammaaa*t2
              t24 = 5.133173416322327d-6*t7*t8+1.5033019185692253d-6*t5*
     1           t6+7.209876543209877d-2*t23**2-1.802469135802469d-1*t17
     2           *t23+1.6455307846020564d-2*gammaaa*t15*t2+1.72188616792
     3           99946d-3*t12
              t25 = 1.2437810945273631d+0*t24*t4+1.0d+0
              t26 = 8.04d-1-8.04d-1/t25
              t27 = rhoa**3.333333333333333d-1
              t28 = 1/t25**2
              t29 = 1/rhoa**9
              t30 = 1/rhoa**6.333333333333333d+0
              t31 = 1/rhoa**3.6666666666666664d+0
              t32 = 1/rhoa**3
              t33 = 1/taua**2
              t34 = 1/rhoa**2
              t35 = 1/t13**3.0d+0
              t36 = t11**3.0d+0
              t37 = 1.553671875d-3*gammaaa*t10*t34*t35*t36-4.97175d-2*t1
     1           4*t32*t33*t7
              t38 = 2.7425513076700936d-2*gammaaa*t31-1.828367538446729d
     1           -1*t19*t2
              t39 = 4.38808209227215d-2*t18*t19*t38+1.0970205230680374d-
     1           2*gammaaa*t20*t31-7.313470153786916d-2*t19*t2*t20
              t40 = 1/t21**1.5d+0
              t41 = -2.25d-1*t20*t39*t40+4.5d-1*t22*t38-2.92538806151476
     1           7d-2*gammaaa*t31
              t42 = 1/t17
              t43 = -5.625d-3*t32*t33*t7-7.220724168194825d-4*t30*t7
              t44 = -3.443772335859989d-3*t32*t33*t7-2.737692488705241d-
     1           5*t30*t7-1.2026415348553804d-5*t29*t5-9.012345679012345
     2           d-2*t23*t42*t43+1.4419753086419754d-1*t23*t41-1.8024691
     3           35802469d-1*t17*t41+1.6455307846020564d-2*gammaaa*t2*t3
     4           7-4.3880820922721503d-2*gammaaa*t15*t31
              t45 = 1/t3**3.0d+0
              t46 = 1.3532736462850253d-1*gammaaa*t24*t31*t45+1.24378109
     1           45273631d+0*t4*t44
              t47 = 4.97175d-2*gammaaa*t14*t33*t34-1.553671875d-3*t10*t3
     1           5*t36*t9
              t48 = 1/rhoa**4.333333333333333d+0
              t49 = -1.2034540280324706d-3*t19*t48-1.0970205230680374d-2
     1           *t2*t20
              t50 = -2.25d-1*t20*t40*t49-1.2341480884515421d-2*t2*t22+1.
     1           0970205230680376d-2*t2
              t51 = 2.70777156307306d-4*gammaaa*t8+5.625d-3*gammaaa*t33*
     1           t34
              t52 = 1.0266346832644656d-5*gammaaa*t8+4.509905755707676d-
     1           6*t6*t7-9.012345679012345d-2*t23*t42*t51+1.441975308641
     2           9754d-1*t23*t50-1.802469135802469d-1*t17*t50+1.64553078
     3           46020564d-2*gammaaa*t2*t47+3.443772335859989d-3*gammaaa
     4           *t33*t34+1.6455307846020564d-2*t15*t2
              t53 = 1.2437810945273631d+0*t4*t52-5.074776173568845d-2*t2
     1           *t24*t45
              t54 = 1/taua**3
              t55 = 1.553671875d-3*gammaaa*t33*t35*t36*t9-4.97175d-2*t14
     1           *t34*t54*t7
              t56 = 1/rhoa**3.3333333333333337d+0
              t57 = 9.627632224259765d-3*t19*t56+8.7761641845443d-2*t18*
     1           t20
              t58 = 9.873184707612337d-2*t18*t22-2.25d-1*t20*t40*t57
              t59 = 5.069444444444443d-4*t23*t34*t42*t54*t7-3.4437723358
     1           59989d-3*t34*t54*t7+1.4419753086419754d-1*t23*t58-1.802
     2           469135802469d-1*t17*t58+1.6455307846020564d-2*gammaaa*t
     3           2*t55
              t60 = 1/rhoa**7.333333333333333d+0
              t61 = 1/rhoa**4.666666666666667d+0
              t62 = 1/rhoa**4
              t63 = gammaaa**4
              t64 = 1/taua**4
              t65 = 1/t13**4.0d+0
              t66 = t11**4.0d+0
              t67 = 1/t21**2.5d+0
              t68 = 4.8756467691912775d-1*t19*t31-1.4626940307573832d-1*
     1           gammaaa*t61
              t69 = -2.25d-1*t20*t40*(4.38808209227215d-2*t18*t19*t68-5.
     1           850776123029533d-2*gammaaa*t20*t61+2.194041046136075d-2
     2           *gammaaa*t31*t38-1.4626940307573832d-1*t19*t2*t38+1.950
     3           258707676511d-1*t19*t20*t31)+4.5d-1*t22*t68+3.375d-1*t2
     4           0*t39**2*t67+1.0726422892220812d-1*gammaaa*t61-4.5d-1*t
     5           38*t39*t40
              t70 = 1/t16**1.5d+0
              t71 = 1/t3**4.0d+0
              t72 = 1/t25**3
              t73 = 1/rhoa**5
              t74 = -2.25d-1*t20*t40*(5.214967454807371d-3*t19*t8-1.0970
     1           205230680374d-2*t2*t38+2.9253880615147665d-2*t20*t31-3.
     2           0086350700811765d-4*gammaaa*t30)+3.375d-1*t20*t39*t49*t
     3           67-2.25d-1*t38*t40*t49+6.170740442257711d-3*t2*t39*t40+
     4           3.2910615692041123d-2*t22*t31-2.925388061514767d-2*t31
              t75 = -1.3538857815365296d-4*t20*t40*t8+3.375d-1*t20*t49**
     1           2*t67+1.2341480884515421d-2*t2*t40*t49
              t76 = 1/taua**5
              t77 = -2.25d-1*t20*t40*(2.406908056064941d-3*gammaaa*t8-3.
     1           209210741419921d-2*t19*t48+8.7761641845443d-2*t18*t38-1
     2           .4626940307573832d-1*t2*t20)+3.375d-1*t20*t39*t57*t67-2
     3           .25d-1*t38*t40*t57-4.9365923538061685d-2*t18*t39*t40-1.
     4           6455307846020562d-1*t2*t22
              t78 = 3.375d-1*t20*t49*t57*t67+6.170740442257711d-3*t2*t40
     1           *t57-4.9365923538061685d-2*t18*t40*t49+1.08310862522922
     2           35d-3*t20*t40*t48
              t79 = 1/taua**6
              t80 = 3.375d-1*t20*t57**2*t67-9.873184707612337d-2*t18*t40
     1           *t57-8.664869001833788d-3*t20*t40*t56
              fnc(iq) = (-9.305257363490997d-1*t1*t26-9.305257363490997d
     1           -1*t1)*wght+fnc(iq)
              Amat(iq,D1_RA) = (-7.481426920246762d-1*t1*t28*t46-1.24070
     1           09817987995d+0*t26*t27-1.2407009817987995d+0*t27)*wght+
     2           Amat(iq,D1_RA)
              Cmat(iq,D1_GAA) = Cmat(iq,D1_GAA)-7.481426920246762d-1*t1*
     1           t28*t53*wght
              Mmat(iq,D1_TA) = Mmat(iq,D1_TA)-9.305257363490997d-1*t1*t2
     1           8*t4*t59*wght
              Mmat(iq,D1_TB) = Mmat(iq,D1_TB)
              Amat2(iq,D2_RA_RA) = (1.4962853840493523d+0*t1*t46**2*t72+
     1           t28*(-7.481426920246762d-1*t1*(2.208607571445859d-2*t24
     2           *t60*t7*t71+1.2437810945273631d+0*t4*(4.506172839506172
     3           3d-2*t23*t43**2*t70+1.6455307846020564d-2*gammaaa*t2*(1
     4           .4565673828125d-4*t33*t62*t65*t66*t7-4.6610156249999996
     5           d-3*t12*t33*t35*t62*t7+1.491525d-1*t14*t33*t62*t7-3.107
     6           34375d-3*t35*t63*t64/rhoa**6-3.10734375d-3*gammaaa*t10*
     7           t32*t35*t36)-9.012345679012345d-2*t23*t42*(1.6875d-2*t3
     8           3*t62*t7+4.573125306523389d-3*t60*t7)+1.033131700757996
     9           8d-2*t33*t62*t7+1.7338719095133195d-4*t60*t7+1.44197530
     :           86419754d-1*t23*t69-1.802469135802469d-1*t17*t69+1.6089
     ;           634338331218d-1*gammaaa*t15*t61+1.0823773813698423d-4*t
     <           5/rhoa**10-1.802469135802469d-1*t41*t42*t43+1.441975308
     =           6419754d-1*t41**2-8.776164184544301d-2*gammaaa*t31*t37)
     >           -4.9620033697117594d-1*gammaaa*t24*t45*t61+2.7065472925
     ?           700507d-1*gammaaa*t31*t44*t45)-1.9950471787324697d+0*t2
     @           7*t46)+(-4.1356699393293317d-1*t26-4.1356699393293317d-
     1           1)/rhoa**6.666666666666666d-1)*wght+Amat2(iq,D2_RA_RA)
              Cmat2(iq,D2_RA_GAA) = (t28*(-7.481426920246762d-1*t1*(1.24
     1           37810945273631d+0*t4*(1.4419753086419754d-1*t23*t74-1.8
     2           02469135802469d-1*t17*t74+1.6455307846020564d-2*gammaaa
     3           *t2*(3.10734375d-3*t35*t5*t64*t73-1.4565673828125d-4*ga
     4           mmaaa*t32*t33*t65*t66+1.553671875d-3*t10*t34*t35*t36+4.
     5           6610156249999996d-3*gammaaa*t12*t32*t33*t35-9.9435d-2*g
     6           ammaaa*t14*t32*t33)+4.5061728395061723d-2*t23*t43*t51*t
     7           70-3.607924604566141d-5*t29*t7-9.012345679012345d-2*t41
     8           *t42*t51-9.012345679012345d-2*t42*t43*t50+1.44197530864
     9           19754d-1*t41*t50-4.3880820922721503d-2*gammaaa*t31*t47-
     :           9.012345679012345d-2*t23*(-1.1249999999999999d-2*gammaa
     ;           a*t32*t33-1.444144833638965d-3*gammaaa*t30)*t42+1.64553
     <           07846020564d-2*t2*t37-6.887544671719978d-3*gammaaa*t32*
     =           t33-4.3880820922721503d-2*t15*t31-5.475384977410482d-5*
     >           gammaaa*t30)-8.282278392921971d-3*gammaaa*t24*t30*t71+1
     ?           .3532736462850253d-1*gammaaa*t31*t45*t52-5.074776173568
     @           845d-2*t2*t44*t45+1.3532736462850253d-1*t24*t31*t45)-9.
     1           975235893662349d-1*t27*t53)+1.4962853840493523d+0*t1*t4
     2           6*t53*t72)*wght+Cmat2(iq,D2_RA_GAA)
              Cmat2(iq,D2_GAA_GAA) = -7.481426920246762d-1*t1*t28*(3.105
     1           85439734574d-3*t24*t71*t8+1.2437810945273631d+0*t4*(1.0
     2           266346832644656d-5*t8-9.012345679012345d-2*t23*t42*(2.7
     3           0777156307306d-4*t8+5.625d-3*t33*t34)+1.441975308641975
     4           4d-1*t23*t75-1.802469135802469d-1*t17*t75+4.50617283950
     5           61723d-2*t23*t51**2*t70+1.6455307846020564d-2*gammaaa*t
     6           2*(-3.10734375d-3*t35*t62*t64*t7+1.4565673828125d-4*t33
     7           *t34*t65*t66-4.6610156249999996d-3*t12*t33*t34*t35+4.97
     8           175d-2*t14*t33*t34)+9.019811511415352d-6*gammaaa*t6-1.8
     9           02469135802469d-1*t42*t50*t51+1.4419753086419754d-1*t50
     :           **2+3.291061569204113d-2*t2*t47+3.443772335859989d-3*t3
     ;           3*t34)-1.014955234713769d-1*t2*t45*t52)*wght+1.49628538
     <           40493523d+0*t1*t53**2*t72*wght+Cmat2(iq,D2_GAA_GAA)
              Mmat2(iq,D2_RA_TA) = (-7.481426920246762d-1*t1*t28*(1.2437
     1           810945273631d+0*t4*(1.4419753086419754d-1*t23*t77-1.802
     2           469135802469d-1*t17*t77+1.6455307846020564d-2*gammaaa*t
     3           2*(-3.10734375d-3*t35*t63*t73*t76+1.4565673828125d-4*t3
     4           2*t54*t65*t66*t7-4.6610156249999996d-3*t12*t32*t35*t54*
     5           t7+9.9435d-2*t14*t32*t54*t7-1.553671875d-3*gammaaa*t33*
     6           t34*t35*t36)-2.5347222222222215d-4*t23*t34*t43*t54*t7*t
     7           70+5.069444444444443d-4*t34*t41*t42*t54*t7-1.0138888888
     8           888886d-3*t23*t32*t42*t54*t7+6.887544671719978d-3*t32*t
     9           54*t7-9.012345679012345d-2*t42*t43*t58+1.44197530864197
     :           54d-1*t41*t58-4.3880820922721503d-2*gammaaa*t31*t55)+1.
     ;           3532736462850253d-1*gammaaa*t31*t45*t59)+1.861051472698
     <           1991d+0*t1*t4*t46*t59*t72-1.2407009817987995d+0*t27*t28
     =           *t4*t59)*wght+Mmat2(iq,D2_RA_TA)
              Mmat2(iq,D2_RA_TB) = Mmat2(iq,D2_RA_TB)
              Mmat2(iq,D2_GAA_TA) = -7.481426920246762d-1*t1*t28*(1.2437
     1           810945273631d+0*t4*(1.6455307846020564d-2*gammaaa*t2*(1
     2           .553671875d-3*t33*t35*t36*t9+3.10734375d-3*t35*t5*t62*t
     3           76-1.4565673828125d-4*gammaaa*t34*t54*t65*t66+4.6610156
     4           249999996d-3*gammaaa*t12*t34*t35*t54-9.9435d-2*gammaaa*
     5           t14*t34*t54)+1.4419753086419754d-1*t23*t78-1.8024691358
     6           02469d-1*t17*t78-2.5347222222222215d-4*t23*t34*t51*t54*
     7           t7*t70+5.069444444444443d-4*t34*t42*t50*t54*t7-9.012345
     8           679012345d-2*t42*t51*t58+1.4419753086419754d-1*t50*t58+
     9           1.6455307846020564d-2*t2*t55+1.0138888888888886d-3*gamm
     :           aaa*t23*t34*t42*t54-6.887544671719978d-3*gammaaa*t34*t5
     ;           4)-5.074776173568845d-2*t2*t45*t59)*wght+1.861051472698
     <           1991d+0*t1*t4*t53*t59*t72*wght+Mmat2(iq,D2_GAA_TA)
              Mmat2(iq,D2_GAA_TB) = Mmat2(iq,D2_GAA_TB)
              Mmat2(iq,D2_TA_TA) = -9.305257363490997d-1*t1*t28*t4*(1.64
     1           55307846020564d-2*gammaaa*t2*(-3.10734375d-3*gammaaa*t3
     2           5*t36*t54*t9-3.10734375d-3*t35*t62*t63*t79+1.4565673828
     3           125d-4*t34*t64*t65*t66*t7-4.6610156249999996d-3*t12*t34
     4           *t35*t64*t7+1.491525d-1*t14*t34*t64*t7)+1.4419753086419
     5           754d-1*t23*t80-1.802469135802469d-1*t17*t80+1.425781249
     6           9999994d-6*t23*t62*t63*t70*t79-1.520833333333333d-3*t23
     7           *t34*t42*t64*t7+1.0331317007579968d-2*t34*t64*t7+1.0138
     8           888888888886d-3*t34*t42*t54*t58*t7+1.4419753086419754d-
     9           1*t58**2)*wght+2.3147406376843277d+0*t1*t59**2*t71*t72*
     :           wght+Mmat2(iq,D2_TA_TA)
              Mmat2(iq,D2_TA_TB) = Mmat2(iq,D2_TA_TB)
              Mmat2(iq,D2_TB_TB) = Mmat2(iq,D2_TB_TB)
            elseif (taua.le.tol_rho.and.taub.gt.tol_rho) then 
              t1 = rhoa**1.3333333333333333d+0
              t2 = 1/rhoa**1.6666666666666669d+0
              t3 = 1.0970205230680374d-51*t2-1.0d+0
              t4 = 4.3880820922721503d-52*t2*t3+1.0d+0
              t5 = 1/t4**5.0d-1
              t6 = 4.5d-1*t3*t5+4.3880820922721503d-52*t2
              t7 = 1/rhoa**3.3333333333333337d+0
              t8 = 2.166217250458448d-103*t7+4.4999999999999996d-2
              t9 = t8**5.0d-1
              t10 = -1.802469135802469d-1*t6*t9+8.213077466115726d-105*t
     1           7+7.209876543209877d-2*t6**2+2.4881109353903252d-52*t2+
     2           9.621132278843042d-155/rhoa**5+2.755017868687991d-2
              t11 = 8.160240087098705d-52*t2+1.0d+0
              t12 = 1/t11**2.0d+0
              t13 = 1.2437810945273631d+0*t10*t12+1.0d+0
              t14 = 8.04d-1-8.04d-1/t13
              t15 = rhoa**3.333333333333333d-1
              t16 = 1/t13**2
              t17 = 1/rhoa**4.333333333333333d+0
              t18 = 1/t9
              t19 = 1/rhoa**2.6666666666666666d+0
              t20 = -7.313470153786917d-52*t19*t3-8.023026853549804d-103
     1           *t17
              t21 = 1/t4**1.5d+0
              t22 = -8.227653923010281d-52*t19*t5-2.25d-1*t20*t21*t3-7.3
     1           13470153786917d-52*t19
              t23 = -1.802469135802469d-1*t22*t9+1.4419753086419754d-1*t
     1           22*t6+6.507566225657065d-104*t17*t18*t6-4.1468515589838
     2           76d-52*t19-2.737692488705242d-104*t17-4.810566139421521
     3           d-154/rhoa**6
              t24 = 1/t11**3.0d+0
              t25 = 3.3831841157125636d-51*t10*t19*t24+1.243781094527363
     1           1d+0*t12*t23
              t26 = 1/rhoa**5.333333333333333d+0
              t27 = 1/rhoa**3.6666666666666664d+0
              t28 = 2.194041046136075d-51*t27*t5+3.375d-1*t20**2*t3/t4**
     1           2.5d+0-2.25d-1*t21*t3*(1.9502587076765113d-51*t27*t3+4.
     2           8138161121298817d-102*t26)+1.9502587076765113d-51*t27+8
     3           .227653923010281d-52*t19*t20*t21
              fnc(iq) = (-9.305257363490997d-1*t1*t14-9.305257363490997d
     1           -1*t1)*wght+fnc(iq)
              Amat(iq,D1_RA) = (-7.481426920246762d-1*t1*t16*t25-1.24070
     1           09817987995d+0*t14*t15-1.2407009817987995d+0*t15)*wght+
     2           Amat(iq,D1_RA)
              Cmat(iq,D1_GAA) = Cmat(iq,D1_GAA)
              Mmat(iq,D1_TA) = Mmat(iq,D1_TA)
              Mmat(iq,D1_TB) = Mmat(iq,D1_TB)
              Amat2(iq,D2_RA_RA) = (t16*(-7.481426920246762d-1*t1*(1.243
     1           7810945273631d+0*t12*(-1.802469135802469d-1*t28*t9+2.34
     2           9467036086518d-206*t6/(rhoa**8.666666666666666d+0*t8**1
     3           .5d+0)+1.4419753086419754d-1*t28*t6-2.8199453644513944d
     4           -103*t18*t26*t6+1.1058270823957002d-51*t27+1.1863334117
     5           722714d-103*t26+1.4419753086419754d-1*t22**2+1.30151324
     6           5131413d-103*t17*t18*t22+2.886339683652913d-153/rhoa**7
     7           )-9.021824308566837d-51*t10*t24*t27+1.3803797321536623d
     8           -101*t10*t26/t11**4.0d+0+6.766368231425127d-51*t19*t23*
     9           t24)-1.9950471787324697d+0*t15*t25)+1.4962853840493523d
     :           +0*t1*t25**2/t13**3+(-4.1356699393293317d-1*t14-4.13566
     ;           99393293317d-1)/rhoa**6.666666666666666d-1)*wght+Amat2(
     <           iq,D2_RA_RA)
              Cmat2(iq,D2_RA_GAA) = Cmat2(iq,D2_RA_GAA)
              Cmat2(iq,D2_GAA_GAA) = Cmat2(iq,D2_GAA_GAA)
              Mmat2(iq,D2_RA_TA) = Mmat2(iq,D2_RA_TA)
              Mmat2(iq,D2_RA_TB) = Mmat2(iq,D2_RA_TB)
              Mmat2(iq,D2_GAA_TA) = Mmat2(iq,D2_GAA_TA)
              Mmat2(iq,D2_GAA_TB) = Mmat2(iq,D2_GAA_TB)
              Mmat2(iq,D2_TA_TA) = Mmat2(iq,D2_TA_TA)
              Mmat2(iq,D2_TA_TB) = Mmat2(iq,D2_TA_TB)
              Mmat2(iq,D2_TB_TB) = Mmat2(iq,D2_TB_TB)
            else 
              t1 = rhoa**1.3333333333333333d+0
              t2 = 1/rhoa**1.6666666666666669d+0
              t3 = 1.0970205230680374d-51*t2-1.0d+0
              t4 = 4.3880820922721503d-52*t2*t3+1.0d+0
              t5 = 1/t4**5.0d-1
              t6 = 4.5d-1*t3*t5+4.3880820922721503d-52*t2
              t7 = 1/rhoa**3.3333333333333337d+0
              t8 = 2.166217250458448d-103*t7+4.4999999999999996d-2
              t9 = t8**5.0d-1
              t10 = -1.802469135802469d-1*t6*t9+8.213077466115726d-105*t
     1           7+7.209876543209877d-2*t6**2+2.4881109353903252d-52*t2+
     2           9.621132278843042d-155/rhoa**5+2.755017868687991d-2
              t11 = 8.160240087098705d-52*t2+1.0d+0
              t12 = 1/t11**2.0d+0
              t13 = 1.2437810945273631d+0*t10*t12+1.0d+0
              t14 = 8.04d-1-8.04d-1/t13
              t15 = rhoa**3.333333333333333d-1
              t16 = 1/t13**2
              t17 = 1/rhoa**4.333333333333333d+0
              t18 = 1/t9
              t19 = 1/rhoa**2.6666666666666666d+0
              t20 = -7.313470153786917d-52*t19*t3-8.023026853549804d-103
     1           *t17
              t21 = 1/t4**1.5d+0
              t22 = -8.227653923010281d-52*t19*t5-2.25d-1*t20*t21*t3-7.3
     1           13470153786917d-52*t19
              t23 = -1.802469135802469d-1*t22*t9+1.4419753086419754d-1*t
     1           22*t6+6.507566225657065d-104*t17*t18*t6-4.1468515589838
     2           76d-52*t19-2.737692488705242d-104*t17-4.810566139421521
     3           d-154/rhoa**6
              t24 = 1/t11**3.0d+0
              t25 = 3.3831841157125636d-51*t10*t19*t24+1.243781094527363
     1           1d+0*t12*t23
              t26 = 1/rhoa**5.333333333333333d+0
              t27 = 1/rhoa**3.6666666666666664d+0
              t28 = 2.194041046136075d-51*t27*t5+3.375d-1*t20**2*t3/t4**
     1           2.5d+0-2.25d-1*t21*t3*(1.9502587076765113d-51*t27*t3+4.
     2           8138161121298817d-102*t26)+1.9502587076765113d-51*t27+8
     3           .227653923010281d-52*t19*t20*t21
              fnc(iq) = (-9.305257363490997d-1*t1*t14-9.305257363490997d
     1           -1*t1)*wght+fnc(iq)
              Amat(iq,D1_RA) = (-7.481426920246762d-1*t1*t16*t25-1.24070
     1           09817987995d+0*t14*t15-1.2407009817987995d+0*t15)*wght+
     2           Amat(iq,D1_RA)
              Cmat(iq,D1_GAA) = Cmat(iq,D1_GAA)
              Mmat(iq,D1_TA) = Mmat(iq,D1_TA)
              Mmat(iq,D1_TB) = Mmat(iq,D1_TB)
              Amat2(iq,D2_RA_RA) = (t16*(-7.481426920246762d-1*t1*(1.243
     1           7810945273631d+0*t12*(-1.802469135802469d-1*t28*t9+2.34
     2           9467036086518d-206*t6/(rhoa**8.666666666666666d+0*t8**1
     3           .5d+0)+1.4419753086419754d-1*t28*t6-2.8199453644513944d
     4           -103*t18*t26*t6+1.1058270823957002d-51*t27+1.1863334117
     5           722714d-103*t26+1.4419753086419754d-1*t22**2+1.30151324
     6           5131413d-103*t17*t18*t22+2.886339683652913d-153/rhoa**7
     7           )-9.021824308566837d-51*t10*t24*t27+1.3803797321536623d
     8           -101*t10*t26/t11**4.0d+0+6.766368231425127d-51*t19*t23*
     9           t24)-1.9950471787324697d+0*t15*t25)+1.4962853840493523d
     :           +0*t1*t25**2/t13**3+(-4.1356699393293317d-1*t14-4.13566
     ;           99393293317d-1)/rhoa**6.666666666666666d-1)*wght+Amat2(
     <           iq,D2_RA_RA)
              Cmat2(iq,D2_RA_GAA) = Cmat2(iq,D2_RA_GAA)
              Cmat2(iq,D2_GAA_GAA) = Cmat2(iq,D2_GAA_GAA)
              Mmat2(iq,D2_RA_TA) = Mmat2(iq,D2_RA_TA)
              Mmat2(iq,D2_RA_TB) = Mmat2(iq,D2_RA_TB)
              Mmat2(iq,D2_GAA_TA) = Mmat2(iq,D2_GAA_TA)
              Mmat2(iq,D2_GAA_TB) = Mmat2(iq,D2_GAA_TB)
              Mmat2(iq,D2_TA_TA) = Mmat2(iq,D2_TA_TA)
              Mmat2(iq,D2_TA_TB) = Mmat2(iq,D2_TA_TB)
              Mmat2(iq,D2_TB_TB) = Mmat2(iq,D2_TB_TB)
            endif 
          elseif (rhoa.le.tol_rho.and.rhob.gt.tol_rho) then 
            if (taua.gt.tol_rho.and.taub.gt.tol_rho) then 
              t1 = rhob**1.3333333333333333d+0
              t2 = 1/rhob**2.6666666666666666d+0
              t3 = 2.040060021774676d-2*gammabb*t2+1.0d+0
              t4 = 1/t3**2.0d+0
              t5 = gammabb**3
              t6 = 1/rhob**8
              t7 = gammabb**2
              t8 = 1/rhob**5.333333333333333d+0
              t9 = 1/rhob
              t10 = 1/taub
              t11 = gammabb*t10*t9
              t12 = t11**2.0d+0
              t13 = 1.5625d-2*t12+1.0d+0
              t14 = 1/t13**2.0d+0
              t15 = 2.485875d-2*t12*t14+1.234567901234568d-1
              t16 = 1.35388578153653d-4*t7*t8+2.8125d-3*t12
              t17 = t16**5.0d-1
              t18 = 1/rhob**1.6666666666666669d+0
              t19 = 2.0d+0*taub-2.5d-1*gammabb*t9
              t20 = 1.0970205230680374d-1*t18*t19-1.0d+0
              t21 = 4.38808209227215d-2*t18*t19*t20+1.0d+0
              t22 = 1/t21**5.0d-1
              t23 = 4.5d-1*t20*t22+1.0970205230680376d-2*gammabb*t2
              t24 = 5.133173416322327d-6*t7*t8+1.5033019185692253d-6*t5*
     1           t6+7.209876543209877d-2*t23**2-1.802469135802469d-1*t17
     2           *t23+1.6455307846020564d-2*gammabb*t15*t2+1.72188616792
     3           99946d-3*t12
              t25 = 1.2437810945273631d+0*t24*t4+1.0d+0
              t26 = 8.04d-1-8.04d-1/t25
              t27 = rhob**3.333333333333333d-1
              t28 = 1/t25**2
              t29 = 1/rhob**9
              t30 = 1/rhob**6.333333333333333d+0
              t31 = 1/rhob**3.6666666666666664d+0
              t32 = 1/rhob**3
              t33 = 1/taub**2
              t34 = 1/rhob**2
              t35 = 1/t13**3.0d+0
              t36 = t11**3.0d+0
              t37 = 1.553671875d-3*gammabb*t10*t34*t35*t36-4.97175d-2*t1
     1           4*t32*t33*t7
              t38 = 2.7425513076700936d-2*gammabb*t31-1.828367538446729d
     1           -1*t19*t2
              t39 = 4.38808209227215d-2*t18*t19*t38+1.0970205230680374d-
     1           2*gammabb*t20*t31-7.313470153786916d-2*t19*t2*t20
              t40 = 1/t21**1.5d+0
              t41 = -2.25d-1*t20*t39*t40+4.5d-1*t22*t38-2.92538806151476
     1           7d-2*gammabb*t31
              t42 = 1/t17
              t43 = -5.625d-3*t32*t33*t7-7.220724168194825d-4*t30*t7
              t44 = -3.443772335859989d-3*t32*t33*t7-2.737692488705241d-
     1           5*t30*t7-1.2026415348553804d-5*t29*t5-9.012345679012345
     2           d-2*t23*t42*t43+1.4419753086419754d-1*t23*t41-1.8024691
     3           35802469d-1*t17*t41+1.6455307846020564d-2*gammabb*t2*t3
     4           7-4.3880820922721503d-2*gammabb*t15*t31
              t45 = 1/t3**3.0d+0
              t46 = 1.3532736462850253d-1*gammabb*t24*t31*t45+1.24378109
     1           45273631d+0*t4*t44
              t47 = 4.97175d-2*gammabb*t14*t33*t34-1.553671875d-3*t10*t3
     1           5*t36*t9
              t48 = 1/rhob**4.333333333333333d+0
              t49 = -1.2034540280324706d-3*t19*t48-1.0970205230680374d-2
     1           *t2*t20
              t50 = -2.25d-1*t20*t40*t49-1.2341480884515421d-2*t2*t22+1.
     1           0970205230680376d-2*t2
              t51 = 2.70777156307306d-4*gammabb*t8+5.625d-3*gammabb*t33*
     1           t34
              t52 = 1.0266346832644656d-5*gammabb*t8+4.509905755707676d-
     1           6*t6*t7-9.012345679012345d-2*t23*t42*t51+1.441975308641
     2           9754d-1*t23*t50-1.802469135802469d-1*t17*t50+1.64553078
     3           46020564d-2*gammabb*t2*t47+3.443772335859989d-3*gammabb
     4           *t33*t34+1.6455307846020564d-2*t15*t2
              t53 = 1.2437810945273631d+0*t4*t52-5.074776173568845d-2*t2
     1           *t24*t45
              t54 = 1/taub**3
              t55 = 1.553671875d-3*gammabb*t33*t35*t36*t9-4.97175d-2*t14
     1           *t34*t54*t7
              t56 = 1/rhob**3.3333333333333337d+0
              t57 = 9.627632224259765d-3*t19*t56+8.7761641845443d-2*t18*
     1           t20
              t58 = 9.873184707612337d-2*t18*t22-2.25d-1*t20*t40*t57
              t59 = 5.069444444444443d-4*t23*t34*t42*t54*t7-3.4437723358
     1           59989d-3*t34*t54*t7+1.4419753086419754d-1*t23*t58-1.802
     2           469135802469d-1*t17*t58+1.6455307846020564d-2*gammabb*t
     3           2*t55
              t60 = 1/rhob**7.333333333333333d+0
              t61 = 1/rhob**4.666666666666667d+0
              t62 = 1/rhob**4
              t63 = gammabb**4
              t64 = 1/taub**4
              t65 = 1/t13**4.0d+0
              t66 = t11**4.0d+0
              t67 = 1/t21**2.5d+0
              t68 = 4.8756467691912775d-1*t19*t31-1.4626940307573832d-1*
     1           gammabb*t61
              t69 = -2.25d-1*t20*t40*(4.38808209227215d-2*t18*t19*t68-5.
     1           850776123029533d-2*gammabb*t20*t61+2.194041046136075d-2
     2           *gammabb*t31*t38-1.4626940307573832d-1*t19*t2*t38+1.950
     3           258707676511d-1*t19*t20*t31)+4.5d-1*t22*t68+3.375d-1*t2
     4           0*t39**2*t67+1.0726422892220812d-1*gammabb*t61-4.5d-1*t
     5           38*t39*t40
              t70 = 1/t16**1.5d+0
              t71 = 1/t3**4.0d+0
              t72 = 1/t25**3
              t73 = 1/rhob**5
              t74 = -2.25d-1*t20*t40*(5.214967454807371d-3*t19*t8-1.0970
     1           205230680374d-2*t2*t38+2.9253880615147665d-2*t20*t31-3.
     2           0086350700811765d-4*gammabb*t30)+3.375d-1*t20*t39*t49*t
     3           67-2.25d-1*t38*t40*t49+6.170740442257711d-3*t2*t39*t40+
     4           3.2910615692041123d-2*t22*t31-2.925388061514767d-2*t31
              t75 = -1.3538857815365296d-4*t20*t40*t8+3.375d-1*t20*t49**
     1           2*t67+1.2341480884515421d-2*t2*t40*t49
              t76 = 1/taub**5
              t77 = -2.25d-1*t20*t40*(2.406908056064941d-3*gammabb*t8-3.
     1           209210741419921d-2*t19*t48+8.7761641845443d-2*t18*t38-1
     2           .4626940307573832d-1*t2*t20)+3.375d-1*t20*t39*t57*t67-2
     3           .25d-1*t38*t40*t57-4.9365923538061685d-2*t18*t39*t40-1.
     4           6455307846020562d-1*t2*t22
              t78 = 3.375d-1*t20*t49*t57*t67+6.170740442257711d-3*t2*t40
     1           *t57-4.9365923538061685d-2*t18*t40*t49+1.08310862522922
     2           35d-3*t20*t40*t48
              t79 = 1/taub**6
              t80 = 3.375d-1*t20*t57**2*t67-9.873184707612337d-2*t18*t40
     1           *t57-8.664869001833788d-3*t20*t40*t56
              fnc(iq) = (-9.305257363490997d-1*t1*t26-9.305257363490997d
     1           -1*t1)*wght+fnc(iq)
              Amat(iq,D1_RB) = (-7.481426920246762d-1*t1*t28*t46-1.24070
     1           09817987995d+0*t26*t27-1.2407009817987995d+0*t27)*wght+
     2           Amat(iq,D1_RB)
              Cmat(iq,D1_GBB) = Cmat(iq,D1_GBB)-7.481426920246762d-1*t1*
     1           t28*t53*wght
              Mmat(iq,D1_TB) = Mmat(iq,D1_TB)-9.305257363490997d-1*t1*t2
     1           8*t4*t59*wght
              Mmat(iq,D1_TA) = Mmat(iq,D1_TA)
              Amat2(iq,D2_RB_RB) = (1.4962853840493523d+0*t1*t46**2*t72+
     1           t28*(-7.481426920246762d-1*t1*(2.208607571445859d-2*t24
     2           *t60*t7*t71+1.2437810945273631d+0*t4*(4.506172839506172
     3           3d-2*t23*t43**2*t70+1.6455307846020564d-2*gammabb*t2*(1
     4           .4565673828125d-4*t33*t62*t65*t66*t7-4.6610156249999996
     5           d-3*t12*t33*t35*t62*t7+1.491525d-1*t14*t33*t62*t7-3.107
     6           34375d-3*t35*t63*t64/rhob**6-3.10734375d-3*gammabb*t10*
     7           t32*t35*t36)-9.012345679012345d-2*t23*t42*(1.6875d-2*t3
     8           3*t62*t7+4.573125306523389d-3*t60*t7)+1.033131700757996
     9           8d-2*t33*t62*t7+1.7338719095133195d-4*t60*t7+1.44197530
     :           86419754d-1*t23*t69-1.802469135802469d-1*t17*t69+1.6089
     ;           634338331218d-1*gammabb*t15*t61+1.0823773813698423d-4*t
     <           5/rhob**10-1.802469135802469d-1*t41*t42*t43+1.441975308
     =           6419754d-1*t41**2-8.776164184544301d-2*gammabb*t31*t37)
     >           -4.9620033697117594d-1*gammabb*t24*t45*t61+2.7065472925
     ?           700507d-1*gammabb*t31*t44*t45)-1.9950471787324697d+0*t2
     @           7*t46)+(-4.1356699393293317d-1*t26-4.1356699393293317d-
     1           1)/rhob**6.666666666666666d-1)*wght+Amat2(iq,D2_RB_RB)
              Cmat2(iq,D2_RB_GBB) = (t28*(-7.481426920246762d-1*t1*(1.24
     1           37810945273631d+0*t4*(1.4419753086419754d-1*t23*t74-1.8
     2           02469135802469d-1*t17*t74+1.6455307846020564d-2*gammabb
     3           *t2*(3.10734375d-3*t35*t5*t64*t73-1.4565673828125d-4*ga
     4           mmabb*t32*t33*t65*t66+1.553671875d-3*t10*t34*t35*t36+4.
     5           6610156249999996d-3*gammabb*t12*t32*t33*t35-9.9435d-2*g
     6           ammabb*t14*t32*t33)+4.5061728395061723d-2*t23*t43*t51*t
     7           70-3.607924604566141d-5*t29*t7-9.012345679012345d-2*t41
     8           *t42*t51-9.012345679012345d-2*t42*t43*t50+1.44197530864
     9           19754d-1*t41*t50-4.3880820922721503d-2*gammabb*t31*t47-
     :           9.012345679012345d-2*t23*(-1.1249999999999999d-2*gammab
     ;           b*t32*t33-1.444144833638965d-3*gammabb*t30)*t42+1.64553
     <           07846020564d-2*t2*t37-6.887544671719978d-3*gammabb*t32*
     =           t33-4.3880820922721503d-2*t15*t31-5.475384977410482d-5*
     >           gammabb*t30)-8.282278392921971d-3*gammabb*t24*t30*t71+1
     ?           .3532736462850253d-1*gammabb*t31*t45*t52-5.074776173568
     @           845d-2*t2*t44*t45+1.3532736462850253d-1*t24*t31*t45)-9.
     1           975235893662349d-1*t27*t53)+1.4962853840493523d+0*t1*t4
     2           6*t53*t72)*wght+Cmat2(iq,D2_RB_GBB)
              Cmat2(iq,D2_GBB_GBB) = -7.481426920246762d-1*t1*t28*(3.105
     1           85439734574d-3*t24*t71*t8+1.2437810945273631d+0*t4*(1.0
     2           266346832644656d-5*t8-9.012345679012345d-2*t23*t42*(2.7
     3           0777156307306d-4*t8+5.625d-3*t33*t34)+1.441975308641975
     4           4d-1*t23*t75-1.802469135802469d-1*t17*t75+4.50617283950
     5           61723d-2*t23*t51**2*t70+1.6455307846020564d-2*gammabb*t
     6           2*(-3.10734375d-3*t35*t62*t64*t7+1.4565673828125d-4*t33
     7           *t34*t65*t66-4.6610156249999996d-3*t12*t33*t34*t35+4.97
     8           175d-2*t14*t33*t34)+9.019811511415352d-6*gammabb*t6-1.8
     9           02469135802469d-1*t42*t50*t51+1.4419753086419754d-1*t50
     :           **2+3.291061569204113d-2*t2*t47+3.443772335859989d-3*t3
     ;           3*t34)-1.014955234713769d-1*t2*t45*t52)*wght+1.49628538
     <           40493523d+0*t1*t53**2*t72*wght+Cmat2(iq,D2_GBB_GBB)
              Mmat2(iq,D2_RB_TA) = Mmat2(iq,D2_RB_TA)
              Mmat2(iq,D2_RB_TB) = (-7.481426920246762d-1*t1*t28*(1.2437
     1           810945273631d+0*t4*(1.4419753086419754d-1*t23*t77-1.802
     2           469135802469d-1*t17*t77+1.6455307846020564d-2*gammabb*t
     3           2*(-3.10734375d-3*t35*t63*t73*t76+1.4565673828125d-4*t3
     4           2*t54*t65*t66*t7-4.6610156249999996d-3*t12*t32*t35*t54*
     5           t7+9.9435d-2*t14*t32*t54*t7-1.553671875d-3*gammabb*t33*
     6           t34*t35*t36)-2.5347222222222215d-4*t23*t34*t43*t54*t7*t
     7           70+5.069444444444443d-4*t34*t41*t42*t54*t7-1.0138888888
     8           888886d-3*t23*t32*t42*t54*t7+6.887544671719978d-3*t32*t
     9           54*t7-9.012345679012345d-2*t42*t43*t58+1.44197530864197
     :           54d-1*t41*t58-4.3880820922721503d-2*gammabb*t31*t55)+1.
     ;           3532736462850253d-1*gammabb*t31*t45*t59)+1.861051472698
     <           1991d+0*t1*t4*t46*t59*t72-1.2407009817987995d+0*t27*t28
     =           *t4*t59)*wght+Mmat2(iq,D2_RB_TB)
              Mmat2(iq,D2_GBB_TA) = Mmat2(iq,D2_GBB_TA)
              Mmat2(iq,D2_GBB_TB) = -7.481426920246762d-1*t1*t28*(1.2437
     1           810945273631d+0*t4*(1.6455307846020564d-2*gammabb*t2*(1
     2           .553671875d-3*t33*t35*t36*t9+3.10734375d-3*t35*t5*t62*t
     3           76-1.4565673828125d-4*gammabb*t34*t54*t65*t66+4.6610156
     4           249999996d-3*gammabb*t12*t34*t35*t54-9.9435d-2*gammabb*
     5           t14*t34*t54)+1.4419753086419754d-1*t23*t78-1.8024691358
     6           02469d-1*t17*t78-2.5347222222222215d-4*t23*t34*t51*t54*
     7           t7*t70+5.069444444444443d-4*t34*t42*t50*t54*t7-9.012345
     8           679012345d-2*t42*t51*t58+1.4419753086419754d-1*t50*t58+
     9           1.6455307846020564d-2*t2*t55+1.0138888888888886d-3*gamm
     :           abb*t23*t34*t42*t54-6.887544671719978d-3*gammabb*t34*t5
     ;           4)-5.074776173568845d-2*t2*t45*t59)*wght+1.861051472698
     <           1991d+0*t1*t4*t53*t59*t72*wght+Mmat2(iq,D2_GBB_TB)
              Mmat2(iq,D2_TA_TA) = Mmat2(iq,D2_TA_TA)
              Mmat2(iq,D2_TA_TB) = Mmat2(iq,D2_TA_TB)
              Mmat2(iq,D2_TB_TB) = -9.305257363490997d-1*t1*t28*t4*(1.64
     1           55307846020564d-2*gammabb*t2*(-3.10734375d-3*gammabb*t3
     2           5*t36*t54*t9-3.10734375d-3*t35*t62*t63*t79+1.4565673828
     3           125d-4*t34*t64*t65*t66*t7-4.6610156249999996d-3*t12*t34
     4           *t35*t64*t7+1.491525d-1*t14*t34*t64*t7)+1.4419753086419
     5           754d-1*t23*t80-1.802469135802469d-1*t17*t80+1.425781249
     6           9999994d-6*t23*t62*t63*t70*t79-1.520833333333333d-3*t23
     7           *t34*t42*t64*t7+1.0331317007579968d-2*t34*t64*t7+1.0138
     8           888888888886d-3*t34*t42*t54*t58*t7+1.4419753086419754d-
     9           1*t58**2)*wght+2.3147406376843277d+0*t1*t59**2*t71*t72*
     :           wght+Mmat2(iq,D2_TB_TB)
            elseif (taua.gt.tol_rho.and.taub.le.tol_rho) then 
              t1 = rhob**1.3333333333333333d+0
              t2 = 1/rhob**1.6666666666666669d+0
              t3 = 1.0970205230680374d-51*t2-1.0d+0
              t4 = 4.3880820922721503d-52*t2*t3+1.0d+0
              t5 = 1/t4**5.0d-1
              t6 = 4.5d-1*t3*t5+4.3880820922721503d-52*t2
              t7 = 1/rhob**3.3333333333333337d+0
              t8 = 2.166217250458448d-103*t7+4.4999999999999996d-2
              t9 = t8**5.0d-1
              t10 = -1.802469135802469d-1*t6*t9+8.213077466115726d-105*t
     1           7+7.209876543209877d-2*t6**2+2.4881109353903252d-52*t2+
     2           9.621132278843042d-155/rhob**5+2.755017868687991d-2
              t11 = 8.160240087098705d-52*t2+1.0d+0
              t12 = 1/t11**2.0d+0
              t13 = 1.2437810945273631d+0*t10*t12+1.0d+0
              t14 = 8.04d-1-8.04d-1/t13
              t15 = rhob**3.333333333333333d-1
              t16 = 1/t13**2
              t17 = 1/rhob**4.333333333333333d+0
              t18 = 1/t9
              t19 = 1/rhob**2.6666666666666666d+0
              t20 = -7.313470153786917d-52*t19*t3-8.023026853549804d-103
     1           *t17
              t21 = 1/t4**1.5d+0
              t22 = -8.227653923010281d-52*t19*t5-2.25d-1*t20*t21*t3-7.3
     1           13470153786917d-52*t19
              t23 = -1.802469135802469d-1*t22*t9+1.4419753086419754d-1*t
     1           22*t6+6.507566225657065d-104*t17*t18*t6-4.1468515589838
     2           76d-52*t19-2.737692488705242d-104*t17-4.810566139421521
     3           d-154/rhob**6
              t24 = 1/t11**3.0d+0
              t25 = 3.3831841157125636d-51*t10*t19*t24+1.243781094527363
     1           1d+0*t12*t23
              t26 = 1/rhob**5.333333333333333d+0
              t27 = 1/rhob**3.6666666666666664d+0
              t28 = 2.194041046136075d-51*t27*t5+3.375d-1*t20**2*t3/t4**
     1           2.5d+0-2.25d-1*t21*t3*(1.9502587076765113d-51*t27*t3+4.
     2           8138161121298817d-102*t26)+1.9502587076765113d-51*t27+8
     3           .227653923010281d-52*t19*t20*t21
              fnc(iq) = (-9.305257363490997d-1*t1*t14-9.305257363490997d
     1           -1*t1)*wght+fnc(iq)
              Amat(iq,D1_RB) = (-7.481426920246762d-1*t1*t16*t25-1.24070
     1           09817987995d+0*t14*t15-1.2407009817987995d+0*t15)*wght+
     2           Amat(iq,D1_RB)
              Cmat(iq,D1_GBB) = Cmat(iq,D1_GBB)
              Mmat(iq,D1_TB) = Mmat(iq,D1_TB)
              Mmat(iq,D1_TA) = Mmat(iq,D1_TA)
              Amat2(iq,D2_RB_RB) = (t16*(-7.481426920246762d-1*t1*(1.243
     1           7810945273631d+0*t12*(-1.802469135802469d-1*t28*t9+2.34
     2           9467036086518d-206*t6/(rhob**8.666666666666666d+0*t8**1
     3           .5d+0)+1.4419753086419754d-1*t28*t6-2.8199453644513944d
     4           -103*t18*t26*t6+1.1058270823957002d-51*t27+1.1863334117
     5           722714d-103*t26+1.4419753086419754d-1*t22**2+1.30151324
     6           5131413d-103*t17*t18*t22+2.886339683652913d-153/rhob**7
     7           )-9.021824308566837d-51*t10*t24*t27+1.3803797321536623d
     8           -101*t10*t26/t11**4.0d+0+6.766368231425127d-51*t19*t23*
     9           t24)-1.9950471787324697d+0*t15*t25)+1.4962853840493523d
     :           +0*t1*t25**2/t13**3+(-4.1356699393293317d-1*t14-4.13566
     ;           99393293317d-1)/rhob**6.666666666666666d-1)*wght+Amat2(
     <           iq,D2_RB_RB)
              Cmat2(iq,D2_RB_GBB) = Cmat2(iq,D2_RB_GBB)
              Cmat2(iq,D2_GBB_GBB) = Cmat2(iq,D2_GBB_GBB)
              Mmat2(iq,D2_RB_TA) = Mmat2(iq,D2_RB_TA)
              Mmat2(iq,D2_RB_TB) = Mmat2(iq,D2_RB_TB)
              Mmat2(iq,D2_GBB_TA) = Mmat2(iq,D2_GBB_TA)
              Mmat2(iq,D2_GBB_TB) = Mmat2(iq,D2_GBB_TB)
              Mmat2(iq,D2_TA_TA) = Mmat2(iq,D2_TA_TA)
              Mmat2(iq,D2_TA_TB) = Mmat2(iq,D2_TA_TB)
              Mmat2(iq,D2_TB_TB) = Mmat2(iq,D2_TB_TB)
            elseif (taua.le.tol_rho.and.taub.gt.tol_rho) then 
              t1 = rhob**1.3333333333333333d+0
              t2 = 1/rhob**2.6666666666666666d+0
              t3 = 2.040060021774676d-2*gammabb*t2+1.0d+0
              t4 = 1/t3**2.0d+0
              t5 = gammabb**3
              t6 = 1/rhob**8
              t7 = gammabb**2
              t8 = 1/rhob**5.333333333333333d+0
              t9 = 1/rhob
              t10 = 1/taub
              t11 = gammabb*t10*t9
              t12 = t11**2.0d+0
              t13 = 1.5625d-2*t12+1.0d+0
              t14 = 1/t13**2.0d+0
              t15 = 2.485875d-2*t12*t14+1.234567901234568d-1
              t16 = 1.35388578153653d-4*t7*t8+2.8125d-3*t12
              t17 = t16**5.0d-1
              t18 = 1/rhob**1.6666666666666669d+0
              t19 = 2.0d+0*taub-2.5d-1*gammabb*t9
              t20 = 1.0970205230680374d-1*t18*t19-1.0d+0
              t21 = 4.38808209227215d-2*t18*t19*t20+1.0d+0
              t22 = 1/t21**5.0d-1
              t23 = 4.5d-1*t20*t22+1.0970205230680376d-2*gammabb*t2
              t24 = 5.133173416322327d-6*t7*t8+1.5033019185692253d-6*t5*
     1           t6+7.209876543209877d-2*t23**2-1.802469135802469d-1*t17
     2           *t23+1.6455307846020564d-2*gammabb*t15*t2+1.72188616792
     3           99946d-3*t12
              t25 = 1.2437810945273631d+0*t24*t4+1.0d+0
              t26 = 8.04d-1-8.04d-1/t25
              t27 = rhob**3.333333333333333d-1
              t28 = 1/t25**2
              t29 = 1/rhob**9
              t30 = 1/rhob**6.333333333333333d+0
              t31 = 1/rhob**3.6666666666666664d+0
              t32 = 1/rhob**3
              t33 = 1/taub**2
              t34 = 1/rhob**2
              t35 = 1/t13**3.0d+0
              t36 = t11**3.0d+0
              t37 = 1.553671875d-3*gammabb*t10*t34*t35*t36-4.97175d-2*t1
     1           4*t32*t33*t7
              t38 = 2.7425513076700936d-2*gammabb*t31-1.828367538446729d
     1           -1*t19*t2
              t39 = 4.38808209227215d-2*t18*t19*t38+1.0970205230680374d-
     1           2*gammabb*t20*t31-7.313470153786916d-2*t19*t2*t20
              t40 = 1/t21**1.5d+0
              t41 = -2.25d-1*t20*t39*t40+4.5d-1*t22*t38-2.92538806151476
     1           7d-2*gammabb*t31
              t42 = 1/t17
              t43 = -5.625d-3*t32*t33*t7-7.220724168194825d-4*t30*t7
              t44 = -3.443772335859989d-3*t32*t33*t7-2.737692488705241d-
     1           5*t30*t7-1.2026415348553804d-5*t29*t5-9.012345679012345
     2           d-2*t23*t42*t43+1.4419753086419754d-1*t23*t41-1.8024691
     3           35802469d-1*t17*t41+1.6455307846020564d-2*gammabb*t2*t3
     4           7-4.3880820922721503d-2*gammabb*t15*t31
              t45 = 1/t3**3.0d+0
              t46 = 1.3532736462850253d-1*gammabb*t24*t31*t45+1.24378109
     1           45273631d+0*t4*t44
              t47 = 4.97175d-2*gammabb*t14*t33*t34-1.553671875d-3*t10*t3
     1           5*t36*t9
              t48 = 1/rhob**4.333333333333333d+0
              t49 = -1.2034540280324706d-3*t19*t48-1.0970205230680374d-2
     1           *t2*t20
              t50 = -2.25d-1*t20*t40*t49-1.2341480884515421d-2*t2*t22+1.
     1           0970205230680376d-2*t2
              t51 = 2.70777156307306d-4*gammabb*t8+5.625d-3*gammabb*t33*
     1           t34
              t52 = 1.0266346832644656d-5*gammabb*t8+4.509905755707676d-
     1           6*t6*t7-9.012345679012345d-2*t23*t42*t51+1.441975308641
     2           9754d-1*t23*t50-1.802469135802469d-1*t17*t50+1.64553078
     3           46020564d-2*gammabb*t2*t47+3.443772335859989d-3*gammabb
     4           *t33*t34+1.6455307846020564d-2*t15*t2
              t53 = 1.2437810945273631d+0*t4*t52-5.074776173568845d-2*t2
     1           *t24*t45
              t54 = 1/taub**3
              t55 = 1.553671875d-3*gammabb*t33*t35*t36*t9-4.97175d-2*t14
     1           *t34*t54*t7
              t56 = 1/rhob**3.3333333333333337d+0
              t57 = 9.627632224259765d-3*t19*t56+8.7761641845443d-2*t18*
     1           t20
              t58 = 9.873184707612337d-2*t18*t22-2.25d-1*t20*t40*t57
              t59 = 5.069444444444443d-4*t23*t34*t42*t54*t7-3.4437723358
     1           59989d-3*t34*t54*t7+1.4419753086419754d-1*t23*t58-1.802
     2           469135802469d-1*t17*t58+1.6455307846020564d-2*gammabb*t
     3           2*t55
              t60 = 1/rhob**7.333333333333333d+0
              t61 = 1/rhob**4.666666666666667d+0
              t62 = 1/rhob**4
              t63 = gammabb**4
              t64 = 1/taub**4
              t65 = 1/t13**4.0d+0
              t66 = t11**4.0d+0
              t67 = 1/t21**2.5d+0
              t68 = 4.8756467691912775d-1*t19*t31-1.4626940307573832d-1*
     1           gammabb*t61
              t69 = -2.25d-1*t20*t40*(4.38808209227215d-2*t18*t19*t68-5.
     1           850776123029533d-2*gammabb*t20*t61+2.194041046136075d-2
     2           *gammabb*t31*t38-1.4626940307573832d-1*t19*t2*t38+1.950
     3           258707676511d-1*t19*t20*t31)+4.5d-1*t22*t68+3.375d-1*t2
     4           0*t39**2*t67+1.0726422892220812d-1*gammabb*t61-4.5d-1*t
     5           38*t39*t40
              t70 = 1/t16**1.5d+0
              t71 = 1/t3**4.0d+0
              t72 = 1/t25**3
              t73 = 1/rhob**5
              t74 = -2.25d-1*t20*t40*(5.214967454807371d-3*t19*t8-1.0970
     1           205230680374d-2*t2*t38+2.9253880615147665d-2*t20*t31-3.
     2           0086350700811765d-4*gammabb*t30)+3.375d-1*t20*t39*t49*t
     3           67-2.25d-1*t38*t40*t49+6.170740442257711d-3*t2*t39*t40+
     4           3.2910615692041123d-2*t22*t31-2.925388061514767d-2*t31
              t75 = -1.3538857815365296d-4*t20*t40*t8+3.375d-1*t20*t49**
     1           2*t67+1.2341480884515421d-2*t2*t40*t49
              t76 = 1/taub**5
              t77 = -2.25d-1*t20*t40*(2.406908056064941d-3*gammabb*t8-3.
     1           209210741419921d-2*t19*t48+8.7761641845443d-2*t18*t38-1
     2           .4626940307573832d-1*t2*t20)+3.375d-1*t20*t39*t57*t67-2
     3           .25d-1*t38*t40*t57-4.9365923538061685d-2*t18*t39*t40-1.
     4           6455307846020562d-1*t2*t22
              t78 = 3.375d-1*t20*t49*t57*t67+6.170740442257711d-3*t2*t40
     1           *t57-4.9365923538061685d-2*t18*t40*t49+1.08310862522922
     2           35d-3*t20*t40*t48
              t79 = 1/taub**6
              t80 = 3.375d-1*t20*t57**2*t67-9.873184707612337d-2*t18*t40
     1           *t57-8.664869001833788d-3*t20*t40*t56
              fnc(iq) = (-9.305257363490997d-1*t1*t26-9.305257363490997d
     1           -1*t1)*wght+fnc(iq)
              Amat(iq,D1_RB) = (-7.481426920246762d-1*t1*t28*t46-1.24070
     1           09817987995d+0*t26*t27-1.2407009817987995d+0*t27)*wght+
     2           Amat(iq,D1_RB)
              Cmat(iq,D1_GBB) = Cmat(iq,D1_GBB)-7.481426920246762d-1*t1*
     1           t28*t53*wght
              Mmat(iq,D1_TB) = Mmat(iq,D1_TB)-9.305257363490997d-1*t1*t2
     1           8*t4*t59*wght
              Mmat(iq,D1_TA) = Mmat(iq,D1_TA)
              Amat2(iq,D2_RB_RB) = (1.4962853840493523d+0*t1*t46**2*t72+
     1           t28*(-7.481426920246762d-1*t1*(2.208607571445859d-2*t24
     2           *t60*t7*t71+1.2437810945273631d+0*t4*(4.506172839506172
     3           3d-2*t23*t43**2*t70+1.6455307846020564d-2*gammabb*t2*(1
     4           .4565673828125d-4*t33*t62*t65*t66*t7-4.6610156249999996
     5           d-3*t12*t33*t35*t62*t7+1.491525d-1*t14*t33*t62*t7-3.107
     6           34375d-3*t35*t63*t64/rhob**6-3.10734375d-3*gammabb*t10*
     7           t32*t35*t36)-9.012345679012345d-2*t23*t42*(1.6875d-2*t3
     8           3*t62*t7+4.573125306523389d-3*t60*t7)+1.033131700757996
     9           8d-2*t33*t62*t7+1.7338719095133195d-4*t60*t7+1.44197530
     :           86419754d-1*t23*t69-1.802469135802469d-1*t17*t69+1.6089
     ;           634338331218d-1*gammabb*t15*t61+1.0823773813698423d-4*t
     <           5/rhob**10-1.802469135802469d-1*t41*t42*t43+1.441975308
     =           6419754d-1*t41**2-8.776164184544301d-2*gammabb*t31*t37)
     >           -4.9620033697117594d-1*gammabb*t24*t45*t61+2.7065472925
     ?           700507d-1*gammabb*t31*t44*t45)-1.9950471787324697d+0*t2
     @           7*t46)+(-4.1356699393293317d-1*t26-4.1356699393293317d-
     1           1)/rhob**6.666666666666666d-1)*wght+Amat2(iq,D2_RB_RB)
              Cmat2(iq,D2_RB_GBB) = (t28*(-7.481426920246762d-1*t1*(1.24
     1           37810945273631d+0*t4*(1.4419753086419754d-1*t23*t74-1.8
     2           02469135802469d-1*t17*t74+1.6455307846020564d-2*gammabb
     3           *t2*(3.10734375d-3*t35*t5*t64*t73-1.4565673828125d-4*ga
     4           mmabb*t32*t33*t65*t66+1.553671875d-3*t10*t34*t35*t36+4.
     5           6610156249999996d-3*gammabb*t12*t32*t33*t35-9.9435d-2*g
     6           ammabb*t14*t32*t33)+4.5061728395061723d-2*t23*t43*t51*t
     7           70-3.607924604566141d-5*t29*t7-9.012345679012345d-2*t41
     8           *t42*t51-9.012345679012345d-2*t42*t43*t50+1.44197530864
     9           19754d-1*t41*t50-4.3880820922721503d-2*gammabb*t31*t47-
     :           9.012345679012345d-2*t23*(-1.1249999999999999d-2*gammab
     ;           b*t32*t33-1.444144833638965d-3*gammabb*t30)*t42+1.64553
     <           07846020564d-2*t2*t37-6.887544671719978d-3*gammabb*t32*
     =           t33-4.3880820922721503d-2*t15*t31-5.475384977410482d-5*
     >           gammabb*t30)-8.282278392921971d-3*gammabb*t24*t30*t71+1
     ?           .3532736462850253d-1*gammabb*t31*t45*t52-5.074776173568
     @           845d-2*t2*t44*t45+1.3532736462850253d-1*t24*t31*t45)-9.
     1           975235893662349d-1*t27*t53)+1.4962853840493523d+0*t1*t4
     2           6*t53*t72)*wght+Cmat2(iq,D2_RB_GBB)
              Cmat2(iq,D2_GBB_GBB) = -7.481426920246762d-1*t1*t28*(3.105
     1           85439734574d-3*t24*t71*t8+1.2437810945273631d+0*t4*(1.0
     2           266346832644656d-5*t8-9.012345679012345d-2*t23*t42*(2.7
     3           0777156307306d-4*t8+5.625d-3*t33*t34)+1.441975308641975
     4           4d-1*t23*t75-1.802469135802469d-1*t17*t75+4.50617283950
     5           61723d-2*t23*t51**2*t70+1.6455307846020564d-2*gammabb*t
     6           2*(-3.10734375d-3*t35*t62*t64*t7+1.4565673828125d-4*t33
     7           *t34*t65*t66-4.6610156249999996d-3*t12*t33*t34*t35+4.97
     8           175d-2*t14*t33*t34)+9.019811511415352d-6*gammabb*t6-1.8
     9           02469135802469d-1*t42*t50*t51+1.4419753086419754d-1*t50
     :           **2+3.291061569204113d-2*t2*t47+3.443772335859989d-3*t3
     ;           3*t34)-1.014955234713769d-1*t2*t45*t52)*wght+1.49628538
     <           40493523d+0*t1*t53**2*t72*wght+Cmat2(iq,D2_GBB_GBB)
              Mmat2(iq,D2_RB_TA) = Mmat2(iq,D2_RB_TA)
              Mmat2(iq,D2_RB_TB) = (-7.481426920246762d-1*t1*t28*(1.2437
     1           810945273631d+0*t4*(1.4419753086419754d-1*t23*t77-1.802
     2           469135802469d-1*t17*t77+1.6455307846020564d-2*gammabb*t
     3           2*(-3.10734375d-3*t35*t63*t73*t76+1.4565673828125d-4*t3
     4           2*t54*t65*t66*t7-4.6610156249999996d-3*t12*t32*t35*t54*
     5           t7+9.9435d-2*t14*t32*t54*t7-1.553671875d-3*gammabb*t33*
     6           t34*t35*t36)-2.5347222222222215d-4*t23*t34*t43*t54*t7*t
     7           70+5.069444444444443d-4*t34*t41*t42*t54*t7-1.0138888888
     8           888886d-3*t23*t32*t42*t54*t7+6.887544671719978d-3*t32*t
     9           54*t7-9.012345679012345d-2*t42*t43*t58+1.44197530864197
     :           54d-1*t41*t58-4.3880820922721503d-2*gammabb*t31*t55)+1.
     ;           3532736462850253d-1*gammabb*t31*t45*t59)+1.861051472698
     <           1991d+0*t1*t4*t46*t59*t72-1.2407009817987995d+0*t27*t28
     =           *t4*t59)*wght+Mmat2(iq,D2_RB_TB)
              Mmat2(iq,D2_GBB_TA) = Mmat2(iq,D2_GBB_TA)
              Mmat2(iq,D2_GBB_TB) = -7.481426920246762d-1*t1*t28*(1.2437
     1           810945273631d+0*t4*(1.6455307846020564d-2*gammabb*t2*(1
     2           .553671875d-3*t33*t35*t36*t9+3.10734375d-3*t35*t5*t62*t
     3           76-1.4565673828125d-4*gammabb*t34*t54*t65*t66+4.6610156
     4           249999996d-3*gammabb*t12*t34*t35*t54-9.9435d-2*gammabb*
     5           t14*t34*t54)+1.4419753086419754d-1*t23*t78-1.8024691358
     6           02469d-1*t17*t78-2.5347222222222215d-4*t23*t34*t51*t54*
     7           t7*t70+5.069444444444443d-4*t34*t42*t50*t54*t7-9.012345
     8           679012345d-2*t42*t51*t58+1.4419753086419754d-1*t50*t58+
     9           1.6455307846020564d-2*t2*t55+1.0138888888888886d-3*gamm
     :           abb*t23*t34*t42*t54-6.887544671719978d-3*gammabb*t34*t5
     ;           4)-5.074776173568845d-2*t2*t45*t59)*wght+1.861051472698
     <           1991d+0*t1*t4*t53*t59*t72*wght+Mmat2(iq,D2_GBB_TB)
              Mmat2(iq,D2_TA_TA) = Mmat2(iq,D2_TA_TA)
              Mmat2(iq,D2_TA_TB) = Mmat2(iq,D2_TA_TB)
              Mmat2(iq,D2_TB_TB) = -9.305257363490997d-1*t1*t28*t4*(1.64
     1           55307846020564d-2*gammabb*t2*(-3.10734375d-3*gammabb*t3
     2           5*t36*t54*t9-3.10734375d-3*t35*t62*t63*t79+1.4565673828
     3           125d-4*t34*t64*t65*t66*t7-4.6610156249999996d-3*t12*t34
     4           *t35*t64*t7+1.491525d-1*t14*t34*t64*t7)+1.4419753086419
     5           754d-1*t23*t80-1.802469135802469d-1*t17*t80+1.425781249
     6           9999994d-6*t23*t62*t63*t70*t79-1.520833333333333d-3*t23
     7           *t34*t42*t64*t7+1.0331317007579968d-2*t34*t64*t7+1.0138
     8           888888888886d-3*t34*t42*t54*t58*t7+1.4419753086419754d-
     9           1*t58**2)*wght+2.3147406376843277d+0*t1*t59**2*t71*t72*
     :           wght+Mmat2(iq,D2_TB_TB)
            else 
              t1 = rhob**1.3333333333333333d+0
              t2 = 1/rhob**1.6666666666666669d+0
              t3 = 1.0970205230680374d-51*t2-1.0d+0
              t4 = 4.3880820922721503d-52*t2*t3+1.0d+0
              t5 = 1/t4**5.0d-1
              t6 = 4.5d-1*t3*t5+4.3880820922721503d-52*t2
              t7 = 1/rhob**3.3333333333333337d+0
              t8 = 2.166217250458448d-103*t7+4.4999999999999996d-2
              t9 = t8**5.0d-1
              t10 = -1.802469135802469d-1*t6*t9+8.213077466115726d-105*t
     1           7+7.209876543209877d-2*t6**2+2.4881109353903252d-52*t2+
     2           9.621132278843042d-155/rhob**5+2.755017868687991d-2
              t11 = 8.160240087098705d-52*t2+1.0d+0
              t12 = 1/t11**2.0d+0
              t13 = 1.2437810945273631d+0*t10*t12+1.0d+0
              t14 = 8.04d-1-8.04d-1/t13
              t15 = rhob**3.333333333333333d-1
              t16 = 1/t13**2
              t17 = 1/rhob**4.333333333333333d+0
              t18 = 1/t9
              t19 = 1/rhob**2.6666666666666666d+0
              t20 = -7.313470153786917d-52*t19*t3-8.023026853549804d-103
     1           *t17
              t21 = 1/t4**1.5d+0
              t22 = -8.227653923010281d-52*t19*t5-2.25d-1*t20*t21*t3-7.3
     1           13470153786917d-52*t19
              t23 = -1.802469135802469d-1*t22*t9+1.4419753086419754d-1*t
     1           22*t6+6.507566225657065d-104*t17*t18*t6-4.1468515589838
     2           76d-52*t19-2.737692488705242d-104*t17-4.810566139421521
     3           d-154/rhob**6
              t24 = 1/t11**3.0d+0
              t25 = 3.3831841157125636d-51*t10*t19*t24+1.243781094527363
     1           1d+0*t12*t23
              t26 = 1/rhob**5.333333333333333d+0
              t27 = 1/rhob**3.6666666666666664d+0
              t28 = 2.194041046136075d-51*t27*t5+3.375d-1*t20**2*t3/t4**
     1           2.5d+0-2.25d-1*t21*t3*(1.9502587076765113d-51*t27*t3+4.
     2           8138161121298817d-102*t26)+1.9502587076765113d-51*t27+8
     3           .227653923010281d-52*t19*t20*t21
              fnc(iq) = (-9.305257363490997d-1*t1*t14-9.305257363490997d
     1           -1*t1)*wght+fnc(iq)
              Amat(iq,D1_RB) = (-7.481426920246762d-1*t1*t16*t25-1.24070
     1           09817987995d+0*t14*t15-1.2407009817987995d+0*t15)*wght+
     2           Amat(iq,D1_RB)
              Cmat(iq,D1_GBB) = Cmat(iq,D1_GBB)
              Mmat(iq,D1_TB) = Mmat(iq,D1_TB)
              Mmat(iq,D1_TA) = Mmat(iq,D1_TA)
              Amat2(iq,D2_RB_RB) = (t16*(-7.481426920246762d-1*t1*(1.243
     1           7810945273631d+0*t12*(-1.802469135802469d-1*t28*t9+2.34
     2           9467036086518d-206*t6/(rhob**8.666666666666666d+0*t8**1
     3           .5d+0)+1.4419753086419754d-1*t28*t6-2.8199453644513944d
     4           -103*t18*t26*t6+1.1058270823957002d-51*t27+1.1863334117
     5           722714d-103*t26+1.4419753086419754d-1*t22**2+1.30151324
     6           5131413d-103*t17*t18*t22+2.886339683652913d-153/rhob**7
     7           )-9.021824308566837d-51*t10*t24*t27+1.3803797321536623d
     8           -101*t10*t26/t11**4.0d+0+6.766368231425127d-51*t19*t23*
     9           t24)-1.9950471787324697d+0*t15*t25)+1.4962853840493523d
     :           +0*t1*t25**2/t13**3+(-4.1356699393293317d-1*t14-4.13566
     ;           99393293317d-1)/rhob**6.666666666666666d-1)*wght+Amat2(
     <           iq,D2_RB_RB)
              Cmat2(iq,D2_RB_GBB) = Cmat2(iq,D2_RB_GBB)
              Cmat2(iq,D2_GBB_GBB) = Cmat2(iq,D2_GBB_GBB)
              Mmat2(iq,D2_RB_TA) = Mmat2(iq,D2_RB_TA)
              Mmat2(iq,D2_RB_TB) = Mmat2(iq,D2_RB_TB)
              Mmat2(iq,D2_GBB_TA) = Mmat2(iq,D2_GBB_TA)
              Mmat2(iq,D2_GBB_TB) = Mmat2(iq,D2_GBB_TB)
              Mmat2(iq,D2_TA_TA) = Mmat2(iq,D2_TA_TA)
              Mmat2(iq,D2_TA_TB) = Mmat2(iq,D2_TA_TB)
              Mmat2(iq,D2_TB_TB) = Mmat2(iq,D2_TB_TB)
            endif 
          endif ! rhoa.gt.tol_rho.and.rhob.gt.tol_rho 
        endif ! ipol.eq.1 
      enddo ! iq 
      end 
C> 
C> \brief Evaluate the nwxcm_x_tpss03 functional [1] 
C> 
C> \f{eqnarray*}{ 
C>   {\it t_1} &=& \rho_\alpha^{{{4}\over{3}}}\\\\ 
C>   {\it t_2} &=& \rho_\beta^{{{4}\over{3}}}\\\\ 
C>   {\it t_3} &=& {{1}\over{\rho_\alpha^{{{8}\over{3}}}}}\\\\ 
C>   {\it t_4} &=& {{1}\over{\rho_\alpha^{{{16}\over{3}}}}}\\\\ 
C>   {\it t_5} &=& \sigma_{\alpha\alpha}^2\\\\ 
C>   {\it t_6} &=& {{1}\over{\rho_\alpha}}\\\\ 
C>   {\it t_7} &=& \left({{{\it t_6}\,\sigma_{\alpha\alpha}}
C>    \over{\tau_\alpha}}\right)^{2.0}\\\\ 
C>   {\it t_8} &=& {{1}\over{\rho_\alpha^{{{5}\over{3}}}}}\\\\ 
C>   {\it t_9} &=& 2.0\,\tau_\alpha-0.25\,{\it t_6}\,
C>    \sigma_{\alpha\alpha}\\\\ 
C>   {\it t_{10}} &=& 0.1097020523068037\,{\it t_8}\,{\it t_9}-1.0\\\\ 
C>   {\it t_{11}} &=& {{0.45\,{\it t_{10}}}\over{
C>    \left(0.0438808209227215\,{\it t_8}\,{\it t_9}\,{\it t_{10}}
C>    +1.0\right)^{0.5}}}+0.01097020523068038\,{\it t_3}\,
C>    \sigma_{\alpha\alpha}\\\\ 
C>   {\it t_{12}} &=& {{1}\over{\rho_\beta^{{{8}\over{3}}}}}\\\\ 
C>   {\it t_{13}} &=& {{1}\over{\rho_\beta^{{{16}\over{3}}}}}\\\\ 
C>   {\it t_{14}} &=& \sigma_{\beta\beta}^2\\\\ 
C>   {\it t_{15}} &=& {{1}\over{\rho_\beta}}\\\\ 
C>   {\it t_{16}} &=& \left({{{\it t_{15}}\,
C>    \sigma_{\beta\beta}}\over{\tau_\beta}}\right)^{2.0}\\\\ 
C>   {\it t_{17}} &=& {{1}\over{\rho_\beta^{{{5}\over{3}}}}}\\\\ 
C>   {\it t_{18}} &=& 2.0\,\tau_\beta-0.25\,{\it t_{15}}\,
C>    \sigma_{\beta\beta}\\\\ 
C>   {\it t_{19}} &=& 0.1097020523068037\,{\it t_{17}}\,{\it t_{18}}
C>    -1.0\\\\ 
C>   {\it t_{20}} &=& {{0.45\,{\it t_{19}}}\over{
C>    \left(0.0438808209227215\,{\it t_{17}}\,{\it t_{18}}\,{
C>    \it t_{19}}+1.0\right)^{0.5}}}+0.01097020523068038\,{
C>    \it t_{12}}\,\sigma_{\beta\beta}\\\\ 
C>   {\it t_{21}} &=& \rho_s^{{{4}\over{3}}}\\\\ 
C>   {\it t_{22}} &=& {{1}\over{\rho_s^{{{8}\over{3}}}}}\\\\ 
C>   {\it t_{23}} &=& {{1}\over{\rho_s^{{{16}\over{3}}}}}\\\\ 
C>   {\it t_{24}} &=& \sigma_{ss}^2\\\\ 
C>   {\it t_{25}} &=& {{1}\over{\rho_s}}\\\\ 
C>   {\it t_{26}} &=& \left({{{\it t_{25}}\,\sigma_{ss}}
C>    \over{\tau_s}}\right)^{2.0}\\\\ 
C>   {\it t_{27}} &=& {{1}\over{\rho_s^{{{5}\over{3}}}}}\\\\ 
C>   {\it t_{28}} &=& 2.0\,\tau_s-0.25\,{\it t_{25}}\,\sigma_{ss}\\\\ 
C>   {\it t_{29}} &=& 0.1097020523068037\,{\it t_{27}}\,{\it t_{28}}
C>    -1.0\\\\ 
C>   {\it t_{30}} &=& {{0.45\,{\it t_{29}}}\over{
C>    \left(0.0438808209227215\,{\it t_{27}}\,{\it t_{28}}\,{
C>    \it t_{29}}+1.0\right)^{0.5}}}+0.01097020523068038\,{
C>    \it t_{22}}\,\sigma_{ss}\\\\ 
C>   f &=& -0.9305257363490997\,{\it t_2}\,\left(0.804
C>    -{{0.804}\over{{{1.243781094527363\,\left(0.07209876543209877
C>    \,{\it t_{20}}^2-0.1802469135802469\,\left(0.0028125\,{
C>    \it t_{16}}+1.35388578153653 \times 10^{-4}\,{\it t_{13}}\,{
C>    \it t_{14}}\right)^{0.5}\,{\it t_{20}}+0.01645530784602056
C>    \,{\it t_{12}}\,\sigma_{\beta\beta}\,\left({{0.02485875\,{
C>    \it t_{16}}}\over{\left(0.015625\,{\it t_{16}}
C>    +1.0\right)^{2.0}}}+0.1234567901234568\right)
C>    +0.001721886167929995\,{\it t_{16}}
C>    +{{1.503301918569225 \times 10^{-6}\,
C>    \sigma_{\beta\beta}^3}\over{\rho_\beta^8}}
C>    +5.133173416322327 \times 10^{-6}\,{\it t_{13}}\,{
C>    \it t_{14}}\right)}\over{\left(0.02040060021774676\,{
C>    \it t_{12}}\,\sigma_{\beta\beta}+1.0\right)^{2.0}}}+1.0}}\right)
C>    -0.9305257363490997\,{\it t_1}\,\left(0.804-{{0.804}
C>    \over{{{1.243781094527363\,\left(0.07209876543209877\,{
C>    \it t_{11}}^2-0.1802469135802469\,\left(0.0028125\,{\it t_7}
C>    +1.35388578153653 \times 10^{-4}\,{\it t_4}\,{
C>    \it t_5}\right)^{0.5}\,{\it t_{11}}+0.01645530784602056\,{
C>    \it t_3}\,\sigma_{\alpha\alpha}\,\left({{0.02485875\,{
C>    \it t_7}}\over{\left(0.015625\,{\it t_7}+1.0\right)^{2.0}}}
C>    +0.1234567901234568\right)+0.001721886167929995\,{\it t_7}
C>    +{{1.503301918569225 \times 10^{-6}\,
C>    \sigma_{\alpha\alpha}^3}\over{\rho_\alpha^8}}
C>    +5.133173416322327 \times 10^{-6}\,{\it t_4}\,{
C>    \it t_5}\right)}\over{\left(0.02040060021774676\,{\it t_3}
C>    \,\sigma_{\alpha\alpha}+1.0\right)^{2.0}}}+1.0}}\right)
C>    -0.9305257363490997\,{\it t_2}-0.9305257363490997\,{\it t_1}\\\\ 
C>   g &=& 0\\\\ 
C>   G &=& -0.9305257363490997\,{\it t_{21}}\,\left(0.804
C>    -{{0.804}\over{{{1.243781094527363\,\left(0.07209876543209877
C>    \,{\it t_{30}}^2-0.1802469135802469\,\left(0.0028125\,{
C>    \it t_{26}}+1.35388578153653 \times 10^{-4}\,{\it t_{23}}\,{
C>    \it t_{24}}\right)^{0.5}\,{\it t_{30}}+0.01645530784602056
C>    \,{\it t_{22}}\,\sigma_{ss}\,\left({{0.02485875\,{
C>    \it t_{26}}}\over{\left(0.015625\,{\it t_{26}}
C>    +1.0\right)^{2.0}}}+0.1234567901234568\right)
C>    +0.001721886167929995\,{\it t_{26}}
C>    +{{1.503301918569225 \times 10^{-6}\,\sigma_{ss}^3}
C>    \over{\rho_s^8}}+5.133173416322327 \times 10^{-6}\,{
C>    \it t_{23}}\,{\it t_{24}}\right)}\over{
C>    \left(0.02040060021774676\,{\it t_{22}}\,\sigma_{ss}
C>    +1.0\right)^{2.0}}}+1.0}}\right)-0.9305257363490997\,{
C>    \it t_{21}}\\\\ 
C> \f} 
C> 
C> Code generated with Maxima 5.34.0 [2] 
C> driven by autoxc-Ds [3]. 
C> 
C> ### References ### 
C> 
C> [1] J Tao, JP Perdew, VN Staveroverov, GE Scuseria
C>    , Phys.Rev.Lett. 91, 146401 (2003)  , DOI: 
C> <a href="https://doi.org/10.1103/PhysRevLett.91.146401 "> 
C> 10.1103/PhysRevLett.91.146401 </a> 
C> 
C> [2] Maxima, a computer algebra system, 
C> <a href="http://maxima.sourceforge.net/"> 
C> http://maxima.sourceforge.net/</a> 
C> 
C> [3] autoxc-Ds, revision 27207 2015-06-23 
C> 
      subroutine nwxcm_x_tpss03_d3(param,tol_rho,ipol,nq,wght, 
     +rho,rgamma,tau,fnc,Amat,Amat2,Amat3, 
     +Cmat,Cmat2,Cmat3,Mmat,Mmat2,Mmat3) 
c $Id: $ 
#ifdef NWXC_QUAD_PREC 
      implicit real(kind=selected_real_kind(30))(a-h,o-z),integer(i-n) 
      integer, parameter :: rk=selected_real_kind(30) 
#else 
      implicit real(kind=selected_real_kind(15))(a-h,o-z),integer(i-n) 
      integer, parameter :: rk=selected_real_kind(15) 
#endif 
#include "nwxc_param.fh" 
      double precision param(*)     !< [Input] Parameters of functional 
      double precision tol_rho      !< [Input] The lower limit on the density 
      integer ipol                  !< [Input] The number of spin channels 
      integer nq                    !< [Input] The number of points 
      double precision wght         !< [Input] The weight of the functional 
      double precision rho(nq,NCOL_RHO)      !< [Input] The density 
      double precision rgamma(nq,NCOL_GAMMA) !< [Input] The norm of the density 
                                             !< gradients 
      double precision tau(nq,NCOL_TAU)      !< [Input] The kinetic energy density 
      double precision fnc(nq)      !< [Output] The value of the functional 
c 
c     Sampling Matrices for the XC Kernel 
c 
      double precision Amat(nq,NCOL_AMAT)   !< [Output] The derivative wrt rho 
      double precision Cmat(nq,NCOL_CMAT)   !< [Output] The derivative wrt rgamma 
      double precision Mmat(nq,NCOL_MMAT)   !< [Output] The derivative wrt tau 
c 
c     Sampling Matrices for the XC Kernel 
c 
      double precision Amat2(nq,NCOL_AMAT2)  !< [Output] The 2nd derivative wrt rho 
      double precision Cmat2(nq,NCOL_CMAT2)  !< [Output] The 2nd derivative wrt rgamma 
                                             !< and possibly rho 
      double precision Mmat2(nq,NCOL_MMAT2)  !< [Output] The 2nd derivative wrt tau 
                                             !< and possibly rho 
c 
c     Sampling Matrices for the XC Kernel 
c 
      double precision Amat3(nq,NCOL_AMAT3)  !< [Output] The 3rd derivative wrt rho 
      double precision Cmat3(nq,NCOL_CMAT3)  !< [Output] The 3rd derivative wrt rgamma 
                                             !< and possibly rho 
      double precision Mmat3(nq,NCOL_MMAT3)  !< [Output] The 3rd derivative wrt tau 
                                             !< and possibly rho 
      integer iq 
      double precision tmp 
      double precision rhoa,rhob 
      double precision gammaaa,gammaab,gammabb 
      double precision taua,taub 
      double precision nwxcm_heaviside 
      external         nwxcm_heaviside 
CDIR$ NOVECTOR
      do iq = 1, nq 
        if (ipol.eq.1) then 
          rhoa    = 0.5d0*rho(iq,R_T) 
          gammaaa = 0.25d0*rgamma(iq,G_TT) 
          taua    = 0.5d0*tau(iq,T_T) 
          if (rhoa.gt.tol_rho) then 
            if (taua.gt.tol_rho) then 
              t1 = rhoa**1.3333333333333333d+0
              t2 = 1/rhoa**2.6666666666666666d+0
              t3 = 2.040060021774676d-2*gammaaa*t2+1.0d+0
              t4 = 1/t3**2.0d+0
              t5 = gammaaa**3
              t6 = 1/rhoa**8
              t7 = gammaaa**2
              t8 = 1/rhoa**5.333333333333333d+0
              t9 = 1/rhoa
              t10 = 1/taua
              t11 = gammaaa*t10*t9
              t12 = t11**2.0d+0
              t13 = 1.5625d-2*t12+1.0d+0
              t14 = 1/t13**2.0d+0
              t15 = 2.485875d-2*t12*t14+1.234567901234568d-1
              t16 = 1.35388578153653d-4*t7*t8+2.8125d-3*t12
              t17 = t16**5.0d-1
              t18 = 1/rhoa**1.6666666666666669d+0
              t19 = 2.0d+0*taua-2.5d-1*gammaaa*t9
              t20 = 1.0970205230680374d-1*t18*t19-1.0d+0
              t21 = 4.38808209227215d-2*t18*t19*t20+1.0d+0
              t22 = 1/t21**5.0d-1
              t23 = 4.5d-1*t20*t22+1.0970205230680376d-2*gammaaa*t2
              t24 = 5.133173416322327d-6*t7*t8+1.5033019185692253d-6*t5*
     1           t6+7.209876543209877d-2*t23**2-1.802469135802469d-1*t17
     2           *t23+1.6455307846020564d-2*gammaaa*t15*t2+1.72188616792
     3           99946d-3*t12
              t25 = 1.2437810945273631d+0*t24*t4+1.0d+0
              t26 = 8.04d-1-8.04d-1/t25
              t27 = rhoa**3.333333333333333d-1
              t28 = 1/t25**2
              t29 = 1/rhoa**9
              t30 = 1/rhoa**6.333333333333333d+0
              t31 = 1/rhoa**3.6666666666666664d+0
              t32 = 1/rhoa**3
              t33 = 1/taua**2
              t34 = 1/rhoa**2
              t35 = 1/t13**3.0d+0
              t36 = t11**3.0d+0
              t37 = 1.553671875d-3*gammaaa*t10*t34*t35*t36-4.97175d-2*t1
     1           4*t32*t33*t7
              t38 = 2.7425513076700936d-2*gammaaa*t31-1.828367538446729d
     1           -1*t19*t2
              t39 = 4.38808209227215d-2*t18*t19*t38+1.0970205230680374d-
     1           2*gammaaa*t20*t31-7.313470153786916d-2*t19*t2*t20
              t40 = 1/t21**1.5d+0
              t41 = -2.25d-1*t20*t39*t40+4.5d-1*t22*t38-2.92538806151476
     1           7d-2*gammaaa*t31
              t42 = 1/t17
              t43 = -5.625d-3*t32*t33*t7-7.220724168194825d-4*t30*t7
              t44 = -3.443772335859989d-3*t32*t33*t7-2.737692488705241d-
     1           5*t30*t7-1.2026415348553804d-5*t29*t5-9.012345679012345
     2           d-2*t23*t42*t43+1.4419753086419754d-1*t23*t41-1.8024691
     3           35802469d-1*t17*t41+1.6455307846020564d-2*gammaaa*t2*t3
     4           7-4.3880820922721503d-2*gammaaa*t15*t31
              t45 = 1/t3**3.0d+0
              t46 = 1.3532736462850253d-1*gammaaa*t24*t31*t45+1.24378109
     1           45273631d+0*t4*t44
              t47 = 4.97175d-2*gammaaa*t14*t33*t34-1.553671875d-3*t10*t3
     1           5*t36*t9
              t48 = 1/rhoa**4.333333333333333d+0
              t49 = -1.2034540280324706d-3*t19*t48-1.0970205230680374d-2
     1           *t2*t20
              t50 = -2.25d-1*t20*t40*t49-1.2341480884515421d-2*t2*t22+1.
     1           0970205230680376d-2*t2
              t51 = 2.70777156307306d-4*gammaaa*t8+5.625d-3*gammaaa*t33*
     1           t34
              t52 = 1.0266346832644656d-5*gammaaa*t8+4.509905755707676d-
     1           6*t6*t7-9.012345679012345d-2*t23*t42*t51+1.441975308641
     2           9754d-1*t23*t50-1.802469135802469d-1*t17*t50+1.64553078
     3           46020564d-2*gammaaa*t2*t47+3.443772335859989d-3*gammaaa
     4           *t33*t34+1.6455307846020564d-2*t15*t2
              t53 = 1.2437810945273631d+0*t4*t52-5.074776173568845d-2*t2
     1           *t24*t45
              t54 = 1/taua**3
              t55 = 1.553671875d-3*gammaaa*t33*t35*t36*t9-4.97175d-2*t14
     1           *t34*t54*t7
              t56 = 1/rhoa**3.3333333333333337d+0
              t57 = 9.627632224259765d-3*t19*t56+8.7761641845443d-2*t18*
     1           t20
              t58 = 9.873184707612337d-2*t18*t22-2.25d-1*t20*t40*t57
              t59 = 5.069444444444443d-4*t23*t34*t42*t54*t7-3.4437723358
     1           59989d-3*t34*t54*t7+1.4419753086419754d-1*t23*t58-1.802
     2           469135802469d-1*t17*t58+1.6455307846020564d-2*gammaaa*t
     3           2*t55
              t60 = 1/rhoa**10
              t61 = 1/rhoa**7.333333333333333d+0
              t62 = 1/rhoa**4.666666666666667d+0
              t63 = 1/rhoa**4
              t64 = gammaaa**4
              t65 = 1/rhoa**6
              t66 = 1/taua**4
              t67 = 1/t13**4.0d+0
              t68 = t11**4.0d+0
              t69 = 1.4565673828125d-4*t33*t63*t67*t68*t7-4.661015624999
     1           9996d-3*t12*t33*t35*t63*t7+1.491525d-1*t14*t33*t63*t7-3
     2           .10734375d-3*t35*t64*t65*t66-3.10734375d-3*gammaaa*t10*
     3           t32*t35*t36
              t70 = t39**2
              t71 = 1/t21**2.5d+0
              t72 = 4.8756467691912775d-1*t19*t31-1.4626940307573832d-1*
     1           gammaaa*t62
              t73 = 4.38808209227215d-2*t18*t19*t72-5.850776123029533d-2
     1           *gammaaa*t20*t62+2.194041046136075d-2*gammaaa*t31*t38-1
     2           .4626940307573832d-1*t19*t2*t38+1.950258707676511d-1*t1
     3           9*t20*t31
              t74 = -2.25d-1*t20*t40*t73+4.5d-1*t22*t72+3.375d-1*t20*t70
     1           *t71+1.0726422892220812d-1*gammaaa*t62-4.5d-1*t38*t39*t
     2           40
              t75 = 1/t16**1.5d+0
              t76 = t43**2
              t77 = 1.6875d-2*t33*t63*t7+4.573125306523389d-3*t61*t7
              t78 = -9.012345679012345d-2*t23*t42*t77+4.5061728395061723
     1           d-2*t23*t75*t76+1.4419753086419754d-1*t23*t74-1.8024691
     2           35802469d-1*t17*t74+1.0331317007579968d-2*t33*t63*t7+1.
     3           7338719095133195d-4*t61*t7+1.6455307846020564d-2*gammaa
     4           a*t2*t69+1.6089634338331218d-1*gammaaa*t15*t62+1.082377
     5           3813698423d-4*t5*t60-1.802469135802469d-1*t41*t42*t43+1
     6           .4419753086419754d-1*t41**2-8.776164184544301d-2*gammaa
     7           a*t31*t37
              t79 = 1/t3**4.0d+0
              t80 = 2.208607571445859d-2*t24*t61*t7*t79+1.24378109452736
     1           31d+0*t4*t78-4.9620033697117594d-1*gammaaa*t24*t45*t62+
     2           2.7065472925700507d-1*gammaaa*t31*t44*t45
              t81 = -7.481426920246762d-1*t1*t80-1.9950471787324697d+0*t
     1           27*t46
              t82 = 1/rhoa**6.666666666666666d-1
              t83 = -4.1356699393293317d-1*t26-4.1356699393293317d-1
              t84 = 1/t25**3
              t85 = t46**2
              t86 = 1/rhoa**5
              t87 = 3.10734375d-3*t35*t5*t66*t86-1.4565673828125d-4*gamm
     1           aaa*t32*t33*t67*t68+1.553671875d-3*t10*t34*t35*t36+4.66
     2           10156249999996d-3*gammaaa*t12*t32*t33*t35-9.9435d-2*gam
     3           maaa*t14*t32*t33
              t88 = 5.214967454807371d-3*t19*t8-1.0970205230680374d-2*t2
     1           *t38+2.9253880615147665d-2*t20*t31-3.0086350700811765d-
     2           4*gammaaa*t30
              t89 = -2.25d-1*t20*t40*t88+3.375d-1*t20*t39*t49*t71-2.25d-
     1           1*t38*t40*t49+6.170740442257711d-3*t2*t39*t40+3.2910615
     2           692041123d-2*t22*t31-2.925388061514767d-2*t31
              t90 = -1.1249999999999999d-2*gammaaa*t32*t33-1.44414483363
     1           8965d-3*gammaaa*t30
              t91 = -9.012345679012345d-2*t23*t42*t90+1.4419753086419754
     1           d-1*t23*t89-1.802469135802469d-1*t17*t89+1.645530784602
     2           0564d-2*gammaaa*t2*t87+4.5061728395061723d-2*t23*t43*t5
     3           1*t75-3.607924604566141d-5*t29*t7-9.012345679012345d-2*
     4           t41*t42*t51-9.012345679012345d-2*t42*t43*t50+1.44197530
     5           86419754d-1*t41*t50-4.3880820922721503d-2*gammaaa*t31*t
     6           47+1.6455307846020564d-2*t2*t37-6.887544671719978d-3*ga
     7           mmaaa*t32*t33-4.3880820922721503d-2*t15*t31-5.475384977
     8           410482d-5*gammaaa*t30
              t92 = 1.2437810945273631d+0*t4*t91-8.282278392921971d-3*ga
     1           mmaaa*t24*t30*t79+1.3532736462850253d-1*gammaaa*t31*t45
     2           *t52-5.074776173568845d-2*t2*t44*t45+1.3532736462850253
     3           d-1*t24*t31*t45
              t93 = -7.481426920246762d-1*t1*t92-9.975235893662349d-1*t2
     1           7*t53
              t94 = -3.10734375d-3*t35*t63*t66*t7+1.4565673828125d-4*t33
     1           *t34*t67*t68-4.6610156249999996d-3*t12*t33*t34*t35+4.97
     2           175d-2*t14*t33*t34
              t95 = t49**2
              t96 = 3.375d-1*t20*t71*t95-1.3538857815365296d-4*t20*t40*t
     1           8+1.2341480884515421d-2*t2*t40*t49
              t97 = t51**2
              t98 = 2.70777156307306d-4*t8+5.625d-3*t33*t34
              t99 = -9.012345679012345d-2*t23*t42*t98+4.5061728395061723
     1           d-2*t23*t75*t97+1.4419753086419754d-1*t23*t96-1.8024691
     2           35802469d-1*t17*t96+1.6455307846020564d-2*gammaaa*t2*t9
     3           4+1.0266346832644656d-5*t8+9.019811511415352d-6*gammaaa
     4           *t6-1.802469135802469d-1*t42*t50*t51+1.4419753086419754
     5           d-1*t50**2+3.291061569204113d-2*t2*t47+3.44377233585998
     6           9d-3*t33*t34
              t100 = 1.2437810945273631d+0*t4*t99+3.10585439734574d-3*t2
     1           4*t79*t8-1.014955234713769d-1*t2*t45*t52
              t101 = t53**2
              t102 = 1/taua**5
              t103 = -3.10734375d-3*t102*t35*t64*t86+1.4565673828125d-4*
     1           t32*t54*t67*t68*t7-4.6610156249999996d-3*t12*t32*t35*t5
     2           4*t7+9.9435d-2*t14*t32*t54*t7-1.553671875d-3*gammaaa*t3
     3           3*t34*t35*t36
              t104 = 2.406908056064941d-3*gammaaa*t8-3.209210741419921d-
     1           2*t19*t48+8.7761641845443d-2*t18*t38-1.4626940307573832
     2           d-1*t2*t20
              t105 = 3.375d-1*t20*t39*t57*t71-2.25d-1*t38*t40*t57-4.9365
     1           923538061685d-2*t18*t39*t40-2.25d-1*t104*t20*t40-1.6455
     2           307846020562d-1*t2*t22
              t106 = -2.5347222222222215d-4*t23*t34*t43*t54*t7*t75+5.069
     1           444444444443d-4*t34*t41*t42*t54*t7-1.0138888888888886d-
     2           3*t23*t32*t42*t54*t7+6.887544671719978d-3*t32*t54*t7-9.
     3           012345679012345d-2*t42*t43*t58+1.4419753086419754d-1*t4
     4           1*t58-4.3880820922721503d-2*gammaaa*t31*t55+1.441975308
     5           6419754d-1*t105*t23+1.6455307846020564d-2*gammaaa*t103*
     6           t2-1.802469135802469d-1*t105*t17
              t107 = 1.3532736462850253d-1*gammaaa*t31*t45*t59+1.2437810
     1           945273631d+0*t106*t4
              t108 = 1.553671875d-3*t33*t35*t36*t9-1.4565673828125d-4*ga
     1           mmaaa*t34*t54*t67*t68+3.10734375d-3*t102*t35*t5*t63+4.6
     2           610156249999996d-3*gammaaa*t12*t34*t35*t54-9.9435d-2*ga
     3           mmaaa*t14*t34*t54
              t109 = 3.375d-1*t20*t49*t57*t71+6.170740442257711d-3*t2*t4
     1           0*t57-4.9365923538061685d-2*t18*t40*t49+1.0831086252292
     2           235d-3*t20*t40*t48
              t110 = -2.5347222222222215d-4*t23*t34*t51*t54*t7*t75+5.069
     1           444444444443d-4*t34*t42*t50*t54*t7-9.012345679012345d-2
     2           *t42*t51*t58+1.4419753086419754d-1*t50*t58+1.6455307846
     3           020564d-2*t2*t55+1.0138888888888886d-3*gammaaa*t23*t34*
     4           t42*t54-6.887544671719978d-3*gammaaa*t34*t54+1.44197530
     5           86419754d-1*t109*t23+1.6455307846020564d-2*gammaaa*t108
     6           *t2-1.802469135802469d-1*t109*t17
              t111 = 1.2437810945273631d+0*t110*t4-5.074776173568845d-2*
     1           t2*t45*t59
              t112 = 1/taua**6
              t113 = t57**2
              t114 = 3.375d-1*t113*t20*t71-9.873184707612337d-2*t18*t40*
     1           t57-8.664869001833788d-3*t20*t40*t56
              t115 = 1.6455307846020564d-2*gammaaa*t2*(-3.10734375d-3*ga
     1           mmaaa*t35*t36*t54*t9+1.4565673828125d-4*t34*t66*t67*t68
     2           *t7-4.6610156249999996d-3*t12*t34*t35*t66*t7+1.491525d-
     3           1*t14*t34*t66*t7-3.10734375d-3*t112*t35*t63*t64)+1.4257
     4           812499999994d-6*t112*t23*t63*t64*t75-1.520833333333333d
     5           -3*t23*t34*t42*t66*t7+1.0331317007579968d-2*t34*t66*t7+
     6           1.0138888888888886d-3*t34*t42*t54*t58*t7+1.441975308641
     7           9754d-1*t58**2+1.4419753086419754d-1*t114*t23-1.8024691
     8           35802469d-1*t114*t17
              t116 = 1/rhoa**11
              t117 = 1/rhoa**8.333333333333334d+0
              t118 = 1/rhoa**5.666666666666667d+0
              t119 = gammaaa**6
              t120 = 1/rhoa**7
              t121 = 1/t13**5.0d+0
              t122 = t11**5.0d+0
              t123 = 1/t21**3.5d+0
              t124 = 8.044817169165608d-1*gammaaa*t118-1.787737148703468
     1           2d+0*t19*t62
              t125 = 1.0125000000000002d+0*t20*t39*t71*t73-6.75d-1*t38*t
     1           40*t73-2.25d-1*t20*t40*(3.2910615692041123d-2*gammaaa*t
     2           31*t72-2.194041046136075d-1*t19*t2*t72-1.75523283690886
     3           d-1*gammaaa*t38*t62-7.150948594813873d-1*t19*t20*t62+5.
     4           850776123029533d-1*t19*t31*t38+3.217926867666243d-1*gam
     5           maaa*t118*t20+4.38808209227215d-2*t124*t18*t19)-6.75d-1
     6           *t39*t40*t72+1.0125000000000002d+0*t38*t70*t71-8.4375d-
     7           1*t123*t20*t39**3+4.5d-1*t124*t22-5.005664016369713d-1*
     8           gammaaa*t118
              t126 = 1/t16**2.5d+0
              t127 = 1/t3**5.0d+0
              t128 = 1/t25**4
              t129 = gammaaa**5
              t130 = 6.75d-1*t20*t39*t71*t88-4.5d-1*t38*t40*t88+3.375d-1
     1           *t20*t49*t71*t73+6.170740442257711d-3*t2*t40*t73-2.25d-
     2           1*t20*t40*(-1.0970205230680374d-2*t2*t72-1.072642289222
     3           081d-1*t20*t62+3.209210741419921d-3*gammaaa*t61+5.85077
     4           6123029533d-2*t31*t38-2.781315975897265d-2*t19*t30)-2.2
     5           5d-1*t40*t49*t72-9.256110663386565d-3*t2*t70*t71+6.75d-
     6           1*t38*t39*t49*t71-8.4375d-1*t123*t20*t49*t70-1.20672257
     7           53748412d-1*t22*t62+1.0726422892220812d-1*t62-3.2910615
     8           692041123d-2*t31*t39*t40
              t131 = 3.375d-1*t38*t71*t95-8.4375d-1*t123*t20*t39*t95+6.7
     1           5d-1*t20*t49*t71*t88+1.2341480884515421d-2*t2*t40*t88+2
     2           .030828672304794d-4*t20*t39*t71*t8-1.3538857815365296d-
     3           4*t38*t40*t8-1.8512221326773132d-2*t2*t39*t49*t71-3.291
     4           0615692041123d-2*t31*t40*t49+7.220724168194822d-4*t20*t
     5           30*t40
              t132 = -2.77683319901597d-2*t2*t71*t95+6.092486016914382d-
     1           4*t20*t49*t71*t8+1.1139303661766865d-5*t40*t6-8.4375d-1
     2           *t123*t20*t49**3
              t133 = 1/taua**7
              t134 = -2.25d-1*t20*t40*(1.3906579879486325d-1*t19*t8+8.77
     1           61641845443d-2*t18*t72-2.9253880615147665d-1*t2*t38+3.9
     2           00517415353022d-1*t20*t31-2.0859869819229487d-2*gammaaa
     3           *t30)+3.375d-1*t20*t57*t71*t73-4.9365923538061685d-2*t1
     4           8*t40*t73-2.25d-1*t40*t57*t72+7.404888530709253d-2*t18*
     5           t70*t71+6.75d-1*t38*t39*t57*t71+6.75d-1*t104*t20*t39*t7
     6           1-8.4375d-1*t123*t20*t57*t70+1.6455307846020562d-1*t2*t
     7           39*t40-4.5d-1*t104*t38*t40+4.38808209227215d-1*t22*t31
              t135 = 3.375d-1*t20*t57*t71*t88-4.9365923538061685d-2*t18*
     1           t40*t88-4.693470709326635d-3*t20*t40*t8+3.375d-1*t38*t4
     2           9*t57*t71-9.256110663386565d-3*t2*t39*t57*t71+7.4048885
     3           30709253d-2*t18*t39*t49*t71+3.375d-1*t104*t20*t49*t71-1
     4           .6246629378438354d-3*t20*t39*t48*t71-8.4375d-1*t123*t20
     5           *t39*t49*t57-1.6455307846020562d-2*t31*t40*t57+8.227653
     6           923010281d-2*t2*t40*t49+1.0831086252292235d-3*t38*t40*t
     7           48+6.170740442257711d-3*t104*t2*t40
              t136 = 7.404888530709253d-2*t18*t71*t95-8.4375d-1*t123*t20
     1           *t57*t95+2.030828672304794d-4*t20*t57*t71*t8-1.85122213
     2           26773132d-2*t2*t49*t57*t71-3.249325875687671d-3*t20*t48
     3           *t49*t71-8.911442929413492d-5*t120*t40
              t137 = 1/taua**9
              t138 = -5.703323474824635d-3*t40*t86+3.899191050825205d-2*
     1           t20*t56*t57*t71+2.2214665592127758d-1*t113*t18*t71-8.43
     2           75d-1*t123*t20*t57**3
              fnc(iq) = (-1.8610514726981994d+0*t1*t26-1.861051472698199
     1           4d+0*t1)*wght+fnc(iq)
              Amat(iq,D1_RA) = (-7.481426920246762d-1*t1*t28*t46-1.24070
     1           09817987995d+0*t26*t27-1.2407009817987995d+0*t27)*wght+
     2           Amat(iq,D1_RA)
              Cmat(iq,D1_GAA) = Cmat(iq,D1_GAA)-7.481426920246762d-1*t1*
     1           t28*t53*wght
              Cmat(iq,D1_GAB) = Cmat(iq,D1_GAB)
              Mmat(iq,D1_TA) = Mmat(iq,D1_TA)-9.305257363490997d-1*t1*t2
     1           8*t4*t59*wght
              Amat2(iq,D2_RA_RA) = (1.4962853840493523d+0*t1*t84*t85+t82
     1           *t83+t28*t81)*wght+Amat2(iq,D2_RA_RA)
              Amat2(iq,D2_RA_RB) = Amat2(iq,D2_RA_RB)
              Cmat2(iq,D2_RA_GAA) = (t28*t93+1.4962853840493523d+0*t1*t4
     1           6*t53*t84)*wght+Cmat2(iq,D2_RA_GAA)
              Cmat2(iq,D2_RA_GAB) = Cmat2(iq,D2_RA_GAB)
              Cmat2(iq,D2_RA_GBB) = Cmat2(iq,D2_RA_GBB)
              Cmat2(iq,D2_GAA_GAA) = 1.4962853840493523d+0*t1*t101*t84*w
     1           ght-7.481426920246762d-1*t1*t100*t28*wght+Cmat2(iq,D2_G
     2           AA_GAA)
              Cmat2(iq,D2_GAA_GAB) = Cmat2(iq,D2_GAA_GAB)
              Cmat2(iq,D2_GAA_GBB) = Cmat2(iq,D2_GAA_GBB)
              Cmat2(iq,D2_GAB_GAB) = Cmat2(iq,D2_GAB_GAB)
              Mmat2(iq,D2_RA_TA) = (1.8610514726981991d+0*t1*t4*t46*t59*
     1           t84-1.2407009817987995d+0*t27*t28*t4*t59-7.481426920246
     2           762d-1*t1*t107*t28)*wght+Mmat2(iq,D2_RA_TA)
              Mmat2(iq,D2_RA_TB) = Mmat2(iq,D2_RA_TB)
              Mmat2(iq,D2_GAA_TA) = 1.8610514726981991d+0*t1*t4*t53*t59*
     1           t84*wght-7.481426920246762d-1*t1*t111*t28*wght+Mmat2(iq
     2           ,D2_GAA_TA)
              Mmat2(iq,D2_GAA_TB) = Mmat2(iq,D2_GAA_TB)
              Mmat2(iq,D2_GAB_TA) = Mmat2(iq,D2_GAB_TA)
              Mmat2(iq,D2_TA_TA) = 2.3147406376843277d+0*t1*t59**2*t79*t
     1           84*wght-9.305257363490997d-1*t1*t115*t28*t4*wght+Mmat2(
     2           iq,D2_TA_TA)
              Mmat2(iq,D2_TA_TB) = Mmat2(iq,D2_TA_TB)
              Amat3(iq,D3_RA_RA_RA) = (t28*(-7.481426920246762d-1*t1*(1.
     1           2437810945273631d+0*t4*(1.6455307846020564d-2*gammaaa*t
     2           2*(-8.739404296874999d-4*t33*t67*t68*t7*t86+2.796609375
     3           d-2*t12*t33*t35*t7*t86-5.9661d-1*t14*t33*t7*t86-1.01959
     4           71679687499d-3*t36*t5*t54*t65*t67-2.913134765625d-4*t11
     5           2*t119*t29*t67+3.7288125d-2*t120*t35*t64*t66+1.82070922
     6           85156248d-5*t121*t122*t5*t54*t65+9.322031249999999d-3*g
     7           ammaaa*t10*t35*t36*t63)-9.012345679012345d-2*t23*t42*(-
     8           6.75d-2*t33*t7*t86-3.3536252247838183d-2*t117*t7)-4.132
     9           526803031987d-2*t33*t7*t86+1.3518518518518516d-1*t23*t4
     :           3*t75*t77-2.703703703703703d-1*t41*t42*t77+1.3518518518
     ;           518516d-1*t41*t75*t76-2.703703703703703d-1*t42*t43*t74+
     <           4.3259259259259264d-1*t41*t74-1.2715060669764344d-3*t11
     =           7*t7-1.3164246276816452d-1*gammaaa*t31*t69+4.8268903014
     >           99366d-1*gammaaa*t37*t62-1.0823773813698424d-3*t116*t5-
     ?           6.759259259259258d-2*t126*t23*t43**3+1.4419753086419754
     @           d-1*t125*t23-1.802469135802469d-1*t125*t17-7.5084960245
     1           5457d-1*gammaaa*t118*t15)+6.625822714337577d-2*t44*t61*
     2           t7*t79-2.4294683285904448d-1*t117*t24*t7*t79+4.05982093
     3           8855076d-1*gammaaa*t31*t45*t78-1.4886010109135278d+0*ga
     4           mmaaa*t44*t45*t62+4.80607147764859d-3*t116*t127*t24*t5+
     5           2.3156015725321547d+0*gammaaa*t118*t24*t45)-6.650157262
     6           441565d-1*t46*t82-2.9925707680987046d+0*t27*t80)+t84*(1
     7           .9950471787324697d+0*t27*t85-2*t46*t81+2.99257076809870
     8           46d+0*t1*t46*t80)-6.666666666666666d-1*t18*t83-3.325078
     9           631220783d-1*t28*t46*t82-4.488856152148057d+0*t1*t128*t
     :           46**3)*wght+Amat3(iq,D3_RA_RA_RA)
              Amat3(iq,D3_RA_RA_RB) = Amat3(iq,D3_RA_RA_RB)
              Cmat3(iq,D3_RA_RA_GAA) = (t84*(2.9925707680987046d+0*t1*t4
     1           6*t92-2*t53*t81)+t28*(-1.9950471787324697d+0*t27*t92-7.
     2           481426920246762d-1*t1*(2.7065472925700507d-1*gammaaa*t3
     3           1*t45*t91+1.2437810945273631d+0*t4*(9.012345679012345d-
     4           2*t23*t43*t75*t90-1.802469135802469d-1*t41*t42*t90-1.80
     5           2469135802469d-1*t42*t43*t89+2.883950617283951d-1*t41*t
     6           89-8.776164184544301d-2*gammaaa*t31*t87+1.6455307846020
     7           564d-2*gammaaa*t2*(1.0195971679687499d-3*t36*t54*t67*t7
     8           *t86-1.8207092285156248d-5*t121*t122*t54*t7*t86+5.82626
     9           953125d-4*gammaaa*t33*t63*t67*t68+2.913134765625d-4*t11
     :           2*t129*t6*t67-3.10734375d-2*t35*t5*t65*t66-1.86440625d-
     ;           2*gammaaa*t12*t33*t35*t63+2.98305d-1*gammaaa*t14*t33*t6
     <           3-3.10734375d-3*t10*t32*t35*t36)+4.5061728395061723d-2*
     =           t23*t51*t75*t77-9.012345679012345d-2*t42*t50*t77+4.5061
     >           728395061723d-2*t50*t75*t76-6.759259259259258d-2*t126*t
     ?           23*t51*t76+9.012345679012345d-2*t41*t43*t51*t75-9.01234
     @           5679012345d-2*t42*t51*t74+1.4419753086419754d-1*t50*t74
     1           +3.2471321441095274d-4*t60*t7+1.6455307846020564d-2*t2*
     2           t69-9.012345679012345d-2*t23*t42*(3.375d-2*gammaaa*t33*
     3           t63+9.146250613046778d-3*gammaaa*t61)+2.066263401515993
     4           6d-2*gammaaa*t33*t63+1.6089634338331218d-1*gammaaa*t47*
     5           t62+1.6089634338331218d-1*t15*t62+3.467743819026639d-4*
     6           gammaaa*t61-8.776164184544301d-2*t31*t37+1.441975308641
     7           9754d-1*t130*t23-1.802469135802469d-1*t130*t17)+2.20860
     8           7571445859d-2*t52*t61*t7*t79+7.454050553629774d-2*gamma
     9           aa*t24*t61*t79-1.6564556785843942d-2*gammaaa*t30*t44*t7
     :           9-5.074776173568845d-2*t2*t45*t78-1.8022768041182213d-3
     ;           *t127*t24*t60*t7-4.9620033697117594d-1*gammaaa*t45*t52*
     <           t62-4.9620033697117594d-1*t24*t45*t62+2.706547292570050
     =           7d-1*t31*t44*t45))-4.488856152148057d+0*t1*t128*t53*t85
     >           -3.325078631220783d-1*t28*t53*t82)*wght+Cmat3(iq,D3_RA_
     ?           RA_GAA)
              Cmat3(iq,D3_RA_RA_GAB) = Cmat3(iq,D3_RA_RA_GAB)
              Cmat3(iq,D3_RA_RA_GBB) = Cmat3(iq,D3_RA_RA_GBB)
              Cmat3(iq,D3_RA_RB_GAA) = Cmat3(iq,D3_RA_RB_GAA)
              Cmat3(iq,D3_RA_RB_GAB) = Cmat3(iq,D3_RA_RB_GAB)
              Cmat3(iq,D3_RA_GAA_GAA) = (t28*(-7.481426920246762d-1*t1*(
     1           1.3532736462850253d-1*gammaaa*t31*t45*t99+1.24378109452
     2           73631d+0*t4*(4.5061728395061723d-2*t23*t43*t75*t98-9.01
     3           2345679012345d-2*t41*t42*t98+4.5061728395061723d-2*t41*
     4           t75*t97-6.759259259259258d-2*t126*t23*t43*t97-9.0123456
     5           79012345d-2*t42*t43*t96+1.4419753086419754d-1*t41*t96-4
     6           .3880820922721503d-2*gammaaa*t31*t94+9.012345679012345d
     7           -2*t23*t51*t75*t90-1.802469135802469d-1*t42*t50*t90-1.8
     8           02469135802469d-1*t42*t51*t89+2.883950617283951d-1*t50*
     9           t89+3.291061569204113d-2*t2*t87+1.6455307846020564d-2*g
     :           ammaaa*t2*(2.485875d-2*t35*t66*t7*t86-2.913134765625d-4
     ;           *t32*t33*t67*t68-2.913134765625d-4*t112*t120*t64*t67-1.
     <           0195971679687499d-3*gammaaa*t36*t54*t63*t67+1.820709228
     =           5156248d-5*gammaaa*t121*t122*t54*t63+9.322031249999999d
     >           -3*t12*t32*t33*t35-9.9435d-2*t14*t32*t33)+9.01234567901
     ?           2345d-2*t43*t50*t51*t75-8.776164184544301d-2*t31*t47-9.
     @           012345679012345d-2*t23*(-1.1249999999999999d-2*t32*t33-
     1           1.444144833638965d-3*t30)*t42-6.887544671719978d-3*t32*
     2           t33-5.475384977410482d-5*t30-7.215849209132282d-5*gamma
     3           aa*t29+1.4419753086419754d-1*t131*t23-1.802469135802469
     4           d-1*t131*t17)-1.014955234713769d-1*t2*t45*t91+3.1058543
     5           9734574d-3*t44*t79*t8-1.6564556785843942d-2*gammaaa*t30
     6           *t52*t79-1.6564556785843942d-2*t24*t30*t79+2.7065472925
     7           700507d-1*t31*t45*t52+6.758538015443329d-4*gammaaa*t127
     8           *t24*t29)-9.975235893662349d-1*t100*t27)+t84*(-2*t53*t9
     9           3+1.4962853840493523d+0*t1*t53*t92+1.4962853840493523d+
     :           0*t1*t100*t46)-4.488856152148057d+0*t1*t101*t128*t46)*w
     ;           ght+Cmat3(iq,D3_RA_GAA_GAA)
              Cmat3(iq,D3_RA_GAA_GAB) = Cmat3(iq,D3_RA_GAA_GAB)
              Cmat3(iq,D3_RA_GAA_GBB) = Cmat3(iq,D3_RA_GAA_GBB)
              Cmat3(iq,D3_RA_GAB_GAB) = Cmat3(iq,D3_RA_GAB_GAB)
              Cmat3(iq,D3_RA_GAB_GBB) = Cmat3(iq,D3_RA_GAB_GBB)
              Cmat3(iq,D3_RA_GBB_GBB) = Cmat3(iq,D3_RA_GBB_GBB)
              Cmat3(iq,D3_GAA_GAA_GAA) = -7.481426920246762d-1*t1*t28*(-
     1           1.5224328520706534d-1*t2*t45*t99+1.2437810945273631d+0*
     2           t4*(1.3518518518518516d-1*t23*t51*t75*t98-2.70370370370
     3           3703d-1*t42*t50*t98+1.3518518518518516d-1*t50*t75*t97-2
     4           .703703703703703d-1*t42*t51*t96+4.3259259259259264d-1*t
     5           50*t96+4.9365923538061696d-2*t2*t94+1.6455307846020564d
     6           -2*gammaaa*t2*(2.913134765625d-4*t112*t5*t65*t67+1.0195
     7           971679687499d-3*t32*t36*t54*t67-1.86440625d-2*gammaaa*t
     8           35*t63*t66-1.8207092285156248d-5*t121*t122*t32*t54)+9.0
     9           19811511415352d-6*t6-6.759259259259258d-2*t126*t23*t51*
     :           *3+1.4419753086419754d-1*t132*t23-1.802469135802469d-1*
     ;           t132*t17)+9.317563192037218d-3*t52*t79*t8-2.53445175579
     <           1249d-4*t127*t24*t6)*wght+4.488856152148057d+0*t1*t100*
     =           t53*t84*wght-4.488856152148057d+0*t1*t128*t53**3*wght+C
     >           mat3(iq,D3_GAA_GAA_GAA)
              Cmat3(iq,D3_GAA_GAA_GAB) = Cmat3(iq,D3_GAA_GAA_GAB)
              Cmat3(iq,D3_GAA_GAA_GBB) = Cmat3(iq,D3_GAA_GAA_GBB)
              Cmat3(iq,D3_GAA_GAB_GAB) = Cmat3(iq,D3_GAA_GAB_GAB)
              Cmat3(iq,D3_GAA_GAB_GBB) = Cmat3(iq,D3_GAA_GAB_GBB)
              Cmat3(iq,D3_GAB_GAB_GAB) = Cmat3(iq,D3_GAB_GAB_GAB)
              Mmat3(iq,D3_RA_RA_TA) = (t28*(-7.481426920246762d-1*t1*(1.
     1           2437810945273631d+0*t4*(1.6455307846020564d-2*gammaaa*t
     2           2*(-1.0195971679687499d-3*t36*t5*t66*t67*t86+1.82070922
     3           85156248d-5*t121*t122*t5*t66*t86-5.82626953125d-4*t54*t
     4           63*t67*t68*t7+1.86440625d-2*t12*t35*t54*t63*t7-2.98305d
     5           -1*t14*t54*t63*t7-2.913134765625d-4*t119*t133*t6*t67+3.
     6           10734375d-2*t102*t35*t64*t65+3.10734375d-3*gammaaa*t32*
     7           t33*t35*t36)-2.5347222222222215d-4*t23*t34*t54*t7*t75*t
     8           77-9.012345679012345d-2*t42*t58*t77+4.5061728395061723d
     9           -2*t58*t75*t76+3.802083333333333d-4*t126*t23*t34*t54*t7
     :           *t76-5.069444444444443d-4*t34*t41*t43*t54*t7*t75+1.0138
     ;           888888888886d-3*t23*t32*t43*t54*t7*t75+5.06944444444444
     <           3d-4*t34*t42*t54*t7*t74+1.4419753086419754d-1*t58*t74+3
     =           .0416666666666664d-3*t23*t42*t54*t63*t7-2.0662634015159
     >           936d-2*t54*t63*t7-2.0277777777777772d-3*t32*t41*t42*t54
     ?           *t7+1.6089634338331218d-1*gammaaa*t55*t62-1.80246913580
     @           2469d-1*t105*t42*t43+2.883950617283951d-1*t105*t41-8.77
     1           6164184544301d-2*gammaaa*t103*t31+1.4419753086419754d-1
     2           *t134*t23-1.802469135802469d-1*t134*t17)+2.208607571445
     3           859d-2*t59*t61*t7*t79-4.9620033697117594d-1*gammaaa*t45
     4           *t59*t62+2.7065472925700507d-1*gammaaa*t106*t31*t45)-1.
     5           9950471787324697d+0*t107*t27)-5.583154418094598d+0*t1*t
     6           128*t4*t59*t85-2.4875621890547261d+0*t4*t59*t81*t84+2.9
     7           925707680987046d+0*t1*t107*t46*t84-4.1356699393293317d-
     8           1*t28*t4*t59*t82)*wght+Mmat3(iq,D3_RA_RA_TA)
              Mmat3(iq,D3_RA_RA_TB) = Mmat3(iq,D3_RA_RA_TB)
              Mmat3(iq,D3_RA_RB_TA) = Mmat3(iq,D3_RA_RB_TA)
              Mmat3(iq,D3_RA_GAA_TA) = (-2.4875621890547261d+0*t4*t59*t8
     1           4*t93+t28*(-7.481426920246762d-1*t1*(1.2437810945273631
     2           d+0*t4*(-2.5347222222222215d-4*t23*t34*t54*t7*t75*t90-9
     3           .012345679012345d-2*t42*t58*t90+5.069444444444443d-4*t3
     4           4*t42*t54*t7*t89+1.4419753086419754d-1*t58*t89+1.645530
     5           7846020564d-2*gammaaa*t2*(-2.796609375d-2*t102*t35*t5*t
     6           86+1.0195971679687499d-3*t36*t63*t66*t67*t7-1.820709228
     7           5156248d-5*t121*t122*t63*t66*t7+4.369702148437499d-4*ga
     8           mmaaa*t32*t54*t67*t68+2.913134765625d-4*t120*t129*t133*
     9           t67-1.3983046875d-2*gammaaa*t12*t32*t35*t54+1.9887d-1*g
     :           ammaaa*t14*t32*t54-1.553671875d-3*t33*t34*t35*t36)-2.53
     ;           47222222222215d-4*t34*t41*t51*t54*t7*t75+5.069444444444
     <           443d-4*t23*t32*t51*t54*t7*t75-2.5347222222222215d-4*t34
     =           *t43*t50*t54*t7*t75+4.5061728395061723d-2*t43*t51*t58*t
     >           75-5.069444444444443d-4*gammaaa*t23*t34*t43*t54*t75+3.8
     ?           02083333333333d-4*t126*t23*t34*t43*t51*t54*t7-1.0138888
     @           888888886d-3*t32*t42*t50*t54*t7-4.3880820922721503d-2*t
     1           31*t55+1.0138888888888886d-3*gammaaa*t34*t41*t42*t54-2.
     2           0277777777777772d-3*gammaaa*t23*t32*t42*t54+1.377508934
     3           3439956d-2*gammaaa*t32*t54-9.012345679012345d-2*t105*t4
     4           2*t51+1.4419753086419754d-1*t105*t50-9.012345679012345d
     5           -2*t109*t42*t43+1.4419753086419754d-1*t109*t41-4.388082
     6           0922721503d-2*gammaaa*t108*t31+1.4419753086419754d-1*t1
     7           35*t23+1.6455307846020564d-2*t103*t2-1.802469135802469d
     8           -1*t135*t17)-8.282278392921971d-3*gammaaa*t30*t59*t79+1
     9           .3532736462850253d-1*t31*t45*t59+1.3532736462850253d-1*
     :           gammaaa*t110*t31*t45-5.074776173568845d-2*t106*t2*t45)-
     ;           9.975235893662349d-1*t111*t27)+(1.4962853840493523d+0*t
     <           1*t107*t53+1.4962853840493523d+0*t1*t111*t46)*t84-5.583
     =           154418094598d+0*t1*t128*t4*t46*t53*t59)*wght+Mmat3(iq,D
     >           3_RA_GAA_TA)
              Mmat3(iq,D3_RA_GAA_TB) = Mmat3(iq,D3_RA_GAA_TB)
              Mmat3(iq,D3_RA_GAB_TA) = Mmat3(iq,D3_RA_GAB_TA)
              Mmat3(iq,D3_RA_GAB_TB) = Mmat3(iq,D3_RA_GAB_TB)
              Mmat3(iq,D3_RA_GBB_TA) = Mmat3(iq,D3_RA_GBB_TA)
              Mmat3(iq,D3_RA_GBB_TB) = Mmat3(iq,D3_RA_GBB_TB)
              Mmat3(iq,D3_GAA_GAA_TA) = -7.481426920246762d-1*t1*t28*(1.
     1           2437810945273631d+0*t4*(-2.5347222222222215d-4*t23*t34*
     2           t54*t7*t75*t98-9.012345679012345d-2*t42*t58*t98+4.50617
     3           28395061723d-2*t58*t75*t97+3.802083333333333d-4*t126*t2
     4           3*t34*t54*t7*t97+5.069444444444443d-4*t34*t42*t54*t7*t9
     5           6+1.4419753086419754d-1*t58*t96-5.069444444444443d-4*t3
     6           4*t50*t51*t54*t7*t75-1.0138888888888886d-3*gammaaa*t23*
     7           t34*t51*t54*t75+1.6455307846020564d-2*gammaaa*t2*(2.485
     8           875d-2*t102*t35*t63*t7-2.913134765625d-4*t34*t54*t67*t6
     9           8-1.0195971679687499d-3*gammaaa*t32*t36*t66*t67-2.91313
     :           4765625d-4*t133*t64*t65*t67+1.8207092285156248d-5*gamma
     ;           aa*t121*t122*t32*t66+9.322031249999999d-3*t12*t34*t35*t
     <           54-9.9435d-2*t14*t34*t54)+2.0277777777777772d-3*gammaaa
     =           *t34*t42*t50*t54+1.0138888888888886d-3*t23*t34*t42*t54-
     >           6.887544671719978d-3*t34*t54-1.802469135802469d-1*t109*
     ?           t42*t51+2.883950617283951d-1*t109*t50+1.441975308641975
     @           4d-1*t136*t23+3.291061569204113d-2*t108*t2-1.8024691358
     1           02469d-1*t136*t17)+3.10585439734574d-3*t59*t79*t8-1.014
     2           955234713769d-1*t110*t2*t45)*wght+1.8610514726981991d+0
     3           *t1*t100*t4*t59*t84*wght+2.9925707680987046d+0*t1*t111*
     4           t53*t84*wght-5.583154418094598d+0*t1*t101*t128*t4*t59*w
     5           ght+Mmat3(iq,D3_GAA_GAA_TA)
              Mmat3(iq,D3_GAA_GAA_TB) = Mmat3(iq,D3_GAA_GAA_TB)
              Mmat3(iq,D3_GAA_GAB_TA) = Mmat3(iq,D3_GAA_GAB_TA)
              Mmat3(iq,D3_GAA_GAB_TB) = Mmat3(iq,D3_GAA_GAB_TB)
              Mmat3(iq,D3_GAA_GBB_TA) = Mmat3(iq,D3_GAA_GBB_TA)
              Mmat3(iq,D3_GAB_GAB_TA) = Mmat3(iq,D3_GAB_GAB_TA)
              Mmat3(iq,D3_TA_TA_TA) = -9.305257363490997d-1*t1*t28*t4*(1
     1           .6455307846020564d-2*gammaaa*t2*(9.322031249999999d-3*g
     2           ammaaa*t35*t36*t66*t9-8.739404296874999d-4*t102*t34*t67
     3           *t68*t7+2.796609375d-2*t102*t12*t34*t35*t7-5.9661d-1*t1
     4           02*t14*t34*t7-2.913134765625d-4*t119*t137*t65*t67-1.019
     5           5971679687499d-3*t112*t32*t36*t5*t67+3.7288125d-2*t133*
     6           t35*t63*t64+1.8207092285156248d-5*t112*t121*t122*t32*t5
     7           )+4.2773437499999983d-6*t112*t58*t63*t64*t75-1.28320312
     8           49999995d-5*t133*t23*t63*t64*t75-4.562499999999999d-3*t
     9           34*t42*t58*t66*t7+1.520833333333333d-3*t114*t34*t42*t54
     :           *t7+6.083333333333332d-3*t102*t23*t34*t42*t7-4.13252680
     ;           3031987d-2*t102*t34*t7+1.2030029296874996d-8*t119*t126*
     <           t137*t23*t65+4.3259259259259264d-1*t114*t58+1.441975308
     =           6419754d-1*t138*t23-1.802469135802469d-1*t138*t17)*wght
     >           +6.944221913052984d+0*t1*t115*t59*t79*t84*wght-8.637091
     ?           931657939d+0*t1*t128*t59**3*wght/t3**6.0d+0+Mmat3(iq,D3
     @           _TA_TA_TA)
              Mmat3(iq,D3_TA_TA_TB) = Mmat3(iq,D3_TA_TA_TB)
            else 
              t1 = rhoa**1.3333333333333333d+0
              t2 = 1/rhoa**1.6666666666666669d+0
              t3 = 1.0970205230680374d-51*t2-1.0d+0
              t4 = 4.3880820922721503d-52*t2*t3+1.0d+0
              t5 = 1/t4**5.0d-1
              t6 = 4.5d-1*t3*t5+4.3880820922721503d-52*t2
              t7 = 1/rhoa**3.3333333333333337d+0
              t8 = 2.166217250458448d-103*t7+4.4999999999999996d-2
              t9 = t8**5.0d-1
              t10 = -1.802469135802469d-1*t6*t9+8.213077466115726d-105*t
     1           7+7.209876543209877d-2*t6**2+2.4881109353903252d-52*t2+
     2           9.621132278843042d-155/rhoa**5+2.755017868687991d-2
              t11 = 8.160240087098705d-52*t2+1.0d+0
              t12 = 1/t11**2.0d+0
              t13 = 1.2437810945273631d+0*t10*t12+1.0d+0
              t14 = 8.04d-1-8.04d-1/t13
              t15 = rhoa**3.333333333333333d-1
              t16 = 1/t13**2
              t17 = 1/rhoa**4.333333333333333d+0
              t18 = 1/t9
              t19 = 1/rhoa**2.6666666666666666d+0
              t20 = -7.313470153786917d-52*t19*t3-8.023026853549804d-103
     1           *t17
              t21 = 1/t4**1.5d+0
              t22 = -8.227653923010281d-52*t19*t5-2.25d-1*t20*t21*t3-7.3
     1           13470153786917d-52*t19
              t23 = -1.802469135802469d-1*t22*t9+1.4419753086419754d-1*t
     1           22*t6+6.507566225657065d-104*t17*t18*t6-4.1468515589838
     2           76d-52*t19-2.737692488705242d-104*t17-4.810566139421521
     3           d-154/rhoa**6
              t24 = 1/t11**3.0d+0
              t25 = 3.3831841157125636d-51*t10*t19*t24+1.243781094527363
     1           1d+0*t12*t23
              t26 = -4.1356699393293317d-1*t14-4.1356699393293317d-1
              t27 = 1/rhoa**6.666666666666666d-1
              t28 = 1/t13**3
              t29 = t25**2
              t30 = 1/t8**1.5d+0
              t31 = 1/rhoa**8.666666666666666d+0
              t32 = 1/rhoa**5.333333333333333d+0
              t33 = 1/rhoa**3.6666666666666664d+0
              t34 = t20**2
              t35 = 1/t4**2.5d+0
              t36 = 1.9502587076765113d-51*t3*t33+4.8138161121298817d-10
     1           2*t32
              t37 = 2.194041046136075d-51*t33*t5-2.25d-1*t21*t3*t36+3.37
     1           5d-1*t3*t34*t35+1.9502587076765113d-51*t33+8.2276539230
     2           10281d-52*t19*t20*t21
              t38 = -1.802469135802469d-1*t37*t9+1.4419753086419754d-1*t
     1           37*t6-2.8199453644513944d-103*t18*t32*t6+2.349467036086
     2           518d-206*t30*t31*t6+1.1058270823957002d-51*t33+1.186333
     3           4117722714d-103*t32+1.4419753086419754d-1*t22**2+1.3015
     4           13245131413d-103*t17*t18*t22+2.886339683652913d-153/rho
     5           a**7
              t39 = 1/t11**4.0d+0
              t40 = 1.3803797321536623d-101*t10*t32*t39+1.24378109452736
     1           31d+0*t12*t38-9.021824308566837d-51*t10*t24*t33+6.76636
     2           8231425127d-51*t19*t23*t24
              t41 = -7.481426920246762d-1*t1*t40-1.9950471787324697d+0*t
     1           15*t25
              t42 = 1/rhoa**8
              t43 = 1/rhoa**6.333333333333333d+0
              t44 = 1/rhoa**4.666666666666667d+0
              t45 = -8.044817169165608d-51*t44*t5-2.25d-1*t21*t3*(-7.150
     1           948594813874d-51*t3*t44-2.9239475644048174d-101*t43)-7.
     2           150948594813874d-51*t44-8.4375d-1*t20**3*t3/t4**3.5d+0+
     3           1.0125000000000002d+0*t20*t3*t35*t36+1.2341480884515423
     4           d-51*t19*t21*t36-1.8512221326773132d-51*t19*t34*t35-3.2
     5           910615692041123d-51*t20*t21*t33
              fnc(iq) = (-1.8610514726981994d+0*t1*t14-1.861051472698199
     1           4d+0*t1)*wght+fnc(iq)
              Amat(iq,D1_RA) = (-7.481426920246762d-1*t1*t16*t25-1.24070
     1           09817987995d+0*t14*t15-1.2407009817987995d+0*t15)*wght+
     2           Amat(iq,D1_RA)
              Cmat(iq,D1_GAA) = Cmat(iq,D1_GAA)
              Cmat(iq,D1_GAB) = Cmat(iq,D1_GAB)
              Mmat(iq,D1_TA) = Mmat(iq,D1_TA)
              Amat2(iq,D2_RA_RA) = (t16*t41+1.4962853840493523d+0*t1*t28
     1           *t29+t26*t27)*wght+Amat2(iq,D2_RA_RA)
              Amat2(iq,D2_RA_RB) = Amat2(iq,D2_RA_RB)
              Cmat2(iq,D2_RA_GAA) = Cmat2(iq,D2_RA_GAA)
              Cmat2(iq,D2_RA_GAB) = Cmat2(iq,D2_RA_GAB)
              Cmat2(iq,D2_RA_GBB) = Cmat2(iq,D2_RA_GBB)
              Cmat2(iq,D2_GAA_GAA) = Cmat2(iq,D2_GAA_GAA)
              Cmat2(iq,D2_GAA_GAB) = Cmat2(iq,D2_GAA_GAB)
              Cmat2(iq,D2_GAA_GBB) = Cmat2(iq,D2_GAA_GBB)
              Cmat2(iq,D2_GAB_GAB) = Cmat2(iq,D2_GAB_GAB)
              Mmat2(iq,D2_RA_TA) = Mmat2(iq,D2_RA_TA)
              Mmat2(iq,D2_RA_TB) = Mmat2(iq,D2_RA_TB)
              Mmat2(iq,D2_GAA_TA) = Mmat2(iq,D2_GAA_TA)
              Mmat2(iq,D2_GAA_TB) = Mmat2(iq,D2_GAA_TB)
              Mmat2(iq,D2_GAB_TA) = Mmat2(iq,D2_GAB_TA)
              Mmat2(iq,D2_TA_TA) = Mmat2(iq,D2_TA_TA)
              Mmat2(iq,D2_TA_TB) = Mmat2(iq,D2_TA_TB)
              Amat3(iq,D3_RA_RA_RA) = (t16*(-7.481426920246762d-1*t1*(1.
     1           2437810945273631d+0*t12*(-1.802469135802469d-1*t45*t9+2
     2           .544728011477048d-308*t6/(rhoa**13*t8**2.5d+0)+1.441975
     3           3086419754d-1*t45*t6+1.5039708610407437d-102*t18*t43*t6
     4           -3.054307146912473d-205*t30*t6/rhoa**9.666666666666666d
     5           +0-4.054699302117567d-51*t44-6.327111529452114d-103*t43
     6           -2.020437778557039d-152*t42+4.3259259259259264d-1*t22*t
     7           37+1.9522698676971195d-103*t17*t18*t37-8.45983609335418
     8           4d-103*t18*t22*t32+7.048401108259554d-206*t22*t30*t31)+
     9           3.308002246474507d-50*t10*t24*t44-1.1043037857229297d-1
     :           00*t10*t39*t43+7.509486683825926d-152*t10*t42/t11**5.0d
     ;           +0+4.1411391964609867d-101*t23*t32*t39+1.01495523471376
     <           91d-50*t19*t24*t38-2.706547292570051d-50*t23*t24*t33)-2
     =           .9925707680987046d+0*t15*t40-6.650157262441565d-1*t25*t
     >           27)+t28*(-2*t25*t41+2.9925707680987046d+0*t1*t25*t40+1.
     ?           9950471787324697d+0*t15*t29)-3.325078631220783d-1*t16*t
     @           25*t27-6.666666666666666d-1*t2*t26-4.488856152148057d+0
     1           *t1*t25**3/t13**4)*wght+Amat3(iq,D3_RA_RA_RA)
              Amat3(iq,D3_RA_RA_RB) = Amat3(iq,D3_RA_RA_RB)
              Cmat3(iq,D3_RA_RA_GAA) = Cmat3(iq,D3_RA_RA_GAA)
              Cmat3(iq,D3_RA_RA_GAB) = Cmat3(iq,D3_RA_RA_GAB)
              Cmat3(iq,D3_RA_RA_GBB) = Cmat3(iq,D3_RA_RA_GBB)
              Cmat3(iq,D3_RA_RB_GAA) = Cmat3(iq,D3_RA_RB_GAA)
              Cmat3(iq,D3_RA_RB_GAB) = Cmat3(iq,D3_RA_RB_GAB)
              Cmat3(iq,D3_RA_GAA_GAA) = Cmat3(iq,D3_RA_GAA_GAA)
              Cmat3(iq,D3_RA_GAA_GAB) = Cmat3(iq,D3_RA_GAA_GAB)
              Cmat3(iq,D3_RA_GAA_GBB) = Cmat3(iq,D3_RA_GAA_GBB)
              Cmat3(iq,D3_RA_GAB_GAB) = Cmat3(iq,D3_RA_GAB_GAB)
              Cmat3(iq,D3_RA_GAB_GBB) = Cmat3(iq,D3_RA_GAB_GBB)
              Cmat3(iq,D3_RA_GBB_GBB) = Cmat3(iq,D3_RA_GBB_GBB)
              Cmat3(iq,D3_GAA_GAA_GAA) = Cmat3(iq,D3_GAA_GAA_GAA)
              Cmat3(iq,D3_GAA_GAA_GAB) = Cmat3(iq,D3_GAA_GAA_GAB)
              Cmat3(iq,D3_GAA_GAA_GBB) = Cmat3(iq,D3_GAA_GAA_GBB)
              Cmat3(iq,D3_GAA_GAB_GAB) = Cmat3(iq,D3_GAA_GAB_GAB)
              Cmat3(iq,D3_GAA_GAB_GBB) = Cmat3(iq,D3_GAA_GAB_GBB)
              Cmat3(iq,D3_GAB_GAB_GAB) = Cmat3(iq,D3_GAB_GAB_GAB)
              Mmat3(iq,D3_RA_RA_TA) = Mmat3(iq,D3_RA_RA_TA)
              Mmat3(iq,D3_RA_RA_TB) = Mmat3(iq,D3_RA_RA_TB)
              Mmat3(iq,D3_RA_RB_TA) = Mmat3(iq,D3_RA_RB_TA)
              Mmat3(iq,D3_RA_GAA_TA) = Mmat3(iq,D3_RA_GAA_TA)
              Mmat3(iq,D3_RA_GAA_TB) = Mmat3(iq,D3_RA_GAA_TB)
              Mmat3(iq,D3_RA_GAB_TA) = Mmat3(iq,D3_RA_GAB_TA)
              Mmat3(iq,D3_RA_GAB_TB) = Mmat3(iq,D3_RA_GAB_TB)
              Mmat3(iq,D3_RA_GBB_TA) = Mmat3(iq,D3_RA_GBB_TA)
              Mmat3(iq,D3_RA_GBB_TB) = Mmat3(iq,D3_RA_GBB_TB)
              Mmat3(iq,D3_GAA_GAA_TA) = Mmat3(iq,D3_GAA_GAA_TA)
              Mmat3(iq,D3_GAA_GAA_TB) = Mmat3(iq,D3_GAA_GAA_TB)
              Mmat3(iq,D3_GAA_GAB_TA) = Mmat3(iq,D3_GAA_GAB_TA)
              Mmat3(iq,D3_GAA_GAB_TB) = Mmat3(iq,D3_GAA_GAB_TB)
              Mmat3(iq,D3_GAA_GBB_TA) = Mmat3(iq,D3_GAA_GBB_TA)
              Mmat3(iq,D3_GAB_GAB_TA) = Mmat3(iq,D3_GAB_GAB_TA)
              Mmat3(iq,D3_TA_TA_TA) = Mmat3(iq,D3_TA_TA_TA)
              Mmat3(iq,D3_TA_TA_TB) = Mmat3(iq,D3_TA_TA_TB)
            endif 
          endif ! rhoa.gt.tol_rho 
        else  ! ipol.eq.1 
          rhoa    = rho(iq,R_A) 
          rhob    = rho(iq,R_B) 
          gammaaa = rgamma(iq,G_AA) 
          gammaab = rgamma(iq,G_AB) 
          gammabb = rgamma(iq,G_BB) 
          taua    = tau(iq,T_A) 
          taub    = tau(iq,T_B) 
          if (rhoa.gt.tol_rho.and.rhob.gt.tol_rho) then 
            if (taua.gt.tol_rho.and.taub.gt.tol_rho) then 
              t1 = rhoa**1.3333333333333333d+0
              t2 = rhob**1.3333333333333333d+0
              t3 = 1/rhoa**2.6666666666666666d+0
              t4 = 2.040060021774676d-2*gammaaa*t3+1.0d+0
              t5 = 1/t4**2.0d+0
              t6 = gammaaa**3
              t7 = 1/rhoa**8
              t8 = gammaaa**2
              t9 = 1/rhoa**5.333333333333333d+0
              t10 = 1/rhoa
              t11 = 1/taua
              t12 = gammaaa*t10*t11
              t13 = t12**2.0d+0
              t14 = 1.5625d-2*t13+1.0d+0
              t15 = 1/t14**2.0d+0
              t16 = 2.485875d-2*t13*t15+1.234567901234568d-1
              t17 = 1.35388578153653d-4*t8*t9+2.8125d-3*t13
              t18 = t17**5.0d-1
              t19 = 1/rhoa**1.6666666666666669d+0
              t20 = 2.0d+0*taua-2.5d-1*gammaaa*t10
              t21 = 1.0970205230680374d-1*t19*t20-1.0d+0
              t22 = 4.38808209227215d-2*t19*t20*t21+1.0d+0
              t23 = 1/t22**5.0d-1
              t24 = 1.0970205230680376d-2*gammaaa*t3+4.5d-1*t21*t23
              t25 = 5.133173416322327d-6*t8*t9+1.5033019185692253d-6*t6*
     1           t7+1.6455307846020564d-2*gammaaa*t16*t3+7.2098765432098
     2           77d-2*t24**2-1.802469135802469d-1*t18*t24+1.72188616792
     3           99946d-3*t13
              t26 = 1.2437810945273631d+0*t25*t5+1.0d+0
              t27 = 8.04d-1-8.04d-1/t26
              t28 = 1/rhob**2.6666666666666666d+0
              t29 = 2.040060021774676d-2*gammabb*t28+1.0d+0
              t30 = 1/t29**2.0d+0
              t31 = gammabb**3
              t32 = 1/rhob**8
              t33 = gammabb**2
              t34 = 1/rhob**5.333333333333333d+0
              t35 = 1/rhob
              t36 = 1/taub
              t37 = gammabb*t35*t36
              t38 = t37**2.0d+0
              t39 = 1.5625d-2*t38+1.0d+0
              t40 = 1/t39**2.0d+0
              t41 = 2.485875d-2*t38*t40+1.234567901234568d-1
              t42 = 2.8125d-3*t38+1.35388578153653d-4*t33*t34
              t43 = t42**5.0d-1
              t44 = 1/rhob**1.6666666666666669d+0
              t45 = 2.0d+0*taub-2.5d-1*gammabb*t35
              t46 = 1.0970205230680374d-1*t44*t45-1.0d+0
              t47 = 4.38808209227215d-2*t44*t45*t46+1.0d+0
              t48 = 1/t47**5.0d-1
              t49 = 4.5d-1*t46*t48+1.0970205230680376d-2*gammabb*t28
              t50 = 7.209876543209877d-2*t49**2-1.802469135802469d-1*t43
     1           *t49+1.6455307846020564d-2*gammabb*t28*t41+1.7218861679
     2           299946d-3*t38+5.133173416322327d-6*t33*t34+1.5033019185
     3           692253d-6*t31*t32
              t51 = 1.2437810945273631d+0*t30*t50+1.0d+0
              t52 = 8.04d-1-8.04d-1/t51
              t53 = rhoa**3.333333333333333d-1
              t54 = 1/t26**2
              t55 = 1/rhoa**9
              t56 = 1/rhoa**6.333333333333333d+0
              t57 = 1/rhoa**3.6666666666666664d+0
              t58 = 1/rhoa**3
              t59 = 1/taua**2
              t60 = 1/rhoa**2
              t61 = 1/t14**3.0d+0
              t62 = t12**3.0d+0
              t63 = 1.553671875d-3*gammaaa*t11*t60*t61*t62-4.97175d-2*t1
     1           5*t58*t59*t8
              t64 = 2.7425513076700936d-2*gammaaa*t57-1.828367538446729d
     1           -1*t20*t3
              t65 = 4.38808209227215d-2*t19*t20*t64+1.0970205230680374d-
     1           2*gammaaa*t21*t57-7.313470153786916d-2*t20*t21*t3
              t66 = 1/t22**1.5d+0
              t67 = -2.25d-1*t21*t65*t66+4.5d-1*t23*t64-2.92538806151476
     1           7d-2*gammaaa*t57
              t68 = 1/t18
              t69 = -5.625d-3*t58*t59*t8-7.220724168194825d-4*t56*t8
              t70 = -3.443772335859989d-3*t58*t59*t8-2.737692488705241d-
     1           5*t56*t8-9.012345679012345d-2*t24*t68*t69+1.44197530864
     2           19754d-1*t24*t67-1.802469135802469d-1*t18*t67+1.6455307
     3           846020564d-2*gammaaa*t3*t63-1.2026415348553804d-5*t55*t
     4           6-4.3880820922721503d-2*gammaaa*t16*t57
              t71 = 1/t4**3.0d+0
              t72 = 1.3532736462850253d-1*gammaaa*t25*t57*t71+1.24378109
     1           45273631d+0*t5*t70
              t73 = rhob**3.333333333333333d-1
              t74 = 1/t51**2
              t75 = 1/rhob**9
              t76 = 1/rhob**6.333333333333333d+0
              t77 = 1/rhob**3.6666666666666664d+0
              t78 = 1/rhob**3
              t79 = 1/taub**2
              t80 = 1/rhob**2
              t81 = 1/t39**3.0d+0
              t82 = t37**3.0d+0
              t83 = 1.553671875d-3*gammabb*t36*t80*t81*t82-4.97175d-2*t3
     1           3*t40*t78*t79
              t84 = 2.7425513076700936d-2*gammabb*t77-1.828367538446729d
     1           -1*t28*t45
              t85 = 4.38808209227215d-2*t44*t45*t84+1.0970205230680374d-
     1           2*gammabb*t46*t77-7.313470153786916d-2*t28*t45*t46
              t86 = 1/t47**1.5d+0
              t87 = -2.25d-1*t46*t85*t86+4.5d-1*t48*t84-2.92538806151476
     1           7d-2*gammabb*t77
              t88 = 1/t43
              t89 = -5.625d-3*t33*t78*t79-7.220724168194825d-4*t33*t76
              t90 = -9.012345679012345d-2*t49*t88*t89+1.4419753086419754
     1           d-1*t49*t87-1.802469135802469d-1*t43*t87+1.645530784602
     2           0564d-2*gammabb*t28*t83-3.443772335859989d-3*t33*t78*t7
     3           9-4.3880820922721503d-2*gammabb*t41*t77-2.7376924887052
     4           41d-5*t33*t76-1.2026415348553804d-5*t31*t75
              t91 = 1/t29**3.0d+0
              t92 = 1.3532736462850253d-1*gammabb*t50*t77*t91+1.24378109
     1           45273631d+0*t30*t90
              t93 = 4.97175d-2*gammaaa*t15*t59*t60-1.553671875d-3*t10*t1
     1           1*t61*t62
              t94 = 1/rhoa**4.333333333333333d+0
              t95 = -1.2034540280324706d-3*t20*t94-1.0970205230680374d-2
     1           *t21*t3
              t96 = -2.25d-1*t21*t66*t95-1.2341480884515421d-2*t23*t3+1.
     1           0970205230680376d-2*t3
              t97 = 2.70777156307306d-4*gammaaa*t9+5.625d-3*gammaaa*t59*
     1           t60
              t98 = -9.012345679012345d-2*t24*t68*t97+1.4419753086419754
     1           d-1*t24*t96-1.802469135802469d-1*t18*t96+1.645530784602
     2           0564d-2*gammaaa*t3*t93+1.0266346832644656d-5*gammaaa*t9
     3           +4.509905755707676d-6*t7*t8+3.443772335859989d-3*gammaa
     4           a*t59*t60+1.6455307846020564d-2*t16*t3
              t99 = 1.2437810945273631d+0*t5*t98-5.074776173568845d-2*t2
     1           5*t3*t71
              t100 = 4.97175d-2*gammabb*t40*t79*t80-1.553671875d-3*t35*t
     1           36*t81*t82
              t101 = 1/rhob**4.333333333333333d+0
              t102 = -1.0970205230680374d-2*t28*t46-1.2034540280324706d-
     1           3*t101*t45
              t103 = -2.25d-1*t102*t46*t86-1.2341480884515421d-2*t28*t48
     1           +1.0970205230680376d-2*t28
              t104 = 5.625d-3*gammabb*t79*t80+2.70777156307306d-4*gammab
     1           b*t34
              t105 = -9.012345679012345d-2*t104*t49*t88+3.44377233585998
     1           9d-3*gammabb*t79*t80+1.4419753086419754d-1*t103*t49-1.8
     2           02469135802469d-1*t103*t43+1.6455307846020564d-2*t28*t4
     3           1+1.0266346832644656d-5*gammabb*t34+4.509905755707676d-
     4           6*t32*t33+1.6455307846020564d-2*gammabb*t100*t28
              t106 = 1.2437810945273631d+0*t105*t30-5.074776173568845d-2
     1           *t28*t50*t91
              t107 = 1/taua**3
              t108 = 1.553671875d-3*gammaaa*t10*t59*t61*t62-4.97175d-2*t
     1           107*t15*t60*t8
              t109 = 1/rhoa**3.3333333333333337d+0
              t110 = 8.7761641845443d-2*t19*t21+9.627632224259765d-3*t10
     1           9*t20
              t111 = 9.873184707612337d-2*t19*t23-2.25d-1*t110*t21*t66
              t112 = 5.069444444444443d-4*t107*t24*t60*t68*t8-3.44377233
     1           5859989d-3*t107*t60*t8+1.6455307846020564d-2*gammaaa*t1
     2           08*t3+1.4419753086419754d-1*t111*t24-1.802469135802469d
     3           -1*t111*t18
              t113 = 1/taub**3
              t114 = 1.553671875d-3*gammabb*t35*t79*t81*t82-4.97175d-2*t
     1           113*t33*t40*t80
              t115 = 1/rhob**3.3333333333333337d+0
              t116 = 8.7761641845443d-2*t44*t46+9.627632224259765d-3*t11
     1           5*t45
              t117 = 9.873184707612337d-2*t44*t48-2.25d-1*t116*t46*t86
              t118 = 5.069444444444443d-4*t113*t33*t49*t80*t88-3.4437723
     1           35859989d-3*t113*t33*t80+1.4419753086419754d-1*t117*t49
     2           -1.802469135802469d-1*t117*t43+1.6455307846020564d-2*ga
     3           mmabb*t114*t28
              t119 = 1/rhoa**10
              t120 = 1/rhoa**7.333333333333333d+0
              t121 = 1/rhoa**4.666666666666667d+0
              t122 = 1/rhoa**4
              t123 = gammaaa**4
              t124 = 1/rhoa**6
              t125 = 1/taua**4
              t126 = 1/t14**4.0d+0
              t127 = t12**4.0d+0
              t128 = -4.6610156249999996d-3*t122*t13*t59*t61*t8+1.491525
     1           d-1*t122*t15*t59*t8+1.4565673828125d-4*t122*t126*t127*t
     2           59*t8-3.10734375d-3*gammaaa*t11*t58*t61*t62-3.10734375d
     3           -3*t123*t124*t125*t61
              t129 = t65**2
              t130 = 1/t22**2.5d+0
              t131 = 4.8756467691912775d-1*t20*t57-1.4626940307573832d-1
     1           *gammaaa*t121
              t132 = 2.194041046136075d-2*gammaaa*t57*t64-1.462694030757
     1           3832d-1*t20*t3*t64+1.950258707676511d-1*t20*t21*t57-5.8
     2           50776123029533d-2*gammaaa*t121*t21+4.38808209227215d-2*
     3           t131*t19*t20
              t133 = -4.5d-1*t64*t65*t66-2.25d-1*t132*t21*t66+4.5d-1*t13
     1           1*t23+3.375d-1*t129*t130*t21+1.0726422892220812d-1*gamm
     2           aaa*t121
              t134 = 1/t17**1.5d+0
              t135 = t69**2
              t136 = 1.6875d-2*t122*t59*t8+4.573125306523389d-3*t120*t8
              t137 = 1.0331317007579968d-2*t122*t59*t8+1.733871909513319
     1           5d-4*t120*t8-1.802469135802469d-1*t67*t68*t69-9.0123456
     2           79012345d-2*t136*t24*t68+1.4419753086419754d-1*t67**2-8
     3           .776164184544301d-2*gammaaa*t57*t63+1.0823773813698423d
     4           -4*t119*t6+1.6455307846020564d-2*gammaaa*t128*t3+4.5061
     5           728395061723d-2*t134*t135*t24+1.4419753086419754d-1*t13
     6           3*t24-1.802469135802469d-1*t133*t18+1.6089634338331218d
     7           -1*gammaaa*t121*t16
              t138 = 1/t4**4.0d+0
              t139 = 2.208607571445859d-2*t120*t138*t25*t8+2.70654729257
     1           00507d-1*gammaaa*t57*t70*t71-4.9620033697117594d-1*gamm
     2           aaa*t121*t25*t71+1.2437810945273631d+0*t137*t5
              t140 = -1.9950471787324697d+0*t53*t72-7.481426920246762d-1
     1           *t1*t139
              t141 = 1/rhoa**6.666666666666666d-1
              t142 = -4.1356699393293317d-1*t27-4.1356699393293317d-1
              t143 = 1/t26**3
              t144 = t72**2
              t145 = 1/rhob**10
              t146 = 1/rhob**7.333333333333333d+0
              t147 = 1/rhob**4.666666666666667d+0
              t148 = 1/rhob**4
              t149 = gammabb**4
              t150 = 1/rhob**6
              t151 = 1/taub**4
              t152 = 1/t39**4.0d+0
              t153 = t37**4.0d+0
              t154 = -3.10734375d-3*gammabb*t36*t78*t81*t82-4.6610156249
     1           999996d-3*t148*t33*t38*t79*t81-3.10734375d-3*t149*t150*
     2           t151*t81+1.491525d-1*t148*t33*t40*t79+1.4565673828125d-
     3           4*t148*t152*t153*t33*t79
              t155 = t85**2
              t156 = 1/t47**2.5d+0
              t157 = 4.8756467691912775d-1*t45*t77-1.4626940307573832d-1
     1           *gammabb*t147
              t158 = 2.194041046136075d-2*gammabb*t77*t84-1.462694030757
     1           3832d-1*t28*t45*t84+1.950258707676511d-1*t45*t46*t77-5.
     2           850776123029533d-2*gammabb*t147*t46+4.38808209227215d-2
     3           *t157*t44*t45
              t159 = -4.5d-1*t84*t85*t86-2.25d-1*t158*t46*t86+4.5d-1*t15
     1           7*t48+3.375d-1*t155*t156*t46+1.0726422892220812d-1*gamm
     2           abb*t147
              t160 = 1/t42**1.5d+0
              t161 = t89**2
              t162 = 1.6875d-2*t148*t33*t79+4.573125306523389d-3*t146*t3
     1           3
              t163 = -1.802469135802469d-1*t87*t88*t89-9.012345679012345
     1           d-2*t162*t49*t88+1.4419753086419754d-1*t87**2-8.7761641
     2           84544301d-2*gammabb*t77*t83+1.0331317007579968d-2*t148*
     3           t33*t79+4.5061728395061723d-2*t160*t161*t49+1.441975308
     4           6419754d-1*t159*t49-1.802469135802469d-1*t159*t43+1.608
     5           9634338331218d-1*gammabb*t147*t41+1.7338719095133195d-4
     6           *t146*t33+1.0823773813698423d-4*t145*t31+1.645530784602
     7           0564d-2*gammabb*t154*t28
              t164 = 1/t29**4.0d+0
              t165 = 2.7065472925700507d-1*gammabb*t77*t90*t91-4.9620033
     1           697117594d-1*gammabb*t147*t50*t91+2.208607571445859d-2*
     2           t146*t164*t33*t50+1.2437810945273631d+0*t163*t30
              t166 = -1.9950471787324697d+0*t73*t92-7.481426920246762d-1
     1           *t165*t2
              t167 = 1/rhob**6.666666666666666d-1
              t168 = -4.1356699393293317d-1*t52-4.1356699393293317d-1
              t169 = 1/t51**3
              t170 = t92**2
              t171 = 1/rhoa**5
              t172 = 1.553671875d-3*t11*t60*t61*t62+3.10734375d-3*t125*t
     1           171*t6*t61+4.6610156249999996d-3*gammaaa*t13*t58*t59*t6
     2           1-9.9435d-2*gammaaa*t15*t58*t59-1.4565673828125d-4*gamm
     3           aaa*t126*t127*t58*t59
              t173 = 5.214967454807371d-3*t20*t9-1.0970205230680374d-2*t
     1           3*t64+2.9253880615147665d-2*t21*t57-3.0086350700811765d
     2           -4*gammaaa*t56
              t174 = -2.25d-1*t64*t66*t95+3.375d-1*t130*t21*t65*t95+6.17
     1           0740442257711d-3*t3*t65*t66-2.25d-1*t173*t21*t66+3.2910
     2           615692041123d-2*t23*t57-2.925388061514767d-2*t57
              t175 = -1.1249999999999999d-2*gammaaa*t58*t59-1.4441448336
     1           38965d-3*gammaaa*t56
              t176 = 4.5061728395061723d-2*t134*t24*t69*t97-9.0123456790
     1           12345d-2*t67*t68*t97-9.012345679012345d-2*t68*t69*t96+1
     2           .4419753086419754d-1*t67*t96-4.3880820922721503d-2*gamm
     3           aaa*t57*t93-3.607924604566141d-5*t55*t8-9.0123456790123
     4           45d-2*t175*t24*t68+1.6455307846020564d-2*t3*t63-6.88754
     5           4671719978d-3*gammaaa*t58*t59-4.3880820922721503d-2*t16
     6           *t57-5.475384977410482d-5*gammaaa*t56+1.645530784602056
     7           4d-2*gammaaa*t172*t3+1.4419753086419754d-1*t174*t24-1.8
     8           02469135802469d-1*t174*t18
              t177 = 1.3532736462850253d-1*gammaaa*t57*t71*t98-5.0747761
     1           73568845d-2*t3*t70*t71+1.3532736462850253d-1*t25*t57*t7
     2           1-8.282278392921971d-3*gammaaa*t138*t25*t56+1.243781094
     3           5273631d+0*t176*t5
              t178 = -9.975235893662349d-1*t53*t99-7.481426920246762d-1*
     1           t1*t177
              t179 = 1/rhob**5
              t180 = 1.553671875d-3*t36*t80*t81*t82+4.6610156249999996d-
     1           3*gammabb*t38*t78*t79*t81+3.10734375d-3*t151*t179*t31*t
     2           81-9.9435d-2*gammabb*t40*t78*t79-1.4565673828125d-4*gam
     3           mabb*t152*t153*t78*t79
              t181 = -1.0970205230680374d-2*t28*t84+2.9253880615147665d-
     1           2*t46*t77-3.0086350700811765d-4*gammabb*t76+5.214967454
     2           807371d-3*t34*t45
              t182 = 6.170740442257711d-3*t28*t85*t86-2.25d-1*t102*t84*t
     1           86-2.25d-1*t181*t46*t86+3.375d-1*t102*t156*t46*t85+3.29
     2           10615692041123d-2*t48*t77-2.925388061514767d-2*t77
              t183 = -1.1249999999999999d-2*gammabb*t78*t79-1.4441448336
     1           38965d-3*gammabb*t76
              t184 = -9.012345679012345d-2*t103*t88*t89+4.50617283950617
     1           23d-2*t104*t160*t49*t89-9.012345679012345d-2*t104*t87*t
     2           88-9.012345679012345d-2*t183*t49*t88+1.4419753086419754
     3           d-1*t103*t87+1.6455307846020564d-2*t28*t83-6.8875446717
     4           19978d-3*gammabb*t78*t79-4.3880820922721503d-2*t41*t77-
     5           4.3880820922721503d-2*gammabb*t100*t77-5.47538497741048
     6           2d-5*gammabb*t76-3.607924604566141d-5*t33*t75+1.4419753
     7           086419754d-1*t182*t49-1.802469135802469d-1*t182*t43+1.6
     8           455307846020564d-2*gammabb*t180*t28
              t185 = -5.074776173568845d-2*t28*t90*t91+1.353273646285025
     1           3d-1*t50*t77*t91+1.3532736462850253d-1*gammabb*t105*t77
     2           *t91-8.282278392921971d-3*gammabb*t164*t50*t76+1.243781
     3           0945273631d+0*t184*t30
              t186 = -9.975235893662349d-1*t106*t73-7.481426920246762d-1
     1           *t185*t2
              t187 = -3.10734375d-3*t122*t125*t61*t8-4.6610156249999996d
     1           -3*t13*t59*t60*t61+4.97175d-2*t15*t59*t60+1.45656738281
     2           25d-4*t126*t127*t59*t60
              t188 = t95**2
              t189 = 1.2341480884515421d-2*t3*t66*t95-1.3538857815365296
     1           d-4*t21*t66*t9+3.375d-1*t130*t188*t21
              t190 = t97**2
              t191 = 2.70777156307306d-4*t9+5.625d-3*t59*t60
              t192 = -1.802469135802469d-1*t68*t96*t97+1.441975308641975
     1           4d-1*t96**2+3.291061569204113d-2*t3*t93+1.0266346832644
     2           656d-5*t9+9.019811511415352d-6*gammaaa*t7-9.01234567901
     3           2345d-2*t191*t24*t68+3.443772335859989d-3*t59*t60+1.645
     4           5307846020564d-2*gammaaa*t187*t3+4.5061728395061723d-2*
     5           t134*t190*t24+1.4419753086419754d-1*t189*t24-1.80246913
     6           5802469d-1*t18*t189
              t193 = -1.014955234713769d-1*t3*t71*t98+3.10585439734574d-
     1           3*t138*t25*t9+1.2437810945273631d+0*t192*t5
              t194 = t99**2
              t195 = -4.6610156249999996d-3*t38*t79*t80*t81-3.10734375d-
     1           3*t148*t151*t33*t81+4.97175d-2*t40*t79*t80+1.4565673828
     2           125d-4*t152*t153*t79*t80
              t196 = t102**2
              t197 = -1.3538857815365296d-4*t34*t46*t86+1.23414808845154
     1           21d-2*t102*t28*t86+3.375d-1*t156*t196*t46
              t198 = t104**2
              t199 = 5.625d-3*t79*t80+2.70777156307306d-4*t34
              t200 = -9.012345679012345d-2*t199*t49*t88-1.80246913580246
     1           9d-1*t103*t104*t88+3.443772335859989d-3*t79*t80+4.50617
     2           28395061723d-2*t160*t198*t49+1.4419753086419754d-1*t197
     3           *t49-1.802469135802469d-1*t197*t43+1.0266346832644656d-
     4           5*t34+9.019811511415352d-6*gammabb*t32+1.64553078460205
     5           64d-2*gammabb*t195*t28+3.291061569204113d-2*t100*t28+1.
     6           4419753086419754d-1*t103**2
              t201 = -1.014955234713769d-1*t105*t28*t91+3.10585439734574
     1           d-3*t164*t34*t50+1.2437810945273631d+0*t200*t30
              t202 = t106**2
              t203 = 1/taua**5
              t204 = -4.6610156249999996d-3*t107*t13*t58*t61*t8+9.9435d-
     1           2*t107*t15*t58*t8+1.4565673828125d-4*t107*t126*t127*t58
     2           *t8-1.553671875d-3*gammaaa*t59*t60*t61*t62-3.10734375d-
     3           3*t123*t171*t203*t61
              t205 = -3.209210741419921d-2*t20*t94+2.406908056064941d-3*
     1           gammaaa*t9+8.7761641845443d-2*t19*t64-1.462694030757383
     2           2d-1*t21*t3
              t206 = -4.9365923538061685d-2*t19*t65*t66-2.25d-1*t110*t64
     1           *t66-2.25d-1*t205*t21*t66+3.375d-1*t110*t130*t21*t65-1.
     2           6455307846020562d-1*t23*t3
              t207 = -2.5347222222222215d-4*t107*t134*t24*t60*t69*t8+5.0
     1           69444444444443d-4*t107*t60*t67*t68*t8-1.013888888888888
     2           6d-3*t107*t24*t58*t68*t8+6.887544671719978d-3*t107*t58*
     3           t8-9.012345679012345d-2*t111*t68*t69+1.4419753086419754
     4           d-1*t111*t67-4.3880820922721503d-2*gammaaa*t108*t57+1.6
     5           455307846020564d-2*gammaaa*t204*t3+1.4419753086419754d-
     6           1*t206*t24-1.802469135802469d-1*t18*t206
              t208 = 1.3532736462850253d-1*gammaaa*t112*t57*t71+1.243781
     1           0945273631d+0*t207*t5
              t209 = 1/taub**5
              t210 = -1.553671875d-3*gammabb*t79*t80*t81*t82-4.661015624
     1           9999996d-3*t113*t33*t38*t78*t81-3.10734375d-3*t149*t179
     2           *t209*t81+9.9435d-2*t113*t33*t40*t78+1.4565673828125d-4
     3           *t113*t152*t153*t33*t78
              t211 = 8.7761641845443d-2*t44*t84-1.4626940307573832d-1*t2
     1           8*t46-3.209210741419921d-2*t101*t45+2.406908056064941d-
     2           3*gammabb*t34
              t212 = -4.9365923538061685d-2*t44*t85*t86-2.25d-1*t116*t84
     1           *t86-2.25d-1*t211*t46*t86+3.375d-1*t116*t156*t46*t85-1.
     2           6455307846020562d-1*t28*t48
              t213 = -9.012345679012345d-2*t117*t88*t89-2.53472222222222
     1           15d-4*t113*t160*t33*t49*t80*t89+5.069444444444443d-4*t1
     2           13*t33*t80*t87*t88-1.0138888888888886d-3*t113*t33*t49*t
     3           78*t88+1.4419753086419754d-1*t117*t87+6.887544671719978
     4           d-3*t113*t33*t78-4.3880820922721503d-2*gammabb*t114*t77
     5           +1.4419753086419754d-1*t212*t49-1.802469135802469d-1*t2
     6           12*t43+1.6455307846020564d-2*gammabb*t210*t28
              t214 = 1.3532736462850253d-1*gammabb*t118*t77*t91+1.243781
     1           0945273631d+0*t213*t30
              t215 = 1.553671875d-3*t10*t59*t61*t62+4.6610156249999996d-
     1           3*gammaaa*t107*t13*t60*t61+3.10734375d-3*t122*t203*t6*t
     2           61-9.9435d-2*gammaaa*t107*t15*t60-1.4565673828125d-4*ga
     3           mmaaa*t107*t126*t127*t60
              t216 = -4.9365923538061685d-2*t19*t66*t95+3.375d-1*t110*t1
     1           30*t21*t95+1.0831086252292235d-3*t21*t66*t94+6.17074044
     2           2257711d-3*t110*t3*t66
              t217 = -2.5347222222222215d-4*t107*t134*t24*t60*t8*t97-9.0
     1           12345679012345d-2*t111*t68*t97+5.069444444444443d-4*t10
     2           7*t60*t68*t8*t96+1.4419753086419754d-1*t111*t96+1.01388
     3           88888888886d-3*gammaaa*t107*t24*t60*t68-6.8875446717199
     4           78d-3*gammaaa*t107*t60+1.6455307846020564d-2*gammaaa*t2
     5           15*t3+1.6455307846020564d-2*t108*t3+1.4419753086419754d
     6           -1*t216*t24-1.802469135802469d-1*t18*t216
              t218 = 1.2437810945273631d+0*t217*t5-5.074776173568845d-2*
     1           t112*t3*t71
              t219 = 1.553671875d-3*t35*t79*t81*t82+4.6610156249999996d-
     1           3*gammabb*t113*t38*t80*t81+3.10734375d-3*t148*t209*t31*
     2           t81-9.9435d-2*gammabb*t113*t40*t80-1.4565673828125d-4*g
     3           ammabb*t113*t152*t153*t80
              t220 = 1.0831086252292235d-3*t101*t46*t86-4.93659235380616
     1           85d-2*t102*t44*t86+6.170740442257711d-3*t116*t28*t86+3.
     2           375d-1*t102*t116*t156*t46
              t221 = 1.0138888888888886d-3*gammabb*t113*t49*t80*t88+5.06
     1           9444444444443d-4*t103*t113*t33*t80*t88-9.01234567901234
     2           5d-2*t104*t117*t88-2.5347222222222215d-4*t104*t113*t160
     3           *t33*t49*t80-6.887544671719978d-3*gammabb*t113*t80+1.44
     4           19753086419754d-1*t220*t49-1.802469135802469d-1*t220*t4
     5           3+1.6455307846020564d-2*gammabb*t219*t28+1.645530784602
     6           0564d-2*t114*t28+1.4419753086419754d-1*t103*t117
              t222 = 1.2437810945273631d+0*t221*t30-5.074776173568845d-2
     1           *t118*t28*t91
              t223 = t112**2
              t224 = 1/taua**6
              t225 = -4.6610156249999996d-3*t125*t13*t60*t61*t8+1.491525
     1           d-1*t125*t15*t60*t8+1.4565673828125d-4*t125*t126*t127*t
     2           60*t8-3.10734375d-3*gammaaa*t10*t107*t61*t62-3.10734375
     3           d-3*t122*t123*t224*t61
              t226 = t110**2
              t227 = -8.664869001833788d-3*t109*t21*t66-9.87318470761233
     1           7d-2*t110*t19*t66+3.375d-1*t130*t21*t226
              t228 = -1.520833333333333d-3*t125*t24*t60*t68*t8+1.0138888
     1           888888886d-3*t107*t111*t60*t68*t8+1.0331317007579968d-2
     2           *t125*t60*t8+1.6455307846020564d-2*gammaaa*t225*t3+1.44
     3           19753086419754d-1*t227*t24+1.4257812499999994d-6*t122*t
     4           123*t134*t224*t24-1.802469135802469d-1*t18*t227+1.44197
     5           53086419754d-1*t111**2
              t229 = t118**2
              t230 = 1/taub**6
              t231 = -3.10734375d-3*gammabb*t113*t35*t81*t82-4.661015624
     1           9999996d-3*t151*t33*t38*t80*t81-3.10734375d-3*t148*t149
     2           *t230*t81+1.491525d-1*t151*t33*t40*t80+1.4565673828125d
     3           -4*t151*t152*t153*t33*t80
              t232 = t116**2
              t233 = -8.664869001833788d-3*t115*t46*t86-9.87318470761233
     1           7d-2*t116*t44*t86+3.375d-1*t156*t232*t46
              t234 = -1.520833333333333d-3*t151*t33*t49*t80*t88+1.013888
     1           8888888886d-3*t113*t117*t33*t80*t88+1.0331317007579968d
     2           -2*t151*t33*t80+1.4419753086419754d-1*t233*t49+1.425781
     3           2499999994d-6*t148*t149*t160*t230*t49-1.802469135802469
     4           d-1*t233*t43+1.6455307846020564d-2*gammabb*t231*t28+1.4
     5           419753086419754d-1*t117**2
              t235 = 1/rhoa**11
              t236 = 1/rhoa**8.333333333333334d+0
              t237 = 1/rhoa**5.666666666666667d+0
              t238 = gammaaa**6
              t239 = 1/rhoa**7
              t240 = 1/t14**5.0d+0
              t241 = t12**5.0d+0
              t242 = 1/t22**3.5d+0
              t243 = 8.044817169165608d-1*gammaaa*t237-1.787737148703468
     1           2d+0*t121*t20
              t244 = -6.75d-1*t131*t65*t66-2.25d-1*t21*(5.85077612302953
     1           3d-1*t20*t57*t64-1.75523283690886d-1*gammaaa*t121*t64+3
     2           .2910615692041123d-2*gammaaa*t131*t57-2.194041046136075
     3           d-1*t131*t20*t3+4.38808209227215d-2*t19*t20*t243+3.2179
     4           26867666243d-1*gammaaa*t21*t237-7.150948594813873d-1*t1
     5           21*t20*t21)*t66-6.75d-1*t132*t64*t66-8.4375d-1*t21*t242
     6           *t65**3+1.0125000000000002d+0*t130*t132*t21*t65+1.01250
     7           00000000002d+0*t129*t130*t64+4.5d-1*t23*t243-5.00566401
     8           6369713d-1*gammaaa*t237
              t245 = 1/t17**2.5d+0
              t246 = 1/t4**5.0d+0
              t247 = 1/t26**4
              t248 = 1/rhob**11
              t249 = 1/rhob**8.333333333333334d+0
              t250 = 1/rhob**5.666666666666667d+0
              t251 = gammabb**6
              t252 = 1/rhob**7
              t253 = 1/t39**5.0d+0
              t254 = t37**5.0d+0
              t255 = 1/t47**3.5d+0
              t256 = 8.044817169165608d-1*gammabb*t250-1.787737148703468
     1           2d+0*t147*t45
              t257 = -6.75d-1*t157*t85*t86-2.25d-1*t46*(5.85077612302953
     1           3d-1*t45*t77*t84-1.75523283690886d-1*gammabb*t147*t84+3
     2           .2910615692041123d-2*gammabb*t157*t77-7.150948594813873
     3           d-1*t147*t45*t46+3.217926867666243d-1*gammabb*t250*t46+
     4           4.38808209227215d-2*t256*t44*t45-2.194041046136075d-1*t
     5           157*t28*t45)*t86-6.75d-1*t158*t84*t86-8.4375d-1*t255*t4
     6           6*t85**3+1.0125000000000002d+0*t156*t158*t46*t85+1.0125
     7           000000000002d+0*t155*t156*t84+4.5d-1*t256*t48-5.0056640
     8           16369713d-1*gammabb*t250
              t258 = 1/t42**2.5d+0
              t259 = 1/t29**5.0d+0
              t260 = 1/t51**4
              t261 = gammaaa**5
              t262 = -2.25d-1*t131*t66*t95+6.75d-1*t130*t64*t65*t95-8.43
     1           75d-1*t129*t21*t242*t95+3.375d-1*t130*t132*t21*t95-3.29
     2           10615692041123d-2*t57*t65*t66-2.25d-1*t21*(5.8507761230
     3           29533d-2*t57*t64-2.781315975897265d-2*t20*t56-1.0970205
     4           230680374d-2*t131*t3-1.072642289222081d-1*t121*t21+3.20
     5           9210741419921d-3*gammaaa*t120)*t66-4.5d-1*t173*t64*t66+
     6           6.170740442257711d-3*t132*t3*t66+6.75d-1*t130*t173*t21*
     7           t65-9.256110663386565d-3*t129*t130*t3-1.206722575374841
     8           2d-1*t121*t23+1.0726422892220812d-1*t121
              t263 = gammabb**5
              t264 = -3.2910615692041123d-2*t77*t85*t86-2.25d-1*t46*(5.8
     1           50776123029533d-2*t77*t84-2.781315975897265d-2*t45*t76-
     2           1.072642289222081d-1*t147*t46-1.0970205230680374d-2*t15
     3           7*t28+3.209210741419921d-3*gammabb*t146)*t86-4.5d-1*t18
     4           1*t84*t86+6.170740442257711d-3*t158*t28*t86-2.25d-1*t10
     5           2*t157*t86+6.75d-1*t102*t156*t84*t85+6.75d-1*t156*t181*
     6           t46*t85-1.2067225753748412d-1*t147*t48-8.4375d-1*t102*t
     7           155*t255*t46+3.375d-1*t102*t156*t158*t46-9.256110663386
     8           565d-3*t155*t156*t28+1.0726422892220812d-1*t147
              t265 = -3.2910615692041123d-2*t57*t66*t95-1.85122213267731
     1           32d-2*t130*t3*t65*t95+6.75d-1*t130*t173*t21*t95-1.35388
     2           57815365296d-4*t64*t66*t9+2.030828672304794d-4*t130*t21
     3           *t65*t9+7.220724168194822d-4*t21*t56*t66+1.234148088451
     4           5421d-2*t173*t3*t66-8.4375d-1*t188*t21*t242*t65+3.375d-
     5           1*t130*t188*t64
              t266 = -1.3538857815365296d-4*t34*t84*t86-3.29106156920411
     1           23d-2*t102*t77*t86+7.220724168194822d-4*t46*t76*t86+1.2
     2           341480884515421d-2*t181*t28*t86+2.030828672304794d-4*t1
     3           56*t34*t46*t85-8.4375d-1*t196*t255*t46*t85-1.8512221326
     4           773132d-2*t102*t156*t28*t85+3.375d-1*t156*t196*t84+6.75
     5           d-1*t102*t156*t181*t46
              t267 = -8.4375d-1*t21*t242*t95**3+6.092486016914382d-4*t13
     1           0*t21*t9*t95+1.1139303661766865d-5*t66*t7-2.77683319901
     2           597d-2*t130*t188*t3
              t268 = 1.1139303661766865d-5*t32*t86+6.092486016914382d-4*
     1           t102*t156*t34*t46-8.4375d-1*t102**3*t255*t46-2.77683319
     2           901597d-2*t156*t196*t28
              t269 = 1/taua**7
              t270 = -2.25d-1*t21*t66*(1.3906579879486325d-1*t20*t9-2.92
     1           53880615147665d-1*t3*t64+3.900517415353022d-1*t21*t57-2
     2           .0859869819229487d-2*gammaaa*t56+8.7761641845443d-2*t13
     3           1*t19)+1.6455307846020562d-1*t3*t65*t66-4.5d-1*t205*t64
     4           *t66-4.9365923538061685d-2*t132*t19*t66-2.25d-1*t110*t1
     5           31*t66+6.75d-1*t110*t130*t64*t65+6.75d-1*t130*t205*t21*
     6           t65+4.38808209227215d-1*t23*t57-8.4375d-1*t110*t129*t21
     7           *t242+3.375d-1*t110*t130*t132*t21+7.404888530709253d-2*
     8           t129*t130*t19
              t271 = 1/taub**7
              t272 = 1.6455307846020562d-1*t28*t85*t86-2.25d-1*t46*(-2.9
     1           253880615147665d-1*t28*t84+3.900517415353022d-1*t46*t77
     2           -2.0859869819229487d-2*gammabb*t76+1.3906579879486325d-
     3           1*t34*t45+8.7761641845443d-2*t157*t44)*t86-4.5d-1*t211*
     4           t84*t86-4.9365923538061685d-2*t158*t44*t86-2.25d-1*t116
     5           *t157*t86+6.75d-1*t116*t156*t84*t85+6.75d-1*t156*t211*t
     6           46*t85+4.38808209227215d-1*t48*t77-8.4375d-1*t116*t155*
     7           t255*t46+3.375d-1*t116*t156*t158*t46+7.404888530709253d
     8           -2*t155*t156*t44
              t273 = 8.227653923010281d-2*t3*t66*t95-8.4375d-1*t110*t21*
     1           t242*t65*t95+7.404888530709253d-2*t130*t19*t65*t95+3.37
     2           5d-1*t110*t130*t64*t95+3.375d-1*t130*t205*t21*t95+1.083
     3           1086252292235d-3*t64*t66*t94-1.6246629378438354d-3*t130
     4           *t21*t65*t94-4.693470709326635d-3*t21*t66*t9-1.64553078
     5           46020562d-2*t110*t57*t66+6.170740442257711d-3*t205*t3*t
     6           66-4.9365923538061685d-2*t173*t19*t66-9.256110663386565
     7           d-3*t110*t130*t3*t65+3.375d-1*t110*t130*t173*t21
              t274 = 1.0831086252292235d-3*t101*t84*t86-1.64553078460205
     1           62d-2*t116*t77*t86-4.693470709326635d-3*t34*t46*t86-4.9
     2           365923538061685d-2*t181*t44*t86+6.170740442257711d-3*t2
     3           11*t28*t86+8.227653923010281d-2*t102*t28*t86-8.4375d-1*
     4           t102*t116*t255*t46*t85-1.6246629378438354d-3*t101*t156*
     5           t46*t85+7.404888530709253d-2*t102*t156*t44*t85-9.256110
     6           663386565d-3*t116*t156*t28*t85+3.375d-1*t102*t116*t156*
     7           t84+3.375d-1*t102*t156*t211*t46+3.375d-1*t116*t156*t181
     8           *t46
              t275 = -3.249325875687671d-3*t130*t21*t94*t95-1.8512221326
     1           773132d-2*t110*t130*t3*t95+2.030828672304794d-4*t110*t1
     2           30*t21*t9-8.911442929413492d-5*t239*t66-8.4375d-1*t110*
     3           t188*t21*t242+7.404888530709253d-2*t130*t188*t19
              t276 = -8.911442929413492d-5*t252*t86+2.030828672304794d-4
     1           *t116*t156*t34*t46-8.4375d-1*t116*t196*t255*t46-3.24932
     2           5875687671d-3*t101*t102*t156*t46+7.404888530709253d-2*t
     3           156*t196*t44-1.8512221326773132d-2*t102*t116*t156*t28
              t277 = -8.4375d-1*t21*t226*t242*t95+1.2997303502750684d-2*
     1           t109*t130*t21*t95+1.4809777061418505d-1*t110*t130*t19*t
     2           95-3.249325875687671d-3*t110*t130*t21*t94+7.12915434353
     3           0794d-4*t124*t66-9.256110663386565d-3*t130*t226*t3
              t278 = 7.129154343530794d-4*t150*t86-8.4375d-1*t102*t232*t
     1           255*t46-3.249325875687671d-3*t101*t116*t156*t46+1.29973
     2           03502750684d-2*t102*t115*t156*t46+1.4809777061418505d-1
     3           *t102*t116*t156*t44-9.256110663386565d-3*t156*t232*t28
              t279 = 1/taua**9
              t280 = -5.703323474824635d-3*t171*t66-8.4375d-1*t110**3*t2
     1           1*t242+2.2214665592127758d-1*t130*t19*t226+3.8991910508
     2           25205d-2*t109*t110*t130*t21
              t281 = 1/taub**9
              t282 = -5.703323474824635d-3*t179*t86-8.4375d-1*t116**3*t2
     1           55*t46+3.899191050825205d-2*t115*t116*t156*t46+2.221466
     2           5592127758d-1*t156*t232*t44
              fnc(iq) = (-9.305257363490997d-1*t2*t52-9.305257363490997d
     1           -1*t1*t27-9.305257363490997d-1*t2-9.305257363490997d-1*
     2           t1)*wght+fnc(iq)
              Amat(iq,D1_RA) = (-7.481426920246762d-1*t1*t54*t72-1.24070
     1           09817987995d+0*t27*t53-1.2407009817987995d+0*t53)*wght+
     2           Amat(iq,D1_RA)
              Amat(iq,D1_RB) = (-7.481426920246762d-1*t2*t74*t92-1.24070
     1           09817987995d+0*t52*t73-1.2407009817987995d+0*t73)*wght+
     2           Amat(iq,D1_RB)
              Cmat(iq,D1_GAA) = Cmat(iq,D1_GAA)-7.481426920246762d-1*t1*
     1           t54*t99*wght
              Cmat(iq,D1_GAB) = Cmat(iq,D1_GAB)
              Cmat(iq,D1_GBB) = Cmat(iq,D1_GBB)-7.481426920246762d-1*t10
     1           6*t2*t74*wght
              Mmat(iq,D1_TA) = Mmat(iq,D1_TA)-9.305257363490997d-1*t1*t1
     1           12*t5*t54*wght
              Mmat(iq,D1_TB) = Mmat(iq,D1_TB)-9.305257363490997d-1*t118*
     1           t2*t30*t74*wght
              Amat2(iq,D2_RA_RA) = (t140*t54+1.4962853840493523d+0*t1*t1
     1           43*t144+t141*t142)*wght+Amat2(iq,D2_RA_RA)
              Amat2(iq,D2_RA_RB) = Amat2(iq,D2_RA_RB)
              Amat2(iq,D2_RB_RB) = (t166*t74+1.4962853840493523d+0*t169*
     1           t170*t2+t167*t168)*wght+Amat2(iq,D2_RB_RB)
              Cmat2(iq,D2_RA_GAA) = (1.4962853840493523d+0*t1*t143*t72*t
     1           99+t178*t54)*wght+Cmat2(iq,D2_RA_GAA)
              Cmat2(iq,D2_RA_GAB) = Cmat2(iq,D2_RA_GAB)
              Cmat2(iq,D2_RA_GBB) = Cmat2(iq,D2_RA_GBB)
              Cmat2(iq,D2_RB_GAA) = Cmat2(iq,D2_RB_GAA)
              Cmat2(iq,D2_RB_GAB) = Cmat2(iq,D2_RB_GAB)
              Cmat2(iq,D2_RB_GBB) = (1.4962853840493523d+0*t106*t169*t2*
     1           t92+t186*t74)*wght+Cmat2(iq,D2_RB_GBB)
              Cmat2(iq,D2_GAA_GAA) = -7.481426920246762d-1*t1*t193*t54*w
     1           ght+1.4962853840493523d+0*t1*t143*t194*wght+Cmat2(iq,D2
     2           _GAA_GAA)
              Cmat2(iq,D2_GAA_GAB) = Cmat2(iq,D2_GAA_GAB)
              Cmat2(iq,D2_GAA_GBB) = Cmat2(iq,D2_GAA_GBB)
              Cmat2(iq,D2_GAB_GAB) = Cmat2(iq,D2_GAB_GAB)
              Cmat2(iq,D2_GAB_GBB) = Cmat2(iq,D2_GAB_GBB)
              Cmat2(iq,D2_GBB_GBB) = -7.481426920246762d-1*t2*t201*t74*w
     1           ght+1.4962853840493523d+0*t169*t2*t202*wght+Cmat2(iq,D2
     2           _GBB_GBB)
              Mmat2(iq,D2_RA_TA) = (1.8610514726981991d+0*t1*t112*t143*t
     1           5*t72-1.2407009817987995d+0*t112*t5*t53*t54-7.481426920
     2           246762d-1*t1*t208*t54)*wght+Mmat2(iq,D2_RA_TA)
              Mmat2(iq,D2_RA_TB) = Mmat2(iq,D2_RA_TB)
              Mmat2(iq,D2_RB_TA) = Mmat2(iq,D2_RB_TA)
              Mmat2(iq,D2_RB_TB) = (1.8610514726981991d+0*t118*t169*t2*t
     1           30*t92-1.2407009817987995d+0*t118*t30*t73*t74-7.4814269
     2           20246762d-1*t2*t214*t74)*wght+Mmat2(iq,D2_RB_TB)
              Mmat2(iq,D2_GAA_TA) = 1.8610514726981991d+0*t1*t112*t143*t
     1           5*t99*wght-7.481426920246762d-1*t1*t218*t54*wght+Mmat2(
     2           iq,D2_GAA_TA)
              Mmat2(iq,D2_GAA_TB) = Mmat2(iq,D2_GAA_TB)
              Mmat2(iq,D2_GAB_TA) = Mmat2(iq,D2_GAB_TA)
              Mmat2(iq,D2_GAB_TB) = Mmat2(iq,D2_GAB_TB)
              Mmat2(iq,D2_GBB_TA) = Mmat2(iq,D2_GBB_TA)
              Mmat2(iq,D2_GBB_TB) = -7.481426920246762d-1*t2*t222*t74*wg
     1           ht+1.8610514726981991d+0*t106*t118*t169*t2*t30*wght+Mma
     2           t2(iq,D2_GBB_TB)
              Mmat2(iq,D2_TA_TA) = -9.305257363490997d-1*t1*t228*t5*t54*
     1           wght+2.3147406376843277d+0*t1*t138*t143*t223*wght+Mmat2
     2           (iq,D2_TA_TA)
              Mmat2(iq,D2_TA_TB) = Mmat2(iq,D2_TA_TB)
              Mmat2(iq,D2_TB_TB) = -9.305257363490997d-1*t2*t234*t30*t74
     1           *wght+2.3147406376843277d+0*t164*t169*t2*t229*wght+Mmat
     2           2(iq,D2_TB_TB)
              Amat3(iq,D3_RA_RA_RA) = (t54*(-7.481426920246762d-1*t1*(1.
     1           2437810945273631d+0*t5*(1.6455307846020564d-2*gammaaa*t
     2           3*(2.796609375d-2*t13*t171*t59*t61*t8-5.9661d-1*t15*t17
     3           1*t59*t8-8.739404296874999d-4*t126*t127*t171*t59*t8+9.3
     4           22031249999999d-3*gammaaa*t11*t122*t61*t62-1.0195971679
     5           687499d-3*t107*t124*t126*t6*t62+3.7288125d-2*t123*t125*
     6           t239*t61+1.8207092285156248d-5*t107*t124*t240*t241*t6-2
     7           .913134765625d-4*t126*t224*t238*t55)-9.012345679012345d
     8           -2*t24*t68*(-6.75d-2*t171*t59*t8-3.3536252247838183d-2*
     9           t236*t8)-4.132526803031987d-2*t171*t59*t8-1.27150606697
     :           64344d-3*t236*t8-6.759259259259258d-2*t24*t245*t69**3-2
     ;           .703703703703703d-1*t133*t68*t69+1.3518518518518516d-1*
     <           t134*t136*t24*t69-2.703703703703703d-1*t136*t67*t68+1.3
     =           518518518518516d-1*t134*t135*t67+4.3259259259259264d-1*
     >           t133*t67+4.826890301499366d-1*gammaaa*t121*t63-1.082377
     ?           3813698424d-3*t235*t6-1.3164246276816452d-1*gammaaa*t12
     @           8*t57+1.4419753086419754d-1*t24*t244-1.802469135802469d
     1           -1*t18*t244-7.50849602455457d-1*gammaaa*t16*t237)+6.625
     2           822714337577d-2*t120*t138*t70*t8-2.4294683285904448d-1*
     3           t138*t236*t25*t8-1.4886010109135278d+0*gammaaa*t121*t70
     4           *t71+4.059820938855076d-1*gammaaa*t137*t57*t71+2.315601
     5           5725321547d+0*gammaaa*t237*t25*t71+4.80607147764859d-3*
     6           t235*t246*t25*t6)-6.650157262441565d-1*t141*t72-2.99257
     7           07680987046d+0*t139*t53)-4.488856152148057d+0*t1*t247*t
     8           72**3+t143*(-2*t140*t72+2.9925707680987046d+0*t1*t139*t
     9           72+1.9950471787324697d+0*t144*t53)-3.325078631220783d-1
     :           *t141*t54*t72-6.666666666666666d-1*t142*t19)*wght+Amat3
     ;           (iq,D3_RA_RA_RA)
              Amat3(iq,D3_RA_RA_RB) = Amat3(iq,D3_RA_RA_RB)
              Amat3(iq,D3_RA_RB_RB) = Amat3(iq,D3_RA_RB_RB)
              Amat3(iq,D3_RB_RB_RB) = (-4.488856152148057d+0*t2*t260*t92
     1           **3+t169*(2.9925707680987046d+0*t165*t2*t92-2*t166*t92+
     2           1.9950471787324697d+0*t170*t73)+t74*(-6.650157262441565
     3           d-1*t167*t92-7.481426920246762d-1*t2*(-1.48860101091352
     4           78d+0*gammabb*t147*t90*t91+4.059820938855076d-1*gammabb
     5           *t163*t77*t91+2.3156015725321547d+0*gammabb*t250*t50*t9
     6           1+6.625822714337577d-2*t146*t164*t33*t90+1.243781094527
     7           3631d+0*t30*(-6.759259259259258d-2*t258*t49*t89**3-2.70
     8           3703703703703d-1*t159*t88*t89+1.3518518518518516d-1*t16
     9           0*t162*t49*t89-2.703703703703703d-1*t162*t87*t88-9.0123
     :           45679012345d-2*t49*(-6.75d-2*t179*t33*t79-3.35362522478
     ;           38183d-2*t249*t33)*t88+1.3518518518518516d-1*t160*t161*
     <           t87+4.3259259259259264d-1*t159*t87+4.826890301499366d-1
     =           *gammabb*t147*t83+1.6455307846020564d-2*gammabb*t28*(9.
     >           322031249999999d-3*gammabb*t148*t36*t81*t82-1.019597167
     ?           9687499d-3*t113*t150*t152*t31*t82+2.796609375d-2*t179*t
     @           33*t38*t79*t81+3.7288125d-2*t149*t151*t252*t81-5.9661d-
     1           1*t179*t33*t40*t79-8.739404296874999d-4*t152*t153*t179*
     2           t33*t79-2.913134765625d-4*t152*t230*t251*t75+1.82070922
     3           85156248d-5*t113*t150*t253*t254*t31)-4.132526803031987d
     4           -2*t179*t33*t79-1.3164246276816452d-1*gammabb*t154*t77+
     5           1.4419753086419754d-1*t257*t49-1.802469135802469d-1*t25
     6           7*t43-7.50849602455457d-1*gammabb*t250*t41-1.2715060669
     7           764344d-3*t249*t33-1.0823773813698424d-3*t248*t31)-2.42
     8           94683285904448d-1*t164*t249*t33*t50+4.80607147764859d-3
     9           *t248*t259*t31*t50)-2.9925707680987046d+0*t165*t73)-3.3
     :           25078631220783d-1*t167*t74*t92-6.666666666666666d-1*t16
     ;           8*t44)*wght+Amat3(iq,D3_RB_RB_RB)
              Cmat3(iq,D3_RA_RA_GAA) = (t143*(2.9925707680987046d+0*t1*t
     1           177*t72-2*t140*t99)-3.325078631220783d-1*t141*t54*t99-4
     2           .488856152148057d+0*t1*t144*t247*t99+t54*(-7.4814269202
     3           46762d-1*t1*(2.208607571445859d-2*t120*t138*t8*t98-4.96
     4           20033697117594d-1*gammaaa*t121*t71*t98+1.24378109452736
     5           31d+0*t5*(9.012345679012345d-2*t134*t67*t69*t97-9.01234
     6           5679012345d-2*t133*t68*t97-6.759259259259258d-2*t135*t2
     7           4*t245*t97+4.5061728395061723d-2*t134*t136*t24*t97-9.01
     8           2345679012345d-2*t136*t68*t96+4.5061728395061723d-2*t13
     9           4*t135*t96+1.4419753086419754d-1*t133*t96+1.60896343383
     :           31218d-1*gammaaa*t121*t93+1.6455307846020564d-2*gammaaa
     ;           *t3*(1.0195971679687499d-3*t107*t126*t171*t62*t8-1.8207
     <           092285156248d-5*t107*t171*t240*t241*t8+2.913134765625d-
     =           4*t126*t224*t261*t7-3.10734375d-3*t11*t58*t61*t62-3.107
     >           34375d-2*t124*t125*t6*t61-1.86440625d-2*gammaaa*t122*t1
     ?           3*t59*t61+2.98305d-1*gammaaa*t122*t15*t59+5.82626953125
     @           d-4*gammaaa*t122*t126*t127*t59)+3.2471321441095274d-4*t
     1           119*t8-1.802469135802469d-1*t174*t68*t69+9.012345679012
     2           345d-2*t134*t175*t24*t69-1.802469135802469d-1*t175*t67*
     3           t68-9.012345679012345d-2*t24*(3.375d-2*gammaaa*t122*t59
     4           +9.146250613046778d-3*gammaaa*t120)*t68+2.8839506172839
     5           51d-1*t174*t67-8.776164184544301d-2*t57*t63+2.066263401
     6           5159936d-2*gammaaa*t122*t59-8.776164184544301d-2*gammaa
     7           a*t172*t57+1.6455307846020564d-2*t128*t3+1.441975308641
     8           9754d-1*t24*t262-1.802469135802469d-1*t18*t262+1.608963
     9           4338331218d-1*t121*t16+3.467743819026639d-4*gammaaa*t12
     :           0)-1.8022768041182213d-3*t119*t246*t25*t8+2.70654729257
     ;           00507d-1*t57*t70*t71+2.7065472925700507d-1*gammaaa*t176
     <           *t57*t71-5.074776173568845d-2*t137*t3*t71-4.96200336971
     =           17594d-1*t121*t25*t71-1.6564556785843942d-2*gammaaa*t13
     >           8*t56*t70+7.454050553629774d-2*gammaaa*t120*t138*t25)-1
     ?           .9950471787324697d+0*t177*t53))*wght+Cmat3(iq,D3_RA_RA_
     @           GAA)
              Cmat3(iq,D3_RA_RA_GAB) = Cmat3(iq,D3_RA_RA_GAB)
              Cmat3(iq,D3_RA_RA_GBB) = Cmat3(iq,D3_RA_RA_GBB)
              Cmat3(iq,D3_RA_RB_GAA) = Cmat3(iq,D3_RA_RB_GAA)
              Cmat3(iq,D3_RA_RB_GAB) = Cmat3(iq,D3_RA_RB_GAB)
              Cmat3(iq,D3_RA_RB_GBB) = Cmat3(iq,D3_RA_RB_GBB)
              Cmat3(iq,D3_RB_RB_GAA) = Cmat3(iq,D3_RB_RB_GAA)
              Cmat3(iq,D3_RB_RB_GAB) = Cmat3(iq,D3_RB_RB_GAB)
              Cmat3(iq,D3_RB_RB_GBB) = (t169*(2.9925707680987046d+0*t185
     1           *t2*t92-2*t106*t166)+t74*(-7.481426920246762d-1*t2*(2.7
     2           065472925700507d-1*t77*t90*t91+2.7065472925700507d-1*ga
     3           mmabb*t184*t77*t91-4.9620033697117594d-1*t147*t50*t91-5
     4           .074776173568845d-2*t163*t28*t91-4.9620033697117594d-1*
     5           gammabb*t105*t147*t91-1.6564556785843942d-2*gammabb*t16
     6           4*t76*t90+1.2437810945273631d+0*t30*(-1.802469135802469
     7           d-1*t182*t88*t89+9.012345679012345d-2*t104*t160*t87*t89
     8           +9.012345679012345d-2*t160*t183*t49*t89-1.8024691358024
     9           69d-1*t183*t87*t88-9.012345679012345d-2*t49*(3.375d-2*g
     :           ammabb*t148*t79+9.146250613046778d-3*gammabb*t146)*t88-
     ;           9.012345679012345d-2*t103*t162*t88-9.012345679012345d-2
     <           *t104*t159*t88+2.883950617283951d-1*t182*t87-8.77616418
     =           4544301d-2*t77*t83+1.6455307846020564d-2*gammabb*t28*(-
     >           3.10734375d-3*t36*t78*t81*t82+1.0195971679687499d-3*t11
     ?           3*t152*t179*t33*t82-1.86440625d-2*gammabb*t148*t38*t79*
     @           t81-3.10734375d-2*t150*t151*t31*t81+2.98305d-1*gammabb*
     1           t148*t40*t79+5.82626953125d-4*gammabb*t148*t152*t153*t7
     2           9-1.8207092285156248d-5*t113*t179*t253*t254*t33+2.91313
     3           4765625d-4*t152*t230*t263*t32)+2.0662634015159936d-2*ga
     4           mmabb*t148*t79-8.776164184544301d-2*gammabb*t180*t77+1.
     5           4419753086419754d-1*t264*t49-6.759259259259258d-2*t104*
     6           t161*t258*t49+4.5061728395061723d-2*t104*t160*t162*t49-
     7           1.802469135802469d-1*t264*t43+1.6089634338331218d-1*t14
     8           7*t41+3.2471321441095274d-4*t145*t33+1.6455307846020564
     9           d-2*t154*t28+4.5061728395061723d-2*t103*t160*t161+1.441
     :           9753086419754d-1*t103*t159+1.6089634338331218d-1*gammab
     ;           b*t100*t147+3.467743819026639d-4*gammabb*t146)-1.802276
     <           8041182213d-3*t145*t259*t33*t50+7.454050553629774d-2*ga
     =           mmabb*t146*t164*t50+2.208607571445859d-2*t105*t146*t164
     >           *t33)-1.9950471787324697d+0*t185*t73)-3.325078631220783
     ?           d-1*t106*t167*t74-4.488856152148057d+0*t106*t170*t2*t26
     @           0)*wght+Cmat3(iq,D3_RB_RB_GBB)
              Cmat3(iq,D3_RA_GAA_GAA) = (t143*(-2*t178*t99+1.49628538404
     1           93523d+0*t1*t177*t99+1.4962853840493523d+0*t1*t193*t72)
     2           +t54*(-7.481426920246762d-1*t1*(2.7065472925700507d-1*t
     3           57*t71*t98-1.6564556785843942d-2*gammaaa*t138*t56*t98+1
     4           .2437810945273631d+0*t5*(9.012345679012345d-2*t134*t69*
     5           t96*t97-1.802469135802469d-1*t174*t68*t97+9.01234567901
     6           2345d-2*t134*t175*t24*t97-1.802469135802469d-1*t175*t68
     7           *t96+2.883950617283951d-1*t174*t96-8.776164184544301d-2
     8           *t57*t93+1.6455307846020564d-2*gammaaa*t3*(2.485875d-2*
     9           t125*t171*t61*t8-1.0195971679687499d-3*gammaaa*t107*t12
     :           2*t126*t62+9.322031249999999d-3*t13*t58*t59*t61-9.9435d
     ;           -2*t15*t58*t59-2.913134765625d-4*t126*t127*t58*t59+1.82
     <           07092285156248d-5*gammaaa*t107*t122*t240*t241-2.9131347
     =           65625d-4*t123*t126*t224*t239)-9.012345679012345d-2*t189
     >           *t68*t69-6.759259259259258d-2*t190*t24*t245*t69+4.50617
     ?           28395061723d-2*t134*t191*t24*t69-9.012345679012345d-2*t
     @           191*t67*t68-9.012345679012345d-2*t24*(-1.12499999999999
     1           99d-2*t58*t59-1.444144833638965d-3*t56)*t68+4.506172839
     2           5061723d-2*t134*t190*t67+1.4419753086419754d-1*t189*t67
     3           -6.887544671719978d-3*t58*t59-4.3880820922721503d-2*gam
     4           maaa*t187*t57-5.475384977410482d-5*t56-7.21584920913228
     5           2d-5*gammaaa*t55+3.291061569204113d-2*t172*t3+1.4419753
     6           086419754d-1*t24*t265-1.802469135802469d-1*t18*t265)+3.
     7           10585439734574d-3*t138*t70*t9+1.3532736462850253d-1*gam
     8           maaa*t192*t57*t71-1.014955234713769d-1*t176*t3*t71-1.65
     9           64556785843942d-2*t138*t25*t56+6.758538015443329d-4*gam
     :           maaa*t246*t25*t55)-9.975235893662349d-1*t193*t53)-4.488
     ;           856152148057d+0*t1*t194*t247*t72)*wght+Cmat3(iq,D3_RA_G
     <           AA_GAA)
              Cmat3(iq,D3_RA_GAA_GAB) = Cmat3(iq,D3_RA_GAA_GAB)
              Cmat3(iq,D3_RA_GAA_GBB) = Cmat3(iq,D3_RA_GAA_GBB)
              Cmat3(iq,D3_RA_GAB_GAB) = Cmat3(iq,D3_RA_GAB_GAB)
              Cmat3(iq,D3_RA_GAB_GBB) = Cmat3(iq,D3_RA_GAB_GBB)
              Cmat3(iq,D3_RA_GBB_GBB) = Cmat3(iq,D3_RA_GBB_GBB)
              Cmat3(iq,D3_RB_GAA_GAA) = Cmat3(iq,D3_RB_GAA_GAA)
              Cmat3(iq,D3_RB_GAA_GAB) = Cmat3(iq,D3_RB_GAA_GAB)
              Cmat3(iq,D3_RB_GAA_GBB) = Cmat3(iq,D3_RB_GAA_GBB)
              Cmat3(iq,D3_RB_GAB_GAB) = Cmat3(iq,D3_RB_GAB_GAB)
              Cmat3(iq,D3_RB_GAB_GBB) = Cmat3(iq,D3_RB_GAB_GBB)
              Cmat3(iq,D3_RB_GBB_GBB) = (t169*(1.4962853840493523d+0*t2*
     1           t201*t92+1.4962853840493523d+0*t106*t185*t2-2*t106*t186
     2           )-4.488856152148057d+0*t2*t202*t260*t92+t74*(-7.4814269
     3           20246762d-1*t2*(1.3532736462850253d-1*gammabb*t200*t77*
     4           t91+2.7065472925700507d-1*t105*t77*t91-1.01495523471376
     5           9d-1*t184*t28*t91+3.10585439734574d-3*t164*t34*t90+1.24
     6           37810945273631d+0*t30*(-9.012345679012345d-2*t197*t88*t
     7           89-6.759259259259258d-2*t198*t258*t49*t89+4.50617283950
     8           61723d-2*t160*t199*t49*t89+9.012345679012345d-2*t103*t1
     9           04*t160*t89-9.012345679012345d-2*t199*t87*t88-9.0123456
     :           79012345d-2*t49*(-1.1249999999999999d-2*t78*t79-1.44414
     ;           4833638965d-3*t76)*t88-1.802469135802469d-1*t103*t183*t
     <           88-1.802469135802469d-1*t104*t182*t88+4.506172839506172
     =           3d-2*t160*t198*t87+1.4419753086419754d-1*t197*t87+1.645
     >           5307846020564d-2*gammabb*t28*(-1.0195971679687499d-3*ga
     ?           mmabb*t113*t148*t152*t82+9.322031249999999d-3*t38*t78*t
     @           79*t81+2.485875d-2*t151*t179*t33*t81-9.9435d-2*t40*t78*
     1           t79-2.913134765625d-4*t152*t153*t78*t79+1.8207092285156
     2           248d-5*gammabb*t113*t148*t253*t254-2.913134765625d-4*t1
     3           49*t152*t230*t252)-6.887544671719978d-3*t78*t79-4.38808
     4           20922721503d-2*gammabb*t195*t77-8.776164184544301d-2*t1
     5           00*t77-5.475384977410482d-5*t76-7.215849209132282d-5*ga
     6           mmabb*t75+1.4419753086419754d-1*t266*t49+9.012345679012
     7           345d-2*t104*t160*t183*t49-1.802469135802469d-1*t266*t43
     8           +3.291061569204113d-2*t180*t28+2.883950617283951d-1*t10
     9           3*t182)-1.6564556785843942d-2*t164*t50*t76-1.6564556785
     :           843942d-2*gammabb*t105*t164*t76+6.758538015443329d-4*ga
     ;           mmabb*t259*t50*t75)-9.975235893662349d-1*t201*t73))*wgh
     <           t+Cmat3(iq,D3_RB_GBB_GBB)
              Cmat3(iq,D3_GAA_GAA_GAA) = -4.488856152148057d+0*t1*t247*t
     1           99**3*wght+4.488856152148057d+0*t1*t143*t193*t99*wght-7
     2           .481426920246762d-1*t1*t54*(9.317563192037218d-3*t138*t
     3           9*t98+1.2437810945273631d+0*t5*(-6.759259259259258d-2*t
     4           24*t245*t97**3-2.703703703703703d-1*t189*t68*t97+1.3518
     5           518518518516d-1*t134*t191*t24*t97-2.703703703703703d-1*
     6           t191*t68*t96+1.3518518518518516d-1*t134*t190*t96+4.3259
     7           259259259264d-1*t189*t96+9.019811511415352d-6*t7+1.6455
     8           307846020564d-2*gammaaa*t3*(1.0195971679687499d-3*t107*
     9           t126*t58*t62-1.86440625d-2*gammaaa*t122*t125*t61+2.9131
     :           34765625d-4*t124*t126*t224*t6-1.8207092285156248d-5*t10
     ;           7*t240*t241*t58)+4.9365923538061696d-2*t187*t3+1.441975
     <           3086419754d-1*t24*t267-1.802469135802469d-1*t18*t267)-1
     =           .5224328520706534d-1*t192*t3*t71-2.534451755791249d-4*t
     >           246*t25*t7)*wght+Cmat3(iq,D3_GAA_GAA_GAA)
              Cmat3(iq,D3_GAA_GAA_GAB) = Cmat3(iq,D3_GAA_GAA_GAB)
              Cmat3(iq,D3_GAA_GAA_GBB) = Cmat3(iq,D3_GAA_GAA_GBB)
              Cmat3(iq,D3_GAA_GAB_GAB) = Cmat3(iq,D3_GAA_GAB_GAB)
              Cmat3(iq,D3_GAA_GAB_GBB) = Cmat3(iq,D3_GAA_GAB_GBB)
              Cmat3(iq,D3_GAA_GBB_GBB) = Cmat3(iq,D3_GAA_GBB_GBB)
              Cmat3(iq,D3_GAB_GAB_GAB) = Cmat3(iq,D3_GAB_GAB_GAB)
              Cmat3(iq,D3_GAB_GAB_GBB) = Cmat3(iq,D3_GAB_GAB_GBB)
              Cmat3(iq,D3_GAB_GBB_GBB) = Cmat3(iq,D3_GAB_GBB_GBB)
              Cmat3(iq,D3_GBB_GBB_GBB) = -7.481426920246762d-1*t2*t74*(-
     1           1.5224328520706534d-1*t200*t28*t91+1.2437810945273631d+
     2           0*t30*(-2.703703703703703d-1*t103*t199*t88-2.7037037037
     3           03703d-1*t104*t197*t88+1.6455307846020564d-2*gammabb*t2
     4           8*(1.0195971679687499d-3*t113*t152*t78*t82-1.86440625d-
     5           2*gammabb*t148*t151*t81-1.8207092285156248d-5*t113*t253
     6           *t254*t78+2.913134765625d-4*t150*t152*t230*t31)+1.44197
     7           53086419754d-1*t268*t49-6.759259259259258d-2*t104**3*t2
     8           58*t49+1.3518518518518516d-1*t104*t160*t199*t49-1.80246
     9           9135802469d-1*t268*t43+9.019811511415352d-6*t32+4.93659
     :           23538061696d-2*t195*t28+1.3518518518518516d-1*t103*t160
     ;           *t198+4.3259259259259264d-1*t103*t197)-2.53445175579124
     <           9d-4*t259*t32*t50+9.317563192037218d-3*t105*t164*t34)*w
     =           ght-4.488856152148057d+0*t106**3*t2*t260*wght+4.4888561
     >           52148057d+0*t106*t169*t2*t201*wght+Cmat3(iq,D3_GBB_GBB_
     ?           GBB)
              Mmat3(iq,D3_RA_RA_TA) = (t54*(-7.481426920246762d-1*t1*(1.
     1           2437810945273631d+0*t5*(1.6455307846020564d-2*gammaaa*t
     2           3*(1.86440625d-2*t107*t122*t13*t61*t8-2.98305d-1*t107*t
     3           122*t15*t8-5.82626953125d-4*t107*t122*t126*t127*t8-2.91
     4           3134765625d-4*t126*t238*t269*t7+3.10734375d-3*gammaaa*t
     5           58*t59*t61*t62-1.0195971679687499d-3*t125*t126*t171*t6*
     6           t62+3.10734375d-2*t123*t124*t203*t61+1.8207092285156248
     7           d-5*t125*t171*t240*t241*t6)-5.069444444444443d-4*t107*t
     8           134*t60*t67*t69*t8+1.0138888888888886d-3*t107*t134*t24*
     9           t58*t69*t8-2.0277777777777772d-3*t107*t58*t67*t68*t8+5.
     :           069444444444443d-4*t107*t133*t60*t68*t8+3.0416666666666
     ;           664d-3*t107*t122*t24*t68*t8+3.802083333333333d-4*t107*t
     <           135*t24*t245*t60*t8-2.5347222222222215d-4*t107*t134*t13
     =           6*t24*t60*t8-2.0662634015159936d-2*t107*t122*t8-1.80246
     >           9135802469d-1*t206*t68*t69-9.012345679012345d-2*t111*t1
     ?           36*t68+2.883950617283951d-1*t206*t67-8.776164184544301d
     @           -2*gammaaa*t204*t57+1.4419753086419754d-1*t24*t270-1.80
     1           2469135802469d-1*t18*t270+4.5061728395061723d-2*t111*t1
     2           34*t135+1.4419753086419754d-1*t111*t133+1.6089634338331
     3           218d-1*gammaaa*t108*t121)+2.208607571445859d-2*t112*t12
     4           0*t138*t8+2.7065472925700507d-1*gammaaa*t207*t57*t71-4.
     5           9620033697117594d-1*gammaaa*t112*t121*t71)-1.9950471787
     6           324697d+0*t208*t53)+2.9925707680987046d+0*t1*t143*t208*
     7           t72-4.1356699393293317d-1*t112*t141*t5*t54-5.5831544180
     8           94598d+0*t1*t112*t144*t247*t5-2.4875621890547261d+0*t11
     9           2*t140*t143*t5)*wght+Mmat3(iq,D3_RA_RA_TA)
              Mmat3(iq,D3_RA_RA_TB) = Mmat3(iq,D3_RA_RA_TB)
              Mmat3(iq,D3_RA_RB_TA) = Mmat3(iq,D3_RA_RB_TA)
              Mmat3(iq,D3_RA_RB_TB) = Mmat3(iq,D3_RA_RB_TB)
              Mmat3(iq,D3_RB_RB_TA) = Mmat3(iq,D3_RB_RB_TA)
              Mmat3(iq,D3_RB_RB_TB) = (2.9925707680987046d+0*t169*t2*t21
     1           4*t92+t74*(-7.481426920246762d-1*t2*(2.7065472925700507
     2           d-1*gammabb*t213*t77*t91-4.9620033697117594d-1*gammabb*
     3           t118*t147*t91+1.2437810945273631d+0*t30*(-1.80246913580
     4           2469d-1*t212*t88*t89-5.069444444444443d-4*t113*t160*t33
     5           *t80*t87*t89+1.0138888888888886d-3*t113*t160*t33*t49*t7
     6           8*t89-2.0277777777777772d-3*t113*t33*t78*t87*t88+5.0694
     7           44444444443d-4*t113*t159*t33*t80*t88+3.0416666666666664
     8           d-3*t113*t148*t33*t49*t88-9.012345679012345d-2*t117*t16
     9           2*t88+2.883950617283951d-1*t212*t87+1.6455307846020564d
     :           -2*gammabb*t28*(3.10734375d-3*gammabb*t78*t79*t81*t82-1
     ;           .0195971679687499d-3*t151*t152*t179*t31*t82+1.86440625d
     <           -2*t113*t148*t33*t38*t81+3.10734375d-2*t149*t150*t209*t
     =           81-2.98305d-1*t113*t148*t33*t40-5.82626953125d-4*t113*t
     >           148*t152*t153*t33-2.913134765625d-4*t152*t251*t271*t32+
     ?           1.8207092285156248d-5*t151*t179*t253*t254*t31)+3.802083
     @           333333333d-4*t113*t161*t258*t33*t49*t80-2.5347222222222
     1           215d-4*t113*t160*t162*t33*t49*t80-8.776164184544301d-2*
     2           gammabb*t210*t77+1.4419753086419754d-1*t272*t49-1.80246
     3           9135802469d-1*t272*t43-2.0662634015159936d-2*t113*t148*
     4           t33+4.5061728395061723d-2*t117*t160*t161+1.441975308641
     5           9754d-1*t117*t159+1.6089634338331218d-1*gammabb*t114*t1
     6           47)+2.208607571445859d-2*t118*t146*t164*t33)-1.99504717
     7           87324697d+0*t214*t73)-4.1356699393293317d-1*t118*t167*t
     8           30*t74-5.583154418094598d+0*t118*t170*t2*t260*t30-2.487
     9           5621890547261d+0*t118*t166*t169*t30)*wght+Mmat3(iq,D3_R
     :           B_RB_TB)
              Mmat3(iq,D3_RA_GAA_TA) = (t143*(1.4962853840493523d+0*t1*t
     1           208*t99+1.4962853840493523d+0*t1*t218*t72)-5.5831544180
     2           94598d+0*t1*t112*t247*t5*t72*t99+t54*(-7.48142692024676
     3           2d-1*t1*(1.2437810945273631d+0*t5*(3.802083333333333d-4
     4           *t107*t24*t245*t60*t69*t8*t97-2.5347222222222215d-4*t10
     5           7*t134*t60*t67*t8*t97+5.069444444444443d-4*t107*t134*t2
     6           4*t58*t8*t97+4.5061728395061723d-2*t111*t134*t69*t97-9.
     7           012345679012345d-2*t206*t68*t97-2.5347222222222215d-4*t
     8           107*t134*t60*t69*t8*t96-1.0138888888888886d-3*t107*t58*
     9           t68*t8*t96+1.4419753086419754d-1*t206*t96+1.64553078460
     :           20564d-2*gammaaa*t3*(1.0195971679687499d-3*t122*t125*t1
     ;           26*t62*t8-1.8207092285156248d-5*t122*t125*t240*t241*t8-
     <           1.553671875d-3*t59*t60*t61*t62-2.796609375d-2*t171*t203
     =           *t6*t61-1.3983046875d-2*gammaaa*t107*t13*t58*t61+1.9887
     >           d-1*gammaaa*t107*t15*t58+4.369702148437499d-4*gammaaa*t
     ?           107*t126*t127*t58+2.913134765625d-4*t126*t239*t261*t269
     @           )+5.069444444444443d-4*t107*t174*t60*t68*t8-2.534722222
     1           2222215d-4*t107*t134*t175*t24*t60*t8-9.012345679012345d
     2           -2*t216*t68*t69-5.069444444444443d-4*gammaaa*t107*t134*
     3           t24*t60*t69+1.0138888888888886d-3*gammaaa*t107*t60*t67*
     4           t68-2.0277777777777772d-3*gammaaa*t107*t24*t58*t68-9.01
     5           2345679012345d-2*t111*t175*t68+1.4419753086419754d-1*t2
     6           16*t67+1.3775089343439956d-2*gammaaa*t107*t58-4.3880820
     7           922721503d-2*gammaaa*t215*t57-4.3880820922721503d-2*t10
     8           8*t57+1.6455307846020564d-2*t204*t3+1.4419753086419754d
     9           -1*t24*t273-1.802469135802469d-1*t18*t273+1.44197530864
     :           19754d-1*t111*t174)+1.3532736462850253d-1*gammaaa*t217*
     ;           t57*t71+1.3532736462850253d-1*t112*t57*t71-5.0747761735
     <           68845d-2*t207*t3*t71-8.282278392921971d-3*gammaaa*t112*
     =           t138*t56)-9.975235893662349d-1*t218*t53)-2.487562189054
     >           7261d+0*t112*t143*t178*t5)*wght+Mmat3(iq,D3_RA_GAA_TA)
              Mmat3(iq,D3_RA_GAA_TB) = Mmat3(iq,D3_RA_GAA_TB)
              Mmat3(iq,D3_RA_GAB_TA) = Mmat3(iq,D3_RA_GAB_TA)
              Mmat3(iq,D3_RA_GAB_TB) = Mmat3(iq,D3_RA_GAB_TB)
              Mmat3(iq,D3_RA_GBB_TA) = Mmat3(iq,D3_RA_GBB_TA)
              Mmat3(iq,D3_RA_GBB_TB) = Mmat3(iq,D3_RA_GBB_TB)
              Mmat3(iq,D3_RB_GAA_TA) = Mmat3(iq,D3_RB_GAA_TA)
              Mmat3(iq,D3_RB_GAA_TB) = Mmat3(iq,D3_RB_GAA_TB)
              Mmat3(iq,D3_RB_GAB_TA) = Mmat3(iq,D3_RB_GAB_TA)
              Mmat3(iq,D3_RB_GAB_TB) = Mmat3(iq,D3_RB_GAB_TB)
              Mmat3(iq,D3_RB_GBB_TA) = Mmat3(iq,D3_RB_GBB_TA)
              Mmat3(iq,D3_RB_GBB_TB) = (t169*(1.4962853840493523d+0*t2*t
     1           222*t92+1.4962853840493523d+0*t106*t2*t214)-5.583154418
     2           094598d+0*t106*t118*t2*t260*t30*t92+t74*(-7.48142692024
     3           6762d-1*t2*(1.3532736462850253d-1*gammabb*t221*t77*t91+
     4           1.3532736462850253d-1*t118*t77*t91-5.074776173568845d-2
     5           *t213*t28*t91+1.2437810945273631d+0*t30*(-9.01234567901
     6           2345d-2*t220*t88*t89+3.802083333333333d-4*t104*t113*t25
     7           8*t33*t49*t80*t89-5.069444444444443d-4*gammabb*t113*t16
     8           0*t49*t80*t89-2.5347222222222215d-4*t103*t113*t160*t33*
     9           t80*t89+4.5061728395061723d-2*t104*t117*t160*t89+1.0138
     :           888888888886d-3*gammabb*t113*t80*t87*t88+5.069444444444
     ;           443d-4*t113*t182*t33*t80*t88-2.0277777777777772d-3*gamm
     <           abb*t113*t49*t78*t88-1.0138888888888886d-3*t103*t113*t3
     =           3*t78*t88-9.012345679012345d-2*t104*t212*t88-9.01234567
     >           9012345d-2*t117*t183*t88-2.5347222222222215d-4*t104*t11
     ?           3*t160*t33*t80*t87+1.4419753086419754d-1*t220*t87+1.645
     @           5307846020564d-2*gammabb*t28*(-1.553671875d-3*t79*t80*t
     1           81*t82+1.0195971679687499d-3*t148*t151*t152*t33*t82-1.3
     2           983046875d-2*gammabb*t113*t38*t78*t81-2.796609375d-2*t1
     3           79*t209*t31*t81+1.9887d-1*gammabb*t113*t40*t78+4.369702
     4           148437499d-4*gammabb*t113*t152*t153*t78-1.8207092285156
     5           248d-5*t148*t151*t253*t254*t33+2.913134765625d-4*t152*t
     6           252*t263*t271)-2.5347222222222215d-4*t113*t160*t183*t33
     7           *t49*t80+5.069444444444443d-4*t104*t113*t160*t33*t49*t7
     8           8+1.3775089343439956d-2*gammabb*t113*t78-4.388082092272
     9           1503d-2*gammabb*t219*t77-4.3880820922721503d-2*t114*t77
     :           +1.4419753086419754d-1*t274*t49-1.802469135802469d-1*t2
     ;           74*t43+1.6455307846020564d-2*t210*t28+1.441975308641975
     <           4d-1*t103*t212+1.4419753086419754d-1*t117*t182)-8.28227
     =           8392921971d-3*gammabb*t118*t164*t76)-9.975235893662349d
     >           -1*t222*t73)-2.4875621890547261d+0*t118*t169*t186*t30)*
     ?           wght+Mmat3(iq,D3_RB_GBB_TB)
              Mmat3(iq,D3_RA_TA_TA) = 2.9925707680987046d+0*t1*t143*t218
     1           *t99*wght-7.481426920246762d-1*t1*t54*(1.24378109452736
     2           31d+0*t5*(-5.069444444444443d-4*t107*t134*t60*t8*t96*t9
     3           7-1.802469135802469d-1*t216*t68*t97-1.0138888888888886d
     4           -3*gammaaa*t107*t134*t24*t60*t97+2.0277777777777772d-3*
     5           gammaaa*t107*t60*t68*t96+2.883950617283951d-1*t216*t96+
     6           1.6455307846020564d-2*gammaaa*t3*(2.485875d-2*t122*t203
     7           *t61*t8-1.0195971679687499d-3*gammaaa*t125*t126*t58*t62
     8           +9.322031249999999d-3*t107*t13*t60*t61-9.9435d-2*t107*t
     9           15*t60-2.913134765625d-4*t107*t126*t127*t60+1.820709228
     :           5156248d-5*gammaaa*t125*t240*t241*t58-2.913134765625d-4
     ;           *t123*t124*t126*t269)+5.069444444444443d-4*t107*t189*t6
     <           0*t68*t8+3.802083333333333d-4*t107*t190*t24*t245*t60*t8
     =           -2.5347222222222215d-4*t107*t134*t191*t24*t60*t8+1.0138
     >           888888888886d-3*t107*t24*t60*t68-9.012345679012345d-2*t
     ?           111*t191*t68-6.887544671719978d-3*t107*t60+3.2910615692
     @           04113d-2*t215*t3+1.4419753086419754d-1*t24*t275-1.80246
     1           9135802469d-1*t18*t275+4.5061728395061723d-2*t111*t134*
     2           t190+1.4419753086419754d-1*t111*t189)+3.10585439734574d
     3           -3*t112*t138*t9-1.014955234713769d-1*t217*t3*t71)*wght-
     4           5.583154418094598d+0*t1*t112*t194*t247*t5*wght+1.861051
     5           4726981991d+0*t1*t112*t143*t193*t5*wght+Mmat3(iq,D3_RA_
     6           TA_TA)
              Mmat3(iq,D3_RA_TA_TB) = Mmat3(iq,D3_RA_TA_TB)
              Mmat3(iq,D3_RA_TB_TB) = Mmat3(iq,D3_RA_TB_TB)
              Mmat3(iq,D3_RB_TA_TA) = Mmat3(iq,D3_RB_TA_TA)
              Mmat3(iq,D3_RB_TA_TB) = Mmat3(iq,D3_RB_TA_TB)
              Mmat3(iq,D3_RB_TB_TB) = Mmat3(iq,D3_RB_TB_TB)
              Mmat3(iq,D3_GAA_GAA_TA) = Mmat3(iq,D3_GAA_GAA_TA)
              Mmat3(iq,D3_GAA_GAA_TB) = Mmat3(iq,D3_GAA_GAA_TB)
              Mmat3(iq,D3_GAA_GAB_TA) = Mmat3(iq,D3_GAA_GAB_TA)
              Mmat3(iq,D3_GAA_GAB_TB) = Mmat3(iq,D3_GAA_GAB_TB)
              Mmat3(iq,D3_GAA_GBB_TA) = Mmat3(iq,D3_GAA_GBB_TA)
              Mmat3(iq,D3_GAA_GBB_TB) = -7.481426920246762d-1*t2*t74*(-1
     1           .014955234713769d-1*t221*t28*t91+1.2437810945273631d+0*
     2           t30*(1.0138888888888886d-3*t113*t49*t80*t88+5.069444444
     3           444443d-4*t113*t197*t33*t80*t88+2.0277777777777772d-3*g
     4           ammabb*t103*t113*t80*t88-1.802469135802469d-1*t104*t220
     5           *t88-9.012345679012345d-2*t117*t199*t88+1.6455307846020
     6           564d-2*gammabb*t28*(-1.0195971679687499d-3*gammabb*t151
     7           *t152*t78*t82+9.322031249999999d-3*t113*t38*t80*t81+2.4
     8           85875d-2*t148*t209*t33*t81-9.9435d-2*t113*t40*t80-2.913
     9           134765625d-4*t113*t152*t153*t80+1.8207092285156248d-5*g
     :           ammabb*t151*t253*t254*t78-2.913134765625d-4*t149*t150*t
     ;           152*t271)+3.802083333333333d-4*t113*t198*t258*t33*t49*t
     <           80-2.5347222222222215d-4*t113*t160*t199*t33*t49*t80-1.0
     =           138888888888886d-3*gammabb*t104*t113*t160*t49*t80-5.069
     >           444444444443d-4*t103*t104*t113*t160*t33*t80-6.887544671
     ?           719978d-3*t113*t80+1.4419753086419754d-1*t276*t49-1.802
     @           469135802469d-1*t276*t43+3.291061569204113d-2*t219*t28+
     1           2.883950617283951d-1*t103*t220+4.5061728395061723d-2*t1
     2           17*t160*t198+1.4419753086419754d-1*t117*t197)+3.1058543
     3           9734574d-3*t118*t164*t34)*wght-5.583154418094598d+0*t11
     4           8*t2*t202*t260*t30*wght+1.8610514726981991d+0*t118*t169
     5           *t2*t201*t30*wght+2.9925707680987046d+0*t106*t169*t2*t2
     6           22*wght+Mmat3(iq,D3_GAA_GBB_TB)
              Mmat3(iq,D3_GAB_GAB_TA) = t143*t5*(1.8610514726981991d+0*t
     1           1*t228*t99*wght+3.7221029453963983d+0*t1*t112*t218*wght
     2           )-7.481426920246762d-1*t1*t54*(1.2437810945273631d+0*t5
     3           *(1.6455307846020564d-2*gammaaa*t3*(2.913134765625d-4*t
     4           124*t126*t261/taua**8+1.0195971679687499d-3*t126*t203*t
     5           58*t62*t8-1.8207092285156248d-5*t203*t240*t241*t58*t8-3
     6           .10734375d-3*t10*t107*t61*t62-1.86440625d-2*gammaaa*t12
     7           5*t13*t60*t61-3.10734375d-2*t122*t224*t6*t61+2.98305d-1
     8           *gammaaa*t125*t15*t60+5.82626953125d-4*gammaaa*t125*t12
     9           6*t127*t60)+7.604166666666664d-4*t125*t134*t24*t60*t8*t
     :           97-5.069444444444443d-4*t107*t111*t134*t60*t8*t97-9.012
     ;           345679012345d-2*t227*t68*t97-2.1386718749999997d-6*t122
     <           *t123*t224*t24*t245*t97-1.520833333333333d-3*t125*t60*t
     =           68*t8*t96+1.4419753086419754d-1*t227*t96+1.425781249999
     >           9994d-6*t122*t123*t134*t224*t96+1.0138888888888886d-3*t
     ?           107*t216*t60*t68*t8-3.041666666666666d-3*gammaaa*t125*t
     @           24*t60*t68+2.0277777777777772d-3*gammaaa*t107*t111*t60*
     1           t68+2.0662634015159936d-2*gammaaa*t125*t60+5.7031249999
     2           99998d-6*t122*t134*t224*t24*t6+1.6455307846020564d-2*t2
     3           25*t3+1.4419753086419754d-1*t24*t277-1.802469135802469d
     4           -1*t18*t277+2.883950617283951d-1*t111*t216)-5.074776173
     5           568845d-2*t228*t3*t71)*wght-6.944221913052981d+0*t1*t13
     6           8*t223*t247*t99*wght+Mmat3(iq,D3_GAB_GAB_TA)
              Mmat3(iq,D3_GAB_GAB_TB) = Mmat3(iq,D3_GAB_GAB_TB)
              Mmat3(iq,D3_GAB_GBB_TA) = Mmat3(iq,D3_GAB_GBB_TA)
              Mmat3(iq,D3_GAB_GBB_TB) = Mmat3(iq,D3_GAB_GBB_TB)
              Mmat3(iq,D3_GBB_GBB_TA) = Mmat3(iq,D3_GBB_GBB_TA)
              Mmat3(iq,D3_GBB_GBB_TB) = Mmat3(iq,D3_GBB_GBB_TB)
              Mmat3(iq,D3_GAA_TA_TA) = Mmat3(iq,D3_GAA_TA_TA)
              Mmat3(iq,D3_GAA_TA_TB) = Mmat3(iq,D3_GAA_TA_TB)
              Mmat3(iq,D3_GAA_TB_TB) = t169*t30*(1.8610514726981991d+0*t
     1           106*t2*t234*wght+3.7221029453963983d+0*t118*t2*t222*wgh
     2           t)-7.481426920246762d-1*t2*t74*(1.2437810945273631d+0*t
     3           30*(1.6455307846020564d-2*gammabb*t28*(2.913134765625d-
     4           4*t150*t152*t263/taub**8-3.10734375d-3*t113*t35*t81*t82
     5           +1.0195971679687499d-3*t152*t209*t33*t78*t82-1.86440625
     6           d-2*gammabb*t151*t38*t80*t81-3.10734375d-2*t148*t230*t3
     7           1*t81+2.98305d-1*gammabb*t151*t40*t80+5.82626953125d-4*
     8           gammabb*t151*t152*t153*t80-1.8207092285156248d-5*t209*t
     9           253*t254*t33*t78)-3.041666666666666d-3*gammabb*t151*t49
     :           *t80*t88+1.0138888888888886d-3*t113*t220*t33*t80*t88-1.
     ;           520833333333333d-3*t103*t151*t33*t80*t88+2.027777777777
     <           7772d-3*gammabb*t113*t117*t80*t88-9.012345679012345d-2*
     =           t104*t233*t88+7.604166666666664d-4*t104*t151*t160*t33*t
     >           49*t80-5.069444444444443d-4*t104*t113*t117*t160*t33*t80
     ?           +2.0662634015159936d-2*gammabb*t151*t80+5.7031249999999
     @           98d-6*t148*t160*t230*t31*t49+1.4419753086419754d-1*t278
     1           *t49-2.1386718749999997d-6*t104*t148*t149*t230*t258*t49
     2           -1.802469135802469d-1*t278*t43+1.6455307846020564d-2*t2
     3           31*t28+1.4419753086419754d-1*t103*t233+1.42578124999999
     4           94d-6*t103*t148*t149*t160*t230+2.883950617283951d-1*t11
     5           7*t220)-5.074776173568845d-2*t234*t28*t91)*wght-6.94422
     6           1913052981d+0*t106*t164*t2*t229*t260*wght+Mmat3(iq,D3_G
     7           AA_TB_TB)
              Mmat3(iq,D3_GAB_TA_TA) = -9.305257363490997d-1*t1*t5*t54*(
     1           1.6455307846020564d-2*gammaaa*t3*(2.796609375d-2*t13*t2
     2           03*t60*t61*t8-5.9661d-1*t15*t203*t60*t8-8.7394042968749
     3           99d-4*t126*t127*t203*t60*t8+9.322031249999999d-3*gammaa
     4           a*t10*t125*t61*t62-1.0195971679687499d-3*t126*t224*t58*
     5           t6*t62+3.7288125d-2*t122*t123*t269*t61+1.82070922851562
     6           48d-5*t224*t240*t241*t58*t6-2.913134765625d-4*t124*t126
     7           *t238*t279)+6.083333333333332d-3*t203*t24*t60*t68*t8+1.
     8           520833333333333d-3*t107*t227*t60*t68*t8-4.5624999999999
     9           99d-3*t111*t125*t60*t68*t8-4.132526803031987d-2*t203*t6
     :           0*t8+1.4419753086419754d-1*t24*t280-1.802469135802469d-
     ;           1*t18*t280+1.2030029296874996d-8*t124*t238*t24*t245*t27
     <           9-1.2832031249999995d-5*t122*t123*t134*t24*t269+4.32592
     =           59259259264d-1*t111*t227+4.2773437499999983d-6*t111*t12
     >           2*t123*t134*t224)*wght-8.637091931657939d+0*t1*t112**3*
     ?           t247*wght/t4**6.0d+0+6.944221913052984d+0*t1*t112*t138*
     @           t143*t228*wght+Mmat3(iq,D3_GAB_TA_TA)
              Mmat3(iq,D3_GAB_TA_TB) = Mmat3(iq,D3_GAB_TA_TB)
              Mmat3(iq,D3_GAB_TB_TB) = Mmat3(iq,D3_GAB_TB_TB)
              Mmat3(iq,D3_GBB_TA_TA) = -9.305257363490997d-1*t2*t30*t74*
     1           (6.083333333333332d-3*t209*t33*t49*t80*t88+1.5208333333
     2           33333d-3*t113*t233*t33*t80*t88-4.562499999999999d-3*t11
     3           7*t151*t33*t80*t88+1.6455307846020564d-2*gammabb*t28*(9
     4           .322031249999999d-3*gammabb*t151*t35*t81*t82-1.01959716
     5           79687499d-3*t152*t230*t31*t78*t82+2.796609375d-2*t209*t
     6           33*t38*t80*t81+3.7288125d-2*t148*t149*t271*t81-5.9661d-
     7           1*t209*t33*t40*t80-8.739404296874999d-4*t152*t153*t209*
     8           t33*t80+1.8207092285156248d-5*t230*t253*t254*t31*t78-2.
     9           913134765625d-4*t150*t152*t251*t281)-4.132526803031987d
     :           -2*t209*t33*t80+1.4419753086419754d-1*t282*t49+1.203002
     ;           9296874996d-8*t150*t251*t258*t281*t49-1.283203124999999
     <           5d-5*t148*t149*t160*t271*t49-1.802469135802469d-1*t282*
     =           t43+4.3259259259259264d-1*t117*t233+4.2773437499999983d
     >           -6*t117*t148*t149*t160*t230)*wght-8.637091931657939d+0*
     ?           t118**3*t2*t260*wght/t29**6.0d+0+6.944221913052984d+0*t
     @           118*t164*t169*t2*t234*wght+Mmat3(iq,D3_GBB_TA_TA)
            elseif (taua.gt.tol_rho.and.taub.le.tol_rho) then 
              t1 = rhoa**1.3333333333333333d+0
              t2 = rhob**1.3333333333333333d+0
              t3 = 1/rhob**1.6666666666666669d+0
              t4 = 1.0970205230680374d-51*t3-1.0d+0
              t5 = 4.3880820922721503d-52*t3*t4+1.0d+0
              t6 = 1/t5**5.0d-1
              t7 = 4.5d-1*t4*t6+4.3880820922721503d-52*t3
              t8 = 1/rhob**3.3333333333333337d+0
              t9 = 2.166217250458448d-103*t8+4.4999999999999996d-2
              t10 = t9**5.0d-1
              t11 = 8.213077466115726d-105*t8+7.209876543209877d-2*t7**2
     1           -1.802469135802469d-1*t10*t7+2.4881109353903252d-52*t3+
     2           9.621132278843042d-155/rhob**5+2.755017868687991d-2
              t12 = 8.160240087098705d-52*t3+1.0d+0
              t13 = 1/t12**2.0d+0
              t14 = 1.2437810945273631d+0*t11*t13+1.0d+0
              t15 = 8.04d-1-8.04d-1/t14
              t16 = 1/rhoa**2.6666666666666666d+0
              t17 = 2.040060021774676d-2*gammaaa*t16+1.0d+0
              t18 = 1/t17**2.0d+0
              t19 = gammaaa**3
              t20 = 1/rhoa**8
              t21 = gammaaa**2
              t22 = 1/rhoa**5.333333333333333d+0
              t23 = 1/rhoa
              t24 = 1/taua
              t25 = gammaaa*t23*t24
              t26 = t25**2.0d+0
              t27 = 1.5625d-2*t26+1.0d+0
              t28 = 1/t27**2.0d+0
              t29 = 2.485875d-2*t26*t28+1.234567901234568d-1
              t30 = 2.8125d-3*t26+1.35388578153653d-4*t21*t22
              t31 = t30**5.0d-1
              t32 = 1/rhoa**1.6666666666666669d+0
              t33 = 2.0d+0*taua-2.5d-1*gammaaa*t23
              t34 = 1.0970205230680374d-1*t32*t33-1.0d+0
              t35 = 4.38808209227215d-2*t32*t33*t34+1.0d+0
              t36 = 1/t35**5.0d-1
              t37 = 4.5d-1*t34*t36+1.0970205230680376d-2*gammaaa*t16
              t38 = 7.209876543209877d-2*t37**2-1.802469135802469d-1*t31
     1           *t37+1.6455307846020564d-2*gammaaa*t16*t29+1.7218861679
     2           299946d-3*t26+5.133173416322327d-6*t21*t22+1.5033019185
     3           692253d-6*t19*t20
              t39 = 1.2437810945273631d+0*t18*t38+1.0d+0
              t40 = 8.04d-1-8.04d-1/t39
              t41 = rhoa**3.333333333333333d-1
              t42 = 1/t39**2
              t43 = 1/rhoa**9
              t44 = 1/rhoa**6.333333333333333d+0
              t45 = 1/rhoa**3.6666666666666664d+0
              t46 = 1/rhoa**3
              t47 = 1/taua**2
              t48 = 1/rhoa**2
              t49 = 1/t27**3.0d+0
              t50 = t25**3.0d+0
              t51 = 1.553671875d-3*gammaaa*t24*t48*t49*t50-4.97175d-2*t2
     1           1*t28*t46*t47
              t52 = 2.7425513076700936d-2*gammaaa*t45-1.828367538446729d
     1           -1*t16*t33
              t53 = 4.38808209227215d-2*t32*t33*t52+1.0970205230680374d-
     1           2*gammaaa*t34*t45-7.313470153786916d-2*t16*t33*t34
              t54 = 1/t35**1.5d+0
              t55 = -2.25d-1*t34*t53*t54+4.5d-1*t36*t52-2.92538806151476
     1           7d-2*gammaaa*t45
              t56 = 1/t31
              t57 = -5.625d-3*t21*t46*t47-7.220724168194825d-4*t21*t44
              t58 = -9.012345679012345d-2*t37*t56*t57+1.4419753086419754
     1           d-1*t37*t55-1.802469135802469d-1*t31*t55+1.645530784602
     2           0564d-2*gammaaa*t16*t51-3.443772335859989d-3*t21*t46*t4
     3           7-4.3880820922721503d-2*gammaaa*t29*t45-2.7376924887052
     4           41d-5*t21*t44-1.2026415348553804d-5*t19*t43
              t59 = 1/t17**3.0d+0
              t60 = 1.3532736462850253d-1*gammaaa*t38*t45*t59+1.24378109
     1           45273631d+0*t18*t58
              t61 = rhob**3.333333333333333d-1
              t62 = 1/t14**2
              t63 = 1/rhob**4.333333333333333d+0
              t64 = 1/t10
              t65 = 1/rhob**2.6666666666666666d+0
              t66 = -7.313470153786917d-52*t4*t65-8.023026853549804d-103
     1           *t63
              t67 = 1/t5**1.5d+0
              t68 = -2.25d-1*t4*t66*t67-8.227653923010281d-52*t6*t65-7.3
     1           13470153786917d-52*t65
              t69 = 1.4419753086419754d-1*t68*t7+6.507566225657065d-104*
     1           t63*t64*t7-1.802469135802469d-1*t10*t68-4.1468515589838
     2           76d-52*t65-2.737692488705242d-104*t63-4.810566139421521
     3           d-154/rhob**6
              t70 = 1/t12**3.0d+0
              t71 = 3.3831841157125636d-51*t11*t65*t70+1.243781094527363
     1           1d+0*t13*t69
              t72 = 4.97175d-2*gammaaa*t28*t47*t48-1.553671875d-3*t23*t2
     1           4*t49*t50
              t73 = 1/rhoa**4.333333333333333d+0
              t74 = -1.2034540280324706d-3*t33*t73-1.0970205230680374d-2
     1           *t16*t34
              t75 = -2.25d-1*t34*t54*t74-1.2341480884515421d-2*t16*t36+1
     1           .0970205230680376d-2*t16
              t76 = 5.625d-3*gammaaa*t47*t48+2.70777156307306d-4*gammaaa
     1           *t22
              t77 = -9.012345679012345d-2*t37*t56*t76+1.4419753086419754
     1           d-1*t37*t75-1.802469135802469d-1*t31*t75+1.645530784602
     2           0564d-2*gammaaa*t16*t72+3.443772335859989d-3*gammaaa*t4
     3           7*t48+1.6455307846020564d-2*t16*t29+1.0266346832644656d
     4           -5*gammaaa*t22+4.509905755707676d-6*t20*t21
              t78 = 1.2437810945273631d+0*t18*t77-5.074776173568845d-2*t
     1           16*t38*t59
              t79 = 1/taua**3
              t80 = 1.553671875d-3*gammaaa*t23*t47*t49*t50-4.97175d-2*t2
     1           1*t28*t48*t79
              t81 = 1/rhoa**3.3333333333333337d+0
              t82 = 9.627632224259765d-3*t33*t81+8.7761641845443d-2*t32*
     1           t34
              t83 = 9.873184707612337d-2*t32*t36-2.25d-1*t34*t54*t82
              t84 = 1.4419753086419754d-1*t37*t83-1.802469135802469d-1*t
     1           31*t83+1.6455307846020564d-2*gammaaa*t16*t80+5.06944444
     2           4444443d-4*t21*t37*t48*t56*t79-3.443772335859989d-3*t21
     3           *t48*t79
              t85 = 1/rhoa**10
              t86 = 1/rhoa**7.333333333333333d+0
              t87 = 1/rhoa**4.666666666666667d+0
              t88 = 1/rhoa**4
              t89 = gammaaa**4
              t90 = 1/rhoa**6
              t91 = 1/taua**4
              t92 = 1/t27**4.0d+0
              t93 = t25**4.0d+0
              t94 = 1.4565673828125d-4*t21*t47*t88*t92*t93-3.10734375d-3
     1           *t49*t89*t90*t91-4.6610156249999996d-3*t21*t26*t47*t49*
     2           t88+1.491525d-1*t21*t28*t47*t88-3.10734375d-3*gammaaa*t
     3           24*t46*t49*t50
              t95 = t53**2
              t96 = 1/t35**2.5d+0
              t97 = 4.8756467691912775d-1*t33*t45-1.4626940307573832d-1*
     1           gammaaa*t87
              t98 = 4.38808209227215d-2*t32*t33*t97-5.850776123029533d-2
     1           *gammaaa*t34*t87+2.194041046136075d-2*gammaaa*t45*t52-1
     2           .4626940307573832d-1*t16*t33*t52+1.950258707676511d-1*t
     3           33*t34*t45
              t99 = -2.25d-1*t34*t54*t98+4.5d-1*t36*t97+3.375d-1*t34*t95
     1           *t96+1.0726422892220812d-1*gammaaa*t87-4.5d-1*t52*t53*t
     2           54
              t100 = 1/t30**1.5d+0
              t101 = t57**2
              t102 = 1.6875d-2*t21*t47*t88+4.573125306523389d-3*t21*t86
              t103 = 1.4419753086419754d-1*t37*t99-1.802469135802469d-1*
     1           t31*t99+1.6455307846020564d-2*gammaaa*t16*t94+1.0331317
     2           007579968d-2*t21*t47*t88+1.6089634338331218d-1*gammaaa*
     3           t29*t87+1.7338719095133195d-4*t21*t86+1.082377381369842
     4           3d-4*t19*t85-1.802469135802469d-1*t55*t56*t57-9.0123456
     5           79012345d-2*t102*t37*t56+1.4419753086419754d-1*t55**2-8
     6           .776164184544301d-2*gammaaa*t45*t51+4.5061728395061723d
     7           -2*t100*t101*t37
              t104 = 1/t17**4.0d+0
              t105 = -4.9620033697117594d-1*gammaaa*t38*t59*t87+2.208607
     1           571445859d-2*t104*t21*t38*t86+2.7065472925700507d-1*gam
     2           maaa*t45*t58*t59+1.2437810945273631d+0*t103*t18
              t106 = -1.9950471787324697d+0*t41*t60-7.481426920246762d-1
     1           *t1*t105
              t107 = 1/rhoa**6.666666666666666d-1
              t108 = -4.1356699393293317d-1*t40-4.1356699393293317d-1
              t109 = 1/t39**3
              t110 = t60**2
              t111 = -4.1356699393293317d-1*t15-4.1356699393293317d-1
              t112 = 1/rhob**6.666666666666666d-1
              t113 = 1/t14**3
              t114 = t71**2
              t115 = 1/t9**1.5d+0
              t116 = 1/rhob**8.666666666666666d+0
              t117 = 1/rhob**5.333333333333333d+0
              t118 = 1/rhob**3.6666666666666664d+0
              t119 = t66**2
              t120 = 1/t5**2.5d+0
              t121 = 1.9502587076765113d-51*t118*t4+4.8138161121298817d-
     1           102*t117
              t122 = 8.227653923010281d-52*t65*t66*t67-2.25d-1*t121*t4*t
     1           67+2.194041046136075d-51*t118*t6+3.375d-1*t119*t120*t4+
     2           1.9502587076765113d-51*t118
              t123 = -2.8199453644513944d-103*t117*t64*t7+1.441975308641
     1           9754d-1*t122*t7+2.349467036086518d-206*t115*t116*t7+1.4
     2           419753086419754d-1*t68**2+1.301513245131413d-103*t63*t6
     3           4*t68-1.802469135802469d-1*t10*t122+1.1058270823957002d
     4           -51*t118+1.1863334117722714d-103*t117+2.886339683652913
     5           d-153/rhob**7
              t124 = 1/t12**4.0d+0
              t125 = 6.766368231425127d-51*t65*t69*t70-9.021824308566837
     1           d-51*t11*t118*t70+1.2437810945273631d+0*t123*t13+1.3803
     2           797321536623d-101*t11*t117*t124
              t126 = -1.9950471787324697d+0*t61*t71-7.481426920246762d-1
     1           *t125*t2
              t127 = 1/rhoa**5
              t128 = -1.4565673828125d-4*gammaaa*t46*t47*t92*t93+3.10734
     1           375d-3*t127*t19*t49*t91+1.553671875d-3*t24*t48*t49*t50+
     2           4.6610156249999996d-3*gammaaa*t26*t46*t47*t49-9.9435d-2
     3           *gammaaa*t28*t46*t47
              t129 = -1.0970205230680374d-2*t16*t52+2.9253880615147665d-
     1           2*t34*t45-3.0086350700811765d-4*gammaaa*t44+5.214967454
     2           807371d-3*t22*t33
              t130 = 3.375d-1*t34*t53*t74*t96-2.25d-1*t52*t54*t74+6.1707
     1           40442257711d-3*t16*t53*t54-2.25d-1*t129*t34*t54+3.29106
     2           15692041123d-2*t36*t45-2.925388061514767d-2*t45
              t131 = -1.1249999999999999d-2*gammaaa*t46*t47-1.4441448336
     1           38965d-3*gammaaa*t44
              t132 = 4.5061728395061723d-2*t100*t37*t57*t76-9.0123456790
     1           12345d-2*t55*t56*t76-9.012345679012345d-2*t56*t57*t75+1
     2           .4419753086419754d-1*t55*t75-4.3880820922721503d-2*gamm
     3           aaa*t45*t72-9.012345679012345d-2*t131*t37*t56+1.6455307
     4           846020564d-2*t16*t51-6.887544671719978d-3*gammaaa*t46*t
     5           47-4.3880820922721503d-2*t29*t45-5.475384977410482d-5*g
     6           ammaaa*t44-3.607924604566141d-5*t21*t43+1.4419753086419
     7           754d-1*t130*t37-1.802469135802469d-1*t130*t31+1.6455307
     8           846020564d-2*gammaaa*t128*t16
              t133 = 1.3532736462850253d-1*gammaaa*t45*t59*t77-5.0747761
     1           73568845d-2*t16*t58*t59+1.3532736462850253d-1*t38*t45*t
     2           59-8.282278392921971d-3*gammaaa*t104*t38*t44+1.24378109
     3           45273631d+0*t132*t18
              t134 = -9.975235893662349d-1*t41*t78-7.481426920246762d-1*
     1           t1*t133
              t135 = 1.4565673828125d-4*t47*t48*t92*t93-3.10734375d-3*t2
     1           1*t49*t88*t91-4.6610156249999996d-3*t26*t47*t48*t49+4.9
     2           7175d-2*t28*t47*t48
              t136 = t74**2
              t137 = 3.375d-1*t136*t34*t96+1.2341480884515421d-2*t16*t54
     1           *t74-1.3538857815365296d-4*t22*t34*t54
              t138 = t76**2
              t139 = 5.625d-3*t47*t48+2.70777156307306d-4*t22
              t140 = -1.802469135802469d-1*t56*t75*t76+1.441975308641975
     1           4d-1*t75**2+3.291061569204113d-2*t16*t72-9.012345679012
     2           345d-2*t139*t37*t56+3.443772335859989d-3*t47*t48+4.5061
     3           728395061723d-2*t100*t138*t37+1.4419753086419754d-1*t13
     4           7*t37-1.802469135802469d-1*t137*t31+1.0266346832644656d
     5           -5*t22+9.019811511415352d-6*gammaaa*t20+1.6455307846020
     6           564d-2*gammaaa*t135*t16
              t141 = -1.014955234713769d-1*t16*t59*t77+3.10585439734574d
     1           -3*t104*t22*t38+1.2437810945273631d+0*t140*t18
              t142 = t78**2
              t143 = 1/taua**5
              t144 = 1.4565673828125d-4*t21*t46*t79*t92*t93-3.10734375d-
     1           3*t127*t143*t49*t89-4.6610156249999996d-3*t21*t26*t46*t
     2           49*t79+9.9435d-2*t21*t28*t46*t79-1.553671875d-3*gammaaa
     3           *t47*t48*t49*t50
              t145 = -3.209210741419921d-2*t33*t73+8.7761641845443d-2*t3
     1           2*t52-1.4626940307573832d-1*t16*t34+2.406908056064941d-
     2           3*gammaaa*t22
              t146 = 3.375d-1*t34*t53*t82*t96-2.25d-1*t52*t54*t82-4.9365
     1           923538061685d-2*t32*t53*t54-2.25d-1*t145*t34*t54-1.6455
     2           307846020562d-1*t16*t36
              t147 = -9.012345679012345d-2*t56*t57*t83+1.441975308641975
     1           4d-1*t55*t83-4.3880820922721503d-2*gammaaa*t45*t80-2.53
     2           47222222222215d-4*t100*t21*t37*t48*t57*t79+5.0694444444
     3           44443d-4*t21*t48*t55*t56*t79-1.0138888888888886d-3*t21*
     4           t37*t46*t56*t79+6.887544671719978d-3*t21*t46*t79+1.4419
     5           753086419754d-1*t146*t37-1.802469135802469d-1*t146*t31+
     6           1.6455307846020564d-2*gammaaa*t144*t16
              t148 = 1.3532736462850253d-1*gammaaa*t45*t59*t84+1.2437810
     1           945273631d+0*t147*t18
              t149 = -1.4565673828125d-4*gammaaa*t48*t79*t92*t93+3.10734
     1           375d-3*t143*t19*t49*t88+4.6610156249999996d-3*gammaaa*t
     2           26*t48*t49*t79-9.9435d-2*gammaaa*t28*t48*t79+1.55367187
     3           5d-3*t23*t47*t49*t50
              t150 = 3.375d-1*t34*t74*t82*t96+6.170740442257711d-3*t16*t
     1           54*t82-4.9365923538061685d-2*t32*t54*t74+1.083108625229
     2           2235d-3*t34*t54*t73
              t151 = -9.012345679012345d-2*t56*t76*t83+1.441975308641975
     1           4d-1*t75*t83+1.6455307846020564d-2*t16*t80-2.5347222222
     2           222215d-4*t100*t21*t37*t48*t76*t79+5.069444444444443d-4
     3           *t21*t48*t56*t75*t79+1.0138888888888886d-3*gammaaa*t37*
     4           t48*t56*t79-6.887544671719978d-3*gammaaa*t48*t79+1.4419
     5           753086419754d-1*t150*t37-1.802469135802469d-1*t150*t31+
     6           1.6455307846020564d-2*gammaaa*t149*t16
              t152 = 1.2437810945273631d+0*t151*t18-5.074776173568845d-2
     1           *t16*t59*t84
              t153 = t84**2
              t154 = 1/taua**6
              t155 = 1.4565673828125d-4*t21*t48*t91*t92*t93-4.6610156249
     1           999996d-3*t21*t26*t48*t49*t91+1.491525d-1*t21*t28*t48*t
     2           91-3.10734375d-3*t154*t49*t88*t89-3.10734375d-3*gammaaa
     3           *t23*t49*t50*t79
              t156 = t82**2
              t157 = 3.375d-1*t156*t34*t96-9.873184707612337d-2*t32*t54*
     1           t82-8.664869001833788d-3*t34*t54*t81
              t158 = -1.520833333333333d-3*t21*t37*t48*t56*t91+1.0331317
     1           007579968d-2*t21*t48*t91+1.4257812499999994d-6*t100*t15
     2           4*t37*t88*t89+1.4419753086419754d-1*t83**2+1.0138888888
     3           888886d-3*t21*t48*t56*t79*t83+1.4419753086419754d-1*t15
     4           7*t37-1.802469135802469d-1*t157*t31+1.6455307846020564d
     5           -2*gammaaa*t155*t16
              t159 = 1/rhoa**11
              t160 = 1/rhoa**8.333333333333334d+0
              t161 = 1/rhoa**5.666666666666667d+0
              t162 = gammaaa**6
              t163 = 1/rhoa**7
              t164 = 1/t27**5.0d+0
              t165 = t25**5.0d+0
              t166 = 1/t35**3.5d+0
              t167 = 8.044817169165608d-1*gammaaa*t161-1.787737148703468
     1           2d+0*t33*t87
              t168 = 1.0125000000000002d+0*t34*t53*t96*t98-6.75d-1*t52*t
     1           54*t98-2.25d-1*t34*t54*(3.2910615692041123d-2*gammaaa*t
     2           45*t97-2.194041046136075d-1*t16*t33*t97-1.7552328369088
     3           6d-1*gammaaa*t52*t87-7.150948594813873d-1*t33*t34*t87+5
     4           .850776123029533d-1*t33*t45*t52+3.217926867666243d-1*ga
     5           mmaaa*t161*t34+4.38808209227215d-2*t167*t32*t33)-6.75d-
     6           1*t53*t54*t97+1.0125000000000002d+0*t52*t95*t96-8.4375d
     7           -1*t166*t34*t53**3+4.5d-1*t167*t36-5.005664016369713d-1
     8           *gammaaa*t161
              t169 = 1/t30**2.5d+0
              t170 = 1/t17**5.0d+0
              t171 = 1/t39**4
              t172 = 1/rhob**8
              t173 = 1/rhob**6.333333333333333d+0
              t174 = 1/rhob**4.666666666666667d+0
              t175 = -3.2910615692041123d-51*t118*t66*t67+1.234148088451
     1           5423d-51*t121*t65*t67-2.25d-1*t4*(-7.150948594813874d-5
     2           1*t174*t4-2.9239475644048174d-101*t173)*t67-8.4375d-1*t
     3           4*t66**3/t5**3.5d+0+1.0125000000000002d+0*t120*t121*t4*
     4           t66-1.8512221326773132d-51*t119*t120*t65-8.044817169165
     5           608d-51*t174*t6-7.150948594813874d-51*t174
              t176 = gammaaa**5
              t177 = 3.375d-1*t34*t74*t96*t98+6.170740442257711d-3*t16*t
     1           54*t98-2.25d-1*t34*t54*(-1.0970205230680374d-2*t16*t97-
     2           1.072642289222081d-1*t34*t87+3.209210741419921d-3*gamma
     3           aa*t86+5.850776123029533d-2*t45*t52-2.781315975897265d-
     4           2*t33*t44)-2.25d-1*t54*t74*t97-9.256110663386565d-3*t16
     5           *t95*t96+6.75d-1*t52*t53*t74*t96+6.75d-1*t129*t34*t53*t
     6           96-8.4375d-1*t166*t34*t74*t95-1.2067225753748412d-1*t36
     7           *t87+1.0726422892220812d-1*t87-3.2910615692041123d-2*t4
     8           5*t53*t54-4.5d-1*t129*t52*t54
              t178 = -1.8512221326773132d-2*t16*t53*t74*t96+6.75d-1*t129
     1           *t34*t74*t96+2.030828672304794d-4*t22*t34*t53*t96+3.375
     2           d-1*t136*t52*t96-3.2910615692041123d-2*t45*t54*t74-1.35
     3           38857815365296d-4*t22*t52*t54+7.220724168194822d-4*t34*
     4           t44*t54+1.2341480884515421d-2*t129*t16*t54-8.4375d-1*t1
     5           36*t166*t34*t53
              t179 = 6.092486016914382d-4*t22*t34*t74*t96-2.776833199015
     1           97d-2*t136*t16*t96-8.4375d-1*t166*t34*t74**3+1.11393036
     2           61766865d-5*t20*t54
              t180 = 1/taua**7
              t181 = 3.375d-1*t34*t82*t96*t98-4.9365923538061685d-2*t32*
     1           t54*t98-2.25d-1*t34*t54*(8.7761641845443d-2*t32*t97-2.9
     2           253880615147665d-1*t16*t52+3.900517415353022d-1*t34*t45
     3           -2.0859869819229487d-2*gammaaa*t44+1.3906579879486325d-
     4           1*t22*t33)-2.25d-1*t54*t82*t97+7.404888530709253d-2*t32
     5           *t95*t96+6.75d-1*t52*t53*t82*t96+6.75d-1*t145*t34*t53*t
     6           96-8.4375d-1*t166*t34*t82*t95+1.6455307846020562d-1*t16
     7           *t53*t54-4.5d-1*t145*t52*t54+4.38808209227215d-1*t36*t4
     8           5
              t182 = 3.375d-1*t52*t74*t82*t96-9.256110663386565d-3*t16*t
     1           53*t82*t96+3.375d-1*t129*t34*t82*t96+7.404888530709253d
     2           -2*t32*t53*t74*t96+3.375d-1*t145*t34*t74*t96-1.62466293
     3           78438354d-3*t34*t53*t73*t96-8.4375d-1*t166*t34*t53*t74*
     4           t82-1.6455307846020562d-2*t45*t54*t82+8.227653923010281
     5           d-2*t16*t54*t74+1.0831086252292235d-3*t52*t54*t73-4.693
     6           470709326635d-3*t22*t34*t54-4.9365923538061685d-2*t129*
     7           t32*t54+6.170740442257711d-3*t145*t16*t54
              t183 = -1.8512221326773132d-2*t16*t74*t82*t96+2.0308286723
     1           04794d-4*t22*t34*t82*t96-3.249325875687671d-3*t34*t73*t
     2           74*t96+7.404888530709253d-2*t136*t32*t96-8.4375d-1*t136
     3           *t166*t34*t82-8.911442929413492d-5*t163*t54
              t184 = 1.4809777061418505d-1*t32*t74*t82*t96-3.24932587568
     1           7671d-3*t34*t73*t82*t96+1.2997303502750684d-2*t34*t74*t
     2           81*t96-9.256110663386565d-3*t156*t16*t96+7.129154343530
     3           794d-4*t54*t90-8.4375d-1*t156*t166*t34*t74
              t185 = 1/taua**9
              t186 = 3.899191050825205d-2*t34*t81*t82*t96+2.221466559212
     1           7758d-1*t156*t32*t96-8.4375d-1*t166*t34*t82**3-5.703323
     2           474824635d-3*t127*t54
              fnc(iq) = (-9.305257363490997d-1*t1*t40-9.305257363490997d
     1           -1*t15*t2-9.305257363490997d-1*t2-9.305257363490997d-1*
     2           t1)*wght+fnc(iq)
              Amat(iq,D1_RA) = (-7.481426920246762d-1*t1*t42*t60-1.24070
     1           09817987995d+0*t40*t41-1.2407009817987995d+0*t41)*wght+
     2           Amat(iq,D1_RA)
              Amat(iq,D1_RB) = (-7.481426920246762d-1*t2*t62*t71-1.24070
     1           09817987995d+0*t15*t61-1.2407009817987995d+0*t61)*wght+
     2           Amat(iq,D1_RB)
              Cmat(iq,D1_GAA) = Cmat(iq,D1_GAA)-7.481426920246762d-1*t1*
     1           t42*t78*wght
              Cmat(iq,D1_GAB) = Cmat(iq,D1_GAB)
              Cmat(iq,D1_GBB) = Cmat(iq,D1_GBB)
              Mmat(iq,D1_TA) = Mmat(iq,D1_TA)-9.305257363490997d-1*t1*t1
     1           8*t42*t84*wght
              Mmat(iq,D1_TB) = Mmat(iq,D1_TB)
              Amat2(iq,D2_RA_RA) = (t106*t42+1.4962853840493523d+0*t1*t1
     1           09*t110+t107*t108)*wght+Amat2(iq,D2_RA_RA)
              Amat2(iq,D2_RA_RB) = Amat2(iq,D2_RA_RB)
              Amat2(iq,D2_RB_RB) = (t126*t62+1.4962853840493523d+0*t113*
     1           t114*t2+t111*t112)*wght+Amat2(iq,D2_RB_RB)
              Cmat2(iq,D2_RA_GAA) = (1.4962853840493523d+0*t1*t109*t60*t
     1           78+t134*t42)*wght+Cmat2(iq,D2_RA_GAA)
              Cmat2(iq,D2_RA_GAB) = Cmat2(iq,D2_RA_GAB)
              Cmat2(iq,D2_RA_GBB) = Cmat2(iq,D2_RA_GBB)
              Cmat2(iq,D2_RB_GAA) = Cmat2(iq,D2_RB_GAA)
              Cmat2(iq,D2_RB_GAB) = Cmat2(iq,D2_RB_GAB)
              Cmat2(iq,D2_RB_GBB) = Cmat2(iq,D2_RB_GBB)
              Cmat2(iq,D2_GAA_GAA) = -7.481426920246762d-1*t1*t141*t42*w
     1           ght+1.4962853840493523d+0*t1*t109*t142*wght+Cmat2(iq,D2
     2           _GAA_GAA)
              Cmat2(iq,D2_GAA_GAB) = Cmat2(iq,D2_GAA_GAB)
              Cmat2(iq,D2_GAA_GBB) = Cmat2(iq,D2_GAA_GBB)
              Cmat2(iq,D2_GAB_GAB) = Cmat2(iq,D2_GAB_GAB)
              Cmat2(iq,D2_GAB_GBB) = Cmat2(iq,D2_GAB_GBB)
              Cmat2(iq,D2_GBB_GBB) = Cmat2(iq,D2_GBB_GBB)
              Mmat2(iq,D2_RA_TA) = (1.8610514726981991d+0*t1*t109*t18*t6
     1           0*t84-1.2407009817987995d+0*t18*t41*t42*t84-7.481426920
     2           246762d-1*t1*t148*t42)*wght+Mmat2(iq,D2_RA_TA)
              Mmat2(iq,D2_RA_TB) = Mmat2(iq,D2_RA_TB)
              Mmat2(iq,D2_RB_TA) = Mmat2(iq,D2_RB_TA)
              Mmat2(iq,D2_RB_TB) = Mmat2(iq,D2_RB_TB)
              Mmat2(iq,D2_GAA_TA) = 1.8610514726981991d+0*t1*t109*t18*t7
     1           8*t84*wght-7.481426920246762d-1*t1*t152*t42*wght+Mmat2(
     2           iq,D2_GAA_TA)
              Mmat2(iq,D2_GAA_TB) = Mmat2(iq,D2_GAA_TB)
              Mmat2(iq,D2_GAB_TA) = Mmat2(iq,D2_GAB_TA)
              Mmat2(iq,D2_GAB_TB) = Mmat2(iq,D2_GAB_TB)
              Mmat2(iq,D2_GBB_TA) = Mmat2(iq,D2_GBB_TA)
              Mmat2(iq,D2_GBB_TB) = Mmat2(iq,D2_GBB_TB)
              Mmat2(iq,D2_TA_TA) = -9.305257363490997d-1*t1*t158*t18*t42
     1           *wght+2.3147406376843277d+0*t1*t104*t109*t153*wght+Mmat
     2           2(iq,D2_TA_TA)
              Mmat2(iq,D2_TA_TB) = Mmat2(iq,D2_TA_TB)
              Mmat2(iq,D2_TB_TB) = Mmat2(iq,D2_TB_TB)
              Amat3(iq,D3_RA_RA_RA) = (t42*(-7.481426920246762d-1*t1*(1.
     1           2437810945273631d+0*t18*(-2.703703703703703d-1*t56*t57*
     2           t99+4.3259259259259264d-1*t55*t99-1.3164246276816452d-1
     3           *gammaaa*t45*t94+1.6455307846020564d-2*gammaaa*t16*(-8.
     4           739404296874999d-4*t127*t21*t47*t92*t93-1.0195971679687
     5           499d-3*t19*t50*t79*t90*t92-2.913134765625d-4*t154*t162*
     6           t43*t92+3.7288125d-2*t163*t49*t89*t91+1.820709228515624
     7           8d-5*t164*t165*t19*t79*t90+9.322031249999999d-3*gammaaa
     8           *t24*t49*t50*t88+2.796609375d-2*t127*t21*t26*t47*t49-5.
     9           9661d-1*t127*t21*t28*t47)+4.826890301499366d-1*gammaaa*
     :           t51*t87-6.759259259259258d-2*t169*t37*t57**3+1.35185185
     ;           18518516d-1*t100*t102*t37*t57-2.703703703703703d-1*t102
     <           *t55*t56-9.012345679012345d-2*t37*(-6.75d-2*t127*t21*t4
     =           7-3.3536252247838183d-2*t160*t21)*t56+1.351851851851851
     >           6d-1*t100*t101*t55-4.132526803031987d-2*t127*t21*t47+1.
     ?           4419753086419754d-1*t168*t37-1.802469135802469d-1*t168*
     @           t31-7.50849602455457d-1*gammaaa*t161*t29-1.271506066976
     1           4344d-3*t160*t21-1.0823773813698424d-3*t159*t19)-1.4886
     2           010109135278d+0*gammaaa*t58*t59*t87+6.625822714337577d-
     3           2*t104*t21*t58*t86+4.059820938855076d-1*gammaaa*t103*t4
     4           5*t59+2.3156015725321547d+0*gammaaa*t161*t38*t59-2.4294
     5           683285904448d-1*t104*t160*t21*t38+4.80607147764859d-3*t
     6           159*t170*t19*t38)-6.650157262441565d-1*t107*t60-2.99257
     7           07680987046d+0*t105*t41)-4.488856152148057d+0*t1*t171*t
     8           60**3+t109*(-2*t106*t60+2.9925707680987046d+0*t1*t105*t
     9           60+1.9950471787324697d+0*t110*t41)-3.325078631220783d-1
     :           *t107*t42*t60-6.666666666666666d-1*t108*t32)*wght+Amat3
     ;           (iq,D3_RA_RA_RA)
              Amat3(iq,D3_RA_RA_RB) = Amat3(iq,D3_RA_RA_RB)
              Amat3(iq,D3_RA_RB_RB) = Amat3(iq,D3_RA_RB_RB)
              Amat3(iq,D3_RB_RB_RB) = (t62*(-7.481426920246762d-1*t2*(1.
     1           2437810945273631d+0*t13*(2.544728011477048d-308*t7/(rho
     2           b**13*t9**2.5d+0)+1.5039708610407437d-102*t173*t64*t7+1
     3           .4419753086419754d-1*t175*t7-3.054307146912473d-205*t11
     4           5*t7/rhob**9.666666666666666d+0-8.459836093354184d-103*
     5           t117*t64*t68+4.3259259259259264d-1*t122*t68+7.048401108
     6           259554d-206*t115*t116*t68+1.9522698676971195d-103*t122*
     7           t63*t64-1.802469135802469d-1*t10*t175-4.054699302117567
     8           d-51*t174-6.327111529452114d-103*t173-2.020437778557039
     9           d-152*t172)-2.706547292570051d-50*t118*t69*t70+1.014955
     :           2347137691d-50*t123*t65*t70+3.308002246474507d-50*t11*t
     ;           174*t70+4.1411391964609867d-101*t117*t124*t69-1.1043037
     <           857229297d-100*t11*t124*t173+7.509486683825926d-152*t11
     =           *t172/t12**5.0d+0)-6.650157262441565d-1*t112*t71-2.9925
     >           707680987046d+0*t125*t61)-4.488856152148057d+0*t2*t71**
     ?           3/t14**4+t113*(2.9925707680987046d+0*t125*t2*t71-2*t126
     @           *t71+1.9950471787324697d+0*t114*t61)-3.325078631220783d
     1           -1*t112*t62*t71-6.666666666666666d-1*t111*t3)*wght+Amat
     2           3(iq,D3_RB_RB_RB)
              Cmat3(iq,D3_RA_RA_GAA) = (t42*(-7.481426920246762d-1*t1*(1
     1           .2437810945273631d+0*t18*(-9.012345679012345d-2*t56*t76
     2           *t99+1.4419753086419754d-1*t75*t99+1.6455307846020564d-
     3           2*t16*t94+1.6455307846020564d-2*gammaaa*t16*(5.82626953
     4           125d-4*gammaaa*t47*t88*t92*t93+1.0195971679687499d-3*t1
     5           27*t21*t50*t79*t92+2.913134765625d-4*t154*t176*t20*t92-
     6           3.10734375d-2*t19*t49*t90*t91-1.86440625d-2*gammaaa*t26
     7           *t47*t49*t88+2.98305d-1*gammaaa*t28*t47*t88-1.820709228
     8           5156248d-5*t127*t164*t165*t21*t79-3.10734375d-3*t24*t46
     9           *t49*t50)-9.012345679012345d-2*t37*t56*(3.375d-2*gammaa
     :           a*t47*t88+9.146250613046778d-3*gammaaa*t86)+2.066263401
     ;           5159936d-2*gammaaa*t47*t88+1.6089634338331218d-1*gammaa
     <           a*t72*t87+1.6089634338331218d-1*t29*t87+3.4677438190266
     =           39d-4*gammaaa*t86+3.2471321441095274d-4*t21*t85+9.01234
     >           5679012345d-2*t100*t55*t57*t76-6.759259259259258d-2*t10
     ?           1*t169*t37*t76+4.5061728395061723d-2*t100*t102*t37*t76-
     @           9.012345679012345d-2*t102*t56*t75+4.5061728395061723d-2
     1           *t100*t101*t75-1.802469135802469d-1*t130*t56*t57+9.0123
     2           45679012345d-2*t100*t131*t37*t57-1.802469135802469d-1*t
     3           131*t55*t56+2.883950617283951d-1*t130*t55-8.77616418454
     4           4301d-2*t45*t51-8.776164184544301d-2*gammaaa*t128*t45+1
     5           .4419753086419754d-1*t177*t37-1.802469135802469d-1*t177
     6           *t31)-4.9620033697117594d-1*gammaaa*t59*t77*t87-4.96200
     7           33697117594d-1*t38*t59*t87+2.208607571445859d-2*t104*t2
     8           1*t77*t86+7.454050553629774d-2*gammaaa*t104*t38*t86-1.8
     9           022768041182213d-3*t170*t21*t38*t85+2.7065472925700507d
     :           -1*t45*t58*t59+2.7065472925700507d-1*gammaaa*t132*t45*t
     ;           59-5.074776173568845d-2*t103*t16*t59-1.6564556785843942
     <           d-2*gammaaa*t104*t44*t58)-1.9950471787324697d+0*t133*t4
     =           1)+t109*(2.9925707680987046d+0*t1*t133*t60-2*t106*t78)-
     >           3.325078631220783d-1*t107*t42*t78-4.488856152148057d+0*
     ?           t1*t110*t171*t78)*wght+Cmat3(iq,D3_RA_RA_GAA)
              Cmat3(iq,D3_RA_RA_GAB) = Cmat3(iq,D3_RA_RA_GAB)
              Cmat3(iq,D3_RA_RA_GBB) = Cmat3(iq,D3_RA_RA_GBB)
              Cmat3(iq,D3_RA_RB_GAA) = Cmat3(iq,D3_RA_RB_GAA)
              Cmat3(iq,D3_RA_RB_GAB) = Cmat3(iq,D3_RA_RB_GAB)
              Cmat3(iq,D3_RA_RB_GBB) = Cmat3(iq,D3_RA_RB_GBB)
              Cmat3(iq,D3_RB_RB_GAA) = Cmat3(iq,D3_RB_RB_GAA)
              Cmat3(iq,D3_RB_RB_GAB) = Cmat3(iq,D3_RB_RB_GAB)
              Cmat3(iq,D3_RB_RB_GBB) = Cmat3(iq,D3_RB_RB_GBB)
              Cmat3(iq,D3_RA_GAA_GAA) = (t42*(-7.481426920246762d-1*t1*(
     1           1.2437810945273631d+0*t18*(1.6455307846020564d-2*gammaa
     2           a*t16*(-2.913134765625d-4*t46*t47*t92*t93-2.91313476562
     3           5d-4*t154*t163*t89*t92-1.0195971679687499d-3*gammaaa*t5
     4           0*t79*t88*t92+2.485875d-2*t127*t21*t49*t91+1.8207092285
     5           156248d-5*gammaaa*t164*t165*t79*t88+9.322031249999999d-
     6           3*t26*t46*t47*t49-9.9435d-2*t28*t46*t47)+9.012345679012
     7           345d-2*t100*t57*t75*t76-1.802469135802469d-1*t130*t56*t
     8           76+9.012345679012345d-2*t100*t131*t37*t76-1.80246913580
     9           2469d-1*t131*t56*t75+2.883950617283951d-1*t130*t75-8.77
     :           6164184544301d-2*t45*t72-9.012345679012345d-2*t137*t56*
     ;           t57-6.759259259259258d-2*t138*t169*t37*t57+4.5061728395
     <           061723d-2*t100*t139*t37*t57-9.012345679012345d-2*t139*t
     =           55*t56-9.012345679012345d-2*t37*(-1.1249999999999999d-2
     >           *t46*t47-1.444144833638965d-3*t44)*t56+4.50617283950617
     ?           23d-2*t100*t138*t55+1.4419753086419754d-1*t137*t55-6.88
     @           7544671719978d-3*t46*t47-4.3880820922721503d-2*gammaaa*
     1           t135*t45-5.475384977410482d-5*t44-7.215849209132282d-5*
     2           gammaaa*t43+1.4419753086419754d-1*t178*t37-1.8024691358
     3           02469d-1*t178*t31+3.291061569204113d-2*t128*t16)+2.7065
     4           472925700507d-1*t45*t59*t77-1.6564556785843942d-2*gamma
     5           aa*t104*t44*t77+1.3532736462850253d-1*gammaaa*t140*t45*
     6           t59-1.014955234713769d-1*t132*t16*t59+3.10585439734574d
     7           -3*t104*t22*t58-1.6564556785843942d-2*t104*t38*t44+6.75
     8           8538015443329d-4*gammaaa*t170*t38*t43)-9.97523589366234
     9           9d-1*t141*t41)+t109*(-2*t134*t78+1.4962853840493523d+0*
     :           t1*t133*t78+1.4962853840493523d+0*t1*t141*t60)-4.488856
     ;           152148057d+0*t1*t142*t171*t60)*wght+Cmat3(iq,D3_RA_GAA_
     <           GAA)
              Cmat3(iq,D3_RA_GAA_GAB) = Cmat3(iq,D3_RA_GAA_GAB)
              Cmat3(iq,D3_RA_GAA_GBB) = Cmat3(iq,D3_RA_GAA_GBB)
              Cmat3(iq,D3_RA_GAB_GAB) = Cmat3(iq,D3_RA_GAB_GAB)
              Cmat3(iq,D3_RA_GAB_GBB) = Cmat3(iq,D3_RA_GAB_GBB)
              Cmat3(iq,D3_RA_GBB_GBB) = Cmat3(iq,D3_RA_GBB_GBB)
              Cmat3(iq,D3_RB_GAA_GAA) = Cmat3(iq,D3_RB_GAA_GAA)
              Cmat3(iq,D3_RB_GAA_GAB) = Cmat3(iq,D3_RB_GAA_GAB)
              Cmat3(iq,D3_RB_GAA_GBB) = Cmat3(iq,D3_RB_GAA_GBB)
              Cmat3(iq,D3_RB_GAB_GAB) = Cmat3(iq,D3_RB_GAB_GAB)
              Cmat3(iq,D3_RB_GAB_GBB) = Cmat3(iq,D3_RB_GAB_GBB)
              Cmat3(iq,D3_RB_GBB_GBB) = Cmat3(iq,D3_RB_GBB_GBB)
              Cmat3(iq,D3_GAA_GAA_GAA) = -7.481426920246762d-1*t1*t42*(1
     1           .2437810945273631d+0*t18*(1.6455307846020564d-2*gammaaa
     2           *t16*(2.913134765625d-4*t154*t19*t90*t92+1.019597167968
     3           7499d-3*t46*t50*t79*t92-1.86440625d-2*gammaaa*t49*t88*t
     4           91-1.8207092285156248d-5*t164*t165*t46*t79)-6.759259259
     5           259258d-2*t169*t37*t76**3-2.703703703703703d-1*t137*t56
     6           *t76+1.3518518518518516d-1*t100*t139*t37*t76-2.70370370
     7           3703703d-1*t139*t56*t75+1.3518518518518516d-1*t100*t138
     8           *t75+4.3259259259259264d-1*t137*t75+1.4419753086419754d
     9           -1*t179*t37-1.802469135802469d-1*t179*t31+9.01981151141
     :           5352d-6*t20+4.9365923538061696d-2*t135*t16)+9.317563192
     ;           037218d-3*t104*t22*t77-1.5224328520706534d-1*t140*t16*t
     <           59-2.534451755791249d-4*t170*t20*t38)*wght-4.4888561521
     =           48057d+0*t1*t171*t78**3*wght+4.488856152148057d+0*t1*t1
     >           09*t141*t78*wght+Cmat3(iq,D3_GAA_GAA_GAA)
              Cmat3(iq,D3_GAA_GAA_GAB) = Cmat3(iq,D3_GAA_GAA_GAB)
              Cmat3(iq,D3_GAA_GAA_GBB) = Cmat3(iq,D3_GAA_GAA_GBB)
              Cmat3(iq,D3_GAA_GAB_GAB) = Cmat3(iq,D3_GAA_GAB_GAB)
              Cmat3(iq,D3_GAA_GAB_GBB) = Cmat3(iq,D3_GAA_GAB_GBB)
              Cmat3(iq,D3_GAA_GBB_GBB) = Cmat3(iq,D3_GAA_GBB_GBB)
              Cmat3(iq,D3_GAB_GAB_GAB) = Cmat3(iq,D3_GAB_GAB_GAB)
              Cmat3(iq,D3_GAB_GAB_GBB) = Cmat3(iq,D3_GAB_GAB_GBB)
              Cmat3(iq,D3_GAB_GBB_GBB) = Cmat3(iq,D3_GAB_GBB_GBB)
              Cmat3(iq,D3_GBB_GBB_GBB) = Cmat3(iq,D3_GBB_GBB_GBB)
              Mmat3(iq,D3_RA_RA_TA) = (t42*(-7.481426920246762d-1*t1*(1.
     1           2437810945273631d+0*t18*(1.4419753086419754d-1*t83*t99+
     2           5.069444444444443d-4*t21*t48*t56*t79*t99+1.645530784602
     3           0564d-2*gammaaa*t16*(-5.82626953125d-4*t21*t79*t88*t92*
     4           t93-1.0195971679687499d-3*t127*t19*t50*t91*t92-2.913134
     5           765625d-4*t162*t180*t20*t92+1.8207092285156248d-5*t127*
     6           t164*t165*t19*t91+3.10734375d-2*t143*t49*t89*t90+1.8644
     7           0625d-2*t21*t26*t49*t79*t88-2.98305d-1*t21*t28*t79*t88+
     8           3.10734375d-3*gammaaa*t46*t47*t49*t50)+3.04166666666666
     9           64d-3*t21*t37*t56*t79*t88-2.0662634015159936d-2*t21*t79
     :           *t88+1.6089634338331218d-1*gammaaa*t80*t87-9.0123456790
     ;           12345d-2*t102*t56*t83+4.5061728395061723d-2*t100*t101*t
     <           83-5.069444444444443d-4*t100*t21*t48*t55*t57*t79+1.0138
     =           888888888886d-3*t100*t21*t37*t46*t57*t79-2.027777777777
     >           7772d-3*t21*t46*t55*t56*t79+3.802083333333333d-4*t101*t
     ?           169*t21*t37*t48*t79-2.5347222222222215d-4*t100*t102*t21
     @           *t37*t48*t79-1.802469135802469d-1*t146*t56*t57+2.883950
     1           617283951d-1*t146*t55-8.776164184544301d-2*gammaaa*t144
     2           *t45+1.4419753086419754d-1*t181*t37-1.802469135802469d-
     3           1*t181*t31)-4.9620033697117594d-1*gammaaa*t59*t84*t87+2
     4           .208607571445859d-2*t104*t21*t84*t86+2.7065472925700507
     5           d-1*gammaaa*t147*t45*t59)-1.9950471787324697d+0*t148*t4
     6           1)-4.1356699393293317d-1*t107*t18*t42*t84-5.58315441809
     7           4598d+0*t1*t110*t171*t18*t84-2.4875621890547261d+0*t106
     8           *t109*t18*t84+2.9925707680987046d+0*t1*t109*t148*t60)*w
     9           ght+Mmat3(iq,D3_RA_RA_TA)
              Mmat3(iq,D3_RA_RA_TB) = Mmat3(iq,D3_RA_RA_TB)
              Mmat3(iq,D3_RA_RB_TA) = Mmat3(iq,D3_RA_RB_TA)
              Mmat3(iq,D3_RA_RB_TB) = Mmat3(iq,D3_RA_RB_TB)
              Mmat3(iq,D3_RB_RB_TA) = Mmat3(iq,D3_RB_RB_TA)
              Mmat3(iq,D3_RB_RB_TB) = Mmat3(iq,D3_RB_RB_TB)
              Mmat3(iq,D3_RA_GAA_TA) = (t42*(-7.481426920246762d-1*t1*(1
     1           .2437810945273631d+0*t18*(1.6455307846020564d-2*gammaaa
     2           *t16*(4.369702148437499d-4*gammaaa*t46*t79*t92*t93+1.01
     3           95971679687499d-3*t21*t50*t88*t91*t92+2.913134765625d-4
     4           *t163*t176*t180*t92-1.8207092285156248d-5*t164*t165*t21
     5           *t88*t91-1.3983046875d-2*gammaaa*t26*t46*t49*t79+1.9887
     6           d-1*gammaaa*t28*t46*t79-1.553671875d-3*t47*t48*t49*t50-
     7           2.796609375d-2*t127*t143*t19*t49)+4.5061728395061723d-2
     8           *t100*t57*t76*t83-9.012345679012345d-2*t131*t56*t83+1.4
     9           419753086419754d-1*t130*t83-4.3880820922721503d-2*t45*t
     :           80+3.802083333333333d-4*t169*t21*t37*t48*t57*t76*t79-2.
     ;           5347222222222215d-4*t100*t21*t48*t55*t76*t79+5.06944444
     <           4444443d-4*t100*t21*t37*t46*t76*t79-2.5347222222222215d
     =           -4*t100*t21*t48*t57*t75*t79-1.0138888888888886d-3*t21*t
     >           46*t56*t75*t79-5.069444444444443d-4*gammaaa*t100*t37*t4
     ?           8*t57*t79+1.0138888888888886d-3*gammaaa*t48*t55*t56*t79
     @           +5.069444444444443d-4*t130*t21*t48*t56*t79-2.0277777777
     1           777772d-3*gammaaa*t37*t46*t56*t79-2.5347222222222215d-4
     2           *t100*t131*t21*t37*t48*t79+1.3775089343439956d-2*gammaa
     3           a*t46*t79-9.012345679012345d-2*t146*t56*t76+1.441975308
     4           6419754d-1*t146*t75-9.012345679012345d-2*t150*t56*t57+1
     5           .4419753086419754d-1*t150*t55-4.3880820922721503d-2*gam
     6           maaa*t149*t45+1.4419753086419754d-1*t182*t37-1.80246913
     7           5802469d-1*t182*t31+1.6455307846020564d-2*t144*t16)+1.3
     8           532736462850253d-1*t45*t59*t84-8.282278392921971d-3*gam
     9           maaa*t104*t44*t84+1.3532736462850253d-1*gammaaa*t151*t4
     :           5*t59-5.074776173568845d-2*t147*t16*t59)-9.975235893662
     ;           349d-1*t152*t41)-5.583154418094598d+0*t1*t171*t18*t60*t
     <           78*t84-2.4875621890547261d+0*t109*t134*t18*t84+t109*(1.
     =           4962853840493523d+0*t1*t148*t78+1.4962853840493523d+0*t
     >           1*t152*t60))*wght+Mmat3(iq,D3_RA_GAA_TA)
              Mmat3(iq,D3_RA_GAA_TB) = Mmat3(iq,D3_RA_GAA_TB)
              Mmat3(iq,D3_RA_GAB_TA) = Mmat3(iq,D3_RA_GAB_TA)
              Mmat3(iq,D3_RA_GAB_TB) = Mmat3(iq,D3_RA_GAB_TB)
              Mmat3(iq,D3_RA_GBB_TA) = Mmat3(iq,D3_RA_GBB_TA)
              Mmat3(iq,D3_RA_GBB_TB) = Mmat3(iq,D3_RA_GBB_TB)
              Mmat3(iq,D3_RB_GAA_TA) = Mmat3(iq,D3_RB_GAA_TA)
              Mmat3(iq,D3_RB_GAA_TB) = Mmat3(iq,D3_RB_GAA_TB)
              Mmat3(iq,D3_RB_GAB_TA) = Mmat3(iq,D3_RB_GAB_TA)
              Mmat3(iq,D3_RB_GAB_TB) = Mmat3(iq,D3_RB_GAB_TB)
              Mmat3(iq,D3_RB_GBB_TA) = Mmat3(iq,D3_RB_GBB_TA)
              Mmat3(iq,D3_RB_GBB_TB) = Mmat3(iq,D3_RB_GBB_TB)
              Mmat3(iq,D3_RA_TA_TA) = -7.481426920246762d-1*t1*t42*(1.24
     1           37810945273631d+0*t18*(1.6455307846020564d-2*gammaaa*t1
     2           6*(-2.913134765625d-4*t48*t79*t92*t93-1.019597167968749
     3           9d-3*gammaaa*t46*t50*t91*t92-2.913134765625d-4*t180*t89
     4           *t90*t92+1.8207092285156248d-5*gammaaa*t164*t165*t46*t9
     5           1+2.485875d-2*t143*t21*t49*t88+9.322031249999999d-3*t26
     6           *t48*t49*t79-9.9435d-2*t28*t48*t79)-9.012345679012345d-
     7           2*t139*t56*t83+4.5061728395061723d-2*t100*t138*t83+1.44
     8           19753086419754d-1*t137*t83-5.069444444444443d-4*t100*t2
     9           1*t48*t75*t76*t79-1.0138888888888886d-3*gammaaa*t100*t3
     :           7*t48*t76*t79+2.0277777777777772d-3*gammaaa*t48*t56*t75
     ;           *t79+1.0138888888888886d-3*t37*t48*t56*t79+5.0694444444
     <           44443d-4*t137*t21*t48*t56*t79+3.802083333333333d-4*t138
     =           *t169*t21*t37*t48*t79-2.5347222222222215d-4*t100*t139*t
     >           21*t37*t48*t79-6.887544671719978d-3*t48*t79-1.802469135
     ?           802469d-1*t150*t56*t76+2.883950617283951d-1*t150*t75+1.
     @           4419753086419754d-1*t183*t37-1.802469135802469d-1*t183*
     1           t31+3.291061569204113d-2*t149*t16)+3.10585439734574d-3*
     2           t104*t22*t84-1.014955234713769d-1*t151*t16*t59)*wght-5.
     3           583154418094598d+0*t1*t142*t171*t18*t84*wght+1.86105147
     4           26981991d+0*t1*t109*t141*t18*t84*wght+2.992570768098704
     5           6d+0*t1*t109*t152*t78*wght+Mmat3(iq,D3_RA_TA_TA)
              Mmat3(iq,D3_RA_TA_TB) = Mmat3(iq,D3_RA_TA_TB)
              Mmat3(iq,D3_RA_TB_TB) = Mmat3(iq,D3_RA_TB_TB)
              Mmat3(iq,D3_RB_TA_TA) = Mmat3(iq,D3_RB_TA_TA)
              Mmat3(iq,D3_RB_TA_TB) = Mmat3(iq,D3_RB_TA_TB)
              Mmat3(iq,D3_RB_TB_TB) = Mmat3(iq,D3_RB_TB_TB)
              Mmat3(iq,D3_GAA_GAA_TA) = Mmat3(iq,D3_GAA_GAA_TA)
              Mmat3(iq,D3_GAA_GAA_TB) = Mmat3(iq,D3_GAA_GAA_TB)
              Mmat3(iq,D3_GAA_GAB_TA) = Mmat3(iq,D3_GAA_GAB_TA)
              Mmat3(iq,D3_GAA_GAB_TB) = Mmat3(iq,D3_GAA_GAB_TB)
              Mmat3(iq,D3_GAA_GBB_TA) = Mmat3(iq,D3_GAA_GBB_TA)
              Mmat3(iq,D3_GAA_GBB_TB) = Mmat3(iq,D3_GAA_GBB_TB)
              Mmat3(iq,D3_GAB_GAB_TA) = t109*t18*(3.7221029453963983d+0*
     1           t1*t152*t84*wght+1.8610514726981991d+0*t1*t158*t78*wght
     2           )-7.481426920246762d-1*t1*t42*(1.2437810945273631d+0*t1
     3           8*(1.6455307846020564d-2*gammaaa*t16*(2.913134765625d-4
     4           *t176*t90*t92/taua**8+5.82626953125d-4*gammaaa*t48*t91*
     5           t92*t93+1.0195971679687499d-3*t143*t21*t46*t50*t92-1.86
     6           440625d-2*gammaaa*t26*t48*t49*t91+2.98305d-1*gammaaa*t2
     7           8*t48*t91-3.10734375d-2*t154*t19*t49*t88-3.10734375d-3*
     8           t23*t49*t50*t79-1.8207092285156248d-5*t143*t164*t165*t2
     9           1*t46)+7.604166666666664d-4*t100*t21*t37*t48*t76*t91-1.
     :           520833333333333d-3*t21*t48*t56*t75*t91-3.04166666666666
     ;           6d-3*gammaaa*t37*t48*t56*t91+2.0662634015159936d-2*gamm
     <           aaa*t48*t91-2.1386718749999997d-6*t154*t169*t37*t76*t88
     =           *t89+1.4257812499999994d-6*t100*t154*t75*t88*t89+5.7031
     >           24999999998d-6*t100*t154*t19*t37*t88-5.069444444444443d
     ?           -4*t100*t21*t48*t76*t79*t83+2.0277777777777772d-3*gamma
     @           aa*t48*t56*t79*t83+2.883950617283951d-1*t150*t83+1.0138
     1           888888888886d-3*t150*t21*t48*t56*t79-9.012345679012345d
     2           -2*t157*t56*t76+1.4419753086419754d-1*t157*t75+1.441975
     3           3086419754d-1*t184*t37-1.802469135802469d-1*t184*t31+1.
     4           6455307846020564d-2*t155*t16)-5.074776173568845d-2*t158
     5           *t16*t59)*wght-6.944221913052981d+0*t1*t104*t153*t171*t
     6           78*wght+Mmat3(iq,D3_GAB_GAB_TA)
              Mmat3(iq,D3_GAB_GAB_TB) = Mmat3(iq,D3_GAB_GAB_TB)
              Mmat3(iq,D3_GAB_GBB_TA) = Mmat3(iq,D3_GAB_GBB_TA)
              Mmat3(iq,D3_GAB_GBB_TB) = Mmat3(iq,D3_GAB_GBB_TB)
              Mmat3(iq,D3_GBB_GBB_TA) = Mmat3(iq,D3_GBB_GBB_TA)
              Mmat3(iq,D3_GBB_GBB_TB) = Mmat3(iq,D3_GBB_GBB_TB)
              Mmat3(iq,D3_GAA_TA_TA) = Mmat3(iq,D3_GAA_TA_TA)
              Mmat3(iq,D3_GAA_TA_TB) = Mmat3(iq,D3_GAA_TA_TB)
              Mmat3(iq,D3_GAA_TB_TB) = Mmat3(iq,D3_GAA_TB_TB)
              Mmat3(iq,D3_GAB_TA_TA) = -9.305257363490997d-1*t1*t18*t42*
     1           (1.6455307846020564d-2*gammaaa*t16*(-8.739404296874999d
     2           -4*t143*t21*t48*t92*t93-2.913134765625d-4*t162*t185*t90
     3           *t92-1.0195971679687499d-3*t154*t19*t46*t50*t92+9.32203
     4           1249999999d-3*gammaaa*t23*t49*t50*t91+3.7288125d-2*t180
     5           *t49*t88*t89+2.796609375d-2*t143*t21*t26*t48*t49-5.9661
     6           d-1*t143*t21*t28*t48+1.8207092285156248d-5*t154*t164*t1
     7           65*t19*t46)-4.562499999999999d-3*t21*t48*t56*t83*t91+1.
     8           2030029296874996d-8*t162*t169*t185*t37*t90+4.2773437499
     9           999983d-6*t100*t154*t83*t88*t89-1.2832031249999995d-5*t
     :           100*t180*t37*t88*t89+4.3259259259259264d-1*t157*t83+1.5
     ;           20833333333333d-3*t157*t21*t48*t56*t79+6.08333333333333
     <           2d-3*t143*t21*t37*t48*t56-4.132526803031987d-2*t143*t21
     =           *t48+1.4419753086419754d-1*t186*t37-1.802469135802469d-
     >           1*t186*t31)*wght-8.637091931657939d+0*t1*t171*t84**3*wg
     ?           ht/t17**6.0d+0+6.944221913052984d+0*t1*t104*t109*t158*t
     @           84*wght+Mmat3(iq,D3_GAB_TA_TA)
              Mmat3(iq,D3_GAB_TA_TB) = Mmat3(iq,D3_GAB_TA_TB)
              Mmat3(iq,D3_GAB_TB_TB) = Mmat3(iq,D3_GAB_TB_TB)
              Mmat3(iq,D3_GBB_TA_TA) = Mmat3(iq,D3_GBB_TA_TA)
            elseif (taua.le.tol_rho.and.taub.gt.tol_rho) then 
              t1 = rhoa**1.3333333333333333d+0
              t2 = 1/rhoa**1.6666666666666669d+0
              t3 = 1.0970205230680374d-51*t2-1.0d+0
              t4 = 4.3880820922721503d-52*t2*t3+1.0d+0
              t5 = 1/t4**5.0d-1
              t6 = 4.5d-1*t3*t5+4.3880820922721503d-52*t2
              t7 = 1/rhoa**3.3333333333333337d+0
              t8 = 2.166217250458448d-103*t7+4.4999999999999996d-2
              t9 = t8**5.0d-1
              t10 = -1.802469135802469d-1*t6*t9+8.213077466115726d-105*t
     1           7+7.209876543209877d-2*t6**2+2.4881109353903252d-52*t2+
     2           9.621132278843042d-155/rhoa**5+2.755017868687991d-2
              t11 = 8.160240087098705d-52*t2+1.0d+0
              t12 = 1/t11**2.0d+0
              t13 = 1.2437810945273631d+0*t10*t12+1.0d+0
              t14 = 8.04d-1-8.04d-1/t13
              t15 = rhob**1.3333333333333333d+0
              t16 = 1/rhob**2.6666666666666666d+0
              t17 = 2.040060021774676d-2*gammabb*t16+1.0d+0
              t18 = 1/t17**2.0d+0
              t19 = gammabb**3
              t20 = 1/rhob**8
              t21 = gammabb**2
              t22 = 1/rhob**5.333333333333333d+0
              t23 = 1/rhob
              t24 = 1/taub
              t25 = gammabb*t23*t24
              t26 = t25**2.0d+0
              t27 = 1.5625d-2*t26+1.0d+0
              t28 = 1/t27**2.0d+0
              t29 = 2.485875d-2*t26*t28+1.234567901234568d-1
              t30 = 2.8125d-3*t26+1.35388578153653d-4*t21*t22
              t31 = t30**5.0d-1
              t32 = 1/rhob**1.6666666666666669d+0
              t33 = 2.0d+0*taub-2.5d-1*gammabb*t23
              t34 = 1.0970205230680374d-1*t32*t33-1.0d+0
              t35 = 4.38808209227215d-2*t32*t33*t34+1.0d+0
              t36 = 1/t35**5.0d-1
              t37 = 4.5d-1*t34*t36+1.0970205230680376d-2*gammabb*t16
              t38 = 7.209876543209877d-2*t37**2-1.802469135802469d-1*t31
     1           *t37+1.6455307846020564d-2*gammabb*t16*t29+1.7218861679
     2           299946d-3*t26+5.133173416322327d-6*t21*t22+1.5033019185
     3           692253d-6*t19*t20
              t39 = 1.2437810945273631d+0*t18*t38+1.0d+0
              t40 = 8.04d-1-8.04d-1/t39
              t41 = rhoa**3.333333333333333d-1
              t42 = 1/t13**2
              t43 = 1/rhoa**4.333333333333333d+0
              t44 = 1/t9
              t45 = 1/rhoa**2.6666666666666666d+0
              t46 = -7.313470153786917d-52*t3*t45-8.023026853549804d-103
     1           *t43
              t47 = 1/t4**1.5d+0
              t48 = -8.227653923010281d-52*t45*t5-2.25d-1*t3*t46*t47-7.3
     1           13470153786917d-52*t45
              t49 = -1.802469135802469d-1*t48*t9+1.4419753086419754d-1*t
     1           48*t6+6.507566225657065d-104*t43*t44*t6-4.1468515589838
     2           76d-52*t45-2.737692488705242d-104*t43-4.810566139421521
     3           d-154/rhoa**6
              t50 = 1/t11**3.0d+0
              t51 = 3.3831841157125636d-51*t10*t45*t50+1.243781094527363
     1           1d+0*t12*t49
              t52 = rhob**3.333333333333333d-1
              t53 = 1/t39**2
              t54 = 1/rhob**9
              t55 = 1/rhob**6.333333333333333d+0
              t56 = 1/rhob**3.6666666666666664d+0
              t57 = 1/rhob**3
              t58 = 1/taub**2
              t59 = 1/rhob**2
              t60 = 1/t27**3.0d+0
              t61 = t25**3.0d+0
              t62 = 1.553671875d-3*gammabb*t24*t59*t60*t61-4.97175d-2*t2
     1           1*t28*t57*t58
              t63 = 2.7425513076700936d-2*gammabb*t56-1.828367538446729d
     1           -1*t16*t33
              t64 = 4.38808209227215d-2*t32*t33*t63+1.0970205230680374d-
     1           2*gammabb*t34*t56-7.313470153786916d-2*t16*t33*t34
              t65 = 1/t35**1.5d+0
              t66 = -2.25d-1*t34*t64*t65+4.5d-1*t36*t63-2.92538806151476
     1           7d-2*gammabb*t56
              t67 = 1/t31
              t68 = -5.625d-3*t21*t57*t58-7.220724168194825d-4*t21*t55
              t69 = -9.012345679012345d-2*t37*t67*t68+1.4419753086419754
     1           d-1*t37*t66-1.802469135802469d-1*t31*t66+1.645530784602
     2           0564d-2*gammabb*t16*t62-3.443772335859989d-3*t21*t57*t5
     3           8-4.3880820922721503d-2*gammabb*t29*t56-2.7376924887052
     4           41d-5*t21*t55-1.2026415348553804d-5*t19*t54
              t70 = 1/t17**3.0d+0
              t71 = 1.3532736462850253d-1*gammabb*t38*t56*t70+1.24378109
     1           45273631d+0*t18*t69
              t72 = 4.97175d-2*gammabb*t28*t58*t59-1.553671875d-3*t23*t2
     1           4*t60*t61
              t73 = 1/rhob**4.333333333333333d+0
              t74 = -1.2034540280324706d-3*t33*t73-1.0970205230680374d-2
     1           *t16*t34
              t75 = -2.25d-1*t34*t65*t74-1.2341480884515421d-2*t16*t36+1
     1           .0970205230680376d-2*t16
              t76 = 5.625d-3*gammabb*t58*t59+2.70777156307306d-4*gammabb
     1           *t22
              t77 = -9.012345679012345d-2*t37*t67*t76+1.4419753086419754
     1           d-1*t37*t75-1.802469135802469d-1*t31*t75+1.645530784602
     2           0564d-2*gammabb*t16*t72+3.443772335859989d-3*gammabb*t5
     3           8*t59+1.6455307846020564d-2*t16*t29+1.0266346832644656d
     4           -5*gammabb*t22+4.509905755707676d-6*t20*t21
              t78 = 1.2437810945273631d+0*t18*t77-5.074776173568845d-2*t
     1           16*t38*t70
              t79 = 1/taub**3
              t80 = 1.553671875d-3*gammabb*t23*t58*t60*t61-4.97175d-2*t2
     1           1*t28*t59*t79
              t81 = 1/rhob**3.3333333333333337d+0
              t82 = 9.627632224259765d-3*t33*t81+8.7761641845443d-2*t32*
     1           t34
              t83 = 9.873184707612337d-2*t32*t36-2.25d-1*t34*t65*t82
              t84 = 1.4419753086419754d-1*t37*t83-1.802469135802469d-1*t
     1           31*t83+1.6455307846020564d-2*gammabb*t16*t80+5.06944444
     2           4444443d-4*t21*t37*t59*t67*t79-3.443772335859989d-3*t21
     3           *t59*t79
              t85 = -4.1356699393293317d-1*t14-4.1356699393293317d-1
              t86 = 1/rhoa**6.666666666666666d-1
              t87 = 1/t13**3
              t88 = t51**2
              t89 = 1/t8**1.5d+0
              t90 = 1/rhoa**8.666666666666666d+0
              t91 = 1/rhoa**5.333333333333333d+0
              t92 = 1/rhoa**3.6666666666666664d+0
              t93 = t46**2
              t94 = 1/t4**2.5d+0
              t95 = 1.9502587076765113d-51*t3*t92+4.8138161121298817d-10
     1           2*t91
              t96 = -2.25d-1*t3*t47*t95+3.375d-1*t3*t93*t94+2.1940410461
     1           36075d-51*t5*t92+1.9502587076765113d-51*t92+8.227653923
     2           010281d-52*t45*t46*t47
              t97 = -1.802469135802469d-1*t9*t96+1.4419753086419754d-1*t
     1           6*t96+1.1058270823957002d-51*t92-2.8199453644513944d-10
     2           3*t44*t6*t91+1.1863334117722714d-103*t91+2.349467036086
     3           518d-206*t6*t89*t90+1.4419753086419754d-1*t48**2+1.3015
     4           13245131413d-103*t43*t44*t48+2.886339683652913d-153/rho
     5           a**7
              t98 = 1/t11**4.0d+0
              t99 = 1.3803797321536623d-101*t10*t91*t98+1.24378109452736
     1           31d+0*t12*t97-9.021824308566837d-51*t10*t50*t92+6.76636
     2           8231425127d-51*t45*t49*t50
              t100 = -7.481426920246762d-1*t1*t99-1.9950471787324697d+0*
     1           t41*t51
              t101 = 1/rhob**10
              t102 = 1/rhob**7.333333333333333d+0
              t103 = 1/rhob**4.666666666666667d+0
              t104 = 1/rhob**4
              t105 = gammabb**4
              t106 = 1/rhob**6
              t107 = 1/taub**4
              t108 = 1/t27**4.0d+0
              t109 = t25**4.0d+0
              t110 = -3.10734375d-3*gammabb*t24*t57*t60*t61-4.6610156249
     1           999996d-3*t104*t21*t26*t58*t60-3.10734375d-3*t105*t106*
     2           t107*t60+1.491525d-1*t104*t21*t28*t58+1.4565673828125d-
     3           4*t104*t108*t109*t21*t58
              t111 = t64**2
              t112 = 1/t35**2.5d+0
              t113 = 4.8756467691912775d-1*t33*t56-1.4626940307573832d-1
     1           *gammabb*t103
              t114 = 2.194041046136075d-2*gammabb*t56*t63-1.462694030757
     1           3832d-1*t16*t33*t63+1.950258707676511d-1*t33*t34*t56-5.
     2           850776123029533d-2*gammabb*t103*t34+4.38808209227215d-2
     3           *t113*t32*t33
              t115 = -4.5d-1*t63*t64*t65-2.25d-1*t114*t34*t65+4.5d-1*t11
     1           3*t36+3.375d-1*t111*t112*t34+1.0726422892220812d-1*gamm
     2           abb*t103
              t116 = 1/t30**1.5d+0
              t117 = t68**2
              t118 = 1.6875d-2*t104*t21*t58+4.573125306523389d-3*t102*t2
     1           1
              t119 = -1.802469135802469d-1*t66*t67*t68-9.012345679012345
     1           d-2*t118*t37*t67+1.4419753086419754d-1*t66**2-8.7761641
     2           84544301d-2*gammabb*t56*t62+1.0331317007579968d-2*t104*
     3           t21*t58+4.5061728395061723d-2*t116*t117*t37+1.441975308
     4           6419754d-1*t115*t37-1.802469135802469d-1*t115*t31+1.608
     5           9634338331218d-1*gammabb*t103*t29+1.7338719095133195d-4
     6           *t102*t21+1.0823773813698423d-4*t101*t19+1.645530784602
     7           0564d-2*gammabb*t110*t16
              t120 = 1/t17**4.0d+0
              t121 = 2.7065472925700507d-1*gammabb*t56*t69*t70-4.9620033
     1           697117594d-1*gammabb*t103*t38*t70+2.208607571445859d-2*
     2           t102*t120*t21*t38+1.2437810945273631d+0*t119*t18
              t122 = -1.9950471787324697d+0*t52*t71-7.481426920246762d-1
     1           *t121*t15
              t123 = 1/rhob**6.666666666666666d-1
              t124 = -4.1356699393293317d-1*t40-4.1356699393293317d-1
              t125 = 1/t39**3
              t126 = t71**2
              t127 = 1/rhob**5
              t128 = 1.553671875d-3*t24*t59*t60*t61+4.6610156249999996d-
     1           3*gammabb*t26*t57*t58*t60+3.10734375d-3*t107*t127*t19*t
     2           60-9.9435d-2*gammabb*t28*t57*t58-1.4565673828125d-4*gam
     3           mabb*t108*t109*t57*t58
              t129 = -1.0970205230680374d-2*t16*t63+2.9253880615147665d-
     1           2*t34*t56-3.0086350700811765d-4*gammabb*t55+5.214967454
     2           807371d-3*t22*t33
              t130 = -2.25d-1*t63*t65*t74+3.375d-1*t112*t34*t64*t74+6.17
     1           0740442257711d-3*t16*t64*t65-2.25d-1*t129*t34*t65+3.291
     2           0615692041123d-2*t36*t56-2.925388061514767d-2*t56
              t131 = -1.1249999999999999d-2*gammabb*t57*t58-1.4441448336
     1           38965d-3*gammabb*t55
              t132 = 4.5061728395061723d-2*t116*t37*t68*t76-9.0123456790
     1           12345d-2*t66*t67*t76-9.012345679012345d-2*t67*t68*t75+1
     2           .4419753086419754d-1*t66*t75-4.3880820922721503d-2*gamm
     3           abb*t56*t72-9.012345679012345d-2*t131*t37*t67+1.6455307
     4           846020564d-2*t16*t62-6.887544671719978d-3*gammabb*t57*t
     5           58-4.3880820922721503d-2*t29*t56-5.475384977410482d-5*g
     6           ammabb*t55-3.607924604566141d-5*t21*t54+1.4419753086419
     7           754d-1*t130*t37-1.802469135802469d-1*t130*t31+1.6455307
     8           846020564d-2*gammabb*t128*t16
              t133 = 1.3532736462850253d-1*gammabb*t56*t70*t77-5.0747761
     1           73568845d-2*t16*t69*t70+1.3532736462850253d-1*t38*t56*t
     2           70-8.282278392921971d-3*gammabb*t120*t38*t55+1.24378109
     3           45273631d+0*t132*t18
              t134 = -9.975235893662349d-1*t52*t78-7.481426920246762d-1*
     1           t133*t15
              t135 = -4.6610156249999996d-3*t26*t58*t59*t60-3.10734375d-
     1           3*t104*t107*t21*t60+4.97175d-2*t28*t58*t59+1.4565673828
     2           125d-4*t108*t109*t58*t59
              t136 = t74**2
              t137 = 1.2341480884515421d-2*t16*t65*t74-1.353885781536529
     1           6d-4*t22*t34*t65+3.375d-1*t112*t136*t34
              t138 = t76**2
              t139 = 5.625d-3*t58*t59+2.70777156307306d-4*t22
              t140 = -1.802469135802469d-1*t67*t75*t76+1.441975308641975
     1           4d-1*t75**2+3.291061569204113d-2*t16*t72-9.012345679012
     2           345d-2*t139*t37*t67+3.443772335859989d-3*t58*t59+4.5061
     3           728395061723d-2*t116*t138*t37+1.4419753086419754d-1*t13
     4           7*t37-1.802469135802469d-1*t137*t31+1.0266346832644656d
     5           -5*t22+9.019811511415352d-6*gammabb*t20+1.6455307846020
     6           564d-2*gammabb*t135*t16
              t141 = -1.014955234713769d-1*t16*t70*t77+3.10585439734574d
     1           -3*t120*t22*t38+1.2437810945273631d+0*t140*t18
              t142 = t78**2
              t143 = 1/taub**5
              t144 = -4.6610156249999996d-3*t21*t26*t57*t60*t79+9.9435d-
     1           2*t21*t28*t57*t79+1.4565673828125d-4*t108*t109*t21*t57*
     2           t79-1.553671875d-3*gammabb*t58*t59*t60*t61-3.10734375d-
     3           3*t105*t127*t143*t60
              t145 = -3.209210741419921d-2*t33*t73+8.7761641845443d-2*t3
     1           2*t63-1.4626940307573832d-1*t16*t34+2.406908056064941d-
     2           3*gammabb*t22
              t146 = -2.25d-1*t63*t65*t82+3.375d-1*t112*t34*t64*t82-4.93
     1           65923538061685d-2*t32*t64*t65-2.25d-1*t145*t34*t65-1.64
     2           55307846020562d-1*t16*t36
              t147 = -9.012345679012345d-2*t67*t68*t83+1.441975308641975
     1           4d-1*t66*t83-4.3880820922721503d-2*gammabb*t56*t80-2.53
     2           47222222222215d-4*t116*t21*t37*t59*t68*t79+5.0694444444
     3           44443d-4*t21*t59*t66*t67*t79-1.0138888888888886d-3*t21*
     4           t37*t57*t67*t79+6.887544671719978d-3*t21*t57*t79+1.4419
     5           753086419754d-1*t146*t37-1.802469135802469d-1*t146*t31+
     6           1.6455307846020564d-2*gammabb*t144*t16
              t148 = 1.3532736462850253d-1*gammabb*t56*t70*t84+1.2437810
     1           945273631d+0*t147*t18
              t149 = 4.6610156249999996d-3*gammabb*t26*t59*t60*t79-9.943
     1           5d-2*gammabb*t28*t59*t79-1.4565673828125d-4*gammabb*t10
     2           8*t109*t59*t79+1.553671875d-3*t23*t58*t60*t61+3.1073437
     3           5d-3*t104*t143*t19*t60
              t150 = 3.375d-1*t112*t34*t74*t82+6.170740442257711d-3*t16*
     1           t65*t82-4.9365923538061685d-2*t32*t65*t74+1.08310862522
     2           92235d-3*t34*t65*t73
              t151 = -9.012345679012345d-2*t67*t76*t83+1.441975308641975
     1           4d-1*t75*t83+1.6455307846020564d-2*t16*t80-2.5347222222
     2           222215d-4*t116*t21*t37*t59*t76*t79+5.069444444444443d-4
     3           *t21*t59*t67*t75*t79+1.0138888888888886d-3*gammabb*t37*
     4           t59*t67*t79-6.887544671719978d-3*gammabb*t59*t79+1.4419
     5           753086419754d-1*t150*t37-1.802469135802469d-1*t150*t31+
     6           1.6455307846020564d-2*gammabb*t149*t16
              t152 = 1.2437810945273631d+0*t151*t18-5.074776173568845d-2
     1           *t16*t70*t84
              t153 = t84**2
              t154 = 1/taub**6
              t155 = -3.10734375d-3*gammabb*t23*t60*t61*t79-4.6610156249
     1           999996d-3*t107*t21*t26*t59*t60-3.10734375d-3*t104*t105*
     2           t154*t60+1.491525d-1*t107*t21*t28*t59+1.4565673828125d-
     3           4*t107*t108*t109*t21*t59
              t156 = t82**2
              t157 = -9.873184707612337d-2*t32*t65*t82-8.664869001833788
     1           d-3*t34*t65*t81+3.375d-1*t112*t156*t34
              t158 = 1.4419753086419754d-1*t83**2+1.0138888888888886d-3*
     1           t21*t59*t67*t79*t83-1.520833333333333d-3*t107*t21*t37*t
     2           59*t67+1.0331317007579968d-2*t107*t21*t59+1.44197530864
     3           19754d-1*t157*t37+1.4257812499999994d-6*t104*t105*t116*
     4           t154*t37-1.802469135802469d-1*t157*t31+1.64553078460205
     5           64d-2*gammabb*t155*t16
              t159 = 1/rhoa**8
              t160 = 1/rhoa**6.333333333333333d+0
              t161 = 1/rhoa**4.666666666666667d+0
              t162 = 1.0125000000000002d+0*t3*t46*t94*t95+1.234148088451
     1           5423d-51*t45*t47*t95-1.8512221326773132d-51*t45*t93*t94
     2           -3.2910615692041123d-51*t46*t47*t92-8.044817169165608d-
     3           51*t161*t5-2.25d-1*t3*(-7.150948594813874d-51*t161*t3-2
     4           .9239475644048174d-101*t160)*t47-8.4375d-1*t3*t46**3/t4
     5           **3.5d+0-7.150948594813874d-51*t161
              t163 = 1/rhob**11
              t164 = 1/rhob**8.333333333333334d+0
              t165 = 1/rhob**5.666666666666667d+0
              t166 = gammabb**6
              t167 = 1/rhob**7
              t168 = 1/t27**5.0d+0
              t169 = t25**5.0d+0
              t170 = 1/t35**3.5d+0
              t171 = 8.044817169165608d-1*gammabb*t165-1.787737148703468
     1           2d+0*t103*t33
              t172 = -6.75d-1*t113*t64*t65-2.25d-1*t34*(5.85077612302953
     1           3d-1*t33*t56*t63-1.75523283690886d-1*gammabb*t103*t63+3
     2           .2910615692041123d-2*gammabb*t113*t56-7.150948594813873
     3           d-1*t103*t33*t34+3.217926867666243d-1*gammabb*t165*t34+
     4           4.38808209227215d-2*t171*t32*t33-2.194041046136075d-1*t
     5           113*t16*t33)*t65-6.75d-1*t114*t63*t65-8.4375d-1*t170*t3
     6           4*t64**3+1.0125000000000002d+0*t112*t114*t34*t64+1.0125
     7           000000000002d+0*t111*t112*t63+4.5d-1*t171*t36-5.0056640
     8           16369713d-1*gammabb*t165
              t173 = 1/t30**2.5d+0
              t174 = 1/t17**5.0d+0
              t175 = 1/t39**4
              t176 = gammabb**5
              t177 = -2.25d-1*t113*t65*t74+6.75d-1*t112*t63*t64*t74-8.43
     1           75d-1*t111*t170*t34*t74+3.375d-1*t112*t114*t34*t74-3.29
     2           10615692041123d-2*t56*t64*t65-2.25d-1*t34*(5.8507761230
     3           29533d-2*t56*t63-2.781315975897265d-2*t33*t55-1.0726422
     4           89222081d-1*t103*t34-1.0970205230680374d-2*t113*t16+3.2
     5           09210741419921d-3*gammabb*t102)*t65-4.5d-1*t129*t63*t65
     6           +6.170740442257711d-3*t114*t16*t65+6.75d-1*t112*t129*t3
     7           4*t64-1.2067225753748412d-1*t103*t36-9.256110663386565d
     8           -3*t111*t112*t16+1.0726422892220812d-1*t103
              t178 = -3.2910615692041123d-2*t56*t65*t74-1.85122213267731
     1           32d-2*t112*t16*t64*t74+6.75d-1*t112*t129*t34*t74-1.3538
     2           857815365296d-4*t22*t63*t65+7.220724168194822d-4*t34*t5
     3           5*t65+1.2341480884515421d-2*t129*t16*t65+2.030828672304
     4           794d-4*t112*t22*t34*t64-8.4375d-1*t136*t170*t34*t64+3.3
     5           75d-1*t112*t136*t63
              t179 = -8.4375d-1*t170*t34*t74**3+6.092486016914382d-4*t11
     1           2*t22*t34*t74+1.1139303661766865d-5*t20*t65-2.776833199
     2           01597d-2*t112*t136*t16
              t180 = 1/taub**7
              t181 = -2.25d-1*t113*t65*t82+6.75d-1*t112*t63*t64*t82-8.43
     1           75d-1*t111*t170*t34*t82+3.375d-1*t112*t114*t34*t82+1.64
     2           55307846020562d-1*t16*t64*t65-2.25d-1*t34*(-2.925388061
     3           5147665d-1*t16*t63+3.900517415353022d-1*t34*t56-2.08598
     4           69819229487d-2*gammabb*t55+1.3906579879486325d-1*t22*t3
     5           3+8.7761641845443d-2*t113*t32)*t65-4.5d-1*t145*t63*t65-
     6           4.9365923538061685d-2*t114*t32*t65+6.75d-1*t112*t145*t3
     7           4*t64+4.38808209227215d-1*t36*t56+7.404888530709253d-2*
     8           t111*t112*t32
              t182 = -8.4375d-1*t170*t34*t64*t74*t82+3.375d-1*t112*t63*t
     1           74*t82-1.6455307846020562d-2*t56*t65*t82-9.256110663386
     2           565d-3*t112*t16*t64*t82+3.375d-1*t112*t129*t34*t82+8.22
     3           7653923010281d-2*t16*t65*t74+7.404888530709253d-2*t112*
     4           t32*t64*t74+3.375d-1*t112*t145*t34*t74+1.08310862522922
     5           35d-3*t63*t65*t73-1.6246629378438354d-3*t112*t34*t64*t7
     6           3-4.693470709326635d-3*t22*t34*t65-4.9365923538061685d-
     7           2*t129*t32*t65+6.170740442257711d-3*t145*t16*t65
              t183 = -1.8512221326773132d-2*t112*t16*t74*t82+2.030828672
     1           304794d-4*t112*t22*t34*t82-8.4375d-1*t136*t170*t34*t82-
     2           3.249325875687671d-3*t112*t34*t73*t74-8.911442929413492
     3           d-5*t167*t65+7.404888530709253d-2*t112*t136*t32
              t184 = 1.4809777061418505d-1*t112*t32*t74*t82-3.2493258756
     1           87671d-3*t112*t34*t73*t82+1.2997303502750684d-2*t112*t3
     2           4*t74*t81-8.4375d-1*t156*t170*t34*t74+7.129154343530794
     3           d-4*t106*t65-9.256110663386565d-3*t112*t156*t16
              t185 = 1/taub**9
              t186 = -8.4375d-1*t170*t34*t82**3+3.899191050825205d-2*t11
     1           2*t34*t81*t82-5.703323474824635d-3*t127*t65+2.221466559
     2           2127758d-1*t112*t156*t32
              fnc(iq) = (-9.305257363490997d-1*t15*t40-9.305257363490997
     1           d-1*t15-9.305257363490997d-1*t1*t14-9.305257363490997d-
     2           1*t1)*wght+fnc(iq)
              Amat(iq,D1_RA) = (-7.481426920246762d-1*t1*t42*t51-1.24070
     1           09817987995d+0*t14*t41-1.2407009817987995d+0*t41)*wght+
     2           Amat(iq,D1_RA)
              Amat(iq,D1_RB) = (-7.481426920246762d-1*t15*t53*t71-1.2407
     1           009817987995d+0*t40*t52-1.2407009817987995d+0*t52)*wght
     2           +Amat(iq,D1_RB)
              Cmat(iq,D1_GAA) = Cmat(iq,D1_GAA)
              Cmat(iq,D1_GAB) = Cmat(iq,D1_GAB)
              Cmat(iq,D1_GBB) = Cmat(iq,D1_GBB)-7.481426920246762d-1*t15
     1           *t53*t78*wght
              Mmat(iq,D1_TA) = Mmat(iq,D1_TA)
              Mmat(iq,D1_TB) = Mmat(iq,D1_TB)-9.305257363490997d-1*t15*t
     1           18*t53*t84*wght
              Amat2(iq,D2_RA_RA) = (1.4962853840493523d+0*t1*t87*t88+t85
     1           *t86+t100*t42)*wght+Amat2(iq,D2_RA_RA)
              Amat2(iq,D2_RA_RB) = Amat2(iq,D2_RA_RB)
              Amat2(iq,D2_RB_RB) = (t122*t53+1.4962853840493523d+0*t125*
     1           t126*t15+t123*t124)*wght+Amat2(iq,D2_RB_RB)
              Cmat2(iq,D2_RA_GAA) = Cmat2(iq,D2_RA_GAA)
              Cmat2(iq,D2_RA_GAB) = Cmat2(iq,D2_RA_GAB)
              Cmat2(iq,D2_RA_GBB) = Cmat2(iq,D2_RA_GBB)
              Cmat2(iq,D2_RB_GAA) = Cmat2(iq,D2_RB_GAA)
              Cmat2(iq,D2_RB_GAB) = Cmat2(iq,D2_RB_GAB)
              Cmat2(iq,D2_RB_GBB) = (1.4962853840493523d+0*t125*t15*t71*
     1           t78+t134*t53)*wght+Cmat2(iq,D2_RB_GBB)
              Cmat2(iq,D2_GAA_GAA) = Cmat2(iq,D2_GAA_GAA)
              Cmat2(iq,D2_GAA_GAB) = Cmat2(iq,D2_GAA_GAB)
              Cmat2(iq,D2_GAA_GBB) = Cmat2(iq,D2_GAA_GBB)
              Cmat2(iq,D2_GAB_GAB) = Cmat2(iq,D2_GAB_GAB)
              Cmat2(iq,D2_GAB_GBB) = Cmat2(iq,D2_GAB_GBB)
              Cmat2(iq,D2_GBB_GBB) = -7.481426920246762d-1*t141*t15*t53*
     1           wght+1.4962853840493523d+0*t125*t142*t15*wght+Cmat2(iq,
     2           D2_GBB_GBB)
              Mmat2(iq,D2_RA_TA) = Mmat2(iq,D2_RA_TA)
              Mmat2(iq,D2_RA_TB) = Mmat2(iq,D2_RA_TB)
              Mmat2(iq,D2_RB_TA) = Mmat2(iq,D2_RB_TA)
              Mmat2(iq,D2_RB_TB) = (1.8610514726981991d+0*t125*t15*t18*t
     1           71*t84-1.2407009817987995d+0*t18*t52*t53*t84-7.48142692
     2           0246762d-1*t148*t15*t53)*wght+Mmat2(iq,D2_RB_TB)
              Mmat2(iq,D2_GAA_TA) = Mmat2(iq,D2_GAA_TA)
              Mmat2(iq,D2_GAA_TB) = Mmat2(iq,D2_GAA_TB)
              Mmat2(iq,D2_GAB_TA) = Mmat2(iq,D2_GAB_TA)
              Mmat2(iq,D2_GAB_TB) = Mmat2(iq,D2_GAB_TB)
              Mmat2(iq,D2_GBB_TA) = Mmat2(iq,D2_GBB_TA)
              Mmat2(iq,D2_GBB_TB) = 1.8610514726981991d+0*t125*t15*t18*t
     1           78*t84*wght-7.481426920246762d-1*t15*t152*t53*wght+Mmat
     2           2(iq,D2_GBB_TB)
              Mmat2(iq,D2_TA_TA) = Mmat2(iq,D2_TA_TA)
              Mmat2(iq,D2_TA_TB) = Mmat2(iq,D2_TA_TB)
              Mmat2(iq,D2_TB_TB) = -9.305257363490997d-1*t15*t158*t18*t5
     1           3*wght+2.3147406376843277d+0*t120*t125*t15*t153*wght+Mm
     2           at2(iq,D2_TB_TB)
              Amat3(iq,D3_RA_RA_RA) = (t87*(2.9925707680987046d+0*t1*t51
     1           *t99+1.9950471787324697d+0*t41*t88-2*t100*t51)+t42*(-2.
     2           9925707680987046d+0*t41*t99-7.481426920246762d-1*t1*(4.
     3           1411391964609867d-101*t49*t91*t98-1.1043037857229297d-1
     4           00*t10*t160*t98+1.0149552347137691d-50*t45*t50*t97+1.24
     5           37810945273631d+0*t12*(4.3259259259259264d-1*t48*t96+1.
     6           9522698676971195d-103*t43*t44*t96-8.459836093354184d-10
     7           3*t44*t48*t91+7.048401108259554d-206*t48*t89*t90-1.8024
     8           69135802469d-1*t162*t9-3.054307146912473d-205*t6*t89/rh
     9           oa**9.666666666666666d+0+2.544728011477048d-308*t6/(rho
     :           a**13*t8**2.5d+0)+1.5039708610407437d-102*t160*t44*t6+1
     ;           .4419753086419754d-1*t162*t6-4.054699302117567d-51*t161
     <           -6.327111529452114d-103*t160-2.020437778557039d-152*t15
     =           9)-2.706547292570051d-50*t49*t50*t92+3.308002246474507d
     >           -50*t10*t161*t50+7.509486683825926d-152*t10*t159/t11**5
     ?           .0d+0)-6.650157262441565d-1*t51*t86)-3.325078631220783d
     @           -1*t42*t51*t86-6.666666666666666d-1*t2*t85-4.4888561521
     1           48057d+0*t1*t51**3/t13**4)*wght+Amat3(iq,D3_RA_RA_RA)
              Amat3(iq,D3_RA_RA_RB) = Amat3(iq,D3_RA_RA_RB)
              Amat3(iq,D3_RA_RB_RB) = Amat3(iq,D3_RA_RB_RB)
              Amat3(iq,D3_RB_RB_RB) = (t53*(-7.481426920246762d-1*t15*(1
     1           .2437810945273631d+0*t18*(1.6455307846020564d-2*gammabb
     2           *t16*(-1.0195971679687499d-3*t106*t108*t19*t61*t79+1.82
     3           07092285156248d-5*t106*t168*t169*t19*t79+9.322031249999
     4           999d-3*gammabb*t104*t24*t60*t61+2.796609375d-2*t127*t21
     5           *t26*t58*t60+3.7288125d-2*t105*t107*t167*t60-5.9661d-1*
     6           t127*t21*t28*t58-8.739404296874999d-4*t108*t109*t127*t2
     7           1*t58-2.913134765625d-4*t108*t154*t166*t54)-6.759259259
     8           259258d-2*t173*t37*t68**3-2.703703703703703d-1*t115*t67
     9           *t68+1.3518518518518516d-1*t116*t118*t37*t68-2.70370370
     :           3703703d-1*t118*t66*t67-9.012345679012345d-2*t37*(-6.75
     ;           d-2*t127*t21*t58-3.3536252247838183d-2*t164*t21)*t67+1.
     <           3518518518518516d-1*t116*t117*t66+4.3259259259259264d-1
     =           *t115*t66+4.826890301499366d-1*gammabb*t103*t62-4.13252
     >           6803031987d-2*t127*t21*t58-1.3164246276816452d-1*gammab
     ?           b*t110*t56+1.4419753086419754d-1*t172*t37-1.80246913580
     @           2469d-1*t172*t31-7.50849602455457d-1*gammabb*t165*t29-1
     1           .2715060669764344d-3*t164*t21-1.0823773813698424d-3*t16
     2           3*t19)-1.4886010109135278d+0*gammabb*t103*t69*t70+4.059
     3           820938855076d-1*gammabb*t119*t56*t70+2.3156015725321547
     4           d+0*gammabb*t165*t38*t70+6.625822714337577d-2*t102*t120
     5           *t21*t69-2.4294683285904448d-1*t120*t164*t21*t38+4.8060
     6           7147764859d-3*t163*t174*t19*t38)-6.650157262441565d-1*t
     7           123*t71-2.9925707680987046d+0*t121*t52)-4.4888561521480
     8           57d+0*t15*t175*t71**3+t125*(2.9925707680987046d+0*t121*
     9           t15*t71-2*t122*t71+1.9950471787324697d+0*t126*t52)-3.32
     :           5078631220783d-1*t123*t53*t71-6.666666666666666d-1*t124
     ;           *t32)*wght+Amat3(iq,D3_RB_RB_RB)
              Cmat3(iq,D3_RA_RA_GAA) = Cmat3(iq,D3_RA_RA_GAA)
              Cmat3(iq,D3_RA_RA_GAB) = Cmat3(iq,D3_RA_RA_GAB)
              Cmat3(iq,D3_RA_RA_GBB) = Cmat3(iq,D3_RA_RA_GBB)
              Cmat3(iq,D3_RA_RB_GAA) = Cmat3(iq,D3_RA_RB_GAA)
              Cmat3(iq,D3_RA_RB_GAB) = Cmat3(iq,D3_RA_RB_GAB)
              Cmat3(iq,D3_RA_RB_GBB) = Cmat3(iq,D3_RA_RB_GBB)
              Cmat3(iq,D3_RB_RB_GAA) = Cmat3(iq,D3_RB_RB_GAA)
              Cmat3(iq,D3_RB_RB_GAB) = Cmat3(iq,D3_RB_RB_GAB)
              Cmat3(iq,D3_RB_RB_GBB) = (t53*(-7.481426920246762d-1*t15*(
     1           1.2437810945273631d+0*t18*(1.6455307846020564d-2*gammab
     2           b*t16*(1.0195971679687499d-3*t108*t127*t21*t61*t79-1.82
     3           07092285156248d-5*t127*t168*t169*t21*t79-3.10734375d-3*
     4           t24*t57*t60*t61-1.86440625d-2*gammabb*t104*t26*t58*t60-
     5           3.10734375d-2*t106*t107*t19*t60+2.98305d-1*gammabb*t104
     6           *t28*t58+5.82626953125d-4*gammabb*t104*t108*t109*t58+2.
     7           913134765625d-4*t108*t154*t176*t20)+9.012345679012345d-
     8           2*t116*t66*t68*t76-9.012345679012345d-2*t115*t67*t76-6.
     9           759259259259258d-2*t117*t173*t37*t76+4.5061728395061723
     :           d-2*t116*t118*t37*t76-9.012345679012345d-2*t118*t67*t75
     ;           +4.5061728395061723d-2*t116*t117*t75+1.4419753086419754
     <           d-1*t115*t75+1.6089634338331218d-1*gammabb*t103*t72-1.8
     =           02469135802469d-1*t130*t67*t68+9.012345679012345d-2*t11
     >           6*t131*t37*t68-1.802469135802469d-1*t131*t66*t67-9.0123
     ?           45679012345d-2*t37*(3.375d-2*gammabb*t104*t58+9.1462506
     @           13046778d-3*gammabb*t102)*t67+2.883950617283951d-1*t130
     1           *t66-8.776164184544301d-2*t56*t62+2.0662634015159936d-2
     2           *gammabb*t104*t58-8.776164184544301d-2*gammabb*t128*t56
     3           +1.4419753086419754d-1*t177*t37-1.802469135802469d-1*t1
     4           77*t31+1.6089634338331218d-1*t103*t29+3.247132144109527
     5           4d-4*t101*t21+1.6455307846020564d-2*t110*t16+3.46774381
     6           9026639d-4*gammabb*t102)-4.9620033697117594d-1*gammabb*
     7           t103*t70*t77+2.208607571445859d-2*t102*t120*t21*t77+2.7
     8           065472925700507d-1*t56*t69*t70+2.7065472925700507d-1*ga
     9           mmabb*t132*t56*t70-4.9620033697117594d-1*t103*t38*t70-5
     :           .074776173568845d-2*t119*t16*t70-1.6564556785843942d-2*
     ;           gammabb*t120*t55*t69-1.8022768041182213d-3*t101*t174*t2
     <           1*t38+7.454050553629774d-2*gammabb*t102*t120*t38)-1.995
     =           0471787324697d+0*t133*t52)+t125*(2.9925707680987046d+0*
     >           t133*t15*t71-2*t122*t78)-3.325078631220783d-1*t123*t53*
     ?           t78-4.488856152148057d+0*t126*t15*t175*t78)*wght+Cmat3(
     @           iq,D3_RB_RB_GBB)
              Cmat3(iq,D3_RA_GAA_GAA) = Cmat3(iq,D3_RA_GAA_GAA)
              Cmat3(iq,D3_RA_GAA_GAB) = Cmat3(iq,D3_RA_GAA_GAB)
              Cmat3(iq,D3_RA_GAA_GBB) = Cmat3(iq,D3_RA_GAA_GBB)
              Cmat3(iq,D3_RA_GAB_GAB) = Cmat3(iq,D3_RA_GAB_GAB)
              Cmat3(iq,D3_RA_GAB_GBB) = Cmat3(iq,D3_RA_GAB_GBB)
              Cmat3(iq,D3_RA_GBB_GBB) = Cmat3(iq,D3_RA_GBB_GBB)
              Cmat3(iq,D3_RB_GAA_GAA) = Cmat3(iq,D3_RB_GAA_GAA)
              Cmat3(iq,D3_RB_GAA_GAB) = Cmat3(iq,D3_RB_GAA_GAB)
              Cmat3(iq,D3_RB_GAA_GBB) = Cmat3(iq,D3_RB_GAA_GBB)
              Cmat3(iq,D3_RB_GAB_GAB) = Cmat3(iq,D3_RB_GAB_GAB)
              Cmat3(iq,D3_RB_GAB_GBB) = Cmat3(iq,D3_RB_GAB_GBB)
              Cmat3(iq,D3_RB_GBB_GBB) = (t53*(-7.481426920246762d-1*t15*
     1           (1.2437810945273631d+0*t18*(1.6455307846020564d-2*gamma
     2           bb*t16*(-1.0195971679687499d-3*gammabb*t104*t108*t61*t7
     3           9+1.8207092285156248d-5*gammabb*t104*t168*t169*t79+9.32
     4           2031249999999d-3*t26*t57*t58*t60+2.485875d-2*t107*t127*
     5           t21*t60-9.9435d-2*t28*t57*t58-2.913134765625d-4*t108*t1
     6           09*t57*t58-2.913134765625d-4*t105*t108*t154*t167)+9.012
     7           345679012345d-2*t116*t68*t75*t76-1.802469135802469d-1*t
     8           130*t67*t76+9.012345679012345d-2*t116*t131*t37*t76-1.80
     9           2469135802469d-1*t131*t67*t75+2.883950617283951d-1*t130
     :           *t75-8.776164184544301d-2*t56*t72-9.012345679012345d-2*
     ;           t137*t67*t68-6.759259259259258d-2*t138*t173*t37*t68+4.5
     <           061728395061723d-2*t116*t139*t37*t68-9.012345679012345d
     =           -2*t139*t66*t67-9.012345679012345d-2*t37*(-1.1249999999
     >           999999d-2*t57*t58-1.444144833638965d-3*t55)*t67+4.50617
     ?           28395061723d-2*t116*t138*t66+1.4419753086419754d-1*t137
     @           *t66-6.887544671719978d-3*t57*t58-4.3880820922721503d-2
     1           *gammabb*t135*t56-5.475384977410482d-5*t55-7.2158492091
     2           32282d-5*gammabb*t54+1.4419753086419754d-1*t178*t37-1.8
     3           02469135802469d-1*t178*t31+3.291061569204113d-2*t128*t1
     4           6)+2.7065472925700507d-1*t56*t70*t77-1.6564556785843942
     5           d-2*gammabb*t120*t55*t77+1.3532736462850253d-1*gammabb*
     6           t140*t56*t70-1.014955234713769d-1*t132*t16*t70+3.105854
     7           39734574d-3*t120*t22*t69-1.6564556785843942d-2*t120*t38
     8           *t55+6.758538015443329d-4*gammabb*t174*t38*t54)-9.97523
     9           5893662349d-1*t141*t52)+t125*(1.4962853840493523d+0*t13
     :           3*t15*t78-2*t134*t78+1.4962853840493523d+0*t141*t15*t71
     ;           )-4.488856152148057d+0*t142*t15*t175*t71)*wght+Cmat3(iq
     <           ,D3_RB_GBB_GBB)
              Cmat3(iq,D3_GAA_GAA_GAA) = Cmat3(iq,D3_GAA_GAA_GAA)
              Cmat3(iq,D3_GAA_GAA_GAB) = Cmat3(iq,D3_GAA_GAA_GAB)
              Cmat3(iq,D3_GAA_GAA_GBB) = Cmat3(iq,D3_GAA_GAA_GBB)
              Cmat3(iq,D3_GAA_GAB_GAB) = Cmat3(iq,D3_GAA_GAB_GAB)
              Cmat3(iq,D3_GAA_GAB_GBB) = Cmat3(iq,D3_GAA_GAB_GBB)
              Cmat3(iq,D3_GAA_GBB_GBB) = Cmat3(iq,D3_GAA_GBB_GBB)
              Cmat3(iq,D3_GAB_GAB_GAB) = Cmat3(iq,D3_GAB_GAB_GAB)
              Cmat3(iq,D3_GAB_GAB_GBB) = Cmat3(iq,D3_GAB_GAB_GBB)
              Cmat3(iq,D3_GAB_GBB_GBB) = Cmat3(iq,D3_GAB_GBB_GBB)
              Cmat3(iq,D3_GBB_GBB_GBB) = -7.481426920246762d-1*t15*t53*(
     1           1.2437810945273631d+0*t18*(1.6455307846020564d-2*gammab
     2           b*t16*(1.0195971679687499d-3*t108*t57*t61*t79-1.8207092
     3           285156248d-5*t168*t169*t57*t79-1.86440625d-2*gammabb*t1
     4           04*t107*t60+2.913134765625d-4*t106*t108*t154*t19)-6.759
     5           259259259258d-2*t173*t37*t76**3-2.703703703703703d-1*t1
     6           37*t67*t76+1.3518518518518516d-1*t116*t139*t37*t76-2.70
     7           3703703703703d-1*t139*t67*t75+1.3518518518518516d-1*t11
     8           6*t138*t75+4.3259259259259264d-1*t137*t75+1.44197530864
     9           19754d-1*t179*t37-1.802469135802469d-1*t179*t31+9.01981
     :           1511415352d-6*t20+4.9365923538061696d-2*t135*t16)+9.317
     ;           563192037218d-3*t120*t22*t77-1.5224328520706534d-1*t140
     <           *t16*t70-2.534451755791249d-4*t174*t20*t38)*wght-4.4888
     =           56152148057d+0*t15*t175*t78**3*wght+4.488856152148057d+
     >           0*t125*t141*t15*t78*wght+Cmat3(iq,D3_GBB_GBB_GBB)
              Mmat3(iq,D3_RA_RA_TA) = Mmat3(iq,D3_RA_RA_TA)
              Mmat3(iq,D3_RA_RA_TB) = Mmat3(iq,D3_RA_RA_TB)
              Mmat3(iq,D3_RA_RB_TA) = Mmat3(iq,D3_RA_RB_TA)
              Mmat3(iq,D3_RA_RB_TB) = Mmat3(iq,D3_RA_RB_TB)
              Mmat3(iq,D3_RB_RB_TA) = Mmat3(iq,D3_RB_RB_TA)
              Mmat3(iq,D3_RB_RB_TB) = (t53*(-7.481426920246762d-1*t15*(-
     1           4.9620033697117594d-1*gammabb*t103*t70*t84+2.2086075714
     2           45859d-2*t102*t120*t21*t84+1.2437810945273631d+0*t18*(-
     3           9.012345679012345d-2*t118*t67*t83+4.5061728395061723d-2
     4           *t116*t117*t83+1.4419753086419754d-1*t115*t83+1.6089634
     5           338331218d-1*gammabb*t103*t80+1.6455307846020564d-2*gam
     6           mabb*t16*(1.86440625d-2*t104*t21*t26*t60*t79-2.98305d-1
     7           *t104*t21*t28*t79-5.82626953125d-4*t104*t108*t109*t21*t
     8           79+3.10734375d-3*gammabb*t57*t58*t60*t61-1.019597167968
     9           7499d-3*t107*t108*t127*t19*t61+3.10734375d-2*t105*t106*
     :           t143*t60-2.913134765625d-4*t108*t166*t180*t20+1.8207092
     ;           285156248d-5*t107*t127*t168*t169*t19)-5.069444444444443
     <           d-4*t116*t21*t59*t66*t68*t79+1.0138888888888886d-3*t116
     =           *t21*t37*t57*t68*t79-2.0277777777777772d-3*t21*t57*t66*
     >           t67*t79+5.069444444444443d-4*t115*t21*t59*t67*t79+3.041
     ?           6666666666664d-3*t104*t21*t37*t67*t79+3.802083333333333
     @           d-4*t117*t173*t21*t37*t59*t79-2.5347222222222215d-4*t11
     1           6*t118*t21*t37*t59*t79-2.0662634015159936d-2*t104*t21*t
     2           79-1.802469135802469d-1*t146*t67*t68+2.883950617283951d
     3           -1*t146*t66-8.776164184544301d-2*gammabb*t144*t56+1.441
     4           9753086419754d-1*t181*t37-1.802469135802469d-1*t181*t31
     5           )+2.7065472925700507d-1*gammabb*t147*t56*t70)-1.9950471
     6           787324697d+0*t148*t52)-4.1356699393293317d-1*t123*t18*t
     7           53*t84-5.583154418094598d+0*t126*t15*t175*t18*t84-2.487
     8           5621890547261d+0*t122*t125*t18*t84+2.9925707680987046d+
     9           0*t125*t148*t15*t71)*wght+Mmat3(iq,D3_RB_RB_TB)
              Mmat3(iq,D3_RA_GAA_TA) = Mmat3(iq,D3_RA_GAA_TA)
              Mmat3(iq,D3_RA_GAA_TB) = Mmat3(iq,D3_RA_GAA_TB)
              Mmat3(iq,D3_RA_GAB_TA) = Mmat3(iq,D3_RA_GAB_TA)
              Mmat3(iq,D3_RA_GAB_TB) = Mmat3(iq,D3_RA_GAB_TB)
              Mmat3(iq,D3_RA_GBB_TA) = Mmat3(iq,D3_RA_GBB_TA)
              Mmat3(iq,D3_RA_GBB_TB) = Mmat3(iq,D3_RA_GBB_TB)
              Mmat3(iq,D3_RB_GAA_TA) = Mmat3(iq,D3_RB_GAA_TA)
              Mmat3(iq,D3_RB_GAA_TB) = Mmat3(iq,D3_RB_GAA_TB)
              Mmat3(iq,D3_RB_GAB_TA) = Mmat3(iq,D3_RB_GAB_TA)
              Mmat3(iq,D3_RB_GAB_TB) = Mmat3(iq,D3_RB_GAB_TB)
              Mmat3(iq,D3_RB_GBB_TA) = Mmat3(iq,D3_RB_GBB_TA)
              Mmat3(iq,D3_RB_GBB_TB) = (t53*(-7.481426920246762d-1*t15*(
     1           1.3532736462850253d-1*t56*t70*t84-8.282278392921971d-3*
     2           gammabb*t120*t55*t84+1.2437810945273631d+0*t18*(4.50617
     3           28395061723d-2*t116*t68*t76*t83-9.012345679012345d-2*t1
     4           31*t67*t83+1.4419753086419754d-1*t130*t83-4.38808209227
     5           21503d-2*t56*t80+1.6455307846020564d-2*gammabb*t16*(-1.
     6           3983046875d-2*gammabb*t26*t57*t60*t79+1.9887d-1*gammabb
     7           *t28*t57*t79+4.369702148437499d-4*gammabb*t108*t109*t57
     8           *t79-1.553671875d-3*t58*t59*t60*t61+1.0195971679687499d
     9           -3*t104*t107*t108*t21*t61-2.796609375d-2*t127*t143*t19*
     :           t60-1.8207092285156248d-5*t104*t107*t168*t169*t21+2.913
     ;           134765625d-4*t108*t167*t176*t180)+3.802083333333333d-4*
     <           t173*t21*t37*t59*t68*t76*t79-2.5347222222222215d-4*t116
     =           *t21*t59*t66*t76*t79+5.069444444444443d-4*t116*t21*t37*
     >           t57*t76*t79-2.5347222222222215d-4*t116*t21*t59*t68*t75*
     ?           t79-1.0138888888888886d-3*t21*t57*t67*t75*t79-5.0694444
     @           44444443d-4*gammabb*t116*t37*t59*t68*t79+1.013888888888
     1           8886d-3*gammabb*t59*t66*t67*t79+5.069444444444443d-4*t1
     2           30*t21*t59*t67*t79-2.0277777777777772d-3*gammabb*t37*t5
     3           7*t67*t79-2.5347222222222215d-4*t116*t131*t21*t37*t59*t
     4           79+1.3775089343439956d-2*gammabb*t57*t79-9.012345679012
     5           345d-2*t146*t67*t76+1.4419753086419754d-1*t146*t75-9.01
     6           2345679012345d-2*t150*t67*t68+1.4419753086419754d-1*t15
     7           0*t66-4.3880820922721503d-2*gammabb*t149*t56+1.44197530
     8           86419754d-1*t182*t37-1.802469135802469d-1*t182*t31+1.64
     9           55307846020564d-2*t144*t16)+1.3532736462850253d-1*gamma
     :           bb*t151*t56*t70-5.074776173568845d-2*t147*t16*t70)-9.97
     ;           5235893662349d-1*t152*t52)-5.583154418094598d+0*t15*t17
     <           5*t18*t71*t78*t84-2.4875621890547261d+0*t125*t134*t18*t
     =           84+t125*(1.4962853840493523d+0*t148*t15*t78+1.496285384
     >           0493523d+0*t15*t152*t71))*wght+Mmat3(iq,D3_RB_GBB_TB)
              Mmat3(iq,D3_RA_TA_TA) = Mmat3(iq,D3_RA_TA_TA)
              Mmat3(iq,D3_RA_TA_TB) = Mmat3(iq,D3_RA_TA_TB)
              Mmat3(iq,D3_RA_TB_TB) = Mmat3(iq,D3_RA_TB_TB)
              Mmat3(iq,D3_RB_TA_TA) = Mmat3(iq,D3_RB_TA_TA)
              Mmat3(iq,D3_RB_TA_TB) = Mmat3(iq,D3_RB_TA_TB)
              Mmat3(iq,D3_RB_TB_TB) = Mmat3(iq,D3_RB_TB_TB)
              Mmat3(iq,D3_GAA_GAA_TA) = Mmat3(iq,D3_GAA_GAA_TA)
              Mmat3(iq,D3_GAA_GAA_TB) = Mmat3(iq,D3_GAA_GAA_TB)
              Mmat3(iq,D3_GAA_GAB_TA) = Mmat3(iq,D3_GAA_GAB_TA)
              Mmat3(iq,D3_GAA_GAB_TB) = Mmat3(iq,D3_GAA_GAB_TB)
              Mmat3(iq,D3_GAA_GBB_TA) = Mmat3(iq,D3_GAA_GBB_TA)
              Mmat3(iq,D3_GAA_GBB_TB) = -7.481426920246762d-1*t15*t53*(3
     1           .10585439734574d-3*t120*t22*t84+1.2437810945273631d+0*t
     2           18*(-9.012345679012345d-2*t139*t67*t83+4.50617283950617
     3           23d-2*t116*t138*t83+1.4419753086419754d-1*t137*t83+1.64
     4           55307846020564d-2*gammabb*t16*(9.322031249999999d-3*t26
     5           *t59*t60*t79-9.9435d-2*t28*t59*t79-2.913134765625d-4*t1
     6           08*t109*t59*t79-1.0195971679687499d-3*gammabb*t107*t108
     7           *t57*t61+2.485875d-2*t104*t143*t21*t60+1.82070922851562
     8           48d-5*gammabb*t107*t168*t169*t57-2.913134765625d-4*t105
     9           *t106*t108*t180)-5.069444444444443d-4*t116*t21*t59*t75*
     :           t76*t79-1.0138888888888886d-3*gammabb*t116*t37*t59*t76*
     ;           t79+2.0277777777777772d-3*gammabb*t59*t67*t75*t79+1.013
     <           8888888888886d-3*t37*t59*t67*t79+5.069444444444443d-4*t
     =           137*t21*t59*t67*t79+3.802083333333333d-4*t138*t173*t21*
     >           t37*t59*t79-2.5347222222222215d-4*t116*t139*t21*t37*t59
     ?           *t79-6.887544671719978d-3*t59*t79-1.802469135802469d-1*
     @           t150*t67*t76+2.883950617283951d-1*t150*t75+1.4419753086
     1           419754d-1*t183*t37-1.802469135802469d-1*t183*t31+3.2910
     2           61569204113d-2*t149*t16)-1.014955234713769d-1*t151*t16*
     3           t70)*wght-5.583154418094598d+0*t142*t15*t175*t18*t84*wg
     4           ht+1.8610514726981991d+0*t125*t141*t15*t18*t84*wght+2.9
     5           925707680987046d+0*t125*t15*t152*t78*wght+Mmat3(iq,D3_G
     6           AA_GBB_TB)
              Mmat3(iq,D3_GAB_GAB_TA) = Mmat3(iq,D3_GAB_GAB_TA)
              Mmat3(iq,D3_GAB_GAB_TB) = Mmat3(iq,D3_GAB_GAB_TB)
              Mmat3(iq,D3_GAB_GBB_TA) = Mmat3(iq,D3_GAB_GBB_TA)
              Mmat3(iq,D3_GAB_GBB_TB) = Mmat3(iq,D3_GAB_GBB_TB)
              Mmat3(iq,D3_GBB_GBB_TA) = Mmat3(iq,D3_GBB_GBB_TA)
              Mmat3(iq,D3_GBB_GBB_TB) = Mmat3(iq,D3_GBB_GBB_TB)
              Mmat3(iq,D3_GAA_TA_TA) = Mmat3(iq,D3_GAA_TA_TA)
              Mmat3(iq,D3_GAA_TA_TB) = Mmat3(iq,D3_GAA_TA_TB)
              Mmat3(iq,D3_GAA_TB_TB) = t125*t18*(3.7221029453963983d+0*t
     1           15*t152*t84*wght+1.8610514726981991d+0*t15*t158*t78*wgh
     2           t)-7.481426920246762d-1*t15*t53*(1.2437810945273631d+0*
     3           t18*(1.6455307846020564d-2*gammabb*t16*(2.913134765625d
     4           -4*t106*t108*t176/taub**8-3.10734375d-3*t23*t60*t61*t79
     5           +1.0195971679687499d-3*t108*t143*t21*t57*t61-1.86440625
     6           d-2*gammabb*t107*t26*t59*t60-3.10734375d-2*t104*t154*t1
     7           9*t60+2.98305d-1*gammabb*t107*t28*t59+5.82626953125d-4*
     8           gammabb*t107*t108*t109*t59-1.8207092285156248d-5*t143*t
     9           168*t169*t21*t57)-5.069444444444443d-4*t116*t21*t59*t76
     :           *t79*t83+2.0277777777777772d-3*gammabb*t59*t67*t79*t83+
     ;           2.883950617283951d-1*t150*t83+1.0138888888888886d-3*t15
     <           0*t21*t59*t67*t79-9.012345679012345d-2*t157*t67*t76+7.6
     =           04166666666664d-4*t107*t116*t21*t37*t59*t76-2.138671874
     >           9999997d-6*t104*t105*t154*t173*t37*t76-1.52083333333333
     ?           3d-3*t107*t21*t59*t67*t75+1.4419753086419754d-1*t157*t7
     @           5+1.4257812499999994d-6*t104*t105*t116*t154*t75-3.04166
     1           6666666666d-3*gammabb*t107*t37*t59*t67+2.06626340151599
     2           36d-2*gammabb*t107*t59+5.703124999999998d-6*t104*t116*t
     3           154*t19*t37+1.4419753086419754d-1*t184*t37-1.8024691358
     4           02469d-1*t184*t31+1.6455307846020564d-2*t155*t16)-5.074
     5           776173568845d-2*t158*t16*t70)*wght-6.944221913052981d+0
     6           *t120*t15*t153*t175*t78*wght+Mmat3(iq,D3_GAA_TB_TB)
              Mmat3(iq,D3_GAB_TA_TA) = Mmat3(iq,D3_GAB_TA_TA)
              Mmat3(iq,D3_GAB_TA_TB) = Mmat3(iq,D3_GAB_TA_TB)
              Mmat3(iq,D3_GAB_TB_TB) = Mmat3(iq,D3_GAB_TB_TB)
              Mmat3(iq,D3_GBB_TA_TA) = -8.637091931657939d+0*t15*t175*t8
     1           4**3*wght/t17**6.0d+0+6.944221913052984d+0*t120*t125*t1
     2           5*t158*t84*wght-9.305257363490997d-1*t15*t18*t53*(-4.56
     3           2499999999999d-3*t107*t21*t59*t67*t83+4.325925925925926
     4           4d-1*t157*t83+4.2773437499999983d-6*t104*t105*t116*t154
     5           *t83+1.520833333333333d-3*t157*t21*t59*t67*t79+6.083333
     6           333333332d-3*t143*t21*t37*t59*t67+1.6455307846020564d-2
     7           *gammabb*t16*(9.322031249999999d-3*gammabb*t107*t23*t60
     8           *t61-1.0195971679687499d-3*t108*t154*t19*t57*t61+2.7966
     9           09375d-2*t143*t21*t26*t59*t60+3.7288125d-2*t104*t105*t1
     :           80*t60-5.9661d-1*t143*t21*t28*t59-8.739404296874999d-4*
     ;           t108*t109*t143*t21*t59+1.8207092285156248d-5*t154*t168*
     <           t169*t19*t57-2.913134765625d-4*t106*t108*t166*t185)-4.1
     =           32526803031987d-2*t143*t21*t59+1.4419753086419754d-1*t1
     >           86*t37+1.2030029296874996d-8*t106*t166*t173*t185*t37-1.
     ?           2832031249999995d-5*t104*t105*t116*t180*t37-1.802469135
     @           802469d-1*t186*t31)*wght+Mmat3(iq,D3_GBB_TA_TA)
            else 
              t1 = rhoa**1.3333333333333333d+0
              t2 = 1/rhoa**1.6666666666666669d+0
              t3 = 1.0970205230680374d-51*t2-1.0d+0
              t4 = 4.3880820922721503d-52*t2*t3+1.0d+0
              t5 = 1/t4**5.0d-1
              t6 = 4.5d-1*t3*t5+4.3880820922721503d-52*t2
              t7 = 1/rhoa**3.3333333333333337d+0
              t8 = 2.166217250458448d-103*t7+4.4999999999999996d-2
              t9 = t8**5.0d-1
              t10 = -1.802469135802469d-1*t6*t9+8.213077466115726d-105*t
     1           7+7.209876543209877d-2*t6**2+2.4881109353903252d-52*t2+
     2           9.621132278843042d-155/rhoa**5+2.755017868687991d-2
              t11 = 8.160240087098705d-52*t2+1.0d+0
              t12 = 1/t11**2.0d+0
              t13 = 1.2437810945273631d+0*t10*t12+1.0d+0
              t14 = 8.04d-1-8.04d-1/t13
              t15 = rhob**1.3333333333333333d+0
              t16 = 1/rhob**1.6666666666666669d+0
              t17 = 1.0970205230680374d-51*t16-1.0d+0
              t18 = 4.3880820922721503d-52*t16*t17+1.0d+0
              t19 = 1/t18**5.0d-1
              t20 = 4.5d-1*t17*t19+4.3880820922721503d-52*t16
              t21 = 1/rhob**3.3333333333333337d+0
              t22 = 2.166217250458448d-103*t21+4.4999999999999996d-2
              t23 = t22**5.0d-1
              t24 = -1.802469135802469d-1*t20*t23+8.213077466115726d-105
     1           *t21+7.209876543209877d-2*t20**2+2.4881109353903252d-52
     2           *t16+9.621132278843042d-155/rhob**5+2.755017868687991d-
     3           2
              t25 = 8.160240087098705d-52*t16+1.0d+0
              t26 = 1/t25**2.0d+0
              t27 = 1.2437810945273631d+0*t24*t26+1.0d+0
              t28 = 8.04d-1-8.04d-1/t27
              t29 = rhoa**3.333333333333333d-1
              t30 = 1/t13**2
              t31 = 1/rhoa**4.333333333333333d+0
              t32 = 1/t9
              t33 = 1/rhoa**2.6666666666666666d+0
              t34 = -7.313470153786917d-52*t3*t33-8.023026853549804d-103
     1           *t31
              t35 = 1/t4**1.5d+0
              t36 = -8.227653923010281d-52*t33*t5-2.25d-1*t3*t34*t35-7.3
     1           13470153786917d-52*t33
              t37 = -1.802469135802469d-1*t36*t9+1.4419753086419754d-1*t
     1           36*t6+6.507566225657065d-104*t31*t32*t6-4.1468515589838
     2           76d-52*t33-2.737692488705242d-104*t31-4.810566139421521
     3           d-154/rhoa**6
              t38 = 1/t11**3.0d+0
              t39 = 3.3831841157125636d-51*t10*t33*t38+1.243781094527363
     1           1d+0*t12*t37
              t40 = rhob**3.333333333333333d-1
              t41 = 1/t27**2
              t42 = 1/rhob**4.333333333333333d+0
              t43 = 1/t23
              t44 = 1/rhob**2.6666666666666666d+0
              t45 = -7.313470153786917d-52*t17*t44-8.023026853549804d-10
     1           3*t42
              t46 = 1/t18**1.5d+0
              t47 = -2.25d-1*t17*t45*t46-8.227653923010281d-52*t19*t44-7
     1           .313470153786917d-52*t44
              t48 = -1.802469135802469d-1*t23*t47+1.4419753086419754d-1*
     1           t20*t47-4.146851558983876d-52*t44+6.507566225657065d-10
     2           4*t20*t42*t43-2.737692488705242d-104*t42-4.810566139421
     3           521d-154/rhob**6
              t49 = 1/t25**3.0d+0
              t50 = 3.3831841157125636d-51*t24*t44*t49+1.243781094527363
     1           1d+0*t26*t48
              t51 = -4.1356699393293317d-1*t14-4.1356699393293317d-1
              t52 = 1/rhoa**6.666666666666666d-1
              t53 = 1/t13**3
              t54 = t39**2
              t55 = 1/t8**1.5d+0
              t56 = 1/rhoa**8.666666666666666d+0
              t57 = 1/rhoa**5.333333333333333d+0
              t58 = 1/rhoa**3.6666666666666664d+0
              t59 = t34**2
              t60 = 1/t4**2.5d+0
              t61 = 1.9502587076765113d-51*t3*t58+4.8138161121298817d-10
     1           2*t57
              t62 = -2.25d-1*t3*t35*t61+3.375d-1*t3*t59*t60+2.1940410461
     1           36075d-51*t5*t58+1.9502587076765113d-51*t58+8.227653923
     2           010281d-52*t33*t34*t35
              t63 = -1.802469135802469d-1*t62*t9+1.4419753086419754d-1*t
     1           6*t62-2.8199453644513944d-103*t32*t57*t6+2.349467036086
     2           518d-206*t55*t56*t6+1.1058270823957002d-51*t58+1.186333
     3           4117722714d-103*t57+1.4419753086419754d-1*t36**2+1.3015
     4           13245131413d-103*t31*t32*t36+2.886339683652913d-153/rho
     5           a**7
              t64 = 1/t11**4.0d+0
              t65 = 1.3803797321536623d-101*t10*t57*t64+1.24378109452736
     1           31d+0*t12*t63-9.021824308566837d-51*t10*t38*t58+6.76636
     2           8231425127d-51*t33*t37*t38
              t66 = -7.481426920246762d-1*t1*t65-1.9950471787324697d+0*t
     1           29*t39
              t67 = -4.1356699393293317d-1*t28-4.1356699393293317d-1
              t68 = 1/rhob**6.666666666666666d-1
              t69 = 1/t27**3
              t70 = t50**2
              t71 = 1/t22**1.5d+0
              t72 = 1/rhob**8.666666666666666d+0
              t73 = 1/rhob**5.333333333333333d+0
              t74 = 1/rhob**3.6666666666666664d+0
              t75 = t45**2
              t76 = 1/t18**2.5d+0
              t77 = 1.9502587076765113d-51*t17*t74+4.8138161121298817d-1
     1           02*t73
              t78 = -2.25d-1*t17*t46*t77+3.375d-1*t17*t75*t76+2.19404104
     1           6136075d-51*t19*t74+1.9502587076765113d-51*t74+8.227653
     2           923010281d-52*t44*t45*t46
              t79 = -1.802469135802469d-1*t23*t78+1.4419753086419754d-1*
     1           t20*t78+1.1058270823957002d-51*t74-2.8199453644513944d-
     2           103*t20*t43*t73+1.1863334117722714d-103*t73+2.349467036
     3           086518d-206*t20*t71*t72+1.4419753086419754d-1*t47**2+1.
     4           301513245131413d-103*t42*t43*t47+2.886339683652913d-153
     5           /rhob**7
              t80 = 1/t25**4.0d+0
              t81 = 1.3803797321536623d-101*t24*t73*t80+1.24378109452736
     1           31d+0*t26*t79-9.021824308566837d-51*t24*t49*t74+6.76636
     2           8231425127d-51*t44*t48*t49
              t82 = -7.481426920246762d-1*t15*t81-1.9950471787324697d+0*
     1           t40*t50
              t83 = 1/rhoa**8
              t84 = 1/rhoa**6.333333333333333d+0
              t85 = 1/rhoa**4.666666666666667d+0
              t86 = -2.25d-1*t3*t35*(-7.150948594813874d-51*t3*t85-2.923
     1           9475644048174d-101*t84)-8.044817169165608d-51*t5*t85-7.
     2           150948594813874d-51*t85+1.0125000000000002d+0*t3*t34*t6
     3           0*t61+1.2341480884515423d-51*t33*t35*t61-1.851222132677
     4           3132d-51*t33*t59*t60-3.2910615692041123d-51*t34*t35*t58
     5           -8.4375d-1*t3*t34**3/t4**3.5d+0
              t87 = 1/rhob**8
              t88 = 1/rhob**6.333333333333333d+0
              t89 = 1/rhob**4.666666666666667d+0
              t90 = -2.25d-1*t17*t46*(-7.150948594813874d-51*t17*t89-2.9
     1           239475644048174d-101*t88)-8.044817169165608d-51*t19*t89
     2           -7.150948594813874d-51*t89+1.0125000000000002d+0*t17*t4
     3           5*t76*t77+1.2341480884515423d-51*t44*t46*t77-1.85122213
     4           26773132d-51*t44*t75*t76-3.2910615692041123d-51*t45*t46
     5           *t74-8.4375d-1*t17*t45**3/t18**3.5d+0
              fnc(iq) = (-9.305257363490997d-1*t15*t28-9.305257363490997
     1           d-1*t15-9.305257363490997d-1*t1*t14-9.305257363490997d-
     2           1*t1)*wght+fnc(iq)
              Amat(iq,D1_RA) = (-7.481426920246762d-1*t1*t30*t39-1.24070
     1           09817987995d+0*t14*t29-1.2407009817987995d+0*t29)*wght+
     2           Amat(iq,D1_RA)
              Amat(iq,D1_RB) = (-7.481426920246762d-1*t15*t41*t50-1.2407
     1           009817987995d+0*t28*t40-1.2407009817987995d+0*t40)*wght
     2           +Amat(iq,D1_RB)
              Cmat(iq,D1_GAA) = Cmat(iq,D1_GAA)
              Cmat(iq,D1_GAB) = Cmat(iq,D1_GAB)
              Cmat(iq,D1_GBB) = Cmat(iq,D1_GBB)
              Mmat(iq,D1_TA) = Mmat(iq,D1_TA)
              Mmat(iq,D1_TB) = Mmat(iq,D1_TB)
              Amat2(iq,D2_RA_RA) = (t30*t66+1.4962853840493523d+0*t1*t53
     1           *t54+t51*t52)*wght+Amat2(iq,D2_RA_RA)
              Amat2(iq,D2_RA_RB) = Amat2(iq,D2_RA_RB)
              Amat2(iq,D2_RB_RB) = (t41*t82+1.4962853840493523d+0*t15*t6
     1           9*t70+t67*t68)*wght+Amat2(iq,D2_RB_RB)
              Cmat2(iq,D2_RA_GAA) = Cmat2(iq,D2_RA_GAA)
              Cmat2(iq,D2_RA_GAB) = Cmat2(iq,D2_RA_GAB)
              Cmat2(iq,D2_RA_GBB) = Cmat2(iq,D2_RA_GBB)
              Cmat2(iq,D2_RB_GAA) = Cmat2(iq,D2_RB_GAA)
              Cmat2(iq,D2_RB_GAB) = Cmat2(iq,D2_RB_GAB)
              Cmat2(iq,D2_RB_GBB) = Cmat2(iq,D2_RB_GBB)
              Cmat2(iq,D2_GAA_GAA) = Cmat2(iq,D2_GAA_GAA)
              Cmat2(iq,D2_GAA_GAB) = Cmat2(iq,D2_GAA_GAB)
              Cmat2(iq,D2_GAA_GBB) = Cmat2(iq,D2_GAA_GBB)
              Cmat2(iq,D2_GAB_GAB) = Cmat2(iq,D2_GAB_GAB)
              Cmat2(iq,D2_GAB_GBB) = Cmat2(iq,D2_GAB_GBB)
              Cmat2(iq,D2_GBB_GBB) = Cmat2(iq,D2_GBB_GBB)
              Mmat2(iq,D2_RA_TA) = Mmat2(iq,D2_RA_TA)
              Mmat2(iq,D2_RA_TB) = Mmat2(iq,D2_RA_TB)
              Mmat2(iq,D2_RB_TA) = Mmat2(iq,D2_RB_TA)
              Mmat2(iq,D2_RB_TB) = Mmat2(iq,D2_RB_TB)
              Mmat2(iq,D2_GAA_TA) = Mmat2(iq,D2_GAA_TA)
              Mmat2(iq,D2_GAA_TB) = Mmat2(iq,D2_GAA_TB)
              Mmat2(iq,D2_GAB_TA) = Mmat2(iq,D2_GAB_TA)
              Mmat2(iq,D2_GAB_TB) = Mmat2(iq,D2_GAB_TB)
              Mmat2(iq,D2_GBB_TA) = Mmat2(iq,D2_GBB_TA)
              Mmat2(iq,D2_GBB_TB) = Mmat2(iq,D2_GBB_TB)
              Mmat2(iq,D2_TA_TA) = Mmat2(iq,D2_TA_TA)
              Mmat2(iq,D2_TA_TB) = Mmat2(iq,D2_TA_TB)
              Mmat2(iq,D2_TB_TB) = Mmat2(iq,D2_TB_TB)
              Amat3(iq,D3_RA_RA_RA) = (t30*(-7.481426920246762d-1*t1*(1.
     1           2437810945273631d+0*t12*(-1.802469135802469d-1*t86*t9+1
     2           .4419753086419754d-1*t6*t86-4.054699302117567d-51*t85+1
     3           .5039708610407437d-102*t32*t6*t84-6.327111529452114d-10
     4           3*t84-2.020437778557039d-152*t83+2.544728011477048d-308
     5           *t6/(rhoa**13*t8**2.5d+0)+4.3259259259259264d-1*t36*t62
     6           +1.9522698676971195d-103*t31*t32*t62-3.054307146912473d
     7           -205*t55*t6/rhoa**9.666666666666666d+0-8.45983609335418
     8           4d-103*t32*t36*t57+7.048401108259554d-206*t36*t55*t56)+
     9           3.308002246474507d-50*t10*t38*t85-1.1043037857229297d-1
     :           00*t10*t64*t84+7.509486683825926d-152*t10*t83/t11**5.0d
     ;           +0+4.1411391964609867d-101*t37*t57*t64+1.01495523471376
     <           91d-50*t33*t38*t63-2.706547292570051d-50*t37*t38*t58)-2
     =           .9925707680987046d+0*t29*t65-6.650157262441565d-1*t39*t
     >           52)+t53*(-2*t39*t66+2.9925707680987046d+0*t1*t39*t65+1.
     ?           9950471787324697d+0*t29*t54)-3.325078631220783d-1*t30*t
     @           39*t52-6.666666666666666d-1*t2*t51-4.488856152148057d+0
     1           *t1*t39**3/t13**4)*wght+Amat3(iq,D3_RA_RA_RA)
              Amat3(iq,D3_RA_RA_RB) = Amat3(iq,D3_RA_RA_RB)
              Amat3(iq,D3_RA_RB_RB) = Amat3(iq,D3_RA_RB_RB)
              Amat3(iq,D3_RB_RB_RB) = (t41*(-7.481426920246762d-1*t15*(1
     1           .2437810945273631d+0*t26*(-1.802469135802469d-1*t23*t90
     2           +1.4419753086419754d-1*t20*t90-4.054699302117567d-51*t8
     3           9+1.5039708610407437d-102*t20*t43*t88-6.327111529452114
     4           d-103*t88-2.020437778557039d-152*t87+4.3259259259259264
     5           d-1*t47*t78+1.9522698676971195d-103*t42*t43*t78-8.45983
     6           6093354184d-103*t43*t47*t73+7.048401108259554d-206*t47*
     7           t71*t72-3.054307146912473d-205*t20*t71/rhob**9.66666666
     8           6666666d+0+2.544728011477048d-308*t20/(rhob**13*t22**2.
     9           5d+0))+3.308002246474507d-50*t24*t49*t89-1.104303785722
     :           9297d-100*t24*t80*t88+7.509486683825926d-152*t24*t87/t2
     ;           5**5.0d+0+4.1411391964609867d-101*t48*t73*t80+1.0149552
     <           347137691d-50*t44*t49*t79-2.706547292570051d-50*t48*t49
     =           *t74)-2.9925707680987046d+0*t40*t81-6.650157262441565d-
     >           1*t50*t68)+t69*(-2*t50*t82+2.9925707680987046d+0*t15*t5
     ?           0*t81+1.9950471787324697d+0*t40*t70)-3.325078631220783d
     @           -1*t41*t50*t68-6.666666666666666d-1*t16*t67-4.488856152
     1           148057d+0*t15*t50**3/t27**4)*wght+Amat3(iq,D3_RB_RB_RB)
              Cmat3(iq,D3_RA_RA_GAA) = Cmat3(iq,D3_RA_RA_GAA)
              Cmat3(iq,D3_RA_RA_GAB) = Cmat3(iq,D3_RA_RA_GAB)
              Cmat3(iq,D3_RA_RA_GBB) = Cmat3(iq,D3_RA_RA_GBB)
              Cmat3(iq,D3_RA_RB_GAA) = Cmat3(iq,D3_RA_RB_GAA)
              Cmat3(iq,D3_RA_RB_GAB) = Cmat3(iq,D3_RA_RB_GAB)
              Cmat3(iq,D3_RA_RB_GBB) = Cmat3(iq,D3_RA_RB_GBB)
              Cmat3(iq,D3_RB_RB_GAA) = Cmat3(iq,D3_RB_RB_GAA)
              Cmat3(iq,D3_RB_RB_GAB) = Cmat3(iq,D3_RB_RB_GAB)
              Cmat3(iq,D3_RB_RB_GBB) = Cmat3(iq,D3_RB_RB_GBB)
              Cmat3(iq,D3_RA_GAA_GAA) = Cmat3(iq,D3_RA_GAA_GAA)
              Cmat3(iq,D3_RA_GAA_GAB) = Cmat3(iq,D3_RA_GAA_GAB)
              Cmat3(iq,D3_RA_GAA_GBB) = Cmat3(iq,D3_RA_GAA_GBB)
              Cmat3(iq,D3_RA_GAB_GAB) = Cmat3(iq,D3_RA_GAB_GAB)
              Cmat3(iq,D3_RA_GAB_GBB) = Cmat3(iq,D3_RA_GAB_GBB)
              Cmat3(iq,D3_RA_GBB_GBB) = Cmat3(iq,D3_RA_GBB_GBB)
              Cmat3(iq,D3_RB_GAA_GAA) = Cmat3(iq,D3_RB_GAA_GAA)
              Cmat3(iq,D3_RB_GAA_GAB) = Cmat3(iq,D3_RB_GAA_GAB)
              Cmat3(iq,D3_RB_GAA_GBB) = Cmat3(iq,D3_RB_GAA_GBB)
              Cmat3(iq,D3_RB_GAB_GAB) = Cmat3(iq,D3_RB_GAB_GAB)
              Cmat3(iq,D3_RB_GAB_GBB) = Cmat3(iq,D3_RB_GAB_GBB)
              Cmat3(iq,D3_RB_GBB_GBB) = Cmat3(iq,D3_RB_GBB_GBB)
              Cmat3(iq,D3_GAA_GAA_GAA) = Cmat3(iq,D3_GAA_GAA_GAA)
              Cmat3(iq,D3_GAA_GAA_GAB) = Cmat3(iq,D3_GAA_GAA_GAB)
              Cmat3(iq,D3_GAA_GAA_GBB) = Cmat3(iq,D3_GAA_GAA_GBB)
              Cmat3(iq,D3_GAA_GAB_GAB) = Cmat3(iq,D3_GAA_GAB_GAB)
              Cmat3(iq,D3_GAA_GAB_GBB) = Cmat3(iq,D3_GAA_GAB_GBB)
              Cmat3(iq,D3_GAA_GBB_GBB) = Cmat3(iq,D3_GAA_GBB_GBB)
              Cmat3(iq,D3_GAB_GAB_GAB) = Cmat3(iq,D3_GAB_GAB_GAB)
              Cmat3(iq,D3_GAB_GAB_GBB) = Cmat3(iq,D3_GAB_GAB_GBB)
              Cmat3(iq,D3_GAB_GBB_GBB) = Cmat3(iq,D3_GAB_GBB_GBB)
              Cmat3(iq,D3_GBB_GBB_GBB) = Cmat3(iq,D3_GBB_GBB_GBB)
              Mmat3(iq,D3_RA_RA_TA) = Mmat3(iq,D3_RA_RA_TA)
              Mmat3(iq,D3_RA_RA_TB) = Mmat3(iq,D3_RA_RA_TB)
              Mmat3(iq,D3_RA_RB_TA) = Mmat3(iq,D3_RA_RB_TA)
              Mmat3(iq,D3_RA_RB_TB) = Mmat3(iq,D3_RA_RB_TB)
              Mmat3(iq,D3_RB_RB_TA) = Mmat3(iq,D3_RB_RB_TA)
              Mmat3(iq,D3_RB_RB_TB) = Mmat3(iq,D3_RB_RB_TB)
              Mmat3(iq,D3_RA_GAA_TA) = Mmat3(iq,D3_RA_GAA_TA)
              Mmat3(iq,D3_RA_GAA_TB) = Mmat3(iq,D3_RA_GAA_TB)
              Mmat3(iq,D3_RA_GAB_TA) = Mmat3(iq,D3_RA_GAB_TA)
              Mmat3(iq,D3_RA_GAB_TB) = Mmat3(iq,D3_RA_GAB_TB)
              Mmat3(iq,D3_RA_GBB_TA) = Mmat3(iq,D3_RA_GBB_TA)
              Mmat3(iq,D3_RA_GBB_TB) = Mmat3(iq,D3_RA_GBB_TB)
              Mmat3(iq,D3_RB_GAA_TA) = Mmat3(iq,D3_RB_GAA_TA)
              Mmat3(iq,D3_RB_GAA_TB) = Mmat3(iq,D3_RB_GAA_TB)
              Mmat3(iq,D3_RB_GAB_TA) = Mmat3(iq,D3_RB_GAB_TA)
              Mmat3(iq,D3_RB_GAB_TB) = Mmat3(iq,D3_RB_GAB_TB)
              Mmat3(iq,D3_RB_GBB_TA) = Mmat3(iq,D3_RB_GBB_TA)
              Mmat3(iq,D3_RB_GBB_TB) = Mmat3(iq,D3_RB_GBB_TB)
              Mmat3(iq,D3_RA_TA_TA) = Mmat3(iq,D3_RA_TA_TA)
              Mmat3(iq,D3_RA_TA_TB) = Mmat3(iq,D3_RA_TA_TB)
              Mmat3(iq,D3_RA_TB_TB) = Mmat3(iq,D3_RA_TB_TB)
              Mmat3(iq,D3_RB_TA_TA) = Mmat3(iq,D3_RB_TA_TA)
              Mmat3(iq,D3_RB_TA_TB) = Mmat3(iq,D3_RB_TA_TB)
              Mmat3(iq,D3_RB_TB_TB) = Mmat3(iq,D3_RB_TB_TB)
              Mmat3(iq,D3_GAA_GAA_TA) = Mmat3(iq,D3_GAA_GAA_TA)
              Mmat3(iq,D3_GAA_GAA_TB) = Mmat3(iq,D3_GAA_GAA_TB)
              Mmat3(iq,D3_GAA_GAB_TA) = Mmat3(iq,D3_GAA_GAB_TA)
              Mmat3(iq,D3_GAA_GAB_TB) = Mmat3(iq,D3_GAA_GAB_TB)
              Mmat3(iq,D3_GAA_GBB_TA) = Mmat3(iq,D3_GAA_GBB_TA)
              Mmat3(iq,D3_GAA_GBB_TB) = Mmat3(iq,D3_GAA_GBB_TB)
              Mmat3(iq,D3_GAB_GAB_TA) = Mmat3(iq,D3_GAB_GAB_TA)
              Mmat3(iq,D3_GAB_GAB_TB) = Mmat3(iq,D3_GAB_GAB_TB)
              Mmat3(iq,D3_GAB_GBB_TA) = Mmat3(iq,D3_GAB_GBB_TA)
              Mmat3(iq,D3_GAB_GBB_TB) = Mmat3(iq,D3_GAB_GBB_TB)
              Mmat3(iq,D3_GBB_GBB_TA) = Mmat3(iq,D3_GBB_GBB_TA)
              Mmat3(iq,D3_GBB_GBB_TB) = Mmat3(iq,D3_GBB_GBB_TB)
              Mmat3(iq,D3_GAA_TA_TA) = Mmat3(iq,D3_GAA_TA_TA)
              Mmat3(iq,D3_GAA_TA_TB) = Mmat3(iq,D3_GAA_TA_TB)
              Mmat3(iq,D3_GAA_TB_TB) = Mmat3(iq,D3_GAA_TB_TB)
              Mmat3(iq,D3_GAB_TA_TA) = Mmat3(iq,D3_GAB_TA_TA)
              Mmat3(iq,D3_GAB_TA_TB) = Mmat3(iq,D3_GAB_TA_TB)
              Mmat3(iq,D3_GAB_TB_TB) = Mmat3(iq,D3_GAB_TB_TB)
              Mmat3(iq,D3_GBB_TA_TA) = Mmat3(iq,D3_GBB_TA_TA)
            endif 
          elseif (rhoa.gt.tol_rho.and.rhob.le.tol_rho) then 
            if (taua.gt.tol_rho.and.taub.gt.tol_rho) then 
              t1 = rhoa**1.3333333333333333d+0
              t2 = 1/rhoa**2.6666666666666666d+0
              t3 = 2.040060021774676d-2*gammaaa*t2+1.0d+0
              t4 = 1/t3**2.0d+0
              t5 = gammaaa**3
              t6 = 1/rhoa**8
              t7 = gammaaa**2
              t8 = 1/rhoa**5.333333333333333d+0
              t9 = 1/rhoa
              t10 = 1/taua
              t11 = gammaaa*t10*t9
              t12 = t11**2.0d+0
              t13 = 1.5625d-2*t12+1.0d+0
              t14 = 1/t13**2.0d+0
              t15 = 2.485875d-2*t12*t14+1.234567901234568d-1
              t16 = 1.35388578153653d-4*t7*t8+2.8125d-3*t12
              t17 = t16**5.0d-1
              t18 = 1/rhoa**1.6666666666666669d+0
              t19 = 2.0d+0*taua-2.5d-1*gammaaa*t9
              t20 = 1.0970205230680374d-1*t18*t19-1.0d+0
              t21 = 4.38808209227215d-2*t18*t19*t20+1.0d+0
              t22 = 1/t21**5.0d-1
              t23 = 4.5d-1*t20*t22+1.0970205230680376d-2*gammaaa*t2
              t24 = 5.133173416322327d-6*t7*t8+1.5033019185692253d-6*t5*
     1           t6+7.209876543209877d-2*t23**2-1.802469135802469d-1*t17
     2           *t23+1.6455307846020564d-2*gammaaa*t15*t2+1.72188616792
     3           99946d-3*t12
              t25 = 1.2437810945273631d+0*t24*t4+1.0d+0
              t26 = 8.04d-1-8.04d-1/t25
              t27 = rhoa**3.333333333333333d-1
              t28 = 1/t25**2
              t29 = 1/rhoa**9
              t30 = 1/rhoa**6.333333333333333d+0
              t31 = 1/rhoa**3.6666666666666664d+0
              t32 = 1/rhoa**3
              t33 = 1/taua**2
              t34 = 1/rhoa**2
              t35 = 1/t13**3.0d+0
              t36 = t11**3.0d+0
              t37 = 1.553671875d-3*gammaaa*t10*t34*t35*t36-4.97175d-2*t1
     1           4*t32*t33*t7
              t38 = 2.7425513076700936d-2*gammaaa*t31-1.828367538446729d
     1           -1*t19*t2
              t39 = 4.38808209227215d-2*t18*t19*t38+1.0970205230680374d-
     1           2*gammaaa*t20*t31-7.313470153786916d-2*t19*t2*t20
              t40 = 1/t21**1.5d+0
              t41 = -2.25d-1*t20*t39*t40+4.5d-1*t22*t38-2.92538806151476
     1           7d-2*gammaaa*t31
              t42 = 1/t17
              t43 = -5.625d-3*t32*t33*t7-7.220724168194825d-4*t30*t7
              t44 = -3.443772335859989d-3*t32*t33*t7-2.737692488705241d-
     1           5*t30*t7-1.2026415348553804d-5*t29*t5-9.012345679012345
     2           d-2*t23*t42*t43+1.4419753086419754d-1*t23*t41-1.8024691
     3           35802469d-1*t17*t41+1.6455307846020564d-2*gammaaa*t2*t3
     4           7-4.3880820922721503d-2*gammaaa*t15*t31
              t45 = 1/t3**3.0d+0
              t46 = 1.3532736462850253d-1*gammaaa*t24*t31*t45+1.24378109
     1           45273631d+0*t4*t44
              t47 = 4.97175d-2*gammaaa*t14*t33*t34-1.553671875d-3*t10*t3
     1           5*t36*t9
              t48 = 1/rhoa**4.333333333333333d+0
              t49 = -1.2034540280324706d-3*t19*t48-1.0970205230680374d-2
     1           *t2*t20
              t50 = -2.25d-1*t20*t40*t49-1.2341480884515421d-2*t2*t22+1.
     1           0970205230680376d-2*t2
              t51 = 2.70777156307306d-4*gammaaa*t8+5.625d-3*gammaaa*t33*
     1           t34
              t52 = 1.0266346832644656d-5*gammaaa*t8+4.509905755707676d-
     1           6*t6*t7-9.012345679012345d-2*t23*t42*t51+1.441975308641
     2           9754d-1*t23*t50-1.802469135802469d-1*t17*t50+1.64553078
     3           46020564d-2*gammaaa*t2*t47+3.443772335859989d-3*gammaaa
     4           *t33*t34+1.6455307846020564d-2*t15*t2
              t53 = 1.2437810945273631d+0*t4*t52-5.074776173568845d-2*t2
     1           *t24*t45
              t54 = 1/taua**3
              t55 = 1.553671875d-3*gammaaa*t33*t35*t36*t9-4.97175d-2*t14
     1           *t34*t54*t7
              t56 = 1/rhoa**3.3333333333333337d+0
              t57 = 9.627632224259765d-3*t19*t56+8.7761641845443d-2*t18*
     1           t20
              t58 = 9.873184707612337d-2*t18*t22-2.25d-1*t20*t40*t57
              t59 = 5.069444444444443d-4*t23*t34*t42*t54*t7-3.4437723358
     1           59989d-3*t34*t54*t7+1.4419753086419754d-1*t23*t58-1.802
     2           469135802469d-1*t17*t58+1.6455307846020564d-2*gammaaa*t
     3           2*t55
              t60 = 1/rhoa**10
              t61 = 1/rhoa**7.333333333333333d+0
              t62 = 1/rhoa**4.666666666666667d+0
              t63 = 1/rhoa**4
              t64 = gammaaa**4
              t65 = 1/rhoa**6
              t66 = 1/taua**4
              t67 = 1/t13**4.0d+0
              t68 = t11**4.0d+0
              t69 = 1.4565673828125d-4*t33*t63*t67*t68*t7-4.661015624999
     1           9996d-3*t12*t33*t35*t63*t7+1.491525d-1*t14*t33*t63*t7-3
     2           .10734375d-3*t35*t64*t65*t66-3.10734375d-3*gammaaa*t10*
     3           t32*t35*t36
              t70 = t39**2
              t71 = 1/t21**2.5d+0
              t72 = 4.8756467691912775d-1*t19*t31-1.4626940307573832d-1*
     1           gammaaa*t62
              t73 = 4.38808209227215d-2*t18*t19*t72-5.850776123029533d-2
     1           *gammaaa*t20*t62+2.194041046136075d-2*gammaaa*t31*t38-1
     2           .4626940307573832d-1*t19*t2*t38+1.950258707676511d-1*t1
     3           9*t20*t31
              t74 = -2.25d-1*t20*t40*t73+4.5d-1*t22*t72+3.375d-1*t20*t70
     1           *t71+1.0726422892220812d-1*gammaaa*t62-4.5d-1*t38*t39*t
     2           40
              t75 = 1/t16**1.5d+0
              t76 = t43**2
              t77 = 1.6875d-2*t33*t63*t7+4.573125306523389d-3*t61*t7
              t78 = -9.012345679012345d-2*t23*t42*t77+4.5061728395061723
     1           d-2*t23*t75*t76+1.4419753086419754d-1*t23*t74-1.8024691
     2           35802469d-1*t17*t74+1.0331317007579968d-2*t33*t63*t7+1.
     3           7338719095133195d-4*t61*t7+1.6455307846020564d-2*gammaa
     4           a*t2*t69+1.6089634338331218d-1*gammaaa*t15*t62+1.082377
     5           3813698423d-4*t5*t60-1.802469135802469d-1*t41*t42*t43+1
     6           .4419753086419754d-1*t41**2-8.776164184544301d-2*gammaa
     7           a*t31*t37
              t79 = 1/t3**4.0d+0
              t80 = 2.208607571445859d-2*t24*t61*t7*t79+1.24378109452736
     1           31d+0*t4*t78-4.9620033697117594d-1*gammaaa*t24*t45*t62+
     2           2.7065472925700507d-1*gammaaa*t31*t44*t45
              t81 = -7.481426920246762d-1*t1*t80-1.9950471787324697d+0*t
     1           27*t46
              t82 = 1/rhoa**6.666666666666666d-1
              t83 = -4.1356699393293317d-1*t26-4.1356699393293317d-1
              t84 = 1/t25**3
              t85 = t46**2
              t86 = 1/rhoa**5
              t87 = 3.10734375d-3*t35*t5*t66*t86-1.4565673828125d-4*gamm
     1           aaa*t32*t33*t67*t68+1.553671875d-3*t10*t34*t35*t36+4.66
     2           10156249999996d-3*gammaaa*t12*t32*t33*t35-9.9435d-2*gam
     3           maaa*t14*t32*t33
              t88 = 5.214967454807371d-3*t19*t8-1.0970205230680374d-2*t2
     1           *t38+2.9253880615147665d-2*t20*t31-3.0086350700811765d-
     2           4*gammaaa*t30
              t89 = -2.25d-1*t20*t40*t88+3.375d-1*t20*t39*t49*t71-2.25d-
     1           1*t38*t40*t49+6.170740442257711d-3*t2*t39*t40+3.2910615
     2           692041123d-2*t22*t31-2.925388061514767d-2*t31
              t90 = -1.1249999999999999d-2*gammaaa*t32*t33-1.44414483363
     1           8965d-3*gammaaa*t30
              t91 = -9.012345679012345d-2*t23*t42*t90+1.4419753086419754
     1           d-1*t23*t89-1.802469135802469d-1*t17*t89+1.645530784602
     2           0564d-2*gammaaa*t2*t87+4.5061728395061723d-2*t23*t43*t5
     3           1*t75-3.607924604566141d-5*t29*t7-9.012345679012345d-2*
     4           t41*t42*t51-9.012345679012345d-2*t42*t43*t50+1.44197530
     5           86419754d-1*t41*t50-4.3880820922721503d-2*gammaaa*t31*t
     6           47+1.6455307846020564d-2*t2*t37-6.887544671719978d-3*ga
     7           mmaaa*t32*t33-4.3880820922721503d-2*t15*t31-5.475384977
     8           410482d-5*gammaaa*t30
              t92 = 1.2437810945273631d+0*t4*t91-8.282278392921971d-3*ga
     1           mmaaa*t24*t30*t79+1.3532736462850253d-1*gammaaa*t31*t45
     2           *t52-5.074776173568845d-2*t2*t44*t45+1.3532736462850253
     3           d-1*t24*t31*t45
              t93 = -7.481426920246762d-1*t1*t92-9.975235893662349d-1*t2
     1           7*t53
              t94 = -3.10734375d-3*t35*t63*t66*t7+1.4565673828125d-4*t33
     1           *t34*t67*t68-4.6610156249999996d-3*t12*t33*t34*t35+4.97
     2           175d-2*t14*t33*t34
              t95 = t49**2
              t96 = 3.375d-1*t20*t71*t95-1.3538857815365296d-4*t20*t40*t
     1           8+1.2341480884515421d-2*t2*t40*t49
              t97 = t51**2
              t98 = 2.70777156307306d-4*t8+5.625d-3*t33*t34
              t99 = -9.012345679012345d-2*t23*t42*t98+4.5061728395061723
     1           d-2*t23*t75*t97+1.4419753086419754d-1*t23*t96-1.8024691
     2           35802469d-1*t17*t96+1.6455307846020564d-2*gammaaa*t2*t9
     3           4+1.0266346832644656d-5*t8+9.019811511415352d-6*gammaaa
     4           *t6-1.802469135802469d-1*t42*t50*t51+1.4419753086419754
     5           d-1*t50**2+3.291061569204113d-2*t2*t47+3.44377233585998
     6           9d-3*t33*t34
              t100 = 1.2437810945273631d+0*t4*t99+3.10585439734574d-3*t2
     1           4*t79*t8-1.014955234713769d-1*t2*t45*t52
              t101 = t53**2
              t102 = 1/taua**5
              t103 = -3.10734375d-3*t102*t35*t64*t86+1.4565673828125d-4*
     1           t32*t54*t67*t68*t7-4.6610156249999996d-3*t12*t32*t35*t5
     2           4*t7+9.9435d-2*t14*t32*t54*t7-1.553671875d-3*gammaaa*t3
     3           3*t34*t35*t36
              t104 = 2.406908056064941d-3*gammaaa*t8-3.209210741419921d-
     1           2*t19*t48+8.7761641845443d-2*t18*t38-1.4626940307573832
     2           d-1*t2*t20
              t105 = 3.375d-1*t20*t39*t57*t71-2.25d-1*t38*t40*t57-4.9365
     1           923538061685d-2*t18*t39*t40-2.25d-1*t104*t20*t40-1.6455
     2           307846020562d-1*t2*t22
              t106 = -2.5347222222222215d-4*t23*t34*t43*t54*t7*t75+5.069
     1           444444444443d-4*t34*t41*t42*t54*t7-1.0138888888888886d-
     2           3*t23*t32*t42*t54*t7+6.887544671719978d-3*t32*t54*t7-9.
     3           012345679012345d-2*t42*t43*t58+1.4419753086419754d-1*t4
     4           1*t58-4.3880820922721503d-2*gammaaa*t31*t55+1.441975308
     5           6419754d-1*t105*t23+1.6455307846020564d-2*gammaaa*t103*
     6           t2-1.802469135802469d-1*t105*t17
              t107 = 1.3532736462850253d-1*gammaaa*t31*t45*t59+1.2437810
     1           945273631d+0*t106*t4
              t108 = 1.553671875d-3*t33*t35*t36*t9-1.4565673828125d-4*ga
     1           mmaaa*t34*t54*t67*t68+3.10734375d-3*t102*t35*t5*t63+4.6
     2           610156249999996d-3*gammaaa*t12*t34*t35*t54-9.9435d-2*ga
     3           mmaaa*t14*t34*t54
              t109 = 3.375d-1*t20*t49*t57*t71+6.170740442257711d-3*t2*t4
     1           0*t57-4.9365923538061685d-2*t18*t40*t49+1.0831086252292
     2           235d-3*t20*t40*t48
              t110 = -2.5347222222222215d-4*t23*t34*t51*t54*t7*t75+5.069
     1           444444444443d-4*t34*t42*t50*t54*t7-9.012345679012345d-2
     2           *t42*t51*t58+1.4419753086419754d-1*t50*t58+1.6455307846
     3           020564d-2*t2*t55+1.0138888888888886d-3*gammaaa*t23*t34*
     4           t42*t54-6.887544671719978d-3*gammaaa*t34*t54+1.44197530
     5           86419754d-1*t109*t23+1.6455307846020564d-2*gammaaa*t108
     6           *t2-1.802469135802469d-1*t109*t17
              t111 = 1.2437810945273631d+0*t110*t4-5.074776173568845d-2*
     1           t2*t45*t59
              t112 = t59**2
              t113 = 1/taua**6
              t114 = -3.10734375d-3*gammaaa*t35*t36*t54*t9+1.45656738281
     1           25d-4*t34*t66*t67*t68*t7-4.6610156249999996d-3*t12*t34*
     2           t35*t66*t7+1.491525d-1*t14*t34*t66*t7-3.10734375d-3*t11
     3           3*t35*t63*t64
              t115 = t57**2
              t116 = 3.375d-1*t115*t20*t71-9.873184707612337d-2*t18*t40*
     1           t57-8.664869001833788d-3*t20*t40*t56
              t117 = 1.4257812499999994d-6*t113*t23*t63*t64*t75-1.520833
     1           333333333d-3*t23*t34*t42*t66*t7+1.0331317007579968d-2*t
     2           34*t66*t7+1.0138888888888886d-3*t34*t42*t54*t58*t7+1.44
     3           19753086419754d-1*t58**2+1.4419753086419754d-1*t116*t23
     4           +1.6455307846020564d-2*gammaaa*t114*t2-1.80246913580246
     5           9d-1*t116*t17
              t118 = 1/rhoa**11
              t119 = 1/rhoa**8.333333333333334d+0
              t120 = 1/rhoa**5.666666666666667d+0
              t121 = gammaaa**6
              t122 = 1/rhoa**7
              t123 = 1/t13**5.0d+0
              t124 = t11**5.0d+0
              t125 = 1/t21**3.5d+0
              t126 = 8.044817169165608d-1*gammaaa*t120-1.787737148703468
     1           2d+0*t19*t62
              t127 = 1.0125000000000002d+0*t20*t39*t71*t73-6.75d-1*t38*t
     1           40*t73-2.25d-1*t20*t40*(3.2910615692041123d-2*gammaaa*t
     2           31*t72-2.194041046136075d-1*t19*t2*t72-1.75523283690886
     3           d-1*gammaaa*t38*t62-7.150948594813873d-1*t19*t20*t62+5.
     4           850776123029533d-1*t19*t31*t38+3.217926867666243d-1*gam
     5           maaa*t120*t20+4.38808209227215d-2*t126*t18*t19)-6.75d-1
     6           *t39*t40*t72+1.0125000000000002d+0*t38*t70*t71-8.4375d-
     7           1*t125*t20*t39**3+4.5d-1*t126*t22-5.005664016369713d-1*
     8           gammaaa*t120
              t128 = 1/t16**2.5d+0
              t129 = 1/t3**5.0d+0
              t130 = 1/t25**4
              t131 = gammaaa**5
              t132 = 6.75d-1*t20*t39*t71*t88-4.5d-1*t38*t40*t88+3.375d-1
     1           *t20*t49*t71*t73+6.170740442257711d-3*t2*t40*t73-2.25d-
     2           1*t20*t40*(-1.0970205230680374d-2*t2*t72-1.072642289222
     3           081d-1*t20*t62+3.209210741419921d-3*gammaaa*t61+5.85077
     4           6123029533d-2*t31*t38-2.781315975897265d-2*t19*t30)-2.2
     5           5d-1*t40*t49*t72-9.256110663386565d-3*t2*t70*t71+6.75d-
     6           1*t38*t39*t49*t71-8.4375d-1*t125*t20*t49*t70-1.20672257
     7           53748412d-1*t22*t62+1.0726422892220812d-1*t62-3.2910615
     8           692041123d-2*t31*t39*t40
              t133 = 3.375d-1*t38*t71*t95-8.4375d-1*t125*t20*t39*t95+6.7
     1           5d-1*t20*t49*t71*t88+1.2341480884515421d-2*t2*t40*t88+2
     2           .030828672304794d-4*t20*t39*t71*t8-1.3538857815365296d-
     3           4*t38*t40*t8-1.8512221326773132d-2*t2*t39*t49*t71-3.291
     4           0615692041123d-2*t31*t40*t49+7.220724168194822d-4*t20*t
     5           30*t40
              t134 = -2.77683319901597d-2*t2*t71*t95+6.092486016914382d-
     1           4*t20*t49*t71*t8+1.1139303661766865d-5*t40*t6-8.4375d-1
     2           *t125*t20*t49**3
              t135 = 1/taua**7
              t136 = -2.25d-1*t20*t40*(1.3906579879486325d-1*t19*t8+8.77
     1           61641845443d-2*t18*t72-2.9253880615147665d-1*t2*t38+3.9
     2           00517415353022d-1*t20*t31-2.0859869819229487d-2*gammaaa
     3           *t30)+3.375d-1*t20*t57*t71*t73-4.9365923538061685d-2*t1
     4           8*t40*t73-2.25d-1*t40*t57*t72+7.404888530709253d-2*t18*
     5           t70*t71+6.75d-1*t38*t39*t57*t71+6.75d-1*t104*t20*t39*t7
     6           1-8.4375d-1*t125*t20*t57*t70+1.6455307846020562d-1*t2*t
     7           39*t40-4.5d-1*t104*t38*t40+4.38808209227215d-1*t22*t31
              t137 = 3.375d-1*t20*t57*t71*t88-4.9365923538061685d-2*t18*
     1           t40*t88-4.693470709326635d-3*t20*t40*t8+3.375d-1*t38*t4
     2           9*t57*t71-9.256110663386565d-3*t2*t39*t57*t71+7.4048885
     3           30709253d-2*t18*t39*t49*t71+3.375d-1*t104*t20*t49*t71-1
     4           .6246629378438354d-3*t20*t39*t48*t71-8.4375d-1*t125*t20
     5           *t39*t49*t57-1.6455307846020562d-2*t31*t40*t57+8.227653
     6           923010281d-2*t2*t40*t49+1.0831086252292235d-3*t38*t40*t
     7           48+6.170740442257711d-3*t104*t2*t40
              t138 = 7.404888530709253d-2*t18*t71*t95-8.4375d-1*t125*t20
     1           *t57*t95+2.030828672304794d-4*t20*t57*t71*t8-1.85122213
     2           26773132d-2*t2*t49*t57*t71-3.249325875687671d-3*t20*t48
     3           *t49*t71-8.911442929413492d-5*t122*t40
              t139 = 1/taua**8
              t140 = 1.4809777061418505d-1*t18*t39*t57*t71+6.75d-1*t104*
     1           t20*t57*t71+1.2997303502750684d-2*t20*t39*t56*t71+3.375
     2           d-1*t115*t38*t71+1.6455307846020562d-1*t2*t40*t57-8.664
     3           869001833788d-3*t38*t40*t56+2.888289667277929d-2*t20*t4
     4           0*t48-9.873184707612337d-2*t104*t18*t40-8.4375d-1*t115*
     5           t125*t20*t39
              t141 = 1.4809777061418505d-1*t18*t49*t57*t71-3.24932587568
     1           7671d-3*t20*t48*t57*t71+1.2997303502750684d-2*t20*t49*t
     2           56*t71-9.256110663386565d-3*t115*t2*t71+7.1291543435307
     3           94d-4*t40*t65-8.4375d-1*t115*t125*t20*t49
              t142 = 1/taua**9
              t143 = -5.703323474824635d-3*t40*t86+3.899191050825205d-2*
     1           t20*t56*t57*t71+2.2214665592127758d-1*t115*t18*t71-8.43
     2           75d-1*t125*t20*t57**3
              fnc(iq) = (-9.305257363490997d-1*t1*t26-9.305257363490997d
     1           -1*t1)*wght+fnc(iq)
              Amat(iq,D1_RA) = (-7.481426920246762d-1*t1*t28*t46-1.24070
     1           09817987995d+0*t26*t27-1.2407009817987995d+0*t27)*wght+
     2           Amat(iq,D1_RA)
              Cmat(iq,D1_GAA) = Cmat(iq,D1_GAA)-7.481426920246762d-1*t1*
     1           t28*t53*wght
              Mmat(iq,D1_TA) = Mmat(iq,D1_TA)-9.305257363490997d-1*t1*t2
     1           8*t4*t59*wght
              Mmat(iq,D1_TB) = Mmat(iq,D1_TB)
              Amat2(iq,D2_RA_RA) = (1.4962853840493523d+0*t1*t84*t85+t82
     1           *t83+t28*t81)*wght+Amat2(iq,D2_RA_RA)
              Cmat2(iq,D2_RA_GAA) = (t28*t93+1.4962853840493523d+0*t1*t4
     1           6*t53*t84)*wght+Cmat2(iq,D2_RA_GAA)
              Cmat2(iq,D2_GAA_GAA) = 1.4962853840493523d+0*t1*t101*t84*w
     1           ght-7.481426920246762d-1*t1*t100*t28*wght+Cmat2(iq,D2_G
     2           AA_GAA)
              Mmat2(iq,D2_RA_TA) = (1.8610514726981991d+0*t1*t4*t46*t59*
     1           t84-1.2407009817987995d+0*t27*t28*t4*t59-7.481426920246
     2           762d-1*t1*t107*t28)*wght+Mmat2(iq,D2_RA_TA)
              Mmat2(iq,D2_RA_TB) = Mmat2(iq,D2_RA_TB)
              Mmat2(iq,D2_GAA_TA) = 1.8610514726981991d+0*t1*t4*t53*t59*
     1           t84*wght-7.481426920246762d-1*t1*t111*t28*wght+Mmat2(iq
     2           ,D2_GAA_TA)
              Mmat2(iq,D2_GAA_TB) = Mmat2(iq,D2_GAA_TB)
              Mmat2(iq,D2_TA_TA) = 2.3147406376843277d+0*t1*t112*t79*t84
     1           *wght-9.305257363490997d-1*t1*t117*t28*t4*wght+Mmat2(iq
     2           ,D2_TA_TA)
              Mmat2(iq,D2_TA_TB) = Mmat2(iq,D2_TA_TB)
              Mmat2(iq,D2_TB_TB) = Mmat2(iq,D2_TB_TB)
              Amat3(iq,D3_RA_RA_RA) = (t28*(-7.481426920246762d-1*t1*(1.
     1           2437810945273631d+0*t4*(1.6455307846020564d-2*gammaaa*t
     2           2*(-8.739404296874999d-4*t33*t67*t68*t7*t86+2.796609375
     3           d-2*t12*t33*t35*t7*t86-5.9661d-1*t14*t33*t7*t86-1.01959
     4           71679687499d-3*t36*t5*t54*t65*t67-2.913134765625d-4*t11
     5           3*t121*t29*t67+3.7288125d-2*t122*t35*t64*t66+1.82070922
     6           85156248d-5*t123*t124*t5*t54*t65+9.322031249999999d-3*g
     7           ammaaa*t10*t35*t36*t63)-9.012345679012345d-2*t23*t42*(-
     8           6.75d-2*t33*t7*t86-3.3536252247838183d-2*t119*t7)-4.132
     9           526803031987d-2*t33*t7*t86+1.3518518518518516d-1*t23*t4
     :           3*t75*t77-2.703703703703703d-1*t41*t42*t77+1.3518518518
     ;           518516d-1*t41*t75*t76-2.703703703703703d-1*t42*t43*t74+
     <           4.3259259259259264d-1*t41*t74-1.2715060669764344d-3*t11
     =           9*t7-1.3164246276816452d-1*gammaaa*t31*t69+4.8268903014
     >           99366d-1*gammaaa*t37*t62-1.0823773813698424d-3*t118*t5-
     ?           6.759259259259258d-2*t128*t23*t43**3+1.4419753086419754
     @           d-1*t127*t23-1.802469135802469d-1*t127*t17-7.5084960245
     1           5457d-1*gammaaa*t120*t15)+6.625822714337577d-2*t44*t61*
     2           t7*t79-2.4294683285904448d-1*t119*t24*t7*t79+4.05982093
     3           8855076d-1*gammaaa*t31*t45*t78-1.4886010109135278d+0*ga
     4           mmaaa*t44*t45*t62+4.80607147764859d-3*t118*t129*t24*t5+
     5           2.3156015725321547d+0*gammaaa*t120*t24*t45)-6.650157262
     6           441565d-1*t46*t82-2.9925707680987046d+0*t27*t80)+t84*(1
     7           .9950471787324697d+0*t27*t85-2*t46*t81+2.99257076809870
     8           46d+0*t1*t46*t80)-6.666666666666666d-1*t18*t83-3.325078
     9           631220783d-1*t28*t46*t82-4.488856152148057d+0*t1*t130*t
     :           46**3)*wght+Amat3(iq,D3_RA_RA_RA)
              Cmat3(iq,D3_RA_RA_GAA) = (t84*(2.9925707680987046d+0*t1*t4
     1           6*t92-2*t53*t81)+t28*(-1.9950471787324697d+0*t27*t92-7.
     2           481426920246762d-1*t1*(2.7065472925700507d-1*gammaaa*t3
     3           1*t45*t91+1.2437810945273631d+0*t4*(9.012345679012345d-
     4           2*t23*t43*t75*t90-1.802469135802469d-1*t41*t42*t90-1.80
     5           2469135802469d-1*t42*t43*t89+2.883950617283951d-1*t41*t
     6           89-8.776164184544301d-2*gammaaa*t31*t87+1.6455307846020
     7           564d-2*gammaaa*t2*(1.0195971679687499d-3*t36*t54*t67*t7
     8           *t86-1.8207092285156248d-5*t123*t124*t54*t7*t86+5.82626
     9           953125d-4*gammaaa*t33*t63*t67*t68+2.913134765625d-4*t11
     :           3*t131*t6*t67-3.10734375d-2*t35*t5*t65*t66-1.86440625d-
     ;           2*gammaaa*t12*t33*t35*t63+2.98305d-1*gammaaa*t14*t33*t6
     <           3-3.10734375d-3*t10*t32*t35*t36)+4.5061728395061723d-2*
     =           t23*t51*t75*t77-9.012345679012345d-2*t42*t50*t77+4.5061
     >           728395061723d-2*t50*t75*t76-6.759259259259258d-2*t128*t
     ?           23*t51*t76+9.012345679012345d-2*t41*t43*t51*t75-9.01234
     @           5679012345d-2*t42*t51*t74+1.4419753086419754d-1*t50*t74
     1           +3.2471321441095274d-4*t60*t7+1.6455307846020564d-2*t2*
     2           t69-9.012345679012345d-2*t23*t42*(3.375d-2*gammaaa*t33*
     3           t63+9.146250613046778d-3*gammaaa*t61)+2.066263401515993
     4           6d-2*gammaaa*t33*t63+1.6089634338331218d-1*gammaaa*t47*
     5           t62+1.6089634338331218d-1*t15*t62+3.467743819026639d-4*
     6           gammaaa*t61-8.776164184544301d-2*t31*t37+1.441975308641
     7           9754d-1*t132*t23-1.802469135802469d-1*t132*t17)+2.20860
     8           7571445859d-2*t52*t61*t7*t79+7.454050553629774d-2*gamma
     9           aa*t24*t61*t79-1.6564556785843942d-2*gammaaa*t30*t44*t7
     :           9-5.074776173568845d-2*t2*t45*t78-1.8022768041182213d-3
     ;           *t129*t24*t60*t7-4.9620033697117594d-1*gammaaa*t45*t52*
     <           t62-4.9620033697117594d-1*t24*t45*t62+2.706547292570050
     =           7d-1*t31*t44*t45))-4.488856152148057d+0*t1*t130*t53*t85
     >           -3.325078631220783d-1*t28*t53*t82)*wght+Cmat3(iq,D3_RA_
     ?           RA_GAA)
              Cmat3(iq,D3_RA_GAA_GAA) = (t28*(-7.481426920246762d-1*t1*(
     1           1.3532736462850253d-1*gammaaa*t31*t45*t99+1.24378109452
     2           73631d+0*t4*(4.5061728395061723d-2*t23*t43*t75*t98-9.01
     3           2345679012345d-2*t41*t42*t98+4.5061728395061723d-2*t41*
     4           t75*t97-6.759259259259258d-2*t128*t23*t43*t97-9.0123456
     5           79012345d-2*t42*t43*t96+1.4419753086419754d-1*t41*t96-4
     6           .3880820922721503d-2*gammaaa*t31*t94+9.012345679012345d
     7           -2*t23*t51*t75*t90-1.802469135802469d-1*t42*t50*t90-1.8
     8           02469135802469d-1*t42*t51*t89+2.883950617283951d-1*t50*
     9           t89+3.291061569204113d-2*t2*t87+1.6455307846020564d-2*g
     :           ammaaa*t2*(2.485875d-2*t35*t66*t7*t86-2.913134765625d-4
     ;           *t32*t33*t67*t68-2.913134765625d-4*t113*t122*t64*t67-1.
     <           0195971679687499d-3*gammaaa*t36*t54*t63*t67+1.820709228
     =           5156248d-5*gammaaa*t123*t124*t54*t63+9.322031249999999d
     >           -3*t12*t32*t33*t35-9.9435d-2*t14*t32*t33)+9.01234567901
     ?           2345d-2*t43*t50*t51*t75-8.776164184544301d-2*t31*t47-9.
     @           012345679012345d-2*t23*(-1.1249999999999999d-2*t32*t33-
     1           1.444144833638965d-3*t30)*t42-6.887544671719978d-3*t32*
     2           t33-5.475384977410482d-5*t30-7.215849209132282d-5*gamma
     3           aa*t29+1.4419753086419754d-1*t133*t23-1.802469135802469
     4           d-1*t133*t17)-1.014955234713769d-1*t2*t45*t91+3.1058543
     5           9734574d-3*t44*t79*t8-1.6564556785843942d-2*gammaaa*t30
     6           *t52*t79-1.6564556785843942d-2*t24*t30*t79+2.7065472925
     7           700507d-1*t31*t45*t52+6.758538015443329d-4*gammaaa*t129
     8           *t24*t29)-9.975235893662349d-1*t100*t27)+t84*(-2*t53*t9
     9           3+1.4962853840493523d+0*t1*t53*t92+1.4962853840493523d+
     :           0*t1*t100*t46)-4.488856152148057d+0*t1*t101*t130*t46)*w
     ;           ght+Cmat3(iq,D3_RA_GAA_GAA)
              Cmat3(iq,D3_GAA_GAA_GAA) = -7.481426920246762d-1*t1*t28*(-
     1           1.5224328520706534d-1*t2*t45*t99+1.2437810945273631d+0*
     2           t4*(1.3518518518518516d-1*t23*t51*t75*t98-2.70370370370
     3           3703d-1*t42*t50*t98+1.3518518518518516d-1*t50*t75*t97-2
     4           .703703703703703d-1*t42*t51*t96+4.3259259259259264d-1*t
     5           50*t96+4.9365923538061696d-2*t2*t94+1.6455307846020564d
     6           -2*gammaaa*t2*(2.913134765625d-4*t113*t5*t65*t67+1.0195
     7           971679687499d-3*t32*t36*t54*t67-1.86440625d-2*gammaaa*t
     8           35*t63*t66-1.8207092285156248d-5*t123*t124*t32*t54)+9.0
     9           19811511415352d-6*t6-6.759259259259258d-2*t128*t23*t51*
     :           *3+1.4419753086419754d-1*t134*t23-1.802469135802469d-1*
     ;           t134*t17)+9.317563192037218d-3*t52*t79*t8-2.53445175579
     <           1249d-4*t129*t24*t6)*wght+4.488856152148057d+0*t1*t100*
     =           t53*t84*wght-4.488856152148057d+0*t1*t130*t53**3*wght+C
     >           mat3(iq,D3_GAA_GAA_GAA)
              Mmat3(iq,D3_RA_RA_TA) = (t28*(-7.481426920246762d-1*t1*(1.
     1           2437810945273631d+0*t4*(1.6455307846020564d-2*gammaaa*t
     2           2*(-1.0195971679687499d-3*t36*t5*t66*t67*t86+1.82070922
     3           85156248d-5*t123*t124*t5*t66*t86-5.82626953125d-4*t54*t
     4           63*t67*t68*t7+1.86440625d-2*t12*t35*t54*t63*t7-2.98305d
     5           -1*t14*t54*t63*t7-2.913134765625d-4*t121*t135*t6*t67+3.
     6           10734375d-2*t102*t35*t64*t65+3.10734375d-3*gammaaa*t32*
     7           t33*t35*t36)-2.5347222222222215d-4*t23*t34*t54*t7*t75*t
     8           77-9.012345679012345d-2*t42*t58*t77+4.5061728395061723d
     9           -2*t58*t75*t76+3.802083333333333d-4*t128*t23*t34*t54*t7
     :           *t76-5.069444444444443d-4*t34*t41*t43*t54*t7*t75+1.0138
     ;           888888888886d-3*t23*t32*t43*t54*t7*t75+5.06944444444444
     <           3d-4*t34*t42*t54*t7*t74+1.4419753086419754d-1*t58*t74+3
     =           .0416666666666664d-3*t23*t42*t54*t63*t7-2.0662634015159
     >           936d-2*t54*t63*t7-2.0277777777777772d-3*t32*t41*t42*t54
     ?           *t7+1.6089634338331218d-1*gammaaa*t55*t62-1.80246913580
     @           2469d-1*t105*t42*t43+2.883950617283951d-1*t105*t41-8.77
     1           6164184544301d-2*gammaaa*t103*t31+1.4419753086419754d-1
     2           *t136*t23-1.802469135802469d-1*t136*t17)+2.208607571445
     3           859d-2*t59*t61*t7*t79-4.9620033697117594d-1*gammaaa*t45
     4           *t59*t62+2.7065472925700507d-1*gammaaa*t106*t31*t45)-1.
     5           9950471787324697d+0*t107*t27)-5.583154418094598d+0*t1*t
     6           130*t4*t59*t85-2.4875621890547261d+0*t4*t59*t81*t84+2.9
     7           925707680987046d+0*t1*t107*t46*t84-4.1356699393293317d-
     8           1*t28*t4*t59*t82)*wght+Mmat3(iq,D3_RA_RA_TA)
              Mmat3(iq,D3_RA_RA_TB) = Mmat3(iq,D3_RA_RA_TB)
              Mmat3(iq,D3_RA_GAA_TA) = (-2.4875621890547261d+0*t4*t59*t8
     1           4*t93+t28*(-7.481426920246762d-1*t1*(1.2437810945273631
     2           d+0*t4*(-2.5347222222222215d-4*t23*t34*t54*t7*t75*t90-9
     3           .012345679012345d-2*t42*t58*t90+5.069444444444443d-4*t3
     4           4*t42*t54*t7*t89+1.4419753086419754d-1*t58*t89+1.645530
     5           7846020564d-2*gammaaa*t2*(-2.796609375d-2*t102*t35*t5*t
     6           86+1.0195971679687499d-3*t36*t63*t66*t67*t7-1.820709228
     7           5156248d-5*t123*t124*t63*t66*t7+4.369702148437499d-4*ga
     8           mmaaa*t32*t54*t67*t68+2.913134765625d-4*t122*t131*t135*
     9           t67-1.3983046875d-2*gammaaa*t12*t32*t35*t54+1.9887d-1*g
     :           ammaaa*t14*t32*t54-1.553671875d-3*t33*t34*t35*t36)-2.53
     ;           47222222222215d-4*t34*t41*t51*t54*t7*t75+5.069444444444
     <           443d-4*t23*t32*t51*t54*t7*t75-2.5347222222222215d-4*t34
     =           *t43*t50*t54*t7*t75+4.5061728395061723d-2*t43*t51*t58*t
     >           75-5.069444444444443d-4*gammaaa*t23*t34*t43*t54*t75+3.8
     ?           02083333333333d-4*t128*t23*t34*t43*t51*t54*t7-1.0138888
     @           888888886d-3*t32*t42*t50*t54*t7-4.3880820922721503d-2*t
     1           31*t55+1.0138888888888886d-3*gammaaa*t34*t41*t42*t54-2.
     2           0277777777777772d-3*gammaaa*t23*t32*t42*t54+1.377508934
     3           3439956d-2*gammaaa*t32*t54-9.012345679012345d-2*t105*t4
     4           2*t51+1.4419753086419754d-1*t105*t50-9.012345679012345d
     5           -2*t109*t42*t43+1.4419753086419754d-1*t109*t41-4.388082
     6           0922721503d-2*gammaaa*t108*t31+1.4419753086419754d-1*t1
     7           37*t23+1.6455307846020564d-2*t103*t2-1.802469135802469d
     8           -1*t137*t17)-8.282278392921971d-3*gammaaa*t30*t59*t79+1
     9           .3532736462850253d-1*t31*t45*t59+1.3532736462850253d-1*
     :           gammaaa*t110*t31*t45-5.074776173568845d-2*t106*t2*t45)-
     ;           9.975235893662349d-1*t111*t27)+(1.4962853840493523d+0*t
     <           1*t107*t53+1.4962853840493523d+0*t1*t111*t46)*t84-5.583
     =           154418094598d+0*t1*t130*t4*t46*t53*t59)*wght+Mmat3(iq,D
     >           3_RA_GAA_TA)
              Mmat3(iq,D3_RA_GAA_TB) = Mmat3(iq,D3_RA_GAA_TB)
              Mmat3(iq,D3_GAA_GAA_TA) = -7.481426920246762d-1*t1*t28*(1.
     1           2437810945273631d+0*t4*(-2.5347222222222215d-4*t23*t34*
     2           t54*t7*t75*t98-9.012345679012345d-2*t42*t58*t98+4.50617
     3           28395061723d-2*t58*t75*t97+3.802083333333333d-4*t128*t2
     4           3*t34*t54*t7*t97+5.069444444444443d-4*t34*t42*t54*t7*t9
     5           6+1.4419753086419754d-1*t58*t96-5.069444444444443d-4*t3
     6           4*t50*t51*t54*t7*t75-1.0138888888888886d-3*gammaaa*t23*
     7           t34*t51*t54*t75+1.6455307846020564d-2*gammaaa*t2*(2.485
     8           875d-2*t102*t35*t63*t7-2.913134765625d-4*t34*t54*t67*t6
     9           8-1.0195971679687499d-3*gammaaa*t32*t36*t66*t67-2.91313
     :           4765625d-4*t135*t64*t65*t67+1.8207092285156248d-5*gamma
     ;           aa*t123*t124*t32*t66+9.322031249999999d-3*t12*t34*t35*t
     <           54-9.9435d-2*t14*t34*t54)+2.0277777777777772d-3*gammaaa
     =           *t34*t42*t50*t54+1.0138888888888886d-3*t23*t34*t42*t54-
     >           6.887544671719978d-3*t34*t54-1.802469135802469d-1*t109*
     ?           t42*t51+2.883950617283951d-1*t109*t50+1.441975308641975
     @           4d-1*t138*t23+3.291061569204113d-2*t108*t2-1.8024691358
     1           02469d-1*t138*t17)+3.10585439734574d-3*t59*t79*t8-1.014
     2           955234713769d-1*t110*t2*t45)*wght+1.8610514726981991d+0
     3           *t1*t100*t4*t59*t84*wght+2.9925707680987046d+0*t1*t111*
     4           t53*t84*wght-5.583154418094598d+0*t1*t101*t130*t4*t59*w
     5           ght+Mmat3(iq,D3_GAA_GAA_TA)
              Mmat3(iq,D3_GAA_GAA_TB) = Mmat3(iq,D3_GAA_GAA_TB)
              Mmat3(iq,D3_RA_TA_TA) = (-7.481426920246762d-1*t1*t28*(1.2
     1           437810945273631d+0*t4*(1.6455307846020564d-2*gammaaa*t2
     2           *(3.10734375d-2*t113*t35*t64*t86-5.82626953125d-4*t32*t
     3           66*t67*t68*t7+1.86440625d-2*t12*t32*t35*t66*t7-2.98305d
     4           -1*t14*t32*t66*t7-1.0195971679687499d-3*t102*t36*t5*t63
     5           *t67-2.913134765625d-4*t121*t122*t139*t67+1.82070922851
     6           56248d-5*t102*t123*t124*t5*t63+3.10734375d-3*gammaaa*t3
     7           4*t35*t36*t54)-5.703124999999998d-6*t113*t23*t64*t75*t8
     8           6+7.604166666666664d-4*t23*t34*t43*t66*t7*t75-5.0694444
     9           44444443d-4*t34*t43*t54*t58*t7*t75+1.4257812499999994d-
     :           6*t113*t41*t63*t64*t75-1.520833333333333d-3*t34*t41*t42
     ;           *t66*t7+3.041666666666666d-3*t23*t32*t42*t66*t7-2.06626
     <           34015159936d-2*t32*t66*t7-2.0277777777777772d-3*t32*t42
     =           *t54*t58*t7+1.0138888888888886d-3*t105*t34*t42*t54*t7-2
     >           .1386718749999997d-6*t113*t128*t23*t43*t63*t64+2.883950
     ?           617283951d-1*t105*t58-9.012345679012345d-2*t116*t42*t43
     @           +1.4419753086419754d-1*t116*t41-4.3880820922721503d-2*g
     1           ammaaa*t114*t31+1.4419753086419754d-1*t140*t23-1.802469
     2           135802469d-1*t140*t17)+1.3532736462850253d-1*gammaaa*t1
     3           17*t31*t45)+3.0863208502457695d+0*t112*t27*t79*t84+t4*(
     4           3.7221029453963983d+0*t1*t107*t59+1.8610514726981991d+0
     5           *t1*t117*t46)*t84-6.944221913052981d+0*t1*t112*t130*t46
     6           *t79-1.2407009817987995d+0*t117*t27*t28*t4)*wght+Mmat3(
     7           iq,D3_RA_TA_TA)
              Mmat3(iq,D3_RA_TA_TB) = Mmat3(iq,D3_RA_TA_TB)
              Mmat3(iq,D3_RA_TB_TB) = Mmat3(iq,D3_RA_TB_TB)
              Mmat3(iq,D3_GAA_TA_TA) = t4*t84*(3.7221029453963983d+0*t1*
     1           t111*t59*wght+1.8610514726981991d+0*t1*t117*t53*wght)-7
     2           .481426920246762d-1*t1*t28*(1.2437810945273631d+0*t4*(1
     3           .6455307846020564d-2*gammaaa*t2*(-3.10734375d-3*t35*t36
     4           *t54*t9+1.0195971679687499d-3*t102*t32*t36*t67*t7-1.820
     5           7092285156248d-5*t102*t123*t124*t32*t7+5.82626953125d-4
     6           *gammaaa*t34*t66*t67*t68+2.913134765625d-4*t131*t139*t6
     7           5*t67-1.86440625d-2*gammaaa*t12*t34*t35*t66+2.98305d-1*
     8           gammaaa*t14*t34*t66-3.10734375d-2*t113*t35*t5*t63)+7.60
     9           4166666666664d-4*t23*t34*t51*t66*t7*t75-5.0694444444444
     :           43d-4*t34*t51*t54*t58*t7*t75+1.4257812499999994d-6*t113
     ;           *t50*t63*t64*t75+5.703124999999998d-6*t113*t23*t5*t63*t
     <           75-1.520833333333333d-3*t34*t42*t50*t66*t7+1.0138888888
     =           888886d-3*t109*t34*t42*t54*t7-3.041666666666666d-3*gamm
     >           aaa*t23*t34*t42*t66+2.0662634015159936d-2*gammaaa*t34*t
     ?           66-2.1386718749999997d-6*t113*t128*t23*t51*t63*t64+2.02
     @           77777777777772d-3*gammaaa*t34*t42*t54*t58+2.88395061728
     1           3951d-1*t109*t58-9.012345679012345d-2*t116*t42*t51+1.44
     2           19753086419754d-1*t116*t50+1.4419753086419754d-1*t141*t
     3           23+1.6455307846020564d-2*t114*t2-1.802469135802469d-1*t
     4           141*t17)-5.074776173568845d-2*t117*t2*t45)*wght-6.94422
     5           1913052981d+0*t1*t112*t130*t53*t79*wght+Mmat3(iq,D3_GAA
     6           _TA_TA)
              Mmat3(iq,D3_GAA_TA_TB) = Mmat3(iq,D3_GAA_TA_TB)
              Mmat3(iq,D3_GAA_TB_TB) = Mmat3(iq,D3_GAA_TB_TB)
              Mmat3(iq,D3_TA_TA_TA) = -9.305257363490997d-1*t1*t28*t4*(1
     1           .6455307846020564d-2*gammaaa*t2*(9.322031249999999d-3*g
     2           ammaaa*t35*t36*t66*t9-8.739404296874999d-4*t102*t34*t67
     3           *t68*t7+2.796609375d-2*t102*t12*t34*t35*t7-5.9661d-1*t1
     4           02*t14*t34*t7-2.913134765625d-4*t121*t142*t65*t67-1.019
     5           5971679687499d-3*t113*t32*t36*t5*t67+3.7288125d-2*t135*
     6           t35*t63*t64+1.8207092285156248d-5*t113*t123*t124*t32*t5
     7           )+4.2773437499999983d-6*t113*t58*t63*t64*t75-1.28320312
     8           49999995d-5*t135*t23*t63*t64*t75-4.562499999999999d-3*t
     9           34*t42*t58*t66*t7+1.520833333333333d-3*t116*t34*t42*t54
     :           *t7+6.083333333333332d-3*t102*t23*t34*t42*t7-4.13252680
     ;           3031987d-2*t102*t34*t7+1.2030029296874996d-8*t121*t128*
     <           t142*t23*t65+4.3259259259259264d-1*t116*t58+1.441975308
     =           6419754d-1*t143*t23-1.802469135802469d-1*t143*t17)*wght
     >           +6.944221913052984d+0*t1*t117*t59*t79*t84*wght-8.637091
     ?           931657939d+0*t1*t130*t59**3*wght/t3**6.0d+0+Mmat3(iq,D3
     @           _TA_TA_TA)
              Mmat3(iq,D3_TA_TA_TB) = Mmat3(iq,D3_TA_TA_TB)
              Mmat3(iq,D3_TA_TB_TB) = Mmat3(iq,D3_TA_TB_TB)
              Mmat3(iq,D3_TB_TB_TB) = Mmat3(iq,D3_TB_TB_TB)
            elseif (taua.gt.tol_rho.and.taub.le.tol_rho) then 
              t1 = rhoa**1.3333333333333333d+0
              t2 = 1/rhoa**2.6666666666666666d+0
              t3 = 2.040060021774676d-2*gammaaa*t2+1.0d+0
              t4 = 1/t3**2.0d+0
              t5 = gammaaa**3
              t6 = 1/rhoa**8
              t7 = gammaaa**2
              t8 = 1/rhoa**5.333333333333333d+0
              t9 = 1/rhoa
              t10 = 1/taua
              t11 = gammaaa*t10*t9
              t12 = t11**2.0d+0
              t13 = 1.5625d-2*t12+1.0d+0
              t14 = 1/t13**2.0d+0
              t15 = 2.485875d-2*t12*t14+1.234567901234568d-1
              t16 = 1.35388578153653d-4*t7*t8+2.8125d-3*t12
              t17 = t16**5.0d-1
              t18 = 1/rhoa**1.6666666666666669d+0
              t19 = 2.0d+0*taua-2.5d-1*gammaaa*t9
              t20 = 1.0970205230680374d-1*t18*t19-1.0d+0
              t21 = 4.38808209227215d-2*t18*t19*t20+1.0d+0
              t22 = 1/t21**5.0d-1
              t23 = 4.5d-1*t20*t22+1.0970205230680376d-2*gammaaa*t2
              t24 = 5.133173416322327d-6*t7*t8+1.5033019185692253d-6*t5*
     1           t6+7.209876543209877d-2*t23**2-1.802469135802469d-1*t17
     2           *t23+1.6455307846020564d-2*gammaaa*t15*t2+1.72188616792
     3           99946d-3*t12
              t25 = 1.2437810945273631d+0*t24*t4+1.0d+0
              t26 = 8.04d-1-8.04d-1/t25
              t27 = rhoa**3.333333333333333d-1
              t28 = 1/t25**2
              t29 = 1/rhoa**9
              t30 = 1/rhoa**6.333333333333333d+0
              t31 = 1/rhoa**3.6666666666666664d+0
              t32 = 1/rhoa**3
              t33 = 1/taua**2
              t34 = 1/rhoa**2
              t35 = 1/t13**3.0d+0
              t36 = t11**3.0d+0
              t37 = 1.553671875d-3*gammaaa*t10*t34*t35*t36-4.97175d-2*t1
     1           4*t32*t33*t7
              t38 = 2.7425513076700936d-2*gammaaa*t31-1.828367538446729d
     1           -1*t19*t2
              t39 = 4.38808209227215d-2*t18*t19*t38+1.0970205230680374d-
     1           2*gammaaa*t20*t31-7.313470153786916d-2*t19*t2*t20
              t40 = 1/t21**1.5d+0
              t41 = -2.25d-1*t20*t39*t40+4.5d-1*t22*t38-2.92538806151476
     1           7d-2*gammaaa*t31
              t42 = 1/t17
              t43 = -5.625d-3*t32*t33*t7-7.220724168194825d-4*t30*t7
              t44 = -3.443772335859989d-3*t32*t33*t7-2.737692488705241d-
     1           5*t30*t7-1.2026415348553804d-5*t29*t5-9.012345679012345
     2           d-2*t23*t42*t43+1.4419753086419754d-1*t23*t41-1.8024691
     3           35802469d-1*t17*t41+1.6455307846020564d-2*gammaaa*t2*t3
     4           7-4.3880820922721503d-2*gammaaa*t15*t31
              t45 = 1/t3**3.0d+0
              t46 = 1.3532736462850253d-1*gammaaa*t24*t31*t45+1.24378109
     1           45273631d+0*t4*t44
              t47 = 4.97175d-2*gammaaa*t14*t33*t34-1.553671875d-3*t10*t3
     1           5*t36*t9
              t48 = 1/rhoa**4.333333333333333d+0
              t49 = -1.2034540280324706d-3*t19*t48-1.0970205230680374d-2
     1           *t2*t20
              t50 = -2.25d-1*t20*t40*t49-1.2341480884515421d-2*t2*t22+1.
     1           0970205230680376d-2*t2
              t51 = 2.70777156307306d-4*gammaaa*t8+5.625d-3*gammaaa*t33*
     1           t34
              t52 = 1.0266346832644656d-5*gammaaa*t8+4.509905755707676d-
     1           6*t6*t7-9.012345679012345d-2*t23*t42*t51+1.441975308641
     2           9754d-1*t23*t50-1.802469135802469d-1*t17*t50+1.64553078
     3           46020564d-2*gammaaa*t2*t47+3.443772335859989d-3*gammaaa
     4           *t33*t34+1.6455307846020564d-2*t15*t2
              t53 = 1.2437810945273631d+0*t4*t52-5.074776173568845d-2*t2
     1           *t24*t45
              t54 = 1/taua**3
              t55 = 1.553671875d-3*gammaaa*t33*t35*t36*t9-4.97175d-2*t14
     1           *t34*t54*t7
              t56 = 1/rhoa**3.3333333333333337d+0
              t57 = 9.627632224259765d-3*t19*t56+8.7761641845443d-2*t18*
     1           t20
              t58 = 9.873184707612337d-2*t18*t22-2.25d-1*t20*t40*t57
              t59 = 5.069444444444443d-4*t23*t34*t42*t54*t7-3.4437723358
     1           59989d-3*t34*t54*t7+1.4419753086419754d-1*t23*t58-1.802
     2           469135802469d-1*t17*t58+1.6455307846020564d-2*gammaaa*t
     3           2*t55
              t60 = 1/rhoa**10
              t61 = 1/rhoa**7.333333333333333d+0
              t62 = 1/rhoa**4.666666666666667d+0
              t63 = 1/rhoa**4
              t64 = gammaaa**4
              t65 = 1/rhoa**6
              t66 = 1/taua**4
              t67 = 1/t13**4.0d+0
              t68 = t11**4.0d+0
              t69 = 1.4565673828125d-4*t33*t63*t67*t68*t7-4.661015624999
     1           9996d-3*t12*t33*t35*t63*t7+1.491525d-1*t14*t33*t63*t7-3
     2           .10734375d-3*t35*t64*t65*t66-3.10734375d-3*gammaaa*t10*
     3           t32*t35*t36
              t70 = t39**2
              t71 = 1/t21**2.5d+0
              t72 = 4.8756467691912775d-1*t19*t31-1.4626940307573832d-1*
     1           gammaaa*t62
              t73 = 4.38808209227215d-2*t18*t19*t72-5.850776123029533d-2
     1           *gammaaa*t20*t62+2.194041046136075d-2*gammaaa*t31*t38-1
     2           .4626940307573832d-1*t19*t2*t38+1.950258707676511d-1*t1
     3           9*t20*t31
              t74 = -2.25d-1*t20*t40*t73+4.5d-1*t22*t72+3.375d-1*t20*t70
     1           *t71+1.0726422892220812d-1*gammaaa*t62-4.5d-1*t38*t39*t
     2           40
              t75 = 1/t16**1.5d+0
              t76 = t43**2
              t77 = 1.6875d-2*t33*t63*t7+4.573125306523389d-3*t61*t7
              t78 = -9.012345679012345d-2*t23*t42*t77+4.5061728395061723
     1           d-2*t23*t75*t76+1.4419753086419754d-1*t23*t74-1.8024691
     2           35802469d-1*t17*t74+1.0331317007579968d-2*t33*t63*t7+1.
     3           7338719095133195d-4*t61*t7+1.6455307846020564d-2*gammaa
     4           a*t2*t69+1.6089634338331218d-1*gammaaa*t15*t62+1.082377
     5           3813698423d-4*t5*t60-1.802469135802469d-1*t41*t42*t43+1
     6           .4419753086419754d-1*t41**2-8.776164184544301d-2*gammaa
     7           a*t31*t37
              t79 = 1/t3**4.0d+0
              t80 = 2.208607571445859d-2*t24*t61*t7*t79+1.24378109452736
     1           31d+0*t4*t78-4.9620033697117594d-1*gammaaa*t24*t45*t62+
     2           2.7065472925700507d-1*gammaaa*t31*t44*t45
              t81 = -7.481426920246762d-1*t1*t80-1.9950471787324697d+0*t
     1           27*t46
              t82 = 1/rhoa**6.666666666666666d-1
              t83 = -4.1356699393293317d-1*t26-4.1356699393293317d-1
              t84 = 1/t25**3
              t85 = t46**2
              t86 = 1/rhoa**5
              t87 = 3.10734375d-3*t35*t5*t66*t86-1.4565673828125d-4*gamm
     1           aaa*t32*t33*t67*t68+1.553671875d-3*t10*t34*t35*t36+4.66
     2           10156249999996d-3*gammaaa*t12*t32*t33*t35-9.9435d-2*gam
     3           maaa*t14*t32*t33
              t88 = 5.214967454807371d-3*t19*t8-1.0970205230680374d-2*t2
     1           *t38+2.9253880615147665d-2*t20*t31-3.0086350700811765d-
     2           4*gammaaa*t30
              t89 = -2.25d-1*t20*t40*t88+3.375d-1*t20*t39*t49*t71-2.25d-
     1           1*t38*t40*t49+6.170740442257711d-3*t2*t39*t40+3.2910615
     2           692041123d-2*t22*t31-2.925388061514767d-2*t31
              t90 = -1.1249999999999999d-2*gammaaa*t32*t33-1.44414483363
     1           8965d-3*gammaaa*t30
              t91 = -9.012345679012345d-2*t23*t42*t90+1.4419753086419754
     1           d-1*t23*t89-1.802469135802469d-1*t17*t89+1.645530784602
     2           0564d-2*gammaaa*t2*t87+4.5061728395061723d-2*t23*t43*t5
     3           1*t75-3.607924604566141d-5*t29*t7-9.012345679012345d-2*
     4           t41*t42*t51-9.012345679012345d-2*t42*t43*t50+1.44197530
     5           86419754d-1*t41*t50-4.3880820922721503d-2*gammaaa*t31*t
     6           47+1.6455307846020564d-2*t2*t37-6.887544671719978d-3*ga
     7           mmaaa*t32*t33-4.3880820922721503d-2*t15*t31-5.475384977
     8           410482d-5*gammaaa*t30
              t92 = 1.2437810945273631d+0*t4*t91-8.282278392921971d-3*ga
     1           mmaaa*t24*t30*t79+1.3532736462850253d-1*gammaaa*t31*t45
     2           *t52-5.074776173568845d-2*t2*t44*t45+1.3532736462850253
     3           d-1*t24*t31*t45
              t93 = -7.481426920246762d-1*t1*t92-9.975235893662349d-1*t2
     1           7*t53
              t94 = -3.10734375d-3*t35*t63*t66*t7+1.4565673828125d-4*t33
     1           *t34*t67*t68-4.6610156249999996d-3*t12*t33*t34*t35+4.97
     2           175d-2*t14*t33*t34
              t95 = t49**2
              t96 = 3.375d-1*t20*t71*t95-1.3538857815365296d-4*t20*t40*t
     1           8+1.2341480884515421d-2*t2*t40*t49
              t97 = t51**2
              t98 = 2.70777156307306d-4*t8+5.625d-3*t33*t34
              t99 = -9.012345679012345d-2*t23*t42*t98+4.5061728395061723
     1           d-2*t23*t75*t97+1.4419753086419754d-1*t23*t96-1.8024691
     2           35802469d-1*t17*t96+1.6455307846020564d-2*gammaaa*t2*t9
     3           4+1.0266346832644656d-5*t8+9.019811511415352d-6*gammaaa
     4           *t6-1.802469135802469d-1*t42*t50*t51+1.4419753086419754
     5           d-1*t50**2+3.291061569204113d-2*t2*t47+3.44377233585998
     6           9d-3*t33*t34
              t100 = 1.2437810945273631d+0*t4*t99+3.10585439734574d-3*t2
     1           4*t79*t8-1.014955234713769d-1*t2*t45*t52
              t101 = t53**2
              t102 = 1/taua**5
              t103 = -3.10734375d-3*t102*t35*t64*t86+1.4565673828125d-4*
     1           t32*t54*t67*t68*t7-4.6610156249999996d-3*t12*t32*t35*t5
     2           4*t7+9.9435d-2*t14*t32*t54*t7-1.553671875d-3*gammaaa*t3
     3           3*t34*t35*t36
              t104 = 2.406908056064941d-3*gammaaa*t8-3.209210741419921d-
     1           2*t19*t48+8.7761641845443d-2*t18*t38-1.4626940307573832
     2           d-1*t2*t20
              t105 = 3.375d-1*t20*t39*t57*t71-2.25d-1*t38*t40*t57-4.9365
     1           923538061685d-2*t18*t39*t40-2.25d-1*t104*t20*t40-1.6455
     2           307846020562d-1*t2*t22
              t106 = -2.5347222222222215d-4*t23*t34*t43*t54*t7*t75+5.069
     1           444444444443d-4*t34*t41*t42*t54*t7-1.0138888888888886d-
     2           3*t23*t32*t42*t54*t7+6.887544671719978d-3*t32*t54*t7-9.
     3           012345679012345d-2*t42*t43*t58+1.4419753086419754d-1*t4
     4           1*t58-4.3880820922721503d-2*gammaaa*t31*t55+1.441975308
     5           6419754d-1*t105*t23+1.6455307846020564d-2*gammaaa*t103*
     6           t2-1.802469135802469d-1*t105*t17
              t107 = 1.3532736462850253d-1*gammaaa*t31*t45*t59+1.2437810
     1           945273631d+0*t106*t4
              t108 = 1.553671875d-3*t33*t35*t36*t9-1.4565673828125d-4*ga
     1           mmaaa*t34*t54*t67*t68+3.10734375d-3*t102*t35*t5*t63+4.6
     2           610156249999996d-3*gammaaa*t12*t34*t35*t54-9.9435d-2*ga
     3           mmaaa*t14*t34*t54
              t109 = 3.375d-1*t20*t49*t57*t71+6.170740442257711d-3*t2*t4
     1           0*t57-4.9365923538061685d-2*t18*t40*t49+1.0831086252292
     2           235d-3*t20*t40*t48
              t110 = -2.5347222222222215d-4*t23*t34*t51*t54*t7*t75+5.069
     1           444444444443d-4*t34*t42*t50*t54*t7-9.012345679012345d-2
     2           *t42*t51*t58+1.4419753086419754d-1*t50*t58+1.6455307846
     3           020564d-2*t2*t55+1.0138888888888886d-3*gammaaa*t23*t34*
     4           t42*t54-6.887544671719978d-3*gammaaa*t34*t54+1.44197530
     5           86419754d-1*t109*t23+1.6455307846020564d-2*gammaaa*t108
     6           *t2-1.802469135802469d-1*t109*t17
              t111 = 1.2437810945273631d+0*t110*t4-5.074776173568845d-2*
     1           t2*t45*t59
              t112 = t59**2
              t113 = 1/taua**6
              t114 = -3.10734375d-3*gammaaa*t35*t36*t54*t9+1.45656738281
     1           25d-4*t34*t66*t67*t68*t7-4.6610156249999996d-3*t12*t34*
     2           t35*t66*t7+1.491525d-1*t14*t34*t66*t7-3.10734375d-3*t11
     3           3*t35*t63*t64
              t115 = t57**2
              t116 = 3.375d-1*t115*t20*t71-9.873184707612337d-2*t18*t40*
     1           t57-8.664869001833788d-3*t20*t40*t56
              t117 = 1.4257812499999994d-6*t113*t23*t63*t64*t75-1.520833
     1           333333333d-3*t23*t34*t42*t66*t7+1.0331317007579968d-2*t
     2           34*t66*t7+1.0138888888888886d-3*t34*t42*t54*t58*t7+1.44
     3           19753086419754d-1*t58**2+1.4419753086419754d-1*t116*t23
     4           +1.6455307846020564d-2*gammaaa*t114*t2-1.80246913580246
     5           9d-1*t116*t17
              t118 = 1/rhoa**11
              t119 = 1/rhoa**8.333333333333334d+0
              t120 = 1/rhoa**5.666666666666667d+0
              t121 = gammaaa**6
              t122 = 1/rhoa**7
              t123 = 1/t13**5.0d+0
              t124 = t11**5.0d+0
              t125 = 1/t21**3.5d+0
              t126 = 8.044817169165608d-1*gammaaa*t120-1.787737148703468
     1           2d+0*t19*t62
              t127 = 1.0125000000000002d+0*t20*t39*t71*t73-6.75d-1*t38*t
     1           40*t73-2.25d-1*t20*t40*(3.2910615692041123d-2*gammaaa*t
     2           31*t72-2.194041046136075d-1*t19*t2*t72-1.75523283690886
     3           d-1*gammaaa*t38*t62-7.150948594813873d-1*t19*t20*t62+5.
     4           850776123029533d-1*t19*t31*t38+3.217926867666243d-1*gam
     5           maaa*t120*t20+4.38808209227215d-2*t126*t18*t19)-6.75d-1
     6           *t39*t40*t72+1.0125000000000002d+0*t38*t70*t71-8.4375d-
     7           1*t125*t20*t39**3+4.5d-1*t126*t22-5.005664016369713d-1*
     8           gammaaa*t120
              t128 = 1/t16**2.5d+0
              t129 = 1/t3**5.0d+0
              t130 = 1/t25**4
              t131 = gammaaa**5
              t132 = 6.75d-1*t20*t39*t71*t88-4.5d-1*t38*t40*t88+3.375d-1
     1           *t20*t49*t71*t73+6.170740442257711d-3*t2*t40*t73-2.25d-
     2           1*t20*t40*(-1.0970205230680374d-2*t2*t72-1.072642289222
     3           081d-1*t20*t62+3.209210741419921d-3*gammaaa*t61+5.85077
     4           6123029533d-2*t31*t38-2.781315975897265d-2*t19*t30)-2.2
     5           5d-1*t40*t49*t72-9.256110663386565d-3*t2*t70*t71+6.75d-
     6           1*t38*t39*t49*t71-8.4375d-1*t125*t20*t49*t70-1.20672257
     7           53748412d-1*t22*t62+1.0726422892220812d-1*t62-3.2910615
     8           692041123d-2*t31*t39*t40
              t133 = 3.375d-1*t38*t71*t95-8.4375d-1*t125*t20*t39*t95+6.7
     1           5d-1*t20*t49*t71*t88+1.2341480884515421d-2*t2*t40*t88+2
     2           .030828672304794d-4*t20*t39*t71*t8-1.3538857815365296d-
     3           4*t38*t40*t8-1.8512221326773132d-2*t2*t39*t49*t71-3.291
     4           0615692041123d-2*t31*t40*t49+7.220724168194822d-4*t20*t
     5           30*t40
              t134 = -2.77683319901597d-2*t2*t71*t95+6.092486016914382d-
     1           4*t20*t49*t71*t8+1.1139303661766865d-5*t40*t6-8.4375d-1
     2           *t125*t20*t49**3
              t135 = 1/taua**7
              t136 = -2.25d-1*t20*t40*(1.3906579879486325d-1*t19*t8+8.77
     1           61641845443d-2*t18*t72-2.9253880615147665d-1*t2*t38+3.9
     2           00517415353022d-1*t20*t31-2.0859869819229487d-2*gammaaa
     3           *t30)+3.375d-1*t20*t57*t71*t73-4.9365923538061685d-2*t1
     4           8*t40*t73-2.25d-1*t40*t57*t72+7.404888530709253d-2*t18*
     5           t70*t71+6.75d-1*t38*t39*t57*t71+6.75d-1*t104*t20*t39*t7
     6           1-8.4375d-1*t125*t20*t57*t70+1.6455307846020562d-1*t2*t
     7           39*t40-4.5d-1*t104*t38*t40+4.38808209227215d-1*t22*t31
              t137 = 3.375d-1*t20*t57*t71*t88-4.9365923538061685d-2*t18*
     1           t40*t88-4.693470709326635d-3*t20*t40*t8+3.375d-1*t38*t4
     2           9*t57*t71-9.256110663386565d-3*t2*t39*t57*t71+7.4048885
     3           30709253d-2*t18*t39*t49*t71+3.375d-1*t104*t20*t49*t71-1
     4           .6246629378438354d-3*t20*t39*t48*t71-8.4375d-1*t125*t20
     5           *t39*t49*t57-1.6455307846020562d-2*t31*t40*t57+8.227653
     6           923010281d-2*t2*t40*t49+1.0831086252292235d-3*t38*t40*t
     7           48+6.170740442257711d-3*t104*t2*t40
              t138 = 7.404888530709253d-2*t18*t71*t95-8.4375d-1*t125*t20
     1           *t57*t95+2.030828672304794d-4*t20*t57*t71*t8-1.85122213
     2           26773132d-2*t2*t49*t57*t71-3.249325875687671d-3*t20*t48
     3           *t49*t71-8.911442929413492d-5*t122*t40
              t139 = 1/taua**8
              t140 = 1.4809777061418505d-1*t18*t39*t57*t71+6.75d-1*t104*
     1           t20*t57*t71+1.2997303502750684d-2*t20*t39*t56*t71+3.375
     2           d-1*t115*t38*t71+1.6455307846020562d-1*t2*t40*t57-8.664
     3           869001833788d-3*t38*t40*t56+2.888289667277929d-2*t20*t4
     4           0*t48-9.873184707612337d-2*t104*t18*t40-8.4375d-1*t115*
     5           t125*t20*t39
              t141 = 1.4809777061418505d-1*t18*t49*t57*t71-3.24932587568
     1           7671d-3*t20*t48*t57*t71+1.2997303502750684d-2*t20*t49*t
     2           56*t71-9.256110663386565d-3*t115*t2*t71+7.1291543435307
     3           94d-4*t40*t65-8.4375d-1*t115*t125*t20*t49
              t142 = 1/taua**9
              t143 = -5.703323474824635d-3*t40*t86+3.899191050825205d-2*
     1           t20*t56*t57*t71+2.2214665592127758d-1*t115*t18*t71-8.43
     2           75d-1*t125*t20*t57**3
              fnc(iq) = (-9.305257363490997d-1*t1*t26-9.305257363490997d
     1           -1*t1)*wght+fnc(iq)
              Amat(iq,D1_RA) = (-7.481426920246762d-1*t1*t28*t46-1.24070
     1           09817987995d+0*t26*t27-1.2407009817987995d+0*t27)*wght+
     2           Amat(iq,D1_RA)
              Cmat(iq,D1_GAA) = Cmat(iq,D1_GAA)-7.481426920246762d-1*t1*
     1           t28*t53*wght
              Mmat(iq,D1_TA) = Mmat(iq,D1_TA)-9.305257363490997d-1*t1*t2
     1           8*t4*t59*wght
              Mmat(iq,D1_TB) = Mmat(iq,D1_TB)
              Amat2(iq,D2_RA_RA) = (1.4962853840493523d+0*t1*t84*t85+t82
     1           *t83+t28*t81)*wght+Amat2(iq,D2_RA_RA)
              Cmat2(iq,D2_RA_GAA) = (t28*t93+1.4962853840493523d+0*t1*t4
     1           6*t53*t84)*wght+Cmat2(iq,D2_RA_GAA)
              Cmat2(iq,D2_GAA_GAA) = 1.4962853840493523d+0*t1*t101*t84*w
     1           ght-7.481426920246762d-1*t1*t100*t28*wght+Cmat2(iq,D2_G
     2           AA_GAA)
              Mmat2(iq,D2_RA_TA) = (1.8610514726981991d+0*t1*t4*t46*t59*
     1           t84-1.2407009817987995d+0*t27*t28*t4*t59-7.481426920246
     2           762d-1*t1*t107*t28)*wght+Mmat2(iq,D2_RA_TA)
              Mmat2(iq,D2_RA_TB) = Mmat2(iq,D2_RA_TB)
              Mmat2(iq,D2_GAA_TA) = 1.8610514726981991d+0*t1*t4*t53*t59*
     1           t84*wght-7.481426920246762d-1*t1*t111*t28*wght+Mmat2(iq
     2           ,D2_GAA_TA)
              Mmat2(iq,D2_GAA_TB) = Mmat2(iq,D2_GAA_TB)
              Mmat2(iq,D2_TA_TA) = 2.3147406376843277d+0*t1*t112*t79*t84
     1           *wght-9.305257363490997d-1*t1*t117*t28*t4*wght+Mmat2(iq
     2           ,D2_TA_TA)
              Mmat2(iq,D2_TA_TB) = Mmat2(iq,D2_TA_TB)
              Mmat2(iq,D2_TB_TB) = Mmat2(iq,D2_TB_TB)
              Amat3(iq,D3_RA_RA_RA) = (t28*(-7.481426920246762d-1*t1*(1.
     1           2437810945273631d+0*t4*(1.6455307846020564d-2*gammaaa*t
     2           2*(-8.739404296874999d-4*t33*t67*t68*t7*t86+2.796609375
     3           d-2*t12*t33*t35*t7*t86-5.9661d-1*t14*t33*t7*t86-1.01959
     4           71679687499d-3*t36*t5*t54*t65*t67-2.913134765625d-4*t11
     5           3*t121*t29*t67+3.7288125d-2*t122*t35*t64*t66+1.82070922
     6           85156248d-5*t123*t124*t5*t54*t65+9.322031249999999d-3*g
     7           ammaaa*t10*t35*t36*t63)-9.012345679012345d-2*t23*t42*(-
     8           6.75d-2*t33*t7*t86-3.3536252247838183d-2*t119*t7)-4.132
     9           526803031987d-2*t33*t7*t86+1.3518518518518516d-1*t23*t4
     :           3*t75*t77-2.703703703703703d-1*t41*t42*t77+1.3518518518
     ;           518516d-1*t41*t75*t76-2.703703703703703d-1*t42*t43*t74+
     <           4.3259259259259264d-1*t41*t74-1.2715060669764344d-3*t11
     =           9*t7-1.3164246276816452d-1*gammaaa*t31*t69+4.8268903014
     >           99366d-1*gammaaa*t37*t62-1.0823773813698424d-3*t118*t5-
     ?           6.759259259259258d-2*t128*t23*t43**3+1.4419753086419754
     @           d-1*t127*t23-1.802469135802469d-1*t127*t17-7.5084960245
     1           5457d-1*gammaaa*t120*t15)+6.625822714337577d-2*t44*t61*
     2           t7*t79-2.4294683285904448d-1*t119*t24*t7*t79+4.05982093
     3           8855076d-1*gammaaa*t31*t45*t78-1.4886010109135278d+0*ga
     4           mmaaa*t44*t45*t62+4.80607147764859d-3*t118*t129*t24*t5+
     5           2.3156015725321547d+0*gammaaa*t120*t24*t45)-6.650157262
     6           441565d-1*t46*t82-2.9925707680987046d+0*t27*t80)+t84*(1
     7           .9950471787324697d+0*t27*t85-2*t46*t81+2.99257076809870
     8           46d+0*t1*t46*t80)-6.666666666666666d-1*t18*t83-3.325078
     9           631220783d-1*t28*t46*t82-4.488856152148057d+0*t1*t130*t
     :           46**3)*wght+Amat3(iq,D3_RA_RA_RA)
              Cmat3(iq,D3_RA_RA_GAA) = (t84*(2.9925707680987046d+0*t1*t4
     1           6*t92-2*t53*t81)+t28*(-1.9950471787324697d+0*t27*t92-7.
     2           481426920246762d-1*t1*(2.7065472925700507d-1*gammaaa*t3
     3           1*t45*t91+1.2437810945273631d+0*t4*(9.012345679012345d-
     4           2*t23*t43*t75*t90-1.802469135802469d-1*t41*t42*t90-1.80
     5           2469135802469d-1*t42*t43*t89+2.883950617283951d-1*t41*t
     6           89-8.776164184544301d-2*gammaaa*t31*t87+1.6455307846020
     7           564d-2*gammaaa*t2*(1.0195971679687499d-3*t36*t54*t67*t7
     8           *t86-1.8207092285156248d-5*t123*t124*t54*t7*t86+5.82626
     9           953125d-4*gammaaa*t33*t63*t67*t68+2.913134765625d-4*t11
     :           3*t131*t6*t67-3.10734375d-2*t35*t5*t65*t66-1.86440625d-
     ;           2*gammaaa*t12*t33*t35*t63+2.98305d-1*gammaaa*t14*t33*t6
     <           3-3.10734375d-3*t10*t32*t35*t36)+4.5061728395061723d-2*
     =           t23*t51*t75*t77-9.012345679012345d-2*t42*t50*t77+4.5061
     >           728395061723d-2*t50*t75*t76-6.759259259259258d-2*t128*t
     ?           23*t51*t76+9.012345679012345d-2*t41*t43*t51*t75-9.01234
     @           5679012345d-2*t42*t51*t74+1.4419753086419754d-1*t50*t74
     1           +3.2471321441095274d-4*t60*t7+1.6455307846020564d-2*t2*
     2           t69-9.012345679012345d-2*t23*t42*(3.375d-2*gammaaa*t33*
     3           t63+9.146250613046778d-3*gammaaa*t61)+2.066263401515993
     4           6d-2*gammaaa*t33*t63+1.6089634338331218d-1*gammaaa*t47*
     5           t62+1.6089634338331218d-1*t15*t62+3.467743819026639d-4*
     6           gammaaa*t61-8.776164184544301d-2*t31*t37+1.441975308641
     7           9754d-1*t132*t23-1.802469135802469d-1*t132*t17)+2.20860
     8           7571445859d-2*t52*t61*t7*t79+7.454050553629774d-2*gamma
     9           aa*t24*t61*t79-1.6564556785843942d-2*gammaaa*t30*t44*t7
     :           9-5.074776173568845d-2*t2*t45*t78-1.8022768041182213d-3
     ;           *t129*t24*t60*t7-4.9620033697117594d-1*gammaaa*t45*t52*
     <           t62-4.9620033697117594d-1*t24*t45*t62+2.706547292570050
     =           7d-1*t31*t44*t45))-4.488856152148057d+0*t1*t130*t53*t85
     >           -3.325078631220783d-1*t28*t53*t82)*wght+Cmat3(iq,D3_RA_
     ?           RA_GAA)
              Cmat3(iq,D3_RA_GAA_GAA) = (t28*(-7.481426920246762d-1*t1*(
     1           1.3532736462850253d-1*gammaaa*t31*t45*t99+1.24378109452
     2           73631d+0*t4*(4.5061728395061723d-2*t23*t43*t75*t98-9.01
     3           2345679012345d-2*t41*t42*t98+4.5061728395061723d-2*t41*
     4           t75*t97-6.759259259259258d-2*t128*t23*t43*t97-9.0123456
     5           79012345d-2*t42*t43*t96+1.4419753086419754d-1*t41*t96-4
     6           .3880820922721503d-2*gammaaa*t31*t94+9.012345679012345d
     7           -2*t23*t51*t75*t90-1.802469135802469d-1*t42*t50*t90-1.8
     8           02469135802469d-1*t42*t51*t89+2.883950617283951d-1*t50*
     9           t89+3.291061569204113d-2*t2*t87+1.6455307846020564d-2*g
     :           ammaaa*t2*(2.485875d-2*t35*t66*t7*t86-2.913134765625d-4
     ;           *t32*t33*t67*t68-2.913134765625d-4*t113*t122*t64*t67-1.
     <           0195971679687499d-3*gammaaa*t36*t54*t63*t67+1.820709228
     =           5156248d-5*gammaaa*t123*t124*t54*t63+9.322031249999999d
     >           -3*t12*t32*t33*t35-9.9435d-2*t14*t32*t33)+9.01234567901
     ?           2345d-2*t43*t50*t51*t75-8.776164184544301d-2*t31*t47-9.
     @           012345679012345d-2*t23*(-1.1249999999999999d-2*t32*t33-
     1           1.444144833638965d-3*t30)*t42-6.887544671719978d-3*t32*
     2           t33-5.475384977410482d-5*t30-7.215849209132282d-5*gamma
     3           aa*t29+1.4419753086419754d-1*t133*t23-1.802469135802469
     4           d-1*t133*t17)-1.014955234713769d-1*t2*t45*t91+3.1058543
     5           9734574d-3*t44*t79*t8-1.6564556785843942d-2*gammaaa*t30
     6           *t52*t79-1.6564556785843942d-2*t24*t30*t79+2.7065472925
     7           700507d-1*t31*t45*t52+6.758538015443329d-4*gammaaa*t129
     8           *t24*t29)-9.975235893662349d-1*t100*t27)+t84*(-2*t53*t9
     9           3+1.4962853840493523d+0*t1*t53*t92+1.4962853840493523d+
     :           0*t1*t100*t46)-4.488856152148057d+0*t1*t101*t130*t46)*w
     ;           ght+Cmat3(iq,D3_RA_GAA_GAA)
              Cmat3(iq,D3_GAA_GAA_GAA) = -7.481426920246762d-1*t1*t28*(-
     1           1.5224328520706534d-1*t2*t45*t99+1.2437810945273631d+0*
     2           t4*(1.3518518518518516d-1*t23*t51*t75*t98-2.70370370370
     3           3703d-1*t42*t50*t98+1.3518518518518516d-1*t50*t75*t97-2
     4           .703703703703703d-1*t42*t51*t96+4.3259259259259264d-1*t
     5           50*t96+4.9365923538061696d-2*t2*t94+1.6455307846020564d
     6           -2*gammaaa*t2*(2.913134765625d-4*t113*t5*t65*t67+1.0195
     7           971679687499d-3*t32*t36*t54*t67-1.86440625d-2*gammaaa*t
     8           35*t63*t66-1.8207092285156248d-5*t123*t124*t32*t54)+9.0
     9           19811511415352d-6*t6-6.759259259259258d-2*t128*t23*t51*
     :           *3+1.4419753086419754d-1*t134*t23-1.802469135802469d-1*
     ;           t134*t17)+9.317563192037218d-3*t52*t79*t8-2.53445175579
     <           1249d-4*t129*t24*t6)*wght+4.488856152148057d+0*t1*t100*
     =           t53*t84*wght-4.488856152148057d+0*t1*t130*t53**3*wght+C
     >           mat3(iq,D3_GAA_GAA_GAA)
              Mmat3(iq,D3_RA_RA_TA) = (t28*(-7.481426920246762d-1*t1*(1.
     1           2437810945273631d+0*t4*(1.6455307846020564d-2*gammaaa*t
     2           2*(-1.0195971679687499d-3*t36*t5*t66*t67*t86+1.82070922
     3           85156248d-5*t123*t124*t5*t66*t86-5.82626953125d-4*t54*t
     4           63*t67*t68*t7+1.86440625d-2*t12*t35*t54*t63*t7-2.98305d
     5           -1*t14*t54*t63*t7-2.913134765625d-4*t121*t135*t6*t67+3.
     6           10734375d-2*t102*t35*t64*t65+3.10734375d-3*gammaaa*t32*
     7           t33*t35*t36)-2.5347222222222215d-4*t23*t34*t54*t7*t75*t
     8           77-9.012345679012345d-2*t42*t58*t77+4.5061728395061723d
     9           -2*t58*t75*t76+3.802083333333333d-4*t128*t23*t34*t54*t7
     :           *t76-5.069444444444443d-4*t34*t41*t43*t54*t7*t75+1.0138
     ;           888888888886d-3*t23*t32*t43*t54*t7*t75+5.06944444444444
     <           3d-4*t34*t42*t54*t7*t74+1.4419753086419754d-1*t58*t74+3
     =           .0416666666666664d-3*t23*t42*t54*t63*t7-2.0662634015159
     >           936d-2*t54*t63*t7-2.0277777777777772d-3*t32*t41*t42*t54
     ?           *t7+1.6089634338331218d-1*gammaaa*t55*t62-1.80246913580
     @           2469d-1*t105*t42*t43+2.883950617283951d-1*t105*t41-8.77
     1           6164184544301d-2*gammaaa*t103*t31+1.4419753086419754d-1
     2           *t136*t23-1.802469135802469d-1*t136*t17)+2.208607571445
     3           859d-2*t59*t61*t7*t79-4.9620033697117594d-1*gammaaa*t45
     4           *t59*t62+2.7065472925700507d-1*gammaaa*t106*t31*t45)-1.
     5           9950471787324697d+0*t107*t27)-5.583154418094598d+0*t1*t
     6           130*t4*t59*t85-2.4875621890547261d+0*t4*t59*t81*t84+2.9
     7           925707680987046d+0*t1*t107*t46*t84-4.1356699393293317d-
     8           1*t28*t4*t59*t82)*wght+Mmat3(iq,D3_RA_RA_TA)
              Mmat3(iq,D3_RA_RA_TB) = Mmat3(iq,D3_RA_RA_TB)
              Mmat3(iq,D3_RA_GAA_TA) = (-2.4875621890547261d+0*t4*t59*t8
     1           4*t93+t28*(-7.481426920246762d-1*t1*(1.2437810945273631
     2           d+0*t4*(-2.5347222222222215d-4*t23*t34*t54*t7*t75*t90-9
     3           .012345679012345d-2*t42*t58*t90+5.069444444444443d-4*t3
     4           4*t42*t54*t7*t89+1.4419753086419754d-1*t58*t89+1.645530
     5           7846020564d-2*gammaaa*t2*(-2.796609375d-2*t102*t35*t5*t
     6           86+1.0195971679687499d-3*t36*t63*t66*t67*t7-1.820709228
     7           5156248d-5*t123*t124*t63*t66*t7+4.369702148437499d-4*ga
     8           mmaaa*t32*t54*t67*t68+2.913134765625d-4*t122*t131*t135*
     9           t67-1.3983046875d-2*gammaaa*t12*t32*t35*t54+1.9887d-1*g
     :           ammaaa*t14*t32*t54-1.553671875d-3*t33*t34*t35*t36)-2.53
     ;           47222222222215d-4*t34*t41*t51*t54*t7*t75+5.069444444444
     <           443d-4*t23*t32*t51*t54*t7*t75-2.5347222222222215d-4*t34
     =           *t43*t50*t54*t7*t75+4.5061728395061723d-2*t43*t51*t58*t
     >           75-5.069444444444443d-4*gammaaa*t23*t34*t43*t54*t75+3.8
     ?           02083333333333d-4*t128*t23*t34*t43*t51*t54*t7-1.0138888
     @           888888886d-3*t32*t42*t50*t54*t7-4.3880820922721503d-2*t
     1           31*t55+1.0138888888888886d-3*gammaaa*t34*t41*t42*t54-2.
     2           0277777777777772d-3*gammaaa*t23*t32*t42*t54+1.377508934
     3           3439956d-2*gammaaa*t32*t54-9.012345679012345d-2*t105*t4
     4           2*t51+1.4419753086419754d-1*t105*t50-9.012345679012345d
     5           -2*t109*t42*t43+1.4419753086419754d-1*t109*t41-4.388082
     6           0922721503d-2*gammaaa*t108*t31+1.4419753086419754d-1*t1
     7           37*t23+1.6455307846020564d-2*t103*t2-1.802469135802469d
     8           -1*t137*t17)-8.282278392921971d-3*gammaaa*t30*t59*t79+1
     9           .3532736462850253d-1*t31*t45*t59+1.3532736462850253d-1*
     :           gammaaa*t110*t31*t45-5.074776173568845d-2*t106*t2*t45)-
     ;           9.975235893662349d-1*t111*t27)+(1.4962853840493523d+0*t
     <           1*t107*t53+1.4962853840493523d+0*t1*t111*t46)*t84-5.583
     =           154418094598d+0*t1*t130*t4*t46*t53*t59)*wght+Mmat3(iq,D
     >           3_RA_GAA_TA)
              Mmat3(iq,D3_RA_GAA_TB) = Mmat3(iq,D3_RA_GAA_TB)
              Mmat3(iq,D3_GAA_GAA_TA) = -7.481426920246762d-1*t1*t28*(1.
     1           2437810945273631d+0*t4*(-2.5347222222222215d-4*t23*t34*
     2           t54*t7*t75*t98-9.012345679012345d-2*t42*t58*t98+4.50617
     3           28395061723d-2*t58*t75*t97+3.802083333333333d-4*t128*t2
     4           3*t34*t54*t7*t97+5.069444444444443d-4*t34*t42*t54*t7*t9
     5           6+1.4419753086419754d-1*t58*t96-5.069444444444443d-4*t3
     6           4*t50*t51*t54*t7*t75-1.0138888888888886d-3*gammaaa*t23*
     7           t34*t51*t54*t75+1.6455307846020564d-2*gammaaa*t2*(2.485
     8           875d-2*t102*t35*t63*t7-2.913134765625d-4*t34*t54*t67*t6
     9           8-1.0195971679687499d-3*gammaaa*t32*t36*t66*t67-2.91313
     :           4765625d-4*t135*t64*t65*t67+1.8207092285156248d-5*gamma
     ;           aa*t123*t124*t32*t66+9.322031249999999d-3*t12*t34*t35*t
     <           54-9.9435d-2*t14*t34*t54)+2.0277777777777772d-3*gammaaa
     =           *t34*t42*t50*t54+1.0138888888888886d-3*t23*t34*t42*t54-
     >           6.887544671719978d-3*t34*t54-1.802469135802469d-1*t109*
     ?           t42*t51+2.883950617283951d-1*t109*t50+1.441975308641975
     @           4d-1*t138*t23+3.291061569204113d-2*t108*t2-1.8024691358
     1           02469d-1*t138*t17)+3.10585439734574d-3*t59*t79*t8-1.014
     2           955234713769d-1*t110*t2*t45)*wght+1.8610514726981991d+0
     3           *t1*t100*t4*t59*t84*wght+2.9925707680987046d+0*t1*t111*
     4           t53*t84*wght-5.583154418094598d+0*t1*t101*t130*t4*t59*w
     5           ght+Mmat3(iq,D3_GAA_GAA_TA)
              Mmat3(iq,D3_GAA_GAA_TB) = Mmat3(iq,D3_GAA_GAA_TB)
              Mmat3(iq,D3_RA_TA_TA) = (-7.481426920246762d-1*t1*t28*(1.2
     1           437810945273631d+0*t4*(1.6455307846020564d-2*gammaaa*t2
     2           *(3.10734375d-2*t113*t35*t64*t86-5.82626953125d-4*t32*t
     3           66*t67*t68*t7+1.86440625d-2*t12*t32*t35*t66*t7-2.98305d
     4           -1*t14*t32*t66*t7-1.0195971679687499d-3*t102*t36*t5*t63
     5           *t67-2.913134765625d-4*t121*t122*t139*t67+1.82070922851
     6           56248d-5*t102*t123*t124*t5*t63+3.10734375d-3*gammaaa*t3
     7           4*t35*t36*t54)-5.703124999999998d-6*t113*t23*t64*t75*t8
     8           6+7.604166666666664d-4*t23*t34*t43*t66*t7*t75-5.0694444
     9           44444443d-4*t34*t43*t54*t58*t7*t75+1.4257812499999994d-
     :           6*t113*t41*t63*t64*t75-1.520833333333333d-3*t34*t41*t42
     ;           *t66*t7+3.041666666666666d-3*t23*t32*t42*t66*t7-2.06626
     <           34015159936d-2*t32*t66*t7-2.0277777777777772d-3*t32*t42
     =           *t54*t58*t7+1.0138888888888886d-3*t105*t34*t42*t54*t7-2
     >           .1386718749999997d-6*t113*t128*t23*t43*t63*t64+2.883950
     ?           617283951d-1*t105*t58-9.012345679012345d-2*t116*t42*t43
     @           +1.4419753086419754d-1*t116*t41-4.3880820922721503d-2*g
     1           ammaaa*t114*t31+1.4419753086419754d-1*t140*t23-1.802469
     2           135802469d-1*t140*t17)+1.3532736462850253d-1*gammaaa*t1
     3           17*t31*t45)+3.0863208502457695d+0*t112*t27*t79*t84+t4*(
     4           3.7221029453963983d+0*t1*t107*t59+1.8610514726981991d+0
     5           *t1*t117*t46)*t84-6.944221913052981d+0*t1*t112*t130*t46
     6           *t79-1.2407009817987995d+0*t117*t27*t28*t4)*wght+Mmat3(
     7           iq,D3_RA_TA_TA)
              Mmat3(iq,D3_RA_TA_TB) = Mmat3(iq,D3_RA_TA_TB)
              Mmat3(iq,D3_RA_TB_TB) = Mmat3(iq,D3_RA_TB_TB)
              Mmat3(iq,D3_GAA_TA_TA) = t4*t84*(3.7221029453963983d+0*t1*
     1           t111*t59*wght+1.8610514726981991d+0*t1*t117*t53*wght)-7
     2           .481426920246762d-1*t1*t28*(1.2437810945273631d+0*t4*(1
     3           .6455307846020564d-2*gammaaa*t2*(-3.10734375d-3*t35*t36
     4           *t54*t9+1.0195971679687499d-3*t102*t32*t36*t67*t7-1.820
     5           7092285156248d-5*t102*t123*t124*t32*t7+5.82626953125d-4
     6           *gammaaa*t34*t66*t67*t68+2.913134765625d-4*t131*t139*t6
     7           5*t67-1.86440625d-2*gammaaa*t12*t34*t35*t66+2.98305d-1*
     8           gammaaa*t14*t34*t66-3.10734375d-2*t113*t35*t5*t63)+7.60
     9           4166666666664d-4*t23*t34*t51*t66*t7*t75-5.0694444444444
     :           43d-4*t34*t51*t54*t58*t7*t75+1.4257812499999994d-6*t113
     ;           *t50*t63*t64*t75+5.703124999999998d-6*t113*t23*t5*t63*t
     <           75-1.520833333333333d-3*t34*t42*t50*t66*t7+1.0138888888
     =           888886d-3*t109*t34*t42*t54*t7-3.041666666666666d-3*gamm
     >           aaa*t23*t34*t42*t66+2.0662634015159936d-2*gammaaa*t34*t
     ?           66-2.1386718749999997d-6*t113*t128*t23*t51*t63*t64+2.02
     @           77777777777772d-3*gammaaa*t34*t42*t54*t58+2.88395061728
     1           3951d-1*t109*t58-9.012345679012345d-2*t116*t42*t51+1.44
     2           19753086419754d-1*t116*t50+1.4419753086419754d-1*t141*t
     3           23+1.6455307846020564d-2*t114*t2-1.802469135802469d-1*t
     4           141*t17)-5.074776173568845d-2*t117*t2*t45)*wght-6.94422
     5           1913052981d+0*t1*t112*t130*t53*t79*wght+Mmat3(iq,D3_GAA
     6           _TA_TA)
              Mmat3(iq,D3_GAA_TA_TB) = Mmat3(iq,D3_GAA_TA_TB)
              Mmat3(iq,D3_GAA_TB_TB) = Mmat3(iq,D3_GAA_TB_TB)
              Mmat3(iq,D3_TA_TA_TA) = -9.305257363490997d-1*t1*t28*t4*(1
     1           .6455307846020564d-2*gammaaa*t2*(9.322031249999999d-3*g
     2           ammaaa*t35*t36*t66*t9-8.739404296874999d-4*t102*t34*t67
     3           *t68*t7+2.796609375d-2*t102*t12*t34*t35*t7-5.9661d-1*t1
     4           02*t14*t34*t7-2.913134765625d-4*t121*t142*t65*t67-1.019
     5           5971679687499d-3*t113*t32*t36*t5*t67+3.7288125d-2*t135*
     6           t35*t63*t64+1.8207092285156248d-5*t113*t123*t124*t32*t5
     7           )+4.2773437499999983d-6*t113*t58*t63*t64*t75-1.28320312
     8           49999995d-5*t135*t23*t63*t64*t75-4.562499999999999d-3*t
     9           34*t42*t58*t66*t7+1.520833333333333d-3*t116*t34*t42*t54
     :           *t7+6.083333333333332d-3*t102*t23*t34*t42*t7-4.13252680
     ;           3031987d-2*t102*t34*t7+1.2030029296874996d-8*t121*t128*
     <           t142*t23*t65+4.3259259259259264d-1*t116*t58+1.441975308
     =           6419754d-1*t143*t23-1.802469135802469d-1*t143*t17)*wght
     >           +6.944221913052984d+0*t1*t117*t59*t79*t84*wght-8.637091
     ?           931657939d+0*t1*t130*t59**3*wght/t3**6.0d+0+Mmat3(iq,D3
     @           _TA_TA_TA)
              Mmat3(iq,D3_TA_TA_TB) = Mmat3(iq,D3_TA_TA_TB)
              Mmat3(iq,D3_TA_TB_TB) = Mmat3(iq,D3_TA_TB_TB)
              Mmat3(iq,D3_TB_TB_TB) = Mmat3(iq,D3_TB_TB_TB)
            elseif (taua.le.tol_rho.and.taub.gt.tol_rho) then 
              t1 = rhoa**1.3333333333333333d+0
              t2 = 1/rhoa**1.6666666666666669d+0
              t3 = 1.0970205230680374d-51*t2-1.0d+0
              t4 = 4.3880820922721503d-52*t2*t3+1.0d+0
              t5 = 1/t4**5.0d-1
              t6 = 4.5d-1*t3*t5+4.3880820922721503d-52*t2
              t7 = 1/rhoa**3.3333333333333337d+0
              t8 = 2.166217250458448d-103*t7+4.4999999999999996d-2
              t9 = t8**5.0d-1
              t10 = -1.802469135802469d-1*t6*t9+8.213077466115726d-105*t
     1           7+7.209876543209877d-2*t6**2+2.4881109353903252d-52*t2+
     2           9.621132278843042d-155/rhoa**5+2.755017868687991d-2
              t11 = 8.160240087098705d-52*t2+1.0d+0
              t12 = 1/t11**2.0d+0
              t13 = 1.2437810945273631d+0*t10*t12+1.0d+0
              t14 = 8.04d-1-8.04d-1/t13
              t15 = rhoa**3.333333333333333d-1
              t16 = 1/t13**2
              t17 = 1/rhoa**4.333333333333333d+0
              t18 = 1/t9
              t19 = 1/rhoa**2.6666666666666666d+0
              t20 = -7.313470153786917d-52*t19*t3-8.023026853549804d-103
     1           *t17
              t21 = 1/t4**1.5d+0
              t22 = -8.227653923010281d-52*t19*t5-2.25d-1*t20*t21*t3-7.3
     1           13470153786917d-52*t19
              t23 = -1.802469135802469d-1*t22*t9+1.4419753086419754d-1*t
     1           22*t6+6.507566225657065d-104*t17*t18*t6-4.1468515589838
     2           76d-52*t19-2.737692488705242d-104*t17-4.810566139421521
     3           d-154/rhoa**6
              t24 = 1/t11**3.0d+0
              t25 = 3.3831841157125636d-51*t10*t19*t24+1.243781094527363
     1           1d+0*t12*t23
              t26 = -4.1356699393293317d-1*t14-4.1356699393293317d-1
              t27 = 1/rhoa**6.666666666666666d-1
              t28 = 1/t13**3
              t29 = t25**2
              t30 = 1/t8**1.5d+0
              t31 = 1/rhoa**8.666666666666666d+0
              t32 = 1/rhoa**5.333333333333333d+0
              t33 = 1/rhoa**3.6666666666666664d+0
              t34 = t20**2
              t35 = 1/t4**2.5d+0
              t36 = 1.9502587076765113d-51*t3*t33+4.8138161121298817d-10
     1           2*t32
              t37 = 2.194041046136075d-51*t33*t5-2.25d-1*t21*t3*t36+3.37
     1           5d-1*t3*t34*t35+1.9502587076765113d-51*t33+8.2276539230
     2           10281d-52*t19*t20*t21
              t38 = -1.802469135802469d-1*t37*t9+1.4419753086419754d-1*t
     1           37*t6-2.8199453644513944d-103*t18*t32*t6+2.349467036086
     2           518d-206*t30*t31*t6+1.1058270823957002d-51*t33+1.186333
     3           4117722714d-103*t32+1.4419753086419754d-1*t22**2+1.3015
     4           13245131413d-103*t17*t18*t22+2.886339683652913d-153/rho
     5           a**7
              t39 = 1/t11**4.0d+0
              t40 = 1.3803797321536623d-101*t10*t32*t39+1.24378109452736
     1           31d+0*t12*t38-9.021824308566837d-51*t10*t24*t33+6.76636
     2           8231425127d-51*t19*t23*t24
              t41 = -7.481426920246762d-1*t1*t40-1.9950471787324697d+0*t
     1           15*t25
              t42 = 1/rhoa**8
              t43 = 1/rhoa**6.333333333333333d+0
              t44 = 1/rhoa**4.666666666666667d+0
              t45 = -8.044817169165608d-51*t44*t5-2.25d-1*t21*t3*(-7.150
     1           948594813874d-51*t3*t44-2.9239475644048174d-101*t43)-7.
     2           150948594813874d-51*t44-8.4375d-1*t20**3*t3/t4**3.5d+0+
     3           1.0125000000000002d+0*t20*t3*t35*t36+1.2341480884515423
     4           d-51*t19*t21*t36-1.8512221326773132d-51*t19*t34*t35-3.2
     5           910615692041123d-51*t20*t21*t33
              fnc(iq) = (-9.305257363490997d-1*t1*t14-9.305257363490997d
     1           -1*t1)*wght+fnc(iq)
              Amat(iq,D1_RA) = (-7.481426920246762d-1*t1*t16*t25-1.24070
     1           09817987995d+0*t14*t15-1.2407009817987995d+0*t15)*wght+
     2           Amat(iq,D1_RA)
              Cmat(iq,D1_GAA) = Cmat(iq,D1_GAA)
              Mmat(iq,D1_TA) = Mmat(iq,D1_TA)
              Mmat(iq,D1_TB) = Mmat(iq,D1_TB)
              Amat2(iq,D2_RA_RA) = (t16*t41+1.4962853840493523d+0*t1*t28
     1           *t29+t26*t27)*wght+Amat2(iq,D2_RA_RA)
              Cmat2(iq,D2_RA_GAA) = Cmat2(iq,D2_RA_GAA)
              Cmat2(iq,D2_GAA_GAA) = Cmat2(iq,D2_GAA_GAA)
              Mmat2(iq,D2_RA_TA) = Mmat2(iq,D2_RA_TA)
              Mmat2(iq,D2_RA_TB) = Mmat2(iq,D2_RA_TB)
              Mmat2(iq,D2_GAA_TA) = Mmat2(iq,D2_GAA_TA)
              Mmat2(iq,D2_GAA_TB) = Mmat2(iq,D2_GAA_TB)
              Mmat2(iq,D2_TA_TA) = Mmat2(iq,D2_TA_TA)
              Mmat2(iq,D2_TA_TB) = Mmat2(iq,D2_TA_TB)
              Mmat2(iq,D2_TB_TB) = Mmat2(iq,D2_TB_TB)
              Amat3(iq,D3_RA_RA_RA) = (t16*(-7.481426920246762d-1*t1*(1.
     1           2437810945273631d+0*t12*(-1.802469135802469d-1*t45*t9+2
     2           .544728011477048d-308*t6/(rhoa**13*t8**2.5d+0)+1.441975
     3           3086419754d-1*t45*t6+1.5039708610407437d-102*t18*t43*t6
     4           -3.054307146912473d-205*t30*t6/rhoa**9.666666666666666d
     5           +0-4.054699302117567d-51*t44-6.327111529452114d-103*t43
     6           -2.020437778557039d-152*t42+4.3259259259259264d-1*t22*t
     7           37+1.9522698676971195d-103*t17*t18*t37-8.45983609335418
     8           4d-103*t18*t22*t32+7.048401108259554d-206*t22*t30*t31)+
     9           3.308002246474507d-50*t10*t24*t44-1.1043037857229297d-1
     :           00*t10*t39*t43+7.509486683825926d-152*t10*t42/t11**5.0d
     ;           +0+4.1411391964609867d-101*t23*t32*t39+1.01495523471376
     <           91d-50*t19*t24*t38-2.706547292570051d-50*t23*t24*t33)-2
     =           .9925707680987046d+0*t15*t40-6.650157262441565d-1*t25*t
     >           27)+t28*(-2*t25*t41+2.9925707680987046d+0*t1*t25*t40+1.
     ?           9950471787324697d+0*t15*t29)-3.325078631220783d-1*t16*t
     @           25*t27-6.666666666666666d-1*t2*t26-4.488856152148057d+0
     1           *t1*t25**3/t13**4)*wght+Amat3(iq,D3_RA_RA_RA)
              Cmat3(iq,D3_RA_RA_GAA) = Cmat3(iq,D3_RA_RA_GAA)
              Cmat3(iq,D3_RA_GAA_GAA) = Cmat3(iq,D3_RA_GAA_GAA)
              Cmat3(iq,D3_GAA_GAA_GAA) = Cmat3(iq,D3_GAA_GAA_GAA)
              Mmat3(iq,D3_RA_RA_TA) = Mmat3(iq,D3_RA_RA_TA)
              Mmat3(iq,D3_RA_RA_TB) = Mmat3(iq,D3_RA_RA_TB)
              Mmat3(iq,D3_RA_GAA_TA) = Mmat3(iq,D3_RA_GAA_TA)
              Mmat3(iq,D3_RA_GAA_TB) = Mmat3(iq,D3_RA_GAA_TB)
              Mmat3(iq,D3_GAA_GAA_TA) = Mmat3(iq,D3_GAA_GAA_TA)
              Mmat3(iq,D3_GAA_GAA_TB) = Mmat3(iq,D3_GAA_GAA_TB)
              Mmat3(iq,D3_RA_TA_TA) = Mmat3(iq,D3_RA_TA_TA)
              Mmat3(iq,D3_RA_TA_TB) = Mmat3(iq,D3_RA_TA_TB)
              Mmat3(iq,D3_RA_TB_TB) = Mmat3(iq,D3_RA_TB_TB)
              Mmat3(iq,D3_GAA_TA_TA) = Mmat3(iq,D3_GAA_TA_TA)
              Mmat3(iq,D3_GAA_TA_TB) = Mmat3(iq,D3_GAA_TA_TB)
              Mmat3(iq,D3_GAA_TB_TB) = Mmat3(iq,D3_GAA_TB_TB)
              Mmat3(iq,D3_TA_TA_TA) = Mmat3(iq,D3_TA_TA_TA)
              Mmat3(iq,D3_TA_TA_TB) = Mmat3(iq,D3_TA_TA_TB)
              Mmat3(iq,D3_TA_TB_TB) = Mmat3(iq,D3_TA_TB_TB)
              Mmat3(iq,D3_TB_TB_TB) = Mmat3(iq,D3_TB_TB_TB)
            else 
              t1 = rhoa**1.3333333333333333d+0
              t2 = 1/rhoa**1.6666666666666669d+0
              t3 = 1.0970205230680374d-51*t2-1.0d+0
              t4 = 4.3880820922721503d-52*t2*t3+1.0d+0
              t5 = 1/t4**5.0d-1
              t6 = 4.5d-1*t3*t5+4.3880820922721503d-52*t2
              t7 = 1/rhoa**3.3333333333333337d+0
              t8 = 2.166217250458448d-103*t7+4.4999999999999996d-2
              t9 = t8**5.0d-1
              t10 = -1.802469135802469d-1*t6*t9+8.213077466115726d-105*t
     1           7+7.209876543209877d-2*t6**2+2.4881109353903252d-52*t2+
     2           9.621132278843042d-155/rhoa**5+2.755017868687991d-2
              t11 = 8.160240087098705d-52*t2+1.0d+0
              t12 = 1/t11**2.0d+0
              t13 = 1.2437810945273631d+0*t10*t12+1.0d+0
              t14 = 8.04d-1-8.04d-1/t13
              t15 = rhoa**3.333333333333333d-1
              t16 = 1/t13**2
              t17 = 1/rhoa**4.333333333333333d+0
              t18 = 1/t9
              t19 = 1/rhoa**2.6666666666666666d+0
              t20 = -7.313470153786917d-52*t19*t3-8.023026853549804d-103
     1           *t17
              t21 = 1/t4**1.5d+0
              t22 = -8.227653923010281d-52*t19*t5-2.25d-1*t20*t21*t3-7.3
     1           13470153786917d-52*t19
              t23 = -1.802469135802469d-1*t22*t9+1.4419753086419754d-1*t
     1           22*t6+6.507566225657065d-104*t17*t18*t6-4.1468515589838
     2           76d-52*t19-2.737692488705242d-104*t17-4.810566139421521
     3           d-154/rhoa**6
              t24 = 1/t11**3.0d+0
              t25 = 3.3831841157125636d-51*t10*t19*t24+1.243781094527363
     1           1d+0*t12*t23
              t26 = -4.1356699393293317d-1*t14-4.1356699393293317d-1
              t27 = 1/rhoa**6.666666666666666d-1
              t28 = 1/t13**3
              t29 = t25**2
              t30 = 1/t8**1.5d+0
              t31 = 1/rhoa**8.666666666666666d+0
              t32 = 1/rhoa**5.333333333333333d+0
              t33 = 1/rhoa**3.6666666666666664d+0
              t34 = t20**2
              t35 = 1/t4**2.5d+0
              t36 = 1.9502587076765113d-51*t3*t33+4.8138161121298817d-10
     1           2*t32
              t37 = 2.194041046136075d-51*t33*t5-2.25d-1*t21*t3*t36+3.37
     1           5d-1*t3*t34*t35+1.9502587076765113d-51*t33+8.2276539230
     2           10281d-52*t19*t20*t21
              t38 = -1.802469135802469d-1*t37*t9+1.4419753086419754d-1*t
     1           37*t6-2.8199453644513944d-103*t18*t32*t6+2.349467036086
     2           518d-206*t30*t31*t6+1.1058270823957002d-51*t33+1.186333
     3           4117722714d-103*t32+1.4419753086419754d-1*t22**2+1.3015
     4           13245131413d-103*t17*t18*t22+2.886339683652913d-153/rho
     5           a**7
              t39 = 1/t11**4.0d+0
              t40 = 1.3803797321536623d-101*t10*t32*t39+1.24378109452736
     1           31d+0*t12*t38-9.021824308566837d-51*t10*t24*t33+6.76636
     2           8231425127d-51*t19*t23*t24
              t41 = -7.481426920246762d-1*t1*t40-1.9950471787324697d+0*t
     1           15*t25
              t42 = 1/rhoa**8
              t43 = 1/rhoa**6.333333333333333d+0
              t44 = 1/rhoa**4.666666666666667d+0
              t45 = -8.044817169165608d-51*t44*t5-2.25d-1*t21*t3*(-7.150
     1           948594813874d-51*t3*t44-2.9239475644048174d-101*t43)-7.
     2           150948594813874d-51*t44-8.4375d-1*t20**3*t3/t4**3.5d+0+
     3           1.0125000000000002d+0*t20*t3*t35*t36+1.2341480884515423
     4           d-51*t19*t21*t36-1.8512221326773132d-51*t19*t34*t35-3.2
     5           910615692041123d-51*t20*t21*t33
              fnc(iq) = (-9.305257363490997d-1*t1*t14-9.305257363490997d
     1           -1*t1)*wght+fnc(iq)
              Amat(iq,D1_RA) = (-7.481426920246762d-1*t1*t16*t25-1.24070
     1           09817987995d+0*t14*t15-1.2407009817987995d+0*t15)*wght+
     2           Amat(iq,D1_RA)
              Cmat(iq,D1_GAA) = Cmat(iq,D1_GAA)
              Mmat(iq,D1_TA) = Mmat(iq,D1_TA)
              Mmat(iq,D1_TB) = Mmat(iq,D1_TB)
              Amat2(iq,D2_RA_RA) = (t16*t41+1.4962853840493523d+0*t1*t28
     1           *t29+t26*t27)*wght+Amat2(iq,D2_RA_RA)
              Cmat2(iq,D2_RA_GAA) = Cmat2(iq,D2_RA_GAA)
              Cmat2(iq,D2_GAA_GAA) = Cmat2(iq,D2_GAA_GAA)
              Mmat2(iq,D2_RA_TA) = Mmat2(iq,D2_RA_TA)
              Mmat2(iq,D2_RA_TB) = Mmat2(iq,D2_RA_TB)
              Mmat2(iq,D2_GAA_TA) = Mmat2(iq,D2_GAA_TA)
              Mmat2(iq,D2_GAA_TB) = Mmat2(iq,D2_GAA_TB)
              Mmat2(iq,D2_TA_TA) = Mmat2(iq,D2_TA_TA)
              Mmat2(iq,D2_TA_TB) = Mmat2(iq,D2_TA_TB)
              Mmat2(iq,D2_TB_TB) = Mmat2(iq,D2_TB_TB)
              Amat3(iq,D3_RA_RA_RA) = (t16*(-7.481426920246762d-1*t1*(1.
     1           2437810945273631d+0*t12*(-1.802469135802469d-1*t45*t9+2
     2           .544728011477048d-308*t6/(rhoa**13*t8**2.5d+0)+1.441975
     3           3086419754d-1*t45*t6+1.5039708610407437d-102*t18*t43*t6
     4           -3.054307146912473d-205*t30*t6/rhoa**9.666666666666666d
     5           +0-4.054699302117567d-51*t44-6.327111529452114d-103*t43
     6           -2.020437778557039d-152*t42+4.3259259259259264d-1*t22*t
     7           37+1.9522698676971195d-103*t17*t18*t37-8.45983609335418
     8           4d-103*t18*t22*t32+7.048401108259554d-206*t22*t30*t31)+
     9           3.308002246474507d-50*t10*t24*t44-1.1043037857229297d-1
     :           00*t10*t39*t43+7.509486683825926d-152*t10*t42/t11**5.0d
     ;           +0+4.1411391964609867d-101*t23*t32*t39+1.01495523471376
     <           91d-50*t19*t24*t38-2.706547292570051d-50*t23*t24*t33)-2
     =           .9925707680987046d+0*t15*t40-6.650157262441565d-1*t25*t
     >           27)+t28*(-2*t25*t41+2.9925707680987046d+0*t1*t25*t40+1.
     ?           9950471787324697d+0*t15*t29)-3.325078631220783d-1*t16*t
     @           25*t27-6.666666666666666d-1*t2*t26-4.488856152148057d+0
     1           *t1*t25**3/t13**4)*wght+Amat3(iq,D3_RA_RA_RA)
              Cmat3(iq,D3_RA_RA_GAA) = Cmat3(iq,D3_RA_RA_GAA)
              Cmat3(iq,D3_RA_GAA_GAA) = Cmat3(iq,D3_RA_GAA_GAA)
              Cmat3(iq,D3_GAA_GAA_GAA) = Cmat3(iq,D3_GAA_GAA_GAA)
              Mmat3(iq,D3_RA_RA_TA) = Mmat3(iq,D3_RA_RA_TA)
              Mmat3(iq,D3_RA_RA_TB) = Mmat3(iq,D3_RA_RA_TB)
              Mmat3(iq,D3_RA_GAA_TA) = Mmat3(iq,D3_RA_GAA_TA)
              Mmat3(iq,D3_RA_GAA_TB) = Mmat3(iq,D3_RA_GAA_TB)
              Mmat3(iq,D3_GAA_GAA_TA) = Mmat3(iq,D3_GAA_GAA_TA)
              Mmat3(iq,D3_GAA_GAA_TB) = Mmat3(iq,D3_GAA_GAA_TB)
              Mmat3(iq,D3_RA_TA_TA) = Mmat3(iq,D3_RA_TA_TA)
              Mmat3(iq,D3_RA_TA_TB) = Mmat3(iq,D3_RA_TA_TB)
              Mmat3(iq,D3_RA_TB_TB) = Mmat3(iq,D3_RA_TB_TB)
              Mmat3(iq,D3_GAA_TA_TA) = Mmat3(iq,D3_GAA_TA_TA)
              Mmat3(iq,D3_GAA_TA_TB) = Mmat3(iq,D3_GAA_TA_TB)
              Mmat3(iq,D3_GAA_TB_TB) = Mmat3(iq,D3_GAA_TB_TB)
              Mmat3(iq,D3_TA_TA_TA) = Mmat3(iq,D3_TA_TA_TA)
              Mmat3(iq,D3_TA_TA_TB) = Mmat3(iq,D3_TA_TA_TB)
              Mmat3(iq,D3_TA_TB_TB) = Mmat3(iq,D3_TA_TB_TB)
              Mmat3(iq,D3_TB_TB_TB) = Mmat3(iq,D3_TB_TB_TB)
            endif 
          elseif (rhoa.le.tol_rho.and.rhob.gt.tol_rho) then 
            if (taua.gt.tol_rho.and.taub.gt.tol_rho) then 
              t1 = rhob**1.3333333333333333d+0
              t2 = 1/rhob**2.6666666666666666d+0
              t3 = 2.040060021774676d-2*gammabb*t2+1.0d+0
              t4 = 1/t3**2.0d+0
              t5 = gammabb**3
              t6 = 1/rhob**8
              t7 = gammabb**2
              t8 = 1/rhob**5.333333333333333d+0
              t9 = 1/rhob
              t10 = 1/taub
              t11 = gammabb*t10*t9
              t12 = t11**2.0d+0
              t13 = 1.5625d-2*t12+1.0d+0
              t14 = 1/t13**2.0d+0
              t15 = 2.485875d-2*t12*t14+1.234567901234568d-1
              t16 = 1.35388578153653d-4*t7*t8+2.8125d-3*t12
              t17 = t16**5.0d-1
              t18 = 1/rhob**1.6666666666666669d+0
              t19 = 2.0d+0*taub-2.5d-1*gammabb*t9
              t20 = 1.0970205230680374d-1*t18*t19-1.0d+0
              t21 = 4.38808209227215d-2*t18*t19*t20+1.0d+0
              t22 = 1/t21**5.0d-1
              t23 = 4.5d-1*t20*t22+1.0970205230680376d-2*gammabb*t2
              t24 = 5.133173416322327d-6*t7*t8+1.5033019185692253d-6*t5*
     1           t6+7.209876543209877d-2*t23**2-1.802469135802469d-1*t17
     2           *t23+1.6455307846020564d-2*gammabb*t15*t2+1.72188616792
     3           99946d-3*t12
              t25 = 1.2437810945273631d+0*t24*t4+1.0d+0
              t26 = 8.04d-1-8.04d-1/t25
              t27 = rhob**3.333333333333333d-1
              t28 = 1/t25**2
              t29 = 1/rhob**9
              t30 = 1/rhob**6.333333333333333d+0
              t31 = 1/rhob**3.6666666666666664d+0
              t32 = 1/rhob**3
              t33 = 1/taub**2
              t34 = 1/rhob**2
              t35 = 1/t13**3.0d+0
              t36 = t11**3.0d+0
              t37 = 1.553671875d-3*gammabb*t10*t34*t35*t36-4.97175d-2*t1
     1           4*t32*t33*t7
              t38 = 2.7425513076700936d-2*gammabb*t31-1.828367538446729d
     1           -1*t19*t2
              t39 = 4.38808209227215d-2*t18*t19*t38+1.0970205230680374d-
     1           2*gammabb*t20*t31-7.313470153786916d-2*t19*t2*t20
              t40 = 1/t21**1.5d+0
              t41 = -2.25d-1*t20*t39*t40+4.5d-1*t22*t38-2.92538806151476
     1           7d-2*gammabb*t31
              t42 = 1/t17
              t43 = -5.625d-3*t32*t33*t7-7.220724168194825d-4*t30*t7
              t44 = -3.443772335859989d-3*t32*t33*t7-2.737692488705241d-
     1           5*t30*t7-1.2026415348553804d-5*t29*t5-9.012345679012345
     2           d-2*t23*t42*t43+1.4419753086419754d-1*t23*t41-1.8024691
     3           35802469d-1*t17*t41+1.6455307846020564d-2*gammabb*t2*t3
     4           7-4.3880820922721503d-2*gammabb*t15*t31
              t45 = 1/t3**3.0d+0
              t46 = 1.3532736462850253d-1*gammabb*t24*t31*t45+1.24378109
     1           45273631d+0*t4*t44
              t47 = 4.97175d-2*gammabb*t14*t33*t34-1.553671875d-3*t10*t3
     1           5*t36*t9
              t48 = 1/rhob**4.333333333333333d+0
              t49 = -1.2034540280324706d-3*t19*t48-1.0970205230680374d-2
     1           *t2*t20
              t50 = -2.25d-1*t20*t40*t49-1.2341480884515421d-2*t2*t22+1.
     1           0970205230680376d-2*t2
              t51 = 2.70777156307306d-4*gammabb*t8+5.625d-3*gammabb*t33*
     1           t34
              t52 = 1.0266346832644656d-5*gammabb*t8+4.509905755707676d-
     1           6*t6*t7-9.012345679012345d-2*t23*t42*t51+1.441975308641
     2           9754d-1*t23*t50-1.802469135802469d-1*t17*t50+1.64553078
     3           46020564d-2*gammabb*t2*t47+3.443772335859989d-3*gammabb
     4           *t33*t34+1.6455307846020564d-2*t15*t2
              t53 = 1.2437810945273631d+0*t4*t52-5.074776173568845d-2*t2
     1           *t24*t45
              t54 = 1/taub**3
              t55 = 1.553671875d-3*gammabb*t33*t35*t36*t9-4.97175d-2*t14
     1           *t34*t54*t7
              t56 = 1/rhob**3.3333333333333337d+0
              t57 = 9.627632224259765d-3*t19*t56+8.7761641845443d-2*t18*
     1           t20
              t58 = 9.873184707612337d-2*t18*t22-2.25d-1*t20*t40*t57
              t59 = 5.069444444444443d-4*t23*t34*t42*t54*t7-3.4437723358
     1           59989d-3*t34*t54*t7+1.4419753086419754d-1*t23*t58-1.802
     2           469135802469d-1*t17*t58+1.6455307846020564d-2*gammabb*t
     3           2*t55
              t60 = 1/rhob**10
              t61 = 1/rhob**7.333333333333333d+0
              t62 = 1/rhob**4.666666666666667d+0
              t63 = 1/rhob**4
              t64 = gammabb**4
              t65 = 1/rhob**6
              t66 = 1/taub**4
              t67 = 1/t13**4.0d+0
              t68 = t11**4.0d+0
              t69 = 1.4565673828125d-4*t33*t63*t67*t68*t7-4.661015624999
     1           9996d-3*t12*t33*t35*t63*t7+1.491525d-1*t14*t33*t63*t7-3
     2           .10734375d-3*t35*t64*t65*t66-3.10734375d-3*gammabb*t10*
     3           t32*t35*t36
              t70 = t39**2
              t71 = 1/t21**2.5d+0
              t72 = 4.8756467691912775d-1*t19*t31-1.4626940307573832d-1*
     1           gammabb*t62
              t73 = 4.38808209227215d-2*t18*t19*t72-5.850776123029533d-2
     1           *gammabb*t20*t62+2.194041046136075d-2*gammabb*t31*t38-1
     2           .4626940307573832d-1*t19*t2*t38+1.950258707676511d-1*t1
     3           9*t20*t31
              t74 = -2.25d-1*t20*t40*t73+4.5d-1*t22*t72+3.375d-1*t20*t70
     1           *t71+1.0726422892220812d-1*gammabb*t62-4.5d-1*t38*t39*t
     2           40
              t75 = 1/t16**1.5d+0
              t76 = t43**2
              t77 = 1.6875d-2*t33*t63*t7+4.573125306523389d-3*t61*t7
              t78 = -9.012345679012345d-2*t23*t42*t77+4.5061728395061723
     1           d-2*t23*t75*t76+1.4419753086419754d-1*t23*t74-1.8024691
     2           35802469d-1*t17*t74+1.0331317007579968d-2*t33*t63*t7+1.
     3           7338719095133195d-4*t61*t7+1.6455307846020564d-2*gammab
     4           b*t2*t69+1.6089634338331218d-1*gammabb*t15*t62+1.082377
     5           3813698423d-4*t5*t60-1.802469135802469d-1*t41*t42*t43+1
     6           .4419753086419754d-1*t41**2-8.776164184544301d-2*gammab
     7           b*t31*t37
              t79 = 1/t3**4.0d+0
              t80 = 2.208607571445859d-2*t24*t61*t7*t79+1.24378109452736
     1           31d+0*t4*t78-4.9620033697117594d-1*gammabb*t24*t45*t62+
     2           2.7065472925700507d-1*gammabb*t31*t44*t45
              t81 = -7.481426920246762d-1*t1*t80-1.9950471787324697d+0*t
     1           27*t46
              t82 = 1/rhob**6.666666666666666d-1
              t83 = -4.1356699393293317d-1*t26-4.1356699393293317d-1
              t84 = 1/t25**3
              t85 = t46**2
              t86 = 1/rhob**5
              t87 = 3.10734375d-3*t35*t5*t66*t86-1.4565673828125d-4*gamm
     1           abb*t32*t33*t67*t68+1.553671875d-3*t10*t34*t35*t36+4.66
     2           10156249999996d-3*gammabb*t12*t32*t33*t35-9.9435d-2*gam
     3           mabb*t14*t32*t33
              t88 = 5.214967454807371d-3*t19*t8-1.0970205230680374d-2*t2
     1           *t38+2.9253880615147665d-2*t20*t31-3.0086350700811765d-
     2           4*gammabb*t30
              t89 = -2.25d-1*t20*t40*t88+3.375d-1*t20*t39*t49*t71-2.25d-
     1           1*t38*t40*t49+6.170740442257711d-3*t2*t39*t40+3.2910615
     2           692041123d-2*t22*t31-2.925388061514767d-2*t31
              t90 = -1.1249999999999999d-2*gammabb*t32*t33-1.44414483363
     1           8965d-3*gammabb*t30
              t91 = -9.012345679012345d-2*t23*t42*t90+1.4419753086419754
     1           d-1*t23*t89-1.802469135802469d-1*t17*t89+1.645530784602
     2           0564d-2*gammabb*t2*t87+4.5061728395061723d-2*t23*t43*t5
     3           1*t75-3.607924604566141d-5*t29*t7-9.012345679012345d-2*
     4           t41*t42*t51-9.012345679012345d-2*t42*t43*t50+1.44197530
     5           86419754d-1*t41*t50-4.3880820922721503d-2*gammabb*t31*t
     6           47+1.6455307846020564d-2*t2*t37-6.887544671719978d-3*ga
     7           mmabb*t32*t33-4.3880820922721503d-2*t15*t31-5.475384977
     8           410482d-5*gammabb*t30
              t92 = 1.2437810945273631d+0*t4*t91-8.282278392921971d-3*ga
     1           mmabb*t24*t30*t79+1.3532736462850253d-1*gammabb*t31*t45
     2           *t52-5.074776173568845d-2*t2*t44*t45+1.3532736462850253
     3           d-1*t24*t31*t45
              t93 = -7.481426920246762d-1*t1*t92-9.975235893662349d-1*t2
     1           7*t53
              t94 = -3.10734375d-3*t35*t63*t66*t7+1.4565673828125d-4*t33
     1           *t34*t67*t68-4.6610156249999996d-3*t12*t33*t34*t35+4.97
     2           175d-2*t14*t33*t34
              t95 = t49**2
              t96 = 3.375d-1*t20*t71*t95-1.3538857815365296d-4*t20*t40*t
     1           8+1.2341480884515421d-2*t2*t40*t49
              t97 = t51**2
              t98 = 2.70777156307306d-4*t8+5.625d-3*t33*t34
              t99 = -9.012345679012345d-2*t23*t42*t98+4.5061728395061723
     1           d-2*t23*t75*t97+1.4419753086419754d-1*t23*t96-1.8024691
     2           35802469d-1*t17*t96+1.6455307846020564d-2*gammabb*t2*t9
     3           4+1.0266346832644656d-5*t8+9.019811511415352d-6*gammabb
     4           *t6-1.802469135802469d-1*t42*t50*t51+1.4419753086419754
     5           d-1*t50**2+3.291061569204113d-2*t2*t47+3.44377233585998
     6           9d-3*t33*t34
              t100 = 1.2437810945273631d+0*t4*t99+3.10585439734574d-3*t2
     1           4*t79*t8-1.014955234713769d-1*t2*t45*t52
              t101 = t53**2
              t102 = 1/taub**5
              t103 = -3.10734375d-3*t102*t35*t64*t86+1.4565673828125d-4*
     1           t32*t54*t67*t68*t7-4.6610156249999996d-3*t12*t32*t35*t5
     2           4*t7+9.9435d-2*t14*t32*t54*t7-1.553671875d-3*gammabb*t3
     3           3*t34*t35*t36
              t104 = 2.406908056064941d-3*gammabb*t8-3.209210741419921d-
     1           2*t19*t48+8.7761641845443d-2*t18*t38-1.4626940307573832
     2           d-1*t2*t20
              t105 = 3.375d-1*t20*t39*t57*t71-2.25d-1*t38*t40*t57-4.9365
     1           923538061685d-2*t18*t39*t40-2.25d-1*t104*t20*t40-1.6455
     2           307846020562d-1*t2*t22
              t106 = -2.5347222222222215d-4*t23*t34*t43*t54*t7*t75+5.069
     1           444444444443d-4*t34*t41*t42*t54*t7-1.0138888888888886d-
     2           3*t23*t32*t42*t54*t7+6.887544671719978d-3*t32*t54*t7-9.
     3           012345679012345d-2*t42*t43*t58+1.4419753086419754d-1*t4
     4           1*t58-4.3880820922721503d-2*gammabb*t31*t55+1.441975308
     5           6419754d-1*t105*t23+1.6455307846020564d-2*gammabb*t103*
     6           t2-1.802469135802469d-1*t105*t17
              t107 = 1.3532736462850253d-1*gammabb*t31*t45*t59+1.2437810
     1           945273631d+0*t106*t4
              t108 = 1.553671875d-3*t33*t35*t36*t9-1.4565673828125d-4*ga
     1           mmabb*t34*t54*t67*t68+3.10734375d-3*t102*t35*t5*t63+4.6
     2           610156249999996d-3*gammabb*t12*t34*t35*t54-9.9435d-2*ga
     3           mmabb*t14*t34*t54
              t109 = 3.375d-1*t20*t49*t57*t71+6.170740442257711d-3*t2*t4
     1           0*t57-4.9365923538061685d-2*t18*t40*t49+1.0831086252292
     2           235d-3*t20*t40*t48
              t110 = -2.5347222222222215d-4*t23*t34*t51*t54*t7*t75+5.069
     1           444444444443d-4*t34*t42*t50*t54*t7-9.012345679012345d-2
     2           *t42*t51*t58+1.4419753086419754d-1*t50*t58+1.6455307846
     3           020564d-2*t2*t55+1.0138888888888886d-3*gammabb*t23*t34*
     4           t42*t54-6.887544671719978d-3*gammabb*t34*t54+1.44197530
     5           86419754d-1*t109*t23+1.6455307846020564d-2*gammabb*t108
     6           *t2-1.802469135802469d-1*t109*t17
              t111 = 1.2437810945273631d+0*t110*t4-5.074776173568845d-2*
     1           t2*t45*t59
              t112 = t59**2
              t113 = 1/taub**6
              t114 = -3.10734375d-3*gammabb*t35*t36*t54*t9+1.45656738281
     1           25d-4*t34*t66*t67*t68*t7-4.6610156249999996d-3*t12*t34*
     2           t35*t66*t7+1.491525d-1*t14*t34*t66*t7-3.10734375d-3*t11
     3           3*t35*t63*t64
              t115 = t57**2
              t116 = 3.375d-1*t115*t20*t71-9.873184707612337d-2*t18*t40*
     1           t57-8.664869001833788d-3*t20*t40*t56
              t117 = 1.4257812499999994d-6*t113*t23*t63*t64*t75-1.520833
     1           333333333d-3*t23*t34*t42*t66*t7+1.0331317007579968d-2*t
     2           34*t66*t7+1.0138888888888886d-3*t34*t42*t54*t58*t7+1.44
     3           19753086419754d-1*t58**2+1.4419753086419754d-1*t116*t23
     4           +1.6455307846020564d-2*gammabb*t114*t2-1.80246913580246
     5           9d-1*t116*t17
              t118 = 1/rhob**11
              t119 = 1/rhob**8.333333333333334d+0
              t120 = 1/rhob**5.666666666666667d+0
              t121 = gammabb**6
              t122 = 1/rhob**7
              t123 = 1/t13**5.0d+0
              t124 = t11**5.0d+0
              t125 = 1/t21**3.5d+0
              t126 = 8.044817169165608d-1*gammabb*t120-1.787737148703468
     1           2d+0*t19*t62
              t127 = 1.0125000000000002d+0*t20*t39*t71*t73-6.75d-1*t38*t
     1           40*t73-2.25d-1*t20*t40*(3.2910615692041123d-2*gammabb*t
     2           31*t72-2.194041046136075d-1*t19*t2*t72-1.75523283690886
     3           d-1*gammabb*t38*t62-7.150948594813873d-1*t19*t20*t62+5.
     4           850776123029533d-1*t19*t31*t38+3.217926867666243d-1*gam
     5           mabb*t120*t20+4.38808209227215d-2*t126*t18*t19)-6.75d-1
     6           *t39*t40*t72+1.0125000000000002d+0*t38*t70*t71-8.4375d-
     7           1*t125*t20*t39**3+4.5d-1*t126*t22-5.005664016369713d-1*
     8           gammabb*t120
              t128 = 1/t16**2.5d+0
              t129 = 1/t3**5.0d+0
              t130 = 1/t25**4
              t131 = gammabb**5
              t132 = 6.75d-1*t20*t39*t71*t88-4.5d-1*t38*t40*t88+3.375d-1
     1           *t20*t49*t71*t73+6.170740442257711d-3*t2*t40*t73-2.25d-
     2           1*t20*t40*(-1.0970205230680374d-2*t2*t72-1.072642289222
     3           081d-1*t20*t62+3.209210741419921d-3*gammabb*t61+5.85077
     4           6123029533d-2*t31*t38-2.781315975897265d-2*t19*t30)-2.2
     5           5d-1*t40*t49*t72-9.256110663386565d-3*t2*t70*t71+6.75d-
     6           1*t38*t39*t49*t71-8.4375d-1*t125*t20*t49*t70-1.20672257
     7           53748412d-1*t22*t62+1.0726422892220812d-1*t62-3.2910615
     8           692041123d-2*t31*t39*t40
              t133 = 3.375d-1*t38*t71*t95-8.4375d-1*t125*t20*t39*t95+6.7
     1           5d-1*t20*t49*t71*t88+1.2341480884515421d-2*t2*t40*t88+2
     2           .030828672304794d-4*t20*t39*t71*t8-1.3538857815365296d-
     3           4*t38*t40*t8-1.8512221326773132d-2*t2*t39*t49*t71-3.291
     4           0615692041123d-2*t31*t40*t49+7.220724168194822d-4*t20*t
     5           30*t40
              t134 = -2.77683319901597d-2*t2*t71*t95+6.092486016914382d-
     1           4*t20*t49*t71*t8+1.1139303661766865d-5*t40*t6-8.4375d-1
     2           *t125*t20*t49**3
              t135 = 1/taub**7
              t136 = -2.25d-1*t20*t40*(1.3906579879486325d-1*t19*t8+8.77
     1           61641845443d-2*t18*t72-2.9253880615147665d-1*t2*t38+3.9
     2           00517415353022d-1*t20*t31-2.0859869819229487d-2*gammabb
     3           *t30)+3.375d-1*t20*t57*t71*t73-4.9365923538061685d-2*t1
     4           8*t40*t73-2.25d-1*t40*t57*t72+7.404888530709253d-2*t18*
     5           t70*t71+6.75d-1*t38*t39*t57*t71+6.75d-1*t104*t20*t39*t7
     6           1-8.4375d-1*t125*t20*t57*t70+1.6455307846020562d-1*t2*t
     7           39*t40-4.5d-1*t104*t38*t40+4.38808209227215d-1*t22*t31
              t137 = 3.375d-1*t20*t57*t71*t88-4.9365923538061685d-2*t18*
     1           t40*t88-4.693470709326635d-3*t20*t40*t8+3.375d-1*t38*t4
     2           9*t57*t71-9.256110663386565d-3*t2*t39*t57*t71+7.4048885
     3           30709253d-2*t18*t39*t49*t71+3.375d-1*t104*t20*t49*t71-1
     4           .6246629378438354d-3*t20*t39*t48*t71-8.4375d-1*t125*t20
     5           *t39*t49*t57-1.6455307846020562d-2*t31*t40*t57+8.227653
     6           923010281d-2*t2*t40*t49+1.0831086252292235d-3*t38*t40*t
     7           48+6.170740442257711d-3*t104*t2*t40
              t138 = 7.404888530709253d-2*t18*t71*t95-8.4375d-1*t125*t20
     1           *t57*t95+2.030828672304794d-4*t20*t57*t71*t8-1.85122213
     2           26773132d-2*t2*t49*t57*t71-3.249325875687671d-3*t20*t48
     3           *t49*t71-8.911442929413492d-5*t122*t40
              t139 = 1/taub**8
              t140 = 1.4809777061418505d-1*t18*t39*t57*t71+6.75d-1*t104*
     1           t20*t57*t71+1.2997303502750684d-2*t20*t39*t56*t71+3.375
     2           d-1*t115*t38*t71+1.6455307846020562d-1*t2*t40*t57-8.664
     3           869001833788d-3*t38*t40*t56+2.888289667277929d-2*t20*t4
     4           0*t48-9.873184707612337d-2*t104*t18*t40-8.4375d-1*t115*
     5           t125*t20*t39
              t141 = 1.4809777061418505d-1*t18*t49*t57*t71-3.24932587568
     1           7671d-3*t20*t48*t57*t71+1.2997303502750684d-2*t20*t49*t
     2           56*t71-9.256110663386565d-3*t115*t2*t71+7.1291543435307
     3           94d-4*t40*t65-8.4375d-1*t115*t125*t20*t49
              t142 = 1/taub**9
              t143 = -5.703323474824635d-3*t40*t86+3.899191050825205d-2*
     1           t20*t56*t57*t71+2.2214665592127758d-1*t115*t18*t71-8.43
     2           75d-1*t125*t20*t57**3
              fnc(iq) = (-9.305257363490997d-1*t1*t26-9.305257363490997d
     1           -1*t1)*wght+fnc(iq)
              Amat(iq,D1_RB) = (-7.481426920246762d-1*t1*t28*t46-1.24070
     1           09817987995d+0*t26*t27-1.2407009817987995d+0*t27)*wght+
     2           Amat(iq,D1_RB)
              Cmat(iq,D1_GBB) = Cmat(iq,D1_GBB)-7.481426920246762d-1*t1*
     1           t28*t53*wght
              Mmat(iq,D1_TB) = Mmat(iq,D1_TB)-9.305257363490997d-1*t1*t2
     1           8*t4*t59*wght
              Mmat(iq,D1_TA) = Mmat(iq,D1_TA)
              Amat2(iq,D2_RB_RB) = (1.4962853840493523d+0*t1*t84*t85+t82
     1           *t83+t28*t81)*wght+Amat2(iq,D2_RB_RB)
              Cmat2(iq,D2_RB_GBB) = (t28*t93+1.4962853840493523d+0*t1*t4
     1           6*t53*t84)*wght+Cmat2(iq,D2_RB_GBB)
              Cmat2(iq,D2_GBB_GBB) = 1.4962853840493523d+0*t1*t101*t84*w
     1           ght-7.481426920246762d-1*t1*t100*t28*wght+Cmat2(iq,D2_G
     2           BB_GBB)
              Mmat2(iq,D2_RB_TA) = Mmat2(iq,D2_RB_TA)
              Mmat2(iq,D2_RB_TB) = (1.8610514726981991d+0*t1*t4*t46*t59*
     1           t84-1.2407009817987995d+0*t27*t28*t4*t59-7.481426920246
     2           762d-1*t1*t107*t28)*wght+Mmat2(iq,D2_RB_TB)
              Mmat2(iq,D2_GBB_TA) = Mmat2(iq,D2_GBB_TA)
              Mmat2(iq,D2_GBB_TB) = 1.8610514726981991d+0*t1*t4*t53*t59*
     1           t84*wght-7.481426920246762d-1*t1*t111*t28*wght+Mmat2(iq
     2           ,D2_GBB_TB)
              Mmat2(iq,D2_TA_TA) = Mmat2(iq,D2_TA_TA)
              Mmat2(iq,D2_TA_TB) = Mmat2(iq,D2_TA_TB)
              Mmat2(iq,D2_TB_TB) = 2.3147406376843277d+0*t1*t112*t79*t84
     1           *wght-9.305257363490997d-1*t1*t117*t28*t4*wght+Mmat2(iq
     2           ,D2_TB_TB)
              Amat3(iq,D3_RB_RB_RB) = (t28*(-7.481426920246762d-1*t1*(1.
     1           2437810945273631d+0*t4*(1.6455307846020564d-2*gammabb*t
     2           2*(-8.739404296874999d-4*t33*t67*t68*t7*t86+2.796609375
     3           d-2*t12*t33*t35*t7*t86-5.9661d-1*t14*t33*t7*t86-1.01959
     4           71679687499d-3*t36*t5*t54*t65*t67-2.913134765625d-4*t11
     5           3*t121*t29*t67+3.7288125d-2*t122*t35*t64*t66+1.82070922
     6           85156248d-5*t123*t124*t5*t54*t65+9.322031249999999d-3*g
     7           ammabb*t10*t35*t36*t63)-9.012345679012345d-2*t23*t42*(-
     8           6.75d-2*t33*t7*t86-3.3536252247838183d-2*t119*t7)-4.132
     9           526803031987d-2*t33*t7*t86+1.3518518518518516d-1*t23*t4
     :           3*t75*t77-2.703703703703703d-1*t41*t42*t77+1.3518518518
     ;           518516d-1*t41*t75*t76-2.703703703703703d-1*t42*t43*t74+
     <           4.3259259259259264d-1*t41*t74-1.2715060669764344d-3*t11
     =           9*t7-1.3164246276816452d-1*gammabb*t31*t69+4.8268903014
     >           99366d-1*gammabb*t37*t62-1.0823773813698424d-3*t118*t5-
     ?           6.759259259259258d-2*t128*t23*t43**3+1.4419753086419754
     @           d-1*t127*t23-1.802469135802469d-1*t127*t17-7.5084960245
     1           5457d-1*gammabb*t120*t15)+6.625822714337577d-2*t44*t61*
     2           t7*t79-2.4294683285904448d-1*t119*t24*t7*t79+4.05982093
     3           8855076d-1*gammabb*t31*t45*t78-1.4886010109135278d+0*ga
     4           mmabb*t44*t45*t62+4.80607147764859d-3*t118*t129*t24*t5+
     5           2.3156015725321547d+0*gammabb*t120*t24*t45)-6.650157262
     6           441565d-1*t46*t82-2.9925707680987046d+0*t27*t80)+t84*(1
     7           .9950471787324697d+0*t27*t85-2*t46*t81+2.99257076809870
     8           46d+0*t1*t46*t80)-6.666666666666666d-1*t18*t83-3.325078
     9           631220783d-1*t28*t46*t82-4.488856152148057d+0*t1*t130*t
     :           46**3)*wght+Amat3(iq,D3_RB_RB_RB)
              Cmat3(iq,D3_RB_RB_GBB) = (t84*(2.9925707680987046d+0*t1*t4
     1           6*t92-2*t53*t81)+t28*(-1.9950471787324697d+0*t27*t92-7.
     2           481426920246762d-1*t1*(2.7065472925700507d-1*gammabb*t3
     3           1*t45*t91+1.2437810945273631d+0*t4*(9.012345679012345d-
     4           2*t23*t43*t75*t90-1.802469135802469d-1*t41*t42*t90-1.80
     5           2469135802469d-1*t42*t43*t89+2.883950617283951d-1*t41*t
     6           89-8.776164184544301d-2*gammabb*t31*t87+1.6455307846020
     7           564d-2*gammabb*t2*(1.0195971679687499d-3*t36*t54*t67*t7
     8           *t86-1.8207092285156248d-5*t123*t124*t54*t7*t86+5.82626
     9           953125d-4*gammabb*t33*t63*t67*t68+2.913134765625d-4*t11
     :           3*t131*t6*t67-3.10734375d-2*t35*t5*t65*t66-1.86440625d-
     ;           2*gammabb*t12*t33*t35*t63+2.98305d-1*gammabb*t14*t33*t6
     <           3-3.10734375d-3*t10*t32*t35*t36)+4.5061728395061723d-2*
     =           t23*t51*t75*t77-9.012345679012345d-2*t42*t50*t77+4.5061
     >           728395061723d-2*t50*t75*t76-6.759259259259258d-2*t128*t
     ?           23*t51*t76+9.012345679012345d-2*t41*t43*t51*t75-9.01234
     @           5679012345d-2*t42*t51*t74+1.4419753086419754d-1*t50*t74
     1           +3.2471321441095274d-4*t60*t7+1.6455307846020564d-2*t2*
     2           t69-9.012345679012345d-2*t23*t42*(3.375d-2*gammabb*t33*
     3           t63+9.146250613046778d-3*gammabb*t61)+2.066263401515993
     4           6d-2*gammabb*t33*t63+1.6089634338331218d-1*gammabb*t47*
     5           t62+1.6089634338331218d-1*t15*t62+3.467743819026639d-4*
     6           gammabb*t61-8.776164184544301d-2*t31*t37+1.441975308641
     7           9754d-1*t132*t23-1.802469135802469d-1*t132*t17)+2.20860
     8           7571445859d-2*t52*t61*t7*t79+7.454050553629774d-2*gamma
     9           bb*t24*t61*t79-1.6564556785843942d-2*gammabb*t30*t44*t7
     :           9-5.074776173568845d-2*t2*t45*t78-1.8022768041182213d-3
     ;           *t129*t24*t60*t7-4.9620033697117594d-1*gammabb*t45*t52*
     <           t62-4.9620033697117594d-1*t24*t45*t62+2.706547292570050
     =           7d-1*t31*t44*t45))-4.488856152148057d+0*t1*t130*t53*t85
     >           -3.325078631220783d-1*t28*t53*t82)*wght+Cmat3(iq,D3_RB_
     ?           RB_GBB)
              Cmat3(iq,D3_RB_GBB_GBB) = (t28*(-7.481426920246762d-1*t1*(
     1           1.3532736462850253d-1*gammabb*t31*t45*t99+1.24378109452
     2           73631d+0*t4*(4.5061728395061723d-2*t23*t43*t75*t98-9.01
     3           2345679012345d-2*t41*t42*t98+4.5061728395061723d-2*t41*
     4           t75*t97-6.759259259259258d-2*t128*t23*t43*t97-9.0123456
     5           79012345d-2*t42*t43*t96+1.4419753086419754d-1*t41*t96-4
     6           .3880820922721503d-2*gammabb*t31*t94+9.012345679012345d
     7           -2*t23*t51*t75*t90-1.802469135802469d-1*t42*t50*t90-1.8
     8           02469135802469d-1*t42*t51*t89+2.883950617283951d-1*t50*
     9           t89+3.291061569204113d-2*t2*t87+1.6455307846020564d-2*g
     :           ammabb*t2*(2.485875d-2*t35*t66*t7*t86-2.913134765625d-4
     ;           *t32*t33*t67*t68-2.913134765625d-4*t113*t122*t64*t67-1.
     <           0195971679687499d-3*gammabb*t36*t54*t63*t67+1.820709228
     =           5156248d-5*gammabb*t123*t124*t54*t63+9.322031249999999d
     >           -3*t12*t32*t33*t35-9.9435d-2*t14*t32*t33)+9.01234567901
     ?           2345d-2*t43*t50*t51*t75-8.776164184544301d-2*t31*t47-9.
     @           012345679012345d-2*t23*(-1.1249999999999999d-2*t32*t33-
     1           1.444144833638965d-3*t30)*t42-6.887544671719978d-3*t32*
     2           t33-5.475384977410482d-5*t30-7.215849209132282d-5*gamma
     3           bb*t29+1.4419753086419754d-1*t133*t23-1.802469135802469
     4           d-1*t133*t17)-1.014955234713769d-1*t2*t45*t91+3.1058543
     5           9734574d-3*t44*t79*t8-1.6564556785843942d-2*gammabb*t30
     6           *t52*t79-1.6564556785843942d-2*t24*t30*t79+2.7065472925
     7           700507d-1*t31*t45*t52+6.758538015443329d-4*gammabb*t129
     8           *t24*t29)-9.975235893662349d-1*t100*t27)+t84*(-2*t53*t9
     9           3+1.4962853840493523d+0*t1*t53*t92+1.4962853840493523d+
     :           0*t1*t100*t46)-4.488856152148057d+0*t1*t101*t130*t46)*w
     ;           ght+Cmat3(iq,D3_RB_GBB_GBB)
              Cmat3(iq,D3_GBB_GBB_GBB) = -7.481426920246762d-1*t1*t28*(-
     1           1.5224328520706534d-1*t2*t45*t99+1.2437810945273631d+0*
     2           t4*(1.3518518518518516d-1*t23*t51*t75*t98-2.70370370370
     3           3703d-1*t42*t50*t98+1.3518518518518516d-1*t50*t75*t97-2
     4           .703703703703703d-1*t42*t51*t96+4.3259259259259264d-1*t
     5           50*t96+4.9365923538061696d-2*t2*t94+1.6455307846020564d
     6           -2*gammabb*t2*(2.913134765625d-4*t113*t5*t65*t67+1.0195
     7           971679687499d-3*t32*t36*t54*t67-1.86440625d-2*gammabb*t
     8           35*t63*t66-1.8207092285156248d-5*t123*t124*t32*t54)+9.0
     9           19811511415352d-6*t6-6.759259259259258d-2*t128*t23*t51*
     :           *3+1.4419753086419754d-1*t134*t23-1.802469135802469d-1*
     ;           t134*t17)+9.317563192037218d-3*t52*t79*t8-2.53445175579
     <           1249d-4*t129*t24*t6)*wght+4.488856152148057d+0*t1*t100*
     =           t53*t84*wght-4.488856152148057d+0*t1*t130*t53**3*wght+C
     >           mat3(iq,D3_GBB_GBB_GBB)
              Mmat3(iq,D3_RB_RB_TA) = Mmat3(iq,D3_RB_RB_TA)
              Mmat3(iq,D3_RB_RB_TB) = (t28*(-7.481426920246762d-1*t1*(1.
     1           2437810945273631d+0*t4*(1.6455307846020564d-2*gammabb*t
     2           2*(-1.0195971679687499d-3*t36*t5*t66*t67*t86+1.82070922
     3           85156248d-5*t123*t124*t5*t66*t86-5.82626953125d-4*t54*t
     4           63*t67*t68*t7+1.86440625d-2*t12*t35*t54*t63*t7-2.98305d
     5           -1*t14*t54*t63*t7-2.913134765625d-4*t121*t135*t6*t67+3.
     6           10734375d-2*t102*t35*t64*t65+3.10734375d-3*gammabb*t32*
     7           t33*t35*t36)-2.5347222222222215d-4*t23*t34*t54*t7*t75*t
     8           77-9.012345679012345d-2*t42*t58*t77+4.5061728395061723d
     9           -2*t58*t75*t76+3.802083333333333d-4*t128*t23*t34*t54*t7
     :           *t76-5.069444444444443d-4*t34*t41*t43*t54*t7*t75+1.0138
     ;           888888888886d-3*t23*t32*t43*t54*t7*t75+5.06944444444444
     <           3d-4*t34*t42*t54*t7*t74+1.4419753086419754d-1*t58*t74+3
     =           .0416666666666664d-3*t23*t42*t54*t63*t7-2.0662634015159
     >           936d-2*t54*t63*t7-2.0277777777777772d-3*t32*t41*t42*t54
     ?           *t7+1.6089634338331218d-1*gammabb*t55*t62-1.80246913580
     @           2469d-1*t105*t42*t43+2.883950617283951d-1*t105*t41-8.77
     1           6164184544301d-2*gammabb*t103*t31+1.4419753086419754d-1
     2           *t136*t23-1.802469135802469d-1*t136*t17)+2.208607571445
     3           859d-2*t59*t61*t7*t79-4.9620033697117594d-1*gammabb*t45
     4           *t59*t62+2.7065472925700507d-1*gammabb*t106*t31*t45)-1.
     5           9950471787324697d+0*t107*t27)-5.583154418094598d+0*t1*t
     6           130*t4*t59*t85-2.4875621890547261d+0*t4*t59*t81*t84+2.9
     7           925707680987046d+0*t1*t107*t46*t84-4.1356699393293317d-
     8           1*t28*t4*t59*t82)*wght+Mmat3(iq,D3_RB_RB_TB)
              Mmat3(iq,D3_RB_GBB_TA) = Mmat3(iq,D3_RB_GBB_TA)
              Mmat3(iq,D3_RB_GBB_TB) = (-2.4875621890547261d+0*t4*t59*t8
     1           4*t93+t28*(-7.481426920246762d-1*t1*(1.2437810945273631
     2           d+0*t4*(-2.5347222222222215d-4*t23*t34*t54*t7*t75*t90-9
     3           .012345679012345d-2*t42*t58*t90+5.069444444444443d-4*t3
     4           4*t42*t54*t7*t89+1.4419753086419754d-1*t58*t89+1.645530
     5           7846020564d-2*gammabb*t2*(-2.796609375d-2*t102*t35*t5*t
     6           86+1.0195971679687499d-3*t36*t63*t66*t67*t7-1.820709228
     7           5156248d-5*t123*t124*t63*t66*t7+4.369702148437499d-4*ga
     8           mmabb*t32*t54*t67*t68+2.913134765625d-4*t122*t131*t135*
     9           t67-1.3983046875d-2*gammabb*t12*t32*t35*t54+1.9887d-1*g
     :           ammabb*t14*t32*t54-1.553671875d-3*t33*t34*t35*t36)-2.53
     ;           47222222222215d-4*t34*t41*t51*t54*t7*t75+5.069444444444
     <           443d-4*t23*t32*t51*t54*t7*t75-2.5347222222222215d-4*t34
     =           *t43*t50*t54*t7*t75+4.5061728395061723d-2*t43*t51*t58*t
     >           75-5.069444444444443d-4*gammabb*t23*t34*t43*t54*t75+3.8
     ?           02083333333333d-4*t128*t23*t34*t43*t51*t54*t7-1.0138888
     @           888888886d-3*t32*t42*t50*t54*t7-4.3880820922721503d-2*t
     1           31*t55+1.0138888888888886d-3*gammabb*t34*t41*t42*t54-2.
     2           0277777777777772d-3*gammabb*t23*t32*t42*t54+1.377508934
     3           3439956d-2*gammabb*t32*t54-9.012345679012345d-2*t105*t4
     4           2*t51+1.4419753086419754d-1*t105*t50-9.012345679012345d
     5           -2*t109*t42*t43+1.4419753086419754d-1*t109*t41-4.388082
     6           0922721503d-2*gammabb*t108*t31+1.4419753086419754d-1*t1
     7           37*t23+1.6455307846020564d-2*t103*t2-1.802469135802469d
     8           -1*t137*t17)-8.282278392921971d-3*gammabb*t30*t59*t79+1
     9           .3532736462850253d-1*t31*t45*t59+1.3532736462850253d-1*
     :           gammabb*t110*t31*t45-5.074776173568845d-2*t106*t2*t45)-
     ;           9.975235893662349d-1*t111*t27)+(1.4962853840493523d+0*t
     <           1*t107*t53+1.4962853840493523d+0*t1*t111*t46)*t84-5.583
     =           154418094598d+0*t1*t130*t4*t46*t53*t59)*wght+Mmat3(iq,D
     >           3_RB_GBB_TB)
              Mmat3(iq,D3_GBB_GBB_TA) = Mmat3(iq,D3_GBB_GBB_TA)
              Mmat3(iq,D3_GBB_GBB_TB) = -7.481426920246762d-1*t1*t28*(1.
     1           2437810945273631d+0*t4*(-2.5347222222222215d-4*t23*t34*
     2           t54*t7*t75*t98-9.012345679012345d-2*t42*t58*t98+4.50617
     3           28395061723d-2*t58*t75*t97+3.802083333333333d-4*t128*t2
     4           3*t34*t54*t7*t97+5.069444444444443d-4*t34*t42*t54*t7*t9
     5           6+1.4419753086419754d-1*t58*t96-5.069444444444443d-4*t3
     6           4*t50*t51*t54*t7*t75-1.0138888888888886d-3*gammabb*t23*
     7           t34*t51*t54*t75+1.6455307846020564d-2*gammabb*t2*(2.485
     8           875d-2*t102*t35*t63*t7-2.913134765625d-4*t34*t54*t67*t6
     9           8-1.0195971679687499d-3*gammabb*t32*t36*t66*t67-2.91313
     :           4765625d-4*t135*t64*t65*t67+1.8207092285156248d-5*gamma
     ;           bb*t123*t124*t32*t66+9.322031249999999d-3*t12*t34*t35*t
     <           54-9.9435d-2*t14*t34*t54)+2.0277777777777772d-3*gammabb
     =           *t34*t42*t50*t54+1.0138888888888886d-3*t23*t34*t42*t54-
     >           6.887544671719978d-3*t34*t54-1.802469135802469d-1*t109*
     ?           t42*t51+2.883950617283951d-1*t109*t50+1.441975308641975
     @           4d-1*t138*t23+3.291061569204113d-2*t108*t2-1.8024691358
     1           02469d-1*t138*t17)+3.10585439734574d-3*t59*t79*t8-1.014
     2           955234713769d-1*t110*t2*t45)*wght+1.8610514726981991d+0
     3           *t1*t100*t4*t59*t84*wght+2.9925707680987046d+0*t1*t111*
     4           t53*t84*wght-5.583154418094598d+0*t1*t101*t130*t4*t59*w
     5           ght+Mmat3(iq,D3_GBB_GBB_TB)
              Mmat3(iq,D3_RB_TA_TA) = Mmat3(iq,D3_RB_TA_TA)
              Mmat3(iq,D3_RB_TA_TB) = Mmat3(iq,D3_RB_TA_TB)
              Mmat3(iq,D3_RB_TB_TB) = (-7.481426920246762d-1*t1*t28*(1.2
     1           437810945273631d+0*t4*(1.6455307846020564d-2*gammabb*t2
     2           *(3.10734375d-2*t113*t35*t64*t86-5.82626953125d-4*t32*t
     3           66*t67*t68*t7+1.86440625d-2*t12*t32*t35*t66*t7-2.98305d
     4           -1*t14*t32*t66*t7-1.0195971679687499d-3*t102*t36*t5*t63
     5           *t67-2.913134765625d-4*t121*t122*t139*t67+1.82070922851
     6           56248d-5*t102*t123*t124*t5*t63+3.10734375d-3*gammabb*t3
     7           4*t35*t36*t54)-5.703124999999998d-6*t113*t23*t64*t75*t8
     8           6+7.604166666666664d-4*t23*t34*t43*t66*t7*t75-5.0694444
     9           44444443d-4*t34*t43*t54*t58*t7*t75+1.4257812499999994d-
     :           6*t113*t41*t63*t64*t75-1.520833333333333d-3*t34*t41*t42
     ;           *t66*t7+3.041666666666666d-3*t23*t32*t42*t66*t7-2.06626
     <           34015159936d-2*t32*t66*t7-2.0277777777777772d-3*t32*t42
     =           *t54*t58*t7+1.0138888888888886d-3*t105*t34*t42*t54*t7-2
     >           .1386718749999997d-6*t113*t128*t23*t43*t63*t64+2.883950
     ?           617283951d-1*t105*t58-9.012345679012345d-2*t116*t42*t43
     @           +1.4419753086419754d-1*t116*t41-4.3880820922721503d-2*g
     1           ammabb*t114*t31+1.4419753086419754d-1*t140*t23-1.802469
     2           135802469d-1*t140*t17)+1.3532736462850253d-1*gammabb*t1
     3           17*t31*t45)+3.0863208502457695d+0*t112*t27*t79*t84+t4*(
     4           3.7221029453963983d+0*t1*t107*t59+1.8610514726981991d+0
     5           *t1*t117*t46)*t84-6.944221913052981d+0*t1*t112*t130*t46
     6           *t79-1.2407009817987995d+0*t117*t27*t28*t4)*wght+Mmat3(
     7           iq,D3_RB_TB_TB)
              Mmat3(iq,D3_GBB_TA_TA) = Mmat3(iq,D3_GBB_TA_TA)
              Mmat3(iq,D3_GBB_TA_TB) = Mmat3(iq,D3_GBB_TA_TB)
              Mmat3(iq,D3_GBB_TB_TB) = t4*t84*(3.7221029453963983d+0*t1*
     1           t111*t59*wght+1.8610514726981991d+0*t1*t117*t53*wght)-7
     2           .481426920246762d-1*t1*t28*(1.2437810945273631d+0*t4*(1
     3           .6455307846020564d-2*gammabb*t2*(-3.10734375d-3*t35*t36
     4           *t54*t9+1.0195971679687499d-3*t102*t32*t36*t67*t7-1.820
     5           7092285156248d-5*t102*t123*t124*t32*t7+5.82626953125d-4
     6           *gammabb*t34*t66*t67*t68+2.913134765625d-4*t131*t139*t6
     7           5*t67-1.86440625d-2*gammabb*t12*t34*t35*t66+2.98305d-1*
     8           gammabb*t14*t34*t66-3.10734375d-2*t113*t35*t5*t63)+7.60
     9           4166666666664d-4*t23*t34*t51*t66*t7*t75-5.0694444444444
     :           43d-4*t34*t51*t54*t58*t7*t75+1.4257812499999994d-6*t113
     ;           *t50*t63*t64*t75+5.703124999999998d-6*t113*t23*t5*t63*t
     <           75-1.520833333333333d-3*t34*t42*t50*t66*t7+1.0138888888
     =           888886d-3*t109*t34*t42*t54*t7-3.041666666666666d-3*gamm
     >           abb*t23*t34*t42*t66+2.0662634015159936d-2*gammabb*t34*t
     ?           66-2.1386718749999997d-6*t113*t128*t23*t51*t63*t64+2.02
     @           77777777777772d-3*gammabb*t34*t42*t54*t58+2.88395061728
     1           3951d-1*t109*t58-9.012345679012345d-2*t116*t42*t51+1.44
     2           19753086419754d-1*t116*t50+1.4419753086419754d-1*t141*t
     3           23+1.6455307846020564d-2*t114*t2-1.802469135802469d-1*t
     4           141*t17)-5.074776173568845d-2*t117*t2*t45)*wght-6.94422
     5           1913052981d+0*t1*t112*t130*t53*t79*wght+Mmat3(iq,D3_GBB
     6           _TB_TB)
              Mmat3(iq,D3_TA_TA_TA) = Mmat3(iq,D3_TA_TA_TA)
              Mmat3(iq,D3_TA_TA_TB) = Mmat3(iq,D3_TA_TA_TB)
              Mmat3(iq,D3_TA_TB_TB) = Mmat3(iq,D3_TA_TB_TB)
              Mmat3(iq,D3_TB_TB_TB) = -9.305257363490997d-1*t1*t28*t4*(1
     1           .6455307846020564d-2*gammabb*t2*(9.322031249999999d-3*g
     2           ammabb*t35*t36*t66*t9-8.739404296874999d-4*t102*t34*t67
     3           *t68*t7+2.796609375d-2*t102*t12*t34*t35*t7-5.9661d-1*t1
     4           02*t14*t34*t7-2.913134765625d-4*t121*t142*t65*t67-1.019
     5           5971679687499d-3*t113*t32*t36*t5*t67+3.7288125d-2*t135*
     6           t35*t63*t64+1.8207092285156248d-5*t113*t123*t124*t32*t5
     7           )+4.2773437499999983d-6*t113*t58*t63*t64*t75-1.28320312
     8           49999995d-5*t135*t23*t63*t64*t75-4.562499999999999d-3*t
     9           34*t42*t58*t66*t7+1.520833333333333d-3*t116*t34*t42*t54
     :           *t7+6.083333333333332d-3*t102*t23*t34*t42*t7-4.13252680
     ;           3031987d-2*t102*t34*t7+1.2030029296874996d-8*t121*t128*
     <           t142*t23*t65+4.3259259259259264d-1*t116*t58+1.441975308
     =           6419754d-1*t143*t23-1.802469135802469d-1*t143*t17)*wght
     >           +6.944221913052984d+0*t1*t117*t59*t79*t84*wght-8.637091
     ?           931657939d+0*t1*t130*t59**3*wght/t3**6.0d+0+Mmat3(iq,D3
     @           _TB_TB_TB)
            elseif (taua.gt.tol_rho.and.taub.le.tol_rho) then 
              t1 = rhob**1.3333333333333333d+0
              t2 = 1/rhob**1.6666666666666669d+0
              t3 = 1.0970205230680374d-51*t2-1.0d+0
              t4 = 4.3880820922721503d-52*t2*t3+1.0d+0
              t5 = 1/t4**5.0d-1
              t6 = 4.5d-1*t3*t5+4.3880820922721503d-52*t2
              t7 = 1/rhob**3.3333333333333337d+0
              t8 = 2.166217250458448d-103*t7+4.4999999999999996d-2
              t9 = t8**5.0d-1
              t10 = -1.802469135802469d-1*t6*t9+8.213077466115726d-105*t
     1           7+7.209876543209877d-2*t6**2+2.4881109353903252d-52*t2+
     2           9.621132278843042d-155/rhob**5+2.755017868687991d-2
              t11 = 8.160240087098705d-52*t2+1.0d+0
              t12 = 1/t11**2.0d+0
              t13 = 1.2437810945273631d+0*t10*t12+1.0d+0
              t14 = 8.04d-1-8.04d-1/t13
              t15 = rhob**3.333333333333333d-1
              t16 = 1/t13**2
              t17 = 1/rhob**4.333333333333333d+0
              t18 = 1/t9
              t19 = 1/rhob**2.6666666666666666d+0
              t20 = -7.313470153786917d-52*t19*t3-8.023026853549804d-103
     1           *t17
              t21 = 1/t4**1.5d+0
              t22 = -8.227653923010281d-52*t19*t5-2.25d-1*t20*t21*t3-7.3
     1           13470153786917d-52*t19
              t23 = -1.802469135802469d-1*t22*t9+1.4419753086419754d-1*t
     1           22*t6+6.507566225657065d-104*t17*t18*t6-4.1468515589838
     2           76d-52*t19-2.737692488705242d-104*t17-4.810566139421521
     3           d-154/rhob**6
              t24 = 1/t11**3.0d+0
              t25 = 3.3831841157125636d-51*t10*t19*t24+1.243781094527363
     1           1d+0*t12*t23
              t26 = -4.1356699393293317d-1*t14-4.1356699393293317d-1
              t27 = 1/rhob**6.666666666666666d-1
              t28 = 1/t13**3
              t29 = t25**2
              t30 = 1/t8**1.5d+0
              t31 = 1/rhob**8.666666666666666d+0
              t32 = 1/rhob**5.333333333333333d+0
              t33 = 1/rhob**3.6666666666666664d+0
              t34 = t20**2
              t35 = 1/t4**2.5d+0
              t36 = 1.9502587076765113d-51*t3*t33+4.8138161121298817d-10
     1           2*t32
              t37 = 2.194041046136075d-51*t33*t5-2.25d-1*t21*t3*t36+3.37
     1           5d-1*t3*t34*t35+1.9502587076765113d-51*t33+8.2276539230
     2           10281d-52*t19*t20*t21
              t38 = -1.802469135802469d-1*t37*t9+1.4419753086419754d-1*t
     1           37*t6-2.8199453644513944d-103*t18*t32*t6+2.349467036086
     2           518d-206*t30*t31*t6+1.1058270823957002d-51*t33+1.186333
     3           4117722714d-103*t32+1.4419753086419754d-1*t22**2+1.3015
     4           13245131413d-103*t17*t18*t22+2.886339683652913d-153/rho
     5           b**7
              t39 = 1/t11**4.0d+0
              t40 = 1.3803797321536623d-101*t10*t32*t39+1.24378109452736
     1           31d+0*t12*t38-9.021824308566837d-51*t10*t24*t33+6.76636
     2           8231425127d-51*t19*t23*t24
              t41 = -7.481426920246762d-1*t1*t40-1.9950471787324697d+0*t
     1           15*t25
              t42 = 1/rhob**8
              t43 = 1/rhob**6.333333333333333d+0
              t44 = 1/rhob**4.666666666666667d+0
              t45 = -8.044817169165608d-51*t44*t5-2.25d-1*t21*t3*(-7.150
     1           948594813874d-51*t3*t44-2.9239475644048174d-101*t43)-7.
     2           150948594813874d-51*t44-8.4375d-1*t20**3*t3/t4**3.5d+0+
     3           1.0125000000000002d+0*t20*t3*t35*t36+1.2341480884515423
     4           d-51*t19*t21*t36-1.8512221326773132d-51*t19*t34*t35-3.2
     5           910615692041123d-51*t20*t21*t33
              fnc(iq) = (-9.305257363490997d-1*t1*t14-9.305257363490997d
     1           -1*t1)*wght+fnc(iq)
              Amat(iq,D1_RB) = (-7.481426920246762d-1*t1*t16*t25-1.24070
     1           09817987995d+0*t14*t15-1.2407009817987995d+0*t15)*wght+
     2           Amat(iq,D1_RB)
              Cmat(iq,D1_GBB) = Cmat(iq,D1_GBB)
              Mmat(iq,D1_TB) = Mmat(iq,D1_TB)
              Mmat(iq,D1_TA) = Mmat(iq,D1_TA)
              Amat2(iq,D2_RB_RB) = (t16*t41+1.4962853840493523d+0*t1*t28
     1           *t29+t26*t27)*wght+Amat2(iq,D2_RB_RB)
              Cmat2(iq,D2_RB_GBB) = Cmat2(iq,D2_RB_GBB)
              Cmat2(iq,D2_GBB_GBB) = Cmat2(iq,D2_GBB_GBB)
              Mmat2(iq,D2_RB_TA) = Mmat2(iq,D2_RB_TA)
              Mmat2(iq,D2_RB_TB) = Mmat2(iq,D2_RB_TB)
              Mmat2(iq,D2_GBB_TA) = Mmat2(iq,D2_GBB_TA)
              Mmat2(iq,D2_GBB_TB) = Mmat2(iq,D2_GBB_TB)
              Mmat2(iq,D2_TA_TA) = Mmat2(iq,D2_TA_TA)
              Mmat2(iq,D2_TA_TB) = Mmat2(iq,D2_TA_TB)
              Mmat2(iq,D2_TB_TB) = Mmat2(iq,D2_TB_TB)
              Amat3(iq,D3_RB_RB_RB) = (t16*(-7.481426920246762d-1*t1*(1.
     1           2437810945273631d+0*t12*(-1.802469135802469d-1*t45*t9+2
     2           .544728011477048d-308*t6/(rhob**13*t8**2.5d+0)+1.441975
     3           3086419754d-1*t45*t6+1.5039708610407437d-102*t18*t43*t6
     4           -3.054307146912473d-205*t30*t6/rhob**9.666666666666666d
     5           +0-4.054699302117567d-51*t44-6.327111529452114d-103*t43
     6           -2.020437778557039d-152*t42+4.3259259259259264d-1*t22*t
     7           37+1.9522698676971195d-103*t17*t18*t37-8.45983609335418
     8           4d-103*t18*t22*t32+7.048401108259554d-206*t22*t30*t31)+
     9           3.308002246474507d-50*t10*t24*t44-1.1043037857229297d-1
     :           00*t10*t39*t43+7.509486683825926d-152*t10*t42/t11**5.0d
     ;           +0+4.1411391964609867d-101*t23*t32*t39+1.01495523471376
     <           91d-50*t19*t24*t38-2.706547292570051d-50*t23*t24*t33)-2
     =           .9925707680987046d+0*t15*t40-6.650157262441565d-1*t25*t
     >           27)+t28*(-2*t25*t41+2.9925707680987046d+0*t1*t25*t40+1.
     ?           9950471787324697d+0*t15*t29)-3.325078631220783d-1*t16*t
     @           25*t27-6.666666666666666d-1*t2*t26-4.488856152148057d+0
     1           *t1*t25**3/t13**4)*wght+Amat3(iq,D3_RB_RB_RB)
              Cmat3(iq,D3_RB_RB_GBB) = Cmat3(iq,D3_RB_RB_GBB)
              Cmat3(iq,D3_RB_GBB_GBB) = Cmat3(iq,D3_RB_GBB_GBB)
              Cmat3(iq,D3_GBB_GBB_GBB) = Cmat3(iq,D3_GBB_GBB_GBB)
              Mmat3(iq,D3_RB_RB_TA) = Mmat3(iq,D3_RB_RB_TA)
              Mmat3(iq,D3_RB_RB_TB) = Mmat3(iq,D3_RB_RB_TB)
              Mmat3(iq,D3_RB_GBB_TA) = Mmat3(iq,D3_RB_GBB_TA)
              Mmat3(iq,D3_RB_GBB_TB) = Mmat3(iq,D3_RB_GBB_TB)
              Mmat3(iq,D3_GBB_GBB_TA) = Mmat3(iq,D3_GBB_GBB_TA)
              Mmat3(iq,D3_GBB_GBB_TB) = Mmat3(iq,D3_GBB_GBB_TB)
              Mmat3(iq,D3_RB_TA_TA) = Mmat3(iq,D3_RB_TA_TA)
              Mmat3(iq,D3_RB_TA_TB) = Mmat3(iq,D3_RB_TA_TB)
              Mmat3(iq,D3_RB_TB_TB) = Mmat3(iq,D3_RB_TB_TB)
              Mmat3(iq,D3_GBB_TA_TA) = Mmat3(iq,D3_GBB_TA_TA)
              Mmat3(iq,D3_GBB_TA_TB) = Mmat3(iq,D3_GBB_TA_TB)
              Mmat3(iq,D3_GBB_TB_TB) = Mmat3(iq,D3_GBB_TB_TB)
              Mmat3(iq,D3_TA_TA_TA) = Mmat3(iq,D3_TA_TA_TA)
              Mmat3(iq,D3_TA_TA_TB) = Mmat3(iq,D3_TA_TA_TB)
              Mmat3(iq,D3_TA_TB_TB) = Mmat3(iq,D3_TA_TB_TB)
              Mmat3(iq,D3_TB_TB_TB) = Mmat3(iq,D3_TB_TB_TB)
            elseif (taua.le.tol_rho.and.taub.gt.tol_rho) then 
              t1 = rhob**1.3333333333333333d+0
              t2 = 1/rhob**2.6666666666666666d+0
              t3 = 2.040060021774676d-2*gammabb*t2+1.0d+0
              t4 = 1/t3**2.0d+0
              t5 = gammabb**3
              t6 = 1/rhob**8
              t7 = gammabb**2
              t8 = 1/rhob**5.333333333333333d+0
              t9 = 1/rhob
              t10 = 1/taub
              t11 = gammabb*t10*t9
              t12 = t11**2.0d+0
              t13 = 1.5625d-2*t12+1.0d+0
              t14 = 1/t13**2.0d+0
              t15 = 2.485875d-2*t12*t14+1.234567901234568d-1
              t16 = 1.35388578153653d-4*t7*t8+2.8125d-3*t12
              t17 = t16**5.0d-1
              t18 = 1/rhob**1.6666666666666669d+0
              t19 = 2.0d+0*taub-2.5d-1*gammabb*t9
              t20 = 1.0970205230680374d-1*t18*t19-1.0d+0
              t21 = 4.38808209227215d-2*t18*t19*t20+1.0d+0
              t22 = 1/t21**5.0d-1
              t23 = 4.5d-1*t20*t22+1.0970205230680376d-2*gammabb*t2
              t24 = 5.133173416322327d-6*t7*t8+1.5033019185692253d-6*t5*
     1           t6+7.209876543209877d-2*t23**2-1.802469135802469d-1*t17
     2           *t23+1.6455307846020564d-2*gammabb*t15*t2+1.72188616792
     3           99946d-3*t12
              t25 = 1.2437810945273631d+0*t24*t4+1.0d+0
              t26 = 8.04d-1-8.04d-1/t25
              t27 = rhob**3.333333333333333d-1
              t28 = 1/t25**2
              t29 = 1/rhob**9
              t30 = 1/rhob**6.333333333333333d+0
              t31 = 1/rhob**3.6666666666666664d+0
              t32 = 1/rhob**3
              t33 = 1/taub**2
              t34 = 1/rhob**2
              t35 = 1/t13**3.0d+0
              t36 = t11**3.0d+0
              t37 = 1.553671875d-3*gammabb*t10*t34*t35*t36-4.97175d-2*t1
     1           4*t32*t33*t7
              t38 = 2.7425513076700936d-2*gammabb*t31-1.828367538446729d
     1           -1*t19*t2
              t39 = 4.38808209227215d-2*t18*t19*t38+1.0970205230680374d-
     1           2*gammabb*t20*t31-7.313470153786916d-2*t19*t2*t20
              t40 = 1/t21**1.5d+0
              t41 = -2.25d-1*t20*t39*t40+4.5d-1*t22*t38-2.92538806151476
     1           7d-2*gammabb*t31
              t42 = 1/t17
              t43 = -5.625d-3*t32*t33*t7-7.220724168194825d-4*t30*t7
              t44 = -3.443772335859989d-3*t32*t33*t7-2.737692488705241d-
     1           5*t30*t7-1.2026415348553804d-5*t29*t5-9.012345679012345
     2           d-2*t23*t42*t43+1.4419753086419754d-1*t23*t41-1.8024691
     3           35802469d-1*t17*t41+1.6455307846020564d-2*gammabb*t2*t3
     4           7-4.3880820922721503d-2*gammabb*t15*t31
              t45 = 1/t3**3.0d+0
              t46 = 1.3532736462850253d-1*gammabb*t24*t31*t45+1.24378109
     1           45273631d+0*t4*t44
              t47 = 4.97175d-2*gammabb*t14*t33*t34-1.553671875d-3*t10*t3
     1           5*t36*t9
              t48 = 1/rhob**4.333333333333333d+0
              t49 = -1.2034540280324706d-3*t19*t48-1.0970205230680374d-2
     1           *t2*t20
              t50 = -2.25d-1*t20*t40*t49-1.2341480884515421d-2*t2*t22+1.
     1           0970205230680376d-2*t2
              t51 = 2.70777156307306d-4*gammabb*t8+5.625d-3*gammabb*t33*
     1           t34
              t52 = 1.0266346832644656d-5*gammabb*t8+4.509905755707676d-
     1           6*t6*t7-9.012345679012345d-2*t23*t42*t51+1.441975308641
     2           9754d-1*t23*t50-1.802469135802469d-1*t17*t50+1.64553078
     3           46020564d-2*gammabb*t2*t47+3.443772335859989d-3*gammabb
     4           *t33*t34+1.6455307846020564d-2*t15*t2
              t53 = 1.2437810945273631d+0*t4*t52-5.074776173568845d-2*t2
     1           *t24*t45
              t54 = 1/taub**3
              t55 = 1.553671875d-3*gammabb*t33*t35*t36*t9-4.97175d-2*t14
     1           *t34*t54*t7
              t56 = 1/rhob**3.3333333333333337d+0
              t57 = 9.627632224259765d-3*t19*t56+8.7761641845443d-2*t18*
     1           t20
              t58 = 9.873184707612337d-2*t18*t22-2.25d-1*t20*t40*t57
              t59 = 5.069444444444443d-4*t23*t34*t42*t54*t7-3.4437723358
     1           59989d-3*t34*t54*t7+1.4419753086419754d-1*t23*t58-1.802
     2           469135802469d-1*t17*t58+1.6455307846020564d-2*gammabb*t
     3           2*t55
              t60 = 1/rhob**10
              t61 = 1/rhob**7.333333333333333d+0
              t62 = 1/rhob**4.666666666666667d+0
              t63 = 1/rhob**4
              t64 = gammabb**4
              t65 = 1/rhob**6
              t66 = 1/taub**4
              t67 = 1/t13**4.0d+0
              t68 = t11**4.0d+0
              t69 = 1.4565673828125d-4*t33*t63*t67*t68*t7-4.661015624999
     1           9996d-3*t12*t33*t35*t63*t7+1.491525d-1*t14*t33*t63*t7-3
     2           .10734375d-3*t35*t64*t65*t66-3.10734375d-3*gammabb*t10*
     3           t32*t35*t36
              t70 = t39**2
              t71 = 1/t21**2.5d+0
              t72 = 4.8756467691912775d-1*t19*t31-1.4626940307573832d-1*
     1           gammabb*t62
              t73 = 4.38808209227215d-2*t18*t19*t72-5.850776123029533d-2
     1           *gammabb*t20*t62+2.194041046136075d-2*gammabb*t31*t38-1
     2           .4626940307573832d-1*t19*t2*t38+1.950258707676511d-1*t1
     3           9*t20*t31
              t74 = -2.25d-1*t20*t40*t73+4.5d-1*t22*t72+3.375d-1*t20*t70
     1           *t71+1.0726422892220812d-1*gammabb*t62-4.5d-1*t38*t39*t
     2           40
              t75 = 1/t16**1.5d+0
              t76 = t43**2
              t77 = 1.6875d-2*t33*t63*t7+4.573125306523389d-3*t61*t7
              t78 = -9.012345679012345d-2*t23*t42*t77+4.5061728395061723
     1           d-2*t23*t75*t76+1.4419753086419754d-1*t23*t74-1.8024691
     2           35802469d-1*t17*t74+1.0331317007579968d-2*t33*t63*t7+1.
     3           7338719095133195d-4*t61*t7+1.6455307846020564d-2*gammab
     4           b*t2*t69+1.6089634338331218d-1*gammabb*t15*t62+1.082377
     5           3813698423d-4*t5*t60-1.802469135802469d-1*t41*t42*t43+1
     6           .4419753086419754d-1*t41**2-8.776164184544301d-2*gammab
     7           b*t31*t37
              t79 = 1/t3**4.0d+0
              t80 = 2.208607571445859d-2*t24*t61*t7*t79+1.24378109452736
     1           31d+0*t4*t78-4.9620033697117594d-1*gammabb*t24*t45*t62+
     2           2.7065472925700507d-1*gammabb*t31*t44*t45
              t81 = -7.481426920246762d-1*t1*t80-1.9950471787324697d+0*t
     1           27*t46
              t82 = 1/rhob**6.666666666666666d-1
              t83 = -4.1356699393293317d-1*t26-4.1356699393293317d-1
              t84 = 1/t25**3
              t85 = t46**2
              t86 = 1/rhob**5
              t87 = 3.10734375d-3*t35*t5*t66*t86-1.4565673828125d-4*gamm
     1           abb*t32*t33*t67*t68+1.553671875d-3*t10*t34*t35*t36+4.66
     2           10156249999996d-3*gammabb*t12*t32*t33*t35-9.9435d-2*gam
     3           mabb*t14*t32*t33
              t88 = 5.214967454807371d-3*t19*t8-1.0970205230680374d-2*t2
     1           *t38+2.9253880615147665d-2*t20*t31-3.0086350700811765d-
     2           4*gammabb*t30
              t89 = -2.25d-1*t20*t40*t88+3.375d-1*t20*t39*t49*t71-2.25d-
     1           1*t38*t40*t49+6.170740442257711d-3*t2*t39*t40+3.2910615
     2           692041123d-2*t22*t31-2.925388061514767d-2*t31
              t90 = -1.1249999999999999d-2*gammabb*t32*t33-1.44414483363
     1           8965d-3*gammabb*t30
              t91 = -9.012345679012345d-2*t23*t42*t90+1.4419753086419754
     1           d-1*t23*t89-1.802469135802469d-1*t17*t89+1.645530784602
     2           0564d-2*gammabb*t2*t87+4.5061728395061723d-2*t23*t43*t5
     3           1*t75-3.607924604566141d-5*t29*t7-9.012345679012345d-2*
     4           t41*t42*t51-9.012345679012345d-2*t42*t43*t50+1.44197530
     5           86419754d-1*t41*t50-4.3880820922721503d-2*gammabb*t31*t
     6           47+1.6455307846020564d-2*t2*t37-6.887544671719978d-3*ga
     7           mmabb*t32*t33-4.3880820922721503d-2*t15*t31-5.475384977
     8           410482d-5*gammabb*t30
              t92 = 1.2437810945273631d+0*t4*t91-8.282278392921971d-3*ga
     1           mmabb*t24*t30*t79+1.3532736462850253d-1*gammabb*t31*t45
     2           *t52-5.074776173568845d-2*t2*t44*t45+1.3532736462850253
     3           d-1*t24*t31*t45
              t93 = -7.481426920246762d-1*t1*t92-9.975235893662349d-1*t2
     1           7*t53
              t94 = -3.10734375d-3*t35*t63*t66*t7+1.4565673828125d-4*t33
     1           *t34*t67*t68-4.6610156249999996d-3*t12*t33*t34*t35+4.97
     2           175d-2*t14*t33*t34
              t95 = t49**2
              t96 = 3.375d-1*t20*t71*t95-1.3538857815365296d-4*t20*t40*t
     1           8+1.2341480884515421d-2*t2*t40*t49
              t97 = t51**2
              t98 = 2.70777156307306d-4*t8+5.625d-3*t33*t34
              t99 = -9.012345679012345d-2*t23*t42*t98+4.5061728395061723
     1           d-2*t23*t75*t97+1.4419753086419754d-1*t23*t96-1.8024691
     2           35802469d-1*t17*t96+1.6455307846020564d-2*gammabb*t2*t9
     3           4+1.0266346832644656d-5*t8+9.019811511415352d-6*gammabb
     4           *t6-1.802469135802469d-1*t42*t50*t51+1.4419753086419754
     5           d-1*t50**2+3.291061569204113d-2*t2*t47+3.44377233585998
     6           9d-3*t33*t34
              t100 = 1.2437810945273631d+0*t4*t99+3.10585439734574d-3*t2
     1           4*t79*t8-1.014955234713769d-1*t2*t45*t52
              t101 = t53**2
              t102 = 1/taub**5
              t103 = -3.10734375d-3*t102*t35*t64*t86+1.4565673828125d-4*
     1           t32*t54*t67*t68*t7-4.6610156249999996d-3*t12*t32*t35*t5
     2           4*t7+9.9435d-2*t14*t32*t54*t7-1.553671875d-3*gammabb*t3
     3           3*t34*t35*t36
              t104 = 2.406908056064941d-3*gammabb*t8-3.209210741419921d-
     1           2*t19*t48+8.7761641845443d-2*t18*t38-1.4626940307573832
     2           d-1*t2*t20
              t105 = 3.375d-1*t20*t39*t57*t71-2.25d-1*t38*t40*t57-4.9365
     1           923538061685d-2*t18*t39*t40-2.25d-1*t104*t20*t40-1.6455
     2           307846020562d-1*t2*t22
              t106 = -2.5347222222222215d-4*t23*t34*t43*t54*t7*t75+5.069
     1           444444444443d-4*t34*t41*t42*t54*t7-1.0138888888888886d-
     2           3*t23*t32*t42*t54*t7+6.887544671719978d-3*t32*t54*t7-9.
     3           012345679012345d-2*t42*t43*t58+1.4419753086419754d-1*t4
     4           1*t58-4.3880820922721503d-2*gammabb*t31*t55+1.441975308
     5           6419754d-1*t105*t23+1.6455307846020564d-2*gammabb*t103*
     6           t2-1.802469135802469d-1*t105*t17
              t107 = 1.3532736462850253d-1*gammabb*t31*t45*t59+1.2437810
     1           945273631d+0*t106*t4
              t108 = 1.553671875d-3*t33*t35*t36*t9-1.4565673828125d-4*ga
     1           mmabb*t34*t54*t67*t68+3.10734375d-3*t102*t35*t5*t63+4.6
     2           610156249999996d-3*gammabb*t12*t34*t35*t54-9.9435d-2*ga
     3           mmabb*t14*t34*t54
              t109 = 3.375d-1*t20*t49*t57*t71+6.170740442257711d-3*t2*t4
     1           0*t57-4.9365923538061685d-2*t18*t40*t49+1.0831086252292
     2           235d-3*t20*t40*t48
              t110 = -2.5347222222222215d-4*t23*t34*t51*t54*t7*t75+5.069
     1           444444444443d-4*t34*t42*t50*t54*t7-9.012345679012345d-2
     2           *t42*t51*t58+1.4419753086419754d-1*t50*t58+1.6455307846
     3           020564d-2*t2*t55+1.0138888888888886d-3*gammabb*t23*t34*
     4           t42*t54-6.887544671719978d-3*gammabb*t34*t54+1.44197530
     5           86419754d-1*t109*t23+1.6455307846020564d-2*gammabb*t108
     6           *t2-1.802469135802469d-1*t109*t17
              t111 = 1.2437810945273631d+0*t110*t4-5.074776173568845d-2*
     1           t2*t45*t59
              t112 = t59**2
              t113 = 1/taub**6
              t114 = -3.10734375d-3*gammabb*t35*t36*t54*t9+1.45656738281
     1           25d-4*t34*t66*t67*t68*t7-4.6610156249999996d-3*t12*t34*
     2           t35*t66*t7+1.491525d-1*t14*t34*t66*t7-3.10734375d-3*t11
     3           3*t35*t63*t64
              t115 = t57**2
              t116 = 3.375d-1*t115*t20*t71-9.873184707612337d-2*t18*t40*
     1           t57-8.664869001833788d-3*t20*t40*t56
              t117 = 1.4257812499999994d-6*t113*t23*t63*t64*t75-1.520833
     1           333333333d-3*t23*t34*t42*t66*t7+1.0331317007579968d-2*t
     2           34*t66*t7+1.0138888888888886d-3*t34*t42*t54*t58*t7+1.44
     3           19753086419754d-1*t58**2+1.4419753086419754d-1*t116*t23
     4           +1.6455307846020564d-2*gammabb*t114*t2-1.80246913580246
     5           9d-1*t116*t17
              t118 = 1/rhob**11
              t119 = 1/rhob**8.333333333333334d+0
              t120 = 1/rhob**5.666666666666667d+0
              t121 = gammabb**6
              t122 = 1/rhob**7
              t123 = 1/t13**5.0d+0
              t124 = t11**5.0d+0
              t125 = 1/t21**3.5d+0
              t126 = 8.044817169165608d-1*gammabb*t120-1.787737148703468
     1           2d+0*t19*t62
              t127 = 1.0125000000000002d+0*t20*t39*t71*t73-6.75d-1*t38*t
     1           40*t73-2.25d-1*t20*t40*(3.2910615692041123d-2*gammabb*t
     2           31*t72-2.194041046136075d-1*t19*t2*t72-1.75523283690886
     3           d-1*gammabb*t38*t62-7.150948594813873d-1*t19*t20*t62+5.
     4           850776123029533d-1*t19*t31*t38+3.217926867666243d-1*gam
     5           mabb*t120*t20+4.38808209227215d-2*t126*t18*t19)-6.75d-1
     6           *t39*t40*t72+1.0125000000000002d+0*t38*t70*t71-8.4375d-
     7           1*t125*t20*t39**3+4.5d-1*t126*t22-5.005664016369713d-1*
     8           gammabb*t120
              t128 = 1/t16**2.5d+0
              t129 = 1/t3**5.0d+0
              t130 = 1/t25**4
              t131 = gammabb**5
              t132 = 6.75d-1*t20*t39*t71*t88-4.5d-1*t38*t40*t88+3.375d-1
     1           *t20*t49*t71*t73+6.170740442257711d-3*t2*t40*t73-2.25d-
     2           1*t20*t40*(-1.0970205230680374d-2*t2*t72-1.072642289222
     3           081d-1*t20*t62+3.209210741419921d-3*gammabb*t61+5.85077
     4           6123029533d-2*t31*t38-2.781315975897265d-2*t19*t30)-2.2
     5           5d-1*t40*t49*t72-9.256110663386565d-3*t2*t70*t71+6.75d-
     6           1*t38*t39*t49*t71-8.4375d-1*t125*t20*t49*t70-1.20672257
     7           53748412d-1*t22*t62+1.0726422892220812d-1*t62-3.2910615
     8           692041123d-2*t31*t39*t40
              t133 = 3.375d-1*t38*t71*t95-8.4375d-1*t125*t20*t39*t95+6.7
     1           5d-1*t20*t49*t71*t88+1.2341480884515421d-2*t2*t40*t88+2
     2           .030828672304794d-4*t20*t39*t71*t8-1.3538857815365296d-
     3           4*t38*t40*t8-1.8512221326773132d-2*t2*t39*t49*t71-3.291
     4           0615692041123d-2*t31*t40*t49+7.220724168194822d-4*t20*t
     5           30*t40
              t134 = -2.77683319901597d-2*t2*t71*t95+6.092486016914382d-
     1           4*t20*t49*t71*t8+1.1139303661766865d-5*t40*t6-8.4375d-1
     2           *t125*t20*t49**3
              t135 = 1/taub**7
              t136 = -2.25d-1*t20*t40*(1.3906579879486325d-1*t19*t8+8.77
     1           61641845443d-2*t18*t72-2.9253880615147665d-1*t2*t38+3.9
     2           00517415353022d-1*t20*t31-2.0859869819229487d-2*gammabb
     3           *t30)+3.375d-1*t20*t57*t71*t73-4.9365923538061685d-2*t1
     4           8*t40*t73-2.25d-1*t40*t57*t72+7.404888530709253d-2*t18*
     5           t70*t71+6.75d-1*t38*t39*t57*t71+6.75d-1*t104*t20*t39*t7
     6           1-8.4375d-1*t125*t20*t57*t70+1.6455307846020562d-1*t2*t
     7           39*t40-4.5d-1*t104*t38*t40+4.38808209227215d-1*t22*t31
              t137 = 3.375d-1*t20*t57*t71*t88-4.9365923538061685d-2*t18*
     1           t40*t88-4.693470709326635d-3*t20*t40*t8+3.375d-1*t38*t4
     2           9*t57*t71-9.256110663386565d-3*t2*t39*t57*t71+7.4048885
     3           30709253d-2*t18*t39*t49*t71+3.375d-1*t104*t20*t49*t71-1
     4           .6246629378438354d-3*t20*t39*t48*t71-8.4375d-1*t125*t20
     5           *t39*t49*t57-1.6455307846020562d-2*t31*t40*t57+8.227653
     6           923010281d-2*t2*t40*t49+1.0831086252292235d-3*t38*t40*t
     7           48+6.170740442257711d-3*t104*t2*t40
              t138 = 7.404888530709253d-2*t18*t71*t95-8.4375d-1*t125*t20
     1           *t57*t95+2.030828672304794d-4*t20*t57*t71*t8-1.85122213
     2           26773132d-2*t2*t49*t57*t71-3.249325875687671d-3*t20*t48
     3           *t49*t71-8.911442929413492d-5*t122*t40
              t139 = 1/taub**8
              t140 = 1.4809777061418505d-1*t18*t39*t57*t71+6.75d-1*t104*
     1           t20*t57*t71+1.2997303502750684d-2*t20*t39*t56*t71+3.375
     2           d-1*t115*t38*t71+1.6455307846020562d-1*t2*t40*t57-8.664
     3           869001833788d-3*t38*t40*t56+2.888289667277929d-2*t20*t4
     4           0*t48-9.873184707612337d-2*t104*t18*t40-8.4375d-1*t115*
     5           t125*t20*t39
              t141 = 1.4809777061418505d-1*t18*t49*t57*t71-3.24932587568
     1           7671d-3*t20*t48*t57*t71+1.2997303502750684d-2*t20*t49*t
     2           56*t71-9.256110663386565d-3*t115*t2*t71+7.1291543435307
     3           94d-4*t40*t65-8.4375d-1*t115*t125*t20*t49
              t142 = 1/taub**9
              t143 = -5.703323474824635d-3*t40*t86+3.899191050825205d-2*
     1           t20*t56*t57*t71+2.2214665592127758d-1*t115*t18*t71-8.43
     2           75d-1*t125*t20*t57**3
              fnc(iq) = (-9.305257363490997d-1*t1*t26-9.305257363490997d
     1           -1*t1)*wght+fnc(iq)
              Amat(iq,D1_RB) = (-7.481426920246762d-1*t1*t28*t46-1.24070
     1           09817987995d+0*t26*t27-1.2407009817987995d+0*t27)*wght+
     2           Amat(iq,D1_RB)
              Cmat(iq,D1_GBB) = Cmat(iq,D1_GBB)-7.481426920246762d-1*t1*
     1           t28*t53*wght
              Mmat(iq,D1_TB) = Mmat(iq,D1_TB)-9.305257363490997d-1*t1*t2
     1           8*t4*t59*wght
              Mmat(iq,D1_TA) = Mmat(iq,D1_TA)
              Amat2(iq,D2_RB_RB) = (1.4962853840493523d+0*t1*t84*t85+t82
     1           *t83+t28*t81)*wght+Amat2(iq,D2_RB_RB)
              Cmat2(iq,D2_RB_GBB) = (t28*t93+1.4962853840493523d+0*t1*t4
     1           6*t53*t84)*wght+Cmat2(iq,D2_RB_GBB)
              Cmat2(iq,D2_GBB_GBB) = 1.4962853840493523d+0*t1*t101*t84*w
     1           ght-7.481426920246762d-1*t1*t100*t28*wght+Cmat2(iq,D2_G
     2           BB_GBB)
              Mmat2(iq,D2_RB_TA) = Mmat2(iq,D2_RB_TA)
              Mmat2(iq,D2_RB_TB) = (1.8610514726981991d+0*t1*t4*t46*t59*
     1           t84-1.2407009817987995d+0*t27*t28*t4*t59-7.481426920246
     2           762d-1*t1*t107*t28)*wght+Mmat2(iq,D2_RB_TB)
              Mmat2(iq,D2_GBB_TA) = Mmat2(iq,D2_GBB_TA)
              Mmat2(iq,D2_GBB_TB) = 1.8610514726981991d+0*t1*t4*t53*t59*
     1           t84*wght-7.481426920246762d-1*t1*t111*t28*wght+Mmat2(iq
     2           ,D2_GBB_TB)
              Mmat2(iq,D2_TA_TA) = Mmat2(iq,D2_TA_TA)
              Mmat2(iq,D2_TA_TB) = Mmat2(iq,D2_TA_TB)
              Mmat2(iq,D2_TB_TB) = 2.3147406376843277d+0*t1*t112*t79*t84
     1           *wght-9.305257363490997d-1*t1*t117*t28*t4*wght+Mmat2(iq
     2           ,D2_TB_TB)
              Amat3(iq,D3_RB_RB_RB) = (t28*(-7.481426920246762d-1*t1*(1.
     1           2437810945273631d+0*t4*(1.6455307846020564d-2*gammabb*t
     2           2*(-8.739404296874999d-4*t33*t67*t68*t7*t86+2.796609375
     3           d-2*t12*t33*t35*t7*t86-5.9661d-1*t14*t33*t7*t86-1.01959
     4           71679687499d-3*t36*t5*t54*t65*t67-2.913134765625d-4*t11
     5           3*t121*t29*t67+3.7288125d-2*t122*t35*t64*t66+1.82070922
     6           85156248d-5*t123*t124*t5*t54*t65+9.322031249999999d-3*g
     7           ammabb*t10*t35*t36*t63)-9.012345679012345d-2*t23*t42*(-
     8           6.75d-2*t33*t7*t86-3.3536252247838183d-2*t119*t7)-4.132
     9           526803031987d-2*t33*t7*t86+1.3518518518518516d-1*t23*t4
     :           3*t75*t77-2.703703703703703d-1*t41*t42*t77+1.3518518518
     ;           518516d-1*t41*t75*t76-2.703703703703703d-1*t42*t43*t74+
     <           4.3259259259259264d-1*t41*t74-1.2715060669764344d-3*t11
     =           9*t7-1.3164246276816452d-1*gammabb*t31*t69+4.8268903014
     >           99366d-1*gammabb*t37*t62-1.0823773813698424d-3*t118*t5-
     ?           6.759259259259258d-2*t128*t23*t43**3+1.4419753086419754
     @           d-1*t127*t23-1.802469135802469d-1*t127*t17-7.5084960245
     1           5457d-1*gammabb*t120*t15)+6.625822714337577d-2*t44*t61*
     2           t7*t79-2.4294683285904448d-1*t119*t24*t7*t79+4.05982093
     3           8855076d-1*gammabb*t31*t45*t78-1.4886010109135278d+0*ga
     4           mmabb*t44*t45*t62+4.80607147764859d-3*t118*t129*t24*t5+
     5           2.3156015725321547d+0*gammabb*t120*t24*t45)-6.650157262
     6           441565d-1*t46*t82-2.9925707680987046d+0*t27*t80)+t84*(1
     7           .9950471787324697d+0*t27*t85-2*t46*t81+2.99257076809870
     8           46d+0*t1*t46*t80)-6.666666666666666d-1*t18*t83-3.325078
     9           631220783d-1*t28*t46*t82-4.488856152148057d+0*t1*t130*t
     :           46**3)*wght+Amat3(iq,D3_RB_RB_RB)
              Cmat3(iq,D3_RB_RB_GBB) = (t84*(2.9925707680987046d+0*t1*t4
     1           6*t92-2*t53*t81)+t28*(-1.9950471787324697d+0*t27*t92-7.
     2           481426920246762d-1*t1*(2.7065472925700507d-1*gammabb*t3
     3           1*t45*t91+1.2437810945273631d+0*t4*(9.012345679012345d-
     4           2*t23*t43*t75*t90-1.802469135802469d-1*t41*t42*t90-1.80
     5           2469135802469d-1*t42*t43*t89+2.883950617283951d-1*t41*t
     6           89-8.776164184544301d-2*gammabb*t31*t87+1.6455307846020
     7           564d-2*gammabb*t2*(1.0195971679687499d-3*t36*t54*t67*t7
     8           *t86-1.8207092285156248d-5*t123*t124*t54*t7*t86+5.82626
     9           953125d-4*gammabb*t33*t63*t67*t68+2.913134765625d-4*t11
     :           3*t131*t6*t67-3.10734375d-2*t35*t5*t65*t66-1.86440625d-
     ;           2*gammabb*t12*t33*t35*t63+2.98305d-1*gammabb*t14*t33*t6
     <           3-3.10734375d-3*t10*t32*t35*t36)+4.5061728395061723d-2*
     =           t23*t51*t75*t77-9.012345679012345d-2*t42*t50*t77+4.5061
     >           728395061723d-2*t50*t75*t76-6.759259259259258d-2*t128*t
     ?           23*t51*t76+9.012345679012345d-2*t41*t43*t51*t75-9.01234
     @           5679012345d-2*t42*t51*t74+1.4419753086419754d-1*t50*t74
     1           +3.2471321441095274d-4*t60*t7+1.6455307846020564d-2*t2*
     2           t69-9.012345679012345d-2*t23*t42*(3.375d-2*gammabb*t33*
     3           t63+9.146250613046778d-3*gammabb*t61)+2.066263401515993
     4           6d-2*gammabb*t33*t63+1.6089634338331218d-1*gammabb*t47*
     5           t62+1.6089634338331218d-1*t15*t62+3.467743819026639d-4*
     6           gammabb*t61-8.776164184544301d-2*t31*t37+1.441975308641
     7           9754d-1*t132*t23-1.802469135802469d-1*t132*t17)+2.20860
     8           7571445859d-2*t52*t61*t7*t79+7.454050553629774d-2*gamma
     9           bb*t24*t61*t79-1.6564556785843942d-2*gammabb*t30*t44*t7
     :           9-5.074776173568845d-2*t2*t45*t78-1.8022768041182213d-3
     ;           *t129*t24*t60*t7-4.9620033697117594d-1*gammabb*t45*t52*
     <           t62-4.9620033697117594d-1*t24*t45*t62+2.706547292570050
     =           7d-1*t31*t44*t45))-4.488856152148057d+0*t1*t130*t53*t85
     >           -3.325078631220783d-1*t28*t53*t82)*wght+Cmat3(iq,D3_RB_
     ?           RB_GBB)
              Cmat3(iq,D3_RB_GBB_GBB) = (t28*(-7.481426920246762d-1*t1*(
     1           1.3532736462850253d-1*gammabb*t31*t45*t99+1.24378109452
     2           73631d+0*t4*(4.5061728395061723d-2*t23*t43*t75*t98-9.01
     3           2345679012345d-2*t41*t42*t98+4.5061728395061723d-2*t41*
     4           t75*t97-6.759259259259258d-2*t128*t23*t43*t97-9.0123456
     5           79012345d-2*t42*t43*t96+1.4419753086419754d-1*t41*t96-4
     6           .3880820922721503d-2*gammabb*t31*t94+9.012345679012345d
     7           -2*t23*t51*t75*t90-1.802469135802469d-1*t42*t50*t90-1.8
     8           02469135802469d-1*t42*t51*t89+2.883950617283951d-1*t50*
     9           t89+3.291061569204113d-2*t2*t87+1.6455307846020564d-2*g
     :           ammabb*t2*(2.485875d-2*t35*t66*t7*t86-2.913134765625d-4
     ;           *t32*t33*t67*t68-2.913134765625d-4*t113*t122*t64*t67-1.
     <           0195971679687499d-3*gammabb*t36*t54*t63*t67+1.820709228
     =           5156248d-5*gammabb*t123*t124*t54*t63+9.322031249999999d
     >           -3*t12*t32*t33*t35-9.9435d-2*t14*t32*t33)+9.01234567901
     ?           2345d-2*t43*t50*t51*t75-8.776164184544301d-2*t31*t47-9.
     @           012345679012345d-2*t23*(-1.1249999999999999d-2*t32*t33-
     1           1.444144833638965d-3*t30)*t42-6.887544671719978d-3*t32*
     2           t33-5.475384977410482d-5*t30-7.215849209132282d-5*gamma
     3           bb*t29+1.4419753086419754d-1*t133*t23-1.802469135802469
     4           d-1*t133*t17)-1.014955234713769d-1*t2*t45*t91+3.1058543
     5           9734574d-3*t44*t79*t8-1.6564556785843942d-2*gammabb*t30
     6           *t52*t79-1.6564556785843942d-2*t24*t30*t79+2.7065472925
     7           700507d-1*t31*t45*t52+6.758538015443329d-4*gammabb*t129
     8           *t24*t29)-9.975235893662349d-1*t100*t27)+t84*(-2*t53*t9
     9           3+1.4962853840493523d+0*t1*t53*t92+1.4962853840493523d+
     :           0*t1*t100*t46)-4.488856152148057d+0*t1*t101*t130*t46)*w
     ;           ght+Cmat3(iq,D3_RB_GBB_GBB)
              Cmat3(iq,D3_GBB_GBB_GBB) = -7.481426920246762d-1*t1*t28*(-
     1           1.5224328520706534d-1*t2*t45*t99+1.2437810945273631d+0*
     2           t4*(1.3518518518518516d-1*t23*t51*t75*t98-2.70370370370
     3           3703d-1*t42*t50*t98+1.3518518518518516d-1*t50*t75*t97-2
     4           .703703703703703d-1*t42*t51*t96+4.3259259259259264d-1*t
     5           50*t96+4.9365923538061696d-2*t2*t94+1.6455307846020564d
     6           -2*gammabb*t2*(2.913134765625d-4*t113*t5*t65*t67+1.0195
     7           971679687499d-3*t32*t36*t54*t67-1.86440625d-2*gammabb*t
     8           35*t63*t66-1.8207092285156248d-5*t123*t124*t32*t54)+9.0
     9           19811511415352d-6*t6-6.759259259259258d-2*t128*t23*t51*
     :           *3+1.4419753086419754d-1*t134*t23-1.802469135802469d-1*
     ;           t134*t17)+9.317563192037218d-3*t52*t79*t8-2.53445175579
     <           1249d-4*t129*t24*t6)*wght+4.488856152148057d+0*t1*t100*
     =           t53*t84*wght-4.488856152148057d+0*t1*t130*t53**3*wght+C
     >           mat3(iq,D3_GBB_GBB_GBB)
              Mmat3(iq,D3_RB_RB_TA) = Mmat3(iq,D3_RB_RB_TA)
              Mmat3(iq,D3_RB_RB_TB) = (t28*(-7.481426920246762d-1*t1*(1.
     1           2437810945273631d+0*t4*(1.6455307846020564d-2*gammabb*t
     2           2*(-1.0195971679687499d-3*t36*t5*t66*t67*t86+1.82070922
     3           85156248d-5*t123*t124*t5*t66*t86-5.82626953125d-4*t54*t
     4           63*t67*t68*t7+1.86440625d-2*t12*t35*t54*t63*t7-2.98305d
     5           -1*t14*t54*t63*t7-2.913134765625d-4*t121*t135*t6*t67+3.
     6           10734375d-2*t102*t35*t64*t65+3.10734375d-3*gammabb*t32*
     7           t33*t35*t36)-2.5347222222222215d-4*t23*t34*t54*t7*t75*t
     8           77-9.012345679012345d-2*t42*t58*t77+4.5061728395061723d
     9           -2*t58*t75*t76+3.802083333333333d-4*t128*t23*t34*t54*t7
     :           *t76-5.069444444444443d-4*t34*t41*t43*t54*t7*t75+1.0138
     ;           888888888886d-3*t23*t32*t43*t54*t7*t75+5.06944444444444
     <           3d-4*t34*t42*t54*t7*t74+1.4419753086419754d-1*t58*t74+3
     =           .0416666666666664d-3*t23*t42*t54*t63*t7-2.0662634015159
     >           936d-2*t54*t63*t7-2.0277777777777772d-3*t32*t41*t42*t54
     ?           *t7+1.6089634338331218d-1*gammabb*t55*t62-1.80246913580
     @           2469d-1*t105*t42*t43+2.883950617283951d-1*t105*t41-8.77
     1           6164184544301d-2*gammabb*t103*t31+1.4419753086419754d-1
     2           *t136*t23-1.802469135802469d-1*t136*t17)+2.208607571445
     3           859d-2*t59*t61*t7*t79-4.9620033697117594d-1*gammabb*t45
     4           *t59*t62+2.7065472925700507d-1*gammabb*t106*t31*t45)-1.
     5           9950471787324697d+0*t107*t27)-5.583154418094598d+0*t1*t
     6           130*t4*t59*t85-2.4875621890547261d+0*t4*t59*t81*t84+2.9
     7           925707680987046d+0*t1*t107*t46*t84-4.1356699393293317d-
     8           1*t28*t4*t59*t82)*wght+Mmat3(iq,D3_RB_RB_TB)
              Mmat3(iq,D3_RB_GBB_TA) = Mmat3(iq,D3_RB_GBB_TA)
              Mmat3(iq,D3_RB_GBB_TB) = (-2.4875621890547261d+0*t4*t59*t8
     1           4*t93+t28*(-7.481426920246762d-1*t1*(1.2437810945273631
     2           d+0*t4*(-2.5347222222222215d-4*t23*t34*t54*t7*t75*t90-9
     3           .012345679012345d-2*t42*t58*t90+5.069444444444443d-4*t3
     4           4*t42*t54*t7*t89+1.4419753086419754d-1*t58*t89+1.645530
     5           7846020564d-2*gammabb*t2*(-2.796609375d-2*t102*t35*t5*t
     6           86+1.0195971679687499d-3*t36*t63*t66*t67*t7-1.820709228
     7           5156248d-5*t123*t124*t63*t66*t7+4.369702148437499d-4*ga
     8           mmabb*t32*t54*t67*t68+2.913134765625d-4*t122*t131*t135*
     9           t67-1.3983046875d-2*gammabb*t12*t32*t35*t54+1.9887d-1*g
     :           ammabb*t14*t32*t54-1.553671875d-3*t33*t34*t35*t36)-2.53
     ;           47222222222215d-4*t34*t41*t51*t54*t7*t75+5.069444444444
     <           443d-4*t23*t32*t51*t54*t7*t75-2.5347222222222215d-4*t34
     =           *t43*t50*t54*t7*t75+4.5061728395061723d-2*t43*t51*t58*t
     >           75-5.069444444444443d-4*gammabb*t23*t34*t43*t54*t75+3.8
     ?           02083333333333d-4*t128*t23*t34*t43*t51*t54*t7-1.0138888
     @           888888886d-3*t32*t42*t50*t54*t7-4.3880820922721503d-2*t
     1           31*t55+1.0138888888888886d-3*gammabb*t34*t41*t42*t54-2.
     2           0277777777777772d-3*gammabb*t23*t32*t42*t54+1.377508934
     3           3439956d-2*gammabb*t32*t54-9.012345679012345d-2*t105*t4
     4           2*t51+1.4419753086419754d-1*t105*t50-9.012345679012345d
     5           -2*t109*t42*t43+1.4419753086419754d-1*t109*t41-4.388082
     6           0922721503d-2*gammabb*t108*t31+1.4419753086419754d-1*t1
     7           37*t23+1.6455307846020564d-2*t103*t2-1.802469135802469d
     8           -1*t137*t17)-8.282278392921971d-3*gammabb*t30*t59*t79+1
     9           .3532736462850253d-1*t31*t45*t59+1.3532736462850253d-1*
     :           gammabb*t110*t31*t45-5.074776173568845d-2*t106*t2*t45)-
     ;           9.975235893662349d-1*t111*t27)+(1.4962853840493523d+0*t
     <           1*t107*t53+1.4962853840493523d+0*t1*t111*t46)*t84-5.583
     =           154418094598d+0*t1*t130*t4*t46*t53*t59)*wght+Mmat3(iq,D
     >           3_RB_GBB_TB)
              Mmat3(iq,D3_GBB_GBB_TA) = Mmat3(iq,D3_GBB_GBB_TA)
              Mmat3(iq,D3_GBB_GBB_TB) = -7.481426920246762d-1*t1*t28*(1.
     1           2437810945273631d+0*t4*(-2.5347222222222215d-4*t23*t34*
     2           t54*t7*t75*t98-9.012345679012345d-2*t42*t58*t98+4.50617
     3           28395061723d-2*t58*t75*t97+3.802083333333333d-4*t128*t2
     4           3*t34*t54*t7*t97+5.069444444444443d-4*t34*t42*t54*t7*t9
     5           6+1.4419753086419754d-1*t58*t96-5.069444444444443d-4*t3
     6           4*t50*t51*t54*t7*t75-1.0138888888888886d-3*gammabb*t23*
     7           t34*t51*t54*t75+1.6455307846020564d-2*gammabb*t2*(2.485
     8           875d-2*t102*t35*t63*t7-2.913134765625d-4*t34*t54*t67*t6
     9           8-1.0195971679687499d-3*gammabb*t32*t36*t66*t67-2.91313
     :           4765625d-4*t135*t64*t65*t67+1.8207092285156248d-5*gamma
     ;           bb*t123*t124*t32*t66+9.322031249999999d-3*t12*t34*t35*t
     <           54-9.9435d-2*t14*t34*t54)+2.0277777777777772d-3*gammabb
     =           *t34*t42*t50*t54+1.0138888888888886d-3*t23*t34*t42*t54-
     >           6.887544671719978d-3*t34*t54-1.802469135802469d-1*t109*
     ?           t42*t51+2.883950617283951d-1*t109*t50+1.441975308641975
     @           4d-1*t138*t23+3.291061569204113d-2*t108*t2-1.8024691358
     1           02469d-1*t138*t17)+3.10585439734574d-3*t59*t79*t8-1.014
     2           955234713769d-1*t110*t2*t45)*wght+1.8610514726981991d+0
     3           *t1*t100*t4*t59*t84*wght+2.9925707680987046d+0*t1*t111*
     4           t53*t84*wght-5.583154418094598d+0*t1*t101*t130*t4*t59*w
     5           ght+Mmat3(iq,D3_GBB_GBB_TB)
              Mmat3(iq,D3_RB_TA_TA) = Mmat3(iq,D3_RB_TA_TA)
              Mmat3(iq,D3_RB_TA_TB) = Mmat3(iq,D3_RB_TA_TB)
              Mmat3(iq,D3_RB_TB_TB) = (-7.481426920246762d-1*t1*t28*(1.2
     1           437810945273631d+0*t4*(1.6455307846020564d-2*gammabb*t2
     2           *(3.10734375d-2*t113*t35*t64*t86-5.82626953125d-4*t32*t
     3           66*t67*t68*t7+1.86440625d-2*t12*t32*t35*t66*t7-2.98305d
     4           -1*t14*t32*t66*t7-1.0195971679687499d-3*t102*t36*t5*t63
     5           *t67-2.913134765625d-4*t121*t122*t139*t67+1.82070922851
     6           56248d-5*t102*t123*t124*t5*t63+3.10734375d-3*gammabb*t3
     7           4*t35*t36*t54)-5.703124999999998d-6*t113*t23*t64*t75*t8
     8           6+7.604166666666664d-4*t23*t34*t43*t66*t7*t75-5.0694444
     9           44444443d-4*t34*t43*t54*t58*t7*t75+1.4257812499999994d-
     :           6*t113*t41*t63*t64*t75-1.520833333333333d-3*t34*t41*t42
     ;           *t66*t7+3.041666666666666d-3*t23*t32*t42*t66*t7-2.06626
     <           34015159936d-2*t32*t66*t7-2.0277777777777772d-3*t32*t42
     =           *t54*t58*t7+1.0138888888888886d-3*t105*t34*t42*t54*t7-2
     >           .1386718749999997d-6*t113*t128*t23*t43*t63*t64+2.883950
     ?           617283951d-1*t105*t58-9.012345679012345d-2*t116*t42*t43
     @           +1.4419753086419754d-1*t116*t41-4.3880820922721503d-2*g
     1           ammabb*t114*t31+1.4419753086419754d-1*t140*t23-1.802469
     2           135802469d-1*t140*t17)+1.3532736462850253d-1*gammabb*t1
     3           17*t31*t45)+3.0863208502457695d+0*t112*t27*t79*t84+t4*(
     4           3.7221029453963983d+0*t1*t107*t59+1.8610514726981991d+0
     5           *t1*t117*t46)*t84-6.944221913052981d+0*t1*t112*t130*t46
     6           *t79-1.2407009817987995d+0*t117*t27*t28*t4)*wght+Mmat3(
     7           iq,D3_RB_TB_TB)
              Mmat3(iq,D3_GBB_TA_TA) = Mmat3(iq,D3_GBB_TA_TA)
              Mmat3(iq,D3_GBB_TA_TB) = Mmat3(iq,D3_GBB_TA_TB)
              Mmat3(iq,D3_GBB_TB_TB) = t4*t84*(3.7221029453963983d+0*t1*
     1           t111*t59*wght+1.8610514726981991d+0*t1*t117*t53*wght)-7
     2           .481426920246762d-1*t1*t28*(1.2437810945273631d+0*t4*(1
     3           .6455307846020564d-2*gammabb*t2*(-3.10734375d-3*t35*t36
     4           *t54*t9+1.0195971679687499d-3*t102*t32*t36*t67*t7-1.820
     5           7092285156248d-5*t102*t123*t124*t32*t7+5.82626953125d-4
     6           *gammabb*t34*t66*t67*t68+2.913134765625d-4*t131*t139*t6
     7           5*t67-1.86440625d-2*gammabb*t12*t34*t35*t66+2.98305d-1*
     8           gammabb*t14*t34*t66-3.10734375d-2*t113*t35*t5*t63)+7.60
     9           4166666666664d-4*t23*t34*t51*t66*t7*t75-5.0694444444444
     :           43d-4*t34*t51*t54*t58*t7*t75+1.4257812499999994d-6*t113
     ;           *t50*t63*t64*t75+5.703124999999998d-6*t113*t23*t5*t63*t
     <           75-1.520833333333333d-3*t34*t42*t50*t66*t7+1.0138888888
     =           888886d-3*t109*t34*t42*t54*t7-3.041666666666666d-3*gamm
     >           abb*t23*t34*t42*t66+2.0662634015159936d-2*gammabb*t34*t
     ?           66-2.1386718749999997d-6*t113*t128*t23*t51*t63*t64+2.02
     @           77777777777772d-3*gammabb*t34*t42*t54*t58+2.88395061728
     1           3951d-1*t109*t58-9.012345679012345d-2*t116*t42*t51+1.44
     2           19753086419754d-1*t116*t50+1.4419753086419754d-1*t141*t
     3           23+1.6455307846020564d-2*t114*t2-1.802469135802469d-1*t
     4           141*t17)-5.074776173568845d-2*t117*t2*t45)*wght-6.94422
     5           1913052981d+0*t1*t112*t130*t53*t79*wght+Mmat3(iq,D3_GBB
     6           _TB_TB)
              Mmat3(iq,D3_TA_TA_TA) = Mmat3(iq,D3_TA_TA_TA)
              Mmat3(iq,D3_TA_TA_TB) = Mmat3(iq,D3_TA_TA_TB)
              Mmat3(iq,D3_TA_TB_TB) = Mmat3(iq,D3_TA_TB_TB)
              Mmat3(iq,D3_TB_TB_TB) = -9.305257363490997d-1*t1*t28*t4*(1
     1           .6455307846020564d-2*gammabb*t2*(9.322031249999999d-3*g
     2           ammabb*t35*t36*t66*t9-8.739404296874999d-4*t102*t34*t67
     3           *t68*t7+2.796609375d-2*t102*t12*t34*t35*t7-5.9661d-1*t1
     4           02*t14*t34*t7-2.913134765625d-4*t121*t142*t65*t67-1.019
     5           5971679687499d-3*t113*t32*t36*t5*t67+3.7288125d-2*t135*
     6           t35*t63*t64+1.8207092285156248d-5*t113*t123*t124*t32*t5
     7           )+4.2773437499999983d-6*t113*t58*t63*t64*t75-1.28320312
     8           49999995d-5*t135*t23*t63*t64*t75-4.562499999999999d-3*t
     9           34*t42*t58*t66*t7+1.520833333333333d-3*t116*t34*t42*t54
     :           *t7+6.083333333333332d-3*t102*t23*t34*t42*t7-4.13252680
     ;           3031987d-2*t102*t34*t7+1.2030029296874996d-8*t121*t128*
     <           t142*t23*t65+4.3259259259259264d-1*t116*t58+1.441975308
     =           6419754d-1*t143*t23-1.802469135802469d-1*t143*t17)*wght
     >           +6.944221913052984d+0*t1*t117*t59*t79*t84*wght-8.637091
     ?           931657939d+0*t1*t130*t59**3*wght/t3**6.0d+0+Mmat3(iq,D3
     @           _TB_TB_TB)
            else 
              t1 = rhob**1.3333333333333333d+0
              t2 = 1/rhob**1.6666666666666669d+0
              t3 = 1.0970205230680374d-51*t2-1.0d+0
              t4 = 4.3880820922721503d-52*t2*t3+1.0d+0
              t5 = 1/t4**5.0d-1
              t6 = 4.5d-1*t3*t5+4.3880820922721503d-52*t2
              t7 = 1/rhob**3.3333333333333337d+0
              t8 = 2.166217250458448d-103*t7+4.4999999999999996d-2
              t9 = t8**5.0d-1
              t10 = -1.802469135802469d-1*t6*t9+8.213077466115726d-105*t
     1           7+7.209876543209877d-2*t6**2+2.4881109353903252d-52*t2+
     2           9.621132278843042d-155/rhob**5+2.755017868687991d-2
              t11 = 8.160240087098705d-52*t2+1.0d+0
              t12 = 1/t11**2.0d+0
              t13 = 1.2437810945273631d+0*t10*t12+1.0d+0
              t14 = 8.04d-1-8.04d-1/t13
              t15 = rhob**3.333333333333333d-1
              t16 = 1/t13**2
              t17 = 1/rhob**4.333333333333333d+0
              t18 = 1/t9
              t19 = 1/rhob**2.6666666666666666d+0
              t20 = -7.313470153786917d-52*t19*t3-8.023026853549804d-103
     1           *t17
              t21 = 1/t4**1.5d+0
              t22 = -8.227653923010281d-52*t19*t5-2.25d-1*t20*t21*t3-7.3
     1           13470153786917d-52*t19
              t23 = -1.802469135802469d-1*t22*t9+1.4419753086419754d-1*t
     1           22*t6+6.507566225657065d-104*t17*t18*t6-4.1468515589838
     2           76d-52*t19-2.737692488705242d-104*t17-4.810566139421521
     3           d-154/rhob**6
              t24 = 1/t11**3.0d+0
              t25 = 3.3831841157125636d-51*t10*t19*t24+1.243781094527363
     1           1d+0*t12*t23
              t26 = -4.1356699393293317d-1*t14-4.1356699393293317d-1
              t27 = 1/rhob**6.666666666666666d-1
              t28 = 1/t13**3
              t29 = t25**2
              t30 = 1/t8**1.5d+0
              t31 = 1/rhob**8.666666666666666d+0
              t32 = 1/rhob**5.333333333333333d+0
              t33 = 1/rhob**3.6666666666666664d+0
              t34 = t20**2
              t35 = 1/t4**2.5d+0
              t36 = 1.9502587076765113d-51*t3*t33+4.8138161121298817d-10
     1           2*t32
              t37 = 2.194041046136075d-51*t33*t5-2.25d-1*t21*t3*t36+3.37
     1           5d-1*t3*t34*t35+1.9502587076765113d-51*t33+8.2276539230
     2           10281d-52*t19*t20*t21
              t38 = -1.802469135802469d-1*t37*t9+1.4419753086419754d-1*t
     1           37*t6-2.8199453644513944d-103*t18*t32*t6+2.349467036086
     2           518d-206*t30*t31*t6+1.1058270823957002d-51*t33+1.186333
     3           4117722714d-103*t32+1.4419753086419754d-1*t22**2+1.3015
     4           13245131413d-103*t17*t18*t22+2.886339683652913d-153/rho
     5           b**7
              t39 = 1/t11**4.0d+0
              t40 = 1.3803797321536623d-101*t10*t32*t39+1.24378109452736
     1           31d+0*t12*t38-9.021824308566837d-51*t10*t24*t33+6.76636
     2           8231425127d-51*t19*t23*t24
              t41 = -7.481426920246762d-1*t1*t40-1.9950471787324697d+0*t
     1           15*t25
              t42 = 1/rhob**8
              t43 = 1/rhob**6.333333333333333d+0
              t44 = 1/rhob**4.666666666666667d+0
              t45 = -8.044817169165608d-51*t44*t5-2.25d-1*t21*t3*(-7.150
     1           948594813874d-51*t3*t44-2.9239475644048174d-101*t43)-7.
     2           150948594813874d-51*t44-8.4375d-1*t20**3*t3/t4**3.5d+0+
     3           1.0125000000000002d+0*t20*t3*t35*t36+1.2341480884515423
     4           d-51*t19*t21*t36-1.8512221326773132d-51*t19*t34*t35-3.2
     5           910615692041123d-51*t20*t21*t33
              fnc(iq) = (-9.305257363490997d-1*t1*t14-9.305257363490997d
     1           -1*t1)*wght+fnc(iq)
              Amat(iq,D1_RB) = (-7.481426920246762d-1*t1*t16*t25-1.24070
     1           09817987995d+0*t14*t15-1.2407009817987995d+0*t15)*wght+
     2           Amat(iq,D1_RB)
              Cmat(iq,D1_GBB) = Cmat(iq,D1_GBB)
              Mmat(iq,D1_TB) = Mmat(iq,D1_TB)
              Mmat(iq,D1_TA) = Mmat(iq,D1_TA)
              Amat2(iq,D2_RB_RB) = (t16*t41+1.4962853840493523d+0*t1*t28
     1           *t29+t26*t27)*wght+Amat2(iq,D2_RB_RB)
              Cmat2(iq,D2_RB_GBB) = Cmat2(iq,D2_RB_GBB)
              Cmat2(iq,D2_GBB_GBB) = Cmat2(iq,D2_GBB_GBB)
              Mmat2(iq,D2_RB_TA) = Mmat2(iq,D2_RB_TA)
              Mmat2(iq,D2_RB_TB) = Mmat2(iq,D2_RB_TB)
              Mmat2(iq,D2_GBB_TA) = Mmat2(iq,D2_GBB_TA)
              Mmat2(iq,D2_GBB_TB) = Mmat2(iq,D2_GBB_TB)
              Mmat2(iq,D2_TA_TA) = Mmat2(iq,D2_TA_TA)
              Mmat2(iq,D2_TA_TB) = Mmat2(iq,D2_TA_TB)
              Mmat2(iq,D2_TB_TB) = Mmat2(iq,D2_TB_TB)
              Amat3(iq,D3_RB_RB_RB) = (t16*(-7.481426920246762d-1*t1*(1.
     1           2437810945273631d+0*t12*(-1.802469135802469d-1*t45*t9+2
     2           .544728011477048d-308*t6/(rhob**13*t8**2.5d+0)+1.441975
     3           3086419754d-1*t45*t6+1.5039708610407437d-102*t18*t43*t6
     4           -3.054307146912473d-205*t30*t6/rhob**9.666666666666666d
     5           +0-4.054699302117567d-51*t44-6.327111529452114d-103*t43
     6           -2.020437778557039d-152*t42+4.3259259259259264d-1*t22*t
     7           37+1.9522698676971195d-103*t17*t18*t37-8.45983609335418
     8           4d-103*t18*t22*t32+7.048401108259554d-206*t22*t30*t31)+
     9           3.308002246474507d-50*t10*t24*t44-1.1043037857229297d-1
     :           00*t10*t39*t43+7.509486683825926d-152*t10*t42/t11**5.0d
     ;           +0+4.1411391964609867d-101*t23*t32*t39+1.01495523471376
     <           91d-50*t19*t24*t38-2.706547292570051d-50*t23*t24*t33)-2
     =           .9925707680987046d+0*t15*t40-6.650157262441565d-1*t25*t
     >           27)+t28*(-2*t25*t41+2.9925707680987046d+0*t1*t25*t40+1.
     ?           9950471787324697d+0*t15*t29)-3.325078631220783d-1*t16*t
     @           25*t27-6.666666666666666d-1*t2*t26-4.488856152148057d+0
     1           *t1*t25**3/t13**4)*wght+Amat3(iq,D3_RB_RB_RB)
              Cmat3(iq,D3_RB_RB_GBB) = Cmat3(iq,D3_RB_RB_GBB)
              Cmat3(iq,D3_RB_GBB_GBB) = Cmat3(iq,D3_RB_GBB_GBB)
              Cmat3(iq,D3_GBB_GBB_GBB) = Cmat3(iq,D3_GBB_GBB_GBB)
              Mmat3(iq,D3_RB_RB_TA) = Mmat3(iq,D3_RB_RB_TA)
              Mmat3(iq,D3_RB_RB_TB) = Mmat3(iq,D3_RB_RB_TB)
              Mmat3(iq,D3_RB_GBB_TA) = Mmat3(iq,D3_RB_GBB_TA)
              Mmat3(iq,D3_RB_GBB_TB) = Mmat3(iq,D3_RB_GBB_TB)
              Mmat3(iq,D3_GBB_GBB_TA) = Mmat3(iq,D3_GBB_GBB_TA)
              Mmat3(iq,D3_GBB_GBB_TB) = Mmat3(iq,D3_GBB_GBB_TB)
              Mmat3(iq,D3_RB_TA_TA) = Mmat3(iq,D3_RB_TA_TA)
              Mmat3(iq,D3_RB_TA_TB) = Mmat3(iq,D3_RB_TA_TB)
              Mmat3(iq,D3_RB_TB_TB) = Mmat3(iq,D3_RB_TB_TB)
              Mmat3(iq,D3_GBB_TA_TA) = Mmat3(iq,D3_GBB_TA_TA)
              Mmat3(iq,D3_GBB_TA_TB) = Mmat3(iq,D3_GBB_TA_TB)
              Mmat3(iq,D3_GBB_TB_TB) = Mmat3(iq,D3_GBB_TB_TB)
              Mmat3(iq,D3_TA_TA_TA) = Mmat3(iq,D3_TA_TA_TA)
              Mmat3(iq,D3_TA_TA_TB) = Mmat3(iq,D3_TA_TA_TB)
              Mmat3(iq,D3_TA_TB_TB) = Mmat3(iq,D3_TA_TB_TB)
              Mmat3(iq,D3_TB_TB_TB) = Mmat3(iq,D3_TB_TB_TB)
            endif 
          endif ! rhoa.gt.tol_rho.and.rhob.gt.tol_rho 
        endif ! ipol.eq.1 
      enddo ! iq 
      end 
C> @} 
