import pathlib
import unittest

from shelxfile import Shelxfile
from shelxfile.cif.cif_write import CifFile

result_p21c = {'data_name'        : 'p21c',
               'version'          : '',
               'creation_date'    : '',
               'sum_formula'      : 'C0.25 H0.5 O0.75 F1 AL1.25 GA1.5',
               'formula_weight'   : 172.816,
               'cell_a'           : 10.5086,
               'cell_b'           : 20.9035,
               'cell_c'           : 20.5072,
               'cell_alpha'       : 90.0,
               'cell_beta'        : 94.13,
               'cell_gamma'       : 90.0,
               'cell_volume'      : 4493.0474,
               'cell_z'           : 4.0,
               'space_group'      : 'P2(1)/c',
               'symmetry_loop'    : " '+x, +y, +z'\n '-x, -y, -z'\n '-x, 1/2+y, 1/2-z'\n '+x, -1/2-y, -1/2+z'",
               'atom_loop_header' : 'loop_\n _atom_site_label\n _atom_site_type_symbol\n _atom_site_fract_x\n _atom_site_fract_y\n _atom_site_fract_z\n _atom_site_adp_type\n _atom_site_occupancy\n _atom_site_disorder_group',
               'atom_loop'        : 'O1_4 O 0.074835 0.238436 0.402457 Uani 0.44236 2\nC1_4 C 0.028576 0.234542 0.337234 Uani 0.44236 2\nC2_4 C 0.12154 0.19446 0.298291 Uani 0.44236 2\nF1_4 F 0.2419 0.211233 0.314197 Uani 0.44236 2\nF2_4 F 0.098797 0.200975 0.23421 Uani 0.44236 2\nF3_4 F 0.112375 0.132048 0.31138 Uani 0.44236 2\nC3_4 C -0.103502 0.202241 0.332346 Uani 0.44236 2\nF4_4 F -0.194239 0.242467 0.347077 Uani 0.44236 2\nF5_4 F -0.106378 0.152755 0.373514 Uani 0.44236 2\nF6_4 F -0.132107 0.178669 0.272635 Uani 0.44236 2\nC4_4 C 0.018702 0.302508 0.307595 Uani 0.44236 2\nF7_4 F -0.033689 0.340543 0.350061 Uani 0.44236 2\nF8_4 F -0.057354 0.300876 0.252663 Uani 0.44236 2\nF9_4 F 0.130286 0.325479 0.293388 Uani 0.44236 2\nGA1 Ga 0.639514 0.561736 0.237758 Uani 1.0 0\nAL1 Al 0.06428 0.26019 0.478723 Uani 1.0 0\nO1 O 0.120468 0.33657 0.494134 Uani 1.0 0\nO2 O -0.097347 0.260917 0.489316 Uani 1.0 0\nF10 F -0.362557 0.278255 0.447769 Uani 1.0 0\nF11 F -0.404368 0.257817 0.547035 Uani 1.0 0\nF12 F -0.301423 0.189573 0.492527 Uani 1.0 0\nF13 F -0.175185 0.202425 0.610083 Uani 1.0 0\nF14 F -0.031515 0.275544 0.61664 Uani 1.0 0\nF15 F -0.222344 0.297022 0.641449 Uani 1.0 0\nF16 F -0.313279 0.377295 0.540567 Uani 1.0 0\nF17 F -0.189445 0.376059 0.461252 Uani 1.0 0\nF18 F -0.110397 0.386665 0.560069 Uani 1.0 0\nC5 C -0.18732 0.282849 0.527509 Uani 1.0 0\nC6 C -0.315961 0.251666 0.503981 Uani 1.0 0\nC7 C -0.154317 0.264427 0.600368 Uani 1.0 0\nC8 C -0.201067 0.356753 0.522179 Uani 1.0 0\nC1 C 0.223141 0.375178 0.503818 Uani 1.0 0\nC2 C 0.32578 0.359141 0.456111 Uani 1.0 0\nF1 F 0.290691 0.379726 0.395764 Uani 1.0 0\nF2 F 0.342782 0.296341 0.451995 Uani 1.0 0\nF3 F 0.439101 0.385304 0.473512 Uani 1.0 0\nC3 C 0.178857 0.445109 0.492599 Uani 1.0 0\nF4 F 0.100281 0.449627 0.439087 Uani 1.0 0\nF5 F 0.116027 0.466251 0.542724 Uani 1.0 0\nF6 F 0.27615 0.485252 0.485742 Uani 1.0 0\nC4 C 0.282165 0.368631 0.575532 Uani 1.0 0\nF7 F 0.358325 0.417829 0.593767 Uani 1.0 0\nF8 F 0.351893 0.315205 0.582802 Uani 1.0 0\nF9 F 0.192067 0.365522 0.617269 Uani 1.0 0\nC34 C 0.369705 0.548727 0.213197 Uani 1.0 0\nH34 H 0.340371 0.506496 0.203858 Uiso 1.0 0\nC33 C 0.38057 0.569531 0.277905 Uani 1.0 0\nC32 C 0.425169 0.631358 0.290541 Uani 1.0 0\nH32 H 0.435581 0.645812 0.334521 Uiso 1.0 0\nC35 C 0.400682 0.588146 0.161619 Uani 1.0 0\nC30 C 0.443761 0.649857 0.176365 Uani 1.0 0\nH30 H 0.466096 0.677175 0.141971 Uiso 1.0 0\nC36 C 0.383703 0.565136 0.09208 Uani 1.0 0\nH36A H 0.29485 0.571445 0.075385 Uiso 1.0 0\nH36B H 0.405081 0.519563 0.090358 Uiso 1.0 0\nH36C H 0.440111 0.589402 0.065167 Uiso 1.0 0\nC31 C 0.454829 0.672447 0.240679 Uani 1.0 0\nC37 C 0.34115 0.52744 0.332522 Uani 1.0 0\nH37A H 0.409001 0.52687 0.3679 Uiso 1.0 0\nH37B H 0.326196 0.483861 0.316092 Uiso 1.0 0\nH37C H 0.262597 0.544192 0.349121 Uiso 1.0 0\nC38 C 0.494303 0.740496 0.25556 Uani 1.0 0\nH38A H 0.530222 0.759352 0.217171 Uiso 1.0 0\nH38B H 0.558658 0.741083 0.292597 Uiso 1.0 0\nH38C H 0.419702 0.765312 0.266591 Uiso 1.0 0\nC21 C 0.721945 0.447951 0.167553 Uani 1.0 0\nC20 C 0.838299 0.47476 0.190372 Uani 1.0 0\nH20 H 0.894192 0.490747 0.15981 Uiso 1.0 0\nC23 C 0.673436 0.429169 0.280515 Uani 1.0 0\nC25 C 0.87437 0.478621 0.256916 Uani 1.0 0\nC22 C 0.641003 0.425688 0.213103 Uani 1.0 0\nH22 H 0.561283 0.407559 0.198146 Uiso 1.0 0\nC28 C 0.685659 0.443539 0.095306 Uani 1.0 0\nH28A H 0.67227 0.486648 0.077319 Uiso 1.0 0\nH28B H 0.606834 0.418689 0.088044 Uiso 1.0 0\nH28C H 0.75426 0.422411 0.073537 Uiso 1.0 0\nC27 C 0.588439 0.401777 0.328925 Uani 1.0 0\nH27A H 0.582501 0.431808 0.365277 Uiso 1.0 0\nH27B H 0.62393 0.361114 0.345619 Uiso 1.0 0\nH27C H 0.503219 0.394469 0.307585 Uiso 1.0 0\nC24 C 0.790626 0.456427 0.301107 Uani 1.0 0\nH24 H 0.813754 0.459897 0.346612 Uiso 1.0 0\nC26 C 1.002704 0.505424 0.281377 Uani 1.0 0\nH26A H 1.045619 0.523155 0.244543 Uiso 1.0 0\nH26B H 1.05514 0.471226 0.302028 Uiso 1.0 0\nH26C H 0.99052 0.539262 0.313413 Uiso 1.0 0\nO1_1 O 0.157034 0.209303 0.526987 Uani 0.48096 1\nC1_1 C 0.198924 0.149501 0.543934 Uani 0.48096 1\nC2_1 C 0.283495 0.12482 0.490346 Uani 0.48096 1\nF1_1 F 0.356079 0.075059 0.51066 Uani 0.48096 1\nF2_1 F 0.359587 0.170574 0.471352 Uani 0.48096 1\nF3_1 F 0.21219 0.104131 0.438109 Uani 0.48096 1\nC3_1 C 0.086376 0.103363 0.549724 Uani 0.48096 1\nF4_1 F 0.116692 0.041286 0.547341 Uani 0.48096 1\nF5_1 F -0.004988 0.114179 0.502041 Uani 0.48096 1\nF6_1 F 0.032538 0.113014 0.606758 Uani 0.48096 1\nC4_1 C 0.280608 0.152857 0.609877 Uani 0.48096 1\nF7_1 F 0.222275 0.187998 0.652487 Uani 0.48096 1\nF8_1 F 0.29825 0.09445 0.636824 Uani 0.48096 1\nF9_1 F 0.394933 0.177213 0.602431 Uani 0.48096 1\nO1_2 O 0.142141 0.207281 0.533641 Uani 0.51904 2\nC1_2 C 0.182648 0.146456 0.545549 Uani 0.51904 2\nC2_2 C 0.192984 0.140449 0.621265 Uani 0.51904 2\nF1_2 F 0.245205 0.192674 0.649231 Uani 0.51904 2\nF2_2 F 0.264027 0.090306 0.642441 Uani 0.51904 2\nF3_2 F 0.078582 0.13192 0.643529 Uani 0.51904 2\nC3_2 C 0.091542 0.095062 0.515334 Uani 0.51904 2\nF4_2 F 0.107933 0.08547 0.452542 Uani 0.51904 2\nF5_2 F -0.029902 0.112024 0.51991 Uani 0.51904 2\nF6_2 F 0.109352 0.0391 0.546088 Uani 0.51904 2\nC4_2 C 0.316387 0.137078 0.519902 Uani 0.51904 2\nF7_2 F 0.319119 0.157467 0.458245 Uani 0.51904 2\nF8_2 F 0.353688 0.075732 0.521565 Uani 0.51904 2\nF9_2 F 0.405819 0.168092 0.556659 Uani 0.51904 2\nO1_3 O 0.087763 0.232808 0.398354 Uani 0.55764 1\nC1_3 C 0.03661 0.23157 0.33651 Uani 0.55764 1\nC2_3 C 0.150502 0.233262 0.294438 Uani 0.55764 1\nF1_3 F 0.122782 0.211275 0.232658 Uani 0.55764 1\nF2_3 F 0.246159 0.194445 0.319696 Uani 0.55764 1\nF3_3 F 0.196682 0.292032 0.290371 Uani 0.55764 1\nC3_3 C -0.052849 0.288661 0.318395 Uani 0.55764 1\nF4_3 F -0.005258 0.342945 0.34665 Uani 0.55764 1\nF5_3 F -0.067147 0.301053 0.253782 Uani 0.55764 1\nF6_3 F -0.169084 0.279883 0.339273 Uani 0.55764 1\nC4_3 C -0.039299 0.168627 0.325762 Uani 0.55764 1\nF7_3 F -0.114803 0.157982 0.372858 Uani 0.55764 1\nF8_3 F -0.112445 0.168653 0.268184 Uani 0.55764 1\nF9_3 F 0.04133 0.118693 0.324876 Uani 0.55764 1',
               'aniso_loop_header': 'loop_\n _atom_site_aniso_label\n _atom_site_aniso_U_11\n _atom_site_aniso_U_22\n _atom_site_aniso_U_33\n _atom_site_aniso_U_23\n _atom_site_aniso_U_13\n _atom_site_aniso_U_12',
               'aniso_loop'       : 'O1_4 0.01579 0.03095 0.01852 -0.00468 -0.0021 0.01153 \nC1_4 0.02311 0.03617 0.01096 -0.01 0.00201 0.00356 \nC2_4 0.0296 0.04586 0.01555 -0.00485 -0.00023 0.01102 \nF1_4 0.02029 0.06494 0.02841 -0.00285 0.00512 0.01642 \nF2_4 0.0399 0.07427 0.01638 -0.00978 0.00426 0.0151 \nF3_4 0.05736 0.03839 0.03444 -0.0058 0.00169 0.0189 \nC3_4 0.02864 0.0615 0.01464 -0.00621 -0.00347 -0.00667 \nF4_4 0.01934 0.08422 0.03135 -0.01447 -0.00634 0.00704 \nF5_4 0.05083 0.07303 0.05196 0.01867 -0.01209 -0.02261 \nF6_4 0.03544 0.08301 0.02571 -0.02102 -0.00635 -0.01918 \nC4_4 0.04608 0.04134 0.01911 -0.00021 -0.00914 0.00573 \nF7_4 0.06375 0.04441 0.03864 -0.00811 -0.01437 0.02588 \nF8_4 0.07921 0.07333 0.03022 0.00207 -0.02887 0.02608 \nF9_4 0.06204 0.04346 0.0354 0.00835 -0.0014 -0.01178 \nGA1 0.02411 0.02509 0.02492 1e-05 -0.00158 0.00159 \nAL1 0.01606 0.01976 0.01375 -4e-05 -0.00222 0.00123 \nO1 0.01597 0.02185 0.02314 -0.00117 -0.00224 -0.00158 \nO2 0.01699 0.02604 0.01664 -0.00417 0.00042 0.00073 \nF10 0.02264 0.04202 0.0273 0.00098 -0.01012 0.00187 \nF11 0.02061 0.04886 0.03559 -0.00164 0.00539 -0.00228 \nF12 0.02693 0.02714 0.04242 -0.004 -0.00182 -0.00533 \nF13 0.04034 0.04367 0.02847 0.01315 0.00119 0.00375 \nF14 0.02289 0.05767 0.02211 -0.00627 -0.00814 0.00752 \nF15 0.03254 0.06814 0.01963 -0.00711 0.00369 0.01577 \nF16 0.02355 0.03306 0.04461 -0.00662 -0.00018 0.00941 \nF17 0.04568 0.02832 0.03495 0.00596 0.00448 0.0019 \nF18 0.02682 0.03303 0.04593 -0.01526 -0.00145 -0.00434 \nC5 0.0175 0.02237 0.01766 -0.00027 -0.00199 0.00127 \nC6 0.02208 0.02832 0.02383 0.00048 0.0009 0.00066 \nC7 0.02017 0.0375 0.02244 -0.00181 -0.00026 0.00595 \nC8 0.02167 0.02902 0.02941 -0.00589 0.00037 0.00036 \nC1 0.01566 0.02218 0.02107 0.00104 -0.00348 -0.00053 \nC2 0.02157 0.02862 0.03027 -0.00071 -0.00038 -0.00059 \nF1 0.03935 0.04638 0.02531 0.002 0.00756 -0.00333 \nF2 0.0251 0.03091 0.04948 -0.00953 0.00443 0.00466 \nF3 0.01753 0.04352 0.05141 -0.00541 0.00373 -0.00643 \nC3 0.02224 0.02551 0.02731 0.00167 -0.00198 -0.00082 \nF4 0.03711 0.03268 0.03461 0.00785 -0.01233 0.00734 \nF5 0.0313 0.02827 0.039 -0.00871 0.00248 0.0037 \nF6 0.03305 0.02487 0.04651 0.0051 0.00086 -0.0068 \nC4 0.02737 0.02972 0.02611 0.00062 -0.00753 -0.00361 \nF7 0.03452 0.03946 0.03401 -0.00363 -0.01521 -0.00994 \nF8 0.03637 0.03413 0.04113 0.00793 -0.02042 0.00474 \nF9 0.04146 0.05393 0.02012 0.00219 2e-05 -0.00935 \nC34 0.01997 0.02249 0.03076 -0.00483 -0.00288 0.00111 \nC33 0.01595 0.03247 0.02434 0.00125 -0.00203 0.00419 \nC32 0.01542 0.03211 0.02656 -0.00928 -0.004 0.00558 \nC35 0.01783 0.02846 0.0223 -0.00167 -0.00586 0.00291 \nC30 0.02024 0.02432 0.02616 0.0045 -0.00253 0.00413 \nC36 0.0429 0.03599 0.02255 -0.0027 -0.00386 0.00018 \nC31 0.01654 0.02494 0.03573 -0.0043 -0.00382 0.00409 \nC37 0.02655 0.04346 0.02844 0.00164 0.00199 -0.0043 \nC38 0.03639 0.02792 0.04823 -0.00738 -0.00692 -0.00106 \nC21 0.02895 0.02285 0.0262 -0.00348 -0.00155 0.00708 \nC20 0.02345 0.03004 0.02891 0.00413 0.00469 0.00693 \nC23 0.03009 0.01943 0.02962 0.00333 0.00332 0.00506 \nC25 0.01974 0.02796 0.03492 0.00298 -0.00733 0.00372 \nC22 0.02678 0.02173 0.03419 -0.00073 -0.00335 0.00181 \nC28 0.05026 0.03684 0.02582 -0.00655 -0.00448 0.0029 \nC27 0.04256 0.04062 0.03932 0.0085 0.00633 -0.002 \nC24 0.03211 0.02719 0.02314 0.00019 -0.00474 0.00905 \nC26 0.02883 0.06245 0.05045 0.00721 -0.01299 -0.00249 \nO1_1 0.0229 0.01854 0.02024 -0.00272 0.00061 0.00702 \nC1_1 0.02042 0.01328 0.02551 0.00269 -0.00452 -0.00369 \nC2_1 0.04415 0.02527 0.0288 0.00167 -0.0004 0.00879 \nF1_1 0.0468 0.02795 0.02756 -0.00401 -0.00109 0.01257 \nF2_1 0.03966 0.03647 0.04562 0.00742 0.0186 0.01182 \nF3_1 0.07988 0.03917 0.02893 -0.01179 -0.02107 0.02432 \nC3_1 0.02202 0.03151 0.06369 0.01467 -0.00611 0.00072 \nF4_1 0.03274 0.02737 0.10682 0.02075 -0.00839 -0.00194 \nF5_1 0.03129 0.03553 0.09741 0.00895 -0.03336 -0.00876 \nF6_1 0.04067 0.05287 0.08384 0.03216 0.0307 0.00247 \nC4_1 0.03663 0.02719 0.02397 0.00616 -0.0071 0.00764 \nF7_1 0.06647 0.04863 0.01636 0.00446 -0.00456 0.02286 \nF8_1 0.04968 0.03156 0.02767 0.01224 -0.00834 0.0131 \nF9_1 0.02826 0.03939 0.04497 -0.00388 -0.0189 0.00193 \nO1_2 0.0229 0.0274 0.01053 0.0072 0.00036 0.00563 \nC1_2 0.01893 0.02594 0.02031 -0.00019 -0.00484 0.00936 \nC2_2 0.04315 0.02747 0.02385 0.00686 -0.00757 0.00126 \nF1_2 0.05143 0.03826 0.03193 -0.00579 -0.01865 -0.00485 \nF2_2 0.06073 0.0445 0.03972 0.0163 -0.0126 0.0146 \nF3_2 0.05691 0.04955 0.03374 0.0104 0.01881 0.00375 \nC3_2 0.0278 0.03105 0.03622 0.00015 -0.0042 0.00231 \nF4_2 0.05359 0.03858 0.03371 -0.01253 -0.00959 0.00645 \nF5_2 0.02234 0.04392 0.06318 -0.00456 -0.0058 -0.00361 \nF6_2 0.05363 0.02466 0.04643 -0.0016 -0.00624 -0.00337 \nC4_2 0.03116 0.02615 0.05093 0.00984 0.00709 0.00398 \nF7_2 0.04376 0.04441 0.04485 0.0168 0.01959 0.0134 \nF8_2 0.02966 0.03601 0.05482 0.01221 0.00815 0.02092 \nF9_2 0.02247 0.03769 0.0907 0.00429 -0.00681 -0.00325 \nO1_3 0.01707 0.02924 0.00692 -0.00661 0.00156 0.00658 \nC1_3 0.01434 0.02998 0.01797 0.00134 -0.00911 0.00584 \nC2_3 0.03946 0.03987 0.01789 -0.004 -0.00262 0.00844 \nF1_3 0.03961 0.06075 0.01181 -0.00492 0.00173 0.00327 \nF2_3 0.02778 0.05311 0.02912 -0.00355 -0.00327 0.01729 \nF3_3 0.04403 0.04759 0.02854 0.00203 0.00562 -0.01235 \nC3_3 0.03382 0.0399 0.02033 -0.00385 -0.00609 0.01178 \nF4_3 0.04999 0.02714 0.02833 -0.00376 -0.01206 0.01276 \nF5_3 0.04179 0.0397 0.01625 0.0006 -0.00415 0.01292 \nF6_3 0.02378 0.06496 0.03144 1e-05 -0.00463 0.01704 \nC4_3 0.0327 0.04277 0.02352 -0.00208 -0.0114 -0.00496 \nF7_3 0.02849 0.05143 0.02641 -0.00326 0.00129 -0.01742 \nF8_3 0.0547 0.04945 0.02846 0.00086 -0.02237 -0.00846 \nF9_3 0.05446 0.03222 0.03789 -0.00744 -0.01048 0.00542 ',
               'temperature'      : 99.97,
               'crystal_size_max' : 0.33,
               'crystal_size_mid' : 0.23,
               'crystal_size_min' : 0.12,
               'wavelength'       : 0.71073,
               'R1'               : 0.04,
               'wR2'              : 0.1005,
               'goodness_of_fit'  : 1.016}


class MyTestCase(unittest.TestCase):
    def setUp(self):
        self.maxDiff = None
        self.shx = Shelxfile(debug=True)
        # shx.read_file('tests/resources/I-43d.res')

    def test_something(self):
        self.shx.read_file('./tests/resources/p21c.res')
        c = CifFile(self.shx)
        cif_dict = c._cif_dict()
        cif_dict['creation_date'] = ''
        cif_dict['version'] = ''
        self.assertDictEqual(result_p21c, cif_dict)


if __name__ == '__main__':
    unittest.main()
