"""Store room subject setter by nickname

Revision ID: 2b1f45ab7379
Revises: c4a8ec35a0e8
Create Date: 2024-07-20 00:14:36.882689

"""

from typing import Sequence, Union

import sqlalchemy as sa
from alembic import op

# revision identifiers, used by Alembic.
revision: str = "2b1f45ab7379"
down_revision: Union[str, None] = "c4a8ec35a0e8"
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("room", schema=None) as batch_op:
        batch_op.add_column(sa.Column("subject_setter", sa.String(), nullable=True))
        batch_op.drop_constraint("subject_setter_id_foreign_key", type_="foreignkey")
        batch_op.drop_column("subject_setter_id")
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("room", schema=None) as batch_op:
        batch_op.add_column(sa.Column("subject_setter_id", sa.INTEGER(), nullable=True))
        batch_op.create_foreign_key(
            "subject_setter_id_foreign_key",
            "participant",
            ["subject_setter_id"],
            ["id"],
        )
        batch_op.drop_column("subject_setter")
    # ### end Alembic commands ###
