if [ ! -s "./raw_graph_edges.txt" ] || [ ! -s "./raw_graph_vertices.txt" ]
then
	echo >&2 "Error: complete input graph not provided"
	exit 1
fi

R --vanilla < "./prepare_graph_input.R" > /dev/null

if [ ! -s "./graph_vertices.csv" ] || [ ! -s "./graph_edges.csv" ]
then
	echo >&2 "Error: failed to prepare graph input"
	exit 1
fi

python -B < "./run_gnn.py"

if [ ! -s "./raw_predictions.txt" ]
then
	echo >&2 "Error: failed to generate predictions"
	exit 1
fi

R --vanilla < "./prepare_results_output.R" > /dev/null

if [ ! -s "./results_detailed.txt" ] || [ ! -s "./results_summary.txt" ]
then
	echo >&2 "Error: failed to produce results"
	exit 1
fi
